#include "usart_gps.h"

void Usart2_Init(u32 baudrate)
{
	GPIO_InitTypeDef GPIO_InitStructure;
  USART_InitTypeDef USART_InitStructure; 

  RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOD,ENABLE);

  RCC_APB1PeriphClockCmd(RCC_APB1Periph_USART2,ENABLE);

  GPIO_PinAFConfig(GPIOD, GPIO_PinSource5, GPIO_AF_USART2);
  GPIO_PinAFConfig(GPIOD, GPIO_PinSource6, GPIO_AF_USART2);

  /*
  *  Open_USARTx_TX -> PD5 , Open_USARTx_RX -PD6
  */
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_5;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_UP;
  GPIO_Init(GPIOD, &GPIO_InitStructure);


  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_6;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_OD;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  GPIO_Init(GPIOD, &GPIO_InitStructure);

  USART_InitStructure.USART_BaudRate = baudrate;
  USART_InitStructure.USART_WordLength = USART_WordLength_8b;
  USART_InitStructure.USART_StopBits = USART_StopBits_1;
  USART_InitStructure.USART_Parity = USART_Parity_No;
	USART_InitStructure.USART_HardwareFlowControl = USART_HardwareFlowControl_None;
  USART_InitStructure.USART_Mode = USART_Mode_Rx | USART_Mode_Tx;
  USART_Init(USART2, &USART_InitStructure);
  /* Enable the Open_USART Transmit interrupt: this interrupt is generated when the 
     Open_USARTx transmit data register is empty */
  USART_ITConfig(USART2,USART_IT_RXNE,ENABLE);

  USART_Cmd(USART2, ENABLE);
}
static u8 TxBuffer_2[256];
static u8 TxCounter_2=0;
static u8 count_2=0; 

static void Gps_Data_Anl(u8 uart_data);

void Uart2_IRQ(void)
{
	if(USART2->SR & USART_SR_ORE)//OREж
	{
		u8 com_data = USART2->DR;//USART_ClearFlag(USART1,USART_IT_ORE);
	}
	//ж
	if((USART2->SR & (1<<7))&&(USART2->CR1 & USART_CR1_TXEIE))//if(USART_GetITStatus(USART1,USART_IT_TXE)!=RESET)
	{
		USART2->DR = TxBuffer_2[TxCounter_2++]; //дDRжϱ־          
		if(TxCounter_2 == count_2)
		{
			USART2->CR1 &= ~USART_CR1_TXEIE;		//رTXEж//USART_ITConfig(USART1,USART_IT_TXE,DISABLE);
		}
	}
	//ж (ռĴǿ) 
	if(USART2->SR & (1<<5))//if(USART_GetITStatus(USART1, USART_IT_RXNE) != RESET)    
	{
		u8 com_data = USART2->DR;
		Gps_Data_Anl(com_data);
	}
}
/////////////////////////////////////////////////////////////////////////////////////////////////////

typedef struct{
				u32 	timeofweek;
				vs32	lng;
				vs32	lat;
				vs32	height;
				vs32	hMSL;
				u32		hAcc;
				u32		vAcc;
				u16		check;}T_GPS_Posllh;
typedef struct{
				u32	timeofweek;
				vs32	fTOW;
				vs16	week;
				u8		gpsFix;
				u8		flags;
				vs32	ecefX;
				vs32	ecefY;
				vs32	ecefZ;
				u32		pAcc;
				vs32	ecefVX;
				vs32	ecefVY;
				vs32	ecefVZ;
				u32		sAcc;
				u16		pDOP;
				u8		reserved1;
				u8		numSV;
				u32		reserved2;
				u16		check;}T_GPS_Sol;

union 
{
	T_GPS_Posllh data;
	char temp[30];
}Data_Posllh;
union 
{
	T_GPS_Sol data;
	char temp[54];
}Data_Sol;

static T_GPS_Data gps_data;

static void Gps_Data_Anl(u8 uart_data)
{
/*
POSLLH : 	B5 62 01 02 1C 00  		ͷݣݳ282ֽУ
SOL			B5 62 01 06 34 00 		ݳ522ֽУ

*/
	static u8 gps_data_status = 0;
	static u8 gps_data_temp_cnt=0;
	static u8 data1_ok = 0,data2_ok = 0;	//յһ֡,Ӧı1,ڼյ֡
	
	switch(gps_data_status)
	{
		case 0:
						if(uart_data==0xB5)
							gps_data_status = 1;
					break;
		case 1:
						if(uart_data==0x62)
							gps_data_status = 2;
						else
							gps_data_status = 0;
					break;
		case 2:
						if(uart_data==0x01)
							gps_data_status = 3;
						else
							gps_data_status = 0;
					break;
		case 3:
						if(uart_data==0x02)
							gps_data_status = 11;
						else if(uart_data==0x06)
							gps_data_status = 21;
						else
							gps_data_status = 0;
					break;
/////////////////////////////////////////////////////////////////
		case 11:
						if(uart_data==0x1C)
							gps_data_status = 12;
						else
							gps_data_status = 0;
					break;
		case 12:
						if(uart_data==0x00)
						{
							gps_data_temp_cnt=0;
							gps_data_status = 13;
						}
						else
							gps_data_status = 0;
					break;
		case 13:		//POSLLH
						Data_Posllh.temp[gps_data_temp_cnt++] = uart_data;
						if(gps_data_temp_cnt==30)		//
						{
							u8 ck_a=0,ck_b=0;
							gps_data_status = 0;
							ck_a += 1;
							ck_b += ck_a;
							ck_a += 2;
							ck_b += ck_a;
							ck_a += 0x1C;
							ck_b += ck_a;
							ck_b += ck_a;
							for(u8 i=0;i<28;i++)			//У
							{
								ck_a += Data_Posllh.temp[i];
								ck_b += ck_a;
							}
							if(ck_a==Data_Posllh.temp[28]&&ck_b==Data_Posllh.temp[29])	//Уͨ
							{
								gps_data.Lng_32 = Data_Posllh.data.lng;
								gps_data.Lng = (double)gps_data.Lng_32 / 10000000;
								gps_data.Lat_32 = Data_Posllh.data.lat;
								gps_data.Lat = (double)gps_data.Lat_32 / 10000000;
								gps_data.Alt = (double)Data_Posllh.data.height / 1000;
								gps_data.Hac = (float)Data_Posllh.data.hAcc / 1000;
								gps_data.Vac = (float)Data_Posllh.data.vAcc / 1000;
								data1_ok = 1;
							}
						}
					break;
/////////////////////////////////////////////////////////
		case 21:		//SOL
						if(uart_data==0x34)
							gps_data_status = 22;
						else
							gps_data_status = 0;
					break;
		case 22:
						if(uart_data==0x00)
						{
							gps_data_temp_cnt=0;
							gps_data_status = 23;
						}
						else
							gps_data_status = 0;
					break;
		case 23:
						Data_Sol.temp[gps_data_temp_cnt++] = uart_data;
						if(gps_data_temp_cnt==54)		//
						{
							u8 ck_a=0,ck_b=0;
							gps_data_status = 0;
							ck_a += 1;
							ck_b += ck_a;
							ck_a += 6;
							ck_b += ck_a;
							ck_a += 0x34;
							ck_b += ck_a;
							ck_b += ck_a;
							for(u8 i=0;i<52;i++)			//У
							{
								ck_a += Data_Sol.temp[i];
								ck_b += ck_a;
							}
							if(ck_a==Data_Sol.temp[52]&&ck_b==Data_Sol.temp[53])	//Уͨ
							{
								gps_data.UTC = Data_Sol.data.timeofweek / 1000;
								gps_data.FixSta = Data_Sol.data.gpsFix;
								gps_data.SOG = (float)Data_Sol.data.sAcc / 100;
								gps_data.SVN = Data_Sol.data.numSV;
								data2_ok = 1;
							}
						}
					break;
	}
	if(data1_ok+data2_ok==2)
	{
		data1_ok = 0;
		data2_ok = 0;
		rt_event_send(&Evt_Sys,EVT_GPS_GET);
	}
	
}
void Get_GpsData(T_GPS_Data *data)
{
	data->Lng 		= gps_data.Lng;
	data->Lat 		= gps_data.Lat;
	data->Lng_32 	= gps_data.Lng_32;
	data->Lat_32 	= gps_data.Lat_32;
	data->Alt 		= gps_data.Alt;
	data->Hac 		= gps_data.Hac;
	data->Vac 		= gps_data.Vac;
	data->UTC 		= gps_data.UTC;
	data->FixSta 	= gps_data.FixSta;
	data->SOG 		= gps_data.SOG;
	data->SVN 		= gps_data.SVN;
}
