#ifndef __SYSCONFIG_H__
#define __SYSCONFIG_H__
#include <rtthread.h>

#define NVIC_GROUP NVIC_PriorityGroup_3		//0--7
#define NVIC_SYSTIMER_P			4
#define NVIC_SYSTIMER_S			1
#define NVIC_PWMIN_P			0
#define NVIC_PWMIN_S			1
#define NVIC_SD_P				7
#define NVIC_SD_S				1
#define NVIC_UART1_P			6
#define NVIC_UART1_S			1
#define NVIC_UART2_P			3	//gps
#define NVIC_UART2_S			1
#define NVIC_UART3_P			6
#define NVIC_UART3_S			1
#define NVIC_UART6_P			6
#define NVIC_UART6_S			1

#define EVT_SS_6050				1
#define EVT_SS_8975				(1<<1)
#define	EVT_SS_5611				(1<<2)
#define EVT_CL_ATT				(1<<3)
//#define EVT_CL_ALT				(1<<4)
//#define EVT_CL_POS				(1<<5)
#define	EVT_RC_GET				(1<<10)
#define EVT_GPS_GET				(1<<11)

#define THD_6050_P				1
#define THD_ATT_P				2
#define THD_POS_P				4
#define THD_RC_P				5
#define THD_DT_P				10
#define THD_LED_P				30

#define DATA_TRANSFER_USE_USART
//#define DATA_TRANSFER_USE_SPI_NRF

typedef struct{
				float rol;
				float pit;
				float yaw;}T_float_angle;
typedef struct{
				float X;
				float Y;
				float Z;}T_float_xyz;
typedef struct{
				int16_t X;
				int16_t Y;
				int16_t Z;}T_int16_xyz;
typedef struct int16_rcget{
				int16_t ROLL;
				int16_t PITCH;
				int16_t THROTTLE;
				int16_t YAW;
				int16_t AUX1;
				int16_t AUX2;
				int16_t AUX3;
				int16_t AUX4;
				int16_t AUX5;
				int16_t AUX6;}T_RC_Data;
typedef struct{
				double	UTC;		//ʱ
				vs32	Lat_32;
				double	Lat;		//γ
				//char	NSi;
				vs32	Lng_32;
				double	Lng;		//
				//char	EWi;
				float	Alt;		//߶
				float	SOG;		//ٶ
				float	Hac;		//߶Ⱦ
				float	Vac;		//ˮƽ
				float	COG;		//
				u8		FixSta;	//GPS״̬
				float	VD;			//?????
				u8		SVN;		//
				}T_GPS_Data;
typedef struct{
				u8		ARMED;	//=0,
				}T_Control;

extern char thread_6050_stack[1024];
extern struct rt_thread thd_6050;
void rt_thread_entry_6050(void* parameter);

extern char thread_ATT_stack[1024];
extern struct rt_thread thd_ATT;
void rt_thread_entry_ATT(void* parameter);

extern char thread_POS_stack[1024];
extern struct rt_thread thd_POS;
void rt_thread_entry_POS(void* parameter);

extern char thread_RC_stack[1024];
extern struct rt_thread thd_RC;
void rt_thread_entry_RC(void* parameter);

extern char thread_DataTrans_stack[1024];
extern struct rt_thread thd_DataTrans;
void rt_thread_entry_DataTrans(void* parameter);

extern struct rt_event Evt_Sys;

extern T_int16_xyz 		Acc,Gyr;	//ۺϺĴ
extern T_int16_xyz		Mag;
extern vs32				Alt;
extern T_float_angle 	Att_Angle;	//ATT̬
extern float			Mag_Heading;
extern T_RC_Data 		Rc_D;
extern T_Control		RC_Control;
extern T_GPS_Data		Gps_Data;
extern u8				LED_STA;
extern u32				Debug_cnt;
#endif
