// window.jQuery = window.$ = require('jquery');

(function ($) {
    "use strict";

    $(document).ready(function () {

        /*------------------------------
            fixed-nav
        -------------------------------*/

        $(window).on('scroll', function () {
            var scroll = $(window).scrollTop();
            if (scroll < 100) {
                $("#navbar").removeClass("sticky");
            } else {
                $("#navbar").addClass("sticky");
            }
        });

        /*------------------------------
            scroll-to-top
        -------------------------------*/
        var ScrollTop = $(".scrollToTop");
        $(window).on('scroll', function() {
            if ($(this).scrollTop() < 500) {
                ScrollTop.removeClass("active");
            } else {
                ScrollTop.addClass("active");
            }
        });

        $('.scrollToTop').on('click', function () {
            $('html, body').animate({
                scrollTop: 0
            }, 500);
            return false;
        });

        /*------------------------------
            Input Increase
        -------------------------------*/

        var minVal = 1, maxVal = 20;
        $(".increaseQty").on('click', function(){
                var $parentElm = $(this).parents(".qtySelector");
                $(this).addClass("clicked");
                setTimeout(function(){
                    $(".clicked").removeClass("clicked");
                },100);
                var value = $parentElm.find(".qtyValue").val();
                if (value < maxVal) {
                    value++;
                }
                $parentElm.find(".qtyValue").val(value);
        });
        
        $(".decreaseQty").on('click', function(){
            var $parentElm = $(this).parents(".qtySelector");
            $(this).addClass("clicked");
            setTimeout(function(){
                $(".clicked").removeClass("clicked");
            },100);
            var value = $parentElm.find(".qtyValue").val();
            if (value > 1) {
                value--;
            }
            $parentElm.find(".qtyValue").val(value);
        });

        // nice select
        $('select:not(.ignore)').niceSelect();

        /*------------------------------
            specialist-section-carousel
        -------------------------------*/

        $('.specialist-section-carousel').slick({
            infinite: true,
            autoplay: true,
            focusOnSelect: true,
            speed: 1000,
            slidesToShow: 5,
            slidesToScroll: 1,
            arrows: true,
            prevArrow:"<button type='button' class='slick-prev pull-left'><i class=\"icofont-thin-left\"  aria-hidden='true'></i></button>",
            nextArrow:"<button type='button' class='slick-next pull-right'><i class=\"icofont-thin-right\"  aria-hidden='true'></i></button>",
            dots: true,
            dotsClass: 'specialist-styles-section-dots',
            customPaging: function (slider, i) {
                var slideNumber = (i + 1),
                    totalSlides = slider.slideCount;
                return '<a class="dot" role="button" title="' + slideNumber + ' of ' + totalSlides + '"><span class="string">' + slideNumber + '/' + totalSlides + '</span></a>';
            },
            responsive: [
                {
                    breakpoint: 1205,
                    settings: {
                        slidesToShow: 4,
                        slidesToScroll: 1,
                        infinite: true
                    }
                },
                {
                    breakpoint: 1025,
                    settings: {
                        slidesToShow: 3,
                        slidesToScroll: 1,
                        infinite: true
                    }
                },
                {
                    breakpoint: 993,
                    settings: {
                        slidesToShow: 3,
                        slidesToScroll: 1,
                        infinite: true
                    }
                },
                {
                    breakpoint: 769,
                    settings: {
                        slidesToShow: 2,
                        slidesToScroll: 1,
                        infinite: true
                    }
                },
                {
                    breakpoint: 576,
                    settings: {
                        slidesToShow: 2,
                        slidesToScroll: 1
                    }
                },
                {
                    breakpoint: 481,
                    settings: {
                        slidesToShow: 1,
                        slidesToScroll: 1
                    }
                }
            ]
        });

        /*------------------------------
            latest-product-area-carousel
        -------------------------------*/

        $('.latest-product-area-carousel').slick({

            infinite: true,
            autoplay: true,
            focusOnSelect: true,
            speed: 1000,
            slidesToShow: 4,
            slidesToScroll: 1,
            arrows: true,
            prevArrow:"<button type='button' class='slick-prev pull-left'><i class=\"icofont-thin-double-left\"  aria-hidden='true'></i></button>",
            nextArrow:"<button type='button' class='slick-next pull-right'><i class=\"icofont-thin-double-right\"  aria-hidden='true'></i></button>",
            responsive: [
                {
                    breakpoint: 1200,
                    settings: {
                        slidesToShow: 3,
                        slidesToScroll: 1
                    }
                },
                {
                    breakpoint: 992,
                    settings: {
                        slidesToShow: 2,
                        slidesToScroll: 1
                    }
                },
                {
                    breakpoint: 768,
                    settings: {
                        slidesToShow: 1,
                        slidesToScroll: 1
                    }
                },
                {
                    breakpoint: 481,
                    settings: {
                        slidesToShow: 1,
                        slidesToScroll: 1,
                    }
                }
            ]
        });

        /*------------------------------
            trending-swimwear-carousel
        -------------------------------*/
        $('.trending-swimwear-carousel').slick({
            infinite: true,
            autoplay: true,
            focusOnSelect: true,
            speed: 1000,
            slidesToShow: 4,
            slidesToScroll: 1,
            arrows: true,
            prevArrow:"<button type='button' class='slick-prev pull-left'><i class=\"icofont-thin-double-left\"  aria-hidden='true'></i></button>",
            nextArrow:"<button type='button' class='slick-next pull-right'><i class=\"icofont-thin-double-right\"  aria-hidden='true'></i></button>",
            responsive: [
                {
                    breakpoint: 1200,
                    settings: {
                        slidesToShow: 3,
                        slidesToScroll: 1
                    }
                },
                {
                    breakpoint: 769,
                    settings: {
                        slidesToShow: 2,
                        slidesToScroll: 1
                    }
                },
                {
                    breakpoint: 600,
                    settings: {
                        slidesToShow: 2,
                        slidesToScroll: 1
                    }
                },
                {
                    breakpoint: 577,
                    settings: {
                        slidesToShow: 2,
                        slidesToScroll: 1,
                    }
                },
                {
                    breakpoint: 482,
                    settings: {
                        slidesToShow: 1,
                        slidesToScroll: 1,
                    }
                },
                {
                    breakpoint: 479,
                    settings: {
                        slidesToShow: 1,
                        slidesToScroll: 1,
                    }
                }
            ]
        });

        /*------------------------------
            related-this-carousel
        -------------------------------*/

        $('.related-this-carousel').slick({
            infinite: true,
            autoplay: true,
            focusOnSelect: true,
            speed: 1000,
            slidesToShow: 4,
            slidesToScroll: 1,
            arrows: true,
            prevArrow:"<button type='button' class='slick-prev pull-left'><i class=\"icofont-thin-double-left\"  aria-hidden='true'></i></button>",
            nextArrow:"<button type='button' class='slick-next pull-right'><i class=\"icofont-thin-double-right\"  aria-hidden='true'></i></button>",
            responsive: [
                {
                    breakpoint: 600,
                    settings: {
                        slidesToShow: 2,
                        slidesToScroll: 1
                    }
                },
                {
                    breakpoint: 1200,
                    settings: {
                        slidesToShow: 3,
                        slidesToScroll: 1
                    }
                },
                {
                    breakpoint: 769,
                    settings: {
                        slidesToShow: 2,
                        slidesToScroll: 1
                    }
                },
                {
                    breakpoint: 577,
                    settings: {
                        slidesToShow: 1,
                        slidesToScroll: 1,
                    }
                }
            ]
        });

        /*------------------------------
            shop-brand--carousel
        -------------------------------*/

        $('.shop-brand-carousel').slick({

            infinite: true,
            autoplay: true,
            focusOnSelect: true,
            speed: 1000,
            slidesToShow: 5,
            slidesToScroll: 1,
            arrows: true,
            prevArrow:"<button type='button' class='slick-prev pull-left'><i class=\"icofont-thin-left\"  aria-hidden='true'></i></button>",
            nextArrow:"<button type='button' class='slick-next pull-right'><i class=\"icofont-thin-right\"  aria-hidden='true'></i></button>",
            dots: true,
            dotsClass: 'shop-brand-section-dots',
            customPaging: function (slider, i) {
                var slideNumber = (i + 1),
                    totalSlides = slider.slideCount;
                return '<a class="dot" role="button" title="' + slideNumber + ' of ' + totalSlides + '"><span class="string">' + slideNumber + '/' + totalSlides + '</span></a>';
            },
            responsive: [
                {
                    breakpoint: 769,
                    settings: {
                        slidesToShow: 4,
                        slidesToScroll: 1
                    }
                },
                {
                    breakpoint: 600,
                    settings: {
                        slidesToShow: 2,
                        slidesToScroll: 1
                    }
                },
                {
                    breakpoint: 321,
                    settings: {
                        slidesToShow: 1,
                        slidesToScroll: 1,
                    }
                }
            ]
        });

        /*------------------------------
            choose-us-carousel
        -------------------------------*/

        $('.choose-us-carousel').slick({

            infinite: true,
            autoplay: true,
            focusOnSelect: true,
            speed: 1000,
            slidesToShow: 1,
            slidesToScroll: 1,
            arrows: true,
            prevArrow:"<button type='button' class='slick-prev pull-left'><i class=\"icofont-thin-double-left\"  aria-hidden='true'></i></button>",
            nextArrow:"<button type='button' class='slick-next pull-right'><i class=\"icofont-thin-double-right\"  aria-hidden='true'></i></button>",
            responsive: [
                {
                    breakpoint: 600,
                    settings: {
                        slidesToShow: 1,
                        slidesToScroll: 1
                    }
                },
                {
                    breakpoint: 320,
                    settings: {
                        slidesToShow: 1,
                        slidesToScroll: 1,
                    }
                }
            ]
        });
        /*------------------------------
            testimonial-right-slide
        -------------------------------*/

        $('.testimonial-right-slide').slick({

            infinite: true,
            autoplay: true,
            focusOnSelect: true,
            speed: 1000,
            slidesToShow: 1,
            slidesToScroll: 1,
            arrows: true,
            prevArrow:"<button type='button' class='slick-prev pull-left'><i class=\"icofont-thin-double-left\"  aria-hidden='true'></i></button>",
            nextArrow:"<button type='button' class='slick-next pull-right'><i class=\"icofont-thin-double-right\"  aria-hidden='true'></i></button>",
            dots: true,
            dotsClass: 'testimonials-section-dots',
            customPaging: function (slider, i) {
                var slideNumber = (i + 1),
                    totalSlides = slider.slideCount;
                return '<a class="dot" role="button" title="' + slideNumber + ' of ' + totalSlides + '"><span class="string">' + slideNumber + '/' + totalSlides + '</span></a>';
            },
            responsive: [
                {
                    breakpoint: 600,
                    settings: {
                        slidesToShow: 1,
                        slidesToScroll: 1
                    }
                },
                {
                    breakpoint: 320,
                    settings: {
                        slidesToShow: 1,
                        slidesToScroll: 1,
                    }
                }
            ]
        });
        
        /*------------------------------
            service grid and list view
        -------------------------------*/
        
        $(".view-style-toggle-area .list-btn").on("click", function() {
            $(".product-grid-view").removeClass("grid-style");
            $(".product-grid-view").addClass("list-style");
        });
        $(".view-style-toggle-area .grid-btn").on("click", function() {
            $(".product-grid-view").removeClass("list-style");
            $(".product-grid-view").addClass("grid-style");
        });
        $(".view-style-toggle-area .view-btn").on("click", function() {
            $('.view-btn').removeClass('active')
            $(this).addClass("active");
        });

        /*------------------------------
            Range Slider
        -------------------------------*/
        $("#sliderdemo").ionRangeSlider({
            skin: "big",
            type: "double",
            grid: true,
            min: -2000,
            max: 10000,
            from: -500,
            to: 8000
        });

        /*------------------------------
            Counter Up
        -------------------------------*/

        $('.number, .counter').counterUp({
            delay: 10, // the delay time in ms
            time: 1000 // the speed time in ms
        });

        /*------------------------------
            Product Zoom
        -------------------------------*/

        $('.item-zoom-slider').slick({
            infinite: true,
            autoplay: false,
            focusOnSelect: true,
            speed: 1000,
            centerMode: true,
            slidesToShow: 3,
            slidesToScroll: 1,
            arrows: true,
            prevArrow:"<button type='button' class='slick-prev pull-left'><i class=\"icofont-thin-double-left\"  aria-hidden='true'></i></button>",
            nextArrow:"<button type='button' class='slick-next pull-right'><i class=\"icofont-thin-double-right\"  aria-hidden='true'></i></button>",
            responsive: [
                {
                    breakpoint: 1200,
                    settings: {
                        slidesToShow: 3,
                        slidesToScroll: 1
                    }
                },
                {
                    breakpoint: 769,
                    settings: {
                        slidesToShow: 2,
                        slidesToScroll: 1
                    }
                },
                {
                    breakpoint: 600,
                    settings: {
                        slidesToShow: 2,
                        slidesToScroll: 1
                    }
                },
                {
                    breakpoint: 479,
                    settings: {
                        slidesToShow: 2,
                        slidesToScroll: 1,
                    }
                }
            ]
        });

        /*------------------------------
            popup-videos
        -------------------------------*/

        $('.popupvideo').magnificPopup({
            disableOn: 700,
            type: 'iframe',
            mainClass: 'mfp-fade',
            removalDelay: 160,
            preloader: false,
            fixedContentPos: false,
        });

        $('.popupvideo').magnificPopup({
            type: 'video'
        });

        // xzoom magific

        $('.xzoom-magnific').magnificPopup({
            type: 'image'
        });

        /*------------------------------
            preloader
        -------------------------------*/

        $("#preloader").delay(300).animate({
            "opacity" : "0"
        }, 500, function() {
            $("#preloader").css("display","none");
        });

    })

})(jQuery);