--[[
*********************************************************
-- NPCMark Database (Simplified Chinese)
-- Currently Maintained by 静谧的狼狈 @ 2016/08/18
*********************************************************
-- Format
1.拍卖师 Auctioneer

2.银行职员 Banker

3.飞行管理员 Flight Master
蝙蝠Bat, 龙鹰Dragonhawk, 狮鹫Gryphon, 角鹰兽Hippogryph, 双足飞龙Wind Rider, etc.

4.旅店老板 Innkeeper

5.兽栏管理员 Stable Master

6.专业训练师
炼金术Alchemy
考古学Archaeology
锻造Blacksmithing
烹饪Cooking
附魔Enchanting
工程学Engineering
急救First Aid
钓鱼Fishing,
飞行Flying
草药学Herbalism
铭文Inscription
珠宝加工Jewelcrafting
制皮Leatherworking
采矿Mining
骑术Riding
剥皮Skinning
裁缝Tailoring
恶魔Demon
传送门Portal

7.职业训练师
死亡骑士Death Knight
恶魔猎手Demon Hunter
德鲁伊Druid
猎人Hunter
法师Mage
武僧Monk
圣骑士Paladin
牧师Priest
潜行者Rogue
萨满祭司Shaman
术士Warlock
战士Warrior

8.商人
Vendor, Trader, Quartermaster, Supply Officer, Gladiator, etc.

9.其他NPC
公会管理员Guild Masters, 理发师Barber, 奥术重铸师Arcane Reforger, etc.

10.训练假人 Dummy
--]]

if GetLocale() == 'zhCN' then
	MapPlusNodeData = {
	-- 主要城市 Major Cities
		-- Darnassus
		["达纳苏斯"]={
		-- 拍卖师
			{"拍卖师", "拍卖师图尔伦",{54.9,57.6}}, -- 8669
			{"拍卖师", "拍卖师戈洛萨斯",{54.8,58.2}}, -- 8723
			{"拍卖师", "拍卖师塞尔瓦拉斯",{55,58}}, -- 15678
			{"拍卖师", "拍卖师卡札雷兹",{54.4,58.1}}, -- 15679
		-- 银行职员
			{"银行职员", "伊迪瑞娜",{43.4,51.3}}, -- 4155
			{"银行职员", "莱恩",{43.6,50.6}}, -- 4208
			{"银行职员", "加瑞斯",{43.6,51.0}}, -- 4209
		-- 飞行管理员
			{"角鹰兽管理员", "利奥拉",{36.2,47.8}}, -- 40552
		-- 旅店老板
			{"旅店老板", "旅店老板塞琳尼",{62.4,32.8}}, -- 6735
			{"旅店老板", "格温·阿姆斯特",{48.2,14.6}}, -- 48735
		-- 兽栏管理员
			{"兽栏管理员", "阿拉辛",{43.2,29.0}}, -- 10056
		-- 专业训练师
			{"炼金术训练师", "安尼希尔",{54.0,38.6}}, -- 4160
			{"考古学训练师", "隐世者汉蒙",{42.6,83.3}}, -- 47569
			{"锻造训练师", "罗尔夫·卡尔尼尔",{56.8,52.8}}, --52640
			{"烹饪训练师", "阿雷贡",{49.4,36.7}}, -- 4210
			{"附魔训练师", "塔兰丹",{56.6,31.6}}, -- 4213
			{"工程学训练师", "塔娜·伦特尼尔",{49.6,32.6}}, --52636
			{"急救训练师", "丹纳罗尔",{51.6,30.6}}, -- 4211
			{"钓鱼训练师", "阿斯坦娅",{49.0,61.0}}, -- 4156
			{"草药学训练师", "菲罗迪恩·唤月",{49.0,69.0}}, -- 4204
			{"铭文训练师", "芬迪·达金",{56.4,32.3}}, -- 30715
			{"珠宝加工训练师", "艾莎·银露",{54.2,30.4}}, --52645
			{"制皮训练师", "泰龙尼斯",{60.6,36.4}}, -- 4212
			{"采矿训练师", "工头佩尔尼奇",{50.6,33.8}}, --52642
			{"骑术训练师", "贾萨姆",{42.7,33.0}}, -- 4753
			{"剥皮训练师", "艾拉迪尔",{60.2,37.0}}, -- 6292
			{"裁缝训练师", "迈里恩",{59.6,37.2}}, -- 4159
			{"传送门训练师", "埃莉萨·杜马斯",{43.4,78.3}}, -- 4165
		-- 职业训练师
			{"德鲁伊训练师", "玛斯雷·驭熊者",{40.5,27.8}}, -- 4217
			{"德鲁伊训练师", "德纳萨里安",{40.2,28.0}}, -- 4218
			{"德鲁伊训练师", "菲勒里亚·夜翼",{39.6,28.4}}, -- 4219
			{"德鲁伊训练师", "莱罗斯·疾风",{49.6,17.0}}, -- 50505
			{"德鲁伊训练师", "野性泰尔兰",{50.6,17.9}}, -- 50506
			{"德鲁伊训练师", "法珊德拉·暴风爪",{49.6,17.2}}, -- 50507
			{"猎人训练师", "吉恩拉",{43.5,25.8}}, -- 4138
			{"猎人训练师", "祖卡斯特",{43.8,28.0}}, -- 4146
			{"猎人训练师", "多利安",{45.2,27.8}}, -- 4205
			{"猎人训练师", "猎手布雷克",{48.7,18.4}}, -- 50497
			{"法师训练师", "米莉安·唤法者",{49.7,15.4}}, -- 50499
			{"法师训练师", "塔勒维尔",{37.7,80.0}}, -- 50690
			{"法师训练师", "戴尔娜拉",{37.5,80.4}}, -- 50714
			{"法师训练师", "玛伊里尔",{37.6,80.2}}, -- 50715
			{"武僧训练师", "茶道大师兰风",{47.6,60.0}}, --62450
			{"圣骑士训练师", "鲁库阿",{43.6,78.6}}, -- 35281
			{"牧师训练师", "阿斯塔利·逐星",{43.2,77.4}}, -- 4090
			{"牧师训练师", "贾德莉亚",{42.6,78.6}}, -- 4091
			{"牧师训练师", "拉瑞亚",{43.8,82.6}}, -- 4092
			{"牧师训练师", "女祭司阿兰希雅",{43.4,79.4}}, -- 11401
			{"牧师训练师", "艾尔米拉修女",{48.2,17.6}}, -- 50501
			{"潜行者训练师", "塞尤娜",{41.6,37.1}}, -- 4163
			{"潜行者训练师", "艾瑞安·影语",{40.0,39.7}}, -- 4214
			{"潜行者训练师", "安妮莎尔",{42.8,36.4}}, -- 4215
			{"潜行者训练师", "侠盗萝伦",{47.4,15.4}}, -- 50498
			{"萨满祭司训练师", "德罗哈",{43.8,78.8}}, --52292
			{"术士训练师", "维图斯·暗行者",{49.8,16.7}}, -- 50502
			{"战士训练师", "阿雷亚斯塔·刃歌",{56.6,46.2}}, -- 4087
			{"战士训练师", "希达奈尔",{58.4,50.2}}, -- 4089
			{"战士训练师", "达纳斯·刃歌",{56.6,46.6}}, -- 7315
			{"战士训练师", "克利希中士",{48.4,18.1}}, -- 50500
		-- 商人
			--{"达纳苏斯军需官", "月之女祭司娜萨拉",{36.6,49.0}}, -- 50305
			--{"吉尔尼斯军需官", "坎德雷勋爵",{37.0,47.8}}, -- 50307
			{"军需官", "达纳苏斯;吉尔尼斯",{36.6,49.0}}, -- 50305/50307
		-- 其他NPC
			{"公会注册员", "琳沙娜",{64.6,37.6}}, -- 4161
		-- 训练假人
			{"训练假人", "训练假人",{60.6,47.2}}, -- 31144
			{"训练假人", "团队副本训练假人",{60.8,53.2}}, -- 31146
			{"训练假人", "训练假人",{61.2,45.0}}, -- 32666
			{"训练假人", "训练假人",{61.4,54.6}}, -- 32667
		-- 交通工具
			{"传送门", "鲁瑟兰村-泰达希尔",{37.4,50.4}},
			{"传送门", "地狱火半岛;埃索达",{44.0,78.5}},
		},

		-- Ironforge
		["铁炉堡"]={
		-- 拍卖师
			{"拍卖师", "拍卖师巴克尔",{23.8,72.0}}, -- 8671
			{"拍卖师", "拍卖师雷姆斯",{24.2,74.4}}, -- 8720
			{"拍卖师", "拍卖师林姆克",{25.8,75.2}}, -- 9859
		-- 银行职员
			{"银行职员", "巴纳姆·石衣",{34.6,59.0}}, -- 2460
			{"银行职员", "拜雷·石衣",{35.4,60.6}}, -- 2461
			{"银行职员", "索雷尔·石衣",{36.4,62.2}}, -- 5099
		-- 飞行管理员
			{"狮鹫管理员", "格莱斯·瑟登",{55.0,48.4}}, -- 1573
		-- 旅店老板
			{"旅店老板", "旅店老板洛雷·火酒",{18.6,51.4}}, -- 5111
		-- 兽栏管理员
			{"兽栏管理员", "乌布雷克·火拳",{69.4,84.0}}, -- 9984
		-- 专业训练师
			{"炼金术训练师", "塔雷·浆泡",{66.6,55.0}}, -- 5177
			{"考古学训练师", "学者教授铁裤",{75.4,11.2}}, -- 39718
			{"锻造训练师", "本古斯·深炉",{52.2,41.4}}, -- 4258
			{"锻造训练师", "格鲁努斯·削钢",{50.2,42.8}}, -- 5164
			{"锻造训练师", "埃隆努斯·冷钢",{50.4,43.0}}, -- 11146
			{"烹饪训练师", "达瑞尔·瑞克努索",{60.1,36.4}}, -- 5159
			{"附魔训练师", "吉布·草须",{60.4,45.4}}, -- 5157
			{"工程学训练师", "宾斯匹德",{68.4,44.2}}, -- 5174
			{"工程学训练师", "工匠大师欧沃斯巴克",{69.8,50.2}}, -- 7944
			{"急救训练师", "尼莎·火石",{54.8,58.6}}, -- 5150
			{"钓鱼训练师", "格瑞诺尔·石印",{48.4,8.2}}, -- 5161
			{"草药学训练师", "雷纳·石枝",{55.6,58.8}}, -- 5137
			{"铭文训练师", "艾莉丝·布莱里特",{60.6,44.8}}, -- 30717
			{"珠宝加工训练师", "哈尼尔·坚石",{50.4,26.2}}, --52586
			{"制皮训练师", "费布·钢轴",{40.4,32.4}}, -- 5127
			{"采矿训练师", "吉尔弗拉姆·石趾",{50.6,27.6}}, -- 4254
			{"剥皮训练师", "巴尔萨斯·裂石",{39.2,31.8}}, -- 6291
			{"裁缝训练师", "约莫德·石眉",{43.2,28.8}}, -- 5153
			{"恶魔训练师", "寻尸者祖贝尔",{53.2,7.4}}, --6382
			{"传送门训练师", "贝尔斯塔弗·风暴之眼",{25.4,7.4}}, -- 2489
		-- 职业训练师
			{"猎人训练师", "戴拉·锐矛",{71.0,90.6}}, -- 5115
			{"猎人训练师", "奥尔明·燃须",{70.9,83.6}}, -- 5116
			{"猎人训练师", "雷格努斯·雷石",{69.9,82.9}}, -- 5117
			{"法师训练师", "彬克",{26.2,7.3}}, -- 5144
			{"法师训练师", "朱莉·雷线",{26.6,7.8}}, -- 5145
			{"法师训练师", "尼特布尔·火花",{27.0,6.8}}, -- 5146
			{"法师训练师", "丁克",{27.0,8.4}}, -- 7312
			{"法师训练师", "炎术师灼酒",{24.3,10.3}}, -- 50716
			{"法师训练师", "菲拉娜·火舌",{24.3,11.6}}, -- 50717
			{"法师训练师", "莱恩达·金石",{24.4,11.4}}, -- 50720
			{"武僧训练师", "千杯不醉刘伶",{19.6,52.8}}, --62425
			{"圣骑士训练师", "瓦尔加·高炉",{22.6,5.7}}, -- 5147
			{"圣骑士训练师", "贝尔杜克·凝眉",{24.6,5.6}}, -- 5148
			{"圣骑士训练师", "布兰度尔·铁锤",{23.4,6.2}}, -- 5149
			{"牧师训练师", "塞欧杜斯·霜须",{23.2,8.3}}, -- 5141
			{"牧师训练师", "布莱纳·火崖",{24.8,8.0}}, -- 5142
			{"牧师训练师", "托德雷·铁矿",{25.8,9.4}}, -- 5143
			{"牧师训练师", "高阶牧师洛汉",{26.8,7.8}}, -- 11406
			{"潜行者训练师", "霍夫丹·黑须",{51.8,14.0}}, -- 5165
			{"潜行者训练师", "奥米尔·火眼",{52.0,14.0}}, -- 5166
			{"潜行者训练师", "芬斯维克",{51.0,14.8}}, -- 5167
			{"萨满祭司训练师", "先知亚瓦德",{55.2,29.0}}, -- 23127
			{"术士训练师", "瑟斯哈特",{50.2,7.7}}, -- 5171
			{"术士训练师", "布瑞尔索恩",{50.2,7.0}}, -- 5172
			{"术士训练师", "亚历山大·考德尔",{50.2,6.9}}, -- 5173
			{"术士训练师", "克里奇·岩刃",{50.6,6.8}}, -- 50723
			{"术士训练师", "巫婆达尔芭",{50.2,6.0}}, -- 50729
			{"术士训练师", "拉恩·深洞",{50.1,6.6}}, -- 50732
			{"战士训练师", "克斯塔姆·碎石",{67.0,88.9}}, -- 1901
			{"战士训练师", "凯夫·重锤",{69.2,91.4}}, -- 5113
			{"战士训练师", "比尔班·飞钳",{66.8,87.4}}, -- 5114
		-- 商人
			{"传家宝商人", "克罗姆·粗臂",{74.6,9.8}}, -- 6294
			--{"诺莫瑞根军需官", "工匠大师崔尼",{55.4,48.0}}, -- 50308
			--{"铁炉堡军需官", "石盔上尉",{55.8,47.8}}, -- 50309
			{"军需官", "铁炉堡;诺莫瑞根",{55.8,47.8}}, -- 50308/50309
		-- 其他NPC
			{"公会注册员", "乔多·钢眉",{36.6,84.6}}, -- 5130
			{"理发师", "贝拉·布拉鲁斯",{26.1,49.5}}, -- 29141
		-- 训练假人
			{"训练假人", "训练假人",{55.4,66.6}}, -- ?
			{"训练假人", "团队副本训练假人",{55.4,66.6}}, -- ?
		-- 交通工具
			{"传送门", "地狱火半岛",{27.2,7.0}},
			{"地铁", "暴风城;比兹莫搏击俱乐部",{72.6,50.2}},
		},

		-- Stormwind City
		["暴风城"]={
		-- 拍卖师
			{"拍卖师", "拍卖师希尔顿",{60.8,71.0}}, -- 8670
			{"拍卖师", "拍卖师费奇",{61.2,70.8}}, -- 8719
			{"拍卖师", "拍卖师亚克森",{61.4,70.6}}, -- 15659
			{"拍卖师", "拍卖师何塞",{60.2,32.4}}, -- 43690
			{"拍卖师", "拍卖师劳菲尔",{60.2,32.0}}, -- 43841
			{"拍卖师", "拍卖师菲格拉德",{60.2,31.8}}, -- 43842
		-- 银行职员
			{"银行职员", "奥利维亚·伯恩赛德",{62.7,78.4}}, -- 2455
			{"银行职员", "牛顿·伯恩赛德",{62.6,78.0}}, -- 2456
			{"银行职员", "约翰·伯恩赛德",{62.4,78.2}}, -- 2457
			{"银行职员", "克莉斯丁·卡扎雷兹",{63.3,79.4}}, -- 43692
			{"银行职员", "贾敏·克雷斯特",{64.8,29.2}}, -- 43723
			{"银行职员", "李·克雷斯特",{65.1,28.3}}, -- 43724
			{"银行职员", "科提斯·克雷斯特",{65.3,28.0}}, -- 43725
			{"银行职员", "柯尔斯蒂·韦斯特米尔",{63.0,77.7}}, -- 43819
			{"银行职员", "斯科特·韦斯特米尔",{63.1,78.7}}, -- 43820
			{"银行职员", "托马斯·韦斯特米尔",{63.3,78.4}}, -- 43822
			{"银行职员", "莱斯莉·韦恩怀特",{64.3,29.0}}, -- 43823
			{"银行职员", "安·韦恩怀特",{64.4,28.6}}, -- 43824
			{"银行职员", "沃伦·韦恩怀特",{64.9,27.7}}, -- 43825
			{"银行职员", "费里亚斯·G·班克沃斯",{65.6,27.6}}, -- 43840
		-- 飞行管理员
			{"狮鹫管理员", "杜加尔·朗德瑞克",{71.0,72.6}}, -- 43768
		-- 旅店老板
			{"旅店老板", "史蒂文·洛汉",{51.6,93.6}}, -- 3628
			{"旅店老板", "旅店老板奥里森",{60.4,75.2}}, -- 6740
			{"旅店老板", "塔格娜·耕石",{64.8,32.0}}, -- 44235
			{"旅店老板", "梅根·提尔曼",{75.6,54.2}}, -- 44237
		-- 兽栏管理员
			{"兽栏管理员", "塞丽斯塔",{42.5,60.6}}, -- 9977
			{"兽栏管理员", "耶诺瓦·石盾",{67.0,37.6}}, -- 11069
			{"兽栏管理员", "卡琳",{77.8,67.2}}, -- 44252
		-- 专业训练师
			{"炼金术训练师", "莉琳希亚·夜风",{55.6,85.8}}, -- 5499
			{"考古学训练师", "哈里森·琼斯",{85.6,25.8}}, -- 44238
			{"锻造训练师", "瑟鲁姆·深炉",{63.4,37.2}}, -- 5511
			--{"锻造训练师", "博古斯·钢拳",{59.4,34.1}}, -- 7232
			{"锻造训练师", "乔丹·史密斯",{64.8,48.2}}, -- 55684
			{"烹饪训练师", "斯蒂芬·雷百克",{77.2,53.2}}, -- 5482
			{"烹饪训练师", "罗比·弗雷",{50.6,71.6}}, -- 42288
			{"附魔训练师", "鲁坎·考迪尔",{53.0,74.2}}, -- 1317
			{"工程学训练师", "利廉姆·火轴",{62.8,32.0}}, -- 5518
			{"急救训练师", "安吉拉·雷菲德",{52.0,45.6}}, -- 56796
			{"钓鱼训练师", "阿诺德·利兰",{54.8,69.4}}, -- 5493
			{"飞行训练师", "布娜拉·云翼",{70.2,73.4}}, -- 43769
			{"草药学训练师", "莎拉米尔",{40.9,65.9}}, -- 5502
			{"草药学训练师", "塔尼莎",{54.4,84.0}}, -- 5566
			{"铭文训练师", "卡塔莉娜·斯坦弗",{49.6,74.6}}, -- 30713
			{"珠宝加工训练师", "特蕾莎·登曼",{63.4,61.6}}, -- 44582
			{"制皮训练师", "西蒙·坦纳尔",{71.8,62.8}}, -- 5564
			{"采矿训练师", "吉尔曼·石手",{59.6,37.6}}, -- 5513
			{"骑术训练师", "达尔雷恩·斯托克斯",{77.4,67.4}}, -- 43693
			{"骑术训练师", "林梅",{67.6,18.6}}, -- 70296
			{"剥皮训练师", "马瑞斯·格兰治",{72.0,62.4}}, -- 1292
			{"裁缝训练师", "乔吉奥·波利罗",{53.2,81.4}}, -- 1346
			{"裁缝训练师", "嘉莱恩·艾罗",{40.2,84.4}}, -- 9584
			{"恶魔训练师", "斯巴克尔",{39.6,84.6}}, -- 5520
			{"传送门训练师", "拉瑞麦尼·普尔度",{50.2,86.0}}, -- 2485
		-- 职业训练师
			{"德鲁伊训练师", "沙德拉斯·月树",{27.6,50.1}}, -- 5504
			{"德鲁伊训练师", "沙德拉斯·月树",{46.7,64.0}}, -- 5504
			{"德鲁伊训练师", "塞瑞德兰",{42.6,60.3}}, -- 5505
			{"德鲁伊训练师", "玛尔德利恩",{45.0,71.0}}, -- 5506
			{"德鲁伊训练师", "丰收女巫塞莱斯廷",{57.6,24.9}}, -- 44395
			{"猎人训练师", "恩瑞斯·锐矛",{67.4,36.4}}, -- 5515
			{"猎人训练师", "奥菲尔·铁须",{67.5,36.8}}, -- 5516
			{"猎人训练师", "索尔芬·石盾",{67.4,37.0}}, -- 5517
			{"猎人训练师", "多恩·奥玛尔",{79.1,70.4}}, -- 43277
			{"猎人训练师", "乌尔夫·哈斯雷姆",{79.1,70.4}}, -- 44247
			{"猎人训练师", "莎里希·朱莫",{79.1,70.4}}, -- 44249
			{"法师训练师", "詹妮亚·坎农",{49.4,86.1}}, -- 5497
			{"法师训练师", "艾尔莎林",{48.1,88.0}}, -- 5498
			{"法师训练师", "亮火",{49.0,87.2}}, -- 85307
			{"法师训练师", "拉鲁",{50.0,86.6}}, -- 89174
			{"武僧训练师", "艾莎·云歌",{68.2,16.6}}, -- 62419
			{"圣骑士训练师", "格雷森·沙东布瑞克公爵",{52.4,45.4}}, -- 928
			{"圣骑士训练师", "虔诚的亚瑟",{52.3,45.6}}, -- 5491
			{"圣骑士训练师", "纯洁的凯瑟琳",{52.3,45.6}}, -- 5492
			{"牧师训练师", "高阶牧师劳瑞娜",{49.7,44.9}}, -- 376
			{"牧师训练师", "本杰明修士",{51.0,45.3}}, -- 5484
			{"牧师训练师", "乔舒修士",{49.7,45.2}}, -- 5489
			{"牧师训练师", "娜拉·梅德隆",{27.9,50.4}}, -- 11397
			{"牧师训练师", "首席外科医生焊创",{62.4,34.0}}, -- 45306
			{"潜行者训练师", "夜行者奥斯伯",{77.4,65.3}}, -- 918
			{"潜行者训练师", "托尼·罗曼诺",{79.6,61.2}}, -- 13283
			{"潜行者训练师", "亚瑟·休维",{79.6,60.8}}, -- 51998
			{"萨满祭司训练师", "先知安布洛尔",{65.9,31.4}}, -- 20407
			{"萨满祭司训练师", "伯尔纳·锤喙",{65.4,30.9}}, -- 44393
			{"萨满祭司训练师", "达尔加·锤喙",{66.0,31.2}}, -- 44394
			{"术士训练师", "德米赛特·克劳斯",{39.4,84.8}}, -- 461
			{"术士训练师", "厄苏拉·德林",{40.0,84.3}}, -- 5495
			{"术士训练师", "山达尔",{39.4,85.0}}, -- 5496
			{"战士训练师", "安德尔·杰曼",{79.5,69.0}}, -- 914
			{"战士训练师", "武神",{79.8,69.4}}, -- 5479
			{"战士训练师", "伊尔萨·考宾",{79.8,69.3}}, -- 5480
		-- 商人
			-- 勇士大厅
			--{"PvP装备商", "军士长贝金斯",{75.6,66.6}}, -- 12781 "杂货军需官"
			--{"PvP装备商", "加克斯宾中尉",{75.6,66.6}}, -- 12784 "旧世界武器军需官"
			--{"PvP装备商", "克莱特军士长",{75.8,66.4}}, -- 12785 "旧世界护甲军需官"
			--{"PvP装备商", "崔丝提亚中尉",{74.8,67.6}}, -- 51255 "残忍角斗士Vicious"
			--{"PvP装备商", "埃德兰·哈尔辛",{74.6,68.2}}, -- 52029 "嗜血角斗士Bloodthirsty"
			{"荣誉传家宝", "莉莉安娜·恩贝弗斯特",{74.4,67.6}}, -- 52030
			--{"PvP装备商", "骑士队长蒂麦尔·塞缇丝",{75.0,67.0}}, -- 69974 "冷酷角斗士Ruthless"
			--{"PvP装备商", "迪格汉默上尉",{74.8,67.6}}, -- 69975 "灾变角斗士Cataclysmic"
			{"PvP装备商", "旧世界武器护甲;战争坐骑;S9L;S9H;S10;S11",{74.6,68.2}}, -- 12781/12784/1285|12783/73190|51255/52029/69974/69975
			-- 勇士大厅门外
			--{"战争坐骑军需官", "卡特尔中尉",{76.2,65.6}}, -- 12783
			--{"战争坐骑军需官", "通灵领主赛普",{76.8,65.6}}, -- 73190
			-- 指挥大厅
			--{"PvE装备商", "费尔德伦·提尔斯戴尔",{79.0,69.6}}, -- 44245 "勇气军需官"
			--{"PvE装备商", "玛嘉莎·斯利文托",{79.0,69.6}}, -- 44246 "正义军需官"
			--{"PvE装备商", "托伦·兰道",{79.0,70.0}}, -- 58154 "传承正义军需官"
			{"PvE装备商", "费尔德伦·提尔斯戴尔;玛嘉莎·斯利文托;托伦·兰道",{79.0,69.6}}, --44245/44246/58154
			-- 派系
			{"暴风城军需官", "骑士队长兰希·莱薇森",{67.6,72.8}}, -- 49877
			{"土水派军需官", "门徒韩俊",{68.0,17.0}}, -- 69334
			-- 其他
			{"大地的裂变时空漫游商人", "琪雅科",{76.0,17.6}}, -- 101759
			-- 恶魔入侵
			{"恶魔入侵军需官", "被俘的虫语者",{41.0,78.8}}, -- 109912
		-- 其他NPC
			{"公会注册员", "奥德文·拉弗林",{64.6,76.8}}, -- 4974
			{"理发师", "耶利尼克·沙希尔",{61.2,64.8}}, -- 29142
			{"奥术重铸师", "魔术师瓦西里恩",{50.6,60.6}}, -- 54441
		-- 训练假人
			{"训练假人", "团队副本训练假人",{80.2,64.5}}, -- 31146
			{"训练假人", "训练假人",{81.4,64.8}}, -- 32666
			{"训练假人", "训练假人",{81.0,65.0}}, -- 32667
			{"训练假人", "训练假人",{79.6,62.0}}, -- 46647
		-- 交通工具
			{"传送门", "坡东村",{68.9,17.2}},
			{"传送门", "托尔巴拉德半岛;深岩之洲;瓦斯琪尔;暮光高地;海加尔山;奥丹姆",{74.5,18.4}},
			{"传送门", "地狱火半岛;诅咒之地",{49.2,87.0}},
			{"传送门", "阿什兰",{82.5,29.7}},
			{"地铁", "铁炉堡;比兹莫搏击俱乐部",{68.7,32.2}},
			{"船舶", "鲁瑟兰村-泰达希尔",{22.7,56.0}},
			{"船舶", "无畏要塞-北风苔原",{18.3,25.3}},
		},

		-- The Exodar
		["埃索达"]={
		-- 拍卖师
			{"拍卖师", "伊欧奇",{63.7,58.7}}, -- 16707
			{"拍卖师", "范尼",{63.0,59.2}}, -- 18348
			{"拍卖师", "艾瑞纱",{63.4,59.0}}, -- 18349
		-- 银行职员
			{"银行职员", "凯拉格",{45.4,43.3}}, -- 16710
			{"银行职员", "欧斯科",{45.4,44.4}}, -- 17773
			{"银行职员", "洁拉",{45.4,43.9}}, -- 18350
		-- 飞行管理员
			{"角鹰兽管理员", "史丹樊那斯",{54.8,35.8}}, -- 17555
		-- 旅店老板
			{"旅店老板", "照顾者布利尤",{59.4,19.2}}, -- 16739
		-- 兽栏管理员
			{"兽栏管理员", "阿斯艾德",{60.0,25.4}}, -- 16764
		-- 专业训练师
			{"炼金术训练师", "鲁克",{27.8,61.6}}, -- 16723
			{"考古学训练师", "蒂亚",{34.0,66.7}}, -- 47570
			{"锻造训练师", "米阿尔",{60.6,89.6}}, -- 16724
			{"烹饪训练师", "穆曼",{55.9,27.0}}, -- 16719
			{"附魔训练师", "纳霍加",{40.2,39.5}}, -- 16725
			{"工程学训练师", "奥克基尔",{54.8,92.2}}, -- 16726
			{"急救训练师", "努丝",{39.6,22.6}}, -- 16731
			{"钓鱼训练师", "伊雷特",{31.2,15.2}}, -- 16774
			{"草药学训练师", "塞摩尔汉",{27.6,63.8}}, -- 16736
			{"铭文训练师", "索斯",{39.8,39.6}}, -- 30716
			{"珠宝加工训练师", "法里",{44.8,24.6}}, -- 19778
			{"制皮训练师", "阿克汉姆",{67.2,74.8}}, -- 16728
			{"采矿训练师", "穆亚特",{60.6,88.1}}, -- 16752
			{"骑术训练师", "埃亚伦",{81.4,52.6}}, -- 20914
			{"剥皮训练师", "雷米勒",{65.5,74.9}}, -- 16763
			{"裁缝训练师", "雷菲克",{64.2,68.3}}, -- 16729
			{"传送门训练师", "鲁纳尔兰",{46.1,63.6}}, -- 16755
		-- 职业训练师
			{"猎人训练师", "德雷米斯",{47.7,86.4}}, -- 16738
			{"猎人训练师", "沃尔德",{47.4,88.1}}, -- 17122
			{"猎人训练师", "基尔拉克",{46.6,89.6}}, -- 17505
			{"法师训练师", "伊迪拉恩",{46.9,62.5}}, -- 16749
			{"法师训练师", "哈尔南",{46.6,62.7}}, -- 17513
			{"法师训练师", "巴蒂",{46.4,63.1}}, -- 17514
			{"武僧训练师", "武魂潘劲",{54.8,82.0}}, --62464
			{"圣骑士训练师", "巴图恩",{39.0,84.2}}, -- 16761
			{"圣骑士训练师", "卡维恩",{39.4,81.8}}, -- 17121
			{"圣骑士训练师", "约尔",{38.4,82.2}}, -- 17509
			{"牧师训练师", "凯德莫斯",{38.8,51.0}}, -- 16756
			{"牧师训练师", "伊兹米尔",{40.0,52.0}}, -- 17510
			{"牧师训练师", "法尔拉特",{39.5,51.5}}, -- 17511
			{"萨满祭司训练师", "预言者努波顿",{30.2,32.4}}, -- 17204
			{"萨满祭司训练师", "苏兰",{32.9,24.2}}, -- 17219
			{"萨满祭司训练师", "霍巴肯",{35.0,8.2}}, -- 17519
			{"萨满祭司训练师", "古尔拉格",{24.2,39.7}}, -- 17520
			{"战士训练师", "安霍纳",{55.0,83.4}}, -- 16771
			{"战士训练师", "贝霍玛特",{55.3,82.0}}, -- 17120
			{"战士训练师", "卡兹",{56.8,84.2}}, -- 17504
		-- 商人
			{"埃索达军需官", "卡杜",{54.6,36.8}}, -- 50306
		-- 其他NPC
			{"公会注册员", "弗纳姆",{53.6,70.6}}, -- 16734
		-- 训练假人
			{"训练假人", "团队副本训练假人",{24.0,32.6}}, -- ?
			{"训练假人", "训练假人",{24.0,32.6}}, -- ?
		-- 交通工具
			{"传送门", "地狱火半岛;达纳苏斯",{48.1,62.3}},
		},

		-- [MISTS] Shrine of Seven Stars
		["七星殿"]={
		-- 拍卖师
			{"工程拍卖", "H.A.R.V.E.Y.",{57.4,51.8},3}, -- 65599
		-- 银行职员
			{"银行职员", "宝库管理者夏恩",{44.2,67.2},4}, -- 63967 -- 二层
			{"银行职员", "宝库管理者惜凡",{38.8,75.0},4}, -- 63968 -- 二层
			{"银行职员", "宝库管理者菲兹诺金",{40.6,80.6},4}, -- 63969 -- 二层
			{"银行职员", "宝库管理者梅尔卡",{46.2,69.8},4}, -- 63970 -- 二层
			{"银行职员", "宝库管理者贾库",{36.0,71.0},4}, -- 63971 -- 二层
			{"银行职员", "宝库管理者佩耶塔",{44.0,65.6},4}, -- 64023 -- 二层
			{"银行职员", "宝库管理者银掌",{45.2,68.8},4}, -- 64024	-- 二层
			{"工程仓库", "小罐头",{57.4,51.8},3}, -- 65596
		-- 旅店老板
			{"旅店老板", "瓦妮阿姨",{35.4,66.8},3}, -- 64149
		-- 专业训练师
			{"锻造训练师", "科伦·锤眉",{72.4,50.6},3}, -- 64085
			{"急救训练师", "治疗者楠",{45.0,62.4},3}, -- 64482
			{"工程学训练师", "工程学训练师",{57.4,51.8},3}, -- need update
		-- 商人
			--{"PvE装备商", "薇尔贝茨·欢哨",{41.6,42.6},4}, -- 74020 "随机副本商人" -- 二层
			--{"PvE装备商", "克拉丽丝·查普曼",{43.6,45.6},4}, -- 74021 "英雄副本商人" -- 二层
			--{"PvE装备商", "德里特·岩心",{42.6,43.6},4}, -- 74022 "团队副本商人" -- 二层
			--{"PvE装备商", "劳瑞·暖心",{43.6,47.6},4}, -- 74027 "史诗副本商人" -- 二层
			{"PvE装备商", "薇尔贝茨·欢哨;克拉丽丝·查普曼;德里特·岩心;劳瑞·暖心",{42.6,43.6},4}, -- 74020/74021/74022/74027
		-- 其他NPC
			{"奥术重铸师", "魔术师法拉凯特",{53.2,87.6},4}, -- 64045 -- 二层
		-- 交通工具
			{"传送门", "暴风城;铁炉堡;达纳苏斯;埃索达;达拉然;沙塔斯城",{70.1,40.2},4}, -- 二层
		},

		-- [WARLORDS] Stormshield
		["暴风之盾"]={
		-- 拍卖师
			{"拍卖师", "乔吉特·泰隆",{54.0,65.0}}, -- 85964
			{"拍卖师", "戴维·泰隆",{53.8,65.0}}, -- 86733
			{"拍卖师", "艾德瑞",{53.6,67.2}}, -- 88520
			{"拍卖师", "孔酒步",{54.4,67.2}}, -- 88522
		-- 银行职员
			{"银行职员", "诺兰·伯布里克",{55.2,48.2}}, -- 85957
			{"银行职员", "巴萨姆·燧眉",{54.4,49.2}}, -- 88468
			{"银行职员", "盖米尔·熔钢",{54.8,49.0}}, -- 88469
			{"银行职员", "德芬·汽距",{55.0,48.6}}, -- 88471
		-- 飞行管理员
			{"飞行管理员", "恩斯特·坦恩·博世",{30.8,48.8}}, -- 85959
		-- 旅店老板
			{"旅店老板", "加西亚·悦花",{35.4,77.6}}, -- 85956
		-- 兽栏管理员
			{"兽栏管理员", "奥维尔·曼弗雷德",{33.4,65.4}}, -- 85963
		-- 专业训练师
			{"炼金术训练师", "贾登·塔斯克",{36.6,69.2}}, -- 85905
			{"考古学训练师", "曼达·达洛维",{49.0,33.8}}, -- 85927
			{"锻造训练师", "艾米·金炉",{48.8,46.6}}, -- 85917
			{"烹饪训练师", "埃尔顿·布莱克",{35,76.6}}, -- 85925
			{"附魔训练师", "比尔·星酒",{56.4,64.6}}, -- 85914
			{"工程学训练师", "希尔达·铜丝",{47.6,40.4}}, -- 85918
			{"急救训练师", "特丽丝·护藤",{47.0,30.6}}, -- 85930
			{"钓鱼训练师", "奥斯汀·温德米尔",{55.6,77.8}}, -- 85926
			{"草药学训练师", "洁·野花",{37.2,69.4}}, -- 85921
			{"铭文训练师", "铭文师芝源",{62.8,34.0}}, -- 85911
			{"宝石加工训练师", "技师妮希亚",{43.8,34.2}}, -- 85916
			{"制皮训练师", "吉斯顿·锐羽",{52.0,42.4}}, -- 85920
			{"采矿训练师", "乔纳斯·链拳",{47.0,43.4}}, -- 85919
			{"剥皮训练师", "游侠兰顿",{51.8,42.6}}, -- 85923
			{"裁缝训练师", "约书亚·福斯汀",{51.0,37.0}}, -- 85910
			{"传送门训练师", "茱莉亚·瓦吉斯",{63.6,35.4}}, -- 88254
		-- 商人
			-- 军需官
			--{"PvP装备商", "布莱格·铜铸",{56.2,20.0}}, -- 86175 "荣誉军需官"
			--{"PvP装备商", "英格丽德·黑锭",{55.4,19.8}}, -- 86176 "征服军需官"
			--{"PvP装备商", "Alixandr Fallor",{54.8,18.8}}, -- 93905 "Elite Conquest Quartermaster" -- need translation
			--{"PvP装备商", "Slugg Spinbolt",{54.6,19.6}}, -- 93906 "Wild Honor Quartermaster" -- need translation
			--{"PvP装备商", "Amelia Clarke",{54.6,18.6}}, -- 93907 "Wild Conquest Quartermaster" -- need translation
			--{"PvP装备商", "Holly McTilla",{55.6,19.2}}, -- 93914 "Warmongering Conquest Quartermaster" -- need translation
			--{"PvP装备商", "Li Crunchpaw Tsang",{55.6,19.4}}, -- 93915 "Warmongering Honor Quartermaster" -- need translation
			{"PvP装备商", "布莱格·铜铸;英格丽德·黑锭,etc.",{56.2,20.0}}, -- 86175/86176/93905/93906/93907/93914/93915
			-- 派系
			--{"主教议会军需官", "守备官努瑞姆",{46.6,76.2}}, -- 85932
			--{"鸦人流亡者军需官", "暗影贤者巴考斯",{44.8,75.0}}, -- 85946
			--{"热砂军需官", "加兹瑞克斯·轮锁",{43.2,77.6}}, -- 88482
			{"军需官", "主教议会;鸦人流亡者;热砂",{46.6,76.2}}, -- 85932/85946/88482
			-- 其他
			{"图纸商人", "金凯德·加科布",{29.8,53.0}}, -- 85849
			--{"埃匹希斯商人", "觅晨者里拉克",{50.0,61.6}}, -- 86387 "埃匹希斯头盔商人"
			--{"埃匹希斯商人", "觅晨者维罗克",{49.6,61.6}}, -- 86389 "埃匹希斯斗篷商人"
			--{"埃匹希斯商人", "觅晨者瓦拉尔",{49.8,61.4}}, -- 86390 "埃匹希斯手套商人"
			--{"埃匹希斯商人", "觅晨者科雷克",{50.6,61.8}}, -- 86391 "埃匹希斯护腿商人"
			--{"埃匹希斯商人", "Dawn-Seeker Skelak",{49.6,61.8}}, -- 91321 "埃匹希斯护腕商人" -- need translation
			--{"埃匹希斯商人", "Dawn-Seeker Kasrek",{51.6,61.8}}, -- 92501 "埃匹希斯腰带商人" -- need translation
			{"埃匹希斯商人", "头盔;斗篷;手套;护腿;护腕;腰带",{50.0,61.6}}, -- 86387/86389/86390/86391/91321/92501
		-- 训练假人
			{"训练假人", "团队副本训练假人",{60.2,15.6}}, -- 87320
			{"训练假人", "训练假人",{58.6,17.6}}, -- 87321
			{"训练假人", "地下城训练假人",{59.0,18.8}}, -- 87322
			{"训练假人", "团队副本训练假人",{64.0,14.0}}, -- 87329
		-- 交通工具
			{"传送门", "暴风城-艾尔文森林",{61.2,38.7}},
			{"传送门", "铁炉堡-丹莫罗",{50.8,50.6}},
			{"传送门", "达纳苏斯-泰达希尔",{60.5,59.0}},
		},

		-- Orgrimmar
		["奥格瑞玛"]={
		-- 拍卖师
			{"拍卖师", "拍卖师索瓦特",{41.4,48.2}}, --  44787
			{"拍卖师", "拍卖师法兹德兰",{53.7,73.5}}, --  44865
			{"拍卖师", "拍卖师德雷泽米特",{54,73.5}}, --  44866
			{"拍卖师", "拍卖师拉林扎",{53.7,73.7}}, --  44867
			{"拍卖师", "拍卖师艾克斯法",{54.1,73.4}}, --  44868
			{"拍卖师", "拍卖师泽基",{33.1,65}}, --  45082
			{"拍卖师", "拍卖师芬卡",{37.3,78.7}}, --  45659
			{"拍卖师", "拍卖师德雷泽比特",{66.4,36.4}}, --  46637
			{"拍卖师", "拍卖师维兹普特",{66.9,36.1}}, --  46638
			{"拍卖师", "拍卖师兹尔比娜",{66.4,36.4}}, --  46639
			{"拍卖师", "拍卖师库薇",{66.8,36.2}}, --  46640
		-- 银行职员
			{"银行职员", "塔特比",{40,46.4}}, -- 44770
			{"银行职员", "里格吉兹",{48.7,84}}, -- 44852
			{"银行职员", "布兰兹利特",{48.4,83.3}}, -- 44853
			{"银行职员", "琪克萨",{48.4,83.7}}, -- 44854
			{"银行职员", "佩妮克萨",{49,83.6}}, -- 44856
			{"银行职员", "玛卡乌",{33.2,64.7}}, -- 45081
			{"银行职员", "泽瑞特",{38.2,78.4}}, -- 45661
			{"银行职员", "努佐",{38.2,78.4}}, -- 45662
			{"银行职员", "菲比",{67.8,52}}, -- 46618
			{"银行职员", "比妮泽拉",{67.7,53.1}}, -- 46619
			{"银行职员", "温克",{67.4,53.1}}, -- 46620
			{"银行职员", "庞克",{67.3,52.6}}, -- 46621
			--{"银行职员", "梅兹利克",{48.6,83.6}}, -- 72554
		-- 飞行管理员
			{"双足飞龙管理员", "多拉斯",{49.4,59.2}}, -- 3310
		-- 旅店老板
			{"旅店老板", "旅店老板格雷什卡",{53.4,78.8}}, -- 6929
			{"旅店老板", "米瓦娜",{39.0,48.6}}, -- 44785
			{"旅店老板", "希加姆比",{32.6,64.8}}, -- 45086
			{"旅店老板", "缇兹娜·银杯",{39.8,81.2}}, -- 45563
			{"旅店老板", "旅馆老板努法",{70.4,49.0}}, -- 46642
		-- 兽栏管理员
			{"兽栏管理员", "克苏卡",{32.6,64.8}}, -- 9988
			{"兽栏管理员", "伦托",{39.4,48.4}}, -- 44788
			{"兽栏管理员", "巴兹尔",{40.4,80.4}}, -- 45789
			{"兽栏管理员", "姆罗格",{62.0,35.2}}, -- 47764
		-- 专业训练师
			{"炼金术训练师", "耶尔玛克",{55.6,45.8}}, -- 3347
			{"考古学训练师", "贝洛克·辉刃",{49.0,70.6}}, -- 47571
			{"锻造训练师", "萨鲁·钢怒",{76.2,34.6}}, -- 3355
			{"锻造训练师", "莎伊斯·钢怒",{75.3,37.1}}, -- 7230
			{"锻造训练师", "克尔格鲁克·血斧",{76.0,37.2}}, -- 7231
			{"锻造训练师", "奥克索斯·铁怒",{75.4,34.2}}, -- 11177
			{"锻造训练师", "伯古什",{75.8,33.8}}, -- 11178
			{"锻造训练师", "罗格",{44.4,77.2}}, -- 37072
			{"锻造训练师", "奥普诺·铁角",{40.6,49.8}}, -- 44781
			{"锻造训练师", "卡尔克·碎盔者",{35.8,83.6}}, -- 45548
			{"烹饪训练师", "扎姆沙",{32.3,69.4}}, -- 3399
			{"烹饪训练师", "玛洛格",{56.6,62.6}}, -- 42506
			{"烹饪训练师", "扎尔博·碎肉饼",{39.0,85.8}}, -- 45550
			{"烹饪训练师", "阿露基",{56.2,61.6}}, -- 46709
			{"附魔训练师", "古丹",{53.4,49.4}}, -- 3345
			{"工程学训练师", "罗克希克",{56.8,56.4}}, -- 11017
			{"工程学训练师", "“杰克”·帕萨雷克·砸修",{36.4,86.6}}, -- 45545
			{"急救训练师", "科伦克·剁肢",{37.0,87.2}}, -- 45540
			{"钓鱼训练师", "鲁玛克",{66.6,41.6}}, -- 3332
			{"钓鱼训练师", "老恩姆贝托",{35.0,67.6}}, -- 44975
			{"飞行训练师", "玛奇萨",{49.0,59.2}}, -- 44919
			{"草药学训练师", "加迪",{34.5,63.5}}, -- 3404
			{"草药学训练师", "穆拉加",{54.4,50.4}}, -- 46741
			{"铭文训练师", "犹尔曼",{35.7,69.5}}, -- 30706
			{"铭文训练师", "内罗格",{55.2,55.8}}, -- 46716
			{"珠宝加工训练师", "鲁格娜",{72.4,34.4}}, -- 46675
			{"制皮训练师", "卡洛雷克",{60.8,54.8}}, -- 3365
			{"采矿训练师", "马卡鲁",{72.4,35}}, -- 3357
			{"采矿训练师", "古恩托",{44.6,78.4}}, -- 46357
			{"采矿训练师", "吉兹克·矿握",{36.0,82.8}},-- 52170
			{"骑术训练师", "基尔达",{61.4,34.4}}, -- 4752
			{"骑术训练师", "蕾薇·推杆",{36.6,87.0}}, -- 48513
			{"骑术训练师", "柔爪",{69.8,40.8}}, -- 70301
			{"剥皮训练师", "苏尔德",{61.0,54.6}}, -- 7088
			{"剥皮训练师", "雷恩托",{39.4,49.4}}, -- 44782
			{"裁缝训练师", "玛加尔",{60.6,59.0}}, -- 3363
			{"裁缝训练师", "希瓦希·三羽",{38.8,50.3}}, -- 44783
			{"裁缝训练师", "妮维·精编",{41.0,79.6}}, -- 45559
			{"恶魔训练师", "摩古尔",{51.8,40.6},2}, -- 88706 -- 暗影裂口
			{"传送门训练师", "观星者吉拉吉",{35.8,68.2}}, -- 45139
			{"传送门训练师", "朗多克",{46.2,66.6},2}, -- 47253 -- 暗影裂口
		-- 职业训练师
			{"德鲁伊训练师", "莎乌拉·白叶",{44.9,51.6}}, -- 44726
			{"德鲁伊训练师", "塞瑟比",{34.4,67.8}}, -- 44978
			{"猎人训练师", "奥玛克",{64,32.8}}, -- 3352
			{"猎人训练师", "诺希·平原行者",{44.8,52.9}}, -- 44743
			{"猎人训练师", "女猎人库扎莉",{34.4,74}}, -- 45023
			{"猎人训练师", "达克因·远狙",{39.4,82.4}}, -- 45713
			{"猎人训练师", "克尔拉",{63.4,32.9}}, -- 47767
			{"猎人训练师", "古尔多尔",{63.4,32.9}}, -- 47788
			{"法师训练师", "尤塞尔奈",{35.2,68.6}}, -- 7311
			{"法师训练师", "尤蕾达",{50,69.9},2}, -- 47246 -- 暗影裂口
			{"法师训练师", "玛鲁德",{49.2,66.8},2}, -- 47247 -- 暗影裂口
			{"法师训练师", "吉加",{48.2,69.5},2}, -- 47248 -- 暗影裂口
			{"法师训练师", "咒术师米克西莉",{40.1,80.7}}, -- 45714
			{"武僧训练师", "季·火掌",{68.8,39.6}}, -- 62445
			{"圣骑士训练师", "派雷亚诺",{49,71.8}}, -- 23128
			{"圣骑士训练师", "烈日行者阿托莫",{45.2,53.4}}, -- 44725
			{"牧师训练师", "先知利瓦萨",{45.4,53.4}}, -- 44735
			{"牧师训练师", "暗影行者祖鲁",{35.4,69.2}}, -- 45137
			{"牧师训练师", "提耶利斯",{49,71.7}}, -- 45337
			{"牧师训练师", "黑暗牧师塞希莉",{48.2,72.8}}, -- 45339
			{"牧师训练师", "圣银币修士",{37.4,87.2}}, -- 45347
			{"潜行者训练师", "盖斯特",{32.3,65.3},2}, -- 3327 -- 暗影裂口
			{"潜行者训练师", "奥莫克",{32.3,66},2}, -- 3328 -- 暗影裂口
			{"潜行者训练师", "戈达尔",{32.4,66},2}, -- 47233 -- 暗影裂口
			{"潜行者训练师", "夜行者库纳基",{32.2,63.6}}, -- 45095
			{"潜行者训练师", "潜行者维西",{39.8,80.9}}, -- 45717
			{"萨满祭司训练师", "萨祖",{39.0,47.7}}, -- 3403
			{"萨满祭司训练师", "萨格尼",{39.7,47.5}}, -- 13417
			{"萨满祭司训练师", "莎伊·云歌",{44.8,52}}, -- 44740
			{"萨满祭司训练师", "巫医尤姆布",{31.1,64.3}}, -- 45029
			{"萨满祭司训练师", "环境工程师林兹娜",{36.2,84.2}}, -- 45718
			{"萨满祭司训练师", "碎地者特加",{39.0,47.6}}, -- 72939
			{"术士训练师", "乌恩加里·邪语",{35.8,69.6}}, -- 45138
			{"术士训练师", "女巫卡兹拉莉",{40.6,80.2}}, -- 45720
			{"术士训练师", "格兰杜尔",{53.6,37.4},2}, -- 88704 -- 暗影裂口
			{"术士训练师", "卡诺什",{54.8,35.6},2}, -- 88705 -- 暗影裂口
			{"战士训练师", "格雷兹·怒拳",{73.3,45.4}}, -- 3353
			{"战士训练师", "索瑞克",{73.3,45.1}}, -- 3354
			{"战士训练师", "纳胡·怒蹄",{44.8,53.1}}, -- 44723
			{"战士训练师", "狂暴者曾迦",{34.3,74.5}}, -- 45019
			{"战士训练师", "卫兵贾尼克斯",{37.3,79.1}}, -- 45709
			{"战士训练师", "剑圣罗纳卡达",{73.2,45.3}}, -- 46667
		-- 商人
			-- 传说大厅
			--{"PvP装备商", "卫兵布莱恩·石皮",{38.2,72.6}}, -- 12793 荣耀印记 "杂货军需官"
			--{"PvP装备商", "石头守卫扎尔格",{38.6,72.8}}, -- 12794 "旧世界武器军需官"
			--{"PvP装备商", "一等军士长霍拉麦",{38.2,72.6}}, -- 12795 荣耀印记 "旧世界护甲军需官"
			--{"PvP装备商", "洛戈克",{37.8,71.6}}, -- 52033 荣耀印记 "嗜血角斗士Bloodthirsty"
			{"荣誉传家宝", "加尔拉",{38,70.8}}, -- 52036 荣耀印记 "荣誉传家宝"
			--{"PvP装备商", "桃丽丝·沃兰休斯",{38.8,69.8}}, -- 54657 荣耀印记 "残忍角斗士Vicious"
			--{"PvP装备商", "血卫士扎尔什",{38.2,70.4}}, --69977 荣耀印记 "冷酷角斗士Ruthless"
			--{"PvP装备商", "雷角中士",{38.6,70.0}}, --69978 荣耀印记 "灾变角斗士Cataclysmic"
			{"PvP装备商", "旧世界武器护甲;战争坐骑;S9L;S9H;S10;S11",{37.8,71.6}}, -- 12793/12794/12795|12796/73151|52033/54657/69977/69978
			-- 传说大厅门外
			--{"战争坐骑军需官", "狼骑兵波尔克",{41.8,73.6}}, -- 12796 荣耀印记 "战争坐骑军需官"
			--{"战争坐骑军需官", "亡灵卫兵奈萨里安",{41.8,73.0}}, -- 73151 邪气鞍座 "战争坐骑军需官"
			-- 格罗玛什要塞顶部
			--{"PvE装备商", "贡娜",{48.4,71.6}}, -- 46555 "正义军需官"
			--{"PvE装备商", "杰姆斯瓦兹",{48.6,71.4}}, -- 46556 "勇气军需官"
			--{"PvE装备商", "鲁戈克",{48.2,71.6}}, -- 58155 "传承正义军需官"
			{"PvE装备商", "贡娜;杰姆斯瓦兹;鲁戈克",{48.4,71.6}}, -- 46555/46556/58155
			-- 派系
			--{"锈水财阀军需官", "弗里兹·维拉马尔",{49.8,58.6}}, -- 50323
			--{"暗矛军需官", "勇士乌拉金",{50.0,58.6}}, -- 50477
			--{"奥格瑞玛军需官", "石头守卫纳尔戈尔",{50.0,58.6}}, -- 50488
			{"军需官", "奥格瑞玛;锈水财阀;暗矛",{50.0,58.6}}, -- 50323/50477/50488
			{"火金派军需官", "门徒君思",{68.6,40.6}}, -- 69333
			-- 其他
			{"大地的裂变时空漫游商人", "琪雅科",{52.0,41.6}}, -- 101759
			-- 恶魔入侵
			{"恶魔入侵军需官", "被俘的虫语者",{52.6,57.6}}, -- 109912
		-- 其他NPC
			{"公会注册员", "乌特伦",{48.6,76.2}}, -- 3370
			{"理发师", "贝布莉·科弗库尔",{40.2,60.8}}, -- 29143
			{"奥术重铸师", "魔术师扎吉尔",{57.8,65.6}}, -- 54471
		-- 训练假人
			{"训练假人", "训练假人",{73.6,47.4}}, -- 31144
			{"训练假人", "团队副本训练假人",{64.6,33.0}}, -- 31146
			{"训练假人", "团队副本训练假人",{61.4,45.4}}, -- 31146
			{"训练假人", "团队副本训练假人",{73.6,46.0}}, -- 31146
			{"训练假人", "训练假人",{73.6,43.8}}, -- 32666
			{"训练假人", "训练假人",{76.0,43.4}}, -- 32667
			{"训练假人", "训练假人",{63.6,34.2}}, -- 46647
			{"训练假人", "训练假人",{63.6,49.2}}, -- 46647
			{"训练假人", "训练假人",{73.8,43.8}}, -- 46647
		-- 交通工具
			{"传送门", "蜜露村",{68.8,39.6}},
			{"传送门", "托尔巴拉德半岛;深岩之洲;瓦斯琪尔;暮光高地;海加尔山;奥丹姆",{50.0,37.8}},
			{"传送门", "地狱火半岛;诅咒之地",{35.8,69.0}},
			{"传送门", "阿什兰",{47.6,72.2}},
			{"入口", "搏击竞技场",{70.5,31.0}},
			{"飞艇", "雷霆崖;战歌要塞",{43.8,63.5}},
			{"飞艇", "提瑞斯法林地;格罗姆高营地",{51.5,54.4}},
		},

		-- Silvermoon City
		["银月城"]={
		-- 拍卖师
			{"拍卖师", "拍卖师伊西利安",{92.6,58.2}}, -- 16627
			{"拍卖师", "拍卖师塞多里",{92.4,59.2}}, -- 16628
			{"拍卖师", "拍卖师坦德隆",{93.0,57.0}}, -- 16629
			{"拍卖师", "拍卖师耶纳斯",{59.8,62.6}}, -- 17627
			{"拍卖师", "拍卖师维纳",{60.6,63.6}}, -- 17628
			{"拍卖师", "拍卖师菲恩娜",{61.4,62.4}}, -- 17629
			{"拍卖师", "拍卖师达莉丝",{60.4,61.7}}, -- 18761
		-- 银行职员
			{"银行职员", "诺维娅",{89.0,43.2}}, -- 16615
			{"银行职员", "彼雷尔",{89.7,43.2}}, -- 16616
			{"银行职员", "黛妮丝",{90.4,43.2}}, -- 16617
			{"银行职员", "希尔拉",{67.4,77.9}}, -- 17631
			{"银行职员", "伊尔拉娜",{67.4,79.1}}, -- 17632
			{"银行职员", "哈瑟恩",{67.4,76.7}}, -- 17633
		-- 旅店老板
			{"旅店老板", "旅店老板维兰德拉",{79.6,58.2}}, -- 16618
			{"旅店老板", "旅店老板约维娅",{67.6,73.0}}, -- 17630
		-- 兽栏管理员
			{"兽栏管理员", "沙尔蕾恩",{83.4,30.4}}, -- 16656
		-- 专业训练师
			{"炼金术训练师", "卡博隆",{66.8,18.0}}, -- 16642
			{"考古学训练师", "埃莱娜拉",{81.3,63.3}}, -- 47346
			{"锻造训练师", "波玛尔",{79.4,39.0}}, -- 16669
			{"附魔训练师", "瑟丹娜",{69.4,24.3}}, -- 16633
			{"工程学训练师", "丹文",{76.3,40.6}}, -- 16667
			{"急救训练师", "埃雷图斯",{77.2,70.4}}, -- 16662
			{"钓鱼训练师", "德拉森",{76.4,68.0}}, -- 16780
			{"草药学训练师", "植物学家娜萨兰",{67.4,17.9}}, -- 16644
			{"铭文训练师", "赞塔希娅",{69.0,24.8}}, -- 30710
			{"珠宝加工训练师", "卡琳达",{90.6,73.8}}, -- 19775
			{"制皮训练师", "莱纳里斯",{84.9,80.6}}, -- 16688
			{"采矿训练师", "比利尔",{79.0,42.8}}, -- 16663
			{"剥皮训练师", "提恩",{84.1,79.6}}, -- 16692
			{"裁缝训练师", "基伦·希斯",{56.8,50.9}}, -- 16640
			{"恶魔训练师", "托利安",{74.6,44.4}}, -- 16649
			{"传送门训练师", "纳林斯",{57.4,21.0}}, -- 16654
		-- 职业训练师
			{"德鲁伊训练师", "哈雷尼·平原行者",{71.6,56.8}}, -- 16655
			{"猎人训练师", "塔纳",{82.5,26.4}}, -- 16672
			{"猎人训练师", "欧尼纳斯",{84.2,26.5}}, -- 16673
			{"猎人训练师", "桑迪恩",{84.4,28.0}}, -- 16674
			{"法师训练师", "塞伊丹纳",{57.3,19.2}}, -- 16651
			{"法师训练师", "奎恩萨斯",{58.3,18.6}}, -- 16652
			{"法师训练师", "伊尼文",{58.4,19.3}}, -- 16653
			{"武僧训练师", "睿智的肖恩",{83.6,39.8}}, -- 62463
			{"圣骑士训练师", "欧塞兰",{91.3,38.3}}, -- 16679
			{"圣骑士训练师", "伊瑟里斯",{91.3,36.1}}, -- 16680
			{"圣骑士训练师", "勇士巴卡希",{91.5,36.2}}, -- 16681
			{"牧师训练师", "奥德兰",{53.3,26.6}}, -- 16658
			{"牧师训练师", "洛塞兰",{55.2,26.4}}, -- 16659
			{"牧师训练师", "贝蕾丝特拉",{54.0,28.2}}, -- 16660
			{"潜行者训练师", "瑟兰尼斯",{78.9,52.1}}, -- 16684
			{"潜行者训练师", "艾尔兰拉",{79.4,49.0}}, -- 16685
			{"潜行者训练师", "奈里森",{78.7,50.4}}, -- 16686
			{"萨满祭司训练师", "吉兹利",{71.8,56.8}}, -- 16661
			{"术士训练师", "奥拉玛",{73.2,46.8}}, -- 16646
			{"术士训练师", "塔莱尼娅",{73.7,47.5}}, -- 16647
			{"术士训练师", "萨尼恩",{73.2,45.3}}, -- 16648
			{"战士训练师", "捍卫者阿尔苏达",{80.4,37.2}}, -- 43009
			{"战士训练师", "萨瑞瑟娜",{80.3,36.8}}, -- 44128
			{"战士训练师", "贝尔迪斯",{80.4,38.0}}, -- 44129
		-- 其他NPC
			{"公会注册员", "坦德莉恩",{78.4,84.6}}, -- 16568
		-- 训练假人
			{"训练假人", "训练假人",{82.2,35.4}}, -- 31144
			{"训练假人", "团队副本训练假人",{82.6,37.8}}, -- 31146
			{"训练假人", "训练假人",{83.0,37.0}}, -- 32667
		-- 交通工具
			{"传送门", "地狱火半岛",{58.4,21.0}},
			{"传送宝珠", "洛丹伦废墟-提瑞斯法林地",{49.3,15.0}},
		},

		-- Thunder Bluff
		["雷霆崖"]={
		-- 拍卖师
			{"拍卖师", "拍卖师斯塔比",{40.4,52.2}}, -- 8674
			{"拍卖师", "拍卖师古雷姆",{39.0,50.6}}, -- 8722
		-- 银行职员
			{"银行职员", "托恩",{46.8,58.4}}, -- 2996
			{"银行职员", "彻斯姆",{46.4,58.4}}, -- 8356
			{"银行职员", "阿特帕",{46.4,58.8}}, -- 8357
		-- 飞行管理员
			{"双足飞龙管理员", "塔尔",{46.8,49.8}}, -- 2995
		-- 旅店老板
			{"旅店老板", "旅店老板帕拉",{45.4,64.2}}, -- 6746
		-- 兽栏管理员
			{"兽栏管理员", "布尔鲁格",{45.0,59.6}}, -- 10054
		-- 专业训练师
			{"炼金术训练师", "本娜·冰蹄",{46.8,33.4}}, -- 3009
			{"考古学训练师", "欧托·灰皮",{75.3,28.2}}, -- 47572
			{"锻造训练师", "卡恩·石蹄",{40.0,55.6}}, -- 2998
			{"烹饪训练师", "阿丝卡·迷雾行者",{51.0,52.8}}, -- 3026
			{"附魔训练师", "泰戈·晨行者",{45.2,39.1}}, -- 3011
			{"工程学训练师", "工程师苍蹄",{36.4,59.6}}, -- 52651
			{"急救训练师", "潘德·缚石",{29.3,21.0}}, -- 2798
			{"钓鱼训练师", "卡尔·迷雾行者",{55.8,47.6}}, -- 3028
			{"草药学训练师", "克米恩·冰蹄",{49.3,39.5}}, -- 3013
			{"铭文训练师", "波什金·哈比德尔",{28.8,20.6}}, -- 30709
			{"珠宝加工训练师", "娜哈莉·追云者",{35.6,53.8}}, -- 52657
			{"制皮训练师", "犹纳",{41.8,42.8}}, -- 3007
			{"采矿训练师", "布瑞克·石蹄",{34.7,57.6}}, -- 3001
			{"剥皮训练师", "莫兰塔",{44.6,42.8}}, -- 7089
			{"裁缝训练师", "坦帕",{44.2,45.0}}, -- 3004
			{"传送门训练师", "比尔吉特·克兰斯顿",{22.0,17.5}}, -- 5957
		-- 职业训练师
			{"德鲁伊训练师", "图拉克·符文图腾",{76.3,27.4}}, -- 3033
			{"德鲁伊训练师", "希尔·符文图腾",{77.0,28.0}}, -- 3034
			{"德鲁伊训练师", "凯姆·蛮鬃",{76.3,31.0}}, -- 3036
			{"猎人训练师", "卡瑞·雷角",{58.4,88.0}}, -- 3038
			{"猎人训练师", "浩特·雷角",{57.4,89.2}}, -- 3039
			{"猎人训练师", "乌瑞克·雷角",{58.7,85.6}}, -- 3040
			{"法师训练师", "大法师山姆",{22.8,14.2}}, -- 3047
			{"法师训练师", "奥松·格鲁尔",{25.8,21.6}}, -- 3048
			{"法师训练师", "瑟斯顿·科萨恩",{27.2,16.6}}, -- 3049
			{"武僧训练师", "宁神花茶大师冉瑟",{22.6,19.2}}, -- 62462
			{"圣骑士训练师", "烈日行者赛恩",{63.0,79.8}}, -- 8664
			{"圣骑士训练师", "烈日行者莱哈",{62.4,79.5}}, -- 43001
			{"圣骑士训练师", "奥伯妮·亮鬃",{63.2,79.8}}, -- 43795
			{"牧师训练师", "麦尔斯·威尔什",{22.0,17.6}}, -- 3044
			{"牧师训练师", "马拉凯·克罗斯",{24.4,22.1}}, -- 3045
			{"牧师训练师", "柯布神父",{24.9,20.5}}, -- 3046
			{"牧师训练师", "先知卡雅",{77.8,27.9}}, -- 43004
			{"牧师训练师", "塔胡·慧风",{77.3,31.1}}, -- 43796
			{"牧师训练师", "绿石先知",{75.4,28.5}}, -- 43870
			{"萨满祭司训练师", "希恩·逐星",{22.8,20.7}}, -- 3030
			{"萨满祭司训练师", "提戈尔·逐星",{23.3,18.4}}, -- 3031
			{"萨满祭司训练师", "博拉姆·逐星",{22.2,19.3}}, -- 3032
			{"术士训练师", "迪拉诺·莫里赛特",{25.3,14.1}}, -- 43881
			{"术士训练师", "扬森·托马森",{25.3,14.2}}, -- 43883
			{"术士训练师", "莫莱拉妮亚·荷尔登",{24.2,15.5}}, -- 43892
			{"战士训练师", "托姆·暴怒图腾",{57.2,88.1}}, -- 3041
			{"战士训练师", "萨尔克·暴怒图腾",{57.3,88.9}}, -- 3042
			{"战士训练师", "科尔·暴怒图腾",{57.9,85.8}}, -- 3043
		-- 商人
			{"雷霆崖军需官", "卫兵图霍",{46.8,50.0}}, -- 50483
		-- 其他NPC
			{"公会注册员", "克拉姆",{37.6,63.0}}, -- 5054
		-- 训练假人
			{"训练假人", "训练假人",{57.0,79.8}}, -- 32666
		-- 交通工具
			{"传送门", "地狱火半岛",{30.8,31.7}},
			{"飞艇", "奥格瑞玛-杜隆塔尔",{15.7,25.7}},
		},

		-- Undercity
		["幽暗城"]={
		-- 拍卖师
			{"拍卖师", "拍卖师里卡",{67.8,52.2}}, -- 8672
			{"拍卖师", "拍卖师埃比图",{64.0,52.2}}, -- 8721
			{"拍卖师", "拍卖师斯托克顿",{71.2,47.0}}, -- 15675
			{"拍卖师", "拍卖师亚尔利",{71.4,41.4}}, -- 15676
			{"拍卖师", "拍卖师凯恩",{67.8,36.0}}, -- 15682
			{"拍卖师", "拍卖师纳克雷米斯",{64.0,36.0}}, -- 15683
			{"拍卖师", "拍卖师特里特",{60.6,41.2}}, -- 15684
			{"拍卖师", "拍卖师雷克尔",{60.6,46.8}}, -- 15686
		-- 银行职员
			{"银行职员", "伦道夫·蒙泰古",{66.0,43.0}}, -- 2458
			{"银行职员", "摩塔莫尔·蒙泰古",{66.8,44.0}}, -- 2459
			{"银行职员", "威廉·蒙泰古",{65.8,45.2}}, -- 4549
			{"银行职员", "奥芬利亚·蒙泰古",{65.2,44.0}}, -- 4550
		-- 飞行管理员
			{"蝙蝠管理员", "迈克尔·加勒特",{63.0,48.2}}, -- 4551
		-- 旅店老板
			{"旅店老板", "旅店老板诺曼",{67.6,38.2}}, -- 6741
		-- 兽栏管理员
			{"兽栏管理员", "安雅·玛尔雷",{67.8,38.6}}, -- 10053
		-- 专业训练师
			{"炼金术训练师", "赫伯特·哈尔希医生",{47.4,72.2}}, -- 4611
			{"考古学训练师", "亚当·霍萨克",{75.8,37.2}}, -- 47382
			{"锻造训练师", "詹姆斯·范·布朗特",{61.2,29.1}}, -- 4596
			{"烹饪训练师", "尤奈斯·伯奇",{63.6,9.0}}, -- 4552
			{"附魔训练师", "拉文尼亚·克洛文",{61.8,61.0}}, -- 4616
			{"工程学训练师", "弗兰克林·洛伊德",{76.0,73.6}}, -- 11031
			{"急救训练师", "玛丽·艾塔斯",{73.4,55.6}}, -- 4591
			{"钓鱼训练师", "阿曼德·克伦威尔",{81.0,31.2}}, -- 4573
			{"草药学训练师", "马尔萨·奥列斯塔",{54.0,49.4}}, -- 4614
			{"铭文训练师", "玛尔迦丝·帕克雷",{61.6,58.6}}, -- 30711
			{"珠宝加工训练师", "内勒尔·费恩",{56.2,36.6}}, -- 52587
			{"制皮训练师", "亚瑟·摩尔",{70.2,58.6}}, -- 4588
			{"采矿训练师", "布罗姆·基里安",{56.0,37.0}}, -- 4598
			{"剥皮训练师", "基里安·哈根",{70.4,59.2}}, -- 7087
			{"裁缝训练师", "乔瑟夫·格里高利",{70.8,30.0}}, -- 4576
			{"裁缝训练师", "约瑟芬·李斯特",{86.4,22.4}}, -- 4578
			{"恶魔训练师", "马尔萨·斯坦恩",{85.8,15.4}}, -- 5753
			{"传送门训练师", "莱克斯顿·莫泰姆",{83.3,15.6}}, -- 2492
		-- 职业训练师
			{"德鲁伊训练师", "玛拉·天卫",{55.0,50.6}}, -- 52319
			{"猎人训练师", "阿波罗斯",{49.2,29.8}}, -- 39116
			{"猎人训练师", "纳萨诺斯·凋零者",{50.0,28.4}}, -- 50609
			{"法师训练师", "凯利斯蒂亚",{85.8,14.2}}, -- 4566
			{"法师训练师", "皮尔斯·沙克尔顿",{85.6,14.8}}, -- 4567
			{"法师训练师", "安娜斯塔西娅·哈特威尔",{85.6,11.0}}, -- 4568
			{"法师训练师", "不死者德尔勒克",{56.6,17.6}}, -- 23103
			{"武僧训练师", "简傲",{56.8,33.2}}, -- 62393
			{"圣骑士训练师", "塞希娅·黎明玫瑰",{57.8,91.6}}, -- 20406
			{"牧师训练师", "艾萨莱斯特",{49.6,17.0}}, -- 4606
			{"牧师训练师", "兰克斯特神父",{50.0,14.7}}, -- 4607
			{"牧师训练师", "拉札鲁斯神父",{47.6,19.2}}, -- 4608
			{"潜行者训练师", "卡罗琳·瓦德",{83.8,73.6}}, -- 4582
			{"潜行者训练师", "迈尔斯·迪克斯特",{85.0,71.6}}, -- 4583
			{"潜行者训练师", "格雷戈·查尔斯",{85.2,72.4}}, -- 4584
			{"萨满训练师", "玛哈拉·云歌",{55.0,50.6}}, -- 52317
			{"术士训练师", "卡尔·噬灵",{85.3,15.3}}, -- 4563
			{"术士训练师", "卢瑟·匹克曼",{86.1,15.5}}, -- 4564
			{"术士训练师", "理查德·科尔文",{88.1,16.8}}, -- 4565
			{"战士训练师", "克里斯托弗·沃克",{46.8,16.5}}, -- 4593
			{"战士训练师", "安吉拉·科萨斯",{47.9,15.5}}, -- 4594
			{"战士训练师", "巴尔图斯·弗勒",{46.4,17.6}}, -- 4595
		-- 商人
			{"传家宝商人", "艾斯特蕾·根德瑞",{78.2,76.6}}, -- 6566
			{"幽暗城军需官", "多纳尔德·亚当斯上尉",{63.6,48.8}}, -- 50304
		-- 其他NPC
			{"公会注册员", "克里斯托弗·德库尔",{69.4,44.2}}, -- 4613
			{"理发师", "纳兹尼克·苏萨弗",{71.0,47.2}}, -- 29139
		-- 训练假人
			{"训练假人", "团队副本训练假人",{54.4,17.7}}, -- ?
			{"训练假人", "训练假人",{55.4,17.2}}, -- 31144
			{"训练假人", "训练假人",{55.4,16.0}}, -- 32666
		-- 交通工具
			{"传送门", "地狱火半岛",{85.3,17.1}},
		},

		-- Shrine of Two Moons
		["双月殿"]={
		-- 拍卖师
			{"工程拍卖", "D.E.N.T.",{59.4,43.2},1}, -- 67130
		-- 银行职员
			{"银行职员", "宝库管理者韩恩",{21.4,47.4},2}, -- 63964 -- 二层
			{"银行职员", "宝库管理者金硬币",{23.0,54.8},2}, -- 63965 -- 二层
			{"银行职员", "宝库管理者诗风",{22.8,62.2},2}, -- 63966 -- 二层
			{"工程仓库", "提维里克斯·本高特",{61.0,44.4},1}, -- 64925
		-- 旅店老板
			{"旅店老板", "薇洛夫人",{69.2,49.0},1}, -- 62996
			{"旅店老板", "酒仙司柯叶",{59.8,75.2},2}, -- 63008
		-- 专业训练师
			{"锻造训练师", "贾鲁高·石蹄",{26.2,45.6},1}, -- 64058
			{"工程学训练师", "古约·晶轮",{60.8,44.0},1}, -- 64924
			{"急救训练师", "艾拉西尼尔",{29.6,74.2},1}, -- 65862
		-- 商人
			--{"PvE装备商", "布里兹克·火刀",{43.2,74.4},2}, -- 73674 "随机副本商人" -- 二层
			--{"PvE装备商", "纳迪娜·星晶",{43.4,76.0},2}, -- 74010 "团队副本商人" -- 二层
			--{"PvE装备商", "奇阿戈努",{43.8,77.8},2}, -- 74012 "英雄副本商人" -- 二层
			--{"PvE装备商", "图阿霍·开山",{43.8,80.2},2}, -- 74019 "史诗副本商人" -- 二层
			{"PvE装备商", "布里兹克·火刀;图阿霍·开山;奇阿戈努;纳迪娜·星晶",{43.8,77.8},2}, -- 73674/74010/74012/74019
		-- 其他NPC
			{"奥术重铸师", "魔术师安裘尔",{63.6,19.6},2}, -- 64044 -- 二层
		-- 交通工具
			{"传送门", "奥格瑞玛;雷霆崖;幽暗城;银月城;达拉然;沙塔斯城",{69.8,45.0},2}, -- 二层
		},

		-- Warspear
		["战争之矛"]={
		-- 拍卖师
			{"拍卖师", "瑞拉·明棘",{54.2,25.6}}, -- 86635
			{"拍卖师", "夏安·幼蹄",{54.8,25}}, -- 88128
			{"拍卖师", "肖恩·幼蹄",{54.8,26.2}}, -- 88130
			{"拍卖师", "Torm Ironfur",{54.4,25.6}}, -- 88133 -- need translation
		-- 银行职员
			{"银行职员", "塔恩·赤拳",{51.6,61.6}}, -- 86631
			{"银行职员", "乌瑞拉·血石",{52.0,62.4}}, -- 88143
			{"银行职员", "法兰·铜库",{51.6,61.2}}, -- 88451
			{"银行职员", "罗伊·碎螺",{52.2,62.6}}, -- 88453
		-- 飞行管理员
			{"飞行管理员", "伊拉鲁",{44.2,34.2}}, -- 86049
		-- 旅店老板
			{"旅店老板", "娜宁·晨光",{44.8,43.6}}, -- 86307
		-- 兽栏管理员
			{"兽栏管理员", "乌佳",{77.2,59}}, -- 86052
		-- 专业训练师
			{"炼金术训练师", "克里斯托弗·柯西",{60.8,27.0}}, -- 86009
			{"考古学训练师", "丽娜·碎轮",{73.4,30.8}}, -- 86033
			{"锻造训练师", "马兹顿·商齿",{74.4,37.0}}, -- 86048
			{"烹饪训练师", "盖伊·火眼",{45.2,44.2}}, -- 86029
			{"附魔训练师", "哈尼克",{78.4,52.6}}, -- 86027
			{"工程学训练师", "汉·跳箭",{71.4,40.2}}, -- 86012
			{"急救训练师", "威恩·妙手",{65.2,51.4}}, -- 86034
			{"钓鱼训练师", "布里克斯·箭投",{69.4,16.4}}, -- 86628
			{"草药学训练师", "安东尼·阿里安",{62.2,30.4}}, -- 86006
			{"铭文训练师", "乔鲁曼",{76.8,48.0}}, -- 86015
			{"宝石加工训练师", "亚历山大·迅钢",{60.0,40.2}}, -- 86010
			{"制皮训练师", "布尔加·硬皮",{50.0,28.2}}, -- 86032
			{"采矿训练师", "姆格·石裂",{76.6,38.0}}, -- 86014
			{"剥皮训练师", "孔达尔·猎誓",{49.0,31.6}}, -- 86028
			{"裁缝训练师", "塞莎·银血",{59.0,42.6}}, -- 86004
			{"传送门训练师", "萨麦尔·玫刃",{59.2,50.6}}, -- 88255
		-- 商人
			-- 军需官
			--{"PvP装备商", "碎拳中尉",{48.8,57.3}}, -- 87774 荣耀印记 "Primal Honor"
			--{"PvP装备商", "斩斧中尉",{48.8,56.6}}, -- 88569 荣耀印记 "Primal Conquest"
			--{"PvP装备商", "Fobbly Kickfix",{49.2,56.8}}, -- 93908 荣耀印记 "Wild Honor Quartermaster" -- need translation
			--{"PvP装备商", "Cladd Dawnstrider",{49.2,56.4}}, -- 93909 荣耀印记 "Wild Conquest Quartermaster" -- need translation
			--{"PvP装备商", "Legionnaire Gutcrush",{49.0,57.2}}, -- 93911/93912 荣耀印记 "Elite Conquest Quartermaster" -- need translation
			--{"PvP装备商", "Tae'loxe Soulshrivel",{49.0,57.0}}, -- 93916 荣耀印记 "Warmongering Honor Quartermaster" -- need translation
			--{"PvP装备商", "Malukah Lightsong",{49.0,57.2}}, -- 93917 荣耀印记 "Warmongering Conquest Quartermaster" -- need translation
			{"PvP装备商", "碎拳中尉;斩斧中尉,etc.",{48.8,57.3}}, -- 87774/88569/93908/93909/93911/93912/93916/93917
			-- 派系
			--{"鸦人流亡者军需官", "暗影贤者巴考斯",{53.6,60.2}}, -- 85946
			--{"霜狼氏族军需官", "贝斯卡·赤牙",{53.6,62.0}}, -- 86036
			--{"热砂军需官", "米米·响泡",{53.8,60.8}}, -- 88493
			{"军需官", "霜狼氏族;鸦人流亡者;热砂",{53.8,60.8}}, -- 85946/86036/88493
			-- 其他
			{"图纸商人", "托格·菲力克辛顿",{42.8,36.6}}, -- 85840
			--{"埃匹希斯商人", "觅晨者科里克",{66.6,63.8}}, -- 86376 "埃匹希斯头盔商人"
			--{"埃匹希斯商人", "觅晨者吉克拉",{66.6,63.6}}, -- 86378 "埃匹希斯斗篷商人"
			--{"埃匹希斯商人", "觅晨者利克斯",{65.8,64.6}}, -- 86379 "埃匹希斯手套商人"
			--{"埃匹希斯商人", "觅晨者阿克赛特",{65.6,64.6}}, -- 86382 "埃匹希斯护腿商人"
			--{"埃匹希斯商人", "Dawn-Seeker Kayrek",{65.6,64.2}}, -- 91322 "埃匹希斯护腕商人" -- need translation
			--{"埃匹希斯商人", "Dawn-Seeker Skariss",{66.2,62.8}}, -- 92503 "埃匹希斯腰带商人" -- need translation
			{"埃匹希斯商人", "头盔;斗篷;手套;护腿;护腕;腰带",{66.6,63.8}}, -- 86376/86378/86379/86382/91322/92503
		-- 训练假人
			{"训练假人", "团队副本训练假人",{70.0,57.2}}, -- 87762
			{"训练假人", "训练假人",{69.0,58.6}}, -- 88835
			{"训练假人", "地下城训练假人",{69.4,56.0}}, -- 88836
			{"训练假人", "团队副本训练假人",{68.8,57.0}}, -- 88837
		-- 交通工具
			{"传送门", "奥格瑞玛-杜隆塔尔",{59.9,52.1}},
			{"传送门", "雷霆崖-莫高雷",{50.6,23.6}},
			{"传送门", "幽暗城-提瑞斯法林地",{62.5,22.8}},
		},

		-- [BC] Shattrath City
		["沙塔斯城"]={
		-- 拍卖师
			{"拍卖师", "拍卖师卡拉伦",{56.9,62.4}}, -- 50139
			{"拍卖师", "拍卖师莱尔莎拉",{56.9,62.4}}, -- 50140
			{"拍卖师", "拍卖师伊托兰",{50.8,26.6}}, -- 50143
			{"拍卖师", "拍卖师布拉库",{51.2,27.2}}, -- 50145
		-- 银行职员
			{"奥尔多银行职员", "门度恩",{47.8,29.0}}, -- 19034
			{"占星者银行职员", "比鲁达·秘誓",{60.2,60.6}}, -- 19246
			{"奥尔多银行职员", "格鲁登",{48.2,29.0}}, -- 19318
			{"占星者银行职员", "鲁拉·金刺",{59.8,60.6}}, -- 19338
		-- 飞行管理员
			{"飞行管理员", "努特拉尔",{63.8,41.0}}, -- 18940
		-- 旅店老板
			{"奥尔多旅店老板", "米娜蕾",{28.0,49.2}}, -- 19046
			{"占星者旅店老板", "旅店老板海索恩",{55.8,80.8}}, -- 19232
		-- 兽栏管理员
			{"占星者兽栏管理员", "伊苏瑞尔",{56.6,79.6}}, -- 21517
			{"奥尔多兽栏管理员", "奥尔鲁赫",{28.4,47.4}}, -- 21518
		-- 专业训练师
			{"炼金术训练师", "罗罗基姆",{45.8,20.4}}, -- 19052
			{"占星者炼金术训练师", "埃尔辛",{38.6,71.8}}, -- 33630
			{"奥尔多炼金术训练师", "炼金师卡恩胡",{39.2,29.4}}, -- 33674
			{"考古学训练师", "搜寻者波杜鲁",{62.6,70.0}}, -- 47575
			{"锻造训练师", "克拉度·利刃",{69.8,42.4}}, -- 20124
			{"锻造训练师", "祖拉·熔怒",{69.8,42.2}}, -- 20125
			{"占星者锻造训练师", "巴利尔",{43.6,65.2}}, -- 33631
			{"奥尔多锻造训练师", "奥努度",{37.6,31.2}}, -- 33675
			{"烹饪训练师", "杰克·塔博尔",{62.8,68.4}}, -- 19185
			{"烹饪训练师", "凯蕾妮",{74.8,31.2}}, -- 19186
			{"占星者附魔训练师", "附魔师沃拉莉",{43.6,92.4}}, -- 19251
			{"占星者附魔训练师", "高阶附魔师巴尔杜兰",{43.1,92.4}}, -- 19252
			{"占星者附魔训练师", "附魔师安蒂亚拉",{56.2,74.4}}, -- 33633
			{"奥尔多附魔训练师", "苏蕾",{36.4,44.6}}, -- 33676
			{"占星者工程学训练师", "工程师辛蓓",{43.6,65.2}}, -- 33634
			{"奥尔多工程学训练师", "技师米希拉",{37.6,31.6}}, -- 33677
			{"急救训练师", "米尔蕾·弗莱彻尔",{66.6,13.6}}, -- 19184
			{"占星者草药学训练师", "草药学家奥莱拉",{38.3,72.0}}, -- 33639
			{"奥尔多草药学训练师", "吉嘉",{38.2,30.0}}, -- 33678
			{"占星者铭文训练师", "抄写员兰罗尔",{56.6,74.5}}, -- 33638
			{"奥尔多铭文训练师", "记录员利迪欧",{36.2,44.6}}, -- 33679
			{"奥尔多珠宝加工训练师", "哈曼纳尔",{35.8,20.6}}, -- 19063
			{"占星者珠宝加工训练师", "吉蕾布莉·银丝",{58.6,75.2}}, -- 33637
			{"奥尔多珠宝加工训练师", "奈米哈",{36.2,47.0}}, -- 33680
			{"制皮训练师", "达尔玛里",{67.2,67.0}}, -- 19187
			{"占星者制皮训练师", "戴恩瑞尔",{41.9,63.8}}, -- 33635
			{"奥尔多制皮训练师", "库里姆",{37.5,28.6}}, -- 33681
			{"占星者采矿训练师", "韩里尔",{58.1,75.0}}, -- 33640
			{"奥尔多采矿训练师", "弗诺",{36.0,48.4}}, -- 33682
			{"剥皮训练师", "塞莫尔",{64.6,66.2}}, -- 19180
			{"占星者剥皮训练师", "伊尔杜",{40.9,63.4}}, -- 33641
			{"奥尔多剥皮训练师", "德雷姆",{37.6,27.9}}, -- 33683
			{"占星者裁缝训练师", "米拉丽丝",{41.8,63.6}}, -- 33636
			{"奥尔多裁缝训练师", "编织者欧尔",{37.6,27.8}}, -- 33684
			{"占星者传送门训练师", "米尔卡·远步",{43.2,93.2}}, -- 19340
			{"传送门训练师", "艾欧莉娅",{56.8,48.0}}, -- 20791
			-- 书柜
			{"炼金术训练师", "书柜",{44.2,90.4}}, -- 33608
			{"锻造训练师", "书柜",{44.0,89.4}}, -- 33609
			{"烹饪训练师", "书柜",{43.6,91.0}}, -- 33619
			{"附魔训练师", "书柜",{43.8,90.2}}, -- 33610
			{"工程学训练师", "书柜",{43.8,89.4}}, -- 33611
			{"急救训练师", "书柜",{43.8,90.4}}, -- 33621
			{"钓鱼训练师", "书柜",{43.6,91.0}}, -- 33623
			{"草药学训练师", "书柜",{43.8,90.2}}, -- 33616
			{"铭文训练师", "书柜",{43.4,90.6}}, -- 33615
			{"珠宝加工训练师", "书柜",{43.6,90.8}}, -- 33614
			{"制皮训练师", "书柜",{43.8,90.4}}, -- 33612
			{"采矿训练师", "书柜",{43.6,90.8}}, -- 33617
			{"剥皮训练师", "书柜",{43.6,90.8}}, -- 33618
			{"裁缝训练师", "书柜",{44.4,90.2}}, -- 33613
		-- 职业训练师
			{"德鲁伊训练师", "贝里尔",{59.2,47.6}}, -- 50136
			{"德鲁伊训练师", "穆哈",{59.2,47.6}}, -- 50137
			{"占星者猎人训练师", "德丽瑟拉",{52.2,52.2}}, -- 50007
			{"奥尔多猎人训练师", "伊尔瓦",{52.8,37.6}}, -- 50020
			{"占星者法师训练师", "阿拉莱莎",{52.2,51.0}}, -- 50010
			{"奥尔多法师训练师", "拉鲁希",{55.6,37.6}}, -- 50021
			{"占星者圣骑士训练师", "血骑士阿尔格隆",{52.8,52.6}}, -- 50012
			{"奥尔多圣骑士训练师", "欧尔多",{55.8,37.2}}, -- 50023
			{"占星者牧师训练师", "护理者伊莎玛拉",{52.0,51.4}}, -- 50013
			{"奥尔多牧师训练师", "萨尔哈",{55.6,36.6}}, -- 50024
			{"占星者潜行者训练师", "寻路者阿尔帕里尔",{52.2,52.4}}, -- 50016
			{"潜行者训练师", "风之猎手埃弗拉姆",{59.2,46.6}}, -- 50127
			{"奥尔多萨满祭司训练师", "达拉胡",{55.6,37.0}}, -- 50019
			{"萨满祭司训练师", "卢克纳尔",{58.2,47.1}}, -- 50130
			{"占星者术士训练师", "召唤着杜雷尔",{51.8,52.0}}, -- 50017
			{"术士训练师", "恶魔召唤者古洛图",{58.6,47.6}}, -- 50128
			{"占星者战士训练师", "塔尔希尔",{52.3,52.9}}, -- 50018
			{"奥尔多战士训练师", "布拉图",{56.0,37.6}}, -- 50025
		-- 商人
			-- 军需官
			{"占星者PvE装备商", "阿罗迪斯·炎刃",{42.6,90.6}}, -- 20613
			{"奥尔多PvE装备商", "阿苏尔",{23.6,32.6}}, -- 20616
			{"占星者PvE装备商", "维恩娜·晨星",{44.8,91.6}}, -- 21905
			{"奥尔多PvE装备商", "克尔拉兰",{24.8,27.0}}, -- 21906
			-- 派系
			{"奥尔多军需官", "军需官恩达尔林",{48.0,26.6}}, -- 19321
			{"占星者军需官", "军需官恩努利尔",{60.6,64.2}}, -- 19331
			{"沙塔尔军需官", "奥玛多尔",{51.6,41.6}}, -- 21432
			{"贫民窟军需官", "纳克杜",{62.6,69.0}}, -- 21655
			-- 其他商人
			{"燃烧的远征时空漫游商人", "凯普丽",{54.6,39.6}}, -- 98685
			{"宝石商人", "利萨尔丝·血目",{54.6,82.6}}, -- 19330
			{"<巨无霸背包>商人", "哈莉丝·西尔顿",{75.6,31.6}}, -- 18756
		-- 其他NPC
			{"公会注册员", "德罗哈",{58.8,46.4}}, -- 52277
		-- 训练假人
			--{"训练假人", "伤害训练假人",{59.0,52.6}}, -- 83552
			--{"训练假人", "治疗训练假人",{29.6,46.8}}, -- 83565
			--{"训练假人", "坦克训练假人",{62.8,39.4}}, -- 83574
		-- 交通工具
			{"传送门", "暴风城;奥格瑞玛",{59.0,46.7}},
			{"传送门", "奎尔丹纳斯岛",{47.9,41.8}},
		},

		-- [CATA] Darkmoon Island
		["暗月岛"]={
		-- 专业训练师
			{"钓鱼训练师", "斯蒂芬·斯塔格纳罗",{52.6,88.4}}, -- 56068
		-- 商人
			--{"纪念品与玩具商人", "吉瓦斯·格里加特",{48.0,64.8}}, -- 14828
			--{"宠物坐骑商人", "兰拉",{48.2,69.4}}, -- 14846
			{"暗月卡片商人", "萨杜斯·帕雷教授",{51.8,60.6}}, -- 14847
			--{"仿制护甲商人", "巴伦姆",{47.6,66.2}}, -- 55072
			{"钓鱼奖励商人", "加里莎·日露",{52.4,88.4}}, -- 55103
			{"传家宝商人", "迪兰德·晨峰",{47.8,66.6}}, -- 56335
			--{"仿制护甲商人", "巴伦玛",{47.6,66.2}}, -- 57983
			{"礼服奇物商人", "切斯特",{51.2,75.0}}, -- 85484
			{"商人", "宠物坐骑;仿制护甲;玩具纪念品",{48.2,69.4}}, -- 14828/14846/55072/57983
			{"血色军需官","出售:裁坏的血色十字军战袍;血色十字军鳞甲锁甲套装",{58.0,80.6}}, -- 108785
		-- 交通工具
			{"传送门", "艾尔文森林;莫高雷",{51.2,23.2}},
			{"回程传送门", "艾尔文森林;莫高雷",{50.5,90.2}},
		},

		-- Dalaran -- need update
		["达拉然"]={
		-- 1层 暗影大厅;2层 达拉然; 3层 达拉然下水道; 4层 艾格文的画廊
		-- 拍卖师
			--{"联盟蒸汽动力拍卖师","布拉斯博特·机钳",{39.0,26.6},1}, -- 35594
			--{"部落蒸汽动力拍卖师","雷加纳德·弧炎",{38.8,25.2},1}, -- 35607
			{"联盟蒸汽动力拍卖师","布拉斯博特·机钳",{37.1,54.8},1}, -- 35594
			{"部落蒸汽动力拍卖师","雷加纳德·弧炎",{65.5,23.5},1}, -- 35607
			{"蒸汽动力拍卖师","[A]布拉斯博特·机钳;[H]雷加纳德·弧炎",{39.0,26.6},1}, -- 35594/35607
		-- 银行职员
			{"银行职员","出纳员拉莫斯",{52.6,14.8},1}, -- 28675
			{"银行职员","出纳员奥西里斯",{54.4,15.8},1}, -- 28676
			{"银行职员","出纳员哈娜",{53.4,15.4},1}, -- 28677
			{"银行职员","出纳员奥斯汀",{53.2,14.6},1}, -- 29282
			{"银行职员","出纳员奥尔米达",{44.0,80.0},1}, -- 30604
			{"银行职员","出纳员吉恩",{43.2,79.4},1}, -- 30605
			{"银行职员","出纳员查恩",{43.4,80.2},1}, -- 30606
			{"银行职员","出纳员普莱施尼尔",{42.4,78.8},1}, -- 30607
			{"银行职员","出纳员阿玛迪",{42.6,79.6},1}, -- 30608
			{"银行职员","宾兹克·戈布克",{32.6,55.4},2}, -- 29530 -- 达拉然下水道
		-- 飞行管理员
			{"飞行管理员","奥鲁丹·白云",{72.8,45.6},1}, -- 28674
		-- 旅店老板
			{"旅店老板","艾米丝·埃索盖斯",{50.0,39.2},1}, -- 28687
			{"联盟旅店老板","伊丝拉米·轻风",{44.6,63.0},1}, -- 32413
			{"部落旅店老板","兽女乌达",{64.6,32.4},1}, -- 31557
			{"旅店老板","埃因·格林",{35.6,56.8},2}, -- 29532 -- 达拉然下水道
		-- 兽栏管理员
			{"兽栏管理员","塔西娅·幽谷",{59.4,37.6},1}, -- 28690
		-- 专业训练师
			{"炼金术训练师", "林奇·黑箭",{42.4,32.0},1}, -- 28703
			{"考古学训练师", "博学者达瑞妮斯",{48.6,38.4},1}, -- 47579
			{"锻造训练师", "奥拉尔德·施米尔",{45.4,28.0},1}, -- 28694
			{"锻造训练师", "伊曼蒂尔·锋歌",{45.4,28.6},1}, -- 29505
			{"锻造训练师", "奥兰德·夏菲尔",{44.8,28.6},1}, -- 29506
			{"联盟烹饪训练师", "凯瑟琳·李",{40.4,65.8},1}, -- 28705
			{"部落烹饪训练师", "埃维罗·隆古巴",{70.0,39.0},1}, -- 29631
			{"附魔训练师", "附魔师纳萨尼斯",{39.0,40.2},1}, -- 28693
			{"工程学训练师", "迪墨菲·欧申克",{38.8,25.8},1}, -- 28697
			{"工程学训练师", "钳工蒂迪",{39.4,25.2},1}, -- 29513
			{"工程学训练师", "芬德尔·汽哨",{39.2,25.0},1}, -- 29514
			{"急救训练师", "善良的欧莉萨拉",{36.8,37.0},1}, -- 28706
			{"钓鱼训练师", "玛西娅·切斯",{52.6,64.8},1}, -- 28742
			{"飞行训练师", "希拉·雪晨",{70.0,45.4},1}, -- 31238
			{"草药学训练师", "多萝希·埃根",{43.2,34.2},1}, -- 28704
			{"铭文训练师", "帕林教授",{41.8,36.8},1}, -- 28702
			{"珠宝加工训练师", "提莫斯·琼斯",{40.4,35.0},1}, -- 28701
			{"制皮训练师", "蒂亚妮·坎宁斯",{35.0,26.6},1}, -- 28700
			{"制皮训练师", "曼弗莱德·斯塔勒",{34.2,29.2},1}, -- 29507
			{"制皮训练师", "安德里奥",{34.2,27.4},1}, -- 29508
			{"制皮训练师", "娜穆·月水",{36.2,29.8},1}, -- 29509
			{"采矿训练师", "杰迪安·汉德尔斯",{41.2,27.0},1}, -- 28698
			{"剥皮训练师", "迪尔克·马克斯",{35.2,28.4},1}, -- 28696
			{"裁缝训练师", "查理·沃尔斯",{36.2,33.6},1}, -- 28699
			{"传送门训练师", "大法师塞琳德拉",{56.6,46.6},1}, -- 29156
		-- 职业训练师
			{"法师训练师", "战争法师法诺莱斯",{55.8,48.8},1}, -- 28956
			{"法师训练师", "叶萨·维尔",{56.0,46.6},1}, -- 28958
			{"联盟德鲁伊训练师", "穆兰·法尔登",{38.0,63.4},1}, -- 50171
			{"联盟猎人训练师", "游侠塞罗妮",{39.6,62.8},1}, -- 50157
			{"联盟圣骑士训练师", "鲁伦·光赐",{39.6,62.6},1}, -- 50160
			{"联盟牧师训练师", "监护者阿蕾苏",{38.6,63.8},1}, -- 50163
			{"联盟潜行者训练师", "寻路者莱尔瑟",{38.6,64.6},1}, -- 50158
			{"联盟萨满祭司训练师", "先知罗帕雅",{38.0,64.8},1}, -- 50174
			{"联盟术士训练师", "召唤者诺尔里克",{38.6,64.6},1}, -- 50156
			{"联盟战士训练师", "纳西弗",{39.6,62.6},1}, -- 50155
			{"部落德鲁伊训练师", "哈娜·月巅",{57.6,24.2},1}, -- 50152
			{"部落猎人训练师", "游侠伊欧斯",{59.2,26.6},1}, -- 50144
			{"部落圣骑士训练师", "尼鲁尔·光誓",{59.6,24.8},1}, -- 50150
			{"部落牧师训练师", "监护者奥瑟拉",{58.0,27.6},1}, -- 50148
			{"部落潜行者训练师", "寻路者里瑟拉",{58.2,28.6},1}, -- 50147
			{"部落萨满祭司训练师", "调谐者穆尔格哈",{57.6,24.6},1}, -- 50153
			{"部落术士训练师", "召唤者卡尔文",{57.0,27.8},1}, -- 50142
			{"部落战士训练师", "文恩苏恩",{59.6,24.8},1}, -- 50149
		-- 商人
			-- 军需官
			{"肯瑞托军需官", "大法师奥瓦利斯",{25.8,46.2},1}, -- 32287
			--{"联盟PvE装备商", "奥术师埃杜林",{37.6,54.8},1}, -- 31579 "传承正义军需官"
			--{"联盟PvE装备商", "奥术师艾弗蕾妮",{37.0,55.0},1}, -- 31580 "传承正义军需官"
			--{"联盟PvE装备商", "奥术师菲莱尔",{38.6,55.0},1}, -- 33964 "传承正义军需官"
			--{"联盟PvE装备商", "奥术师米露蕊娅",{37.8,54.6},1}, -- 35494 "传承正义军需官"
			--{"联盟PvE装备商", "奥术师尤维尔",{38.6,53.6},1}, -- 37942 "传承正义军需官"
			{"联盟PvE装备商", "奥术师埃杜林;奥术师艾弗蕾妮,etc.",{37.6,54.8},1}, -- 31579/31580/33964/35494/37942
			--{"部落PvE装备商", "魔导师布拉塞尔",{65.8,23.6},1}, -- 31581
			--{"部落PvE装备商", "魔导师拉姆布莉丝",{65.6,23.6},1}, -- 31582
			--{"部落PvE装备商", "魔导师萨雷恩",{65.6,24.0},1}, -- 33963
			--{"部落PvE装备商", "魔导师维莎拉",{65.6,23.2},1}, -- 35495
			--{"部落PvE装备商", "魔导师奥尔兰",{65.6,23.6},1}, -- 37941
			{"部落PvE装备商", "魔导师布拉塞尔;魔导师拉姆布莉丝,etc.",{65.8,23.6},1}, -- 31581/31582/33963/35495/37941
			-- 装备商
			{"PvE装备商", "板甲;盾牌",{46.8,28.0},1}, -- 28997/34252/35498|28990
			{"PvE装备商", "布甲;披风;脚部装备",{43.8,49.2},1}, -- 28995/35496|29495|29703
			{"PvE装备商", "副手;饰品",{49.0,54.6},1}, -- 29527|29528
			{"PvE装备商", "单手剑;匕首;拳套",{54.0,61.4},1}, -- 28991|29499
			{"PvE装备商", "锁甲;皮甲",{51.6,72.6},1}, -- 28992/35497|29523/35500
			-- 其他商人
			{"坐骑宠物商人", "布琳妮;梅尔·弗兰希斯",{58.6,39.6},1}, -- 28951/32216
			{"玩具商人", "耶比托·乔巴斯;发条助手",{44.6,46.0},1}, -- 29478/29716
			{"肯瑞托饰品商人", "哈罗德·温斯顿",{38.4,33.8},1}, -- 32172
			{"物品兑换商人", "梦境碎片;厚北地皮;战争约束者墨水;冰冻宝珠",{42.8,35.6},1}, -- 32514/32515/33027/40160
			{"法师<奥术语言/幻觉技能书>与玩具商人","恩多拉·莫尔海德",{38.6,53.8},1}, -- 28715 -- 逆风小径同名NPC 99337
			{"猎人<烟花技能书>商人","比尔亚·兰德斯",{39.0,26.0},1}, -- 28722
			{"巫妖王之怒时空漫游商人", "奥金",{50.6,46.6},1}, -- 98690
			--达拉然下水道
			{"PvE装备商","赫塞尔·加洛特",{60.6,11.8},2}, -- 29538
			{"PvP装备商","S5L;S5M;S5H;S6;S7;S8;S9H;S10;S11",{59.4,58.0},2}, -- 30885/40212/69318/69321/69971/69973 "暴怒角斗士Wrathful" "憎恨角斗士Hateful" "凶残角斗士Savage" "灾变角斗士Cataclysmic" "冷酷角斗士Ruthless" "残忍角斗士Vicious" "狂怒角斗士Furious" "致命角斗士Deadly" "无情角斗士Relentless"
			{"技能书商人","卡维兹·洛典(刷新机制未知.售卖萨满<妖术:蟑螂>技能书;盗贼<侦测>技能书,;牧师玩具;燃尽雕文配方)",{47.0,28.0},2}, -- 106887
		-- 其他NPC
			{"公会注册员","安德鲁·马休",{51.4,54.4},1}, -- 28774
			{"理发师","吉兹·考波克利",{52.8,31.2},1}, -- 28708
		-- 交通工具
			{"入口","达拉然下水道",{60.4,47.4},1},
			{"传送宝珠","紫罗兰哨站-晶歌森林",{56.0,46.8},1},
			{"传送门","时光之穴-塔纳利斯;紫色天台",{25.2,47.7},1},
			{"传送门","暴风城-艾尔文森林",{39.9,62.8},1},
			{"传送门","冬拥湖",{33.6,68.8},1},
			{"传送门","战歌峡谷;阿拉希盆地;奥特兰克山谷;风暴之眼;征服之岛;远古海滩",{29.7,75.8},1},
			{"传送门","奥格瑞玛-杜隆塔尔",{55.6,25.6},1},
			{"传送门","冬拥湖;阿拉希盆地;风暴之眼;征服之岛",{58.1,25.8},1},
			{"传送门","战歌峡谷;奥特兰克山谷;远古海滩",{61.2,16.4},1},
		},

		-- Deeprun Tram
		["矿道地铁"]={
			{"入口", "比兹莫搏击俱乐部",{52.5,69.8}},
		-- 比兹莫搏击俱乐部
			{"比兹莫搏击俱乐部军需官", "奎肯布什",{54.4,25.0},2}, -- 68363
			{"稀有与奢侈饮料商人", "莫兹尔·轮须",{27.0,62.8},2}, -- 70719
			{"奢侈食品商人", "贾斯法夫人",{25.6,70.8},2}, -- 70723
			{"卡牌商人", "卡牌商人蕾拉",{52.2,25.2},2}, -- 70752
		},

		-- [MISTS] Brawl'gar Arena
		["搏击竞技场"]={
			{"搏击竞技场军需官", "保尔·诺斯",{50.9,29.2}}, -- 68364
			--{"稀有与奢侈饮料商人", "哈克西尔·酒神",{,}}, -- 70713 -- need update
			--{"奢侈食品商人", "哈尔·灰鬃",{,}}, -- 70714 -- need update
			{"卡牌商人", "卡牌商人阿弥",{60.3,77.2}}, -- 70751
		},

	-- 卡利姆多 Kalimdor
		-- Azuremyst Isle
		["秘蓝岛"]={
		-- 飞行管理员
			{"飞行管理员", "萨尔达恩",{49.6,49.2},0}, -- 43991
		-- 旅店老板
			{"旅馆老板", "看护员谢尔兰",{48.4,49.2},0}, -- 16553
		-- 兽栏管理员
			{"兽栏管理员", "伊斯比纳",{49,49.8},0}, -- 17485
		-- 专业训练师
			{"炼金术训练师", "丹达尔",{48.4,51.4},0}, -- 17215
			{"锻造训练师", "铁匠卡里普索",{46.4,71.0},0}, -- 17245
			{"烹饪训练师", "“曲奇”米维克索斯",{46.6,70.4},0}, -- 17246
			{"附魔训练师", "瓦伦",{48.6,52.2},0}, -- 47431
			{"工程学训练师", "技师戴罗",{48.4,50.2},0}, -- 17222
			{"工程学训练师", "瓦伦",{48.6,52.2},0}, -- 47431
			{"急救训练师", "学者法蒂玛",{48.4,51.8},0}, -- 17214
			{"钓鱼训练师", "迪泰娜",{61.0,54.2},0}, -- 17101
			{"草药学训练师", "赫罗",{48.2,51.2},0}, -- 17983
			{"草药学训练师", "瓦伦",{48.6,52.2},0}, -- 47431
			{"珠宝加工训练师", "瓦伦",{48.6,52.2},0}, -- 47431
			{"制皮训练师", "莫多",{44.8,23.8},0}, -- 17442
			{"采矿训练师", "杜尔维",{48.8,51.0},0}, -- 17488
			{"采矿训练师", "瓦伦",{48.6,52.2},0}, -- 47431
			{"剥皮训练师", "古尔弗",{44.6,23.4},0}, -- 17441
			{"裁缝训练师", "艾林·凯利",{46.4,70.6},0}, -- 17487
			{"裁缝训练师", "瓦伦",{48.6,52.2},0}, -- 47431
		-- 交通工具
			{"船舶", "鲁瑟兰村-泰达希尔",{29.3,28.2},0},
		},

		-- Teldrassil
		["泰达希尔"]={
		-- 飞行管理员
			{"角鹰兽管理员", "维斯派塔斯",{55.4,88.4},0}, -- 3838
			{"角鹰兽管理员", "菲德利奥",{55.4,50.4},0}, -- 40553
		-- 旅店老板
			{"旅店老板", "旅店老板凯达米尔",{55.4,52.2},0}, -- 6736
		-- 兽栏管理员
			{"兽栏管理员", "瑟里亚迪",{56.2,52.0},0}, -- 10051
		-- 专业训练师
			{"炼金术训练师", "塞恩德拉·细语者",{57.0,53.0},0}, -- 3603
			{"烹饪训练师", "扎瑞恩",{56.6,53.4},0}, -- 6286
			{"附魔训练师", "奥兰纳·鸦眼",{39.0,30.0},0}, -- 3606
			{"急救训练师", "拜恩希",{55.0,49.6},0}, -- 6094
			{"钓鱼训练师", "安多尔·橡木之手",{54.0,89.8},0}, -- 3607
			{"铭文训练师", "玛洛尼·刃叶",{57.0,53.0},0}, -- 3604
			{"制皮训练师", "纳迪娅·织发",{43.4,43.2},0}, -- 3605
			{"制皮训练师", "伊兰尼斯·影花",{56.0,52.2},0}, -- 47420
			{"剥皮训练师", "拉德纳尔·织发",{43.6,43.8},0}, -- 6287
			{"剥皮训练师", "伊兰尼斯·影花",{56.0,52.2},0}, -- 47420
		-- 交通工具
			{"船舶", "瓦拉尔港口-秘蓝岛",{52.3,59.5},0},
			{"船舶", "暴风城港口-暴风城",{55.0,93.7},0},
			{"界门", "达纳苏斯-泰达希尔",{55.1,88.5},0},
		},

		-- Durotar
		["杜隆塔尔"]={
		-- 飞行管理员
			{"飞行管理员", "波洛克",{53.0,43.6},0}, -- 41140
			{"蝙蝠管理员", "管理员曼雷克",{55.4,73.4},0}, -- 41142
		-- 旅店老板
			{"旅店老板", "旅店老板格罗斯克",{51.6,41.6},0}, -- 6928
		-- 兽栏管理员
			{"兽栏管理员", "苏亚米",{52.0,41.8},0}, -- 9987
		-- 专业训练师
			{"炼金术训练师", "米奥赞",{55.4,74.0},0}, -- 3184
			{"炼金术训练师", "伦达",{52.8,42.0},0}, -- 47418
			{"锻造训练师", "杜克",{52.0,40.6},0}, -- 3174
			{"工程学训练师", "穆德拉克",{52.2,40.8},0}, -- 11025
			{"急救训练师", "拉乌克",{54.0,42.0},0}, -- 5943
			{"钓鱼训练师", "劳迪克",{57.2,77.0},0}, -- 5941
			{"草药学训练师", "米什基",{55.6,75.2},0}, -- 3185
			{"草药学训练师", "伦达",{52.8,42.0},0}, -- 47418
			{"制皮训练师", "伦达",{52.8,42.0},0}, -- 47418
			{"骑术训练师", "克萨尔迪",{55.2,75.4},0}, -- 7953
			{"剥皮训练师", "伦达",{52.8,42.0},0}, -- 47418
			{"恶魔训练师", "基萨",{54.6,41.4},0}, -- 6027
		},

		-- Mulgore
		["莫高雷"]={
		-- 飞行管理员
			{"双足飞龙管理员", "塔克",{47.4,58.6},0}, -- 40809
		-- 旅店老板
			{"旅店老板", "旅店老板考乌斯",{46.8,60.4},0}, -- 6747
		-- 兽栏管理员
			{"兽栏管理员", "希克瓦",{47.0,59.6},0}, -- 10050
		-- 专业训练师
			{"烹饪训练师", "派尔·沉默行者",{45.6,57.6},0}, -- 3067
			{"工程学训练师", "图兹维克·斯普格林",{61.2,32.6},0}, -- 10993
			{"急救训练师", "维尔拉·幼蹄",{46.8,60.2},0}, -- 5939
			{"钓鱼训练师", "尤萨恩·静水",{44.8,60.0},0}, -- 5938
			{"草药学训练师", "拉鲁姆·黑鬃",{46.4,57.6},0}, -- 47419
			{"制皮训练师", "查尔·硬皮",{45.8,57.4},0}, -- 3069
			{"采矿训练师", "拉鲁姆·黑鬃",{46.4,57.6},0}, -- 47419
			{"骑术训练师", "卡尔·雷歌",{47.6,58.0},0}, -- 3690
			{"剥皮训练师", "姚恩·深刺",{45.8,57.4},0}, -- 6290
		},

		-- Bloodmyst Isle
		["秘血岛"]={
		-- 飞行管理员
			{"角鹰兽管理员", "兰度",{57.6,54.0}}, -- 17554
		-- 旅店老板
			{"旅店老板", "托菲尔·罗阿",{55.6,59.6}}, -- 17553
		-- 兽栏管理员
			{"兽栏管理员", "阿斯图",{55.0,59.8}}, -- 17666
		-- 专业训练师
			{"急救训练师", "学者菲索斯",{54.6,54.0}}, -- 17424
			{"草药学训练师", "莫莱",{56.2,54.2}}, -- 17434
			{"采矿训练师", "勘探者纳克兰",{53.2,57.6}}, -- 18804
		},

		-- Darkshore
		["黑海岸"]={
		-- 飞行管理员
			{"角鹰兽管理员", "特尔迪娜·月羽",{51.6,17.6}}, -- 3841
			{"飞行管理员", "德拉莉亚",{44.4,75.4}}, -- 33253
		-- 旅店老板
			{"旅店老板", "旅店老板凯特兰",{51.0,18.6}}, -- 43420
		-- 兽栏管理员
			{"兽栏管理员", "贾琳希亚",{50.4,19.2}}, -- 10085
		-- 专业训练师
			{"考古学训练师", "史蒂芬妮·克鲁希克",{50.6,20.6}}, -- 51997
			{"锻造训练师", "泰耶尔·焰击",{50.8,19.2}}, -- 43429
			{"工程学训练师", "洁娜·雷姆尼利",{50.6,20.6}}, -- 11037
			{"采矿训练师", "帕莉亚蕾",{51.4,19.0}}, -- 43431
			{"裁缝训练师", "菲叶琳·柳月",{50.6,20.8}}, -- 43428
		-- 商人
			{"部落<枯萎的树人>商人", "药剂师弗洛斯",{57.2,33.8}}, -- 33980
		},

		-- Azshara
		["艾萨拉"]={
		-- 飞行管理员
			{"双足飞龙管理员", "克隆姆",{53.0,49.8}}, -- 8610
			{"双足飞龙管理员", "克隆姆",{14.2,65.0}}, -- 36728
			{"飞行管理员", "“天旋地转”费利兹",{51.4,74.2}}, -- 37005
			{"飞行管理员", "布利兹·爆裂弹",{66.4,20.8}}, -- 43328
		-- 旅店老板
			{"旅馆老板", "米克希",{57.0,50.4}}, -- 43771
		-- 兽栏管理员
			{"兽栏管理员", "史蒂拉·布恩布恩",{56.8,50.0}}, -- 43773
		-- 专业训练师
			{"急救训练师", "卡亚罗全能训练机豪华版",{57.0,50.6}}, -- 49885
			{"急救训练师", "扎普诺兹医生",{57.0,50.6}}, -- 49879
			{"钓鱼训练师", "卡亚罗全能训练机豪华版",{57.0,50.6}}, -- 49885
		-- 商人
			{"中立<卡莱莎的魂萦坠饰>商人", "特克斯·垂旋",{57.0,50.6}}, -- 36375
			-- 恶魔入侵
			{"恶魔入侵军需官", "被俘的虫语者",{29.8,68.8}}, -- 109912
		},

		-- Northern Barrens
		["北贫瘠之地"]={
		-- 银行职员
			{"银行职员", "法兹拉克",{68.4,71.2},0}, -- 3496
			{"银行职员", "兹科尔",{68.4,71.2},0}, -- 8119
		-- 飞行管理员
			{"双足飞龙管理员", "迪弗拉克",{48.6,58.6},0}, -- 3615/110574 -- 恶魔入侵
			{"飞行管理员", "布拉高克",{69.0,70.6},0}, -- 16227
			{"飞行管理员", "格特·血翔",{42.0,15.8},0}, -- 34927
			{"飞行管理员", "加瑞克斯",{62.4,17.2},0}, -- 40558
		-- 旅店老板
			{"旅店老板", "旅店老板伯兰德·草风",{49.6,58.0},0}, -- 3934/104802 -- 恶魔入侵
			{"旅店老板", "旅店老板维尔雷",{67.2,74.6},0}, -- 6791
			{"旅店老板", "酒馆老板克莉泽尔",{62.4,16.6},0}, -- 43945
			{"旅店老板", "旅店老板科尔蒂斯",{56.2,40.0},0}, -- 43946
		-- 兽栏管理员
			{"兽栏管理员", "希克瓦",{49.0,57.6},0}, -- 9981/95609 -- 恶魔入侵
			{"兽栏管理员", "雷格菲兹",{67.4,74.2},0}, -- 10063
			{"兽栏管理员", "维尔隆·喷酸",{62.4,16.8},0}, -- 43982
			{"兽栏管理员", "卡索科",{56.6,39.8},0}, -- 43988
		-- 专业训练师
			{"锻造训练师", "特劳弗",{48.2,56.2},0}, -- 3478
			{"烹饪训练师", "杜恩格",{55.4,61.2},0}, -- 8306/95981 -- 恶魔入侵
			{"工程学训练师", "廷克维斯",{68.4,69.2},0}, -- 3494
			{"工程学训练师", "瓦萨里奥·林克格雷斯",{68.4,69.2},0}, -- 8738
			{"裁缝训练师", "基尔哈拉",{49.8,61.0},0}, -- 3484/95794 -- 恶魔入侵
			{"恶魔训练师", "迈特罗·塞舒瓦",{68.0,67.8},0}, -- 23535
		-- 商人
			{"战歌军需官", "凯尔姆·哈古斯",{40.2,20.0},0}, -- 14754
			-- 恶魔入侵
			{"恶魔入侵军需官", "被俘的虫语者",{51.2,57.6},0}, -- 109912
		-- 交通工具
			{"船舶", "藏宝海湾-荆棘谷海角",{70.2,73.8},0},
		},

		-- Moonglade
		["月光林地"]={
		-- 飞行管理员
			{"角鹰兽管理员", "辛德拉尔",{48.0,67.2}}, -- 10897
			{"德鲁伊雷霆崖飞行管理员", "布瑟恩·草风",{44.2,45.6}}, -- 11798
			{"德鲁伊达纳苏斯飞行管理员", "希尔瓦·菲纳雯斯",{44.2,45.8}}, -- 11800
			{"双足飞龙管理员", "法斯托恩",{32.2,66.4}}, -- 12740
		-- 职业训练师
			{"德鲁伊训练师", "洛甘纳尔",{52.4,40.6}}, -- 12042
			{"德鲁伊训练师", "赞巴莱",{47.8,32.6}}, -- 13476
		-- 专业训练师
			{"草药学训练师", "玛沃尔",{45.4,47.0}}, -- 12025
		-- 商人
			{"德鲁伊<技能书>商人", "罗莱尔·冬歌",{48.6,40.2}}, -- 12022 -- need translation 7.0.3新增职业物品
		},

		-- Ashenvale
		["灰谷"]={
		-- 飞行管理员
			{"角鹰兽管理员", "黛琳希亚",{34.4,48.0}}, -- 4267
			{"双足飞龙管理员", "安德鲁克",{11.2,34.4}}, -- 11901
			{"双足飞龙管理员", "乌尔格拉",{73.2,61.6}}, -- 12616
			{"角鹰兽管理员", "索拉莱斯·远风",{85.0,43.4}}, -- 22935
			{"联盟飞行管理员", "索莱斯",{18.2,20.6}}, -- 34374
			{"联盟飞行管理员", "麦瑞·月翔",{35.0,72.0}}, -- 34378
			{"双足飞龙管理员", "萨拉卡",{38.0,42.2}}, -- 34429
			{"部落飞行管理员", "驯风者舒舍克",{49.2,65.2}}, -- 34943
		-- 旅店老板
			{"联盟旅店老板", "旅店老板基姆利雅",{37.0,49.2}}, -- 6738
			{"部落旅店老板", "旅店老板凯利斯克",{74.0,60.6}}, -- 12196
			{"部落旅店老板", "旅店老板杜拉斯",{13.0,34.0}}, -- 43606
			{"部落旅店老板", "旅店老板林卡莎",{38.6,42.2}}, -- 43624
			{"部落旅店老板", "旅店老板奇恩托卡",{50.4,67.0}}, -- 43633
		-- 兽栏管理员
			{"联盟兽栏管理员", "玛鲁希亚",{36.4,50.4}}, -- 10052
			{"部落兽栏管理员", "基苏",{73.2,60.6}}, -- 15131
			{"部落兽栏管理员", "鲁尔莎",{12.6,33.8}}, -- 43617
			{"部落兽栏管理员", "德雷克",{38.6,42.4}}, -- 43630
			{"部落兽栏管理员", "沃尔查",{50.2,65.8}}, -- 43634
		-- 专业训练师
			{"部落钓鱼训练师", "基尔希瓦纳",{10.8,33.8}}, -- 12961
			{"联盟制皮训练师", "艾蒂安·花丛之风",{35.8,52.0}}, -- 3967
		-- 商人
			{"银翼军需官", "艾蒂尔·月火",{61.6,83.8}}, -- 14753
		},

		-- Stonetalon Mountains
		["石爪山脉"]={
		-- 飞行管理员
			{"角鹰兽管理员", "泰罗伦",{40.0,32.0}}, -- 4407
			{"联盟飞行管理员", "卡璐纳·歌翔",{70.8,80.4}}, -- 35136
			{"联盟飞行管理员", "艾兰娜·迅翔",{58.8,54.2}}, -- 35137
			{"联盟飞行管理员", "瑟攸拉",{32.0,61.8}}, -- 35138 -- need translation
			{"部落飞行管理员", "齐拉内",{70.6,89.4}}, -- 35139
			{"部落飞行管理员", "迅捷科玛尔",{66.4,62.8}}, -- 35140
			{"部落飞行管理员", "欧尔娜·观天者",{45.0,30.8}}, -- 35141 -- need translation
			{"联盟飞行管理员", "菲欧拉·月翔",{48.6,51.6}}, -- 41240
			{"部落飞行管理员", "弗劳克",{53.8,40.0}}, -- 41246
		-- 旅店老板
			{"联盟旅店老板", "奥莉西雅·眠湖",{59.0,56.4}}, -- 40898
			{"联盟旅店老板", "莱纳斯",{71.0,79.0}}, -- 41286
			{"联盟旅店老板", "瓦罗斯·影息",{39.4,32.8}}, -- 41491
			{"部落旅店老板", "菲洛留斯·斯塔克",{66.4,64.2}}, -- 41892
			{"联盟旅店老板", "旅店老板波妮丝",{31.4,60.6}}, -- 44177 -- need translation
		-- 兽栏管理员
			{"部落兽栏管理员", "格雷克",{50.8,63.0}}, -- 10048
			{"部落兽栏管理员", "格尔宾",{66.2,64.0}}, -- 41893
			{"联盟兽栏管理员", "法赫斯塔德",{39.8,32.2}}, -- 43017
			{"联盟兽栏管理员", "泰尔朵拉",{31.8,61.6}}, -- 43019 -- need translation
			{"联盟兽栏管理员", "阿多琉斯",{58.6,56.6}}, -- 43021
		-- 专业训练师
			{"部落附魔训练师", "赫加斯",{51.8,59.8}}, -- 11074
		-- 商人
			{"部落PvE装备商", "克罗姆加军需官",{65.8,64.0}}, -- 42028
		},

		-- Southern Barrens
		["南贫瘠之地"]={
		-- 飞行管理员
			{"联盟飞行管理员", "约翰·约翰森",{38.8,10.8}}, -- 39210
			{"联盟飞行管理员", "史蒂夫·史蒂文森",{49.2,67.8}}, -- 39211
			{"联盟飞行管理员", "比尔·威廉姆斯",{66.4,47.0}}, -- 39212
			{"部落飞行管理员", "克雷多",{41.2,70.8}}, -- 39330
			{"部落飞行管理员", "乌内加",{39.6,20.2}}, -- 39340
			{"双足飞龙管理员", "罗格纳",{41.6,47.6}}, -- 52060
		-- 旅店老板
			{"联盟旅店老板", "后勤军士雷纳尔多",{39.0,11.0}}, -- 44219
			{"联盟旅店老板", "后勤军士萨莉丝塔",{49.0,68.6}}, -- 44267
			{"联盟旅店老板", "城堡卫士克里",{65.6,46.6}}, -- 44268
			{"部落旅店老板", "旅店老板胡纳哈特",{39.2,20.0}}, -- 44270
			{"部落旅店老板", "旅店老板鲁哈卡德",{40.8,69.2}}, -- 44276
		-- 兽栏管理员
			{"联盟兽栏管理员", "布兰登·梅里威瑟",{39.0,11.2}}, -- 44346
			{"联盟兽栏管理员", "沃纳·伊斯特布鲁克",{49.0,68.2}}, -- 44347
			{"联盟兽栏管理员", "卡雷·威利斯",{66.0,46.8}}, -- 44348
			{"部落兽栏管理员", "穆纳达",{39.2,19.8}}, -- 44349
			{"部落兽栏管理员", "格兰托尔",{40.8,69.6}}, -- 44354
		-- 专业训练师
			{"部落制皮训练师", "克鲁姆·满月",{44.4,51.0}}, -- 3703
			{"部落剥皮训练师", "德拉恩",{44.6,52.0}}, -- 6387
			{"部落裁缝训练师", "马哈尼",{41.6,47.0}}, -- 3704
		},

		-- Desolace
		["凄凉之地"]={
		-- 飞行管理员
			{"角鹰兽管理员", "巴瑞特·克罗斯",{64.6,10.4},0}, -- 6706
			{"双足飞龙管理员", "萨隆",{21.6,74.0},0}, -- 6726
			{"部落飞行管理员", "纳里玛",{44.2,29.6},0}, -- 35315
			{"飞行管理员", "拉斯特瑞·绿风",{57.6,49.6},0}, -- 35478
			{"狮鹫管理员", "茉艾拉·钢翼",{36.8,71.6},0}, -- 35481
			{"飞行管理员", "桑克的双足飞龙",{70.6,32.8},0}, -- 35556
			{"飞行管理员", "库拉的角鹰兽",{39.0,27.0},0}, -- 35562
		-- 旅店老板
			{"联盟旅店老板", "旅店老板利莎瑞亚",{66.2,6.6},0}, -- 11103
			{"部落旅店老板", "旅店老板希科瓦",{24.0,68.2},0}, -- 11106
			{"旅店老板", "旅店老板德希娜",{56.8,50.0},0}, -- 43872
		-- 兽栏管理员
			{"联盟兽栏管理员", "舍尔戈莱恩",{65.6,7.8},0}, -- 11104
			{"部落兽栏管理员", "安伯达",{24.8,6.8},0}, -- 11105
			{"兽栏管理员", "菲娜·止林",{57.0,49.6},0}, -- 43877
		-- 专业训练师
			{"部落钓鱼训练师", "鲁伊马拉",{22.6,72.6},0}, -- 12032
			{"部落制皮训练师", "纳夫",{55.2,56.2},0}, -- 8153
			{"部落剥皮训练师", "马鲁克斯",{23.2,69.8},0}, -- 12030
		},

		-- Dustwallow Marsh
		["尘泥沼泽"]={
		-- 银行职员
			{"联盟银行职员", "出纳员兰德里",{67.8,48.2}}, -- 5083
		-- 飞行管理员
			{"狮鹫管理员", "巴德拉克",{67.4,51.2}}, -- 4321
			{"双足飞龙管理员", "沙尔迪",{35.6,31.8}}, -- 11899
			{"飞行管理员", "德斯利克·希维格拉",{42.8,72.4}}, -- 40358
		-- 旅店老板
			{"联盟旅店老板", "旅店老板詹妮",{66.4,45.4}}, -- 6272
			{"旅店老板", "埃克斯勒",{41.8,74.0}}, -- 23995
			{"部落旅店老板", "“小个子”洛戈克",{36.8,32.2}}, -- 24208
		-- 兽栏管理员
			{"联盟兽栏管理员", "麦克尔",{65.8,45.4}}, -- 10047
		-- 专业训练师
			{"炼金术训练师", "炼金师纳瑞特",{64.0,47.6}}, -- 4900
			{"考古学训练师", "菲娜·绒套",{66.2,45.2}}, -- 53421
			{"锻造训练师", "玛蕾·霍斯顿",{64.6,50.0}}, -- 4888
			{"烹饪训练师", "克莱格·诺瓦德",{66.8,45.2}}, -- 4894
			{"附魔训练师", "丽萨·斯贝维克",{66.0,49.6}}, -- 53410
			{"工程学训练师", "卡兹·双链",{64.6,50.4}}, -- 4941
			{"急救训练师", "古斯塔夫·范沃森医生",{67.6,48.8}}, -- 12939
			{"钓鱼训练师", "“脏鬼”迈克尔·克罗维",{69.2,51.8}}, -- 23896
			{"草药学训练师", "布兰特·加斯布鲁姆",{64.0,47.6}}, -- 4898
			{"铭文训练师", "瑟尔顿·曼勒斯",{66.0,49.6}}, -- 53415
			{"珠宝加工训练师", "因格·绒套",{66.2,45.2}}, -- 5388
			{"制皮训练师", "尤塔西·坦维尔",{66.4,45.2}}, -- 53436
			{"采矿训练师", "“狗头人”科尔里克",{64.6,49.8}}, -- 53409
			{"骑术训练师", "珊莎·玛克温斯",{65.4,51.6}}, -- 53407
			{"剥皮训练师", "休伯特·坦维尔",{66.4,45.2}}, -- 53437
			{"裁缝训练师", "提莫斯·沃森特",{66.2,51.6}}, -- 11052
			{"传送门训练师", "伊苏莉娅",{66.0,49.0}}, -- 27703
		-- 商人
			{"H<迷你魔法炸弹>/A<塞拉摩战袍>商人", "希多尔米",{55.8,49.6}}, -- 63546
		-- 交通工具
			{"船舶", "米奈希尔港-湿地",{71.2,54.0}},
		},

		-- Feralas
		["菲拉斯"]={
		-- 飞行管理员
			{"双足飞龙管理员", "希恩",{75.4,44.2}}, -- 39898
			{"角鹰兽管理员", "塞亚娜·夜灵",{77.2,56.8}}, -- 40367
			{"双足飞龙管理员", "托诺",{41.4,15.4}}, -- 40473
			{"联盟飞行管理员", "瑟洛",{50.2,16.6}}, -- 40966
			{"角鹰兽管理员", "伊瑞拉·月羽",{46.8,45.2}}, -- 41383
			{"联盟飞行管理员", "爱伦达",{57.0,54.0}}, -- 41580
			{"双足飞龙管理员", "玛尔格",{51.0,48.4}}, -- 41605
		-- 旅店老板
			{"部落旅店老板", "旅店老板格鲁尔",{74.8,45.0}}, -- 7737
			{"部落旅店老板", "雅蒂恩·辉树",{41.4,15.6}}, -- 40467
			{"联盟旅店老板", "安多利尔",{51.0,17.8}}, -- 40968
			{"部落旅店老板", "冲克",{51.8,47.4}}, -- 44376
			{"联盟旅店老板", "旅店老板希瑞亚",{46.0,45.2}}, -- 44391
		-- 兽栏管理员
			{"部落兽栏管理员", "谢尔卡·狼行者",{74.6,43.2}}, -- 9986
			{"联盟兽栏管理员", "安塔留斯",{46.8,45.6}}, -- 10059
			{"部落兽栏管理员", "阿加耶",{51.6,48.0}}, -- 44378
			{"联盟兽栏管理员", "瓦尔",{51.0,18.0}}, -- 44382
			{"部落兽栏管理员", "索拉",{41.4,15.6}}, -- 44384
		-- 专业训练师
			{"联盟炼金术训练师", "凯兰娜·风语",{46.6,42.8}}, -- 7948
			{"联盟附魔训练师", "辛琳妮亚·星光",{46.6,42.8}}, -- 7949
			{"联盟钓鱼训练师", "布拉诺克",{45.2,41.4}}, -- 7946
			{"部落草药学训练师", "拉乌",{76.0,43.4}}, -- 8146
			{"部落制皮训练师", "哈拉纳·铁皮",{74.4,43.0}}, -- 11098
			{"部落剥皮训练师", "库雷格·石角",{74.4,43.0}}, -- 8144
		-- 商人
			{"中立<双塔山降落伞>商人", "卡林·风程",{49.0,21.4}}, -- 7772
		},

		-- Thousand Needles
		["千针石林"]={
		-- 飞行管理员
			{"飞行管理员", "扎兹克斯·爆旅",{79.0,71.8}}, -- 40769
			{"双足飞龙管理员", "纳赫特",{11.0,11.6}}, -- 44399
		-- 旅店老板
			{"旅店老板", "黛西",{76.4,74.6}}, -- 40832
		-- 商人
			{"中立<灰色小鸡>商人", "勇敢的强森",{85.6,91.6}}, -- 41135
		},

		-- Felwood
		["费伍德森林"]={
		-- 飞行管理员
			{"角鹰兽管理员", "米萨琳娜",{60.6,25.2}}, -- 12578
			{"翡翠议会飞行管理员", "高瑞姆",{51.4,80.8}}, -- 22931
			{"中立角鹰兽管理员", "哈娜·南歌",{43.6,28.6}}, -- 43073
			{"中立角鹰兽管理员", "凯拉·静林",{44.2,61.8}}, -- 43079
		-- 旅店老板
			{"联盟旅店老板", "狼巢之母尤尔莉卡",{61.8,26.6}}, -- 47931
			{"旅店老板", "旅店老板瓦拉莉亚",{44.8,29.0}}, -- 48215
			{"旅店老板", "旅店老板提尼考",{44.0,61.8}}, -- 48599
		-- 兽栏管理员
			{"兽栏管理员", "纳雷塞特",{61.6,25.4}}, -- 543
			{"联盟兽栏管理员", "胡拉",{44.4,28.6}}, -- 48216
		-- 专业训练师
			{"裁缝训练师", "梅罗什",{64.8,5.2}}, -- 11557
		-- 商人
			{"中立<熊怪变形棒>商人", "梅罗什",{64.8,5.2}}, -- 11557
		},

		-- Tanaris
		["塔纳利斯"]={
		-- 拍卖师
			{"拍卖师", "拍卖师比尔杜",{51.8,30.4},0}, -- 8661/106939 -- 恶魔入侵
		-- 银行职员
			{"银行职员", "吉布索恩",{52.2,29.6},0}, -- 7799/98841 -- 恶魔入侵
			{"银行职员", "奇兹克",{52.2,29.6},0}, -- 8124/98842 -- 恶魔入侵
		-- 飞行管理员
			{"狮鹫管理员", "博拉·石锤",{51.4,29.4},0}, -- 7823
			{"双足飞龙管理员", "布科雷克·怒拳",{52.0,27.6},0}, -- 7824
			{"联盟飞行管理员", "苏尔达",{40.0,77.4},0}, -- 40827
			{"飞行管理员", "斯里克·坠沉",{55.8,60.6},0}, -- 41214
			{"部落飞行管理员", "莱娜·日翔",{33.2,77.2},0}, -- 41215
		-- 旅店老板
			{"旅店老板", "旅店老板菲兹格瑞博",{52.6,27.0},0}, -- 7733/106940 -- 恶魔入侵
			{"旅店老板", "卡门·艾般诺兹",{55.6,60.8},0}, -- 38714
		-- 兽栏管理员
			{"兽栏管理员", "拉兹弗斯",{52.6,27.4},0}, -- 9985/98861 -- 恶魔入侵
		-- 专业训练师
			{"工程学训练师", "尼克斯·斯普克斯宾",{52.2,28.2},0}, -- 8126/98838 -- 恶魔入侵
			{"工程学训练师", "巴兹克·布拉斯温",{51.6,30.2},0}, -- 8736/98872 -- 恶魔入侵
			{"采矿训练师", "皮库尔",{51.0,29.0},0}, -- 8128/106979 -- 恶魔入侵
		-- 商人
			-- 军需官
			--{"PvP装备商", "维克斯顿",{51.6,28.0},0}, -- 20278/106944 荣耀印记 "嗜血角斗士Bloodthirsty" "暴怒角斗士Wrathful" "野蛮角斗士Brutal" "守卫者Guardian"
			--{"PvP装备商", "骗子布拉兹克",{51.4,28.0},0}, -- 40216/106945 "残忍角斗士Vicious" "暴怒角斗士Wrathful" "野蛮角斗士Brutal"
			--{"PvP装备商", "“巫婆”凯普斯",{51.4,28.0},0}, -- 69322/106947 "灾变角斗士Cataclysmic" "无情角斗士Relentless" "残忍角斗士Vicious"
			--{"PvP装备商", "小个子泰格",{51.4,28.0},0}, -- 69323/106946 "冷酷角斗士Ruthless" "灾变角斗士Cataclysmic" "残忍角斗士Vicious"
			--{"PvP装备商", "埃克顿·布拉斯塔",{51.4,28.0},0}, -- 69979/106949 "荣誉军需官" -- 恶魔入侵 "冷酷角斗士Ruthless"
			--{"PvP装备商", "伊维·考伯斯宾",{51.4,28.0},0}, -- 69980/106948 "征服军需官" -- 恶魔入侵 "灾变角斗士Cataclysmic" "冷酷角斗士Ruthless" "残忍角斗士Vicious"
			{"PvP装备商", "守卫者;S4;S7;S8;S9L;S9H;S10;S11",{51.4,28.0},0}, -- 20278/40216/69322/69323/69979/69980
			-- 派系
			{"时光守护者军需官", "艾鲁尔米",{48.4,71.6},0}, -- 21643
			-- 其他商人
			{"中立<诺格弗格药剂>商人", "斯宾科尔·诺格弗格",{51.2,29.8},0}, -- 43418/98844 -- 恶魔入侵
			-- 恶魔入侵
			{"恶魔入侵军需官", "被俘的虫语者",{53.0,25.8},0}, -- 109912
		},

		-- Un'Goro Crater
		["安戈洛环形山"]={
		-- 飞行管理员
			{"飞行管理员", "格莱菲",{56.0,64.0},0}, -- 10583
			{"飞行管理员", "弗里兹·考斯班纳",{44.0,40.2},0}, -- 39175
		-- 商人
			{"中立<玩具风车>任务商人", "北郡骑士麦斯米兰",{30.6,51.2},0}, -- 38237
			{"部落<毒皮暴掠龙哨>任务商人", "莫维克",{71.6,73.8},0}, -- 11701
		},

		-- Winterspring
		["冬泉谷"]={
		-- 拍卖师
			{"拍卖师", "拍卖师格里兹林",{59.8,49.2}}, -- 9857
		-- 银行职员
			{"银行职员", "伊兹·考伯加布",{59.8,49.0}}, -- 13917
		-- 飞行管理员
			{"角鹰兽管理员", "麦瑟蕾亚",{61.0,48.6}}, -- 11138
			{"双足飞龙管理员", "尤格雷克",{58.8,48.2}}, -- 11139
		-- 旅店老板
			{"旅店老板", "旅店老板维兹奇",{59.8,51.2}}, -- 11118
		-- 兽栏管理员
			{"兽栏管理员", "阿兹雷比",{58.6,50.2}}, -- 11119
		-- 商人
			{"联盟<冬泉霜刃豹缰绳>商人", "雷沃·霜翼",{46.6,17.6}}, -- 10618
			{"中立<冬泉豹幼崽>商人", "米歇尔·德朗姆",{59.8,51.6}}, -- 52830
		},

		-- Silithus
		["希利苏斯"]={
		-- 飞行管理员
			{"角鹰兽管理员", "克劳德·天舞者",{54.4,32.8},0}, -- 15177
			{"双足飞龙管理员", "鲁克·驯风者",{52.8,34.6},0}, -- 15178
		-- 旅店老板
			{"旅店老板", "卡兰德拉斯",{55.4,36.6},0}, -- 15174
		-- 兽栏管理员
			{"兽栏管理员", "莱欧伦·玛尔迪拉斯",{53.2,34.6},0}, -- 15722
		},

		-- Mount Hyjal
		["海加尔山"]={
		-- 飞行管理员
			{"飞行管理员", "费兰·艾尔萨斯",{62.2,21.6}}, -- 41861
			{"飞行管理员", "艾里希尔·冬蛾",{19.6,36.4}}, -- 41860/53783
			{"飞行管理员", "蒂诺莱·迅羽",{41.2,42.6}}, -- 43481/50084
			{"飞行管理员", "艾尔特拉",{71.6,75.2}}, -- 43549
			{"飞行管理员", "蕾尼拉·羽峡",{27.8,63.4}}, -- 54392/54393
		-- 旅店老板
			{"旅店老板", "塞贝莉亚",{63.0,24.0}}, -- 40843
			{"旅店老板", "萨利恩·月熊",{18.6,37.2}}, -- 43378/53779
			{"旅店老板", "艾莎娜·溪行",{42.6,45.6}}, -- 43487/50068
		-- 兽栏管理员
			{"兽栏管理员", "艾丽·绿柳",{63.2,23.0}}, -- 43408
			{"兽栏管理员", "利米娅·白枝",{19.4,36.2}}, -- 43379/53780
			{"兽栏管理员", "奥尔塔林·灰云",{41.8,45.0}}, -- 43494/50069
		-- 商人
			{"海加尔守护者军需官", "供给官白云",{62.8,23.8}}, -- 50314
			{"海加尔复仇者军需官", "纳瑟尔·雷怒",{47.8,78.2}}, -- 54401
			{"PvE装备商", "鲁娜·怒藤",{47.6,77.6}}, -- 54402 "火石结晶收集者"
		},

		-- Uldum
		["奥丹姆"]={
		-- 飞行管理员
			{"飞行管理员", "伊瓦克斯·油光",{22.2,64.8}}, -- 48273
			{"飞行管理员", "约克·林赛",{26.6,8.2}}, -- 48274
			{"飞行管理员", "库塞尔",{56.2,33.6}}, -- 48275
		-- 旅店老板
			{"旅店老板", "卡泽穆迪",{54.6,32.8}}, -- 48886
			{"旅店老板", "雅斯敏",{26.6,7.2}}, -- 49406
		-- 兽栏管理员
			{"兽栏管理员", "达尔维什",{54.6,33.8}}, -- 48887
			{"兽栏管理员", "法拉·塔米娜",{27.0,7.6}}, -- 49408
		-- 商人
			{"拉穆卡恒军需官", "铁匠阿巴西",{54.0,33.2}}, -- 48617
		},

		-- Molten Front
		["熔火前线"]={
		-- 商人
			--{"世界之树的印记商人", "赞沃卡",{47.6,77.6}}, -- 52822 "世界之树的馈赠"
			{"PvE装备商", "达默克·冲炉",{47.6,77.6}}, -- 53214 "优质装备"
			--{"宠物玩具装备商人", "艾拉·影暴",{47.6,77.6}}, -- 53881 "艾露恩的珍宝"
			--{"宠物玩具装备商人", "瓦尔兰·高枝",{47.6,77.6}}, -- 53882 "林地补给官"
			{"商人", "世界之树的印记;宠物;玩具",{47.6,77.6}}, -- 52822/53881/53882
		},

	-- 东部王国 Eastern Kingdoms
		-- Dun Morogh
		["丹莫罗"]={
		-- 飞行管理员
			{"狮鹫管理员", "布洛兰·风须",{53.8,52.6},0}, -- 43701
			{"狮鹫管理员", "多米尼克·风须",{75.8,54.4},0}, -- 43702
		-- 旅店老板
			{"旅店老板", "旅店老板贝尔姆",{54.4,50.8},0}, -- 1247
		-- 兽栏管理员
			{"兽栏管理员", "谢尔比·石火",{54.0,51.0},0}, -- 9980
		-- 专业训练师
			{"锻造训练师", "托格努斯·燧火",{52.4,50.2},0}, -- 1241
			{"烹饪训练师", "厨师格瑞姆",{75.6,52.8},0}, -- 1355
			{"烹饪训练师", "格雷姆罗克·匹斯诺尔",{54.6,50.6},0}, -- 1699/99991 恶魔入侵
			{"工程学训练师", "布隆克",{57.2,48.6},0}, -- 1702
			{"急救训练师", "萨姆诺·普尔",{54.2,50.8},0}, -- 2326/100013 恶魔入侵
			{"草药学训练师", "温比尔·任务栏",{53.8,52.0},0}, -- 47396/99938 恶魔入侵
			{"采矿训练师", "丹克·利刃",{76.6,53.6},0}, -- 1701/99845 恶魔入侵
			{"采矿训练师", "亚尔·锤石",{57.2,48.6},0}, -- 5392
			{"采矿训练师", "温比尔·任务栏",{53.8,52.0},0}, -- 47396/99938 恶魔入侵
			{"骑术训练师", "奥萨姆·铁角",{71.2,48.4},0}, -- 4772
			{"骑术训练师", "宾吉·羽哨",{56.2,46.4},0}, -- 7954/100164 恶魔入侵
			{"剥皮训练师", "温比尔·任务栏",{53.8,52.0},0}, -- 47396/99938 恶魔入侵
			{"恶魔训练师", "丹尼·血泡",{54.4,52.0},0}, -- 6328/99979 恶魔入侵
		-- 商人
			-- 恶魔入侵
			{"恶魔入侵军需官", "被俘的虫语者",{59.8,35.2},0}, -- 109912
		},

		-- Elwynn Forest
		["艾尔文森林"]={
		-- 飞行管理员
			{"狮鹫管理员", "勇敢的巴特利",{41.8,64.6},0}, -- 42983
			{"狮鹫管理员", "迅翼高斯",{81.8,66.4},0}, -- 43000
		-- 旅店老板
			{"旅店老板", "旅店老板法雷",{43.8,65.8},0}, -- 295
		-- 兽栏管理员
			{"兽栏管理员", "艾玛",{42.8,65.8},0}, -- 6749
		-- 专业训练师
			{"炼金术训练师", "炼金师玛洛瑞",{39.8,48.6},0}, -- 1215
			{"炼金术训练师", "莱恩·法尔娜",{42.0,67.0},0}, -- 47384
			{"锻造训练师", "铁匠阿古斯",{41.6,65.6},0}, -- 514
			{"锻造训练师", "莱恩·法尔娜",{42.0,67.0},0}, -- 47384
			{"烹饪训练师", "异种搜寻者",{44.2,66.0},0}, -- 4130
			{"附魔训练师", "基塔·费温德",{64.8,70.6},0}, -- 11072
			{"附魔训练师", "莱恩·法尔娜",{42.0,67.0},0}, -- 47384
			{"工程学训练师", "莱恩·法尔娜",{42.0,67.0},0}, -- 47384
			{"急救训练师", "米歇尔·贝利",{43.4,65.6},0}, -- 2329
			{"钓鱼训练师", "李·布朗",{47.4,62.2},0}, -- 1651
			{"草药学训练师", "草药师博米洛伊",{39.8,48.4},0}, -- 1218
			{"草药学训练师", "莱恩·法尔娜",{42.0,67.0},0}, -- 47384
			{"制皮训练师", "艾德勒·费欧德",{46.4,62.0},0}, -- 1632
			{"采矿训练师", "莱恩·法尔娜",{42.0,67.0},0}, -- 47384
			{"骑术训练师", "工头考兹尔",{64.2,65.0},0}, -- 4723
			{"剥皮训练师", "海伦尼·派特斯金纳",{46.2,62.2},0}, -- 6306
			{"裁缝训练师", "艾尔丁",{79.2,69.0},0}, -- 1103
			{"裁缝训练师", "莱恩·法尔娜",{42.0,67.0},0}, -- 47384
			{"恶魔训练师", "塞琳娜·达克哈特",{44.4,66.0},0}, -- 6374
		},

		-- Eversong Woods
		["永歌森林"]={
		-- 飞行管理员
			{"龙鹰管理员", "葛拉米",{54.4,50.8}}, -- 16192
			{"龙鹰管理员", "飞行管理员晨光",{44.0,77.0}}, -- 44036
			{"龙鹰管理员", "飞行管理员斯凯勒斯",{46.2,46.8}}, -- 44244
		-- 旅店老板
			{"旅店老板", "玛尼尔·琥珀之光",{43.6,71.2}}, -- 15397
			{"旅店老板", "旅店老板德兰妮尔",{48.0,47.6}}, -- 15433
		-- 兽栏管理员
			{"兽栏管理员", "阿娜索丝",{47.6,47.2}}, -- 16185
		-- 专业训练师
			{"炼金术训练师", "奥术师森纳瑟林",{38.2,72.6}}, -- 16161
			{"炼金术训练师", "塞伦",{48.8,46.8}}, -- 47421
			{"锻造训练师", "阿拉瑟尔",{59.6,62.6}}, -- 15400
			{"烹饪训练师", "卡雷斯特拉",{48.6,47.0}}, -- 16277
			{"附魔训练师", "魔导师艾雷达妮娅",{38.2,72.6}}, -- 16160
			{"急救训练师", "卡娜莉亚",{48.4,47.6}}, -- 16272
			{"草药学训练师", "植物学家塔尼安雷尔",{37.4,71.8}}, -- 16367
			{"草药学训练师", "塞伦",{48.8,46.8}}, -- 47421
			{"珠宝加工训练师", "奥雷妮亚",{48.4,47.4}}, -- 15501
			{"珠宝加工训练师", "塞伦",{48.8,46.8}}, -- 47421
			{"制皮训练师", "萨瑟林",{53.6,51.2}}, -- 16278
			{"采矿训练师", "塞伦",{48.8,46.8}}, -- 47421
			{"骑术训练师", "佩拉斯卡米",{61.2,54.0}}, -- 16280
			{"剥皮训练师", "玛斯雷恩",{53.8,51.2}}, -- 16273
			{"裁缝训练师", "女裁缝蔻妮·琥珀之光",{37.4,71.8}}, -- 16366
			{"恶魔训练师", "戴丝特拉",{48.2,47.8}}, -- 16267
		-- 商人
			{"银月城军需官", "女魔导师妮萨拉",{54.2,50.8}}, -- 50484
		},

		-- [LEGION] Tirisfal Glades -- need update
		["提瑞斯法林地"]={
		-- 飞行管理员
			{"蝙蝠管理员", "提摩西·卡宁汉",{83.4,70.0},0}, -- 37915
			{"蝙蝠管理员", "安内特·威廉姆斯",{58.8,51.8},0}, -- 43124
		-- 旅店老板
			{"旅店老板", "旅店老板瑞尼",{60.8,51.6},0}, -- 5688
		-- 兽栏管理员
			{"兽栏管理员", "莫加努斯",{61.8,52.0},0}, -- 10055
		-- 专业训练师
			{"炼金术训练师", "卡罗莱·安尼斯",{59.4,52.0},0}, -- 2132
			{"烹饪训练师", "大厨",{61.2,52.4},0}, -- 47405
			{"附魔训练师", "范斯·安德格鲁姆",{59.8,53.2},0}, -- 5695
			{"急救训练师", "妮拉",{59.8,52.0},0}, -- 5759
			{"钓鱼训练师", "克莱德·凯林",{67.2,51.0},0}, -- 5690
			{"草药学训练师", "法鲁萨",{59.4,52.0},0}, -- 2114
			{"草药学训练师", "尼德里奇·沙洛",{61.0,51.0},0}, -- 47400
			{"制皮训练师", "舍伦尼·洛巴尔特",{65.4,60.0},0}, -- 3549
			{"采矿训练师", "尼德里奇·沙洛",{61.0,51.0},0}, -- 47400
			{"骑术训练师", "维尔玛·瓦纳姆",{61.8,51.8},0}, -- 4773
			{"剥皮训练师", "兰德·洛巴尔特",{65.4,60.0},0}, -- 6289
			{"剥皮训练师", "尼德里奇·沙洛",{61.0,51.0},0}, -- 47400
			{"裁缝训练师", "博文·布里斯博埃斯",{52.6,55.6},0}, -- 3523
			{"裁缝训练师", "尼德里奇·沙洛",{61.0,51.0},0}, -- 47400
			{"恶魔训练师", "吉娜·朗恩",{61.0,50.4},0}, -- 5750
		-- 商人
			{"银色黎明军需官", "<中立>银色黎明军需官哈萨娜",{83.2,68.0},0}, -- 10856
		-- 交通工具
			{"传送宝珠", "内部圣殿-银月城",{59.4,67.5},0},
			{"飞艇", "复仇港-嚎风峡湾",{58.5,59.0},0},
			{"飞艇", "奥格瑞玛-杜隆塔尔;格罗姆高营地-北荆棘谷",{62.5,59.0},0},
		},

		-- Westfall
		["西部荒野"]={
		-- 飞行管理员
			{"狮鹫管理员", "索尔",{56.6,49.4},0}, -- 523/110587 恶魔入侵
			{"狮鹫管理员", "霍博艾尔",{49.8,18.8},0}, -- 42406
			{"狮鹫管理员", "缇娜·斯基登",{42.0,63.4},0}, -- 42426
		-- 旅店老板
			{"旅店老板", "旅店老板希瑟尔",{52.8,53.6},0}, -- 8931/110583 恶魔入侵
		-- 兽栏管理员
			{"兽栏管理员", "科尔克·麦克斯韦尔",{53.0,53.0},0}, -- 10045
		},

		-- Loch Modan
		["洛克莫丹"]={
		-- 飞行管理员
			{"狮鹫管理员", "索格拉姆·伯雷森",{33.8,50.8}}, -- 1572
			{"狮鹫管理员", "艾瑞文·格蕾尔",{81.8,64.2}}, -- 41332
		-- 旅店老板
			{"旅店老板", "维林·疾风",{81.8,64.4}}, -- 1156
			{"旅店老板", "旅店老板纳克罗·壁炉",{35.4,48.4}}, -- 6734
		-- 兽栏管理员
			{"兽栏管理员", "丽娜·壁炉",{34.6,48.0}}, -- 9989
			{"兽栏管理员", "格拉芬因·钢须",{84.0,62.8}}, -- 43979
		-- 专业训练师
			{"炼金术训练师", "加克",{37.0,49.2}}, -- 1470
			{"工程学训练师", "迪克",{42.8,10.0}}, -- 3290
			{"钓鱼训练师", "瓦格·深水",{40.6,39.6}}, -- 1683
			{"草药学训练师", "卡利",{36.4,48.4}}, -- 1473
			{"采矿训练师", "布洛克·寻石者",{37.0,47.8}}, -- 1681
		},

		-- Ghostlands
		["幽魂之地"]={
		-- 飞行管理员
			{"龙鹰管理员", "飞行管理员加尼斯·日翼",{45.4,30.6},0}, -- 16189
			{"中立飞行管理员", "吉兹·考斯班纳",{74.6,67.0},0}, -- 24851
		-- 旅店老板
			{"旅店老板", "维林·疾风",{48.4,32.4},0}, -- 1156
		-- 兽栏管理员
			{"兽栏管理员", "帕尼亚",{48.4,31.2},0}, -- 16665
		-- 专业训练师
			{"烹饪训练师", "大厨师莫迪尔",{48.4,31.0},0}, -- 16253
		-- 商人
			{"部落<塔奎林勇士披风>商人", "补给官弗雷迪加",{47.6,32.2},0}, -- 16528
		},

		-- Silverpine Forest
		["银松森林"]={
		-- 飞行管理员
			{"蝙蝠管理员", "卡洛斯·拉佐克",{45.4,42.4}}, -- 2226
			{"飞行管理员", "蝙蝠管理员玛格特布里斯",{57.8,8.8}}, -- 44825
			{"蝙蝠管理员", "史蒂芬·斯图扎卡",{50.8,63.6}}, -- 46552
			{"蝙蝠管理员", "弗兰妮·梅尔兹",{45.8,21.8}}, -- 50463
		-- 旅店老板
			{"旅店老板", "旅店老板贝茨",{46.4,42.6}}, -- 6739
			{"旅店老板", "指挥官辛克雷",{44.4,20.4}}, -- 45496
		-- 兽栏管理员
			{"兽栏管理员", "萨拉·古迪",{46.0,42.6}}, -- 9979
			{"兽栏管理员", "“老水兵”洛克卡",{44.6,20.8}}, -- 45498
		-- 专业训练师
			{"锻造训练师", "古拉摩·索洛伊",{42.8,40.8}}, -- 3557
			{"采矿训练师", "乔汉·弗彻",{43.4,40.6}}, -- 3555
		},

		-- Redridge Mountains
		["赤脊山"]={
		-- 飞行管理员
			{"狮鹫管理员", "艾蕾娜·斯托姆法瑟",{29.4,53.6}}, -- 931
			{"狮鹫管理员", "诺拉·巴尔德温",{77.8,65.8}}, -- 43072
			{"狮鹫管理员", "阿尔伦·玛尔斯特",{52.8,54.6}}, -- 43371
		-- 旅店老板
			{"旅店老板", "旅店老板布瑞安娜",{26.2,41.4}}, -- 6727
		-- 兽栏管理员
			{"兽栏管理员", "本尼",{26.2,43.0}}, -- 9982
		-- 专业训练师
			{"烹饪训练师", "克里斯托·鲍曼",{22.8,40.4}}, -- 3087
			{"钓鱼训练师", "马修·胡柏",{26.0,46.6}}, -- 1680
			{"草药学训练师", "奥玛·詹洛斯",{22.0,42.2}}, -- 812
			{"剥皮训练师", "威尔玛·兰萨尔",{78.6,63.6}}, -- 6295
		},

		-- Duskwood
		["暮色森林"]={
		-- 飞行管理员
			{"狮鹫管理员", "菲利希亚·玛林",{77.4,44.2}}, -- 2409
			{"狮鹫管理员", "约翰·谢尔比",{21.0,56.6}}, -- 43697
		-- 旅店老板
			{"旅店老板", "旅店老板崔莱尼",{73.8,44.4}}, -- 6790
		-- 兽栏管理员
			{"兽栏管理员", "斯蒂文·布莱克",{74.0,46.2}}, -- 10062
		-- 专业训练师
			{"锻造训练师", "克拉莉斯·纳尔特里",{74.0,48.4}}, -- 3136
			{"工程学训练师", "芬布斯",{77.4,48.6}}, -- 1676
			{"采矿训练师", "玛特·约翰森",{73.8,49.8}}, -- 3137
		-- 商人
			{"中立<稀有货物>商人", "卡兹克斯",{81.8,19.8}}, -- 3134
		},

		-- Wetlands
		["湿地"]={
		-- 飞行管理员
			{"狮鹫管理员", "谢尔雷·布隆迪尔",{9.4,59.6}}, -- 1571
			{"狮鹫管理员", "艾尔金·巴勒",{38.6,39.0}}, -- 41321
			{"角鹰兽管理员", "哈兰娜",{56.4,41.8}}, -- 41322
			{"狮鹫管理员", "达蒙·巴尔罗",{38.6,39.0}}, -- 41323
			{"狮鹫管理员", "卡雷布·巴耶罗",{50.0,18.4}}, -- 41325
		-- 旅店老板
			{"旅店老板", "旅店老板赫布瑞克",{10.6,60.8}}, -- 1464
			{"旅店老板", "旅店老板道格尼",{25.6,25.8}}, -- 44006
			{"旅店老板", "旅店老板拉莉萨",{58.0,39.2}}, -- 43993
		-- 兽栏管理员
			{"兽栏管理员", "贝塞尼·火锤",{10.6,59.6}}, -- 10046
			{"兽栏管理员", "萨鲁斯特雷德",{57.6,40.2}}, -- 43994
			{"兽栏管理员", "谢普·金牌养护",{26.2,25.8}}, -- 44007
		-- 专业训练师
			{"急救训练师", "弗雷玛尔",{10.6,60.2}}, -- 3181
			{"钓鱼训练师", "哈洛德·李格斯",{8.0,58.6}}, -- 3179
			{"草药学训练师", "泰伦瑞诺·月影",{11.2,52.0}}, -- 1458
		-- 交通工具
			{"船舶", "瓦加德-嚎风峡湾",{5.1,55.7}},
			{"船舶", "塞拉摩-尘泥沼泽",{6.4,62.3}},
		},

		-- Hillsbrad Foothills
		["希尔斯布莱德丘陵"]={
		-- 飞行管理员
			{"蝙蝠管理员", "扎瑞斯",{56.0,46.0}}, -- 2389/110404 恶魔入侵
			{"蝙蝠管理员", "达尔拉·哈瑞斯",{49.0,66.2}}, -- 47644/110940 恶魔入侵
			{"蝙蝠管理员", "帕梅拉·斯图扎卡",{29.0,64.4}}, -- 47655
			{"蝙蝠管理员", "达伦·朗费罗",{59.6,63.2}}, -- 47661/110769 恶魔入侵
			{"蝙蝠管理员", "菲利普·哈尔丁",{58.2,26.4}}, -- 47665
		-- 旅店老板
			{"旅店老板", "旅店老板沙恩",{57.8,47.2}}, -- 2388/112837 恶魔入侵
			{"旅店老板", "旅店老板哈尔希贝格",{35.8,61.2}}, -- 49394
			{"旅店老板", "旅店老板杜更斯",{60.2,64.0}}, -- 49430
		-- 兽栏管理员
			{"兽栏管理员", "塞多蒙·克莱尔",{56.8,46.8}}, -- 10057/110357 恶魔入侵
			{"兽栏管理员", "莎侬·朗博",{36.2,61.6}}, -- 49395/110889 恶魔入侵
			{"兽栏管理员", "安歇尔·汤瑟沃斯",{59.6,64.8}}, -- 49431
		-- 专业训练师
			{"炼金术训练师", "瑟尔格·希诺特",{49.0,66.2}}, -- 2391
			{"草药学训练师", "阿兰奈·维诺布拉德",{57.2,47.4}}, -- 2390/110345 恶魔入侵
			{"裁缝训练师", "达瑞尔·斯塔克",{58.0,47.8}}, -- 2399
		-- 商人
			{"雷矛军需官", "塔萨迪斯·雪光",{44.6,46.6}}, -- 13217
			{"霜狼军需官", "乔雷克·铁盾",{58.0,33.6}}, -- 13219
			{"中立<炼金配方：冰霜之油>商人", "布洛金",{44.0,21.8}}, -- 2480
		},

		-- Arathi Highlands
		["阿拉希高地"]={
		-- 飞行管理员
			{"狮鹫管理员", "瑟迪克·普罗斯",{39.8,47.4}}, -- 2835
			{"双足飞龙管理员", "尤尔达",{68.2,33.4}}, -- 2851
			{"蝙蝠管理员", "洛达·鲍威",{13.4,34.8}}, -- 43104
		-- 旅店老板
			{"联盟旅店老板", "维基·隆萨夫",{40.0,49.0}}, -- 2808
			{"部落旅店老板", "旅店老板埃德瓦",{69.0,33.4}}, -- 9501
		-- 兽栏管理员
			{"部落兽栏管理员", "萨里顿",{69.0,34.0}}, -- 9976
			{"联盟兽栏管理员", "艾米莉·杰克逊",{40.0,49.0}}, -- 44123
		-- 专业训练师
			{"部落制皮训练师", "布鲁姆·白蹄",{21.8,46.6}}, -- 7869
		-- 商人
			{"污染者军需官", "卢瑟弗·图恩",{68.4,30.6}}, -- 15126
			{"阿拉索军需官", "萨缪尔·霍克",{40.2,46.4}}, -- 15127
		},

		-- Northern Stranglethorn
		["北荆棘谷"]={
		-- 飞行管理员
			{"双足飞龙管理员", "塞斯塔",{39.0,51.2}}, -- 1387
			{"狮鹫管理员", "罗伯特·洛德斯",{52.6,66.2}}, -- 43042
			{"狮鹫管理员", "詹姆斯·斯蒂莱尔",{47.8,11.8}}, -- 43045
			{"部落飞行管理员", "拉斯克哈",{62.4,39.2}}, -- 43052
		-- 旅店老板
			{"部落旅店老板", "旅店老板苏贝克",{37.2,51.8}}, -- 5814
			{"联盟旅店老板", "利文斯顿·马绍尔",{53.2,66.8}}, -- 44019
		-- 兽栏管理员
			{"部落兽栏管理员", "杜雷克",{38.0,51.2}}, -- 16094
		-- 专业训练师
			{"部落烹饪训练师", "玛杜克",{37.2,49.2}}, -- 1382
			{"部落草药学训练师", "安格伦",{38.6,48.4}}, -- 2856
			{"部落制皮训练师", "布劳恩",{37.8,50.4}}, -- 1385
			{"部落制皮训练师", "瑟伊布",{45.2,58.6}}, -- 7871
		-- 交通工具
			{"飞艇", "奥格瑞玛-杜隆塔尔;提瑞斯法林地",{37.5,51.5}},
		},

		-- The Cape of Stranglethorn
		["荆棘谷海角"]={
		-- 拍卖师
			{"拍卖师", "拍卖师克雷斯克",{42.0,73.4}}, -- 9858
			{"拍卖师", "拍卖师格拉维斯",{43.0,71.4}}, -- 15677
			{"拍卖师", "拍卖师奥利雷",{40.2,72.2}}, -- 15681
		-- 银行职员
			{"银行职员", "掘金者维兹尼克",{40.0,72.4}}, -- 2625
			{"银行职员", "掘金者里克",{40.0,72.4}}, -- 8123
		-- 飞行管理员
			{"双足飞龙管理员", "格林戈",{40.6,73.2}}, -- 2858
			{"狮鹫管理员", "盖尔",{41.6,74.4}}, -- 2859
			{"狮鹫管理员", "科林·迅锤",{55.6,41.2}}, -- 43043/52646
			{"部落飞行管理员", "希兹尔",{35.0,39.2}}, -- 43053
		-- 旅店老板
			{"旅店老板", "旅店老板斯金德",{40.8,73.8}}, -- 6807
			{"部落旅店老板", "旅店老板德拉克希尔",{35.0,27.2}}, -- 44190
		-- 兽栏管理员
			{"兽栏管理员", "格雷米斯塔克",{41.4,73.6}}, -- 10060
			{"部落兽栏管理员", "费奇·沃奇沃兹",{34.8,27.6}}, -- 44191
		-- 专业训练师
			{"炼金术训练师", "加克森",{42.6,74.8}}, -- 2837
			{"锻造训练师", "布里克·基克拉夫",{44.0,70.8}}, -- 2836
			{"烹饪训练师", "甘特夫人",{42.6,72.8}}, -- 54232
			{"工程学训练师", "奥格索普·奥布诺提斯",{43.0,72.0}}, -- 7406
			{"钓鱼训练师", "麦依兹·拉齐卡",{41.6,73.4}}, -- 2834
			{"草药学训练师", "弗洛拉·希沃温德",{42.0,74.6}}, -- 908
			{"裁缝训练师", "格拉尼克·古斯提",{43.6,73.0}}, -- 2627
		-- 商人
			{"中立<鹦鹉笼>商人", "纳尔克",{42.6,69.2}}, -- 2663
		-- 交通工具
			{"船舶", "棘齿城-北贫瘠之地",{38.6,67.4}},
		},

		-- The Hinterlands
		["辛特兰"]={
		-- 飞行管理员
			{"双足飞龙管理员", "格卡斯",{81.6,81.8}}, -- 4314
			{"狮鹫管理员", "戈斯鲁姆",{11.0,46.0}}, -- 8018
			{"狮鹫管理员", "布罗克·铁须",{65.6,44.8}}, -- 43570
			{"部落飞行管理员", "凯伦·库恩",{32.4,58.0}}, -- 43573
		-- 旅店老板
			{"联盟旅店老板", "旅店老板苏弗拉姆",{14.0,44.8}}, -- 7744
			{"部落旅店老板", "拉尔德",{78.2,81.2}}, -- 14731
			{"联盟旅店老板", "旅店老板柯尔南",{66.2,44.4}}, -- 43699
			{"部落旅店老板", "小小胖",{31.8,58.0}}, -- 43739
		-- 兽栏管理员
			{"联盟兽栏管理员", "基利姆·石趾",{14.4,45.2}}, -- 10061
			{"部落兽栏管理员", "猎户马克霍尔",{79.0,79.6}}, -- 14741
			{"联盟兽栏管理员", "塔萨恩·雷石",{66.4,45.0}}, -- 43770
			{"部落兽栏管理员", "罗斯林·帕克斯顿",{32.0,57.6}}, -- 43766
		-- 专业训练师
			{"联盟制皮训练师", "德拉克·石拳",{13.4,43.4}}, -- 11097
			{"部落钓鱼训练师", "钓鱼者卡图姆",{80.4,81.4}}, -- 14740
		},

		-- Western Plaguelands
		["西瘟疫之地"]={
		-- 飞行管理员
			{"狮鹫管理员", "比比尔法兹",{42.8,85.0}}, -- 12596
			{"蝙蝠管理员", "朗达·莫维尔",{46.6,64.6}}, -- 46004
			{"联盟飞行管理员", "金妮·古德温",{39.4,69.4}}, -- 46006
			{"中立狮鹫管理员", "玛吉·赫夫曼",{50.4,52.2}}, -- 46011
			{"中立飞行管理员", "威廉·亨特尔森",{44.6,18.4}}, -- 47875
		-- 旅店老板
			{"联盟旅店老板", "马特莉大妈",{43.4,84.4}}, -- 46269
			{"部落旅店老板", "罗曼·加内尔",{48.2,63.8}}, -- 47857
		-- 兽栏管理员
			{"兽栏管理员", "汉克·福特",{47.2,31.8}}, -- 47761
			{"部落兽栏管理员", "洛伊斯·亨德尔森",{47.8,64.0}}, -- 47866
		-- 商人
			{"银色北伐军需官", "银色黎明军需官莱斯巴克",{42.8,83.8}}, -- 10857
			{"中立<元素精华炼金配方>商人", "玛格努斯·霜鸣",{68.0,77.6}}, -- 11278
		},

		-- Eastern Plaguelands
		["东瘟疫之地"]={
		-- 飞行管理员
			{"狮鹫管理员", "凯琳·斯蒂文",{75.8,53.4}}, -- 12617
			{"飞行管理员", "格莱森·铁翼",{51.2,21.2}}, -- 28621
			{"飞行管理员", "鬼翼",{83.8,50.2}}, -- 29480
			{"飞行管理员", "弗莱克斯·巴克特德普",{10.0,65.8}}, -- 37888
			{"飞行管理员", "理查德·杜鲁弗赖特",{61.6,43.8}}, -- 44230
			{"飞行管理员", "德沃·曼宁",{52.8,53.6}}, -- 44231
			{"飞行管理员", "詹尼丝·迈尔斯",{34.8,68.0}}, -- 44232
			{"飞行管理员", "小威廉·凯拉",{18.4,27.4}}, -- 44233
		-- 旅店老板
			{"旅店老板", "杰希卡·查伯斯",{75.6,52.4}}, -- 16256
		-- 商人
			{"银色北伐军军需官", "军需官米兰达·布利洛克",{75.8,54.0}}, -- 11536
			{"牧师圣骑士<技能书>商人", "军需官米兰达·布利洛克",{75.8,54.0}}, -- 11536 -- need translation 7.0.3新增职业物品
			{"死亡骑士军需官", "军需官奥佐格",{82.0,48.2}}, -- 28512
			{"死亡骑士商人", "黑锋骸骨狮鹫;技能书",{68.0,77.6}}, -- 29587 -- need translation 7.0.3新增职业物品
			--{"中立<白银之手套装>PvE装备商", "Eadric the Pure",{75.6,49.2}}, -- 100196 -- need update -- 地图上不显示，会移入职业大厅
		},

		-- Badlands
		["荒芜之地"]={
		-- 飞行管理员
			{"双足飞龙管理员", "格里克",{17.2,40.2},0}, -- 2861
			{"飞行管理员", "米可兹·蜜旅",{64.2,35.2},0}, -- 44407
			{"部落飞行管理员", "塞拉娜",{52.4,50.8},0}, -- 44408
			{"联盟飞行管理员", "南希·空酒",{48.4,36.2},0}, -- 44409
			{"联盟飞行管理员", "杰克·荒地",{21.6,57.6},0}, -- 44410
		-- 旅店老板
			{"部落旅店老板", "旅店老板舒尔卡",{18.2,42.8},0}, -- 9356
			{"旅店老板", "莎莉·固轮",{65.8,35.6},0}, -- 48054
			{"联盟旅店老板", "埃文·齐菲尔",{20.6,56.2},0}, -- 48093
			{"旅店老板", "伟大的皮萨尼",{90.0,37.6},0}, -- 49934
		-- 兽栏管理员
			{"部落兽栏管理员", "格雷斯",{18.2,42.2},0}, -- 10058
			{"兽栏管理员", "迪迪·投矢",{65.6,36.4},0}, -- 48055
			{"联盟兽栏管理员", "卡催娜·莱昂斯",{21.0,56.6},0}, -- 48095
		},

		-- Searing Gorge
		["灼热峡谷"]={
		-- 飞行管理员
			{"狮鹫管理员", "兰尼·瑞德",{37.8,30.6},0}, -- 2941
			{"双足飞龙管理员", "格瑞沙",{34.8,30.8},0}, -- 3305
			{"飞行管理员", "道格·俯冲",{41.0,68.6},0}, -- 47927
		-- 旅店老板
			{"旅店老板", "威尔玛·崩岩",{39.4,66.2},0}, -- 47942
		-- 兽栏管理员
			{"兽栏管理员", "卡恩·峭牧",{40.6,68.6},0}, -- 47934
		},

		-- Burning Steppes
		["燃烧平原"]={
		-- 飞行管理员
			{"狮鹫管理员", "博古斯·粗臂",{72.2,65.6},0}, -- 2299
			{"双足飞龙管理员", "瓦格鲁克",{54.2,24.2},0}, -- 13177
			{"飞行管理员", "汉斯·石翱",{17.6,52.6},0}, -- 48318
			{"飞行管理员", "格里姆·焦羽",{46.0,41.8},0}, -- 48321
		-- 商人
			{"术士绝版<克索诺斯恐惧战马任务物品>商人", "戈瑟奇·邪眼",{8.2,35.8},0}, -- 14437
		},

		-- Deadwind Pass -- need update
		["逆风小径"]={
		-- 拍卖师
			{"蒸汽动力拍卖师", "Brassbolt Mechawrench",{43.8,67.2}}, -- 99094
		-- 银行职员
			{"银行职员", "Teller Gee",{45.6,84.2}}, -- 113414
			{"银行职员", "Teller Plushner",{45.6,85.2}}, -- 113415
		-- 兽栏管理员
			{"兽栏管理员", "Tassia Whisperglen",{50.8,71.4}}, -- 113337
		-- 专业训练师
			{"炼金术训练师", "Linzy Blackbolt",{45.0,69.4}}, -- 99157
			{"锻造训练师", "Alard Schmied",{45.8,68.4}}, -- 99121
			{"附魔训练师", "Enchanter Nalthanis",{44.0,72.4}}, -- 98839
			{"工程学训练师", "Didi the Wrench",{44.0,67.2}}, -- 99076
			{"工程学训练师", "Findle Whistlesteam",{44.0,67.2}}, -- 99078
			{"工程学训练师", "Timofey Oshenko",{43.8,67.2}}, -- 99098
			{"急救训练师", "Olisarra the Kind",{43.2,71.0}}, -- 98843
			{"草药学训练师", "Dorothy Egan",{45.2,70.2}}, -- 99167
			{"铭文训练师", "Professor Pallin",{44.8,71.0}}, -- 99169
			{"珠宝加工训练师", "Timothy Jones",{44.4,70.4}}, -- 98901
			{"制皮训练师", "Namha Moonwater",{43.0,68.4}}, -- 98950
			{"采矿训练师", "Jedidiah Handers",{44.8,67.4}}, -- 99099
			{"裁缝训练师", "Ainderu Summerleaf",{43.2,70.0}}, -- 98908
		-- 商人
			{"法师<魔宠石>玩具商人", "恩多拉·莫尔海德",{43.6,77.2}}, -- 99337 -- 达拉然同名NPC 28715
		},

		-- Swamp of Sorrows
		["悲伤沼泽"]={
		-- 飞行管理员
			{"双足飞龙管理员", "布雷依克",{47.6,55.0}}, -- 6026
			{"中立狮鹫管理员", "斯基兹",{72.0,12.0}}, -- 43086
			{"狮鹫管理员", "宝拉·巴尔德温",{70.0,38.4}}, -- 43087
			{"飞行管理员", "耶德林",{30.6,34.6}}, -- 43088
		-- 旅店老板
			{"部落旅店老板", "旅店老板卡拉库尔",{46.8,56.8}}, -- 6930
			{"旅店老板", "格里奇船长",{71.6,13.8}}, -- 47334
			{"联盟旅店老板", "瓦拉德",{29.0,32.4}}, -- 47367
		-- 兽栏管理员
			{"部落兽栏管理员", "哈克鲁",{47.2,55.2}}, -- 10049
			{"兽栏管理员", "谢奇·虾猎",{72.0,14.8}}, -- 47337
			{"联盟兽栏管理员", "乔兰",{28.6,33.2}}, -- 47368
		-- 专业训练师
			{"部落炼金术训练师", "罗格瓦尔",{49.8,56.0}}, -- 1386
			{"部落传送门训练师", "洛林·跃火",{49.6,55.6}}, -- 27705
		},

		-- Plaguelands: The Scarlet Enclave
		["东瘟疫之地：血色领地"]={
		-- 商人
			{"死亡骑士军需官", "军需官奥佐格",{48.8,32.2}}, -- 28512
		},

		-- Blasted Lands
		["诅咒之地"]={
		-- 飞行管理员
			{"狮鹫管理员", "亚历山大·康斯坦丁",{61.2,21.6}}, -- 8609
			{"角鹰兽管理员", "格拉汉姆·麦凯利斯特",{47.0,89.2}}, -- 43107
			{"龙鹰管理员", "莎琳娜",{50.8,72.8}}, -- 43114
			{"双足飞龙管理员", "普蕾达",{43.6,14.2}}, -- 43121
			{"联盟飞行管理员", "阿拉兹",{67.6,28.0}}, -- 85731
			{"部落飞行管理员", "艾茉莉·风刃",{72.8,48.6}}, -- 85734
		-- 旅店老板
			{"部落旅店老板", "旅店老板格拉克",{40.4,11.4}}, -- 44309
			{"联盟旅店老板", "莫尔顿老妈",{60.6,14.0}}, -- 44325
			{"联盟旅店老板", "多娜·贝利莫",{44.4,87.6}}, -- 44334
		-- 兽栏管理员
			{"部落兽栏管理员", "克鲁夫",{41.6,12.8}}, -- 44310
			{"联盟兽栏管理员", "吉娜·格拉尔",{60.2,16.0}}, -- 44330
			{"联盟兽栏管理员", "威拉德·C·贝宁顿",{46.0,85.4}}, -- 44335
		-- 专业训练师
			{"联盟急救训练师", "“缝衣针”焊钉",{67.6,28.6}}, -- 76108
			{"部落急救训练师", "罗特·骨指",{72.2,47.8}}, -- 76519
		-- 商人
			{"联盟任务奖励兑换商人", "军需官琳黛勒",{66.4,27.6}}, -- 76117
			{"部落任务奖励兑换商人", "泽平·震钳",{71.6,49.0}}, -- 76522
		},

		-- Isle of Quel'Danas
		["奎尔丹纳斯岛"]={
		-- 飞行管理员
			{"中立龙鹰管理员", "欧胡拉",{48.4,25.2}}, -- 26560
		-- 旅店老板
			{"旅店老板", "护理员因纳拉",{51.0,33.8}}, -- 25036
		-- 兽栏管理员
			{"兽栏管理员", "塞拉菲娜·血心",{50.2,35.4}}, -- 25037
		-- 商人
			{"破碎残阳军需官", "艾尔达拉·晨行者",{47.2,30.6}}, -- 25032
			--{"PvE装备商", "瑟雷米斯",{50.2,28.6}}, -- 25976 "失落神器管理者"
			--{"PvE装备商", "伊尔玛",{50.2,28.2}}, -- 25977 "辛多雷圣物转化师"
			{"PvE装备商", "瑟雷米斯;伊尔玛",{50.2,28.6}}, -- 25976/25977
			--{"PvP装备商", "卡艾莉",{50.0,39.8}}, -- 26089 "特种装备销售商"
			--{"PvP装备商", "卡蕾娜",{49.6,40.4}}, -- 26090 "特种装备销售商"
			--{"PvP装备商", "欧鲁斯",{50.0,40.0}}, -- 26091 "特种装备销售商"
			--{"PvP装备商", "索因",{49.4,39.8}}, -- 26092 "特种装备销售商"
			{"PvP装备商", "卡艾莉;卡蕾娜;欧鲁斯;索因",{50.0,40.0}}, -- 26089/26090/26091/26092
		},

		-- Abyssal Depths
		["无底海渊"]={
		-- 飞行管理员
			{"联盟飞行管理员", "迅捷的海马",{56.8,75.4}}, -- 40866
			{"部落飞行管理员", "迅捷的海马",{53.8,59.6}}, -- 40873
		-- 旅店老板
			{"联盟旅店老板", "营房主管密尔逊",{54.6,72.2}}, -- 42963
			{"部落旅店老板", "旅店老板内留斯",{51.2,60.6}}, -- 43141
		-- 兽栏管理员
			{"联盟兽栏管理员", "凯斯·威瑟尔",{56.0,73.0}}, -- 42966
			{"部落兽栏管理员", "舒拉克",{53.0,59.2}}, -- 43151
		},

		-- Kelp'thar Forest
		["柯尔普萨之森"]={
		-- 飞行管理员
			{"飞行管理员", "迅捷的海马",{56.2,31.0}}, -- 40852
			{"部落飞行管理员", "迅捷的海马",{49.2,87.8}}, -- 43216
			{"联盟飞行管理员", "迅捷的海马",{42.4,66.2}}, -- 43287
		-- 旅店老板
			{"联盟旅店老板", "石语者埃鲁纳克",{45.0,23.2}}, -- 36915
			{"旅店老板", "石语者埃鲁纳克",{63.8,59.8}}, -- 41341
			{"部落旅店老板", "石语者埃鲁纳克",{38.8,31.6}}, -- 41618
		-- 商人
			{"联盟大地之环装备商人", "石语者埃鲁纳克",{45.0,23.2}}, -- 36915
			{"部落大地之环装备商人", "石语者埃鲁纳克",{38.8,31.6}}, -- 41618
		},

		-- Shimmering Expanse
		["烁光海床"]={
		-- 飞行管理员
			{"飞行管理员", "迅捷的海马",{49.4,41.2}}, -- 40851
			{"联盟飞行管理员", "迅捷的海马",{48.6,57.4}}, -- 40867
			--{"部落飞行管理员", "迅捷的海马",{50.8,63.4}}, -- 40871
			{"部落飞行管理员", "布里格拉尔",{61.0,28.2}}, -- 43220
			{"狮鹫管理员", "弗朗西斯·格林尼",{57.0,17.0}}, -- 43290
			{"部落飞行管理员", "迅捷的海马",{49.4,65.6}}, -- 43293
		-- 旅店老板
			{"旅店老板", "看护者穆拉",{49.2,42.0}}, -- 39878
			{"联盟旅店老板", "阿丽莎·玛西利",{49.6,57.4}}, -- 42873
			{"部落旅店老板", "尊加",{51.6,62.6}}, -- 42908
		-- 兽栏管理员
			{"兽栏管理员", "看护者阿鲁",{49.4,42.0}}, -- 41903
			{"联盟兽栏管理员", "米莉安·黄铜炸弹",{49.0,57.6}}, -- 42875
			{"部落兽栏管理员", "拉洛克",{51.4,62.6}}, -- 42911
		-- 商人
			{"大地之环军需官", "补给官阿罗克",{49.0,42.0}}, -- 50324
		},

		-- Vashj'ir
		["瓦丝琪尔"]={
		-- 飞行管理员
			{"部落飞行管理员", "布洛格多尔",{64.8,68.0}}, -- 43225
			{"联盟飞行管理员", "湿咸的麦克特拉维斯",{69.4,75.2}}, -- 43295
		},

		-- Twilight Highlands
		["暮光高地"]={
		-- 飞行管理员
			--{"狮鹫管理员", "安古斯·巍山",{43.8,57.2}}, -- 45904
			--{"双足飞龙管理员", "乔乔·黏脖",{45.6,76.0}}, -- 45947
			{"部落飞行管理员", "哈尔波·电肘",{75.4,17.8}}, -- 47061
			--{"双足飞龙管理员", "托克罗格",{45.6,76.2}}, -- 47116
			{"双足飞龙管理员", "托克罗格;乔乔·黏脖",{45.6,76.2}}, -- 45947/47116
			--{"狮鹫管理员", "戴斯蒙德·查德沃斯",{43.8,57.2}}, -- 47118
			{"狮鹫管理员", "戴斯蒙德·查德沃斯;安古斯·巍山",{43.8,57.2}}, -- 45904/47118
			{"狮鹫管理员", "格伦·阿尔巴克",{81.6,77.0}}, -- 47119
			{"飞行管理员", "阿奎纳斯塔兹",{28.4,24.8}}, -- 47121
			{"双足飞龙管理员", "桑希格",{36.8,38.0}}, -- 47133
			{"狮鹫管理员", "法斯塔德·石握",{60.4,57.6}}, -- 47147
			{"狮鹫管理员", "多朗·爪心",{48.6,28.2}}, -- 47154
			{"狮鹫管理员", "沙伊娜·爪心",{56.6,15.2}}, -- 47155
			{"双足飞龙管理员", "布拉莫克·血翼",{54.0,42.2}}, -- 47156
			{"部落飞行管理员", "格索乌",{73.8,52.8}}, -- 47174
		-- 旅店老板
			{"部落旅店老板", "旅店老板鲁茨",{75.8,52.6}}, -- 49498
			{"联盟旅店老板", "沃恩·密须",{54.6,18.0}}, -- 49574
			{"联盟旅店老板", "纳维恩·软鼻",{49.6,30.4}}, -- 49591
			{"联盟旅店老板", "本·莫拉",{43.6,57.2}}, -- 49599
			--{"联盟旅店老板", "旅店老板特蕾莎",{79.0,77.6}}, -- 49686
			--{"联盟旅店老板", "旅店老板弗朗西斯",{79.4,78.6}}, -- 49688
			{"联盟旅店老板", "旅店老板特蕾莎;旅店老板弗朗西斯",{79.0,77.6}}, -- 49686/49688
			{"部落旅店老板", "旅店老板克鲁姆",{45.0,76.6}}, -- 49747
			{"部落旅店老板", "旅店老板图尔克",{73.2,42.8}}, -- 49762
			{"部落旅店老板", "旅店老板吉诺",{75.4,16.6}}, -- 49783
			{"联盟旅店老板", "旅店老板科林",{60.4,58.0}}, -- 49795
		-- 兽栏管理员
			{"部落兽栏管理员", "卡纳斯",{75.6,52.6}}, -- 49554
			{"联盟兽栏管理员", "巴尔德·黑羽",{55.6,14.8}}, -- 49577
			{"联盟兽栏管理员", "塔尔姆·深谷",{48.6,29.6}}, -- 49593
			{"联盟兽栏管理员", "马修·彻奇希尔",{43.6,57.4}}, -- 49600
			{"联盟兽栏管理员", "邦妮·海宁根",{80.6,77.4}}, -- 49689
			{"部落兽栏管理员", "扎伊哈娜",{45.2,76.4}}, -- 49755
			{"部落兽栏管理员", "鲁克·脏塔",{53.8,43.0}}, -- 49767
			{"部落兽栏管理员", "卡兹·费查姆",{75.6,16.8}}, -- 49790
			{"联盟兽栏管理员", "科恩南",{60.2,58.0}}, -- 49803
		-- 商人
			{"蛮锤部族军需官", "克劳·麦克格罗",{48.6,30.6}}, -- 49386
			{"龙喉氏族军需官", "格罗特·致命打击",{53.8,42.0}}, -- 49387
			--{"联盟碎片商人", "塞希伊",{78.6,77.0}}, -- 50134
			--{"联盟重蛮皮商人", "米斯蒂·梅里维斯",{78.6,76.2}}, -- 50381
			--{"联盟燃钢锭商人", "布伦达尔·凿胆",{79.0,76.6}}, -- 50382
			--{"联盟烬丝布卷商人", "塞尔·费拉加",{78.6,76.8}}, -- 50386
			{"联盟兑换商人", "碎片;重蛮皮;燃钢锭;烬丝布卷",{78.6,77.0}}, -- 50134/50381/50382/50386
			--{"部落碎片商人", "阿加提亚·法拉诺斯",{76.6,49.4}}, -- 50146
			--{"部落重蛮皮商人", "斯雷姆·黑首",{75.2,50.0}}, -- 50172
			--{"部落燃钢锭商人", "库尔丹·钢齿",{77.2,53.0}}, -- 50375
			--{"部落烬丝布卷商人", "阿里斯塔莱昂·日织",{75.2,50.0}}, -- 50433
			{"部落兑换商人", "碎片;重蛮皮;燃钢锭;烬丝布卷",{76.6,49.4}}, -- 50146/50172/50375/50433
			{"中立<大灾变食品>商人", "古罗克·汉姆奇克",{50.6,58.4}}, -- 57262
		},

	-- 外域 Outland
		-- Hellfire Peninsula
		["地狱火半岛"]={
		-- 飞行管理员
			{"双足飞龙管理员", "巴尔雷",{56.2,36.2}}, -- 16587
			{"狮鹫管理员", "克莉尔·比特修",{54.6,62.4}}, -- 16822
			{"角鹰兽管理员", "古玛",{25.2,37.2}}, -- 18785
			{"双足飞龙管理员", "维拉加·乱羽",{87.4,48.2}}, -- 18930
			{"狮鹫管理员", "阿米什·蛮锤",{87.4,52.4}}, -- 18931
			{"双足飞龙管理员", "因娜丽雅",{27.8,60.0}}, -- 18942
			{"双足飞龙管理员", "阿米尔雅·风心",{61.6,81.2}}, -- 19558
			{"狮鹫管理员", "鲁恩托格·蛮锤",{78.4,35.0}}, -- 20234
		-- 旅店老板
			{"部落旅店老板", "弗洛伊德·平克",{56.6,37.4}}, -- 16602
			{"联盟旅店老板", "希德·利巴迪",{54.2,63.4}}, -- 16826
			{"部落旅店老板", "旅店老板巴希尔·欧洛塔斯",{26.8,59.6}}, -- 18905
			{"联盟旅店老板", "奥菲拉·风怒",{23.4,36.4}}, -- 18906
		-- 兽栏管理员
			{"部落兽栏管理员", "猎手托尔弗·怒蹄",{54.4,41.0}}, -- 16586
			{"联盟兽栏管理员", "军士长洛琳·萨梅洛克",{54.4,62.6}}, -- 16824
		-- 专业训练师
			{"联盟炼金术训练师", "炼金师格里比",{53.8,65.8}}, -- 18802
			{"联盟考古学训练师", "歌达·法德尔芙",{53.6,65.8}}, -- 47574
			{"联盟锻造训练师", "哈姆菲",{56.8,63.8}}, -- 16823
			{"联盟锻造训练师", "达姆菲",{51.2,60.2}}, -- 21209
			{"联盟烹饪训练师", "加斯顿",{54.0,63.4}}, -- 18987
			{"联盟附魔训练师", "乔汉·巴内斯",{53.6,66.0}}, -- 18773
			{"联盟工程学训练师", "莱布斯基",{55.6,65.4}}, -- 18775
			{"联盟急救训练师", "布尔库",{22.4,39.2}}, -- 18990
			{"联盟飞行训练师", "哈根·铜翼",{54.2,62.6}}, -- 35100
			{"联盟草药学训练师", "罗雷利恩",{53.6,65.8}}, -- 18776
			{"联盟铭文训练师", "迈克尔·斯克瓦",{54.0,65.6}}, -- 30721
			{"联盟珠宝加工训练师", "塔蒂亚娜",{54.6,63.6}}, -- 18774
			{"联盟制皮训练师", "布鲁曼",{54.0,64.0}}, -- 18771
			{"联盟采矿训练师", "霍纳克·格里莫德",{56.6,63.8}}, -- 18779
			{"联盟剥皮训练师", "耶蕾娜·夜空",{54.4,63.2}}, -- 18777
			{"联盟裁缝训练师", "哈玛",{54.6,63.6}}, -- 18772
			{"部落炼金术训练师", "药剂师安东尼维奇",{52.2,36.4}}, -- 16588
			{"部落考古学训练师", "茜拉贝尔",{52.4,36.0}}, -- 47573
			{"部落锻造训练师", "罗霍克",{53.2,38.2}}, -- 16583
			{"部落烹饪训练师", "阿莉森",{56.8,37.4}}, -- 49789
			{"部落附魔训练师", "菲兰妮娅",{52.2,36.0}}, -- 18753
			{"部落工程学训练师", "塞比格",{54.8,38.6}}, -- 18752
			{"部落急救训练师", "阿蕾瑟拉",{26.2,62.0}}, -- 18991
			{"部落飞行训练师", "驭风者雅胡布",{54.2,41.6}}, -- 35093
			{"部落草药学训练师", "鲁埃克·硬角",{52.2,36.2}}, -- 18748
			{"部落铭文训练师", "奈菲拉蒂",{52.2,36.0}}, -- 30722
			{"部落珠宝加工训练师", "卡莱恩",{56.8,37.6}}, -- 18751
			{"部落制皮训练师", "巴里姆·裂蹄",{56.2,38.6}}, -- 18754
			{"部落采矿训练师", "克鲁格什",{55.4,37.6}}, -- 18747
			{"部落剥皮训练师", "穆鲁图",{56.2,38.4}}, -- 18755
			{"部落裁缝训练师", "达琳娜",{56.6,37.2}}, -- 18749
		-- 商人
			{"荣耀堡军需官", "后勤军需官乌瑞卡",{56.6,62.6}}, -- 17657
			{"萨尔玛军需官", "军需官乌尔格隆",{54.8,37.8}}, -- 17585
			--{"联盟宝石商人", "委任官翠希·普罗维尔",{56.4,62.8}}, -- 18266
			--{"联盟宝石商人", "马库斯·斯卡兰",{53.9,63.5}}, -- 22227
			{"联盟宝石商人", "委任官翠希·普罗维尔;马库斯·斯卡兰",{56.4,62.8}}, -- 18266/22227
			--{"部落宝石商人", "传令官布莱肯·黑眼",{55.8,39.0}}, -- 18267
			--{"部落宝石商人", "雷甘·曼库索",{56.8,37.6}}, -- 22225
			{"部落宝石商人", "传令官布莱肯·黑眼;雷甘·曼库索",{55.8,39.0}}, -- 18267/22225

		},

		-- Zangarmarsh
		["赞加沼泽"]={
		-- 飞行管理员
			{"角鹰兽管理员", "蒙希",{67.8,51.4}}, -- 18788
			{"双足飞龙管理员", "杜迦",{33.0,51.0}}, -- 18791
			{"双足飞龙管理员", "古尔基尔",{84.8,55.0}}, -- 20762
			{"角鹰兽管理员", "哈卢",{41.2,28.8}}, -- 22485
		-- 旅店老板
			{"部落旅店老板", "梅拉吉特",{30.6,50.8}}, -- 18245
			{"联盟旅店老板", "看护者阿比达尔",{67.2,49.0}}, -- 18251
			{"旅店老板", "旅店老板考伊斯·斯托克顿",{78.4,63.0}}, -- 18907
			{"联盟旅店老板", "旅店老板克尔普",{41.8,26.2}}, -- 18908
		-- 兽栏管理员
			{"兽栏管理员", "卡米尔·长路",{78.8,64.2}}, -- 17896
			{"部落兽栏管理员", "坎兰",{31.8,49.8}}, -- 18244
			{"联盟兽栏管理员", "约拉尔",{67.6,49.6}}, -- 18250
		-- 专业训练师
			{"烹饪训练师", "纳卡",{78.6,63.0}}, -- 18993
			{"联盟工程学训练师", "凯莉·弗莱",{68.6,50.2}}, -- 17634
			{"部落工程学训练师", "马克·迪沃",{34.0,51.0}}, -- 17637
			{"部落钓鱼训练师", "苏尔加亚",{32.2,49.6}}, -- 18018
			{"钓鱼训练师", "基诺·杜弗莱",{78.0,66.0}}, -- 18911
		-- 商人
			{"塞纳里奥远征队军需官", "芬德雷·迅矛",{79.2,63.8}}, -- 17904
			{"孢子村军需官", "麦卡",{17.8,51.2}}, -- 18382
			{"荣耀堡印记商人", "部落战地斥候",{33.0,49.0}}, -- 18564
			{"萨尔玛印记商人", "联盟战地斥候",{64.6,46.4}}, -- 18581
		},

		-- Terokkar Forest
		["泰罗卡森林"]={
		-- 飞行管理员
			{"双足飞龙管理员", "柯纳",{49.2,43.4}}, -- 18807
			{"狮鹫管理员", "伏尔南·天啸",{59.4,55.4}}, -- 18809
		-- 旅店老板
			{"部落旅店老板", "旅店老板格里尔卡",{48.8,45.0}}, -- 18957
			{"联盟旅店老板", "旅店老板贝莉比",{56.6,53.2}}, -- 19296
		-- 兽栏管理员
			{"部落兽栏管理员", "塔拉戈",{49.4,44.6}}, -- 18984
			{"联盟兽栏管理员", "雷萨安",{56.8,53.8}}, -- 24905
		-- 专业训练师
			{"急救训练师", "学者恩沙姆",{30.8,76.0}}, -- 22477
			{"钓鱼训练师", "老渔夫巴尔洛",{38.6,12.8}}, -- 25580
		-- 商人
			{"天空卫队军需官", "格蕾拉",{64.2,66.2}}, -- 23367
			{"部落幽魂碎片商人", "灵魂先知加尔托克",{49.8,46.6}}, -- 19772
			{"联盟幽魂碎片商人", "灵魂先知斯兰",{56.0,53.6}}, -- 19773
		},

		-- Nagrand 477
		["纳格兰外域"]={
		-- 飞行管理员
			{"角鹰兽管理员", "菲尔古",{54.2,75.0}}, -- 18789
			{"双足飞龙管理员", "古尔沙",{57.2,35.2}}, -- 18808
		-- 旅店老板
			{"部落旅店老板", "蒂基特",{56.6,34.6}}, -- 18913
			{"联盟旅店老板", "看护者伊塞尔",{54.2,76.0}}, -- 18914
		-- 兽栏管理员
			{"部落兽栏管理员", "维尔达·熊鬃",{56.8,40.8}}, -- 19018
			{"联盟兽栏管理员", "卢弗塔希娅",{55.8,74.6}}, -- 19019
		-- 商人
			{"库雷尼军需官", "商人纳拉苏",{54.6,75.0}}, -- 20240
			{"玛格汉军需官", "补给官纳瑟拉",{53.4,36.8}}, -- 20241
			{"星界财团军需官", "帕斯塔兹",{30.6,57.0}}, -- 23007
			--{"部落哈兰勋章商人", "军需官亚弗雷·诺雷里克",{41.2,44.2}}, -- 18821
			--{"联盟哈兰勋章商人", "军需官达维安·瓦克拉弗",{41.2,44.2}}, -- 18822
			{"哈兰勋章商人", "[A]军需官达维安·瓦克拉弗;[H]军需官亚弗雷·诺雷里克",{41.2,44.2}}, -- 18821/18822
			{"萨满<技能书>商人", "元素师沙尔瓦克",{60.6,22.2}}, -- 18072 -- need translation 7.0.3新增职业物品
		},

		-- Blade's Edge Mountains
		["刀锋山"]={
		-- 飞行管理员
			{"角鹰兽管理员", "埃莫伦·叶影",{37.8,61.4}}, -- 18937
			{"双足飞龙管理员", "安努克·绿蹄",{52.0,54.2}}, -- 18953
			{"狮鹫管理员", "里普·派兹拉姆",{61.0,70.4}}, -- 21107
			{"飞行管理员", "菲恩·叶影",{61.6,39.6}}, -- 22216
			{"部落飞行管理员", "飞行管理员玛克索",{76.4,65.8}}, -- 22455
		-- 旅店老板
			{"联盟旅店老板", "旅店老板肖恩妮丝",{35.8,63.8}}, -- 19495
			{"部落旅店老板", "苟拉尔",{53.2,55.4}}, -- 19470
			{"部落旅店老板", "瓦拉伊",{76.0,60.2}}, -- 21088
			{"联盟旅店老板", "菲兹特·表针",{60.8,68.2}}, -- 21110
			{"旅店老板", "旅店老板埃蕾尔娅",{62.8,38.2}}, -- 22922
		-- 兽栏管理员
			{"部落兽栏管理员", "劳尔",{53.6,53.2}}, -- 19476
			{"部落兽栏管理员", "奥格林",{75.6,60.4}}, -- 22468
			{"联盟兽栏管理员", "菲斯卡·影歌",{36.0,64.6}}, -- 22469
			{"兽栏管理员", "天空卫队兽栏管理员",{27.6,52.6}}, -- 23392
		-- 专业训练师
			{"部落急救训练师", "菲拉·苍白行者",{53.8,55.0}}, -- 19478
			{"部落制皮训练师", "格里卡",{76.8,65.4}}, -- 21087
		-- 商人
			{"奥格瑞拉军需官", "霍纳斯",{28.0,58.6}}, -- 23428
			{"埃匹希斯商人", "资深以太技师",{54.4,10.8}}, -- 23244 "Aether-tech Adept"
			{"埃匹希斯商人", "资深以太技师",{54.4,10.8}}, -- 23245 "Aether-tech Master" -- need translation
		},

		-- Netherstorm
		["虚空风暴"]={
		-- 银行职员
			{"银行职员", "纳迪克斯",{33.0,67.8}}, -- 21732
			{"银行职员", "坎索",{32.8,68.0}}, -- 21733
			{"银行职员", "塞克希",{32.6,67.8}}, -- 21734
			{"银行职员", "米达",{32.2,37.2}}, -- 28343
		-- 飞行管理员
			{"飞行管理员", "克雷兹希尔",{33.8,64.0}}, -- 18938
			{"飞行管理员", "格伦尼克",{45.2,34.8}}, -- 19583
			{"飞行管理员", "哈帕克斯",{65.2,66.6}}, -- 20515
		-- 旅店老板
			{"旅店老板", "尤尼克斯",{43.4,36.0}}, -- 19531
			{"旅店老板", "旅店老板雷米·度苏",{32.0,64.4}}, -- 19571
		-- 兽栏管理员
			{"兽栏管理员", "里萨·卡勒菲克斯",{32.0,64.8}}, -- 24974
		-- 专业训练师
			{"附魔训练师", "阿萨纳",{44.2,33.6}}, -- 19540
			{"工程学训练师", "塞希罗",{32.4,66.6}}, -- 19576
			{"珠宝加工训练师", "贾达莱德",{44.4,34.0}}, -- 19539
		-- 商人
			{"星界财团军需官", "卡拉兹",{43.6,34.4}}, -- 20242
			--{"PvP装备商", "打击者科吉克",{33.0,64.2}}, -- 54650 "角斗士Gladiator" "复仇角斗士Vengeful" "残酷角斗士Merciless" "将军General" "统帅Marshal"
			--{"PvP装备商", "Izzee the 'Clutch'",{33.0,64.2}}, -- 107599 "残酷角斗士Merciless" "老兵Veteran" -- need translation
			--{"PvP装备商", "Kitzie Crankshot",{33.0,64.2}}, -- 107610 "复仇角斗士Vengeful" "守备官Vindicator" -- need translation
			--{"PvP装备商", "Blaze Magmaburn",{33.2,64.0}}, -- 107619 "野蛮角斗士Brutal" "守卫者Guardian" -- need translation
			{"PvP装备商", "老兵;统帅;将军;守备官;守卫者;S1;S2;S3;S4",{33.0,64.2}}, -- 54650/107599/107610/107619
			--{"PvE装备商", "克里希·宾奇维斯",{33.0,64.0}}, -- 23396 "经典旧世联盟锁甲及板甲"
			--{"PvE装备商", "格雷克斯·布莱伯勒",{33.0,64.0}}, -- 40209 "经典旧世联盟布甲及皮甲"
			--{"PvE装备商", "雷尼·“招牌微笑”·斯莫",{33.0,64.0}}, -- 54648 "经典旧世部落锁甲及板甲"
			--{"绝版PvE装备商", "佐克·托齐维克",{33.0,64.2}}, -- 54649 "经典旧世武器"
			--{"PvE装备商", "提尼·斯莫",{33.0,64.0}}, -- 58152 "经典旧世部落布甲及皮甲"
			{"PvE装备商", "克里希·宾奇维斯;格雷克斯·布莱伯勒,etc.",{33.0,64.0}}, -- 23396/40209/54648/54649/58152
			{"宠物商人", "商人拉沙德",{43.4,35.2}}, -- 20980 "特种小动物"
			{"<达拉然泰坦神铁徽记>商人", "Blaze Magmaburn",{33.2,64.0}}, -- 107619 -- need translation
		-- 其他NPC
			{"理发师", "普里克·斯韦尼",{31.0,66.8}}, -- 29145
		},

		-- Shadowmoon Valley 473
		["影月谷外域"]={
		-- 飞行管理员
			{"狮鹫管理员", "布鲁贝克·雷足",{37.6,55.4}}, -- 18939
			{"双足飞龙管理员", "德雷克格尔",{30.2,29.2}}, -- 19317
			{"飞行管理员", "玛蒂克斯",{63.2,30.4}}, -- 19581
			{"飞行管理员", "奥雷索尔",{56.2,57.8}}, -- 21766
		-- 旅店老板
			{"旅店老板", "看护者奥鲁罗",{61.0,28.2}}, -- 21746
			{"联盟旅店老板", "德雷格·掠云",{37.0,58.2}}, -- 19352
			{"旅店老板", "霍卢斯",{66.2,87.0}}, -- 23143
			{"部落旅店老板", "旅店老板达尔格·血爪",{30.2,27.8}}, -- 19319
			{"旅店老板", "伦德玛尔",{56.2,59.8}}, -- 21744
		-- 兽栏管理员
			{"联盟兽栏管理员", "克里恩·寻路者",{37.6,56.0}}, -- 19368
			{"部落兽栏管理员", "盖德拉",{29.2,29.4}}, -- 21336
		-- 专业训练师
			{"部落锻造训练师", "格鲁塔恩",{29.6,31.6}}, -- 19341
			{"联盟烹饪训练师", "希琳·钢翼",{37.2,58.4}}, -- 19369
			{"联盟工程学训练师", "奈奥比·维兹巴克",{36.6,55.0}}, -- 24868
			{"部落工程学训练师", "乔纳森·加雷特",{29.2,28.6}}, -- 25099
			{"部落飞行训练师", "欧尔洛克",{29.2,29.2}}, -- 20500
			{"联盟飞行训练师", "伊尔萨·枪酒",{37.2,56.2}}, -- 20511
		-- 商人
			{"中立<灵翼幼龙的缰绳>商人", "霍尔伦克",{65.6,86.0}}, -- 23489
		},

	-- 诺森德 Northrend
		-- Borean Tundra
		["北风苔原"]={
		-- 飞行管理员
			{"飞行管理员", "苏雷斯塔兹",{45.2,34.4}}, -- 24795
			{"双足飞龙管理员", "图莉达·冷风",{40.4,51.4}}, -- 25288
			{"联盟飞行管理员", "卡拉·芒星",{56.6,20.}}, -- 26602
			{"双足飞龙管理员", "乌姆·魂风",{77.6,37.8}}, -- 26847
			{"双足飞龙管理员", "基姆比扎",{49.6,11.0}}, -- 26848
			{"狮鹫管理员", "托马斯·雷维尔",{58.8,68.2}}, -- 26879
			{"飞行管理员", "战斗法师阿达米",{33.0,34.4}}, -- 27046
			{"飞行管理员", "比尔克·迪弗斯巴克",{78.4,51.4}}, -- 28195
		-- 旅店老板
			{"联盟旅店老板", "詹姆斯·迪肯",{58.2,68.0}}, -- 25245
			{"部落旅店老板", "威廉姆森",{41.8,54.4}}, -- 25278
			{"联盟旅店老板", "查莉·诺斯托",{57.0,18.6}}, -- 26596
			{"部落旅店老板", "帕乌·霜蹄",{76.2,37.2}}, -- 26709
			{"部落旅店老板", "护理者玛迦尔",{49.6,10.0}}, -- 27069
			{"旅店老板", "护理者普奥卢",{78.4,49.2}}, -- 27187
		-- 兽栏管理员
			{"部落兽栏管理员", "布蕾卡·狼女",{49.8,10.6}}, -- 27065
			{"联盟兽栏管理员", "塞莉德·酒痕",{58.4,68.6}}, -- 27010
			{"部落兽栏管理员", "杜尔克特·狼脉",{40.2,55.0}}, -- 26044
			{"部落兽栏管理员", "哈洛娜·雷语者",{77.0,37.2}}, -- 26721
			{"联盟兽栏管理员", "罗纳德·安德森",{56.6,73.0}}, -- 27385
			{"联盟兽栏管理员", "“母鹅”托比·铁栓",{57.0,19.0}}, -- 26597
			{"兽栏管理员", "猎手萨格哈尼",{78.0,49.0}}, -- 27194
		-- 专业训练师
			{"联盟炼金术训练师", "法隆·夜语",{57.8,71.8}}, -- 26987
			{"联盟考古学训练师", "法达·法德尔芙",{57.6,71.6}}, -- 47576
			{"联盟锻造训练师", "亚格·斯托德",{57.2,66.6}}, -- 26988
			{"联盟烹饪训练师", "罗里克·玛克雷尔",{57.8,71.6}}, -- 26989
			{"联盟附魔训练师", "亚莉希丝·玛洛",{57.6,71.6}}, -- 26990
			{"联盟工程学训练师", "索克·亮钉",{57.6,72.2}}, -- 26991
			{"联盟急救训练师", "布莱娜·维尔森",{57.8,66.2}}, -- 26992
			{"联盟钓鱼训练师", "老人罗伯特",{57.8,66.2}}, -- 26993
			{"联盟飞行训练师", "麦格拉·锋羽",{58.8,68.2}}, -- 35133
			{"联盟草药学训练师", "基琳·月舞",{57.8,71.8}}, -- 26994
			{"联盟铭文训练师", "汀克·亮钉",{57.6,71.6}}, -- 26995
			{"联盟珠宝加工训练师", "奥雷斯托斯",{57.4,72.2}}, -- 26997
			{"联盟制皮训练师", "洛丝玛丽·伯瓦尔德",{57.6,71.8}}, -- 26998
			{"联盟采矿训练师", "芬德里格·红须",{57.4,66.2}}, -- 26999
			{"联盟剥皮训练师", "猎户杰克",{57.6,71.8}}, -- 27000
			{"联盟裁缝训练师", "达尔林·古斯丁",{57.4,72.2}}, -- 27001
			{"部落炼金术训练师", "亚瑟·亨斯洛",{41.8,54.2}}, -- 26975
			{"部落考古学训练师", "林德雷尔",{41.2,53.8}}, -- 47577
			{"部落锻造训练师", "克洛格·钢骨",{40.8,55.2}}, -- 26981
			{"部落烹饪训练师", "奥恩·嫩蹄",{42.0,54.2}}, -- 26972
			{"部落附魔训练师", "艾欧莱·晨击",{41.2,53.8}}, -- 26980
			{"部落工程学训练师", "首席技师利维尼",{42.6,53.6}}, -- 25277
			{"部落急救训练师", "护士艾波伍德",{41.6,54.4}}, -- 29233
			{"部落钓鱼训练师", "渔夫瑟尔金",{41.8,54.6}}, -- 32474
			{"部落飞行训练师", "驭风者萨曼巴",{42.0,55.2}}, -- 35135
			{"部落草药学训练师", "塔希·蛮鬃",{42.0,53.6}}, -- 26974
			{"部落铭文训练师", "奥德蕾·炎枪",{41.2,53.8}}, -- 26977
			{"部落珠宝加工训练师", "格巴里",{41.6,53.4}}, -- 26982
			{"部落制皮训练师", "埃万·冰原",{76.2,37.0}}, -- 26996
			{"部落采矿训练师", "布隆娜·铁斧",{42.6,53.2}}, -- 26976
			{"部落剥皮训练师", "迪波妮·雷语者",{76.2,37.4}}, -- 26986
			{"部落裁缝训练师", "莱娜",{41.6,53.4}}, -- 26969
		-- 商人
			{"联盟先遣军军需官", "后勤官希瓦丝顿",{57.6,66.2}}, -- 32564
			{"部落远征军军需官", "迦拉·裂颅者",{41.4,53.6}}, -- 32565
			{"冬鳞蚌壳商人", "呀噜咕噜",{43.0,13.8}}, -- 25206
		-- 交通工具
			{"船舶","暴风城港口-暴风城",{59.7,69.4}},
			{"飞艇","奥格瑞玛-杜隆塔尔",{41.4,53.6}},
			{"船舶","莫亚基港口-龙骨荒野",{77.3,51.4}},
		},

		-- Howling Fjord
		["嚎风峡湾"]={
		-- 飞行管理员
			{"狮鹫管理员", "普莉希拉·冬风",{59.8,63.2}}, -- 23736
			{"狮鹫管理员", "格雷尔·岩锤",{31.2,44.0}}, -- 23859
			{"双足飞龙管理员", "塞莉亚·冰鬃",{49.4,11.6}}, -- 24032
			{"狮鹫管理员", "詹姆斯·奥斯比",{60.0,16.0}}, -- 24061
			{"蝙蝠管理员", "托比亚斯·萨克霍夫",{52.0,67.4}}, -- 24155
			{"蝙蝠管理员", "莉莉丝·拉德斯库",{26.0,25.0}}, -- 26844
			{"蝙蝠管理员", "艾德琳·查博斯",{79.0,29.6}}, -- 27344
			{"飞行管理员", "基普·特斯基普",{24.6,57.8}}, -- 28197
		-- 旅店老板
			{"联盟旅店老板", "旅店老板哈吉尔·拉格拉斯",{58.4,62.6}}, -- 23731
			{"联盟旅店老板", "旅店老板塞蕾丝·古德哈彻",{30.8,41.4}}, -- 23937
			{"部落旅店老板", "波雷·寒冬图腾",{49.4,10.8}}, -- 24033
			{"联盟旅店老板", "克利丝蒂娜·丹尼尔",{60.4,15.8}}, -- 24057
			{"部落旅店老板", "巴希尔·奥斯古德",{52.2,66.4}}, -- 24149
			{"部落旅店老板", "蒂姆斯·霍兰德",{79.6,30.8}}, -- 24342
			{"旅店老板", "护理员伊克尼克",{25.4,59.8}}, -- 27148
		-- 兽栏管理员
			{"联盟兽栏管理员", "马童霍拉提奥",{58.6,63.0}}, -- 23733
			{"联盟兽栏管理员", "阿尔提·灰手",{60.6,16.0}}, -- 24066
			{"部落兽栏管理员", "玛哈纳·霜蹄",{49.4,11.0}}, -- 24067
			{"部落兽栏管理员", "玛丽·达隆",{52.0,66.6}}, -- 24154
			{"部落兽栏管理员", "罗伯特·克拉克",{79.0,30.8}}, -- 24350
			{"兽栏管理员", "猎户塞什",{25.4,59.0}}, -- 27150
			{"联盟兽栏管理员", "切尔希·雷斯",{31.6,41.4}}, -- 29658
		-- 专业训练师
			{"联盟炼金术训练师", "拉诺利斯·晨露",{58.4,62.2}}, -- 26903
			{"联盟考古学训练师", "胡根·金智",{58.2,62.4}}, -- 47578
			{"联盟锻造训练师", "罗希娜·雷维特",{59.6,63.6}}, -- 26904
			{"联盟烹饪训练师", "布罗姆",{58.2,62.0}}, -- 26905
			{"联盟附魔训练师", "伊丽莎白·杰克森",{58.6,62.8}}, -- 26906
			{"联盟工程学训练师", "提沙·长桥",{59.6,64.0}}, -- 26907
			{"联盟急救训练师", "学者亚米娜",{59.8,62.2}}, -- 23734
			{"联盟钓鱼训练师", "拜隆·维尔维克",{60.2,64.0}}, -- 26909
			{"联盟草药学训练师", "菲因·语叶",{58.8,63.0}}, -- 26910
			{"联盟铭文训练师", "明蒂·丁克斯",{58.2,62.4}}, -- 26916
			{"联盟珠宝加工训练师", "恩霍罗",{59.8,63.8}}, -- 26915
			{"联盟制皮训练师", "波娜蒂特·迪克斯特",{59.8,63.6}}, -- 26911
			{"联盟采矿训练师", "格鲁伯尔·铁锄",{59.8,63.8}}, -- 26912
			{"联盟剥皮训练师", "菲德里克·布尔霍斯",{59.8,63.6}}, -- 26913
			{"联盟裁缝训练师", "本杰明·克莱格",{58.6,62.6}}, -- 26914
			{"部落炼金术训练师", "维尔赫米娜·雷尼尔",{78.6,28.6}}, -- 26951
			{"部落考古学训练师", "伊安·托马斯·沃尔",{79.4,29.2}}, -- 47568
			{"部落锻造训练师", "克里斯汀·斯米瑟",{79.2,29.0}}, -- 26952
			{"部落烹饪训练师", "托马斯·克里奇",{78.6,29.4}}, -- 26953
			{"部落附魔训练师", "埃米尔·奥顿",{78.6,28.2}}, -- 26954
			{"部落工程学训练师", "亚米希娜·瓦特雷",{78.4,30.0}}, -- 26955
			{"部落急救训练师", "萨莉·托普金斯",{79.4,29.4}}, -- 26956
			{"部落钓鱼训练师", "安吉丽娜·索伦",{79.4,27.2}}, -- 26957
			{"部落草药学训练师", "马尔约里·凯恩斯",{78.4,28.4}}, -- 26958
			{"部落铭文训练师", "书记员凯尔斯",{79.4,29.2}}, -- 26959
			{"部落珠宝加工训练师", "卡特尔·迪芬斯",{79.2,28.8}}, -- 26960
			{"部落制皮训练师", "冈特尔·汉森",{78.2,28.2}}, -- 26961
			{"部落采矿训练师", "乔纳森·刘易斯",{79.2,29.0}}, -- 26962
			{"部落剥皮训练师", "洛贝塔·贾克斯",{78.2,28.2}}, -- 26963
			{"部落裁缝训练师", "亚历山德拉·米库恩",{79.4,30.6}}, -- 26964
		-- 商人
			{"卡鲁亚克军需官", "塔奈卡",{25.4,58.6}}, -- 31916
			{"联盟先遣军军需官", "后勤官员布莱顿",{59.6,63.8}}, -- 32773
			{"部落远征军军需官", "塞巴斯迪安·克兰",{79.6,30.6}}, -- 32774
		-- 交通工具
			{"飞艇","提瑞斯法林地",{77.7,28.3}},
			{"船舶","米奈希尔港-湿地",{61.3,62.6}},
			{"船舶","莫亚基港口-龙骨荒野",{23.9,58.0}},
		},

		-- Dragonblight
		["龙骨荒野"]={
		-- 飞行管理员
			{"双足飞龙管理员", "纳苏·破天者",{37.4,45.6}}, -- 26566
			{"蝙蝠管理员", "朱特尔·维斯",{76.4,62.2}}, -- 26845
			{"双足飞龙管理员", "努莫·魂风",{43.8,16.8}}, -- 26850
			{"飞行管理员", "奈瑟斯塔兹",{60.2,51.4}}, -- 26851
			{"狮鹫管理员", "德里克·拉米尔",{39.4,25.8}}, -- 26877
			{"狮鹫管理员", "罗尼·威尔斯",{77.0,49.8}}, -- 26878
			{"角鹰兽管理员", "帕蕾娜·银云",{29.2,55.4}}, -- 26881
			{"飞行管理员", "希德·弗劳菲克斯",{48.4,74.4}}, -- 28196
		-- 旅店老板
			{"部落旅店老板", "军营管理员哈尔加",{38.0,46.6}}, -- 26985
			{"部落旅店老板", "温特白夫人",{76.8,63.0}}, -- 27027
			{"联盟旅店老板", "伊露希亚·卢恩",{77.4,51.4}}, -- 27042
			{"联盟旅店老板", "诺哈因",{28.8,56.0}}, -- 27052
			{"旅店老板", "护理者穆米克",{48.2,74.6}}, -- 27174
			{"旅店老板", "德米斯塔兹",{59.8,54.2}}, -- 27950
		-- 兽栏管理员
			{"部落兽栏管理员", "加尔米·赫佐格",{76.8,62.6}}, -- 28057
			{"兽栏管理员", "莉塞拉",{61.6,53.4}}, -- 27948
			{"联盟兽栏管理员", "哨兵琪珊·清泉",{28.8,56.0}}, -- 27056
			{"部落兽栏管理员", "索艾·鹰怒",{37.0,48.6}}, -- 26504
			{"兽栏管理员", "猎户提卡尼",{48.4,74.6}}, -- 27183
			{"联盟兽栏管理员", "达纳苏斯的塞巴鲁斯",{77.4,50.8}}, -- 27040
		-- 专业训练师
			{"部落炼金术训练师", "炼金师布蕾萨",{36.2,48.6}}, -- 27023
			{"部落炼金术训练师", "药剂师沃维克",{76.8,62.2}}, -- 27029
			{"部落锻造训练师", "伯鲁斯·折铁",{36.6,47.0}}, -- 26564
			{"部落锻造训练师", "约里克·费姆",{75.8,63.2}}, -- 27034
		-- 商人
			{"龙眠联军军需官", "希尔丝塔萨",{59.8,53.0}}, -- 32533
			{"卡鲁亚克军需官", "塞鲁克",{48.6,75.6}}, -- 32763
		-- 交通工具
			{"船舶","卡玛古-嚎风峡湾;乌努比-北风苔原",{48.5,75.3}},
		},

		-- Grizzly Hills
		["灰熊丘陵"]={
		-- 飞行管理员
			{"双足飞龙管理员", "克拉乌",{22.0,64.4}}, -- 26852
			{"双足飞龙管理员", "玛吉·冬风",{64.8,46.8}}, -- 26853
			{"狮鹫管理员", "瓦娜·格雷",{31.2,59.2}}, -- 26880
			{"狮鹫管理员", "萨缪尔·克莱布克",{59.8,26.6}}, -- 26876
		-- 旅店老板
			{"联盟旅店老板", "军需官米卡迪",{59.4,26.2}}, -- 26375
			{"部落旅店老板", "埃亚·冷风",{65.4,47.0}}, -- 26680
			{"联盟旅店老板", "珍妮佛·贝尔",{32.0,60.2}}, -- 27066
			{"部落旅店老板", "军营管理员雷尔库",{20.8,64.4}}, -- 27125
		-- 兽栏管理员
			{"联盟兽栏管理员", "侍从皮尔斯",{59.0,26.6}}, -- 26377
			{"部落兽栏管理员", "索鲁克·雷怒",{65.0,47.8}}, -- 26944
			{"联盟兽栏管理员", "玛修·埃克曼",{32.6,59.6}}, -- 27068
			{"联盟兽栏管理员", "蒂姆·斯崔特",{13.8,84.6}}, -- 29250
			{"部落兽栏管理员", "考乌尔",{13.8,84.8}}, -- 29251
			{"部落兽栏管理员", "克拉迦·铁刺",{21.6,64.0}}, -- 29740
		-- 商人
			--{"部落风险硬币商人", "普科姆",{13.8,86.2}}, -- 27730
			--{"联盟风险硬币商人", "“灰发”亚当斯",{13.8,86.4}}, -- 27760
			{"风险硬币商人", "[A]“灰发”亚当斯;[H]普科姆",{13.8,86.4}}, -- 27730/27760
		},

		-- Zul'Drak
		["祖达克"]={
		-- 飞行管理员
			{"飞行管理员", "毒翼",{14.0,73.6}}, -- 28615
			--{"飞行管理员", "丹妮卡·森特",{32.2,74.4}}, -- 28618
			{"飞行管理员", "古瑞克",{41.4,64.4}}, -- 28623
			{"飞行管理员", "玛尔卡",{60.0,56.8}}, -- 28624
			--{"飞行管理员", "莉安娜中士",{32.0,74.4}}, -- 29137
			{"飞行管理员", "丹妮卡·森特;莉安娜中士",{32.2,74.4}}, -- 28618/29137
			{"飞行管理员", "拉法伊",{70.4,23.2}}, -- 30569
		-- 旅店老板
			{"旅店老板", "玛丽萨·艾沃基",{40.8,66.2}}, -- 28791
			{"旅店老板", "潘娅",{59.2,57.2}}, -- 29583
		-- 兽栏管理员
			{"兽栏管理员", "法拉·柔蹄",{40.2,65.2}}, -- 28790
			{"兽栏管理员", "阿斯佳莉",{59.0,57.6}}, -- 30039
		},

		-- Sholazar Basin
		["索拉查盆地"]={
		-- 飞行管理员
			{"飞行管理员", "诺莫瑞根之魂",{25.2,58.4}}, -- 28037
			{"飞行管理员", "玛尔文·摇链",{50.0,61.4}}, -- 28574
		-- 旅店老板
			{"旅店老板", "普瑟尔·波利安",{26.8,59.2}}, -- 28038
		-- 兽栏管理员
			{"兽栏管理员", "哈迪乌斯·哈洛维",{27.2,59.4}}, -- 28047
		-- 专业训练师
			{"飞行训练师", "飞行员维克",{50.0,61.4}}, -- 28746
			{"大师级草药学训练师", "Dani Earthtouch",{63.8,49.0}}, -- 98223
		-- 商人
			{"神谕者军需官", "吉恩",{54.6,56.2}}, -- 31910
			{"狂心氏族军需官", "塔纳克",{55.0,69.0}}, -- 31911
			{"猎人<技能书>商人","玛尔丹·雷蹄",{27.2,59.6}}, -- 28040 -- need translation 7.0.3新增职业物品
		},

		-- Icecrown
		["冰冠冰川"]={
		-- 飞行管理员
			{"飞行管理员", "茉莉亚·恐翼",{43.6,24.4}}, -- 30314
			{"飞行管理员", "埃丹·莫兰",{87.8,78.0}}, -- 30433
			{"飞行管理员", "本诺比奥斯",{79.4,72.2}}, -- 31069
			{"飞行管理员", "恐翼",{19.4,47.8}}, -- 31078
			{"飞行管理员", "赫尔利丹·轻翼",{72.6,22.6}}, -- 33849
		-- 旅店老板
			{"旅店老板", "新兵布雷纳斯",{44.0,22.2}}, -- 30308
			{"联盟旅店老板", "卡雷斯·炎枪",{76.2,19.6}}, -- 33970
			{"部落旅店老板", "亚尔林·晨光",{76.0,24.0}}, -- 33971
		-- 兽栏管理员
			{"兽栏管理员", "伯纳尔·铁足",{69.6,22.0}}, -- 35344
			{"兽栏管理员", "伊哈蒂亚",{44.2,22.4}}, -- 30304
			{"联盟兽栏管理员", "月玲",{75.8,20.2}}, -- 35291
			{"部落兽栏管理员", "斯汀·绿角",{75.6,23.6}}, -- 35290
			{"兽栏管理员", "托马斯·帕塔基",{71.8,22.4}}, -- 33854
		-- 专业训练师
			{"炼金术训练师", "克莉丝塔·火花",{71.6,21.0}}, -- 33588
			{"锻造训练师", "重锤蕾卡",{71.8,20.8}}, -- 33591
			{"烹饪训练师", "贝萨妮·克伦威尔",{72.4,20.8}}, -- 33587
			{"附魔训练师", "费尔·晨歌",{73.0,20.6}}, -- 33583
			{"工程学训练师", "宾吉·明链",{72.2,20.8}}, -- 33586
			{"急救训练师", "约瑟弗·威尔森",{71.4,22.6}}, -- 33589
			{"铭文训练师", "亚瑟·丹尼",{71.6,20.8}}, -- 33603
			{"珠宝加工训练师", "欧鲁洛斯",{71.4,20.8}}, -- 33590
			{"制皮训练师", "库尔德",{71.8,20.8}}, -- 33581
			{"裁缝训练师", "达斯汀·维尔",{73.0,20.8}}, -- 33580
		-- 商人
			{"银色北伐军军需官", "精锐北伐军战士奥利卡·塞加德",{87.6,75.6}}, -- 30431
			{"黑锋骑士团军需官", "女公爵麦恩克丝",{43.4,20.6}}, -- 32538
			{"冠军徽记传家宝", "卡普萨里斯夫人",{69.4,23.2}}, -- 34885
			--{"联盟PvE装备商", "奥术师阿萨琳娜",{75.2,21.6}}, -- 35573 "传承正义军需官"
			--{"部落PvE装备商", "魔导师伊露维娅",{75.2,22.0}}, -- 35574 "传承正义军需官"
			{"PvE装备商", "[A]奥术师阿萨琳娜;[H]魔导师伊露维娅",{75.2,21.6}}, -- 35573/35574
			{"军需官", "夺日者;银色盟约;八大主城;诺莫瑞根;暗矛",{76.2,19.6}}, -- 34772/34881|[A]33307/33310/33650/33653/33657|[H]33553/33554/33555/33556/33557
		},

		-- The Storm Peaks
		["风暴峭壁"]={
		-- 飞行管理员
			{"飞行管理员", "布雷克·岩眉",{30.6,36.4}}, -- 29950
			{"飞行管理员", "古怪的沙瓦留斯",{44.4,28.2}}, -- 29951
			{"飞行管理员", "斯克兹尔·斯莱德",{40.6,84.6}}, -- 29721
			{"联盟飞行管理员", "法尔多弗·冷寒",{29.6,74.2}}, -- 29750
			{"部落飞行管理员", "卡巴格·驯风者",{36.2,49.2}}, -- 29757
			{"双足飞龙管理员", "海娅·帕尔卡",{65.4,50.6}}, -- 29762
			{"飞行管理员", "哈尔弗丹",{62.6,60.8}}, -- 32571
		-- 旅店老板
			{"旅店老板", "微笑的斯利尔克·布拉诺布",{41.0,85.8}}, -- 29904
			{"联盟旅店老板", "古达·硬锤",{28.6,74.4}}, -- 29926
			{"部落旅店老板", "苦工加克拉",{37.0,49.6}}, -- 29944
			{"旅店老板", "玛古恩",{30.8,37.2}}, -- 29963
			{"部落旅店老板", "瓦达巴·冰花",{67.6,50.6}}, -- 29971
			{"旅店老板", "女主人伊布拉",{48.8,65.0}}, -- 30005
		-- 兽栏管理员
			{"兽栏管理员", "赫克希",{40.8,86.0}}, -- 29906
			{"联盟兽栏管理员", "野猪驯养员布莱格",{28.6,74.4}}, -- 29948
			{"兽栏管理员", "安度尔格·岩甲",{30.6,36.8}}, -- 29959
			{"部落兽栏管理员", "安多霍·踏冰者",{67.4,50.2}}, -- 29967
			{"兽栏管理员", "兽王卡莉",{49.8,66.0}}, -- 30008
		-- 专业训练师
			{"联盟锻造训练师", "布兰迪格",{28.8,74.8}}, -- 29924
			{"飞行训练师", "洛克希·拉姆罗基",{40.6,84.8}}, -- 31247
		-- 商人
			{"霍迪尔之子军需官", "李奥霍夫",{66.0,61.4}}, -- 32540
			{"联盟奥杜尔圣物商人", "洛尔克·锐须",{28.8,74.0}}, -- 29744
			{"部落奥杜尔圣物商人", "奥鲁特·埃雷古",{37.0,49.6}}, -- 30472
		},

		-- Crystalsong Forest
		["晶歌森林"]={
		-- 飞行管理员
			{"龙鹰管理员", "飞行管理员拜里克",{78.4,50.2}}, -- 30269
			{"角鹰兽管理员", "加林德洛·白翼",{72.0,80.8}}, -- 30271
		-- 商人
			{"中立<工程图纸:奥金幼龙>商人", "安德鲁·钱伯斯",{34.0,35.6}}, -- 35826
		-- 交通工具
			{"传送宝珠","达拉然-晶歌森林",{15.7,42.5}},
		},

		-- Wintergrasp
		["冬拥湖"]={
		-- 飞行管理员
			{"联盟飞行管理员", "埃佐·希弗莱特",{72.0,31.0}}, -- 30869
			{"部落飞行管理员", "赫佐·希弗莱特",{21.6,34.8}}, -- 30870
		-- 商人
			{"冬拥湖军需官", "骑士达米隆",{51.6,17.6}}, -- [A]32294/39172|[H]32296/39173
		},

	-- 大漩涡 The Maelstrom
		-- The Lost Isles
		["失落群岛"]={
		-- 银行职员
			{"银行职员", "大胖",{28.4,76.4}}, -- 36186
			{"银行职员", "大胖",{56.8,32.2}}, -- 38746
		-- 旅店老板
			{"旅店老板", "格里米·油指",{45.0,65.4}}, -- 42473
		-- 兽栏管理员
			{"兽栏管理员", "比斯布拉特·巴布斯纳夫",{42.4,16.4}}, -- 68989 -- need translation
			{"兽栏管理员", "比斯布拉特·巴布斯纳夫",{39.6,27.8}}, -- 68989
			{"兽栏管理员", "比斯布拉特·巴布斯纳夫",{53.0,35.6}}, -- 68989
			{"兽栏管理员", "比斯布拉特·巴布斯纳夫",{45.2,65.0}}, -- 68989
			{"兽栏管理员", "比斯布拉特·巴布斯纳夫",{28.0,76.2}}, -- 68989
		-- 专业训练师
			{"烹饪训练师", "卡亚罗全能训练机豪华版",{42.8,16.4}}, -- 45286
			{"烹饪训练师", "卡亚罗全能训练机豪华版",{39.6,27.8}}, -- 45286
			{"烹饪训练师", "卡亚罗全能训练机豪华版",{53.0,35.6}}, -- 45286
			{"烹饪训练师", "卡亚罗全能训练机豪华版",{45.6,65.6}}, -- 45286
			{"工程学训练师", "卡亚罗全能训练机豪华版",{42.8,16.4}}, -- 45286
			{"工程学训练师", "卡亚罗全能训练机豪华版",{39.6,27.8}}, -- 45286
			{"工程学训练师", "卡亚罗全能训练机豪华版",{53.0,35.6}}, -- 45286
			{"工程学训练师", "卡亚罗全能训练机豪华版",{45.6,65.6}}, -- 45286
			{"急救训练师", "扎普诺兹医生",{42.6,16.2}}, -- 36615
			{"急救训练师", "扎普诺兹医生",{28.4,76.4}}, -- 36615
			{"急救训练师", "扎普诺兹医生",{35.6,67.4}}, -- 36615
			{"急救训练师", "扎普诺兹医生",{45.6,65.6}}, -- 36615
			{"钓鱼训练师", "卡亚罗全能训练机豪华版",{42.8,16.4}}, -- 45286
			{"钓鱼训练师", "卡亚罗全能训练机豪华版",{39.6,27.8}}, -- 45286
			{"钓鱼训练师", "卡亚罗全能训练机豪华版",{53.0,35.6}}, -- 45286
			{"钓鱼训练师", "卡亚罗全能训练机豪华版",{45.6,65.6}}, -- 45286
			{"草药学训练师", "卡亚罗全能训练机豪华版",{42.8,16.4}}, -- 45286
			{"草药学训练师", "卡亚罗全能训练机豪华版",{39.6,27.8}}, -- 45286
			{"草药学训练师", "卡亚罗全能训练机豪华版",{53.0,35.6}}, -- 45286
			{"草药学训练师", "卡亚罗全能训练机豪华版",{45.6,65.6}}, -- 45286
			{"珠宝加工训练师", "卡亚罗全能训练机豪华版",{42.8,16.4}}, -- 45286
			{"珠宝加工训练师", "卡亚罗全能训练机豪华版",{39.6,27.8}}, -- 45286
			{"珠宝加工训练师", "卡亚罗全能训练机豪华版",{53.0,35.6}}, -- 45286
			{"珠宝加工训练师", "卡亚罗全能训练机豪华版",{45.6,65.6}}, -- 45286
			{"采矿训练师", "卡亚罗全能训练机豪华版",{42.8,16.4}}, -- 45286
			{"采矿训练师", "卡亚罗全能训练机豪华版",{39.6,27.8}}, -- 45286
			{"采矿训练师", "卡亚罗全能训练机豪华版",{53.0,35.6}}, -- 45286
			{"采矿训练师", "卡亚罗全能训练机豪华版",{45.6,65.6}}, -- 45286
		},

		-- The Wandering Isle
		["迷踪岛"]={
		-- 旅店老板
			{"旅店老板", "程·晨勉",{51.6,46.0}}, -- 57619
			{"旅店老板", "老马良",{49.0,58.4}}, -- 65046
		-- 兽栏管理员
			{"兽栏管理员", "驯兽师小丽",{53.6,47.8}}, -- 68986
		-- 专业训练师
			{"炼金术训练师", "橡掌长老",{50.6,58.6}}, -- 65043
			{"锻造训练师", "木艺师大伟",{63.0,41.6}}, -- 57620
			{"锻造训练师", "橡掌长老",{50.6,58.6}}, -- 65043
			{"附魔训练师", "木艺师大伟",{63.0,41.6}}, -- 57620
			{"附魔训练师", "橡掌长老",{50.6,58.6}}, -- 65043
			{"工程学训练师", "木艺师大伟",{63.0,41.6}}, -- 57620
			{"草药学训练师", "木艺师大伟",{63.0,41.6}}, -- 57620
			{"草药学训练师", "橡掌长老",{50.6,58.6}}, -- 65043
			{"铭文训练师", "橡掌长老",{50.6,58.6}}, -- 65043
			{"珠宝加工训练师", "木艺师大伟",{63.0,41.6}}, -- 57620
			{"珠宝加工训练师", "橡掌长老",{50.6,58.6}}, -- 65043
			{"制皮训练师", "橡掌长老",{50.6,58.6}}, -- 65043
			{"采矿训练师", "木艺师大伟",{63.0,41.6}}, -- 57620
			{"采矿训练师", "橡掌长老",{50.6,58.6}}, -- 65043
			{"剥皮训练师", "木艺师大伟",{63.0,41.6}}, -- 57620
			{"剥皮训练师", "橡掌长老",{50.6,58.6}}, -- 65043
			{"裁缝训练师", "木艺师大伟",{63.0,41.6}}, -- 57620
			{"裁缝训练师", "橡掌长老",{50.6,58.6}}, -- 65043
		},

		-- Deepholm
		["深岩之洲"]={
		-- 旅店老板
			{"旅店老板", "看护者努恩瓦",{49.2,51.8}}, -- 45300
		-- 兽栏管理员
			{"兽栏管理员", "驭兽者锈夹",{51.2,50.2}}, -- 45297
			{"兽栏管理员", "驯骡者铁棒",{47.4,51.6}}, -- 45298
		-- 商人
			{"塞拉赞恩军需官", "收集者德罗姆",{56.8,13.2}}, -- 45408
		},

		-- Tol Barad Peninsula
		["托尔巴拉德半岛"]={
		-- 商人
			{"巴拉丁典狱官军需官", "军需官布雷泽",{72.6,62.6}}, -- 47328
			{"地狱咆哮近卫军军需官", "普格",{54.6,81.0}}, -- 48531
		},

	-- 潘达利亚 Pandaria
		-- The Jade Forest
		["翡翠林"]={
		-- 飞行管理员
			{"联盟飞行管理员", "欧提南",{58.0,82.4},0}, -- 56737
			{"飞行管理员", "酒桶飞人老李",{47.0,46.2},0}, -- 59186
			{"飞行管理员", "金莎·箭眼",{54.6,61.6},0}, -- 59727
			{"飞行管理员", "尹夏历·湖花",{57.0,44.0},0}, -- 59732
			{"飞行管理员", "金戈·酒腹",{55.4,23.6},0}, -- 59733
			{"飞行管理员", "供应商陶莎",{50.8,26.8},0}, -- 59735
			{"飞行管理员", "好学的朱谨",{43.6,24.6},0}, -- 59736
			{"部落飞行管理员", "古鲁金飞行管理猿",{27.8,47.8},0}, -- 60952
			{"飞行管理员", "天舞者阿吉",{43.0,68.4},0}, -- 64310
			{"联盟飞行管理员", "焦翼",{46.0,85.0},0}, -- 66023
			{"部落飞行管理员", "韩翼",{28.0,15.6},0}, -- 66227
		-- 旅店老板
			{"旅店老板", "林·风裘",{45.6,43.8},0}, -- 55233
			{"旅店老板", "菲拉·木穗",{54.6,63.2},0}, -- 57313
			{"联盟旅店老板", "和蔼的杰苏",{59.6,83.2},0}, -- 61599
			{"旅店老板", "优雅的斯万",{48.2,34.8},0}, -- 62322
			{"旅店老板", "长者伯罗",{41.6,23.2},0}, -- 62867
			{"旅店老板", "“海风”拉纳",{55.8,24.4},0}, -- 62868
			{"联盟旅店老板", "佳意·苹花",{44.8,84.4},0}, -- 65907
			{"部落旅店老板", "酒坊老板娘奇奇",{28.6,13.2},0}, -- 66236
		-- 兽栏管理员
			{"部落兽栏管理员", "兽语者吱吱",{27.8,46.8},0}, -- 66717
			{"联盟兽栏管理员", "张垣",{44.6,84.8},0}, -- 66266
			{"兽栏管理员", "亲切的阿宏",{46.4,43.8},0}, -- 66241
			{"兽栏管理员", "善良的潘",{54.8,63.0},0}, -- 66243
			{"部落兽栏管理员", "苏米",{28.6,13.0},0}, -- 66230
		-- 专业训练师
			{"锻造训练师", "“大锤”铁伦",{48.4,36.8},0}, -- 65114
			{"烹饪训练师", "秦",{46.2,45.4},0}, -- 56707
			{"附魔训练师", "莱·咒爪",{46.8,42.8},0}, -- 65127
			{"联盟急救训练师", "索拉卡",{45.4,85.8},0}, -- 65983
			{"部落急救训练师", "穆尔长老",{28.2,15.2},0}, -- 66222
			{"部落草药学训练师", "培育者苗萍",{27.8,15.4},0}, -- 66980
			{"联盟草药学训练师", "果园守卫李梅",{45.4,86.0},0}, -- 67025
			{"铭文训练师", "墨水大师魏",{54.6,44.2},0}, -- 56065
			{"铭文训练师", "篆书人宁吉",{47.6,35.0},0}, -- 62327
			{"珠宝加工训练师", "塑玉者麦逸",{48.4,36.8},0}, -- 65098
			{"采矿训练师", "冶炼大师灰掌",{46.0,29.4},0}, -- 65092
			{"部落采矿训练师", "碎石者瑞安",{27.8,14.8},0}, -- 66979
			{"联盟采矿训练师", "觅石者郭岩",{45.0,85.8},0}, -- 67024
			{"部落剥皮训练师", "陷阱猎手瑞安",{27.8,15.4},0}, -- 66981
			{"联盟剥皮训练师", "“鹿角”郝立",{44.8,85.6},0}, -- 67026
		-- 商人
			{"部落<黯淡林木套装>商人", "利维特·急刹",{27.2,50.6},0}, -- 56406
			{"中立<黯淡林木套装>商人", "拙焰师匠",{46.6,45.6},0}, -- 56705 "探险装备供应商"
			{"联盟<黯淡林木套装>商人", "织丝者如意",{58.2,84.0},0}, -- 61598 "探险装备供应商"
			{"云端翔龙骑士团军需官","飒安·红鳞",{56.6,44.4},0}, -- 58414
		},

		-- Krasarang Wilds
		["卡桑琅丛林"]={
		-- 飞行管理员
			{"部落飞行管理员", "黎娜·裂天者",{59.2,24.6},0}, -- 59046
			{"部落飞行管理员", "蒙奇·风蹄",{29.0,50.4},0}, -- 59047
			{"联盟飞行管理员", "梅伦·月羽",{25.2,33.4},0}, -- 59048
			{"联盟飞行管理员", "泰伦·月羽",{67.6,32.4},0}, -- 59049
			{"飞行管理员", "黄吉",{76.6,8.4},0}, -- 60232
			{"飞行管理员", "南博",{52.4,76.6},0}, -- 60441
			{"飞行管理员", "飞羽管理员李息",{31.2,63.2},0}, -- 65189
			{"部落飞行管理员", "库姆萨尔",{9.6,52.6},0}, -- 67785
			{"联盟飞行管理员", "达金·风须",{88.4,34.6},0}, -- 68226
		-- 旅店老板
			{"部落旅店老板", "艾希拉·逐晨者",{28.2,50.6},0}, -- 62967
			{"旅店老板", "搏鱼者柯兰法",{51.6,77.2},0}, -- 62872
			{"联盟旅店老板", "酒保杰瑞尔",{88.8,35.2},0}, -- 69088
			{"部落旅店老板", "马拉雅·逐晨者",{60.8,24.8},0}, -- 58184
			{"旅店老板", "仁慈的倪",{40.8,34.4},0}, -- 62869
			{"旅店老板", "粗鲁的肖老板",{75.8,7.2},0}, -- 62879
			{"部落旅店老板", "托纳科",{10.8,52.4},0}, -- 67775
		-- 兽栏管理员
			{"部落兽栏管理员", "提夫·逐晨者",{59.2,24.4},0}, -- 59310
			{"联盟兽栏管理员", "女猎手维尔耶丽",{67.2,32.2},0}, -- 66251
		-- 专业训练师
			{"钓鱼训练师", "纳特·帕格",{68.4,43.4},0}, -- 63721
		-- 商人
			{"垂钓翁军需官", "纳特·帕格",{68.4,43.4},0}, -- 63721
			{"神盾守备军军需官", "特工马尔利",{89.6,33.4},0}, -- 69059
			{"统御先锋军军需官", "撕咬者古卡纳",{10.8,53.4},0}, -- 69060
			{"统御岗哨委任状商人", "猎手布雷克",{84.2,18.8},0}, -- 67558
			{"统御岗哨委任状商人", "普凡迪特·格兰特利",{89.6,33.4},0}, -- 67881
			{"统御岗哨委任状商人", "游商斯科文",{17.6,79.4},0}, -- 68198
			{"雄狮港委任状商人", "乔恩·星眼",{12.6,62.6},0}, -- 67447
			{"雄狮港委任状商人", "奥格罗姆·黑牙",{10.6,53.6},0}, -- 67751
			{"雄狮港委任状商人", "韦弗·沃博蒂特",{76.2,34.4},0}, -- 68107
		},

		-- [LEGION] Kun-Lai Summit -- need update
		["昆莱山"]={
		-- 飞行管理员
			{"飞行管理员", "表叔东风急",{42.8,69.6},0}, -- 60416
			{"飞行管理员", "大哥绿羽毛",{66.2,50.6},0}, -- 61118
			{"飞行管理员", "信·语云",{63.2,40.2},0}, -- 61380
			{"飞行管理员", "风筝大师倪风",{43.8,89.6},0}, -- 61473
			{"飞行管理员", "观风者乔云",{72.4,94.0},0}, -- 61474
			{"飞行管理员", "小鬼白风筝",{57.6,59.8},0}, -- 61504
			{"飞行管理员", "追风人阿波",{62.4,30.0},0}, -- 61511
			{"飞行管理员", "风筝大师林息",{34.6,59.0},0}, -- 61512
			{"联盟飞行管理员", "飞行家泰波",{54.0,84.2},0}, -- 61744
			{"部落飞行管理员", "翔天爪",{62.4,80.6},0}, -- 61745
			{"部落飞行管理员", "莫拉·天刃",{36.0,83.6},0}, -- 65863
		-- 旅店老板
			{"旅店老板", "李·金酿",{64.4,61.2},0}, -- 59405
			{"旅店老板", "奇游·雾爪",{57.4,60.0},0}, -- 59688
			{"旅店老板", "苜蓿保管人",{42.6,69.6},0}, -- 60420
			{"旅店老板", "刘哲",{62.4,28.8},0}, -- 60605/65535
			{"旅店老板", "童叟无欺普利",{72.6,92.2},0}, -- 62871
			{"旅店老板", "污泥盏",{44.4,90.2},0}, -- 62877
			{"联盟旅店老板", "焦虑的凯",{54.0,82.8},0}, -- 62882
			{"部落旅店老板", "打瞌睡的麦金",{62.6,80.4},0}, -- 62883
			{"旅店老板", "调酒师拓莫若",{56.0,91.6},0}, -- 65976
		-- 兽栏管理员
			{"兽栏管理员", "表哥山麝香",{42.2,69.2},0}, -- 59413
			{"兽栏管理员", "牧民自由麝",{65.4,61.6},0}, -- 59509
		-- 专业训练师
			--{"部落考古学训练师", "埃莱娜拉",{57.2,78.6},0}, -- 47346 --need update
			{"急救训练师", "陈药师",{71.6,92.8},0}, -- 59077
			{"急救训练师", "毕迩大师",{51.0,40.2},0}, -- 66357
			{"制皮训练师", "亮皮带",{64.6,60.8},0}, -- 65121
			{"采矿训练师", "布兰登师傅",{48.6,44.6},0}, -- 66360
		-- 商人
			--{"部落PvP装备商", "鲁·戴斯文",{35.4,83.2},0}, -- 75688 "暴虐角斗士Tyrannical"
			--{"部落PvP装备商", "洛克诺·血拳",{35.4,83.4},0}, -- 75690 "恐怖角斗士Dreadful"
			--{"部落PvP装备商", "桃丽丝·奇尔顿妮斯",{35.4,83.4},0}, -- 75693 "恶毒角斗士Malevolent"
			--{"部落PvP装备商", "阿肯·死亡统御",{35.4,83.2},0}, -- 75695 "恶孽角斗士Grievous"
			--{"部落PvP装备商", "苏雄",{35.4,83.2},0}, -- 78461 "骄矜角斗士Prideful"
			{"部落PvP装备商", "S12L;S12H;S13;S14;S15S",{35.4,83.2},0}, -- 75688/75690/75693/75695/78461
			{"中立<攀山者套装>商人", "锻铁爪",{71.4,92.2},0}, -- 61749 "探险装备供应商"
			{"中立<牦牛>商人", "表叔大口袋",{65.4,61.6},0}, -- 64518
			{"武僧<技能书>商人","黄师傅",{50.4,42.6},0}, -- 66356 -- need translation 7.0.3新增职业物品
		},

		-- Valley of the Four Winds
		["四风谷"]={
		-- 飞行管理员
			{"飞行管理员", "丹·“龙之翼”",{20.2,58.6},0}, -- 58843
			{"飞行管理员", "普林斯顿",{84.4,21.0},0}, -- 60230
			{"飞行管理员", "“飞翼”小雅",{56.4,50.2},0}, -- 60231
			{"飞行管理员", "“山风”基姆",{70.8,24.2},0}, -- 62658
			{"联盟飞行管理员", "泰波·疾风",{12.0,32.8},0}, -- 65865
		-- 旅店老板
			{"旅店老板", "旅店老板雷岚",{55.0,50.4},0}, -- 59582
			--{"旅店老板", "农夫的日志",{52.6,48.0},0}, -- 70585
			{"旅店老板", "“砌石酒盏”阿楠",{19.6,56.2},0}, -- 62878
			{"旅店老板", "楠·雷脚",{83.6,20.2},0}, -- 65528
		-- 兽栏管理员
			{"兽栏管理员", "小提布",{83.8,21.8},0}, -- 66242
			{"兽栏管理员", "驯兽师苏明",{55.2,49.6},0}, -- 66244
		-- 专业训练师
			{"烹饪训练师", "孙行·铁掌",{53.6,51.2},0}, -- 64231/53712-53717
			{"工程学训练师", "莎莉·轮怒",{16.0,83.0},0}, -- 55143
			{"钓鱼训练师", "“大嗓门”班宏",{58.8,47.0},0}, -- 70398
			{"草药学训练师", "韩·繁花",{53.6,51.2},0}, -- 65877
			{"剥皮训练师", "普利波先生",{16.0,83.0},0}, -- 63825
			{"裁缝训练师", "蔡丝匠",{62.6,59.6},0}, -- 57405
		-- 商人
			--{"联盟PvP装备商", "桃丽丝·奇尔顿妮斯",{12.2,34.2},0}, -- 75689 "恶毒角斗士Malevolent"
			--{"联盟PvP装备商", "洛克诺·血拳",{12.2,34.0},0}, -- 75691 "恐怖角斗士Dreadful"
			--{"联盟PvP装备商", "阿肯·死亡统御",{12.0,34.2},0}, -- 75692 "恶孽角斗士Grievous"
			--{"联盟PvP装备商", "鲁·戴斯文",{12.0,34.0},0}, -- 75694 "暴虐角斗士Tyrannical"
			--{"联盟PvP装备商", "苏雄",{12.0,34.0},0}, -- 78456 "骄矜角斗士Prideful"
			{"联盟PvP装备商", "S12L;S12H;S13;S14;S15",{12.2,34.2},0}, -- 75689/75691/75692/75694/78456
			{"阡陌客军需官", "吉娜·泥爪",{53.1,52.1},0}, -- 58706
			--{"中立<种子>商人", "商人绿野",{52.8,52.0},0}, -- 58718
			{"中立<黯淡林木套装>商人", "商人迦姆比兹",{56.2,47.0},0}, -- 59583 "探险装备供应商"
			{"中立<黯淡林木套装>商人", "科拉尔塔",{84.8,21.6},0}, -- 61215 "探险装备供应商"
			--{"中立<不稳定的传送门>商人", "巴纳比·弗莱彻",{53.2,51.6},0}, -- 67565
			{"中立商人", "种子;不稳定的传送门",{52.8,52.0},0}, -- 58718/67565
		},

		-- The Veiled Stair
		["雾纱栈道"]={
		-- 飞行管理员
			{"飞行管理员", "鸿毛阿信",{56.6,75.8},0}, -- 61759
		-- 旅店老板
			{"旅店老板", "调酒师童福",{54.8,72.4},0}, -- 62917
		-- 兽栏管理员
			{"兽栏管理员", "驯兽师卡玛",{55.8,75.8},0}, -- 62935
		-- 商人
			{"黑王子军需官", "黑爪军需官",{54.4,72.8},0}, -- 70436
		},

		-- Townlong Steppes
		["螳螂高原"]={
		-- 飞行管理员
			{"飞行管理员", "风筝大师李森",{54.2,79.0},0}, -- 62898
			{"飞行管理员", "风筝大师吴工",{71.0,57.2},0}, -- 62901
			{"飞行管理员", "风筝大师宁师师",{74.4,81.4},0}, -- 62903
			{"飞行管理员", "风筝大师姚莉",{50.0,71.8},0}, -- 62909
		-- 旅店老板
			{"旅店老板", "睡影赛图",{71.0,57.8},0}, -- 62873
			{"旅店老板", "守夜人卡里",{48.8,70.8},0}, -- 62874
			{"旅店老板", "安静的吉姆",{75.8,82.8},0}, -- 62875
		-- 兽栏管理员
			{"兽栏管理员", "驯虎师盖林",{71.4,57.6},0}, -- 66246
			{"兽栏管理员", "驯虎师刘多",{74.8,81.2},0}, -- 66247
			{"兽栏管理员", "女驯虎师明朵",{50.0,71.4},0}, -- 66248
		-- 商人
			{"影踪派军需官", "狡狐鲁西",{48.8,70.6},0}, -- 64595
			--{"PvE装备商", "指挥官牛心",{37.8,64.6},0}, -- 64606 "勇气军需官"
			--{"PvE装备商", "指挥官罗平",{37.8,64.6},0}, -- 64607 "正义军需官"
			--{"PvE装备商", "白傲",{38.0,64.6},0}, -- 70346 "影踪突袭营军需官"
			{"PvE装备商", "指挥官牛心;指挥官罗平;白傲",{37.8,64.6},0}, -- 64606/64607/70346
			{"中立<攀山者/废土套装>商人", "供应商老辛",{70.8,55.8},0}, -- 62737/65171 "装备商人"/"探险装备供应商"
		},

		-- Dread Wastes
		["恐惧废土"]={
		-- 飞行管理员
			{"飞行管理员", "乘风者溟",{56.0,70.2}}, -- 63498
			{"飞行管理员", "飞桶阿晋",{50.2,12.2}}, -- 63500
			{"飞行管理员", "基克提克",{55.8,34.8}}, -- 63501
			{"飞行管理员", "渗透者伊克萨尔",{42.6,55.6}}, -- 65511
		-- 旅店老板
			{"旅店老板", "澄海者塞安",{55.2,71.0}}, -- 63016
			{"旅店老板", "兹特提克斯",{55.8,32.2}}, -- 65220
		-- 兽栏管理员
			{"兽栏管理员", "驯马人金姆",{55.8,69.6}}, -- 66249
			{"兽栏管理员", "训练师卡拉维克",{53.6,32.4}}, -- 66250
		-- 专业训练师
			{"炼金术训练师", "下毒者克尔兹特",{55.6,35.2}}, -- 65186
		-- 商人
			{"卡拉克西军需官", "琥珀匠师齐克",{55.0,35.6}}, -- 64599
		},

		-- Isle of Giants
		["巨兽岛"]={
		-- 飞行管理员
			{"联盟飞行管理员", "比波尔·短扳",{41.8,79.2}}, -- 69359
			{"部落飞行管理员", "波兹尔·爆索",{51.8,75.4}}, -- 69360
		-- 商人
			{"联盟<恐角龙皮伪装>商人", "阿加特·锐眼",{35.8,53.6}}, -- 70030
			{"部落<恐角龙皮伪装>商人", "阿诺德·雷甘",{60.6,44.0}}, -- 70034
		},

		-- Isle of Thunder
		["雷神岛"]={
		-- 旅店老板
			{"部落旅店老板", "兽女乌达",{33.4,32.6},0}, -- 67668
			{"联盟旅店老板", "伊丝拉米·轻风",{64.8,73.0},0}, -- 70182
		-- 兽栏管理员
			{"部落兽栏管理员", "游侠沙兰",{32.8,32.6},0}, -- 69252
			{"联盟兽栏管理员", "塔西娅·幽谷",{63.2,73.8},0}, -- 70184
		-- 专业训练师
			{"部落考古学训练师", "埃莱娜拉",{33.8,33.6},0}, -- 67586
		-- 商人
			{"夺日者先锋军军需官", "瓦萨林·赤晨",{33.4,32.4},0}, -- 67672
			{"肯瑞托远征军军需官", "海伦·慧歌",{64.6,74.6},0}, -- 68000
			{"影踪突袭营军需官", "飞刀客腾青",{51.6,46.6},0}, -- 70535
			{"好运符与羊皮纸商人", "供应商老包",{51.4,45.8},0}, -- 70318
		},

		-- Timeless Isle
		["永恒岛"]={
		-- 飞行管理员
			{"部落飞行管理员", "驯天者甄洛",{21.8,39.8},0}, -- 71939
			{"联盟飞行管理员", "蜜琪·风花",{23.2,71.0},0}, -- 71940
		-- 旅店老板
			{"旅店老板", "优雅的斯万",{36.6,47.0},0}, -- 73622
		-- 兽栏管理员
			{"兽栏管理员", "怯懦的祖音",{37.2,46.8},0}, -- 73632
		-- 商人
			{"中立<库库鲁宝箱钥匙>商人", "库库鲁大师",{59.2,40.4},0}, -- 72007
			{"天神铸币商人", "李大师",{34.8,59.6},0}, -- 73082
			{"永恒铸币商人", "维茨格;",{41.6,47.2},0}, -- 73293
			{"永恒铸币商人", "织雾者顾严",{42.8,55.6},0}, -- 73305/73306
			{"永恒铸币商人", "莫苦",{41.2,63.6},0}, -- 73819
			{"永恒/染血铸币商人", "发言人古兰",{75.0,44.8},0}, -- 73307
		},

		-- Vale of Eternal Blossoms
		["锦绣谷"]={
		-- 飞行管理员
			{"联盟飞行管理员", "萨琳娜·踏春",{84.6,62.4},0}, -- 61121
			{"部落飞行管理员", "塔尼亚·夏风",{62.8,21.6},0}, -- 61122
			{"飞行管理员", "铁壁老麦",{14.2,79.2},0}, -- 63497
		-- 旅店老板
			{"旅店老板", "调酒师拓莫若",{35.4,77.4},0}, -- 58691
		-- 兽栏管理员
			{"部落兽栏管理员", "追踪者老朗",{60.4,22.6},0}, -- 63986
			{"联盟兽栏管理员", "贾许",{84.6,63.2},0}, -- 63988
			{"兽栏管理员", "骑羊人尼克尼克",{36.0,75.2},0}, -- 66245
		-- 专业训练师
			{"考古学训练师", "布莱恩·铜须",{83.6,31.0},0}, -- 64922
			{"部落考古学训练师", "伊莉娜拉",{21.0,15.2},0}, -- 67837
			{"锻造训练师", "禅宗铁匠劳敖",{21.6,72.2},0}, -- 65129
			{"飞行训练师", "穿云行者凌大师",{84.2,61.6},0}, -- 60166
			{"飞行训练师", "舞空者书恩",{62.8,23.2},0}, -- 60167
			{"铭文训练师", "游学者胡恩",{82.0,29.4},0}, -- 64691
		-- 商人
			-- 七星殿
			{"联盟军需官", "金莲教;至尊天神",{84.2,62.6},0}, -- 59908/64032
			{"祥和之灵商人", "克里斯托",{84.6,60.6},0}, -- 66678
			{"联盟PvE装备商", "挑战者老宋",{86.2,61.6},0}, -- 64028
			-- 双月殿
			{"部落军需官", "金莲教;至尊天神",{63.0,22.2},0}, -- 59908/64001
			{"祥和之灵商人", "达奇",{61.6,21.6},0}, -- 66685
			{"部落PvE装备商", "挑战者吴立",{61.2,20.8},0}, -- 63994
			-- 魔古山宫殿
			{"游学者军需官", "谭欣眺",{82.2,29.4},0}, -- 64605
			{"中立<先祖凤凰>商人", "凯·羽落",{82.2,34.0},0}, -- 66973
			-- 其他
			{"稀有古董商人", "大块头齐奇",{60.4,43.2},0}, -- 61650
			{"中立<废土套装>商人", "全副武装的伦",{14.2,78.8},0}, -- 65172 "探险装备供应商"
		},

	-- 德拉诺 Draenor
		-- Frostfire Ridge
		["霜火岭"]={
		-- 飞行管理员
			{"部落飞行管理员", "飞狼罗尔克",{24.4,37.2},0}, -- 76781
			{"部落飞行管理员", "普尔·塑风",{21.6,5.6},0}, -- 76782
			{"部落飞行管理员", "加诺克·破晓",{31.8,9.6},0}, -- 76783
			{"部落飞行管理员", "贝尔·战颈",{83.6,60.8},0}, -- 76784
			{"飞行管理员", "贝蕾娜·天沼",{51.4,21.4},0}, -- 76787
			{"部落飞行管理员", "天空猎手多莫甘",{40.0,51.8},0}, -- 76879
			{"部落飞行管理员", "贾卡纳",{51.8,41.0},0}, -- 78699
			{"联盟飞行管理员", "游侠薇拉",{87.4,62.6},0}, -- 84993
			{"部落飞行管理员", "猎风",{73.6,60.0},0}, -- 87707
		-- 旅店老板
			{"部落旅店老板", "卓戈",{40.6,51.6},0}, -- 72382
			--{"部落旅店老板", "德什威",{27.0,36.4},0}, -- 76746
			{"部落旅店老板", "谦卑的萨科",{20.8,56.6},0}, -- 77460
			--{"部落旅店老板", "脏兮兮的哈维",{30.0,38.6},0}, -- 77468
			{"部落旅店老板", "德什威;脏兮兮的哈维",{27.0,36.4},0}, -- 76746/77468
			{"部落旅店老板", "补给商拉姆巴拉",{52.2,39.8},0}, -- 78672
			{"部落旅店老板", "旅店老板查尔",{32.0,10.0},0}, -- 78769
		-- 兽栏管理员
			{"部落兽栏管理员", "幼崽看护员格里姆贝尔",{38.8,52.0},0}, -- 77455
			--{"部落兽栏管理员", "牧狼者安查",{22.0,56.2},0}, -- 77461
			--{"部落兽栏管理员", "斯图·白牙",{21.4,54.6},0}, -- 77475
			{"部落兽栏管理员", "斯图·白牙;牧狼者安查",{21.4,54.6},0}, -- 77461/77475
			{"部落兽栏管理员", "考里",{52.4,40.2},0}, -- 78698
			--{"联盟兽栏管理员", "科甘·焰须",{52.6,20.4},0}, -- 86808
			--{"兽栏管理员", "托尔玛克;科甘·焰须",{52.6,20.6},0}, -- 87006
			{"兽栏管理员", "托尔玛克;[A]科甘·焰须",{52.6,20.6},0}, -- 86808/87006
		-- 专业训练师
			{"部落钓鱼训练师", "Sverre",{41.0,73.8},0}, -- 96097 -- need translation
		-- 商人
			{"部落<要塞舰船装备>商人", "Kronk Rustspark",{40.0,72.2},0}, -- 94801 -- need translation
		},

		-- Shadowmoon Valley 947
		["影月谷德拉诺"]={
		-- 飞行管理员
			{"联盟飞行管理员", "高顿",{40.6,55.2},0}, -- 76839
			{"联盟飞行管理员", "伊奥诺",{45.6,38.8},0}, -- 76840
			{"飞行管理员", "瓦格拉",{45.6,25.4},0}, -- 76850
			{"联盟飞行管理员", "帕娅",{59.4,46.0},0}, -- 76851
			{"联盟飞行管理员", "莫法科斯",{57.0,56.6},0}, -- 81284
			{"飞行管理员", "阿扎拉·金翼",{43.8,77.4},0}, -- 81285
			{"联盟飞行管理员", "瓦姆",{58.6,31.8},0}, -- 81289
			--{"飞行管理员", "驯兽师拉达克",{59.8,81.4},0}, -- 83427
			{"联盟飞行管理员", "伊塔拉",{70.4,50.4},0}, -- 86685
			--{"联盟飞行管理员", "Beasttamer Zov'jin",{57.6,83.6},0}, -- 88113 -- need translation
			{"飞行管理员", "驯兽师拉达克;[A]驯兽师祖沃金",{59.8,81.4},0}, -- 83427/88113 -- need translation
		-- 旅店老板
			{"联盟旅店老板", "克丽安德",{46.6,40.8},0}, -- 78952
			{"联盟旅店老板", "麦法尔",{56.8,57.4},0}, -- 82770
			{"联盟旅店老板", "奈瑟妮",{60.0,27.2},0}, -- 82775
		-- 兽栏管理员
			{"联盟兽栏管理员", "达卡瑞",{25.2,7.0},0}, -- 81830
			{"联盟兽栏管理员", "艾坦",{59.2,26.6},0}, -- 84730
			--{"联盟兽栏管理员", "科甘·焰须",{47.6,28.0},0}, -- 86808
			--{"兽栏管理员", "托尔玛克",{47.6,28.0},0}, -- 87006
			{"兽栏管理员", "托尔玛克;[A]科甘·焰须",{47.6,28.0},0}, -- 86808/87006
		-- 专业训练师
			{"联盟钓鱼训练师", "努拉",{66.8,35.2},0}, -- 85825
			{"联盟钓鱼训练师", "Lester Scaleworth",{27.4,10.0},0}, -- 94311 -- need translation
		-- 商人
			{"联盟<略微干瘪的蛤蟆>商人", "老露拉",{41.2,55.0},0}, -- 71641
			{"联盟<要塞舰船装备>商人", "Salty Jorren",{28.6,10.8},0}, -- 93812 -- need translation
		},

		-- Gorgrond
		["戈尔隆德"]={
		-- 飞行管理员
			{"部落飞行管理员", "割齿",{46.0,69.2},0}, -- 81055
			{"联盟飞行管理员", "游侠拉洁丝",{52.8,59.4},0}, -- 81074
			{"联盟飞行管理员", "游侠特维",{64.0,57.4},0}, -- 81884
			{"联盟飞行管理员", "游侠纳格",{46.4,76.6},0}, -- 81888
			{"部落飞行管理员", "查格斯班",{41.2,87.2},0}, -- 84495
			--{"联盟飞行管理员", "游侠亚威尔",{46.4,92.4},0}, -- 84507
			--{"部落飞行管理员", "啸风",{47.4,90.8},0}, -- 84508
			{"飞行管理员", "[A]游侠亚威尔;[H]啸风",{46.9,91.6},0}, -- 84507/84508
			{"飞行管理员", "尼莎",{43.0,20.2},0}, -- 84700
			{"飞行管理员", "奥术师温德波普",{57.0,45.8},0}, -- 84714
			{"飞行管理员", "法隆·尘世行者",{39.6,36.6},0}, -- 85829
			{"飞行管理员", "尼莎",{45.8,55.0},0}, -- 86492/81674
			{"飞行管理员", "研究员萨莉克丝",{68.6,28.8},0}, -- 88757
			{"部落飞行管理员", "Dron Skyborn",{55.8,6.6},0}, -- 89831 -- need translation
			{"联盟飞行管理员", "Taal Blevaans",{52.8,9.6},0}, -- 90188 -- need translation
		-- 旅店老板
			{"部落旅店老板", "死肉",{60.6,22.4},0}, -- 86994
			{"部落旅店老板", "咬虱",{46.0,69.8},0}, -- 85967
			{"联盟旅店老板", "商人尤拉",{53.2,59.8},0}, -- 85968
			{"旅店老板", "艾登·夏天",{40.0,36.4},0}, -- 85830
			{"旅店老板", "奇帕斯",{46.0,54.8},0}, -- 84237
		-- 兽栏管理员
			{"联盟兽栏管理员", "游侠科兰",{52.6,59.6},0}, -- 81075
			{"部落兽栏管理员", "嚼骨",{45.8,69.8},0}, -- 82731
			{"联盟兽栏管理员", "科甘·焰须",{45.8,43.8},0}, -- 86808
		},

		-- Talador
		["塔拉多"]={
		-- 飞行管理员
			{"飞行管理员", "多米尼克·阿灵顿",{80.4,25.4},0}, -- 80932
			{"部落飞行管理员", "莫克拉",{61.4,10.6},0}, -- 81053
			{"部落飞行管理员", "莫吉巴",{70.8,29.4},0}, -- 81057
			{"部落飞行管理员", "特加·天刃",{55.4,40.8},0}, -- 81058
			{"部落飞行管理员", "Skyreaver Lyriarra",{61.0,73.4},0}, -- 81059 -- Need translation
			{"联盟飞行管理员", "护天者阿米拉",{69.8,21.4},0}, -- 81060
			{"联盟飞行管理员", "诺麦尔",{63.2,25.8},0}, -- 81061
			{"联盟飞行管理员", "Shalaa",{57.4,76.2},0}, -- 81062 -- Need translation
			{"飞行管理员", "扎玛拉",{51.2,42.6},0}, -- 81064
			{"联盟飞行管理员", "扎里",{80.0,56.6},0}, -- 81067
			{"飞行管理员", "贝尔多斯",{42.0,76.8},0}, -- 81068
			--{"联盟飞行管理员", "妮雅",{54.8,68.8},0}, -- 81077
			--{"部落飞行管理员", "洛卡",{54.6,67.8},0}, -- 81078
			{"飞行管理员", "[A]妮雅;[H]洛卡",{54.8,68.8},0}, -- 81077/81078
			{"飞行管理员", "天爪卫士伊努兹",{70.4,57.0},0}, -- 81354
		-- 旅店老板
			{"旅店老板", "看护者乌露拉",{77.2,57.4},0}, -- 75430
			{"部落旅店老板", "瓦格坦",{61.8,10.8},0}, -- 77028
			{"联盟旅店老板", "梅·特塔",{85.2,31.8},0}, -- 80931
			{"联盟旅店老板", "奥利维亚·阿比顿",{69.6,21.8},0}, -- 81358
			{"部落旅店老板", "葆妮·柔蹄",{72.0,30.0},0}, -- 81359
			{"旅店老板", "巴达",{50.8,44.4},0}, -- 86316
		-- 兽栏管理员
			{"部落兽栏管理员", "兽王塔格",{70.8,29.6},0}, -- 80833
			{"联盟兽栏管理员", "帕特里克·麦瑟",{69.4,21.2},0}, -- 80854
			{"联盟兽栏管理员", "科甘·焰须",{67.2,49.2},0}, -- 86808
		-- 商人
			{"中立<新奇玩具>商人", "卡兹巴拉",{45.2,38.8},0}, -- 84212
			{"绝版PvE装备商", "裂铁者塔加尔",{45.6,38.6},0}, -- 84216
			{"中立<传说戒指>商人", "佐提·轮怒",{85.0,31.0},0}, -- 86949
		},

		-- Spires of Arak
		["阿兰卡峰林"]={
		-- 飞行管理员
			{"飞行管理员", "奎文·飞轮",{60.8,73.2}}, -- 82511
			{"部落飞行管理员", "胡托·羽风",{39.4,43.2}}, -- 82612
			{"联盟飞行管理员", "菲恩·迅风",{39.0,61.8}}, -- 83567
			{"飞行管理员", "天爪卫士米沙尔",{46.2,44.0}}, -- 84498
			{"飞行管理员", "天爪卫士卡拉兹",{61.8,42.6}}, -- 84504
			{"飞行管理员", "天爪卫士库里斯",{37.0,24.6}}, -- 84509
			{"飞行管理员", "黯啸",{51.8,31.0}}, -- 84515
			{"飞行管理员", "暮爪",{65.6,17.6}}, -- 88584
		-- 旅店老板
			{"旅店老板", "考比克斯·查奇",{61.6,73.4}}, -- 82516
			{"联盟旅店老板", "艾丽娅·坠柳",{40.0,61.4}}, -- 84134
			{"部落旅店老板", "塔兹加尔",{40.4,43.0}}, -- 84213
			{"旅店老板", "库罗阿克",{46.6,44.0}}, -- 86386
		-- 兽栏管理员
			{"兽栏管理员", "威利·矿板",{60.8,71.8}}, -- 82553
		-- 商人
			{"中立<守巢幼鸟/卡利雏鸟>商人", "维沙尔",{46.2,45.4}}, -- 87123
		},

		-- Nagrand 950
		["纳格兰德拉诺"]={
		-- 飞行管理员
			{"狮鹫管理员", "菲利希亚·玛林",{62.6,40.6},0}, -- 81250
			{"狮鹫管理员", "约翰·谢尔比",{63.6,61.6},0}, -- 82309
			{"双足飞龙管理员", "乌姆·魂风",{49.4,48.0},0}, -- 82340
			{"双足飞龙管理员", "塔尔",{83.2,44.6},0}, -- 82346
			{"双头飞龙管理员", "吉克斯莫·现钞",{73.6,26.6},0}, -- 82844
			{"双头飞龙管理员", "比吉·战利",{79.8,49.6},0}, -- 83924
			{"双头飞龙管理员", "里尔兹特·喷泥",{50.6,30.6},0}, -- 87395
			{"双头飞龙管理员", "内维克·李",{49.4,75.8},0}, -- 88653
			{"双头飞龙管理员", "乔兹·纳瓦克斯",{62.2,32.8},0}, -- 88668
		-- 旅店老板
			{"联盟旅店老板", "看护菲拉妮",{63.6,62.4},0}, -- 80006
			{"联盟旅店老板", "艾玛·南土",{62.2,40.0},0}, -- 81249
			{"部落旅店老板", "温特白夫人",{48.4,47.0},0}, -- 82341
			{"部落旅店老板", "艾拉丝丽儿·射日者",{82.6,45.4},0}, -- 82345
		-- 兽栏管理员
			--{"联盟兽栏管理员", "科甘·焰须",{86.6,42.6},0}, -- 86808
			--{"兽栏管理员", "托尔玛克",{86.6,42.8},0}, -- 87006
			{"兽栏管理员", "托尔玛克;[A]科甘·焰须",{86.6,42.8},0}, -- 86808/87006
			{"兽栏管理员", "托尔玛克",{55.6,59.6},0}, -- 87006
		-- 商人
			{"热砂保护协会军需官", "奎拉克斯·刀索",{50.4,41.4},0}, -- 87394
			{"中立<窖藏达拉然红葡萄酒>商人", "Lytah",{76.6,50.6},0}, -- 89702 -- need translation
		},

		-- Tanaan Jungle -- need translation
		["塔纳安丛林"]={
		-- 飞行管理员
			{"部落飞行管理员", "Gargash the Diver",{60.4,46.4}}, -- 90550
			--{"部落飞行管理员", "Nasher",{9.2,55.8}}, -- 90552
			{"飞行管理员", "Skytalon Kariz",{26.0,38.8}}, -- 90560
			{"飞行管理员", "Urtol Skyshear",{47.0,70.2}}, -- 90562
			{"联盟飞行管理员", "Skyguard Thann",{57.4,58.8}}, -- 90960
			--{"联盟飞行管理员", "Skyguard Blann",{10.0,53.0}}, -- 91940
			{"飞行管理员", "Rocketmaster Malo",{43.4,42.2}}, -- 92808
			{"飞行管理员", "Rangari Sha'ana",{29.6,63.0}}, -- 92809
			{"飞行管理员", "[A]Skyguard Blann;[H]Nasher",{9.6,54.4}}, -- 90552/91940
		-- 旅店老板
			{"联盟旅店老板", "Shima Islebreeze",{58.4,60.2}}, -- 90971
			{"部落旅店老板", "Retho Quillmane",{61.4,46.0}}, -- 90989
		-- 兽栏管理员
			{"部落兽栏管理员", "Dal Palesmoke",{59.8,45.6}}, -- 90992
		-- 商人
			{"刃牙追猎者军需官", "行者兹坦加",{55.2,74.8}}, -- 92805
			--{"先知之手军需官", "Vindicator Krethos",{58.4,60.4}}, -- 90974
			--{"觉醒教派军需官", "Dawn-Seeker Krisek",{57.8,59.4}}, -- 95424
			{"联盟军需官", "先知之手;觉醒教派",{58.0,59.9}}, -- 90974/95424
			{"联盟埃匹希斯水晶商人", "Ravenspeaker Thelnaas",{57.8,59.4}}, -- 96130
			--{"沃金之锋军需官", "Shadow Hunter Denjai",{61.6,45.6}}, -- 96014
			--{"觉醒教派军需官", "Dawn-Seeker Krisek",{60.4,46.6}}, -- 95424
			{"部落军需官", "沃金之锋;觉醒教派",{61.0,46.1}}, -- 96014/95424
			{"部落埃匹希斯水晶商人", "Ravenspeaker Thelnaas",{60.4,46.6}}, -- 96130
		},

		-- Lunarfall
		["坠落之月"]={
		-- 拍卖师
			{"拍卖师", "古代交易机",{35.0,48.4},0}, -- 87205
		-- 银行职员
			{"银行职员", "琪拉·金手",{47.0,59.2},0}, -- 84857
		-- 飞行管理员
			{"狮鹫管理员", "杜加尔·朗德瑞克",{47.6,49.6},0}, -- 81103
		-- 兽栏管理员
			{"兽栏管理员", "拉文",{38.2,60.0},0}, -- 77381
		-- 专业训练师
			{"钓鱼训练师", "罗恩·艾什顿",{54.4,14.4},0}, -- 77733
		-- 商人
			{"沙塔尔防御者军需官", "玛瑞亚",{52.0,43.4},0}, -- 85427
			{"钢铁部落碎片商人", "克里斯汀·石铸",{36.2,62.8},0}, -- 77377
			{"要塞军需官", "克劳勒中士",{37.6,36.4},0}, -- 88223
			{"纳特的幸运硬币商人", "纳特·帕格",{53.4,14.0},0}, -- 85984
			{"宠物符咒商人", "缇菲·机簧",{29.6,39.0},0}, -- 94512
			{"商人", "图纸;合约;坐骑;追随者装备",{29.6,33.0},0}, -- 85839/88633/95470
		},

		-- Frostwall
		["霜寒晶壁"]={
		-- 拍卖师
			{"拍卖师", "古代交易机",{51.2,61.4},0}, -- 87109
		-- 银行职员
			{"银行职员", "尤恩·长蹄",{48.2,33.2},0}, -- 79862
		-- 飞行管理员
			{"飞行管理员", "布罗恩·天角",{45.8,50.2},0}, -- 79407
		-- 兽栏管理员
			{"兽栏管理员", "多吉尔",{52.8,57.4},0}, -- 79816
			{"兽栏管理员", "扎加拉",{65.4,34.2},0}, -- 79860
		-- 专业训练师
			{"钓鱼训练师", "马克金",{38.4,72.2},0}, -- 79892
		-- 商人
			{"嘲颅军需官", "基尔里普",{51.6,60.4},0}, -- 86698
			{"钢铁部落碎片商人", "戈伦莱克",{64.0,35.2},0}, -- 79815
			{"要塞军需官", "格里姆加中士",{44.0,47.6},0}, -- 88228
			{"纳特的幸运硬币商人", "纳特·帕格",{38.2,72.0},0}, -- 85984
			{"宠物符咒商人", "吉雅达·金索",{33.0,40.0},0}, -- 94516
			{"商人", "图纸;合约;坐骑;追随者装备",{40.8,55.8},0}, -- 79619/88635/95471
		},

		-- [LEGION] Ashran -- need update
		["阿什兰"]={
		-- 商人
			{"暴风之盾军需官", "克拉提库斯·曼比德尔",{44.2,74.0}}, -- 80882
			{"战争之矛军需官", "达兹里安",{48.4,23.8}}, -- 85115
			{"联盟PvP装备商", "大元帅泰布雷德;加布里埃尔元帅;卡什·暴炉将军",{45.2,79.4}}, -- 82876/82878/82880
			{"部落PvP装备商", "高阶督军沃拉斯;艾弗德将军;督军诺克泰",{48.0,26.0}}, -- 82877/82882/82883
		},

	-- 破碎群岛 The Broken Isles -- need update
		-- Broken Shore
		["破碎海滩"]={
		-- 飞行管理员
			{"飞行管理员","Grimwing",{97.4,56.0}}, -- 93465
			{"飞行管理员","Izal Whitemoon",{49.6,21.0}}, -- 111323
		},

		-- Stormheim
		["风暴峡湾"]={
		-- 飞行管理员
			{"部落飞行管理员","Duchess",{45.0,59.2}}, -- 92560
			{"部落飞行管理员","Dread-Rider Barnes",{54.6,73.0}}, -- 98105
			{"联盟飞行管理员","Gryphon-Master Clifford",{72.0,59.8}}, -- 98108
			{"联盟飞行管理员","Donovan",{37.4,63.8}}, -- 98113
			{"联盟飞行管理员","Donovan",{33.6,50.6}}, -- 98114
			{"部落飞行管理员","Dread-Rider Roth",{36.4,30.6}}, -- 98124
			{"飞行管理员","Garhal the Scalekeeper",{60.6,50.8}}, -- 98161
			{"飞行管理员","Visser the Scalekeeper",{89.8,10.6}}, -- 111314
			{"飞行管理员","Hillevi the Scalekeeper",{52.0,34.6}}, -- 111327
		-- 旅店老板
			{"旅店老板","Riala the Hearthwatcher",{60.4,50.2}}, -- 103796
		-- 专业训练师
			{"部落剥皮训练师","Seymour",{45.6,25.6}}, --98721
		-- 商人
			{"瓦拉加尔军需官","Valdemar Stormseeker",{60.2,51.2}}, -- 106904
		},

		-- Highmountain
		["至高岭"]={
		-- 飞行管理员
			{"飞行管理员","Tamara Sigmund",{40.2,52.6}}, -- 94973
			{"飞行管理员","Chofa Nighthoof",{47.2,84.6}}, -- 96565
			{"飞行管理员","Farah Skybeak",{52.6,45.2}}, -- 97860
			{"飞行管理员","Rafat Smokehoof",{38.2,39.2}}, -- 97868
			{"飞行管理员","Kimben Wingheart",{30.0,39.4}}, -- 97870
			{"飞行管理员","Steven Nelson",{41.8,10.4}}, -- 98066
			{"飞行管理员","Brun Prepfoot",{58.0,28.6}}, -- 98972
			{"飞行管理员","Poca Firemantle",{56.8,53.8}}, -- 98966
			{"飞行管理员","Roren Longshadow",{35.8,66.0}}, -- 100550
			{"飞行管理员","Lassa Skymane",{59.2,65.0}}, -- 100559
		-- 旅店老板
			{"旅店老板","Marius Felbane",{29.8,40.0}}, -- 108504
		-- 专业训练师
			{"锻造训练师","Barm Stonebreaker",{55.2,84.2}}, -- 92242
			{"采矿训练师","Ronos Ironhorn",{55.0,84.0}}, -- 93691
		},

		-- Thunder Totem
		["雷霆图腾"]={
		-- 飞行管理员
			{"飞行管理员","Windtamer Nalt",{44.8,38.8}}, -- 95688
		-- 旅店老板
			{"旅店老板","Ernu Mesawind",{44.8,53.4}}, -- 97852
		-- 兽栏管理员
			{"兽栏管理员","Liza Galestride",{44.8,53.4}}, -- 97852
		-- 专业训练师
			{"附魔训练师","Guron Twaintail ",{44.2,45.2}}, -- 98017
		-- 商人
			{"高岭部族军需官","Ransa Greyfeather",{38.4,46.0}}, -- 106902
			{"玩具背包商人","Slyhoof the Shameless Shaman ",{60.8,59.2}}, -- 99574
		},

		-- Val'sharah
		["瓦尔莎拉"]={
		-- 飞行管理员
			{"飞行管理员","Elyssia Winterdusk",{55.0,72.4}}, -- 93447
			{"飞行管理员","Douglas Carrington",{42.2,58.6}}, -- 93940
			{"飞行管理员","Brinlanya Moonstone",{56.6,57.8}}, -- 100459
			{"飞行管理员","Landrius Ravenfall",{69.0,50.8}}, -- 100468
			{"飞行管理员","Gyrdaen Windreef",{25.8,66.4}}, -- 114837
		-- 旅店老板
			{"旅店老板","Faeolas Nightwhisper",{69.4,49.4}}, -- 95118
		-- 商人
			{"织梦者军需官","Sylvia Hartshorn",{54.6,73.2}}, -- 106901
		},

		-- Azsuna
		["阿苏纳"]={
		-- 飞行管理员
			{"飞行管理员","Izal Whitemoon",{44.6,43.8}}, -- 88110
			{"飞行管理员","Dagrona",{48.4,28.0}}, -- 90556
			{"飞行管理员","Stagtamer Maliana",{40.8,9.0}}, -- 90639
			{"飞行管理员","Trainee Sylwindial",{48.2,73.0}}, -- 108888
			{"飞行管理员","Adept Jena Moonrath",{31.8,46.2}}, -- 110971
			{"联盟飞行管理员","Trainee Starwhisper",{51.8,82.0}}, -- 111418
			{"飞行管理员","Adept Sunwing",{63.8,28.4}}, -- 111624
			{"飞行管理员","Avaya Farwind",{56.2,59.0}}, -- 112866
		-- 旅店老板
			{"旅店老板","Berazus",{47.8,23.4}}, -- 89939
			{"旅店老板","Gentle Rosh",{56.6,59.4}}, -- 91457
			{"旅店老板","Nalysse Dawnsorrow",{47.2,41.4}}, -- 109372
			{"联盟旅店老板","Filrich",{53.0,36.8}}, -- 109377
		-- 专业训练师
			{"珠宝加工训练师","Timothy Jones",{46.6,41.4}}, -- 100538
			{"制皮训练师","Celea",{47.4,44.0}}, -- 98964
			{"剥皮训练师","Glielle",{47.0,45.0}}, -- 98791
		-- 商人
			{"法罗迪斯宫廷军需官","Veridis Fallon",{46.8,41.4}}, -- 107376
			{"守望者军需官","Marin Bladewing",{48.2,73.8}}, -- 107379
		},

		-- Suramar
		["苏拉玛"]={
		-- 飞行管理员
			{"飞行管理员","Ancient Cloudwing",{34.2,49.4}}, -- 111675
			{"飞行管理员","Alyndra Stormgazer",{25.4,31.8}}, -- 114666
			{"飞行管理员","Ancient Cloudwing",{64.2,42.0}}, -- 114718
		-- 旅店老板
			{"旅店老板","First Arcanist Thalyssra",{36.8,46.6}}, -- 97140
		-- 专业训练师
			{"锻造训练师","Felsmith Nal'ryssa",{29.8,53.4}}, -- 92264
			{"制皮训练师","Stalriss Dawnrunner",{26.6,71.6}}, -- 98969
			{"剥皮训练师","Ske'rit",{30.6,33.4}}, -- 98720
		-- 商人
			{"堕夜精灵军需官","First Arcanist Thalyssra",{36.8,46.6}}, -- 97140
		},

		-- Eye of Azshara
		["艾萨拉之眼"]={
		},
	}
end