local _, TS = ...

--定义要显示的成就
--[[
    {
        tab = "test",
        bosses = {1017,621,13},
        idName = { [1017] = "养他", [621] = "战袍", [13] = "80级", },
    },
    {
        tab = "ULD(25)",
        bosses = {2885,2875,2882,3256,3257,3258,2879,2880,2883,2881},
        idName = { [2885] = "议会", [2875] = "左右手", [2882] = "猫女", [3256] = "霍迪尔", [3257] = "托里姆", [3258] = "弗蕾亚", [2879] = "米米隆", [2880] = "将军", [2883] = "尤格", [2881] = "观察者", },
    },
]]

TS.DATA_VERSION = 20170301

TS.VERSION_BOSSES = { -11194, "萨", -11581, "海", -11195, "古" }  --引领潮流

local RES = {
  {
      tab = "总览",
      ids = { 7399, -11162, -11195},
      names = { "秘境", "15层", "古尔丹" },
      tips = { "史诗秘钥副本总次数", "限时通关15层成就", "引领潮流：古尔丹 成就完成时间" }
  },
}

local INSTANCES = {
    {
        bosses = {
            { "击杀伊格诺斯", 10925, 10926, 10927, },
            { "击杀尼珊德拉", 10912, 10913, 10914, },
            { "击杀梦魇之龙", 10929, 10930, 10931, },
            { "击杀乌索克", 10916, 10917, 10919, },
            { "救赎塞纳留斯", 10933, 10934, 10935, },
            { "击杀艾乐瑞瑟·雷弗拉尔", 10921, 10922, 10923, },
            { "击杀萨维斯", 10937, 10938, 10939, },
        },
        diff = { "", "", "M翡翠", },
        tab = "翡翠梦魇",
    },
    {
        bosses = {
            { "击杀高姆", 11412, 11413, 11414, },
            { "击杀海拉", 11416, 11417, 11418, },
            { "奥丁", 11408, 11409, 11410, },
        },
        diff = { "", "H勇气", "M勇气", },
        tab = "勇气试炼",
    },
    {
        bosses = {
            { "击杀斯考匹隆", 10941, 10942, 10943, },
            { "击杀占星师艾塔乌斯", 10957, 10959, 10960, },
            { "击杀大魔导师艾利桑德", 10974, 10975, 10976, },
            { "击杀时空畸体", 10945, 10946, 10947, },
            { "击杀高级植物学家特尔安", 10962, 10963, 10964, },
            { "击杀古尔丹", 10978, 10979, 10980, },
            { "击杀崔利艾克斯", 10949, 10950, 10951, },
            { "击杀提克迪奥斯", 10966, 10967, 10968, },
            { "击杀克洛苏斯", 10970, 10971, 10972, },
            { "击杀魔剑士奥鲁瑞尔", 10953, 10954, 10955, },
        },
        diff = { "暗夜", "H暗夜", "M暗夜", },
        tab = "暗夜要塞",
    },
}

-- {
--    ids = { 7399, 11162, {id1, id2, id3, ...}, {}, ... },
--    names = { "秘境数", "15层", "M翡翠", "H勇气", ...},
--    tab = "总览",
--  },
local TABS = {}

for ord, tab in next, RES do
    local one = { ids = {}, names = {}, tips = {}, tab = tab.tab }
    for i = 1, #tab.ids do
        if tab.names[i] and #tab.names[i] > 0 then
            one.ids[i] = tab.ids[i]
            one.names[i] = tab.names[i]
            one.tips[i] = tab.tips[i]
        end
    end

    for i, ins in ipairs(INSTANCES) do
        for j, diff in ipairs(ins.diff) do
            if diff and #diff > 0 then
                local bosses = {}
                for k = 1, #ins.bosses do
                    bosses[k] = ins.bosses[k][j + 1]
                end
                table.insert(one.ids, bosses)
                table.insert(one.names, diff)
            end
        end
    end
    tinsert(TABS, one)
end

TS.TABS = TABS

--[==[
-- 鼠标移到统计项目上 /run a=GetMouseFocus().id print(a, GetAchievementInfo(a))

--之前的版本可以省略bossID, 从idName里取key
for _, v in next, TS.TABS do
    if(not v.bosses) then
        v.bosses = {}
        for k in next, v.idName do
            tinsert(v.bosses, k)
        end
        table.sort(v.bosses)
    end
end

-- GetAchievementInfo(6168) => 6168, "死亡之翼英雄模式擊殺數(巨龍之魂)", 0, false, nil, nil, nil, "", 9, "Interface\Icons\achievment_boss_madnessofdeathwing", "", false, false, nil


-- 一个boss一个boss的列出不同难度
local instanceList = { '翡翠梦魇', '梦魇', '勇气试炼', '勇气', '暗夜要塞', '要塞' }
local diff = { "普通", "英雄", "史诗" }
local pattern = "（{diff}{instance}）"
local prefixes = {"击败", "消灭", "掠夺", "通过"}

-- 获取成就很卡
if not ACHIEVE_DATAS then
    ACHIEVE_DATAS = {}
    for _, cate in next, GetStatisticsCategoryList() do
        for i = 1, GetCategoryNumAchievements(cate) do
            local id, name = GetAchievementInfo(cate, i)
            ACHIEVE_DATAS[id] = name
        end
    end
end

INSTANCES = {}
for kk = 1, #instanceList, 2 do
    local instanceName = instanceList[kk]
    local DATA = { tab = instanceName, diff = copy(diff), bosses = {} }
    tinsert(INSTANCES, DATA);
    for id, name in pairs(ACHIEVE_DATAS) do
        for diffId, diffName in next, diff do
            local search = pattern:gsub("{diff}", diffName):gsub("{instance}", instanceName)
            if(name:find(search)) then
                for _, prefix in  next, prefixes do name = name:gsub("^"..prefix, "") end
                name = name:gsub(search, "")
                local foundBoss
                for j, boss in next, DATA.bosses do
                    if boss[1] == name then
                        foundBoss = boss
                        break
                    end
                end
                if not foundBoss then
                    foundBoss = { name }
                    tinsert(DATA.bosses, foundBoss)
                end
                foundBoss[diffId+1] = id
                print(id, name, diffName, instanceName)
            end
        end
    end
    for _, boss in next, DATA.bosses do
        --boss[1] = instanceList[kk+1].." "..boss[1]
    end
end
wowluacopy(INSTANCES)
--------------------------------------------------------------
{
  {
    bosses = {
      { "伊墨苏斯", 8551, 8552, 8553, 8554, },
      { "堕落的守护者", 8557, 8558, 8559, 8560, },
      { "诺鲁什的试炼", 8563, 8564, 8565, 8566, },
      { "傲之煞", 8569, 8570, 8571, 8573, },
      { "迦拉卡斯", 8576, 8577, 8578, 8579, },
      { "钢铁战蝎", 8582, 8583, 8584, 8585, },
      { "黑暗萨满", 8588, 8589, 8590, 8591, },
      { "纳兹戈林将军", 8595, 8596, 8597, 8598, },
      { "马尔考罗克", 8601, 8602, 8603, 8604, },
      { "潘达利亚战利品", 8608, 8609, 8610, 8612, },
      { "嗜血的索克", 8616, 8617, 8618, 8619, },
      { "攻城匠师黑索", 8622, 8623, 8624, 8625, },
      { "卡拉克西英杰", 8628, 8629, 8630, 8631, },
      { "加尔鲁什·地狱咆哮", 8635, 8636, 8637, 8638, },
    },
    diff = {
      { "10人普通", "10", },
      { "25人普通", "25", },
      { "10人英雄", "10H", },
      { "25人英雄", "25H", },
    },
    tab = "决战奥格瑞玛",
  },
}

--老版本的以副本来
local pattern = "（{diff}{instance}）"
local instanceList = { '决战奥格瑞玛', }
local diff = {
  {"随机", ""},
  {"弹性", ""},
  {"10人普通", "10人"},
  {"25人普通", "25人"},
  {"10人英雄", "10H"},
  {"25人英雄", "25H"},
}
local prefixes = {"击败", "消灭", "掠夺", "通过"}
INSTANCES = {}
for _, instanceName in next, instanceList do
  for _, cate in next, GetStatisticsCategoryList() do
    for i = 1, GetCategoryNumAchievements(cate) do
      local id, name = GetAchievementInfo(cate, i)  
      for diffId, diffData in next, diff do
        local search = pattern:gsub("{diff}", diffData[1]):gsub("{instance}", instanceName)
        if(name:find(search)) then
          for _, prefix in  next, prefixes do name = name:gsub("^"..prefix, "") end
          name = name:gsub(search, "")
          local foundBoss
          for j, boss in next, INSTANCES do
            if boss.tab == name then 
              foundBoss = boss
              break
            end
          end
          if not foundBoss then
            foundBoss = { tab = name, bosses = {}, idName = {} }
            tinsert(INSTANCES, foundBoss)
          end
          tinsert(foundBoss.bosses, id)
          foundBoss.idName[id] = diffData[2]
        end
      end
    end
  end
end
wowluacopy(INSTANCES)

--]==]
