--
--	Grail Rewards
--	Written by scott@mithrandir.com
--
--	Version History
--		001	Initial version
--
--	Known Issues
--
--	UTF-8 file
--
--	Each reward is a string with colon as delimiter with the following type of values:
--		Xxxx		XP of xxx
--		Mxxx		Money of xxx in copper
--		Cxxx-yyy	Choice reward of item xxx, with count yyy
--		Rxxx-yyy	Reward of item xxx, with count yyy

local _, release, _, interface = GetBuildInfo()
release = tonumber(release)
interface = tonumber(interface)

local G = Grail.questRewards or {}

if release >= 0 then
G[33564]=':R107640-5:R108900'
G[34099]=':X43150:M536000:C112516'
G[34963]=':X14400:M134000'
G[38241]=':R122457-1'
G[38250]=':M462000'
G[39433]=':M154000'
G[39582]=':M154000:R124099-100'
end

if release >= 20338 then
G[3100]=':X130'
G[28766]=':X500:M50'
G[28774]=':X500:M40:R57388-1'
G[29464]=':M30'
G[29649]=':M44000:C25792:C25789:C25791:C25790:C25788'
G[29652]=':M44000'
G[29654]=':M44000:C25806:C25805:C25804:C25803'
G[29656]=':M44000'
G[35168]=':M11400:R108257-5'
G[36016]=':M15400:C118307:C118309:C118306:C118308'
G[36017]=':M15400'
G[37770]=':M616000:R123975-1'
G[37773]=':M816200'
G[37774]=':M816200'
G[37777]=':M816200'
G[37793]=':M616000'
G[37794]=':M616000'
G[37834]=':M308000'
G[37835]=':M308000'
G[37836]=':M308000'
G[37837]=':M308000'
G[37841]=':M154000'
G[37848]=':M38500'
G[37866]=':X14400:M134000'
G[37891]=':M462000'
G[37964]=':M77000'
G[37968]=':M462000'
G[38045]=':M462000'
G[38046]=':M462000'
G[38051]=':M616000'
G[38439]=':M154000'
G[38440]=':M462000'
G[39000]=':M154000'
G[39020]=':R127853-1'
G[39041]=':X14400:M134000'
G[39057]=':M154000'
G[39250]=':M616000'
G[39443]=':X14400:M134000'
G[39449]=':M154000'
G[39565]=':M154000'
G[39569]=':M154000'
G[39571]=':M154000'
G[39573]=':M154000'
G[39574]=':M154000'
G[39581]=':M154000'
G[39586]=':M154000'
G[39697]=':M154000'
end

if release >= 20426 then
G[38415]=':M154000'
end

if release >= 20444 then
G[29507]=':M146300:R71083-1'
G[33578]=':X14400:M134000'
G[33579]=':X14400:M134000'
G[35379]=':M750000'
G[37788]=':M38500'
G[37791]=':M616000'
G[37796]=':M616000'
G[37881]=':M38500'
G[37941]=':M38500'
G[39021]=':R127853-1'
end

if release >= 20490 then
G[24622]=':X130:M25'
G[24758]=':X170:M25'
G[24759]=':X220:M35'
G[24760]=':X190:M40'
G[24761]=':X380:M50'
G[24762]=':X380:M50:R52875-1'
G[24763]=':X130:M25'
G[25037]=':X250:M50'
G[25064]=':X25:M5'
G[37776]=':M816200'
G[37778]=':M816200'
G[37789]=':M616000'
G[37792]=':M616000'
G[37973]=':M38500'
G[39034]=':C127854'
G[39042]=':C122457'
G[40329]=':M154000:C116429'
end

if release >= 20574 then
G[12981]=':M74000'
G[13631]=':M296000:C46320:C46321:C46322:C46323'
G[13819]=':M296000:C45588:C45618:C45608:C45614'
G[26024]=':M5000:C59182:C59183:C59184:C59185'
G[26035]=':M4000'
G[26036]=':M2000'
G[26037]=':M2200'
G[26038]=':M4500:C59159:C59160:C59161:C59162:C59163'
G[26039]=':M2500'
G[26041]=':M5000'
G[26049]=':M5000:C59208:C59209:C59210:C59211'
G[26050]=':M2500'
G[26051]=':M5000:C59198:C59199:C59200'
G[26055]=':M2500:C59205:C59206:C59207'
G[26079]=':M5000:C59174:C59175:C59176:C59177'
G[26093]=':M2000'
G[26095]=':M5000:C59190:C59191:C59192:C59193'
G[26110]=':M2500'
G[26113]=':M1200'
G[26114]=':M250'
G[26116]=':M2500'
G[26117]=':M5000:C59168:C59169:C59170'
G[26336]=':M1200'
G[26346]=':M1100'
G[26462]=':M3000'
G[26483]=':M6500:C59242:C59243:C59244:C59245'
G[26485]=':M3000:R19022-1'
G[26486]=':M3000'
G[26490]=':M6500:C59239:C59240:C59241'
G[26491]=':M3000'
G[26492]=':M3000'
G[26496]=':M1700'
G[26497]=':M3500'
G[26498]=':M3500'
G[26515]=':M3500'
G[26516]=':M3500:C59246:C59247:C59248'
G[26517]=':M3500'
G[26518]=':M3500'
G[26521]=':M3500:C59249:C59250:C59251'
G[26523]=':M3500'
G[26524]=':M3500:C59252:C59253:C59254:C59255'
G[26525]=':M3500'
G[26526]=':M6500:C59256:C59257:C59258:C59259'
G[26528]=':M3500'
G[26529]=':M3500'
G[26530]=':M3500:C59265:C59266:C59267:C59268'
G[26532]=':M11000:C59269:C59270:C59271:C59272'
G[26546]=':M3000:C59235:C59236:C59237:C59238'
G[26547]=':M3000'
G[26548]=':M2200'
G[26628]=':C59212:C59213:C59214:C59215'
G[26641]=':M3500:C59260:C59262:C59263:C59264'
G[26643]=':M3500'
G[26935]=':M400'
G[26943]=':M200'
G[26953]=':M8000'
G[26954]=':M4000'
G[26955]=':M8500:C62194:C62193:C62192'
G[26956]=':M4000'
G[26957]=':M1100'
G[26999]=':M4000:C62174:C62173:C62172'
G[27000]=':M4000'
G[27001]=':M4000:C62180:C62179:C62178'
G[27002]=':M3000'
G[27011]=':M4000'
G[27012]=':M4000:C62177:C62176:C62175'
G[27013]=':M4000'
G[27017]=':M4500:C62198:C62197:C62196:C62195'
G[27053]=':M2000'
G[27055]=':M14000:C62201:C62200:C62199'
G[27057]=':M4500'
G[27151]=':M4000'
G[27152]=':M4000'
G[27153]=':M4000'
G[27154]=':M4000'
G[27156]=':M4000'
G[27157]=':M4000'
G[27159]=':M3500'
G[27160]=':M7500:C62143:C62142:C62141:C62140'
G[27161]=':M3500'
G[27162]=':M11000:C62151:C62150:C62149:C62148'
G[27163]=':M11000'
G[27164]=':M7500'
G[27165]=':M350'
G[27166]=':M4000'
G[27167]=':M4000:C62159:C62158:C62157:C62156'
G[27168]=':M4000'
G[27169]=':M3000'
G[27170]=':M2000'
G[27171]=':M7500:C62167:C62166:C62165:C62164'
G[27172]=':M2000'
G[27173]=':M4000'
G[27174]=':M8000:C62184:C62183:C62182:C62181'
G[27175]=':M400'
G[27197]=':M500'
G[27198]=':M10000:C62205:C62204:C62203:C62202'
G[27199]=':M5000'
G[27201]=':M10000'
G[27202]=':M10000:C62213:C62212:C62211:C62210'
G[27204]=':M15000'
G[27205]=':M500'
G[27206]=':M5000:C62222:C62221:C62220:C62219:C62218'
G[27625]=':M7500'
G[27626]=':M7500'
G[27725]=':M1700'
G[28390]=':M172000'
G[28505]=':M900'
G[29159]=':M94000'
G[29182]=':M23500'
G[29189]=':M94000'
G[29211]=':M94000'
G[29279]=':M188000'
G[29281]=':M188000'
G[29283]=':M188000'
G[30006]=':M114000'
G[30063]=':M114000'
G[30064]=':M114000'
G[30065]=':M114000'
G[30066]=':M114000'
G[30067]=':M114000'
G[30068]=':M114000'
G[30317]=':M114000'
G[30318]=':M114000'
G[30324]=':M114000'
G[30326]=':M114000'
G[30729]=':M228000'
G[30821]=':M106000'
G[30879]=':M114000'
G[30881]=':M114000'
G[30883]=':M114000'
G[30907]=':M114000'
G[30952]=':M228000'
G[30953]=':M114000'
G[30954]=':M114000'
G[30955]=':M114000'
G[30956]=':M228000'
G[30957]=':M114000'
G[30958]=':M114000'
G[30959]=':M114000'
G[31042]=':M114000'
G[31043]=':M114000'
G[31047]=':M114000'
G[31061]=':M114000'
G[31104]=':M114000'
G[31105]=':M114000'
G[31109]=':M114000'
G[31111]=':M114000'
G[31204]=':M114000'
G[31216]=':M114000'
G[31221]=':M228000'
G[31266]=':M57000'
G[31277]=':M342000:R87768-1'
G[31323]=':M114000'
G[31443]=':M154000'
G[31444]=':M154000'
G[31446]=':M154000'
G[31487]=':M114000'
G[31492]=':M114000'
G[31494]=':M114000'
G[31496]=':M114000'
G[31502]=':M114000'
G[31503]=':M114000'
G[31504]=':M114000'
G[31505]=':M114000'
G[31506]=':M114000'
G[31507]=':M114000'
G[31508]=':M114000'
G[31509]=':M114000'
G[31510]=':M114000'
G[31599]=':M228000'
G[31609]=':M228000'
G[31612]=':M228000:C90859:C90858'
G[31799]=':R87399-3:R79868-1'
G[31808]=':M114000'
G[31959]=':M114000'
G[32657]=':M114000'
G[32659]=':M114000'
G[32853]=':R98092-1:R98103-1'
G[32855]=':R98093-1:R98103-1'
G[32856]=':M77000'
G[32857]=':R98087-1:R98102-1'
G[36517]=':M154000:R112623-1'
G[36772]=':R87399-3:R109585-1'
G[37087]=':M154000'
G[37201]=':M154000:R116415-4'
G[37208]=':M154000:R116415-4'
G[37839]=':M462000:C124634:C124635:C124636:C124637:C124638'
G[39003]=':M154000'
G[39004]=':M2310000'
G[39568]=':M154000'
end

if release >= 20601 then
G[475]=':X270'
G[929]=':X550'
G[2159]=':X110:M25:C2070:C159'
G[2438]=':X410:M100'
G[3120]=':X130:M25'
G[6341]=':X160'
G[6344]=':X160'
G[26948]=':X250'
G[28713]=':X170:M35'
G[28714]=':X250:M50:R961-3:C5398'
G[28715]=':X250:M50:R46753-1'
G[28723]=':X130:M25'
G[28724]=':X250:M50:C10655:C10656'
G[28725]=':X190:M40'
G[28726]=':X360:M75:C10544'
G[28727]=':X360:M75:C5405:C6058'
G[28728]=':X230:M50'
G[28729]=':X450:M100'
G[28730]=':X450:M100:C4907'
G[28731]=':X450:M100'
G[28734]=':X25:M5'
G[35988]=':M77000'
G[36157]=':M154000'
G[37890]=':M308000'
G[37934]=':M154000'
G[37935]=':M308000'
G[38567]=':M15400'
G[38577]=':M116000'
G[38599]=':M308000'
G[39423]=':M15400'
G[39432]=':M154000'
G[39519]=':M154000'
G[39716]=':M154000:R128658-1'
G[39719]=':M154000:R128658-2'
G[39720]=':M154000:R128658-1'
G[39721]=':M154000:R128658-1'
end

if release >= 20726 then
G[13177]=':M114000'
G[14022]=':M14650'
G[14023]=':M73200'
G[14024]=':M73200'
G[14028]=':M73200'
G[14030]=':M73200'
G[14033]=':M73200'
G[14035]=':M73200:R44844-1'
G[14048]=':M73200:C46723:C46800:C44785:C46824:C44788:C116404'
G[14051]=':M73200:C46723:C46800:C44785:C46824:C44788:C116404'
G[14053]=':M73200:C46723:C46800:C44785:C46824:C44788:C116404'
G[14054]=':M73200:C46723:C46800:C44785:C46824:C44788:C116404'
G[14055]=':M109700:C46723:C46800:C44785:C46824:C44788:C116404'
G[26710]=':M86000'
G[27048]=':M86000'
G[27051]=':M86000'
G[37203]=':M154000:R116415-4'
G[37207]=':M154000:R116415-4'
G[37644]=':R118697-1'
G[38299]=':M154000:R122535-1:R116429-3'
end

if release >= 20779 then
G[834]=':X775:M300'
G[835]=':X775:C4932:C4931:C4938'
G[840]=':X420'
G[844]=':X900:M500'
G[6365]=':X160'
G[6384]=':X320:M85'
G[6385]=':X160'
G[6386]=':X625:M175'
G[7023]=':M14650'
G[7025]=':M36600:R17727-1'
G[7043]=':M73200:R116762-1'
G[7062]=':M14650'
G[7063]=':M14650'
G[7926]=':X80:R71634-1'
G[24623]=':X250:M50'
G[24624]=':X250:M50'
G[24625]=':X250:M50'
G[24626]=':X250:M50:C52877'
G[24764]=':X170:M25'
G[24765]=':X260:M35'
G[24766]=':X190:M40'
G[24767]=':X380:M50'
G[24768]=':X380:M50:R52870-1'
G[24769]=':X130:M25'
G[24812]=':X360:M75:C52883'
G[24813]=':X360:M75'
G[24814]=':X675:M300'
G[25035]=':X90:M20'
G[25073]=':X45:M10'
G[25126]=':X220:M65:C53359'
G[25127]=':X250:M50:C53380'
G[25128]=':X90:M25'
G[25129]=':X450:M100'
G[25130]=':X110:M25:R60241-1:C53371'
G[25131]=':X550:M150'
G[25132]=':X675:M300'
G[25133]=':X230:M50'
G[25135]=':X450:M150'
G[25136]=':X380:M50:R11584-10'
G[25152]=':X40'
G[25165]=':X550:M125'
G[25167]=':X550:M125'
G[25168]=':X550:M125:C53389:C53388'
G[25169]=':X550:M250:C53391:C53364'
G[25170]=':X410:M125'
G[25171]=':X55:M35'
G[25172]=':X250:M50'
G[25173]=':X625:M175:C53383:C53375:C53392'
G[25176]=':X480:M175'
G[25177]=':X625:M350'
G[25178]=':X480:M175'
G[25179]=':X625:M175:R53384-1'
G[25187]=':X525:M175'
G[25188]=':X875:M450'
G[25189]=':X700:M225'
G[25190]=':X700:M225'
G[25192]=':X775:M300:C53381:C53382'
G[25193]=':X700:M225:R60242-1:C53372:C53377:C53393'
G[25194]=':X350:M225'
G[25195]=':X975:M600:R53398-1'
G[25196]=':X210:M85'
G[25205]=':X850:M350'
G[25206]=':X850:M350:C53368:C53374'
G[25227]=':X70:M22'
G[25232]=':X850:M350'
G[25236]=':X850:M350'
G[25256]=':X85:M35'
G[25257]=':X625:M250'
G[25258]=':X850:M350'
G[25259]=':X1050:M700'
G[25260]=':X850:M350:C53369:C53366'
G[25261]=':X85'
G[25262]=':X900:C53358:C53387:C53390'
G[25263]=':X90'
G[25264]=':X90'
G[25648]=':X85:M35'
G[28494]=':X85'
G[28496]=':X85'
G[31812]=':X775:M300'
G[31813]=':X850:M350:R89125-1'
G[32838]=':M77000'
G[32839]=':R98080-1:R98102-1'
G[32851]=':R98091-1:R98101-1'
G[33078]=':M118000'
G[33462]=':M122000:C101677'
G[33633]=':M231000'
G[33871]=':M13400'
G[33872]=':M134000'
G[33873]=':M134000'
G[33874]=':M134000:C113035'
G[33882]=':M134000'
G[33884]=':M134000'
G[33928]=':M146000'
G[33973]=':M134000'
G[34012]=':M189000'
G[34087]=':M134000'
G[34088]=':M134000'
G[34089]=':M134000'
G[34090]=':M134000:C113024'
G[34091]=':M134000'
G[34094]=':M134000'
G[34095]=':M134000'
G[34096]=':M134000'
G[34097]=':M134000'
G[34098]=':M134000:C113051'
G[34099]=':M536000:C112516'
G[34154]=':M276000:C113015'
G[34157]=':M69000'
G[34163]=':M138000'
G[34164]=':M138000'
G[34399]=':M13800'
G[34400]=':M138000'
G[34403]=':M138000'
G[34406]=':M138000'
G[34415]=':M138000'
G[34448]=':M276000:C113011'
G[34464]=':M308000'
G[34466]=':M308000'
G[34512]=':M146000'
G[34513]=':M292000'
G[34514]=':M146000'
G[34515]=':M146000:C114881'
G[34516]=':M146000'
G[34572]=':M150000:C114683'
G[34593]=':M150000'
G[34596]=':M308000:C114911:C114912'
G[34597]=':M150000'
G[34598]=':M14600'
G[34662]=':M292000'
G[34663]=':M292000'
G[34664]=':M292000'
G[34665]=':M292000'
G[34666]=':M292000:C114709'
G[34698]=':M189000'
G[34699]=':M189000:C112617'
G[34700]=':M189000'
G[34702]=':M189000'
G[34703]=':M189000:C112884'
G[34704]=':M18900'
G[34707]=':M13800'
G[34723]=':M750000'
G[34724]=':M630000'
G[34802]=':M134000'
G[34809]=':M146000'
G[34810]=':M14600'
G[34811]=':M146000'
G[34819]=':M150000'
G[34869]=':M150000'
G[34877]=':M154000'
G[34881]=':M292000:C118152'
G[34893]=':M146000'
G[34894]=':M146000'
G[34897]=':M126000'
G[34900]=':M300000:R114834-1'
G[34932]=':M146000'
G[34941]=':M146000:C114884'
G[34943]=':M146000'
G[34959]=':M134000'
G[34963]=':M134000'
G[35022]=':M150000'
G[35023]=':M150000'
G[35024]=':M300000:C118159'
G[35026]=':M189000:C118039'
G[35033]=':M189000'
G[35037]=':M189000:C112591'
G[35050]=':M189000:C118031'
G[35055]=':M189000'
G[35059]=':M13950'
G[35060]=':M14650'
G[35061]=':M308000:C118139'
G[35062]=':M14650'
G[35063]=':M189000'
G[35065]=':M189000'
G[35067]=':M150000'
G[35068]=':M150000:C118148'
G[35069]=':M308000'
G[35083]=':M150000'
G[35084]=':M150000:C114886'
G[35085]=':M150000'
G[35086]=':M150000'
G[35087]=':M150000'
G[35088]=':M150000:C118144'
G[35128]=':M189000:C118022:C118023'
G[35137]=':M189000'
G[35139]=':M189000'
G[35140]=':M146000'
G[35141]=':M13400'
G[35146]=':M146000'
G[35169]=':M616000:C118154'
G[35185]=':M77000'
G[35196]=':M77000'
G[35210]=':M18900'
G[35236]=':M670000'
G[35254]=':M138000'
G[35330]=':M146000:C114680'
G[35331]=':M14600'
G[35332]=':M14600'
G[35337]=':M150000'
G[35338]=':M150000'
G[35350]=':M308000'
G[35356]=':M154000'
G[35357]=':M308000:C114695'
G[35372]=':M146000'
G[35386]=':M150000'
G[35393]=':M150000'
G[35395]=':M150000'
G[35396]=':M150000:C118124:C118125'
G[35397]=':M150000'
G[35398]=':M150000'
G[35632]=':M146000'
G[35633]=':M126000'
G[35640]=':M189000'
G[35642]=':M94500'
G[35644]=':M189000:C112596'
G[35645]=':M189000'
G[35647]=':M189000'
G[35649]=':M710000'
G[35656]=':M189000'
G[35659]=':M378000:C112603'
G[35663]=':M146000:C114890'
G[35664]=':M189000'
G[35665]=':M189000'
G[35666]=':M94500'
G[35686]=':M94500'
G[35693]=':M189000:C112612'
G[35702]=':M189000:C112588'
G[35730]=':M189000'
G[35737]=':M154000'
G[35808]=':M378000'
G[35809]=':M378000'
G[35812]=':M378000'
G[35813]=':M378000'
G[35816]=':M378000'
G[35817]=':M378000'
G[35820]=':M378000'
G[35828]=':M189000'
G[35834]=':M189000:C112609'
G[35870]=':M189000'
G[35925]=':M189000'
G[35934]=':M189000'
G[36075]=':M189000'
G[36078]=':M189000'
G[36084]=':M189000'
G[36105]=':M189000'
G[36208]=':M189000:C112864'
G[36209]=':M189000'
G[36210]=':M189000'
G[36223]=':M189000'
G[36273]=':M146000'
G[36275]=':M146000:C116830'
G[36284]=':M146000'
G[36285]=':M146000'
G[36289]=':M15400'
G[36409]=':M114000:R111814-1:R115359-1'
G[36432]=':M94500'
G[36436]=':M189000:C118034'
G[36440]=':M189000:C118014'
G[36443]=':M378000:C112961'
G[36500]=':M610000'
G[36502]=':M378000'
G[36508]=':M189000'
G[36564]=':M610000'
G[36571]=':M610000'
G[36576]=':M18900:R116394-1:C112885'
G[36792]=':M710000'
G[36820]=':M462000'
G[37119]=':M154000'
G[37129]=':M154000'
G[37137]=':M154000'
G[37148]=':M154000:R118922-1'
G[37149]=':M154000:R118936-1'
G[37150]=':M154000:R118921-1'
G[37151]=':M154000:R118918-1'
G[37152]=':M616000:R119083-1'
G[37155]=':M154000:R118925-1'
G[37158]=':M154000:R118928-1'
G[37163]=':M154000:R119003-1'
G[37164]=':M154000:R118923-1'
G[37165]=':M154000:R118935-1'
G[37179]=':M154000:R118938-1'
G[37205]=':M154000:R116415-4'
G[37318]=':M150000'
G[37332]=':M244000'
G[37446]=':X450:M150'
G[37631]=':M462000'
G[37795]=':M616000'
G[39278]=':M308000'
G[39359]=':M15400'
G[39648]=':M154000:R128659-1'
G[39649]=':M154000:R128632-5:R128659-1'
G[39651]=':M154000:R128659-2'
G[39668]=':M154000:R128659-1'
end

if release >= 20886 then
G[11490]=':M44000'
G[11905]=':M47000:C42758:C42761:C42763:C42765'
G[11911]=':M47000:C42760:C42762:C42766:C42767:C42768'
G[11973]=':M47000:C38223:C38222:C38221'
G[13094]=':M47000:C43181:C43182:C43183:C43184'
G[13131]=':M74000:C44404:C44405:C44407:C44406'
G[13132]=':M74000:C44408:C44409:C44410:C44412:C44411'
G[13187]=':M62000:C44350:C44351:C44352:C44353'
G[13635]=':M300'
G[13636]=':M400'
G[24536]=':M73200'
G[24541]=':M109700'
G[24576]=':M109700'
G[24850]=':M15400'
G[24851]=':M154000'
G[26012]=':M8200'
G[26013]=':M82000'
G[26034]=':M246000'
G[26131]=':M35'
G[26145]=':M500'
G[26146]=':M500:R414-5:C58986:C58985:C58984'
G[26147]=':M500:R2863-3:C58994:C58996:C58995'
G[26148]=':M1000:C58990:C58989:C58988'
G[26176]=':M500'
G[26842]=':M500'
G[26854]=':C58972:C58971:C58970'
G[26855]=':M400:C57560:C57566:C57562:C57563'
G[28934]=':M154000:R49927-5'
G[29611]=':M9800'
G[29684]=':M44000'
G[29685]=':M44000:C35487:C35488'
G[29690]=':M9800'
G[29825]=':M62000'
G[29826]=':M62000'
G[29829]=':M6600'
G[29830]=':M65000:C44342:C44343:C44344:C44345'
G[29834]=':M68000:C43164:C43165:C43167:C43168'
G[29839]=':M68000:C43171:C43172:C43173:C43176:C43174'
G[29844]=':M68000:C43180:C43178:C43179:C43177'
G[29864]=':M74000'
G[31261]=':M196000'
G[31853]=':M9800'
G[32979]=':M15400'
G[32980]=':M154000'
G[32983]=':M154000'
G[32984]=':M154000'
G[32985]=':M154000:R119145-1'
G[33145]=':M610000'
G[33427]=':M15400'
G[33444]=':M154000'
G[34034]=':M15400'
G[34035]=':M154000'
G[34039]=':M154000'
G[34040]=':M154000'
G[34041]=':M154000'
G[34042]=':M154000'
G[34078]=':M616000'
G[34106]=':M268000:C112585:C112536'
G[34107]=':M268000:C112576:C112579:C112583'
G[34108]=':M268000:C112582'
G[34309]=':M154000'
G[34314]=':M154000'
G[34315]=':M154000'
G[34316]=':M154000'
G[34318]=':M154000'
G[34319]=':M308000:R119151-1'
G[34352]=':M308000'
G[34353]=':M308000'
G[34355]=':M308000'
G[34365]=':M308000'
G[34381]=':M154000'
G[34397]=':M308000'
G[34409]=':M23100'
G[34410]=':M231000'
G[34418]=':M138000'
G[34450]=':M308000'
G[34455]=':M154000'
G[34469]=':M154000'
G[34472]=':M308000'
G[34505]=':M590000'
G[34566]=':M13000'
G[34569]=':M38050'
G[34576]=':M130000'
G[34577]=':M130000'
G[34579]=':M130000'
G[34667]=':M670000'
G[34683]=':M13000'
G[34758]=':M154000'
G[34766]=':M130000'
G[34803]=':M130000:C112527'
G[34837]=':M13000'
G[34840]=':M130000'
G[34855]=':M130000'
G[34858]=':M130000'
G[34860]=':M130000'
G[34870]=':M130000:C112523'
G[34971]=':M13000:R116395-1'
G[35102]=':M13000'
G[35186]=':M77000'
G[35187]=':M154000'
G[35188]=':M154000'
G[35189]=':M154000'
G[35190]=':M154000'
G[35191]=':M154000'
G[35194]=':M146300'
G[35195]=':M154000:R119134-1'
G[35197]=':M77000'
G[35237]=':M670000'
G[35537]=':M13800'
G[35679]=':M77000'
G[35680]=':M77000'
G[35684]=':M308000'
G[35687]=':M308000'
G[35837]=':M77000'
G[35838]=':M154000'
G[35839]=':M154000'
G[35840]=':M154000'
G[35841]=':M154000'
G[35842]=':M154000'
G[35843]=':M77000'
G[35844]=':M154000'
G[35845]=':M154000'
G[35846]=':M154000'
G[35876]=':M77000'
G[35881]=':M630000'
G[35945]=':M15400'
G[35970]=':M154000'
G[35972]=':M308000'
G[35973]=':M308000'
G[35985]=':M77000'
G[35993]=':M154000'
G[35994]=':M15400'
G[35995]=':M462000'
G[35997]=':M462000'
G[35998]=':M154000'
G[36000]=':M15400'
G[36004]=':M15400:C118295:C118298'
G[36005]=':M15400'
G[36006]=':M154000'
G[36007]=':M15400:C118300:C118303'
G[36009]=':M308000'
G[36010]=':M154000'
G[36012]=':M154000'
G[36013]=':M154000'
G[36014]=':M462000'
G[36117]=':M77000'
G[36134]=':M462000'
G[36137]=':M308000'
G[36138]=':M462000'
G[36142]=':M308000'
G[36160]=':M154000'
G[36161]=':M154000'
G[36162]=':M154000'
G[36163]=':M308000'
G[36164]=':M308000'
G[36167]=':M308000'
G[36168]=':M308000'
G[36169]=':M462000:R119144-1'
G[36193]=':M308000'
G[36196]=':M77000'
G[36197]=':M116000'
G[36198]=':M154000:R118110-1'
G[36206]=':M154000'
G[36219]=':M15400'
G[36220]=':M154000'
G[36221]=':M154000'
G[36222]=':M154000'
G[36226]=':M154000:R115793-3'
G[36227]=':M154000'
G[36228]=':M154000'
G[36290]=':M15400'
G[36449]=':M292550:R116154-1'
G[36469]=':M154000'
G[36480]=':M630000'
G[36504]=':M610000'
G[36505]=':M11400'
G[36516]=':M114000:R111818-1:R115358-1:R117566-1'
G[36520]=':M630000'
G[36563]=':M610000'
G[36590]=':M710000'
G[36644]=':M11400:R115524-5'
G[36685]=':M616000'
G[36743]=':R87399-3:R108439-1'
G[36745]=':R87399-3:R108439-1'
G[36748]=':R87399-3:R108439-1'
G[36750]=':R87399-3:R108439-1'
G[36756]=':R87399-3:R108439-1'
G[36761]=':R87399-3:R109584-1'
G[36763]=':R87399-3:R109584-1'
G[36766]=':R87399-3:R109584-1'
G[36767]=':R87399-3:R109584-1'
G[36768]=':R87399-3:R109584-1'
G[36769]=':R87399-3:R109584-1'
G[36770]=':R87399-3:R109584-1'
G[36775]=':R87399-3:R109585-1'
G[36776]=':R87399-3:R109585-1'
G[36780]=':R87399-3:R109585-1'
G[36821]=':M462000'
G[36874]=':M308000'
G[36912]=':M308000'
G[36917]=':M308000'
G[36944]=':M308000'
G[36945]=':M308000'
G[36946]=':M308000'
G[36950]=':M308000'
G[37032]=':M308000'
G[37033]=':M308000'
G[37034]=':M308000'
G[37035]=':M308000'
G[37036]=':M308000'
G[37037]=':M308000'
G[37038]=':M308000'
G[37039]=':M308000'
G[37040]=':M308000'
G[37041]=':M308000:R116675-1'
G[37048]=':M308000'
G[37049]=':M308000'
G[37050]=':M308000'
G[37051]=':M308000'
G[37052]=':M308000'
G[37053]=':M308000'
G[37054]=':M308000'
G[37055]=':M308000'
G[37056]=':M308000'
G[37057]=':M308000'
G[37058]=':M308000'
G[37059]=':M308000:R116656-1'
G[37063]=':M308000'
G[37064]=':M308000'
G[37065]=':M308000'
G[37066]=':M308000'
G[37067]=':M308000'
G[37068]=':M308000'
G[37069]=':M308000:R116662-1'
G[37071]=':M308000'
G[37072]=':M308000'
G[37073]=':M308000'
G[37074]=':M308000'
G[37075]=':M308000'
G[37076]=':M308000'
G[37077]=':M308000'
G[37078]=':M308000'
G[37079]=':M308000:R116676-1'
G[37093]=':M308000'
G[37094]=':M308000'
G[37095]=':M308000'
G[37096]=':M308000'
G[37097]=':M308000'
G[37098]=':M308000'
G[37099]=':M308000'
G[37100]=':M308000'
G[37101]=':M308000'
G[37102]=':M308000'
G[37103]=':M308000'
G[37104]=':M308000:R116774-1'
G[37105]=':M308000'
G[37106]=':M308000'
G[37107]=':M308000'
G[37108]=':M308000'
G[37109]=':M308000'
G[37110]=':M308000'
G[37111]=':M308000:R116784-1'
G[37123]=':M116000'
G[37124]=':M116000'
G[37126]=':M154000'
G[37127]=':M154000'
G[37153]=':M154000:R118929-1'
G[37154]=':M154000:R118931-1'
G[37156]=':M154000:R119039-1'
G[37157]=':M154000:R119092-1'
G[37159]=':M154000:R119093-1'
G[37160]=':M154000:R118937-1'
G[37161]=':M154000:R118926-1'
G[37162]=':M154000:R118927-1'
G[37166]=':M154000:R118930-1'
G[37167]=':M154000:R118924-1'
G[37209]=':M154000:R119036-1'
G[37245]=':M154000:R119036-1'
G[37280]=':M750000'
G[37295]=':M731400'
G[37297]=':M731400'
G[37475]=':M308000'
G[37476]=':M308000'
G[37477]=':M308000'
G[37478]=':M308000'
G[37511]=':M308000'
G[37516]=':M308000'
G[37517]=':M308000'
G[37622]=':M462000'
G[37624]=':M462000'
G[37626]=':M462000'
G[37627]=':M462000'
G[37628]=':M462000'
G[37629]=':M462000'
G[37630]=':M462000'
G[37632]=':M462000'
G[37633]=':M462000'
G[37634]=':M462000'
G[37636]=':M462000'
G[37688]=':M154000'
G[37780]=':M616000'
G[37781]=':M616000'
G[37782]=':M616000'
G[37783]=':M616000'
G[37787]=':M616000'
G[37813]=':M816200'
G[37816]=':M816200'
G[37889]=':M38500'
G[37940]=':M462000'
G[37942]=':M38500'
G[37943]=':M38500'
G[37944]=':M38500'
G[37961]=':R122613-1'
G[37976]=':M38500'
G[37977]=':M38500'
G[37978]=':M38500'
G[37996]=':M1500022'
G[37997]=':M1500022'
G[38001]=':M308000'
G[38044]=':M462000'
G[38047]=':M462000'
G[38213]=':M154000'
G[38223]=':M308000:R124557-1'
G[38242]=':R122457-1'
G[38252]=':M462000'
G[38269]=':M15400'
G[38270]=':M154000'
G[38271]=':M154000'
G[38272]=':M154000'
G[38273]=':M154000'
G[38274]=':M308000:R124553-1'
G[38300]=':M154000:R122535-1:R116429-3'
G[38306]=':M154000'
G[38396]=':R122339-1'
G[38402]=':R122341-1'
G[38416]=':M308000:R124552-1'
G[38417]=':M154000'
G[38441]=':M462000'
G[38449]=':M462000'
G[38453]=':M154000:R123852-1'
G[38458]=':M154000'
G[38462]=':M154000'
G[38463]=':M462000:R124551-1:R128225-1'
G[38568]=':M77000'
G[38569]=':M154000'
G[38570]=':M154000'
G[38571]=':M15400'
G[38572]=':M154000'
G[38573]=':M77000'
G[38586]=':M462000'
G[38876]=':M462000'
G[38877]=':M462000'
G[38923]=':M146300'
G[38925]=':M146300'
G[38926]=':M146300'
G[39018]=':M77000'
G[39090]=':M146300'
G[39221]=':M616000'
G[39225]=':M616000'
G[39231]=':M616000'
G[39236]=':M15400'
G[39241]=':M15400'
G[39242]=':M15400'
G[39243]=':M15400'
G[39245]=':M14650:R127270-1'
G[39246]=':R127267-1'
G[39263]=':M308000'
G[39315]=':M116000'
G[39364]=':M15400'
G[39499]=':M308000'
G[39504]=':M308000'
G[39513]=':M154000'
G[39526]=':M154000'
G[39529]=':M154000:R124099-100'
G[39532]=':M154000'
G[39604]=':M15400'
G[39674]=':M15400'
G[39675]=':M15400'
G[39676]=':M15400:R128373-5'
G[40173]=':M154000'
G[40235]=':R115981-5'
G[40237]=':R115510-75'
G[40417]=':M15400'
G[40792]=':R127853-1'
G[40904]=':M219450'
G[40962]=':M219450:R128422-1'
end

if release >= 21355 then
G[13816]=':M148000'
G[13817]=':M222000'
G[13821]=':M296000'
G[13822]=':M296000'
G[13823]=':M296000'
G[13824]=':M296000'
G[29590]=':M37000'
G[29591]=':M37000'
G[29596]=':M37000:C29341:C29340:C29339:C29337'
G[30730]=':M228000'
G[31118]=':M114000'
G[31291]=':M114000'
G[31324]=':M102000:C87313:C87314'
G[31327]=':M102000:C87308:C87309'
G[32505]=':M114000:R94221-1'
G[32525]=':M114000'
G[32529]=':M114000'
G[32531]=':M114000'
G[32536]=':M114000'
G[32539]=':M114000'
G[32540]=':M114000'
G[32542]=':M114000'
G[32543]=':M114000'
G[32544]=':M114000'
G[32552]=':M114000'
G[32555]=':M114000'
G[32559]=':M114000'
G[32560]=':M114000'
G[32568]=':M28500'
G[32575]=':M114000'
G[32578]=':M228000:R94219-1'
G[32588]=':M114000'
G[32604]=':M154000:R94207-1'
G[32650]=':M114000'
G[32731]=':M28500'
G[32732]=':M28500'
G[32733]=':M28500'
G[32807]=':M456000:C98133'
G[32863]=':M154000:R98095-1'
G[32868]=':M154000:R94207-1'
G[32869]=':M154000:R94207-1'
G[33374]=':M228000:C103643:C103642:C103641'
G[34335]=':M23100'
G[34336]=':M231000:R119139-1'
G[34337]=':M23100'
G[34338]=':M693000'
G[34339]=':M231000'
G[34340]=':M231000'
G[34341]=':M231000'
G[34347]=':M115500'
G[35016]=':M189000'
G[36016]=':M15400:C118305:C118308'
G[36242]=':M154000'
G[36248]=':M154000'
G[36261]=':M154000'
G[36603]=':M630000'
G[37177]=':M462000'
G[37914]=':M38500'
G[38345]=':R122338-1'
end

if release >= 21463 then
G[10297]=':M44000:C29320:C29322:C29321:C29323'
G[13375]=':M296000'
G[13682]=':M300:C46114:C45724'
G[13789]=':M300:C46114:C45724'
G[13790]=':M300:C46114:C45724'
G[13818]=':M296000:R45798-1:R45878-1'
G[13861]=':M74000:C46114:C45724'
G[14076]=':M74000'
G[14077]=':M74000'
G[14096]=':M74000'
G[14104]=':M74000'
G[14107]=':M74000'
G[25316]=':M59000'
G[27003]=':M500'
G[27227]=':M7500'
G[27228]=':M7500'
G[27230]=':M7500'
G[27352]=':M7500'
G[27359]=':M7500'
G[27724]=':M30'
G[27726]=':M30'
G[27922]=':M86000'
G[27923]=':M86000'
G[28105]=':M86000:C65820:C65819:C65821'
G[28558]=':M50'
G[28778]=':M146300:R52351-1'
G[28781]=':M94000:C66907:C66905:C66906'
G[28783]=':M94000:C66910:C66908:C66909'
G[28814]=':M90000'
G[28815]=':M90000'
G[28852]=':M94000:R66943-1'
G[28853]=':M94000:C66937:C66936:C66938'
G[28854]=':M94000:C66934:C66935:C66933'
G[29139]=':M94000'
G[29142]=':M94000'
G[29147]=':M1150'
G[29148]=':M94000'
G[29154]=':M94000'
G[29155]=':M94000:R69262-1:R69863-1:R69864-1:R69865-1'
G[29156]=':M9400'
G[29162]=':M94000'
G[29172]=':M94000'
G[29179]=':M94000'
G[29203]=':M188000'
G[29206]=':M94000'
G[29241]=':M94000'
G[29242]=':M94000'
G[29246]=':M94000'
G[29247]=':M94000'
G[29255]=':M94000'
G[29257]=':M94000'
G[29264]=':M94000'
G[29265]=':M94000'
G[29272]=':M94000'
G[29274]=':M94000'
G[29280]=':M23500'
G[29298]=':M775'
G[29302]=':M775'
G[29303]=':M775'
G[29304]=':M94000'
G[29310]=':M775'
G[29311]=':M376000:R71259-1'
G[29563]=':M60'
G[29564]=':M66000'
G[29565]=':M66000:C25541:C28029:C25540'
G[29573]=':M35000'
G[29574]=':M35000'
G[29575]=':M35000'
G[29577]=':X13150:M102000'
G[29581]=':X13150:M102000'
G[29600]=':X13150:M102000:C81811'
G[29605]=':M41000:C29333:C29334:C29335:C29336'
G[29606]=':M41000:C29330:C29332:C29329'
G[29607]=':M41000'
G[29674]=':M44000'
G[29675]=':M44000'
G[29681]=':M44000'
G[29686]=':M44000'
G[29687]=':M44000'
G[29757]=':X13150:M102000'
G[29758]=':X13150:M102000'
G[29871]=':X1300:M10200'
G[29872]=':X1300:M10200'
G[29873]=':X1300:M9400'
G[29874]=':X1300:M9400'
G[29877]=':X13150:M102000:R88371-1'
G[29907]=':X1300:M10200'
G[29908]=':X13150:M102000:C81775'
G[29909]=':X1300:M10200'
G[29910]=':X13150:M102000:R88370-1'
G[29911]=':X1300:M10200'
G[29912]=':X9850:M77000'
G[29913]=':X13150:M102000:C88011'
G[29914]=':X13150:M102000'
G[29915]=':X1300:M10200'
G[29916]=':X9850:M77000'
G[29917]=':X13150:M102000'
G[29918]=':X16450:M204000:C81826'
G[29919]=':X6550:M51000'
G[29940]=':X13150:M102000:C81802'
G[29944]=':X13150:M102000:R88375-1'
G[29945]=':X13150:M102000:R88377-1'
G[29946]=':X16450:M102000'
G[29947]=':X13150:M102000:R88376-1'
G[29948]=':X13150:M102000'
G[29949]=':X3300:M10200'
G[29950]=':X13150:M102000'
G[29951]=':X13150:M102000:C81784'
G[29952]=':X16450:M204000'
G[30028]=':X13150:M102000'
G[30029]=':X13150:M102000:C84331'
G[30030]=':X13150:M102000'
G[30031]=':X13150:M102000'
G[30032]=':X13150:M102000:C81793'
G[30046]=':X1300:M10200'
G[30047]=':X13150:M102000'
G[30048]=':X1300:M10200'
G[30049]=':X1300:M10200'
G[30053]=':X13150:M102000'
G[30058]=':X13150:M102000:C88030'
G[30059]=':X13150:M102000'
G[30072]=':X13150:M102000:C84341'
G[30086]=':X1300'
G[30134]=':M57000'
G[30135]=':M114000'
G[30136]=':M114000'
G[30137]=':M114000'
G[30138]=':M57000:C78962:C78960:C78961'
G[30141]=':M57000'
G[30142]=':M57000'
G[30146]=':M114000'
G[30147]=':M114000'
G[30148]=':M114000'
G[30149]=':M114000'
G[30150]=':M114000'
G[30151]=':M114000'
G[30243]=':M114000'
G[30267]=':X13150:M102000'
G[30280]=':M456000'
G[30322]=':M114000'
G[30500]=':X13000:M98000'
G[30502]=':X13000:M98000'
G[30565]=':X13000:M98000'
G[30568]=':X13000:M98000'
G[30648]=':X9750:M74000'
G[30717]=':M114000'
G[30731]=':M228000'
G[30732]=':M228000'
G[30733]=':M228000'
G[30734]=':M228000'
G[30735]=':M228000'
G[30736]=':M228000'
G[30737]=':M228000'
G[31113]=':M114000'
G[31114]=':M114000'
G[31116]=':M114000'
G[31117]=':M114000'
G[31119]=':M114000'
G[31120]=':M114000'
G[31196]=':M114000'
G[31197]=':M114000'
G[31198]=':M114000'
G[31200]=':M114000'
G[31201]=':M114000'
G[31203]=':M114000'
G[31281]=':X1350:M11400'
G[31303]=':X13000:M98000'
G[31319]=':X13000:M98000'
G[31337]=':R90735-1'
G[31362]=':X13000:M98000'
G[31442]=':M114000'
G[31448]=':M114000:C87383:C87387'
G[31705]=':M114000'
G[32035]=':X1300:M10200'
G[32115]=':M114000'
G[32116]=':M11400'
G[32121]=':M114000'
G[32122]=':M114000'
G[32144]=':M114000'
G[32145]=':M114000'
G[32148]=':M114000'
G[32149]=':M114000'
G[32150]=':M114000'
G[32152]=':M114000'
G[32153]=':M114000'
G[32154]=':M114000'
G[32156]=':M114000'
G[32157]=':M114000'
G[32158]=':M114000'
G[32193]=':M57000'
G[32194]=':M114000'
G[32243]=':M114000'
G[32315]=':M57000'
G[32316]=':M114000'
G[32321]=':M114000'
G[32331]=':M114000'
G[32332]=':M114000'
G[32333]=':M114000'
G[32334]=':M114000'
G[32346]=':M114000'
G[32347]=':M114000'
G[32355]=':M114000'
G[32362]=':M114000'
G[32370]=':M57000'
G[32371]=':M114000'
G[32377]=':M114000'
G[32380]=':M57000'
G[32381]=':M114000'
G[32382]=':M11400'
G[32383]=':M114000'
G[32393]=':M57000'
G[32394]=':M114000'
G[32397]=':M114000'
G[32414]=':M57000'
G[32416]=':M57000'
G[32417]=':M114000'
G[32418]=':M228000'
G[32419]=':M228000'
G[32420]=':M114000'
G[32421]=':M114000'
G[32423]=':M342000'
G[32426]=':M114000'
G[32446]=':M114000'
G[32451]=':M11400'
G[32452]=':M11400'
G[32460]=':M57000'
G[32526]=':M114000'
G[32527]=':M114000'
G[32530]=':M114000'
G[32533]=':M114000'
G[32538]=':M114000'
G[32541]=':M114000'
G[32545]=':M114000'
G[32554]=':M114000'
G[32558]=':M114000'
G[32574]=':M114000'
G[32587]=':M228000:R94219-1'
G[32608]=':M456000'
G[32640]=':M228000'
G[32646]=':M114000'
G[32945]=':M114000'
G[33077]=':X13850:M118000'
G[33078]=':X13850:M118000'
G[33084]=':X13850:M118000'
G[33419]=':X13850:M118000'
G[33543]=':M189000'
G[33544]=':M189000'
G[33548]=':M189000:C112608'
G[33563]=':M189000:C118030'
G[33593]=':M189000'
G[33786]=':X13850:M118000'
G[33787]=':M118000'
G[33788]=':M118000:R113130-1'
G[33808]=':M118000:C106143'
G[33833]=':X17300:M236000'
G[33834]=':X17300:M236000:C113163'
G[33836]=':X17300:M236000:C117991'
G[33944]=':M134000'
G[34012]=':X21150:M189000'
G[34026]=':M15400'
G[34027]=':M154000'
G[34028]=':M154000'
G[34076]=':X69150:M590000'
G[34392]=':X13700:M114000'
G[34393]=':X13700:M114000:C112387'
G[34398]=':X6850:M57000'
G[34420]=':X1350:M11400'
G[34422]=':X13700:M114000:C112432'
G[34423]=':X13700:M114000'
G[34425]=':X6850:M57000'
G[34429]=':X17100:M228000'
G[34431]=':X13700:M114000'
G[34432]=':X13700:M114000:C112665'
G[34434]=':X13700:M114000'
G[34436]=':X13700:M114000'
G[34437]=':X6850:M57000'
G[34439]=':X20550:M342000'
G[34442]=':X13700:M114000'
G[34445]=':X20550:M342000'
G[34463]=':M308000'
G[34465]=':M308000'
G[34478]=':X13700:M114000:C112442'
G[34496]=':X69150:M590000'
G[34504]=':X69150:M590000'
G[34575]=':X13700:M114000'
G[34675]=':M146000'
G[34698]=':X21150:M189000'
G[34699]=':X21150:M189000:C112618'
G[34700]=':X21150:M189000'
G[34702]=':X21150:M189000'
G[34703]=':X21150:M189000:C112886'
G[34704]=':X2100:M18900'
G[34728]=':X69150:M590000'
G[34836]=':X13850:M118000'
G[34847]=':X14100:M126000:C113162'
G[34876]=':X13950:M122000'
G[34897]=':X14100:M126000'
G[34925]=':X13700:M114000'
G[34958]=':X13700:M114000'
G[34987]=':X13700:M114000'
G[34994]=':M114000'
G[34995]=':M114000'
G[34996]=':X10450:M114000:C113239'
G[34997]=':X10450:M114000'
G[35000]=':M138000'
G[35006]=':M114000'
G[35014]=':M114000'
G[35015]=':M114000:C107305'
G[35019]=':X13700:M114000:C112671'
G[35026]=':X21150:M189000:C118038'
G[35033]=':X21150:M189000'
G[35037]=':X21150:M189000:C112593'
G[35050]=':X21150:M189000:C118033'
G[35055]=':X21150:M189000'
G[35063]=':X21150:M189000'
G[35065]=':X21150:M189000'
G[35128]=':X21150:M189000:C118024'
G[35137]=':X21150:M189000'
G[35139]=':X21150:M189000'
G[35151]=':M189000'
G[35210]=':X2100:M18900'
G[35218]=':X5300'
G[35236]=':X71900:M670000'
G[35240]=':X13700:M114000'
G[35242]=':X13700:M114000'
G[35399]=':M189000:C112615'
G[35400]=':M189000'
G[35402]=':M189000'
G[35406]=':M189000'
G[35416]=':M195000'
G[35429]=':M189000'
G[35430]=':M189000'
G[35432]=':M189000:C112858:C119068'
G[35433]=':M189000'
G[35434]=':M189000:C118009:C119090'
G[35487]=':M195000'
G[35501]=':M195000'
G[35505]=':M183000'
G[35506]=':M183000:C112619'
G[35507]=':M195000:C112872'
G[35508]=':M183000'
G[35509]=':M195000'
G[35510]=':M195000:C112590'
G[35524]=':M183000'
G[35527]=':M183000'
G[35536]=':M19500'
G[35633]=':X14100:M126000'
G[35640]=':X21150:M189000'
G[35642]=':X10600:M94500'
G[35644]=':M189000:C112595'
G[35645]=':X18900:M189000'
G[35647]=':X18900:M189000'
G[35656]=':X18900:M189000'
G[35659]=':M378000:C112606'
G[35664]=':X21150:M189000'
G[35665]=':X21150:M189000'
G[35666]=':X10600:M94500'
G[35686]=':X10600:M94500'
G[35693]=':X21150:M189000:C112614'
G[35702]=':X21150:M189000:C112589'
G[35707]=':M91500'
G[35730]=':X21150:M189000'
G[35747]=':X13700:M114000'
G[35812]=':X26450:M378000'
G[35820]=':X26450:M378000'
G[35834]=':X21150:M189000:C112611'
G[35861]=':M77000'
G[35870]=':X21150:M189000'
G[35881]=':X70500:M630000'
G[35884]=':X20550:M342000'
G[35925]=':X21150:M189000'
G[35926]=':M138000'
G[35933]=':X13700'
G[35934]=':X21150:M189000'
G[35944]=':X12600:M189000'
G[35959]=':M138000'
G[35989]=':M15400:C118292:C118294:C118293'
G[35990]=':M154000'
G[35991]=':M154000'
G[35992]=':M154000'
G[36023]=':M138000'
G[36029]=':M138000'
G[36048]=':M138000'
G[36081]=':X21150:M189000'
G[36105]=':X16800:M189000'
G[36136]=':M462000'
G[36158]=':M154000'
G[36165]=':M13800:R116394-1'
G[36195]=':M616000'
G[36208]=':X21150:M189000:C112863'
G[36209]=':X21150:M189000'
G[36210]=':X21150:M189000'
G[36223]=':X21150:M189000'
G[36432]=':X10600:M94500'
G[36434]=':M18900'
G[36436]=':M189000:C118037'
G[36437]=':M189000'
G[36438]=':M189000'
G[36440]=':M189000:C118005'
G[36441]=':M189000'
G[36442]=':M189000'
G[36443]=':M378000:C112960:C119054'
G[36448]=':M292550:R116154-1'
G[36460]=':M94500'
G[36473]=':M610000'
G[36474]=':M18900'
G[36480]=':X70500:M630000'
G[36482]=':M195000:C112594'
G[36483]=':M15400:R116415-8'
G[36488]=':M195000'
G[36495]=':X1400:M13000'
G[36500]=':X55700:M610000'
G[36504]=':X55700:M610000'
G[36508]=':X21150:M189000'
G[36520]=':X70500:M630000'
G[36563]=':X69850:M610000'
G[36571]=':X69850:M610000'
G[36576]=':X2100:M18900:R116394-1:C112887'
G[36595]=':X21150:M189000'
G[36603]=':X70500:M630000'
G[36645]=':M11400:R115504-6'
G[36813]=':M616000:R117398-1'
G[36911]=':M308000'
G[36913]=':M308000'
G[36914]=':M308000'
G[36915]=':M308000'
G[36916]=':M308000'
G[36918]=':M308000'
G[36971]=':M308000'
G[36972]=':M308000'
G[36973]=':M308000'
G[36974]=':M308000'
G[36975]=':M308000'
G[36976]=':M308000'
G[36977]=':M308000'
G[36983]=':M308000'
G[36984]=':M308000'
G[36985]=':M308000'
G[36986]=':M308000'
G[36987]=':M308000'
G[36988]=':M308000'
G[36995]=':M308000'
G[36996]=':M308000'
G[36997]=':M308000'
G[36998]=':M308000'
G[36999]=':M308000'
G[37005]=':M308000'
G[37006]=':M308000'
G[37007]=':M308000'
G[37008]=':M308000'
G[37015]=':M308000'
G[37016]=':M308000'
G[37017]=':M308000'
G[37022]=':M308000'
G[37023]=':M308000'
G[37092]=':M154000:R118365-1'
G[37121]=':M116000'
G[37184]=':M13400'
G[37192]=':M462000:R120313-1'
G[37287]=':M138000:R119001-1'
G[37319]=':R119191-1'
G[37320]=':R119195-1'
G[37323]=':R119191-1'
G[37324]=':R119191-1'
G[37332]=':X17450:M244000'
G[37585]=':M462000'
G[37687]=':M154000'
G[37790]=':M616000'
G[38267]=':M15400'
G[38421]=':M154000'
G[38560]=':M154000:R123852-1'
G[38585]=':M462000'
G[39253]=':M616000'
G[39500]=':M308000'
G[39567]=':M154000'
G[39570]=':M154000'
G[40168]=':M154000'
G[40787]=':M154000'
end

if release >= 21691 then
G[37466]=':X45200'
G[37507]=':X1500'
G[37654]=':X1500'
G[37657]=':X45200:M462000:R133549-1:C138851:C129170'
G[37779]=':X45200:M462000'
G[37965]=':X45200:M462000'
G[38203]=':X15050:M154000:C121493:C132967'
G[38407]=':X1500'
G[38857]=':X15050:M154000:C133037:C133032'
G[39123]=':X15900:M178000'
G[39124]=':X15900:M178000'
G[39178]=':X19900:M356000'
G[39305]=':X7950:M89000:R129277-1'
G[39317]=':X47700'
G[39322]=':X15900:M178000:C133095:C133106'
G[39386]=':X1600:M17800'
G[39387]=':X1600:M17800:R138784-1'
G[39392]=':X15900:M178000'
G[39656]=':X15900:M178000:R131933-1'
G[39670]=':X11950:M134000'
G[39859]=':X15900:M178000:R130320-1'
G[39867]=':X19900:M356000:R133810-1'
G[40000]=':X15900:M178000'
G[40122]=':X1500:M15400'
G[40170]=':X15900:M178000'
G[40216]=':X19900:M356000'
G[40217]=':X1600:M17800'
G[40228]=':X19900:M356000:C121655:C130277'
G[42268]=':X15050:M154000'
G[42375]=':X15050:M154000'
G[42425]=':X15900:M178000'
G[42630]=':X15900:M178000'
end

if release >= 21737 then
G[38308]=':X15200:M158000'
G[38317]=':X15200:M158000'
G[38331]=':X1500:M15800'
G[38332]=':X15050:M154000'
G[38357]=':X15050:M154000'
G[38358]=':X15050:M154000:C134555:C134559'
G[38442]=':X45650:M474000'
G[38459]=':X1500:M15800'
G[38611]=':X1500:M15800'
G[38612]=':X15200:M158000'
G[38613]=':X1500:M15800'
G[39590]=':X15200:M158000'
G[39591]=':X15200:M158000'
G[39592]=':X15200:M158000'
G[39593]=':X11400:M119000:C121560:C129316'
G[39594]=':X15200:M158000'
G[39595]=':X15200:M158000'
G[39597]=':X7600:M79000:R138784-1:C132778:C132789'
end

if release >= 21742 then
G[12704]=':M65000'
G[12705]=':M136000'
G[12726]=':M74000'
G[29101]=':M1150'
G[29122]=':M94000'
G[29123]=':M94000'
G[29125]=':M1150'
G[29126]=':M94000'
G[29127]=':M94000'
G[29128]=':M188000'
G[29137]=':M94000'
G[29138]=':M94000'
G[29141]=':M94000'
G[29143]=':M94000'
G[29161]=':M1150'
G[29163]=':M94000'
G[29164]=':M1150'
G[29165]=':M94000'
G[29166]=':M94000'
G[29177]=':M78000'
G[29205]=':M94000'
G[29263]=':M94000'
G[29273]=':M94000'
G[29282]=':M23500'
G[29287]=':M94000'
G[29288]=':M94000'
G[29290]=':M94000'
G[29293]=':M94000'
G[29295]=':M94000'
G[29296]=':M94000'
G[29299]=':M94000'
G[30277]=':M456000'
G[30716]=':M114000'
G[30718]=':M114000'
G[30738]=':M228000'
G[30739]=':M228000'
G[31044]=':M114000'
G[31045]=':M114000'
G[31048]=':M114000'
G[31062]=':M114000'
G[31106]=':M114000'
G[31199]=':M114000'
G[31486]=':M11400'
G[31802]=':R87399-3:R79868-1'
G[32142]=':M114000'
G[32143]=':M114000'
G[32146]=':M114000'
G[32164]=':M114000'
G[32165]=':M114000'
G[32166]=':M114000'
G[32336]=':M114000'
G[32337]=':M114000'
G[32338]=':M114000'
G[32400]=':M57000'
G[32401]=':M342000'
G[32455]=':M342000:R93385-1'
G[32550]=':M114000'
G[32551]=':M114000'
G[32553]=':M114000'
G[32567]=':M28500'
G[32572]=':M114000'
G[32581]=':M228000:R94219-1'
G[32586]=':M114000'
G[32599]=':M114000:R95589-1'
G[36676]=':M462000'
G[36978]=':M308000'
G[36979]=':M308000'
G[36980]=':M308000'
G[36981]=':M308000'
G[36982]=':M308000:R116774-1'
G[36989]=':M308000'
G[36990]=':M308000'
G[36991]=':M308000'
G[36992]=':M308000'
G[36993]=':M308000'
G[37000]=':M308000'
G[37001]=':M308000'
G[37002]=':M308000'
G[37003]=':M308000'
G[37004]=':M308000:R116675-1'
G[37009]=':M308000'
G[37010]=':M308000'
G[37011]=':M308000'
G[37012]=':M308000'
G[37013]=':M308000:R116676-1'
G[37018]=':M308000'
G[37019]=':M308000'
G[37020]=':M308000'
G[37021]=':M308000:R116662-1'
G[37024]=':M308000'
G[37025]=':M308000'
G[37026]=':M308000'
G[37027]=':M308000'
G[37028]=':M308000:R116784-1'
G[37122]=':M116000'
G[37140]=':M154000'
G[37321]=':R119191-1'
G[37325]=':R119191-1'
G[37433]=':M154000:C119462:C119461'
G[38175]=':M154000:C120301:C120302'
end

if release >= 21796 then
G[37466]=':X46450'
G[38374]=':X45650:M474000'
G[38413]=':X15200:M158000:C121515:C129325'
G[38414]=':X15200:M158000'
G[38614]=':X15200:M158000:C121567:C129318'
G[38615]=':X15200:M158000'
G[38616]=':X15200:M158000:C121522:C129321'
G[38617]=':X15200:M158000'
G[38618]=':X15200:M158000'
G[38624]=':X15200:M158000'
G[38778]=':X15350:M162000'
G[38808]=':X15350:M162000:C129336:C129353'
G[38810]=':X15350:M162000'
G[38811]=':X15350:M162000'
G[38815]=':X7650:M81000'
G[38816]=':X15350:M162000'
G[38817]=':X15350:M162000:C129231:C132759'
G[38818]=':X15350:M162000:R141391-1'
G[38823]=':X11500:M122000'
G[39652]=':X15200:M158000:R141399-1:C132806:C132817'
G[39786]=':X15350'
G[39787]=':X15350'
G[39788]=':X15350:M162000'
G[39789]=':X15350:M162000:C138127:C138129'
G[39791]=':X15350:M162000'
G[39792]=':X15350:M162000:C138125:C138133'
G[39793]=':X15350:M162000:C138131:C138123'
G[39796]=':X1550:M16200'
G[39803]=':X1550:M16200'
G[39804]=':X1550:M16200'
G[40568]=':X15200:M158000'
G[41803]=':X1550:M16200'
G[41804]=':X11500:M122000'
G[41806]=':X1550:M16200'
G[41807]=':X11500:M122000'
G[41863]=':X15350:M162000'
G[42444]=':X15350:M162000'
G[42445]=':X15350:M162000'
G[42446]=':X15350:M162000'
G[42447]=':X15350:M162000:C129363:C129247'
G[42666]=':X1550'
G[42670]=':X7650:M81000'
G[42679]=':X7650:M81000'
G[42681]=':X15350:M162000'
G[42682]=':X15500:M166000'
G[42683]=':X7650:M81000:R140517-1'
G[44009]=':X15350:M162000'
G[44161]=':X15350:M162000'
G[44379]=':X1550:M16200'
end

if release >= 21863 then
G[37447]=':X19350:M332000'
G[37496]=':X15750:M174000'
G[37779]=':X47300'
G[37965]=':X47300'
G[38203]=':X15750:M174000:C121493:C132967'
G[38324]=':X15500:M166000:C121563:C129332'
G[38339]=':X15500:M166000'
G[38347]=':X15600:M170000'
G[38407]=':X1550'
G[38873]=':X15600:M170000'
G[38878]=':X15600:M170000'
G[38882]=':X15600:M170000:R141392-1:C121572:C129343'
G[38939]=':X46850:M510000'
G[39153]=':X15600:M170000'
G[39154]=':X1550:M17000'
G[39155]=':X15600:M170000'
G[39385]=':X15600:M170000:C129228:C132764'
G[39405]=':X15600:M170000'
G[39718]=':X1600:M17400'
G[39786]=':X15500'
G[39848]=':X15600:M170000'
G[39849]=':X15600:M170000:C129239:C129339'
G[39850]=':X15600:M170000'
G[39851]=':X15600:M170000'
G[39853]=':X15600:M170000'
G[39855]=':X15600:M170000:R141401-1:C132827:C132832'
G[39857]=':X15600:M170000'
G[39998]=':X46850:M510000'
G[40001]=':X1550:M17000'
G[40002]=':X15600:M170000'
G[40003]=':X15600:M170000'
G[40004]=':X15600:M170000'
G[40005]=':X15600:M170000:C132847:C132852'
G[40072]=':X124950:M680000:R141402-1'
G[40078]=':X1550:M17000:R133813-1'
G[40111]=':X46450:M498000'
G[40120]=':X15500:M166000'
G[41220]=':X15750'
G[42238]=':X1600:M17400'
G[42372]=':M17400'
G[42375]=':X15750:M174000'
G[42483]=':X15600:M170000'
G[42635]=':X15500:M166000'
G[42639]=':X15500:M166000'
G[42640]=':X15500:M166000'
G[42641]=':X15500:M166000:C129329:C129359'
G[42645]=':X15500:M166000'
G[43483]=':X46450:M498000'
G[43705]=':X46450:M498000:C140608:C140604'
G[44004]=':X61900:M664000:C140615:C140613'
G[44153]=':X15500:M166000'
G[44400]=':X31500:M696000:C141358'
end

Grail.questRewards = G
Grail:_CleanDatabase()	-- this is called because Grail will do it before this loadable addon is loaded, which means its reputation data will be dirty
