--[=[
H.H.T.D. World of Warcraft Add-on
Copyright (c) 2009-2017 by John Wellesz (Archarodim@teaser.fr)
All rights reserved

Version 2.4.5

In World of Warcraft healers have to die. This is a cruel truth that you're
taught very early in the game. This add-on helps you influence this unfortunate
destiny in a way or another depending on the healer's side...

More information: https://www.wowace.com/projects/h-h-t-d

-----
    Localization.lua
-----


--]=]


--[=[
--                      YOUR ATTENTION PLEASE
--
--         !!!!!!! TRANSLATORS TRANSLATORS TRANSLATORS !!!!!!!
--
--    Thank you very much for your interest in translating H.H.T.D.
--    Do not edit this file. Use the localization interface available at the following address:
--
--      ##########################################################################
--      #     http://www.wowace.com/addons/h-h-t-d/localization/     #
--      ##########################################################################
--
--    Your translations made using this interface will be automatically included in the next release.
--
--]=]


do
    local L = LibStub("AceLocale-3.0"):NewLocale("H.H.T.D.", "enUS", true, true);

    if L then
L["ACTIVE"] = "Active!"
L["Announcer"] = "Announcer"
L["Announcer_DESC"] = "This module allows you to manage chat and sound alerts"
L["AUTO_RAID_PARTY_INSTANCE"] = "Auto: Raid Warning / Raid / Instance / Party"
L["CHAT_POST_ANNOUNCE_FEATURE_NOT_CONFIGURED"] = "The announce to raid messages are not configured. Type /HHTDG"
L["CHAT_POST_ANNOUNCE_TOO_SOON_WAIT"] = "It's too soon (see the announce throttle setting)."
L["CHAT_POST_NO_HEALERS"] = "No healers on either sides :/ (yet)"
L["CM"] = "Custom Marks"
L["CM_DESC"] = "Enable this module to set permanent custom marks on NPC and Player units' nameplates."
L["DESCRIPTION"] = "In World of Warcraft healers have to die. This is a cruel truth that you're taught very early in the game. This add-on helps you influence this unfortunate destiny in a way or another depending on the healer's side..."
L["DISABLED"] = [=[hhtd has been disabled!
Type '/hhtd on' to re-enable it.]=]
L["ENABLED"] = "enabled! Type /HHTDG to open its option panel"
L["HEALER_UNDER_ATTACK"] = "Healer friend %s is being attacked by %s"
L["HHTD_IS_NOW_KNOWN_AS_H.H.T.D."] = [=['%s' is now known as H.H.T.D. (see the change log for more information)

Your previous settings were successfully transferred and the old version turned off.

If you had previously disabled HHTD for some of your characters, you must login to each one once before deleting or disabling globally the old '%s' add-on so that this preference can also be kept.

This message will be displayed only once per character where HHTD's previous version was enabled.]=]
L["HUMAN"] = "Human"
L["IDLE"] = "Idle"
L["INSTANCE_CHAT"] = "Instance chat"
L["IS_A_HEALER"] = "%s is a healer!"
L["LOG_ACTIVE"] = "Active!"
L["LOG_BELOW_THRESHOLD"] = " (below threshold)"
L["LOG_IDLE"] = "Idle"
L["NO_DATA"] = "No data"
L["NPC"] = "NPC"
L["NPH"] = "Nameplate Hooker"
L["NPH_DESC"] = "This module adds a red cross to enemy healers' nameplates"
L["OPT_A_CHAT_WARNING"] = "Chat Warning"
L["OPT_A_CHAT_WARNING_DESC"] = "Display a chat warning when a friendly healer is under attack"
L["OPT_A_HEALER_PROTECTION"] = "Healer protection settings"
L["OPT_A_HUD_WARNING"] = "HUD Warning"
L["OPT_A_HUD_WARNING_DESC"] = "Display a heads-up warning when a friendly healer is under attack"
L["OPT_ANNOUNCE"] = "Show messages"
L["OPT_ANNOUNCE_DESC"] = "HHTD will display messages when you target or mouse-over an enemy healer."
L["OPT_CLEAR_LOGS"] = "Clear logs"
L["OPT_CM_CHANGEMARK"] = "Change to %s"
L["OPT_CM_CHANGEMARK_DESC"] = "Change the mark to the one selected in the '%s' selector"
L["OPT_CM_CLEARASSOC"] = "Clear"
L["OPT_CM_CLEARASSOC_DESC"] = "Clear the selected name from its mark"
L["OPT_CM_CLEARTARGETMARKER"] = "Clear target"
L["OPT_CM_CLEARTARGETMARKER_DESC"] = "Remove the marker from your target"
L["OPT_CM_DESCRIPTION"] = "Here you can target a unit and apply a custom mark only you will see, these marks will persist accross sessions."
L["OPT_CM_EXISTINGASSOC"] = "Existing name-marker associations"
L["OPT_CM_EXISTINGASSOC_DESC"] = "Select a name in this list to use with the other buttons of this section"
L["OPT_CM_FNPC_NAMEPLATE"] = "Friendly NPC nameplates"
L["OPT_CM_FNPC_NAMEPLATE_DESC"] = [=[Show nameplates on friendly NPCs
This is necessary for markers to be shown on these units.]=]
L["OPT_CM_MARKER_CUSTOMIZATION"] = "Marker customization"
L["OPT_CM_MARKER_MANAGEMENT"] = "Marker management"
L["OPT_CM_SELECT_MARKER"] = "Marker"
L["OPT_CM_SELECT_MARKER_DESC"] = "Select a marker to apply to your target"
L["OPT_CM_SETTARGETMARKER"] = "Mark target"
L["OPT_CM_SETTARGETMARKER_DESC"] = "Mark the selected target with the selected marker"
L["OPT_CM_VCa"] = "Alpha Shading"
L["OPT_CM_VCa_DESC"] = "Change texture's Alpha component shading"
L["OPT_CM_VCb"] = "Blue Shading"
L["OPT_CM_VCb_DESC"] = "Change texture's Blue component shading"
L["OPT_CM_VCg"] = "Green Shading"
L["OPT_CM_VCg_DESC"] = "Change texture's Green component shading"
L["OPT_CM_VCr"] = "Red Shading"
L["OPT_CM_VCr_DESC"] = "Change texture's red component shading"
L["OPT_CORE_OPTIONS"] = "Core options"
L["OPT_DEBUG"] = "debugging logs"
L["OPT_DEBUG_DESC"] = "Enables / disables debugging"
L["OPT_DEBUGLEVEL"] = "debugging level"
L["OPT_DEBUGLEVEL_DESC"] = "debug level: 1=all, 2=warnings, 3=errors"
L["OPT_ENABLE_GEHR"] = "Enable Graphical Reporter"
L["OPT_ENABLE_GEHR_DESC"] = "Displays a graphical list of detected enemy healers with various features"
L["OPT_GUI"] = "Open GUI"
L["OPT_GUI_DESC"] = "Open the graphical configuration panel"
L["OPT_HEADER_GLOBAL_ENEMY_HEALER_OPTIONS"] = "Global enemy healers settings"
L["OPT_HEADER_GLOBAL_FRIENDLY_HEALER_OPTIONS"] = "Global friendly healers settings"
L["OPT_HEALER_FORGET_TIMER"] = "Healer Forget Timer"
L["OPT_HEALER_FORGET_TIMER_DESC"] = "Set the Healer Forget Timer (the time in seconds an enemy will remain considered has a healer)"
L["OPT_HEALER_MINIMUM_HEAL_AMOUNT"] = "Heal amount (|cff00dd00%u|r) threshold"
L["OPT_HEALER_MINIMUM_HEAL_AMOUNT_DESC"] = "Healers won't be detected until they reach this cumulative amount of healing based on a percentage of your own maximum health."
L["OPT_HEALER_UNDER_ATTACK_ALERTS"] = "Protect friendly healers"
L["OPT_HEALER_UNDER_ATTACK_ALERTS_DESC"] = "Display an alert when a nearby friendly healers is attacked for more than |cffdd0000%u|r damage"
L["OPT_LOG"] = "Logging"
L["OPT_LOG_DESC"] = "Enables logging and adds a new 'Logs' tab to HHTD's option panel"
L["OPT_LOGS"] = "Logs"
L["OPT_LOGS_DESC"] = "Display HHTD detected healers and statistics"
L["OPT_MODULES"] = "Modules"
L["OPT_NPH_ENEMY_NAMEPLATE"] = "Enemy nameplates"
L["OPT_NPH_FRIENDLY_NAMEPLATE"] = "Friendly nameplates"
L["OPT_NPH_MARKER_HIDDEN_WOW_SETTINGS"] = "Hidden WoW settings"
L["OPT_NPH_MARKER_SCALE"] = "Markers' scaling"
L["OPT_NPH_MARKER_SCALE_DESC"] = "Multiply markers' size by # i.e. 1 = normal size, 0.5 = half size, 2 = double size, etc..."
L["OPT_NPH_MARKER_SETTINGS"] = "Markers' settings"
L["OPT_NPH_MARKER_THEME"] = "Markers' theme"
L["OPT_NPH_MARKER_THEME_DEFAULT"] = "Default"
L["OPT_NPH_MARKER_THEME_DESC"] = "Select between the available markers' themes"
L["OPT_NPH_MARKER_THEME_MINIMAL"] = "Minimalist"
L["OPT_NPH_MARKER_WOW_SETTINGS"] = "WoW settings"
L["OPT_NPH_MARKER_X_OFFSET"] = "Horizontal offset"
L["OPT_NPH_MARKER_X_OFFSET_DESC"] = "Move markers horizontally"
L["OPT_NPH_MARKER_Y_OFFSET"] = "Vertical offset"
L["OPT_NPH_MARKER_Y_OFFSET_DESC"] = "Move markers vertically"
L["OPT_NPH_WARNING1"] = [=[WARNING: *Enemies*' nameplates are currently disabled. HHTD cannot add its symbol on enemies.
        You can enable nameplates display through the WoW UI's options or by using the assigned key-stroke.]=]
L["OPT_NPH_WARNING2"] = [=[WARNING: *Allies*' nameplates are currently disabled. HHTD cannot add its symbol on allies.
        You can enable nameplates display through the WoW UI's options or by using the assigned key-stroke.]=]
L["OPT_OFF"] = "off"
L["OPT_OFF_DESC"] = "Disables HHTD"
L["OPT_ON"] = "on"
L["OPT_ON_DESC"] = "Enables HHTD"
L["OPT_POST_ANNOUNCE_CHANNEL"] = "Post channel"
L["OPT_POST_ANNOUNCE_CHANNEL_DESC"] = [=[Decide where your announce will be posted.
Note: unless you want to use 'say' or 'yell' you should leave this to automatic.]=]
L["OPT_POST_ANNOUNCE_DESCRIPTION"] = [=[|cFFFF0000IMPORTANT:|r Type |cff40ff40/hhtdp|r or bind a key to announce friendly healers to protect and enemy healers to focus.

(see World of Warcraft escape menu binding interface to bind a key)
]=]
L["OPT_POST_ANNOUNCE_ENABLE"] = "Chat announces"
L["OPT_POST_ANNOUNCE_ENABLE_DESC"] = "Enable announce to raid features."
L["OPT_POST_ANNOUNCE_HUMAMNS_ONLY"] = "Humans only"
L["OPT_POST_ANNOUNCE_HUMAMNS_ONLY_DESC"] = "Do not include NPCs in the announce."
L["OPT_POST_ANNOUNCE_KILL_MESSAGE"] = "Text for enemy healers"
L["OPT_POST_ANNOUNCE_KILL_MESSAGE_DESC"] = [=[Type a message inciting your team to focus enemy healers.

You must use the [HEALERS] keyword somewhere which will be automatically replaced by the names of the currently active healers.]=]
L["OPT_POST_ANNOUNCE_MESSAGE_TOO_SHORT"] = "Your message is too short!"
L["OPT_POST_ANNOUNCE_MESSAGES_EQUAL"] = "There is one message for friends and one for foes, they cannot be the same."
L["OPT_POST_ANNOUNCE_MISSING_KEYWORD"] = "The [HEALERS] keyword is missing!"
L["OPT_POST_ANNOUNCE_NUMBER"] = "Healers number"
L["OPT_POST_ANNOUNCE_NUMBER_DESC"] = "Set how many healers to include in each announce."
L["OPT_POST_ANNOUNCE_POST_MESSAGE_ISSUE"] = "There is something wrong with one of the announce text."
L["OPT_POST_ANNOUNCE_PROTECT_MESSAGE"] = "Text for friendly healers"
L["OPT_POST_ANNOUNCE_PROTECT_MESSAGE_DESC"] = [=[Type a message inciting your team to protect their healers.

You must use the [HEALERS] keyword somewhere which will be automatically replaced by the names of the currently active healers.]=]
L["OPT_POST_ANNOUNCE_SETTINGS"] = "Announce to raid settings"
L["OPT_POST_ANNOUNCE_THROTTLE"] = "Announce throttle"
L["OPT_POST_ANNOUNCE_THROTTLE_DESC"] = "Set the minimum time in seconds between each possible announce."
L["OPT_PROTECT_HEALER_MINIMUM_DAMAGE_AMOUNT"] = "Damage amount (|cffdd0000%u|r) threshold"
L["OPT_PROTECT_HEALER_MINIMUM_DAMAGE_AMOUNT_DESC"] = "Friendly attacked healers won't be detected until they reach this cumulative amount of damage based on a percentage of your own maximum health."
L["OPT_PVE"] = "Enable for PVE"
L["OPT_PVE_DESC"] = "HHTD will also work for NPCs."
L["OPT_PVPHEALERSSPECSONLY"] = "Specialized players only"
L["OPT_PVPHEALERSSPECSONLY_DESC"] = "Only detect players specialized in healing."
L["OPT_SET_FRIENDLY_HEALERS_ROLE"] = "Set friendly healers role"
L["OPT_SET_FRIENDLY_HEALERS_ROLE_DESC"] = "Will automatically set the raid HEALER role to friendly healers upon detection (if possible)"
L["OPT_SOUNDS"] = "Sound alerts"
L["OPT_SOUNDS_DESC"] = "HHTD will play a specific sound when you hover or target an enemy healer"
L["OPT_STRICTGUIDPVE"] = "Accurate PVE detection"
L["OPT_STRICTGUIDPVE_DESC"] = "When several NPCs share the same name, HHTD will only add a cross over those who actually healed instead of adding a cross to all of them."
L["OPT_SWAPSYMBOLS"] = "Swap friends/foes symbols"
L["OPT_SWAPSYMBOLS_DESC"] = "The symbols used for friends and foes are swapped"
L["OPT_TESTONTARGET"] = "Test HHTD's behavior on current target"
L["OPT_TESTONTARGET_DESC"] = "Will mark your current target as a healer so you can test what happens."
L["OPT_TESTONTARGET_ENOTARGET"] = "You need to target something"
L["OPT_USE_HEALER_MINIMUM_HEAL_AMOUNT"] = "Use minimum heal amount filter"
L["OPT_USE_HEALER_MINIMUM_HEAL_AMOUNT_DESC"] = "Healers will have to heal for a specified amount before being tagged as such."
L["OPT_VERSION"] = "version"
L["OPT_VERSION_DESC"] = "Display version and release date"
L["PARTY"] = "Party"
L["RELEASE_DATE"] = "Release Date:"
L["SAY"] = "Say"
L["VERSION"] = "version:"
L["YELL"] = "Yell"
L["YOU_GOT_HER"] = "You got %sher|r!"
L["YOU_GOT_HIM"] = "You got %shim|r!"
L["YOU_GOT_IT"] = "You got %sit|r!"


    end

end

do
    local L = LibStub("AceLocale-3.0"):NewLocale("H.H.T.D.", "frFR");

    if L then
L["ACTIVE"] = "Actif !"
L["Announcer"] = "Annonceur"
L["Announcer_DESC"] = "Ce module permet de gérer différents type d'alertes."
L["AUTO_RAID_PARTY_INSTANCE"] = "Automatique: Alerte de Raid / Raid / Instance / Groupe"
L["CHAT_POST_ANNOUNCE_FEATURE_NOT_CONFIGURED"] = "Les messages d'annonce au raid ne sont pas configurés. Tapez /HHTDG"
L["CHAT_POST_ANNOUNCE_TOO_SOON_WAIT"] = "C'est trop tôt (voir le réglage du limiteur d'annonce)"
L["CHAT_POST_NO_HEALERS"] = "Aucun soigneur d'un coté ou de l'autre :/ (pour l'instant)"
L["CM"] = "Marques personelles"
L["CM_DESC"] = "Activez ce module pour mettre des marqueurs permanents sur les plaques des unités (Joueur et PNJ)"
L["DESCRIPTION"] = "Dans World of Warcraft les soigneurs doivent mourir. C'est une vérité cruelle que vous apprenez très tôt dans le jeu. Cet add-on vous aide à influencer ce funeste destin d'une manière ou une autre en fonction du camp du soigneur..."
L["DISABLED"] = [=[hhtd a été désactivé !
Taper '/hhtd on' pour le réactiver]=]
L["ENABLED"] = "activé ! Taper /HHTDG pour accéder aux options"
L["HEALER_UNDER_ATTACK"] = "Le soigneur ami %s est attaqué par %s"
L["HHTD_IS_NOW_KNOWN_AS_H.H.T.D."] = [=["%s" est maintenant connu sous le nom de H.H.T.D. (Voir le journal des modifications pour plus d'informations)

Vos paramètres précédents ont été transférés avec succès et l'ancienne version a été fermée.

Si vous avez préalablement désactivé HHTD pour certains de vos personnages, vous devez vous connecter à chacun d'eux une fois avant de supprimer ou de désactiver globalement l'ancien "%s" afin que cette préférence puisse également être conservée.

Ce message ne sera affiché qu'une seule fois par personnage où la version précédente de HHTD était activée.]=]
L["HUMAN"] = "Humain"
L["IDLE"] = "Dormant"
L["INSTANCE_CHAT"] = "Canal des instances"
L["IS_A_HEALER"] = "%s est un soigneur !"
L["LOG_ACTIVE"] = "Actif !"
L["LOG_BELOW_THRESHOLD"] = "(sous le seuil)"
L["LOG_IDLE"] = "Inactif"
L["NO_DATA"] = "Aucune donnée"
L["NPC"] = "PNJ"
L["NPH"] = "Barres d'info"
L["NPH_DESC"] = "Ce module ajoute une croix rouge au dessus des barres d'info des soigneurs ennemis."
L["OPT_A_CHAT_WARNING"] = "Alerte messagerie"
L["OPT_A_CHAT_WARNING_DESC"] = "Affiche une alerte dans la messagerie lorsqu'un soigneur amicale est attaqué"
L["OPT_A_HEALER_PROTECTION"] = "Protection des soigneurs"
L["OPT_A_HUD_WARNING"] = "Alerte tête haute"
L["OPT_A_HUD_WARNING_DESC"] = "Affiche une alerte de type raid lorsqu'un soigneur amical est attaqué"
L["OPT_ANNOUNCE"] = "Afficher les messages."
L["OPT_ANNOUNCE_DESC"] = "HHTD affiche des messages lorsque vous ciblez ou survolez des soigneurs ennemis avec la souris."
L["OPT_CLEAR_LOGS"] = "Effacer les journaux"
L["OPT_CM_CHANGEMARK"] = "Remplacer par %s"
L["OPT_CM_CHANGEMARK_DESC"] = "Remplace la marque par celle choisie dans le menu '%s'"
L["OPT_CM_CLEARASSOC"] = "Effacer"
L["OPT_CM_CLEARASSOC_DESC"] = "Efface la marque du nom sélectionné"
L["OPT_CM_CLEARTARGETMARKER"] = "Démarquer la cible"
L["OPT_CM_CLEARTARGETMARKER_DESC"] = "Enlève la marque de la cible"
L["OPT_CM_DESCRIPTION"] = "Ici vous pouvez cibler une unité et y appliquer une marque personnelle uniquement visible par vous-même. Ces marques persisteront entre les sessions de jeux."
L["OPT_CM_EXISTINGASSOC"] = "Associations nom / marque existantes"
L["OPT_CM_EXISTINGASSOC_DESC"] = "Sélectionner un nom à utiliser avec les autres boutons de cette section"
L["OPT_CM_FNPC_NAMEPLATE"] = "Barre d'info PNJ amicaux"
L["OPT_CM_FNPC_NAMEPLATE_DESC"] = [=[Affiche les Barre d'info des PNJ amicaux
Cela est nécessaire pour que les marqueurs soient affichés sur ces unités]=]
L["OPT_CM_MARKER_CUSTOMIZATION"] = "Personalisation des marques"
L["OPT_CM_MARKER_MANAGEMENT"] = "Gestion des marques"
L["OPT_CM_SELECT_MARKER"] = "Marque"
L["OPT_CM_SELECT_MARKER_DESC"] = "Sélectionner une marque à appliquer sur votre cible"
L["OPT_CM_SETTARGETMARKER"] = "Marquer la cible"
L["OPT_CM_SETTARGETMARKER_DESC"] = "Marque la cible avec la marque séléctionée"
L["OPT_CM_VCa"] = "Alpha"
L["OPT_CM_VCa_DESC"] = "Change la composante alpha de la texure"
L["OPT_CM_VCb"] = "Teinte bleu"
L["OPT_CM_VCb_DESC"] = "Change la composante bleue de la texure"
L["OPT_CM_VCg"] = "Teinte verte"
L["OPT_CM_VCg_DESC"] = "Change la composante verte de la texure"
L["OPT_CM_VCr"] = "Teinte rouge"
L["OPT_CM_VCr_DESC"] = "Change la composante rouge de la texure"
L["OPT_CORE_OPTIONS"] = "Options Générales"
L["OPT_DEBUG"] = "débuggage"
L["OPT_DEBUG_DESC"] = "Active / désactive le débuggage"
L["OPT_DEBUGLEVEL"] = "debugging level"
L["OPT_DEBUGLEVEL_DESC"] = "debug level: 1=all, 2=warnings, 3=errors"
L["OPT_ENABLE_GEHR"] = "Activer le rapporteur graphique"
L["OPT_ENABLE_GEHR_DESC"] = "Affiche une interface listant les soigneurs ennemis."
L["OPT_GUI"] = "Ouvrir l'interface"
L["OPT_GUI_DESC"] = "Ouvre l'interface graphique de configuration"
L["OPT_HEADER_GLOBAL_ENEMY_HEALER_OPTIONS"] = "Réglages globaux des soigneurs ennemis"
L["OPT_HEADER_GLOBAL_FRIENDLY_HEALER_OPTIONS"] = "Réglages globaux des soigneurs alliés"
L["OPT_HEALER_FORGET_TIMER"] = "Délai d'oubli des soigneurs"
L["OPT_HEALER_FORGET_TIMER_DESC"] = "Règle le délai d'oubli des soigneurs (le temps en secondes où un ennemi sera considéré comme soigneur)"
L["OPT_HEALER_MINIMUM_HEAL_AMOUNT"] = "Seuil de soins (|cff00dd00%u|r)"
L["OPT_HEALER_MINIMUM_HEAL_AMOUNT_DESC"] = "Les soigneurs ne seront détectés qu'à partir de ce seuil de soin basé sur un pourcentage de vos points de vie maximales."
L["OPT_HEALER_UNDER_ATTACK_ALERTS"] = "Protéger les soigneurs amicaux"
L["OPT_HEALER_UNDER_ATTACK_ALERTS_DESC"] = "Affiche une alerte lorsqu'un soigneur amical proche est attaqué pour plus de |cffdd0000%u|r de dégats"
L["OPT_LOG"] = "Journalisation"
L["OPT_LOG_DESC"] = "Active la journalisation et ajoute un onglet 'Journaux' aux panneau des options de HHTD"
L["OPT_LOGS"] = "Journaux"
L["OPT_LOGS_DESC"] = "Affiche les soigneurs détectés par HHTD et des statistiques."
L["OPT_MODULES"] = "Modules"
L["OPT_NPH_ENEMY_NAMEPLATE"] = "Barre d'info énemies"
L["OPT_NPH_FRIENDLY_NAMEPLATE"] = "Barres d'info amicale"
L["OPT_NPH_MARKER_HIDDEN_WOW_SETTINGS"] = "Réglages WoW cachés"
L["OPT_NPH_MARKER_SCALE"] = "Échelle des marqueurs"
L["OPT_NPH_MARKER_SCALE_DESC"] = "Change la taille des marqueurs en y appliquant un multiplicateur"
L["OPT_NPH_MARKER_SETTINGS"] = "Réglages des marqueurs"
L["OPT_NPH_MARKER_THEME"] = "Thème des marqueurs"
L["OPT_NPH_MARKER_THEME_DEFAULT"] = "Standard"
L["OPT_NPH_MARKER_THEME_DESC"] = "Choisissez parmi les thèmes de marqueurs disponibles"
L["OPT_NPH_MARKER_THEME_MINIMAL"] = "Minimaliste"
L["OPT_NPH_MARKER_WOW_SETTINGS"] = "Réglages WoW"
L["OPT_NPH_MARKER_X_OFFSET"] = "Offset horizontale"
L["OPT_NPH_MARKER_X_OFFSET_DESC"] = "Déplacer les marqueurs horizontalement"
L["OPT_NPH_MARKER_Y_OFFSET"] = "Offset verticale"
L["OPT_NPH_MARKER_Y_OFFSET_DESC"] = "Déplacer les marqueurs verticalement"
L["OPT_NPH_WARNING1"] = [=[ATTENTION : Les barres d'infos des unités ennemies sont désactivées. HHTD ne peut pas ajouter sa croix rouge.
Vous pouvez activer les barres d'infos dans les options d'interface de WoW ou en utilisant le raccourcis.]=]
L["OPT_NPH_WARNING2"] = [=[ATTENTION : Les barres d'infos des unités alliées sont désactivées. HHTD ne peut pas ajouter son symbole de soigneur.
Vous pouvez activer les barres d'infos dans les options d'interface de WoW ou en utilisant le raccourcis.]=]
L["OPT_OFF"] = "désactivé"
L["OPT_OFF_DESC"] = "Désactive HHTD"
L["OPT_ON"] = "activé"
L["OPT_ON_DESC"] = "Active HHTD"
L["OPT_POST_ANNOUNCE_CHANNEL"] = "Canal d'annonce"
L["OPT_POST_ANNOUNCE_CHANNEL_DESC"] = [=[Décider où votre annonce sera postée
Note: à moins que vous ne souhaitiez utiliser les canaux 'say' ou 'yell' spécifiquement, laissez cette option en automatique.]=]
L["OPT_POST_ANNOUNCE_DESCRIPTION"] = [=[|cFFFF0000IMPORTANT:|r Tapez |cff40ff40/hhtdp|r ou utilisez un raccourci clavier pour annoncer les soigneurs amis à protéger et les soigneurs ennemis à focaliser.

(voir l'interface des raccourcis de World of Warcraft pour lier une touche à cette fonction)
]=]
L["OPT_POST_ANNOUNCE_ENABLE"] = "Annonces"
L["OPT_POST_ANNOUNCE_ENABLE_DESC"] = "Activer les fonctionnalités d'annonce au raid."
L["OPT_POST_ANNOUNCE_HUMAMNS_ONLY"] = "Humains seulement"
L["OPT_POST_ANNOUNCE_HUMAMNS_ONLY_DESC"] = "Ne pas inclure les PNJs dans l'annonce."
L["OPT_POST_ANNOUNCE_KILL_MESSAGE"] = "Texte pour les soigneurs ennemis"
L["OPT_POST_ANNOUNCE_KILL_MESSAGE_DESC"] = [=[Tapez un message incitant votre équipe à se focaliser sur les soigneurs ennemis.

Vous devez placer le mot clé [HEALERS] quelque part, il sera automatiquement remplacé par les noms des soigneurs actuellement actifs.]=]
L["OPT_POST_ANNOUNCE_MESSAGE_TOO_SHORT"] = "Votre message est trop court !"
L["OPT_POST_ANNOUNCE_MESSAGES_EQUAL"] = "Il y a un message pour les amis et un autre pour les ennemis, ils ne peuvent pas être identiques."
L["OPT_POST_ANNOUNCE_MISSING_KEYWORD"] = "Il manque le mot clé [HEALERS] !"
L["OPT_POST_ANNOUNCE_NUMBER"] = "Nombre de soigneurs."
L["OPT_POST_ANNOUNCE_NUMBER_DESC"] = "Régler le nombre de soigneurs à inclure dans chacune des annonces."
L["OPT_POST_ANNOUNCE_POST_MESSAGE_ISSUE"] = "Quelque chose ne va pas avec l'un de vos messages d'annonce."
L["OPT_POST_ANNOUNCE_PROTECT_MESSAGE"] = "Texte pour les soigneurs amis."
L["OPT_POST_ANNOUNCE_PROTECT_MESSAGE_DESC"] = [=[Tapez un message incitant votre équipe à protéger ses soigneurs.

Vous devez placer le mot clé [HEALERS] quelque part, il sera automatiquement remplacé par les noms des soigneurs actuellement actifs.]=]
L["OPT_POST_ANNOUNCE_SETTINGS"] = "Réglages des annonces au raid."
L["OPT_POST_ANNOUNCE_THROTTLE"] = "Limiteur d'annonce"
L["OPT_POST_ANNOUNCE_THROTTLE_DESC"] = "Régler le temps minimum (en secondes) entre deux annonces."
L["OPT_PROTECT_HEALER_MINIMUM_DAMAGE_AMOUNT"] = "Seuil (|cffdd0000%u|r) de dégâts "
L["OPT_PROTECT_HEALER_MINIMUM_DAMAGE_AMOUNT_DESC"] = "Les soigneurs alliés attaquées ne seront détectés qu'une fois ce seuil de dégâts, basé sur un pourcentage de votre propre vie maximale, sera atteint."
L["OPT_PVE"] = "Activer en PVE"
L["OPT_PVE_DESC"] = "HHTD fonctionnera également avec les personnages non joueurs (PNJs)"
L["OPT_PVPHEALERSSPECSONLY"] = "Joueurs spécialisés seulement"
L["OPT_PVPHEALERSSPECSONLY_DESC"] = "Ne détectera que les joueurs spécialisés en soins."
L["OPT_SET_FRIENDLY_HEALERS_ROLE"] = "Assignation des rôles"
L["OPT_SET_FRIENDLY_HEALERS_ROLE_DESC"] = "Affectera automatiquement le rôle de soigneur aux joueurs détectés (si possible)"
L["OPT_SOUNDS"] = "Alertes sonores"
L["OPT_SOUNDS_DESC"] = "HHTD joue un son spécifique lorsque votre souris se trouve au dessus d'un soigneur ennemi ou lorsque vous en ciblez un."
L["OPT_STRICTGUIDPVE"] = "Détection PVE précise"
L["OPT_STRICTGUIDPVE_DESC"] = "Quand plusieurs PNJ partagent le même nom, HHTD n'ajoutera une croix qu'à ceux qui ont réellement soigné au lieu d'en ajouter une à tous."
L["OPT_SWAPSYMBOLS"] = "Échanger les symboles amis / ennemis"
L["OPT_SWAPSYMBOLS_DESC"] = "Les symboles utilisés pour les amis et les ennemis sont échangés."
L["OPT_TESTONTARGET"] = "Tester le comportement de HHTD sur la cible"
L["OPT_TESTONTARGET_DESC"] = "Marque la cible actuelle comme soigneur de façon à tester ce qui ce passe."
L["OPT_TESTONTARGET_ENOTARGET"] = "Vous devez cibler quelque chose."
L["OPT_USE_HEALER_MINIMUM_HEAL_AMOUNT"] = "Filtrage sur soins cumulés"
L["OPT_USE_HEALER_MINIMUM_HEAL_AMOUNT_DESC"] = "Les soigneurs devront cumuler un certain minimum de soins avant d'être considérés comme tel."
L["OPT_VERSION"] = "version"
L["OPT_VERSION_DESC"] = "Affiche la version et la date de sortie"
L["PARTY"] = "Groupe"
L["RELEASE_DATE"] = "Date de sortie :"
L["SAY"] = "Dire"
L["VERSION"] = "Version :"
L["YELL"] = "Crier"
L["YOU_GOT_HER"] = "Vous %sla|r tenez !"
L["YOU_GOT_HIM"] = "Vous %sle|r tenez !"
L["YOU_GOT_IT"] = "Vous %sle|r tenez !"
    end
end

do
    local L = LibStub("AceLocale-3.0"):NewLocale("H.H.T.D.", "deDE");

    if L then
L["ACTIVE"] = "Aktiv!"
L["Announcer"] = "Melder"
L["Announcer_DESC"] = "Dieses Modul erlaubt dir Chat-Warnungen und Alarmtöne einzustellen"
L["AUTO_RAID_PARTY_INSTANCE"] = "Auto: Schlachtzugswarnung / Schlachtzug / Instanz / Gruppe"
L["CHAT_POST_ANNOUNCE_FEATURE_NOT_CONFIGURED"] = "Die Texte für die Schlachtzugsmeldungen sind nicht konfiguriert. Tippe /hhtdg"
L["CHAT_POST_ANNOUNCE_TOO_SOON_WAIT"] = "Das ist zu früh (siehe Option Meldungsverzögerung)."
L["CHAT_POST_NO_HEALERS"] = "Keine Heiler auf beiden Seiten :/ (noch)"
L["CM"] = "Benutzerdefinierte Markierungen"
L["CM_DESC"] = "Aktiviere dieses Modul, um dauerhafte benutzerdefinierte Markierungen auf Namensplaketten von Nicht-Spieler-Charakteren (NSCs) und Spielern zu setzen."
L["DESCRIPTION"] = "In World of Warcraft müssen Heiler sterben. Dies ist eine grausame Wahrheit, die ihnen sehr früh im Spiel gelehrt wird. Dieses Addon hilft ihnen, dieses bedauerliche Schicksal der Heiler auf dem einen oder anderen Weg, in Abhängigkeit davon auf welcher Seite der Heiler steht, zu beeinflussen"
L["DISABLED"] = [=[hhtd wurde deaktiviert!
Gib /hhtd ein, um es wieder zu aktivieren.]=]
L["ENABLED"] = "aktiviert! Gib /HHTDG ein, um eine Optionsliste zu erhalten."
L["HEALER_UNDER_ATTACK"] = "Heiler %s wird von %s angegriffen"
L["HHTD_IS_NOW_KNOWN_AS_H.H.T.D."] = [=['%s' heißt nun H.H.T.D (siehe Änderungsprotokoll für mehr Informationen)

Deine bisherigen Einstellungen wurde erfolgreich übernommen und die alte Version auf diesem Charakter deaktiviert.

Falls du HHTD bisher bei ein paar deiner Charaktere deaktiviert hattest, solltest du dich bei jedem Charakter einloggen, bevor du das alte Addon %s komplett löschst oder deaktivierst. Dies sorgt dafür, dass deine Einstellungen in das neue Addon übernommen werden.

Diese Nachricht wird nur einmal pro Charakter, bei dem die vorherige Version von HHTD aktiviert war, angezeigt.]=]
L["HUMAN"] = "Spieler"
L["IDLE"] = "Untätig"
L["INSTANCE_CHAT"] = "Instanzchat"
L["IS_A_HEALER"] = "%s ist ein Heiler!"
L["LOG_ACTIVE"] = "Aktiv!"
L["LOG_BELOW_THRESHOLD"] = " (unter Schwellwert)"
L["LOG_IDLE"] = "inaktiv"
L["NO_DATA"] = "Keine Daten"
L["NPC"] = "NSC"
L["NPH"] = "Namensplakettenanker"
L["NPH_DESC"] = "Dieses Modul fügt Namensplaketten feindlicher Heiler ein rotes Kreuz hinzu"
L["OPT_A_CHAT_WARNING"] = "Chatwarnung"
L["OPT_A_CHAT_WARNING_DESC"] = "Zeigt eine Chatwarnung an, wenn ein befreundeter Heiler angegriffen wird"
L["OPT_A_HEALER_PROTECTION"] = "Einstellungen Heilerschutz"
L["OPT_A_HUD_WARNING"] = "HUD-Warnung"
L["OPT_A_HUD_WARNING_DESC"] = "Zeigt eine Warnung in deinem Blickfeld an, sobald ein verbündeter Heiler angegriffen wird."
L["OPT_ANNOUNCE"] = "Mitteilungen anzeigen"
L["OPT_ANNOUNCE_DESC"] = "HHTD wird Mitteilungen anzeigen, wenn du auf einen feindlichen Heiler zielst oder die Maus über ihn bewegst."
L["OPT_CLEAR_LOGS"] = "Protokolle löschen"
L["OPT_CM_CHANGEMARK"] = "Auf %s ändern"
L["OPT_CM_CHANGEMARK_DESC"] = "Ändert die Markierung auf die, die in der Auswahl '%s' gewählt wurde."
L["OPT_CM_CLEARASSOC"] = "Löschen"
L["OPT_CM_CLEARASSOC_DESC"] = "Löscht die gewählte Verknüpfung von Ziel und Markierung"
L["OPT_CM_CLEARTARGETMARKER"] = "Ziel säubern"
L["OPT_CM_CLEARTARGETMARKER_DESC"] = "Entfernt die Markierung deines Ziels"
L["OPT_CM_DESCRIPTION"] = "Hier kannst du eine Einheit anvisieren ihr eine benutzerdefinierte Markierung hinzufügen, die nur du sehen kannst. Diese Markierungen existieren sitzungsübergreifend."
L["OPT_CM_EXISTINGASSOC"] = "Vorhandene Namen-Markierung-Verknüpfungen"
L["OPT_CM_EXISTINGASSOC_DESC"] = "Wähle einen Namen in dieser Liste, um auf ihn andere Schaltflächen dieses Bereichs anzuwenden."
L["OPT_CM_FNPC_NAMEPLATE"] = "Namensplaketten befreundeter NSCs"
L["OPT_CM_FNPC_NAMEPLATE_DESC"] = [=[Zeigt Namensplaketten auf befreundeten NSCs
Dies wird benötigt, um Markierungen auf diesen Einheiten anzuzeigen.]=]
L["OPT_CM_MARKER_CUSTOMIZATION"] = "Markierungsanpassung"
L["OPT_CM_MARKER_MANAGEMENT"] = "Markierungsverwaltung"
L["OPT_CM_SELECT_MARKER"] = "Markierung"
L["OPT_CM_SELECT_MARKER_DESC"] = "Wähle ein Symbol, das für dein Ziel verwendet wird"
L["OPT_CM_SETTARGETMARKER"] = "Ziel markieren"
L["OPT_CM_SETTARGETMARKER_DESC"] = "Markiert das gewählte Ziel mit der ausgewählten Markierung"
L["OPT_CM_VCa"] = "Deckkraft"
L["OPT_CM_VCa_DESC"] = "Ändert die Transparenz der Textur (0 = komplett durchsichtig, 1 = undurchsichtig)"
L["OPT_CM_VCb"] = "Blaue Komponente"
L["OPT_CM_VCb_DESC"] = "Ändert die Intensität der blauen Komponente der Textur"
L["OPT_CM_VCg"] = "Grüne Komponente"
L["OPT_CM_VCg_DESC"] = "Ändert die Intensität der grünen Komponente der Textur"
L["OPT_CM_VCr"] = "Rote Komponente"
L["OPT_CM_VCr_DESC"] = "Ändert die Intensität der roten Komponente der Textur"
L["OPT_CORE_OPTIONS"] = "Hauptoptionen"
L["OPT_DEBUG"] = "Fehler suchen"
L["OPT_DEBUG_DESC"] = "Aktiviert/Deaktiviert die Fehlersuche"
L["OPT_DEBUGLEVEL"] = "Debug-Stufe"
L["OPT_DEBUGLEVEL_DESC"] = "Debug-Stufe: 1=Alle, 2=Warnungen, 3=Fehler"
L["OPT_ENABLE_GEHR"] = "Graphischen Bericht aktivieren"
L["OPT_ENABLE_GEHR_DESC"] = "Zeigt eine graphische Liste der entdeckten feindlichen Heiler mit verschiedenen Eigenschaften an."
L["OPT_GUI"] = "Öffnet die grafischen Einstellungen"
L["OPT_GUI_DESC"] = "Öffnet das grafische Konfigurationsmenü"
L["OPT_HEADER_GLOBAL_ENEMY_HEALER_OPTIONS"] = "Allgemeine Einstellungen für feindliche Heiler"
L["OPT_HEADER_GLOBAL_FRIENDLY_HEALER_OPTIONS"] = "Allgemeine Einstellungen für befreundete Heiler"
L["OPT_HEALER_FORGET_TIMER"] = "Heiler-vergessen-Zeitmesser"
L["OPT_HEALER_FORGET_TIMER_DESC"] = "Den Heiler-vergessen-Zeitmesser einstellen (die Anzahl in Sekunden, für deren Dauer ein Feind als Heiler betrachtet wird)"
L["OPT_HEALER_MINIMUM_HEAL_AMOUNT"] = "Heilungsschwellenwert (|cff00dd00%u|r)"
L["OPT_HEALER_MINIMUM_HEAL_AMOUNT_DESC"] = "Heiler werden nicht erkannt, bis sie diese Heilungsmenge, die auf deiner eigenen maximalen Gesundheit basiert, erreicht haben."
L["OPT_HEALER_UNDER_ATTACK_ALERTS"] = "Befreundete Heiler schützen"
L["OPT_HEALER_UNDER_ATTACK_ALERTS_DESC"] = "Zeigt eine Warnung an, wenn ein befreundeter Heiler in der Nähe mit mehr als |cffdd0000%u|r Schaden angegriffen wird."
L["OPT_LOG"] = "Protokollieren"
L["OPT_LOG_DESC"] = "Aktiviert die Protokollierung und fügt den Tab 'Protokolle' zum Optionsfenster hinzu."
L["OPT_LOGS"] = "Protokolle"
L["OPT_LOGS_DESC"] = "Zeigt erkannte Heiler und Statistik an."
L["OPT_MODULES"] = "Module"
L["OPT_NPH_ENEMY_NAMEPLATE"] = "Namensplaketten von Feinden"
L["OPT_NPH_FRIENDLY_NAMEPLATE"] = "Namensplaketten von Verbündeten"
L["OPT_NPH_MARKER_HIDDEN_WOW_SETTINGS"] = "Versteckte WoW-Einstellungen"
L["OPT_NPH_MARKER_SCALE"] = "Markierungsskalierung"
L["OPT_NPH_MARKER_SCALE_DESC"] = "Wert, mit dem die Markierungsgröße multipliziert wird (1 = Normalgröße, 0.5 = halbe Größe, 2 = doppelte Größe etc.)"
L["OPT_NPH_MARKER_SETTINGS"] = "Markierungseinstellungen"
L["OPT_NPH_MARKER_WOW_SETTINGS"] = "WoW-Einstellungen"
L["OPT_NPH_MARKER_X_OFFSET"] = "Horizontale Verschiebung"
L["OPT_NPH_MARKER_X_OFFSET_DESC"] = "Verschiebt Markierungen horizontal."
L["OPT_NPH_MARKER_Y_OFFSET"] = "Vertikale Verschiebung"
L["OPT_NPH_MARKER_Y_OFFSET_DESC"] = "Verschiebt Markierungen vertikal."
L["OPT_NPH_WARNING1"] = [=[WARNUNG: Die Namensplaketten feindlicher Einheiten sind deaktiviert. So kann HHTD sein Symbol auf feindlichen Heilern nicht anzeigen.
Du kannst die Anzeige der Namensplaketten aktivieren über Interface > Spiel > Namen oder durch Drücken der zugewiesenen Taste(nkombination).]=]
L["OPT_NPH_WARNING2"] = [=[WARNUNG: Die Namensplaketten befreundeter Einheiten sind deaktiviert. So kann HHTD sein Symbol nicht auf Verbündeten anzeigen.
Du kannst die Anzeige der Namensplaketten aktivieren über Interface > Spiel > Namen oder durch Drücken der zugewiesenen Taste(nkombination).]=]
L["OPT_OFF"] = "aus"
L["OPT_OFF_DESC"] = "Deaktiviert HHTD"
L["OPT_ON"] = "ein"
L["OPT_ON_DESC"] = "Aktiviert HHTD"
L["OPT_POST_ANNOUNCE_CHANNEL"] = "Chatkanal"
L["OPT_POST_ANNOUNCE_CHANNEL_DESC"] = [=[Entscheide, in welchen Kanal deine Meldungen gesendet werden.
Hinweis: Sofern du nicht 'Sagen' oder 'Schreien' verwenden willst, solltest du dies auf automatisch lassen.]=]
L["OPT_POST_ANNOUNCE_DESCRIPTION"] = [=[|cFFFF0000WICHTIG:|r Tippe |cff40ff40/hhtdp|r oder belege eine Taste, um die Meldung zu senden,
befreundete Heiler zu schützen und feindliche Heiler anzugreifen.
(siehe im Spielmenü unter Optionen -> Tastaturbelegung, um eine Taste zu belegen)]=]
L["OPT_POST_ANNOUNCE_ENABLE"] = "Chatmeldungen"
L["OPT_POST_ANNOUNCE_ENABLE_DESC"] = "Wenn du einen feindlichen Heiler anvisierst oder die Maus über ihn bewegst, wird eine Meldung in einem bestimmten Kanal gesendet."
L["OPT_POST_ANNOUNCE_HUMAMNS_ONLY"] = "Nur Spieler"
L["OPT_POST_ANNOUNCE_HUMAMNS_ONLY_DESC"] = "Es werden keine Meldungen über NPC's gesendet."
L["OPT_POST_ANNOUNCE_KILL_MESSAGE"] = "Text für feindliche Heiler"
L["OPT_POST_ANNOUNCE_KILL_MESSAGE_DESC"] = [=[Gib eine Meldung ein, die Dein Team anstachelt, feindliche Heiler anzugreifen.

Du musst das Schlüsselwort [HEALERS] irgendwo verwenden, welches automatisch mit den Namen der momentan aktiven feindlichen Heiler ersetzt wird.]=]
L["OPT_POST_ANNOUNCE_MESSAGE_TOO_SHORT"] = "Deine Meldung ist zu kurz!"
L["OPT_POST_ANNOUNCE_MESSAGES_EQUAL"] = "Es gibt eine Meldung für befreundete Heiler und eine für feindliche Heiler, diese dürfen nicht gleich sein."
L["OPT_POST_ANNOUNCE_MISSING_KEYWORD"] = "Das Schlüsselwort [HEALERS] fehlt!"
L["OPT_POST_ANNOUNCE_NUMBER"] = "Heileranzahl"
L["OPT_POST_ANNOUNCE_NUMBER_DESC"] = "So viele Heiler werden maximal pro Meldung einbezogen."
L["OPT_POST_ANNOUNCE_POST_MESSAGE_ISSUE"] = "In einem der Texte ist ein Fehler."
L["OPT_POST_ANNOUNCE_PROTECT_MESSAGE"] = "Text für befreundete Heiler"
L["OPT_POST_ANNOUNCE_PROTECT_MESSAGE_DESC"] = [=[Gib eine Meldung ein, die Dein Team anstachelt, seine Heiler zu schützen.

Du musst das Schlüsselwort [HEALERS] irgendwo verwenden, welches automatisch mit den Namen der momentan aktiven befreundeten Heiler ersetzt wird.]=]
L["OPT_POST_ANNOUNCE_SETTINGS"] = "Meldungseinstellungen"
L["OPT_POST_ANNOUNCE_THROTTLE"] = "Meldungsverzögerung"
L["OPT_POST_ANNOUNCE_THROTTLE_DESC"] = "So viele Sekunden liegen mindestens zwischen den Meldungen."
L["OPT_PROTECT_HEALER_MINIMUM_DAMAGE_AMOUNT"] = "Schadensschwellenwert (|cffdd0000%u|r)"
L["OPT_PROTECT_HEALER_MINIMUM_DAMAGE_AMOUNT_DESC"] = "Angegriffene befreundete Heiler werden nicht erkannt, bis sie diese Schadensmenge, die auf deiner eigenen maximalen Gesundheit basiert, erlitten haben."
L["OPT_PVE"] = "PVE-Option aktivieren"
L["OPT_PVE_DESC"] = "HHTD wird NPCs einbeziehen"
L["OPT_PVPHEALERSSPECSONLY"] = "Nur spezialisierte Spieler"
L["OPT_PVPHEALERSSPECSONLY_DESC"] = "Erkennt nur Spieler, die in Heilung spezialisiert sind."
L["OPT_SET_FRIENDLY_HEALERS_ROLE"] = "Rolle befreundeter Heiler setzen"
L["OPT_SET_FRIENDLY_HEALERS_ROLE_DESC"] = "Legt automatisch die Schlachtzug-Heiler-Rolle bei erkannten freundlichen Heilern (wenn möglich) fest."
L["OPT_SOUNDS"] = "Warnsignale"
L["OPT_SOUNDS_DESC"] = "HHTD wird einen bestimmten Sound abspielen, wenn du auf einen feindlichen Heiler zielst oder die Maus über ihn bewegst."
L["OPT_STRICTGUIDPVE"] = "Genaue PVE-Erkennung"
L["OPT_STRICTGUIDPVE_DESC"] = "Bei namensgleichen NPCs wird HHTD nur solchen NPCs ein rotes Kreuz hinzufügen, welche auch tatsächlich geheilt haben und nicht allen."
L["OPT_SWAPSYMBOLS"] = "Symbole von Verbündeten/Feinden tauschen"
L["OPT_SWAPSYMBOLS_DESC"] = "Die Symbole, die für Freunde und Feinde verwendet werden, werden getauscht."
L["OPT_TESTONTARGET"] = "Verhalten von HHTD auf das momentane Ziel testen"
L["OPT_TESTONTARGET_DESC"] = "Markiert das momentane Ziel als Heiler, so könnt Ihr testen, was passiert."
L["OPT_TESTONTARGET_ENOTARGET"] = "Du musst etwas anvisieren"
L["OPT_USE_HEALER_MINIMUM_HEAL_AMOUNT"] = "Benutze den Filter 'Minimale Heilungsmenge'"
L["OPT_USE_HEALER_MINIMUM_HEAL_AMOUNT_DESC"] = "Heiler müssen für die genannte Menge heilen, bevor sie als solche markiert werden."
L["OPT_VERSION"] = "Version"
L["OPT_VERSION_DESC"] = "Zeigt Version und Veröffentlichungsdatum an"
L["PARTY"] = "Gruppe"
L["RELEASE_DATE"] = "Veröffentlichungsdatum: "
L["SAY"] = "Sagen"
L["VERSION"] = "Version:"
L["YELL"] = "Schreien"
L["YOU_GOT_HER"] = "Du hast %ssie|r!"
L["YOU_GOT_HIM"] = "Du hast %sihn|r!"
L["YOU_GOT_IT"] = "Du hast %ses|r!"
    end
end

do
    local L = LibStub("AceLocale-3.0"):NewLocale("H.H.T.D.", "esES");

    if L then
L["ACTIVE"] = "¡Activo!"
L["Announcer"] = "Anunciador"
L["Announcer_DESC"] = "Este módulo te permite gestionar las alertas de chat y sonido."
L["CHAT_POST_ANNOUNCE_FEATURE_NOT_CONFIGURED"] = "Los anuncios a mensajes de raid no están configurados. Teclea /HHTDG"
L["CHAT_POST_NO_HEALERS"] = "No hay sanadores en ninguno de los bandos :/ (aún)"
L["DESCRIPTION"] = "¡Descubre a esos sanadores sangrientos instantáneamente y ayúdales a cumplir su destino! (JcE y JcJ)"
L["DISABLED"] = [=[hhtd ha sido desactivado!
Escribe /hhtd enable para reactivarlo.]=]
L["ENABLED"] = "¡Activado! Escribe /HHTDG para una lista de opciones."
L["HEALER_UNDER_ATTACK"] = "El sanador amigo %s esta siendo atacado por %s"
L["HUMAN"] = "Humano"
L["IDLE"] = "Inactivo"
L["IS_A_HEALER"] = "¡%s es un sanador!"
L["LOG_ACTIVE"] = "¡Activo!"
L["LOG_IDLE"] = "Inactivo"
L["NO_DATA"] = "No hay datos"
L["NPC"] = "NPC"
L["NPH_DESC"] = "Este módulo añade una cruz roja a las placas de nombre de los sanadores enemigos."
L["OPT_ANNOUNCE"] = "Mostrar mensajes"
L["OPT_ANNOUNCE_DESC"] = "HHTD mostrará mensajes cuando selecciones o pases por encima el ratón de un sanador enemigo."
L["OPT_CLEAR_LOGS"] = "Limpiar registros."
L["OPT_CORE_OPTIONS"] = "Opciones principales"
L["OPT_DEBUG"] = "Depurar"
L["OPT_DEBUG_DESC"] = "Activa / desactiva la depuración de errores"
L["OPT_ENABLE_GEHR"] = "Activa el Informe Gráfico"
L["OPT_ENABLE_GEHR_DESC"] = "Muestra una lista gráfica de sanadores enemigos detectados con diversas funciones"
L["OPT_HEALER_FORGET_TIMER"] = "Contador de olvido de sanador"
L["OPT_HEALER_FORGET_TIMER_DESC"] = "Establece el Contador de olvido de sanador (el tiempo en segundos en que un enemigo sigue siendo considerado como un sanador)"
L["OPT_HEALER_MINIMUM_HEAL_AMOUNT_DESC"] = "Los sanadores no serán detectados hasta que alcancen esta cantidad de sanación basada en un porcentaje de tu salud máxima."
L["OPT_HEALER_UNDER_ATTACK_ALERTS"] = "Protege los sanadores amigos"
L["OPT_HEALER_UNDER_ATTACK_ALERTS_DESC"] = "Muestra un mensaje cuando un sanador amigo cercano está siendo atacado"
L["OPT_LOG"] = "Registrando"
L["OPT_LOG_DESC"] = "Activa los registros y añade una nueva pestaña \"Registros\" al panel de opciones de HHTD."
L["OPT_LOGS"] = "Registros"
L["OPT_LOGS_DESC"] = "Muestra los sanadores detectados por HHTD y las estadísticas."
L["OPT_MODULES"] = "Módulos"
L["OPT_NPH_MARKER_SCALE"] = "Escala de los marcadores"
L["OPT_NPH_MARKER_SCALE_DESC"] = "Cambiar el tamaño de los marcadores"
L["OPT_NPH_MARKER_SETTINGS"] = "Opciones de los marcadores"
L["OPT_NPH_MARKER_X_OFFSET"] = "Punto horizontal"
L["OPT_NPH_MARKER_X_OFFSET_DESC"] = "Mueve el marcador horizontalmente"
L["OPT_NPH_MARKER_Y_OFFSET"] = "Punto vertical"
L["OPT_NPH_MARKER_Y_OFFSET_DESC"] = "Mueve el marcador verticalmente"
L["OPT_NPH_WARNING1"] = [=[AVISO: Las placas de nombre de enemigos están desactivadas. HHTD no puede añadir el símbolo de sanador.
Puedes activar las placas de nombre a través de las opciones de interfaz de WoW o usando la tecla asignada.]=]
L["OPT_NPH_WARNING2"] = [=[AVISO: Las placas de nombre de aliados están desactivadas. HHTD no puede añadir el símbolo de sanador.
Puedes activar las placas de nombre a través de las opciones de interfaz de WoW o usando la tecla asignada.]=]
L["OPT_OFF"] = "Desactivado"
L["OPT_OFF_DESC"] = "Desactiva HHTD"
L["OPT_ON"] = "Activado"
L["OPT_ON_DESC"] = "Activa HHTD"
L["OPT_POST_ANNOUNCE_CHANNEL_DESC"] = "Decide donde será mostrado tu anuncio"
L["OPT_POST_ANNOUNCE_ENABLE"] = "Anuncios de chat"
L["OPT_POST_ANNOUNCE_ENABLE_DESC"] = "Activar anuncios a raid."
L["OPT_POST_ANNOUNCE_HUMAMNS_ONLY"] = "Solo humanos"
L["OPT_POST_ANNOUNCE_HUMAMNS_ONLY_DESC"] = "No incluir NPCs en el anuncio."
L["OPT_POST_ANNOUNCE_KILL_MESSAGE"] = "Texto para sanadores enemigos"
L["OPT_POST_ANNOUNCE_KILL_MESSAGE_DESC"] = [=[Escribe un mensaje incitando a tu equipo a centrarse en los sanadores enemigos.

Debes usar la palabra clave [SANADORES] en algún sitio, que será reemplazado automáticamente por los nombres de los sanadores activos.]=]
L["OPT_POST_ANNOUNCE_MESSAGE_TOO_SHORT"] = "¡Tu mensaje es demasiado corto!"
L["OPT_POST_ANNOUNCE_MESSAGES_EQUAL"] = "Hay un mensaje para amigos y otro para enemigos, no pueden ser el mismo."
L["OPT_POST_ANNOUNCE_MISSING_KEYWORD"] = "¡La palabra clave [SANADORES] falta!"
L["OPT_POST_ANNOUNCE_NUMBER"] = "Número de sanadores"
L["OPT_POST_ANNOUNCE_NUMBER_DESC"] = "Establecer cuántos sanadores incluir en cada anuncio."
L["OPT_POST_ANNOUNCE_POST_MESSAGE_ISSUE"] = "Hay algo mal con uno de los textos de anuncio."
L["OPT_POST_ANNOUNCE_PROTECT_MESSAGE"] = "Texto para sanadores amigos."
L["OPT_POST_ANNOUNCE_PROTECT_MESSAGE_DESC"] = [=[Escribe un mensaje incitando a tu equipo a proteger sus sanadores.

Debes usar la palabra clave [SANADORES] en algún sitio, que será reemplazado automáticamente por los nombres de los sanadores activos.]=]
L["OPT_POST_ANNOUNCE_SETTINGS"] = "Opciones de anuncios a raid"
L["OPT_POST_ANNOUNCE_THROTTLE_DESC"] = "Establecer el tiempo mínimo en segundos entre cada posible anuncio."
L["OPT_PVE"] = "Activar para PVE"
L["OPT_PVE_DESC"] = "HHTD también trabajará con NPCs."
L["OPT_PVPHEALERSSPECSONLY"] = "Detección de especialización de sanador"
L["OPT_PVPHEALERSSPECSONLY_DESC"] = "Solo detectar jugadores especializados en sanación."
L["OPT_SET_FRIENDLY_HEALERS_ROLE"] = "Establecer rol de los sanadores amigos"
L["OPT_SET_FRIENDLY_HEALERS_ROLE_DESC"] = "Establecerá automáticamente el rol de raid SANADOR a los sanadores amigos cuando se detecten (si es posible)"
L["OPT_SOUNDS"] = "Sonidos de alerta"
L["OPT_SOUNDS_DESC"] = "HHTD activará un sonido específico cuando selecciones o pases el ratón por encima de un sanador enemigo"
L["OPT_STRICTGUIDPVE"] = "Detección refinada para PVE"
L["OPT_STRICTGUIDPVE_DESC"] = "Cuando varios NPCs compartan el mismo nombre, HHTD solo añadirá una cruz sobre aquellos que realmente curaron en vez de a todos. Toma nota de que la mayor parte del tiempo, necesitarás seleccionar o pasar el ratón por encima para que aparezca la cruz."
L["OPT_TESTONTARGET"] = "Probar el comportamiento de HHTD en el objetivo actual"
L["OPT_TESTONTARGET_DESC"] = "Marcará tu objetivo actual como sanador para que puedas probar lo que pasa."
L["OPT_TESTONTARGET_ENOTARGET"] = "Debes tener algún objetivo."
L["OPT_USE_HEALER_MINIMUM_HEAL_AMOUNT"] = "Usar filtro de cantidad sanación mínima."
L["OPT_USE_HEALER_MINIMUM_HEAL_AMOUNT_DESC"] = "Los sanadores tendrán que curar una cantidad especificada antes de ser etiquetados como sanadores."
L["OPT_VERSION"] = "Versión"
L["OPT_VERSION_DESC"] = "Muestra la versión y la fecha de publicación"
L["PARTY"] = "Grupo"
L["RELEASE_DATE"] = "Fecha de publicación:"
L["SAY"] = "Decir"
L["VERSION"] = "Versión:"
L["YELL"] = "Gritar"
    end
end

do
    local L = LibStub("AceLocale-3.0"):NewLocale("H.H.T.D.", "esMX");

    if L then
    end
end

do
    local L = LibStub("AceLocale-3.0"):NewLocale("H.H.T.D.", "koKR");

    if L then
L["ACTIVE"] = "활성화!"
L["Announcer"] = "알림"
L["Announcer_DESC"] = "이 모듈은 대화창 알림과 소리 경보를 관리할 수 있습니다"
L["AUTO_RAID_PARTY_INSTANCE"] = "자동: 공격대 경보 / 공격대 / 인스턴스 / 파티"
L["CHAT_POST_ANNOUNCE_FEATURE_NOT_CONFIGURED"] = "공격대 메시지로 알리기가 설정되어 있지 않습니다. /HHTDG를 입력하세요."
L["CHAT_POST_ANNOUNCE_TOO_SOON_WAIT"] = "잠깐! 기다리세요. (알림 속도 설정을 참조하세요.)"
L["CHAT_POST_NO_HEALERS"] = "아직 양쪽 힐러를 알 수 없음."
L["CM"] = "기호 사용자 설정"
L["CM_DESC"] = "NPC와 플레이어 유닛의 이름표에 영구적인 사용자 설정 기호를 설정하는 모듈을 활성화합니다."
L["DESCRIPTION"] = "피의 힐러를 빠르게 발견하고 그들의 운명을 결정짓습니다! (PVP 와 PVE)"
L["DISABLED"] = [=[hhtd가 중지 되었습니다!
다시 사용하려면 '/hhtd on'을 입력하세요.]=]
L["ENABLED"] = "사용! 옵션 창을 열려면 /HHTDG 를 입력하세요."
L["HEALER_UNDER_ATTACK"] = "힐러 %s|1이;가; %s의 공격을 받고 있습니다."
L["HUMAN"] = "인간"
L["IDLE"] = "놀고 있음"
L["INSTANCE_CHAT"] = "인스턴스 대화"
L["IS_A_HEALER"] = "%s|1는;은; 힐러입니다!"
L["LOG_ACTIVE"] = "활성화!"
L["LOG_BELOW_THRESHOLD"] = " (한계치 미만)"
L["LOG_IDLE"] = "비활성화"
L["NO_DATA"] = "자료 없음"
L["NPC"] = "NPC"
L["NPH"] = "이름표에 표시"
L["NPH_DESC"] = "이 모듈은 적 힐러 이름표에 붉은 십자가를 표시합니다."
L["OPT_ANNOUNCE"] = "메시지 보기"
L["OPT_ANNOUNCE_DESC"] = "적 힐러를 대상으로 잡거나 마우스-오버 하면 HHTD에 메시지를 표시합니다."
L["OPT_CLEAR_LOGS"] = "기록 지우기"
L["OPT_CM_CHANGEMARK"] = "%s|1으로;로; 변경"
L["OPT_CM_CHANGEMARK_DESC"] = "'%s' 선택기에서 선택된 기호로 변경합니다"
L["OPT_CM_CLEARASSOC"] = "초기화"
L["OPT_CM_CLEARASSOC_DESC"] = "각 기호에 지정된 이름을 초기화합니다"
L["OPT_CM_CLEARTARGETMARKER"] = "대상 지정 해제"
L["OPT_CM_CLEARTARGETMARKER_DESC"] = "당신의 대상에게서 기호를 제거합니다"
L["OPT_CM_DESCRIPTION"] = "여기서 유닛을 지정하고 자신만 볼 수 있는 사용자 설정 기호를 적용할 수 있습니다, 이 기호는 세션 간 유지됩니다."
L["OPT_CM_EXISTINGASSOC"] = "존재하는 이름-기호 연관"
L["OPT_CM_EXISTINGASSOC_DESC"] = "이 영역의 다른 버튼과 사용할 이름을 목록에서 선택하세요"
L["OPT_CM_MARKER_CUSTOMIZATION"] = "기호 사용자 설정"
L["OPT_CM_MARKER_MANAGEMENT"] = "기호 관리"
L["OPT_CM_SELECT_MARKER"] = "기호"
L["OPT_CM_SELECT_MARKER_DESC"] = "대상에게 지정할 기호를 선택하세요"
L["OPT_CM_SETTARGETMARKER"] = "대상 기호 지정"
L["OPT_CM_SETTARGETMARKER_DESC"] = "선택된 대상에게 선택된 기호를 지정합니다"
L["OPT_CM_VCa"] = "투명도 음영"
L["OPT_CM_VCa_DESC"] = "무늬의 투명도 요소 음영을 변경합니다"
L["OPT_CM_VCb"] = "청색 음영"
L["OPT_CM_VCb_DESC"] = "무늬의 청색 요소 음영을 변경합니다"
L["OPT_CM_VCg"] = "녹색 음영"
L["OPT_CM_VCg_DESC"] = "무늬의 녹색 요소 음영을 변경합니다"
L["OPT_CM_VCr"] = "적색 음영"
L["OPT_CM_VCr_DESC"] = "무늬의 적색 요소 음영을 변경합니다"
L["OPT_CORE_OPTIONS"] = "코어 옵션"
L["OPT_DEBUG"] = "디버그"
L["OPT_DEBUG_DESC"] = "디버그를 사용 / 중지합니다."
L["OPT_DEBUGLEVEL"] = "디버그 레벨"
L["OPT_DEBUGLEVEL_DESC"] = "디버그 레벨: 1=모두, 2=경고, 3=에러"
L["OPT_ENABLE_GEHR"] = "그래픽 보고 사용"
L["OPT_ENABLE_GEHR_DESC"] = "다양한 기능과 함께 감지된 적 힐러를 그래픽으로 목록을 표시합니다."
L["OPT_GUI"] = "GUI 열기"
L["OPT_GUI_DESC"] = "그래픽 설정 창을 엽니다"
L["OPT_HEADER_GLOBAL_ENEMY_HEALER_OPTIONS"] = "적 힐러 전역 설정"
L["OPT_HEADER_GLOBAL_FRIENDLY_HEALER_OPTIONS"] = "아군 힐러 전역 설정"
L["OPT_HEALER_FORGET_TIMER"] = "힐러 표시 시간"
L["OPT_HEALER_FORGET_TIMER_DESC"] = "힐러 표시 시간 설정 (적 힐러 표시를 유지할 시간을 초 단위로 설정합니다)"
L["OPT_HEALER_MINIMUM_HEAL_AMOUNT"] = "치유량 (|cff00dd00%u|r) 한계치"
L["OPT_HEALER_MINIMUM_HEAL_AMOUNT_DESC"] = "자신의 최대 체력 비율에 따르는 이 누적 치유량에 도달하기 전까진 힐러로 감지되지 않습니다."
L["OPT_HEALER_UNDER_ATTACK_ALERTS"] = "아군 힐러 보호"
L["OPT_HEALER_UNDER_ATTACK_ALERTS_DESC"] = "근처의 아군 힐러가 |cffdd0000%u|r 이상의 피해를 받으면 경보를 표시합니다"
L["OPT_LOG"] = "기록하기"
L["OPT_LOG_DESC"] = "기록하기를 활성화하면 HHTD의 옵션 창에 새로운 '기록' 탭이 추가됩니다."
L["OPT_LOGS"] = "기록"
L["OPT_LOGS_DESC"] = "감지된 힐러 및 통계를 HHTD에 표시"
L["OPT_MODULES"] = "모듈"
L["OPT_NPH_MARKER_SCALE"] = "힐러 기호 확대"
L["OPT_NPH_MARKER_SCALE_DESC"] = "힐러 기호의 크기를 설정합니다 # 예제. 1= 기본 크기, 0.5 = 절반 크기, 2 = 두배 크기, 등등..."
L["OPT_NPH_MARKER_SETTINGS"] = "힐러 기호 설정"
L["OPT_NPH_MARKER_X_OFFSET"] = "수평 위치"
L["OPT_NPH_MARKER_X_OFFSET_DESC"] = "힐러 기호의 위치를 수평으로 이동합니다."
L["OPT_NPH_MARKER_Y_OFFSET"] = "수직 위치"
L["OPT_NPH_MARKER_Y_OFFSET_DESC"] = "힐러 기호의 위치를 수직으로 이동합니다."
L["OPT_NPH_WARNING1"] = [=[경고: 적대적 이름표가 현재 비활성화되어 있습니다. HHTD가 적에게 표시를 추가할 수 없습니다.
        와우 인터페이스 설정이나 지정된 단축키로 이름표 표시를 활성화시킬 수 있습니다.]=]
L["OPT_NPH_WARNING2"] = [=[경고: 우호적 이름표가 현재 비활성되어 있습니다. HHTD가 아군에게 표시를 추가할 수 없습니다.
        와우 인터페이스 설정이나 지정된 단축키로 이름표 표시를 활성화시킬 수 있습니다.]=]
L["OPT_OFF"] = "끄기"
L["OPT_OFF_DESC"] = "HHTD 중지"
L["OPT_ON"] = "켜기"
L["OPT_ON_DESC"] = "HHTD 사용"
L["OPT_POST_ANNOUNCE_CHANNEL"] = "알림 채널"
L["OPT_POST_ANNOUNCE_CHANNEL_DESC"] = [=[알림을 표시할 채널을 지정합니다.
참고: '일반' 또는 '외치기'를 사용하려면 자동으로 설정해야 합니다.]=]
L["OPT_POST_ANNOUNCE_DESCRIPTION"] = [=[|cFFFF0000중요:|r 아군 힐러를 보호하고 주시할 적 힐러를 알리기 위해 |cff40ff40/hhtdp|r 입력하거나 단축키를 지정하세요.

(World of Warcraft에서 ESC를 누르고 환경 설정 메뉴 중 단축키 설정에서 단축키를 지정합니다.)]=]
L["OPT_POST_ANNOUNCE_ENABLE"] = "대화창에 알리기"
L["OPT_POST_ANNOUNCE_ENABLE_DESC"] = "공격대에 알립니다."
L["OPT_POST_ANNOUNCE_HUMAMNS_ONLY"] = "인간만 표시"
L["OPT_POST_ANNOUNCE_HUMAMNS_ONLY_DESC"] = "알림에서 NPC를 제외합니다."
L["OPT_POST_ANNOUNCE_KILL_MESSAGE"] = "적 힐러에 대한 문자 표시"
L["OPT_POST_ANNOUNCE_KILL_MESSAGE_DESC"] = [=[적 힐러를 주시하도록 팀에 전송할 메시지를 입력하세요.

[HEALERS] 키워드를 사용하면 자동으로 현재 활성화 된 힐러의 이름으로 바뀝니다.]=]
L["OPT_POST_ANNOUNCE_MESSAGE_TOO_SHORT"] = "메시지가 너무 짧습니다!"
L["OPT_POST_ANNOUNCE_MESSAGES_EQUAL"] = "아군과 적에게 사용할 메시지는 같을 수 없습니다."
L["OPT_POST_ANNOUNCE_MISSING_KEYWORD"] = "[HEALERS] 키워드가 없습니다!"
L["OPT_POST_ANNOUNCE_NUMBER"] = "힐러 숫자"
L["OPT_POST_ANNOUNCE_NUMBER_DESC"] = "각 알림에 포함할 힐러 수를 설정합니다."
L["OPT_POST_ANNOUNCE_POST_MESSAGE_ISSUE"] = "알림 문자 중 하나에 어떤 문제가 있습니다."
L["OPT_POST_ANNOUNCE_PROTECT_MESSAGE"] = "아군 힐러에 대한 문자"
L["OPT_POST_ANNOUNCE_PROTECT_MESSAGE_DESC"] = [=[아군 힐러를 보호하도록 팀에 전송할 메시지를 입력하세요.

[HEALERS] 키워드를 사용하면 자동으로 현재 활성화된 힐러의 이름으로 바뀝니다.]=]
L["OPT_POST_ANNOUNCE_SETTINGS"] = "공격대 알림 설정"
L["OPT_POST_ANNOUNCE_THROTTLE"] = "알림 속도 조절"
L["OPT_POST_ANNOUNCE_THROTTLE_DESC"] = "알림을 초 단위로 최소 시간을 설정합니다."
L["OPT_PROTECT_HEALER_MINIMUM_DAMAGE_AMOUNT"] = "피해량 (|cffdd0000%u|r) 한계치"
L["OPT_PROTECT_HEALER_MINIMUM_DAMAGE_AMOUNT_DESC"] = "자신의 최대 체력 비율에 따르는 이 누적 피해량에 도달하기 전까진 공격받는 아군 힐러로 감지되지 않습니다."
L["OPT_PVE"] = "PVE에서 사용"
L["OPT_PVE_DESC"] = "HHTD는 NPC에 대해서도 동작합니다."
L["OPT_PVPHEALERSSPECSONLY"] = [=[힐러 특화 감지
]=]
L["OPT_PVPHEALERSSPECSONLY_DESC"] = "오직 치료를 전문으로 하는 플레이어를 감지합니다."
L["OPT_SET_FRIENDLY_HEALERS_ROLE"] = "아군 힐러 역할을 설정"
L["OPT_SET_FRIENDLY_HEALERS_ROLE_DESC"] = "자동 감지할 때 아군 힐러를 공격대 힐러 역할로 설정합니다. (가능한 경우)"
L["OPT_SOUNDS"] = "소리 경보"
L["OPT_SOUNDS_DESC"] = "적 힐러를 대상으로 잡거나 마우스-오버 하면 HHTD에서 특정 소리를 냅니다."
L["OPT_STRICTGUIDPVE"] = "정확한 PVE 감지"
L["OPT_STRICTGUIDPVE_DESC"] = "여러 NPC가 같은 이름을 가지고 있으면 HHTD는 그들 모두에게 십자가를 표시하는 대신 실제로 치유하는 NPC에게만 십자가를 표시합니다. 지속적으로 십자가를 표시할 유닛을 대상 지정하거나 마우스-오버를 해야 한다는 걸 기억하세요."
L["OPT_TESTONTARGET"] = "현재 대상에게 HHTD의 동작을 테스트합니다"
L["OPT_TESTONTARGET_DESC"] = "테스트를 위해 현재 대상을 힐러로 지정합니다."
L["OPT_TESTONTARGET_ENOTARGET"] = "적절한 대상이 필요합니다."
L["OPT_USE_HEALER_MINIMUM_HEAL_AMOUNT"] = "최소 치유량 필터를 사용"
L["OPT_USE_HEALER_MINIMUM_HEAL_AMOUNT_DESC"] = "힐러로 지정되려면 특정량의 치유를 해야합니다."
L["OPT_VERSION"] = "버전"
L["OPT_VERSION_DESC"] = "버전과 배포 날짜 표시"
L["PARTY"] = "파티"
L["RELEASE_DATE"] = "배포 날짜:"
L["SAY"] = "일반"
L["VERSION"] = "버전:"
L["YELL"] = "외치기"
L["YOU_GOT_HER"] = "You got %sher|r!"
L["YOU_GOT_HIM"] = "You got %shim|r!"
L["YOU_GOT_IT"] = "You got %sit|r!"
    end
end

do
    local L = LibStub("AceLocale-3.0"):NewLocale("H.H.T.D.", "zhCN");

    if L then
L["ACTIVE"] = "激活！"
L["Announcer"] = "通报"
L["Announcer_DESC"] = "此模管理聊天和音效警报"
L["AUTO_RAID_PARTY_INSTANCE"] = "自动：团队/小队/副本"
L["CHAT_POST_ANNOUNCE_FEATURE_NOT_CONFIGURED"] = "未配置团队通报信息。输入 /HHTDG"
L["CHAT_POST_ANNOUNCE_TOO_SOON_WAIT"] = "太快了（查看通报阈值设置）。"
L["CHAT_POST_NO_HEALERS"] = "哇靠，当前双方都没有治疗职业！:D（暂时的）"
L["DESCRIPTION"] = "在魔兽世界中，治疗者必须死亡。这是一个残酷的真理，你在游戏的早期就被教导。这个插件可以帮助你影响这种不幸的命运在某种方式或另一个取决于治疗师的身边..."
L["DISABLED"] = [=[hhtd 已被禁用！
输入“/hhtd on”来重新启用。]=]
L["ENABLED"] = "已启用！输入 /HHTDG 打开选项列表"
L["HEALER_UNDER_ATTACK"] = "友方治疗职业%s被%s攻击"
L["HHTD_IS_NOW_KNOWN_AS_H.H.T.D."] = [=['%s'现在称为H.H.T.D. （有关详细信息，请参阅更改日志）

您之前的设置已成功传输，旧版本已关闭。

如果先前已为某些字符停用HHTD，则应在删除或全局禁用旧版'%s'插件之前加载每个字符，以便也可以保留此首选项。

此消息每个字符只显示一次。
]=]
L["HUMAN"] = "人类"
L["IDLE"] = "发呆"
L["INSTANCE_CHAT"] = "副本消息"
L["IS_A_HEALER"] = "%s是治疗职业！"
L["LOG_ACTIVE"] = "激活！"
L["LOG_BELOW_THRESHOLD"] = "（低于阈值）"
L["LOG_IDLE"] = "发呆"
L["NO_DATA"] = "无数据"
L["NPC"] = "NPC"
L["NPH"] = "姓名版挂钩"
L["NPH_DESC"] = "此模块在敌对治疗姓名板上添加一个红十字"
L["OPT_ANNOUNCE"] = "显示信息"
L["OPT_ANNOUNCE_DESC"] = "当你的目标或是鼠标指向一个敌对治疗者时 HHTD 将显示信息。"
L["OPT_CLEAR_LOGS"] = "清除记录"
L["OPT_CORE_OPTIONS"] = "核心选项"
L["OPT_DEBUG"] = "除错"
L["OPT_DEBUG_DESC"] = "启用/禁用除错"
L["OPT_DEBUGLEVEL"] = "除错等级"
L["OPT_DEBUGLEVEL_DESC"] = "除错等级：1=全部，2=警报，3=错误"
L["OPT_ENABLE_GEHR"] = "启用图形报告"
L["OPT_ENABLE_GEHR_DESC"] = "显示敌对治疗多功能图形列表"
L["OPT_HEALER_FORGET_TIMER"] = "治疗职业遗忘计时器"
L["OPT_HEALER_FORGET_TIMER_DESC"] = "设置治疗职业遗忘计时器（用于在一定时间内将一个敌人标记为治疗职业）"
L["OPT_HEALER_MINIMUM_HEAL_AMOUNT"] = "治疗值（|cff00dd00%u|r）阈值"
L["OPT_HEALER_MINIMUM_HEAL_AMOUNT_DESC"] = "治疗职业当他们达到累积的治疗量根据自己的最大生命值的百分比之前不会被检测到。"
L["OPT_HEALER_UNDER_ATTACK_ALERTS"] = "保护友方治疗职业"
L["OPT_HEALER_UNDER_ATTACK_ALERTS_DESC"] = "当附近的友方治疗职业被攻击时显示警报"
L["OPT_LOG"] = "正在记录"
L["OPT_LOG_DESC"] = "启用记录并添加一个新的“记录”标签到 HHTD 选项面板"
L["OPT_LOGS"] = "记录"
L["OPT_LOGS_DESC"] = "显示 HHTD 检测到的治疗和数据"
L["OPT_MODULES"] = "模块"
L["OPT_NPH_MARKER_SCALE"] = "标记缩放"
L["OPT_NPH_MARKER_SCALE_DESC"] = "更改标记尺寸"
L["OPT_NPH_MARKER_SETTINGS"] = "标记配置"
L["OPT_NPH_MARKER_X_OFFSET"] = "水平偏移量"
L["OPT_NPH_MARKER_X_OFFSET_DESC"] = "水平移动标记"
L["OPT_NPH_MARKER_Y_OFFSET"] = "垂直偏移量"
L["OPT_NPH_MARKER_Y_OFFSET_DESC"] = "垂直移动标记"
L["OPT_NPH_WARNING1"] = [=[提示：敌方姓名版未被启用。HHTD 不能添加治疗标记。
可以通过游戏内界面选项开启姓名版显示或使用快捷键。]=]
L["OPT_NPH_WARNING2"] = [=[提示：友方姓名版未被启用。HHTD 不能添加治疗标记。
可以通过游戏内界面选项开启姓名版显示或使用快捷键。]=]
L["OPT_OFF"] = "off"
L["OPT_OFF_DESC"] = "禁用 HHTD"
L["OPT_ON"] = "on"
L["OPT_ON_DESC"] = "启用 HHTD"
L["OPT_POST_ANNOUNCE_CHANNEL"] = "广播频道"
L["OPT_POST_ANNOUNCE_CHANNEL_DESC"] = "选择广播通报的频道"
L["OPT_POST_ANNOUNCE_DESCRIPTION"] = [=[|cFFFF0000主要：|r输入 |cff40ff40/hhtdp|r 或绑定按键通报保护友方治疗职业和特殊照顾敌方治疗职业。

（魔兽世界 ESC 菜单绑定界面设置按键绑定）]=]
L["OPT_POST_ANNOUNCE_ENABLE"] = "聊天通报"
L["OPT_POST_ANNOUNCE_ENABLE_DESC"] = "启用通报到团队功能。"
L["OPT_POST_ANNOUNCE_HUMAMNS_ONLY"] = "只对人类"
L["OPT_POST_ANNOUNCE_HUMAMNS_ONLY_DESC"] = "通报中不包含 NPC。"
L["OPT_POST_ANNOUNCE_KILL_MESSAGE"] = "敌对治疗文本"
L["OPT_POST_ANNOUNCE_KILL_MESSAGE_DESC"] = [=[输入一个消息鼓动你的队伍集中火力攻击敌方治疗职业。

必须使用 [HEALERS] 键值将被自动替换为当前激活治疗职业。]=]
L["OPT_POST_ANNOUNCE_MESSAGE_TOO_SHORT"] = "你的信息太少了！"
L["OPT_POST_ANNOUNCE_MESSAGES_EQUAL"] = "这有一个友好和敌对的信息，他们不能一样。"
L["OPT_POST_ANNOUNCE_MISSING_KEYWORD"] = "[HEALERS] 键值缺失！"
L["OPT_POST_ANNOUNCE_NUMBER"] = "治疗数量"
L["OPT_POST_ANNOUNCE_NUMBER_DESC"] = "设置每条通报上的治疗数量。"
L["OPT_POST_ANNOUNCE_POST_MESSAGE_ISSUE"] = "通报文本里有什么东西出错。"
L["OPT_POST_ANNOUNCE_PROTECT_MESSAGE"] = "友方治疗文本"
L["OPT_POST_ANNOUNCE_PROTECT_MESSAGE_DESC"] = [=[输入一个信息鼓动团队保护他们的治疗职业。

必须使用 [HEALERS] 键值将被自动替换为当激活的治疗职业。]=]
L["OPT_POST_ANNOUNCE_SETTINGS"] = "通报到团队设置"
L["OPT_POST_ANNOUNCE_THROTTLE"] = "通报阈值"
L["OPT_POST_ANNOUNCE_THROTTLE_DESC"] = "设置每条可能通报的最小时间间隔。"
L["OPT_PVE"] = "PvE 启用"
L["OPT_PVE_DESC"] = "HHTD 同样作用于 NPC。"
L["OPT_PVPHEALERSSPECSONLY"] = "治疗职业特定检测"
L["OPT_PVPHEALERSSPECSONLY_DESC"] = "只特定治疗玩家。"
L["OPT_SET_FRIENDLY_HEALERS_ROLE"] = "设置友方治疗职业角色"
L["OPT_SET_FRIENDLY_HEALERS_ROLE_DESC"] = "（如可能）自动设置检测团队治疗角色到友方治疗"
L["OPT_SOUNDS"] = "音效警报"
L["OPT_SOUNDS_DESC"] = "当你鼠标悬停或目标到一个敌对治疗时 HHTD 播放特定的音效。"
L["OPT_STRICTGUIDPVE"] = "精确 PvE 检测"
L["OPT_STRICTGUIDPVE_DESC"] = "当多个 NPC 共享相同的名称，HHTD 只会增加一个十字而不是全部。请注意，在十字出现之前大部分的时间需要切换目标或鼠标悬停在单位。"
L["OPT_TESTONTARGET"] = "在当前目标测试 HHTD 状态"
L["OPT_TESTONTARGET_DESC"] = "将标记当前目标为治疗者来测试发生了什么。"
L["OPT_TESTONTARGET_ENOTARGET"] = "需要一个目标"
L["OPT_USE_HEALER_MINIMUM_HEAL_AMOUNT"] = "使用最少治疗值过滤"
L["OPT_USE_HEALER_MINIMUM_HEAL_AMOUNT_DESC"] = "治疗职业将有指定治疗数值前被标记等。"
L["OPT_VERSION"] = "version"
L["OPT_VERSION_DESC"] = "显示版本和发布日期"
L["PARTY"] = "小队"
L["RELEASE_DATE"] = "发布日期："
L["SAY"] = "说"
L["VERSION"] = "版本："
L["YELL"] = "大喊"
L["YOU_GOT_HER"] = "你抓到%s她了|r！"
L["YOU_GOT_HIM"] = "你抓到%s他了|r！"
L["YOU_GOT_IT"] = "你抓到%s它了|r！"
    end
end

do
    local L = LibStub("AceLocale-3.0"):NewLocale("H.H.T.D.", "zhTW");

    if L then
L["ACTIVE"] = "啟用！"
L["Announcer"] = "通報"
L["Announcer_DESC"] = "此模組管理聊天和音效警報"
L["AUTO_RAID_PARTY_INSTANCE"] = "自動:團隊警告/團隊/隊伍/副本"
L["CHAT_POST_ANNOUNCE_FEATURE_NOT_CONFIGURED"] = "未設定團隊通報訊息。輸入 /HHTDG"
L["CHAT_POST_ANNOUNCE_TOO_SOON_WAIT"] = "太快了（查看通報條件設定）。"
L["CHAT_POST_NO_HEALERS"] = "哇靠，當前雙方都沒有治療！"
L["CM"] = "自訂標記"
L["CM_DESC"] = "啟用此模組在NPC和玩家血條上設定一個永久固定不變的自訂標記圖示。"
L["DESCRIPTION"] = "在魔獸世界中，治療者必須死亡。這是一個殘酷的真理，你在遊戲的早期就被教導。這個插件可以幫助你影響這種不幸的命運在某種方式或另一個取決於治療師的身邊..."
L["DISABLED"] = [=[hhtd 已被禁用！
輸入“/hhtd on”來重新啟用。]=]
L["ENABLED"] = "已啟用！輸入 /HHTDG 開啟選項面板"
L["HEALER_UNDER_ATTACK"] = "友方治療者%s被%s攻擊"
L["HHTD_IS_NOW_KNOWN_AS_H.H.T.D."] = [=['%s'現在稱為H.H.T.D. （有關詳細信息，請參閱更改日誌）

您之前的設置已成功傳輸，舊版本已關閉。

如果您以前對某些字符停用了HHTD，則應該在刪除或全局禁用舊版'%s'插件之前加載每個字符，以便也可以保留此首選項。

此消息每個字符只顯示一次。
]=]
L["HUMAN"] = "人類"
L["IDLE"] = "呆滯"
L["INSTANCE_CHAT"] = "副本頻道"
L["IS_A_HEALER"] = "%s是治療者！"
L["LOG_ACTIVE"] = "啟用！"
L["LOG_BELOW_THRESHOLD"] = "（低於條件）"
L["LOG_IDLE"] = "呆滯"
L["NO_DATA"] = "無數據"
L["NPC"] = "NPC"
L["NPH"] = "血條標記"
L["NPH_DESC"] = "此模組會在敵方治療者血條上添加一個紅十字標記"
L["OPT_A_CHAT_WARNING"] = "聊天視窗顯示警報"
L["OPT_A_CHAT_WARNING_DESC"] = "當友方治療者被攻擊時在聊天視窗顯示警報"
L["OPT_A_HEALER_PROTECTION"] = "保護補師設定"
L["OPT_A_HUD_WARNING"] = "螢幕畫面顯示警報"
L["OPT_A_HUD_WARNING_DESC"] = "當友方治療者被攻擊時在螢幕畫面上顯示警報"
L["OPT_ANNOUNCE"] = "顯示訊息"
L["OPT_ANNOUNCE_DESC"] = "當你的目標或是滑鼠指向一個敵對治療者時 HHTD 將顯示訊息。"
L["OPT_CLEAR_LOGS"] = "清除記錄"
L["OPT_CM_CHANGEMARK"] = "更改成 %s"
L["OPT_CM_CHANGEMARK_DESC"] = "將標記更改為 '%s' 中的所選擇的其中一個"
L["OPT_CM_CLEARASSOC"] = "清除"
L["OPT_CM_CLEARASSOC_DESC"] = "清除選取名稱的標記"
L["OPT_CM_CLEARTARGETMARKER"] = "清除目標"
L["OPT_CM_CLEARTARGETMARKER_DESC"] = "移除目標的標記圖示"
L["OPT_CM_DESCRIPTION"] = "選取一個對象為目標，加上只有你看得到的自訂標記圖示。這些標記圖示會一直保留。"
L["OPT_CM_EXISTINGASSOC"] = "已被標記的名稱"
L["OPT_CM_EXISTINGASSOC_DESC"] = "從清單中選擇一個名稱來使用此區塊按鈕的功能"
L["OPT_CM_FNPC_NAMEPLATE"] = "友方NPC血條"
L["OPT_CM_FNPC_NAMEPLATE_DESC"] = [=[顯示友方NPC的血條
要在頭上顯示標記圖示必須開啟這項功能。]=]
L["OPT_CM_MARKER_CUSTOMIZATION"] = "自訂標記圖示"
L["OPT_CM_MARKER_MANAGEMENT"] = "管理標記"
L["OPT_CM_SELECT_MARKER"] = "標記"
L["OPT_CM_SELECT_MARKER_DESC"] = "選擇要套用的標記圖示"
L["OPT_CM_SETTARGETMARKER"] = "標記目標"
L["OPT_CM_SETTARGETMARKER_DESC"] = "將選擇的標記圖示套用到選取的目標上"
L["OPT_CM_VCa"] = "半透明"
L["OPT_CM_VCa_DESC"] = "更改圖案的透明度"
L["OPT_CM_VCb"] = "藍色"
L["OPT_CM_VCb_DESC"] = "更改圖案的藍色調"
L["OPT_CM_VCg"] = "綠色"
L["OPT_CM_VCg_DESC"] = "更改圖案的綠色調"
L["OPT_CM_VCr"] = "紅色"
L["OPT_CM_VCr_DESC"] = "更改圖案的紅色調"
L["OPT_CORE_OPTIONS"] = "核心選項"
L["OPT_DEBUG"] = "除錯"
L["OPT_DEBUG_DESC"] = "啟用/停用除錯"
L["OPT_DEBUGLEVEL"] = "除錯等級"
L["OPT_DEBUGLEVEL_DESC"] = "除錯等級：1=全部，2 =警報，3 =錯誤"
L["OPT_ENABLE_GEHR"] = "啟用圖形報告"
L["OPT_ENABLE_GEHR_DESC"] = "顯示敵方治療多功能圖形列表"
L["OPT_GUI"] = "開啟圖形介面"
L["OPT_GUI_DESC"] = "開啟圖形設定面板"
L["OPT_HEADER_GLOBAL_ENEMY_HEALER_OPTIONS"] = "全局敵方治療者設定"
L["OPT_HEADER_GLOBAL_FRIENDLY_HEALER_OPTIONS"] = "全局友方治療者設定"
L["OPT_HEALER_FORGET_TIMER"] = "治療忽略計時器"
L["OPT_HEALER_FORGET_TIMER_DESC"] = "設定治療忽略計時器（在幾秒鐘的時間敵人仍會被認為有個治療者）"
L["OPT_HEALER_MINIMUM_HEAL_AMOUNT"] = "治療值（|cff00dd00%u|r）條件"
L["OPT_HEALER_MINIMUM_HEAL_AMOUNT_DESC"] = "治療者不會被偵測到直到他們累積一定數值的治療量(基於你最大血量的百分比)。"
L["OPT_HEALER_UNDER_ATTACK_ALERTS"] = "保護友方治療者"
L["OPT_HEALER_UNDER_ATTACK_ALERTS_DESC"] = "當附近的友方治療者被攻擊多達|cffdd0000%u|r傷害時顯示警報"
L["OPT_LOG"] = "正在記錄"
L["OPT_LOG_DESC"] = "啟用記錄並添加一個新的“記錄”標籤到 HHTD 選項面板"
L["OPT_LOGS"] = "記錄"
L["OPT_LOGS_DESC"] = "顯示 HHTD 檢測到的治療和數據"
L["OPT_MODULES"] = "模組"
L["OPT_NPH_ENEMY_NAMEPLATE"] = "敵方血條"
L["OPT_NPH_FRIENDLY_NAMEPLATE"] = "友方血條"
L["OPT_NPH_MARKER_HIDDEN_WOW_SETTINGS"] = "隱藏的遊戲設定"
L["OPT_NPH_MARKER_SCALE"] = "標記縮放"
L["OPT_NPH_MARKER_SCALE_DESC"] = "更改標記尺寸。1=一般大小、0.5=一半大小、2=雙倍大小...等。"
L["OPT_NPH_MARKER_SETTINGS"] = "標記設定"
L["OPT_NPH_MARKER_WOW_SETTINGS"] = "遊戲本身的設定"
L["OPT_NPH_MARKER_X_OFFSET"] = "水平偏移量"
L["OPT_NPH_MARKER_X_OFFSET_DESC"] = "水平移動標記"
L["OPT_NPH_MARKER_Y_OFFSET"] = "垂直偏移量"
L["OPT_NPH_MARKER_Y_OFFSET_DESC"] = "垂直移動標記"
L["OPT_NPH_WARNING1"] = [=[警告：敵方血條目前是關閉的，HHTD無法加入紅十字標記。
你可以在遊戲的介面選項中啟用顯示名稱/血條，或使用指定的按鍵。]=]
L["OPT_NPH_WARNING2"] = [=[警告：友方血條目前是關閉的，HHTD無法加入紅十字標記。
你可以在遊戲的介面選項中啟用顯示名稱/血條，或使用指定的按鍵。]=]
L["OPT_OFF"] = "off"
L["OPT_OFF_DESC"] = "停用 HHTD"
L["OPT_ON"] = "on"
L["OPT_ON_DESC"] = "啟用 HHTD"
L["OPT_POST_ANNOUNCE_CHANNEL"] = "廣播頻道"
L["OPT_POST_ANNOUNCE_CHANNEL_DESC"] = [=[選擇廣播通報的頻道
注意：除非您想使用'說'或'大喊'否則應該使用預設選項]=]
L["OPT_POST_ANNOUNCE_DESCRIPTION"] = [=[|cFFFF0000重要:|r 輸入 |cff40ff40/hhtdp|r 或是綁定一個按鍵以通報保護友方治療者與聚焦敵方治療者。
(請看魔獸世界ESC的快捷鍵設定介面以綁定一個按鍵)]=]
L["OPT_POST_ANNOUNCE_ENABLE"] = "聊天通報"
L["OPT_POST_ANNOUNCE_ENABLE_DESC"] = "啟用通報到團隊功能。"
L["OPT_POST_ANNOUNCE_HUMAMNS_ONLY"] = "只有玩家"
L["OPT_POST_ANNOUNCE_HUMAMNS_ONLY_DESC"] = "通報中不包含 NPC。"
L["OPT_POST_ANNOUNCE_KILL_MESSAGE"] = "敵方治療訊息"
L["OPT_POST_ANNOUNCE_KILL_MESSAGE_DESC"] = [=[輸入一個訊息以煽動你的團隊聚焦到敵方治療者。
你必須使用 [HEALERS]關鍵字，此字會自動替換為當前敵方治療者的名稱。]=]
L["OPT_POST_ANNOUNCE_MESSAGE_TOO_SHORT"] = "你的訊息太少了！"
L["OPT_POST_ANNOUNCE_MESSAGES_EQUAL"] = "這有一個友好和敵對的訊息，他們不能一樣。"
L["OPT_POST_ANNOUNCE_MISSING_KEYWORD"] = "[治療]鍵值缺失！"
L["OPT_POST_ANNOUNCE_NUMBER"] = "治療數值"
L["OPT_POST_ANNOUNCE_NUMBER_DESC"] = "設定每條通報上的治療數值。"
L["OPT_POST_ANNOUNCE_POST_MESSAGE_ISSUE"] = "通報訊息裡有什麼東西出錯。"
L["OPT_POST_ANNOUNCE_PROTECT_MESSAGE"] = "友方治療訊息"
L["OPT_POST_ANNOUNCE_PROTECT_MESSAGE_DESC"] = [=[輸入一個訊息調動團隊保護他們的治療。

你必須使用[HEALERS]關鍵字，而此字將被替換為當前啟動的治療者。]=]
L["OPT_POST_ANNOUNCE_SETTINGS"] = "通報到團隊設定"
L["OPT_POST_ANNOUNCE_THROTTLE"] = "通報條件"
L["OPT_POST_ANNOUNCE_THROTTLE_DESC"] = "設定每條可能通報的最小時間間隔。"
L["OPT_PROTECT_HEALER_MINIMUM_DAMAGE_AMOUNT"] = "傷害量(|cffdd0000%u|r)閥值"
L["OPT_PROTECT_HEALER_MINIMUM_DAMAGE_AMOUNT_DESC"] = "友方攻擊治療者不會被檢測到直到累積基於你本身最大血量質一定百分比的傷害量。"
L["OPT_PVE"] = "PvE 啟用"
L["OPT_PVE_DESC"] = "HHTD 同樣作用於 NPC。"
L["OPT_PVPHEALERSSPECSONLY"] = "偵測特定治療者"
L["OPT_PVPHEALERSSPECSONLY_DESC"] = "只偵測特定治療玩家。"
L["OPT_SET_FRIENDLY_HEALERS_ROLE"] = "設定友方治療者角色"
L["OPT_SET_FRIENDLY_HEALERS_ROLE_DESC"] = "（如可能）自動設定檢測團隊治療職責到友方治療"
L["OPT_SOUNDS"] = "音效警報"
L["OPT_SOUNDS_DESC"] = "當滑鼠滑過或目標為敵方治療時 HHTD 播放特定的音效。"
L["OPT_STRICTGUIDPVE"] = "精確 PvE 檢測"
L["OPT_STRICTGUIDPVE_DESC"] = "當多個NPC的名字相同時，HHTD只會加上一個紅十字在真實的治療者上，而不是所有人。"
L["OPT_SWAPSYMBOLS"] = "對調友方/敵方的標記"
L["OPT_SWAPSYMBOLS_DESC"] = "友方和敵方所使用的標記互相調換"
L["OPT_TESTONTARGET"] = "在當前目標測試 HHTD 狀態"
L["OPT_TESTONTARGET_DESC"] = "將標記當前目標為治療者來測試發生了什麼。"
L["OPT_TESTONTARGET_ENOTARGET"] = "需要一個目標"
L["OPT_USE_HEALER_MINIMUM_HEAL_AMOUNT"] = "使用最少治療值過濾"
L["OPT_USE_HEALER_MINIMUM_HEAL_AMOUNT_DESC"] = "治療者需要治療特定數額的治療量才能被標記。"
L["OPT_VERSION"] = "version"
L["OPT_VERSION_DESC"] = "顯示版本和發佈日期"
L["PARTY"] = "小隊"
L["RELEASE_DATE"] = "發佈日期："
L["SAY"] = "說"
L["VERSION"] = "版本："
L["YELL"] = "大喊"
L["YOU_GOT_HER"] = "你抓到%s她了|r！"
L["YOU_GOT_HIM"] = "你抓到%s他了|r！"
L["YOU_GOT_IT"] = "你抓到%s它了|r！"
    end
end

do
    local L = LibStub("AceLocale-3.0"):NewLocale("H.H.T.D.", "ruRU");

    if L then
L["ACTIVE"] = "Активный!"
L["Announcer"] = "Информатор"
L["Announcer_DESC"] = "Модуль настройки оповещений в чате и звуковых оповещений"
L["AUTO_RAID_PARTY_INSTANCE"] = "Автоматически: Рейд/Группа/Подземелье"
L["CHAT_POST_ANNOUNCE_FEATURE_NOT_CONFIGURED"] = "Рейдовые оповещения не сконфигурированы. Введите /HHTDG"
L["CHAT_POST_ANNOUNCE_TOO_SOON_WAIT"] = "Слишком быстро. Проверьте установки скорости появления оповещений"
L["CHAT_POST_NO_HEALERS"] = "Ни наших,ни вражеских лекарей не обнаружено :/ (Пока...)"
L["DESCRIPTION"] = "Мгновенно обнаружить этих чертовых лекарей и воздать им по заслугам! (PVP и PVE)."
L["DISABLED"] = [=[HHTD выключен.
Введите "/hhtd on" для включения.]=]
L["ENABLED"] = [=[HHTD включен!
Для просмотра возможных параметров введите команду /HHTDG]=]
L["HEALER_UNDER_ATTACK"] = "наш лекарь %s атакован %s"
L["HUMAN"] = "Человек"
L["IDLE"] = "Находится в режиме ожидания"
L["INSTANCE_CHAT"] = "Чат подземелья"
L["IS_A_HEALER"] = "%s - лекарь!"
L["LOG_ACTIVE"] = "активен"
L["LOG_BELOW_THRESHOLD"] = "ниже порогового значения"
L["LOG_IDLE"] = "в режиме ожидания"
L["NO_DATA"] = "Информация отсутствует"
L["NPC"] = "НИП"
L["NPH"] = "Подключение к индикаторам"
L["NPH_DESC"] = "Модуль, добавляющий красный крест к индикаторам здоровья вражеских лекарей"
L["OPT_ANNOUNCE"] = "Вывод сообщений"
L["OPT_ANNOUNCE_DESC"] = "HHTD выводит сообщения при выборе вражеского лекаря в цель или наведении на него мышкой"
L["OPT_CLEAR_LOGS"] = "Стирает информацию в Логах"
L["OPT_CORE_OPTIONS"] = "Основные настройки"
L["OPT_DEBUG"] = "отладка"
L["OPT_DEBUG_DESC"] = "Включает/выключает режим отладки."
L["OPT_DEBUGLEVEL"] = "уровень отладки"
L["OPT_DEBUGLEVEL_DESC"] = "уровень отладки: 1=все, 2=предупреждения, 3=ошибки"
L["OPT_ENABLE_GEHR"] = "Включение графического информатора"
L["OPT_ENABLE_GEHR_DESC"] = "Отображает графический список вражеских лекарей с разными дополнительными возможностями."
L["OPT_HEALER_FORGET_TIMER"] = "Таймер забывания лекарей"
L["OPT_HEALER_FORGET_TIMER_DESC"] = "устанавливает таймер забывания лекаря (Сколько времени в секундах помнить об обнаруженном лекаре)."
L["OPT_HEALER_MINIMUM_HEAL_AMOUNT"] = "Порог количества лечения - (|cff00dd00%u|r)."
L["OPT_HEALER_MINIMUM_HEAL_AMOUNT_DESC"] = "Лекари не будут обнаружены, пока они не достигнут Порога количества лечения."
L["OPT_HEALER_UNDER_ATTACK_ALERTS"] = "защитить наших лекарей"
L["OPT_HEALER_UNDER_ATTACK_ALERTS_DESC"] = "выдать сообщение когда рядом с вами атакован наш лекарь "
L["OPT_LOG"] = "Загрузка"
L["OPT_LOG_DESC"] = "включает режим загрузки и добавляет новую страницу \"Логи\" к панели опций HHTD"
L["OPT_LOGS"] = "Логи"
L["OPT_LOGS_DESC"] = "отображает лекарей, обнаруженных HHTD, и соответствующую статистику"
L["OPT_MODULES"] = "Модули"
L["OPT_NPH_MARKER_SCALE"] = "установка пропорций индикаторов"
L["OPT_NPH_MARKER_SCALE_DESC"] = "изменить размер индикаторов"
L["OPT_NPH_MARKER_SETTINGS"] = "установка параметров индикаторов"
L["OPT_NPH_MARKER_X_OFFSET"] = "отступ по горизонтали"
L["OPT_NPH_MARKER_X_OFFSET_DESC"] = "сдвинуть маркеры по горизонтали"
L["OPT_NPH_MARKER_Y_OFFSET"] = "отступ по вертикали"
L["OPT_NPH_MARKER_Y_OFFSET_DESC"] = "сдвинуть маркеры по вертикали"
L["OPT_NPH_WARNING1"] = [=[ВНИМАНИЕ: Индикаторы здоровья врагов выключены! HHTD не сможет добавлять символ красного креста!
Вы можете включить индикаторы здоровья через опции интерфейса WoW или используя горячую клавишу.]=]
L["OPT_NPH_WARNING2"] = [=[ВНИМАНИЕ: Индикаторы здоровья союзников выключены! HHTD не сможет добавлять символ лекаря!
Вы можете включить индикаторы здоровья через опции интерфейса WoW или используя горячую клавишу.]=]
L["OPT_OFF"] = "off"
L["OPT_OFF_DESC"] = "Отключение HHTD."
L["OPT_ON"] = "on"
L["OPT_ON_DESC"] = "Включает HHTD"
L["OPT_POST_ANNOUNCE_CHANNEL"] = "канал сообщения"
L["OPT_POST_ANNOUNCE_CHANNEL_DESC"] = "выберите в каком канале появится ваше сообщение"
L["OPT_POST_ANNOUNCE_DESCRIPTION"] = "|cFFFF0000IMPORTANT:|r Введите |cff40ff40/hhtdp|r или назначьте горячую клавишу для выдачи объявления о небходимости защиты наших лекарей, и о фокусировании на атаках на вражеских лекарей"
L["OPT_POST_ANNOUNCE_ENABLE"] = "объявления в чате"
L["OPT_POST_ANNOUNCE_ENABLE_DESC"] = "Включает рейдовые оповещения"
L["OPT_POST_ANNOUNCE_HUMAMNS_ONLY"] = "Только люди"
L["OPT_POST_ANNOUNCE_HUMAMNS_ONLY_DESC"] = "Не включать имена НИП в оповещения"
L["OPT_POST_ANNOUNCE_KILL_MESSAGE"] = "Текст для вражеских лекарей"
L["OPT_POST_ANNOUNCE_KILL_MESSAGE_DESC"] = [=[Выдать сообщение для вашей группы о необходимости сконцентрироваться на атаке вражеских лекарей.

В тексте вашего сообщения вы должны использовать кодовое слово [HEALERS], которое будет автоматически заменено на имена активных в данный момент лекарей]=]
L["OPT_POST_ANNOUNCE_MESSAGE_TOO_SHORT"] = "ваше сообщение слишком короткое"
L["OPT_POST_ANNOUNCE_MESSAGES_EQUAL"] = "Есть сообщения для друзей, и есть для недругов. Они не могут быть одинаковы."
L["OPT_POST_ANNOUNCE_MISSING_KEYWORD"] = "кодовое слово [HEALERS] отсутствует"
L["OPT_POST_ANNOUNCE_NUMBER"] = "количество лекарей"
L["OPT_POST_ANNOUNCE_NUMBER_DESC"] = "установить какое количество лекарей включать в каждое оповещение"
L["OPT_POST_ANNOUNCE_POST_MESSAGE_ISSUE"] = "что-то не так с текстом одного из обьявлений"
L["OPT_POST_ANNOUNCE_PROTECT_MESSAGE"] = "текст для наших лекарей"
L["OPT_POST_ANNOUNCE_PROTECT_MESSAGE_DESC"] = [=[Выдать сообщение для вашей группы о необходимости сконцентрироваться на защите наших лекарей.

В тексте вашего сообщения вы должны использовать кодовое слово [HEALERS], которое будет автоматически заменено на имена активных в данный момент лекарей]=]
L["OPT_POST_ANNOUNCE_SETTINGS"] = "параметры рейдовых обьявлений"
L["OPT_POST_ANNOUNCE_THROTTLE"] = "скорость появления обьявлений"
L["OPT_POST_ANNOUNCE_THROTTLE_DESC"] = "установите минимальное время в секундах между появлениями каждого из возможных обьявлений"
L["OPT_PVE"] = "Включить для ПВЕ"
L["OPT_PVE_DESC"] = "Разрешить использование HHTD против НИП"
L["OPT_PVPHEALERSSPECSONLY"] = "Обнаружение специализации лекаря"
L["OPT_PVPHEALERSSPECSONLY_DESC"] = "Выявлять только игроков специализирующихся на лечении."
L["OPT_SET_FRIENDLY_HEALERS_ROLE"] = "установите роли наших лекарей"
L["OPT_SET_FRIENDLY_HEALERS_ROLE_DESC"] = "если возможно, автоматически установит роль Лекарь Рейда для всех обнаруженных наших лекарей"
L["OPT_SOUNDS"] = "Звуковые оповещения"
L["OPT_SOUNDS_DESC"] = "HHTD воспроизводит определенный звук при выборе лекаря в цель или наведении на него мышки"
L["OPT_STRICTGUIDPVE"] = "Точность отслеживания в ПВЕ-режиме"
L["OPT_STRICTGUIDPVE_DESC"] = "Если несколько НИП имеют одинаковые имена, HHTD добавит красный крест только к тому, который лечил в последнее время, а не ко всем сразу. В большинстве случаев понадобится выбрать НИП целью или навести на него мышь для появления креста."
L["OPT_TESTONTARGET"] = "протестировать работу HHTD на выбранной цели"
L["OPT_TESTONTARGET_DESC"] = "пометит выбранную вами цель как лекаря чтобы вы смогли протестировать как все работает"
L["OPT_TESTONTARGET_ENOTARGET"] = "вы должны сначала выбрать цель"
L["OPT_USE_HEALER_MINIMUM_HEAL_AMOUNT"] = "Фильтр порога количества лечения."
L["OPT_USE_HEALER_MINIMUM_HEAL_AMOUNT_DESC"] = "Лекарь должен выдать определенное количество лечения прежде чем он будет помечен как лекарь."
L["OPT_VERSION"] = "версия"
L["OPT_VERSION_DESC"] = "Информация о версии и дате релиза"
L["PARTY"] = "группа"
L["RELEASE_DATE"] = "Дата выхода:"
L["SAY"] = "сказать"
L["VERSION"] = "Версия:"
L["YELL"] = "крикнуть"
L["YOU_GOT_HER"] = "Ты сделал %sее|r!"
L["YOU_GOT_HIM"] = "Ты сделал %sего|r!"
L["YOU_GOT_IT"] = "Ты сделал %sэтого|r!"
    end
end

do
    local L = LibStub("AceLocale-3.0"):NewLocale("H.H.T.D.", "itIT");

    if L then
L["ACTIVE"] = "Attivo!"
L["Announcer"] = "Annunciatore"
L["Announcer_DESC"] = "Questo modulo ti permette di gestire chat e avvisi sonori"
L["AUTO_RAID_PARTY_INSTANCE"] = "Auto: Raid/Party/Instance"
L["CHAT_POST_ANNOUNCE_FEATURE_NOT_CONFIGURED"] = "Gli annunci al raid non sono configurati. Scrivi /HHTDG"
L["CHAT_POST_ANNOUNCE_TOO_SOON_WAIT"] = "E' troppo presto (vedi impostazioni sulla frequenza degli annunci)."
L["CHAT_POST_NO_HEALERS"] = "Nessun guaritore su entrambi i lati :/ (ancora)"
L["DESCRIPTION"] = "Individua quei dannati curatori all'istante e aiutali a compiere il loro destino! (PVP e PVE)"
L["DISABLED"] = [=[hhtd è stato disattivato!
Scrivi '/hhtd on' per riattivarlo.]=]
L["ENABLED"] = "attivo! Scrivi /HHTDG per aprire il pannello delle opzioni"
L["HEALER_UNDER_ATTACK"] = "Il curatore amico %s sta venendo attaccato da %s"
L["HUMAN"] = "Umano"
L["IDLE"] = "Inattivo"
L["INSTANCE_CHAT"] = "Instance chat"
L["IS_A_HEALER"] = "%s è un curatore!"
L["LOG_ACTIVE"] = "Attivo!"
L["LOG_BELOW_THRESHOLD"] = " (sotto la soglia)"
L["LOG_IDLE"] = "Inattivo"
L["NO_DATA"] = "Nessun dato"
L["NPC"] = "NPC"
L["NPH"] = "Marcatore Name Plate"
L["NPH_DESC"] = "Questo modulo aggiunge una croce rossa sui name plate dei curatori nemici"
L["OPT_ANNOUNCE"] = "Mostra messaggi"
L["OPT_ANNOUNCE_DESC"] = "HHTD mostrerà messaggi quando passerai il mouse sopra un curatore nemico o lo avrai come target."
L["OPT_CLEAR_LOGS"] = "Cancella i log"
L["OPT_CORE_OPTIONS"] = "Opzioni di base"
L["OPT_DEBUG"] = "log dei debug"
L["OPT_DEBUG_DESC"] = "Attiva / disattiva debugging"
L["OPT_DEBUGLEVEL"] = "livello debugging"
L["OPT_DEBUGLEVEL_DESC"] = "livello debug: 1=tutto, 2=avvisi, 3=errori"
L["OPT_ENABLE_GEHR"] = "Attiva Rapporto Grafico"
L["OPT_ENABLE_GEHR_DESC"] = "Mostra una lista con varie caratteristiche dei curatori nemici rilevati"
L["OPT_HEALER_FORGET_TIMER"] = "Timer Dimentica Curatore"
L["OPT_HEALER_FORGET_TIMER_DESC"] = "Imposta il Timer Dimentica Curatore (tempo in secondi per cui un nemico resterà marcato come curatore)"
L["OPT_HEALER_MINIMUM_HEAL_AMOUNT"] = "Soglia di cura (|cff00dd00%u|r)"
L["OPT_HEALER_MINIMUM_HEAL_AMOUNT_DESC"] = "I curatori non saranno rilevati fino a che non raggiungeranno questo ammontare cumulativo di cure, basato su una percentuale della tua vita massima."
L["OPT_HEALER_UNDER_ATTACK_ALERTS"] = "Proteggi i curatori amici"
L["OPT_HEALER_UNDER_ATTACK_ALERTS_DESC"] = "Mostra un avviso quando un curatore amico è sotto attacco"
L["OPT_LOG"] = "Logging"
L["OPT_LOG_DESC"] = "Attiva i log e aggiunge una nuova etichetta 'Log' al pannello delle opzioni di HHTD"
L["OPT_LOGS"] = "Log"
L["OPT_LOGS_DESC"] = "Mostra curatori rilevati e statistiche di HHTD"
L["OPT_MODULES"] = "Moduli"
L["OPT_NPH_MARKER_SCALE"] = "Dimensioni marcatore"
L["OPT_NPH_MARKER_SCALE_DESC"] = "Moltiplica la dimensione del marcatore di # ad es. 1 = normale, 0.5 = dimezzata, 2 = doppia, ecc."
L["OPT_NPH_MARKER_SETTINGS"] = "Impostazioni marcatore"
L["OPT_NPH_MARKER_X_OFFSET"] = "Offset orizzontale"
L["OPT_NPH_MARKER_X_OFFSET_DESC"] = "Muove il marcatore orizzontalmente"
L["OPT_NPH_MARKER_Y_OFFSET"] = "Offset verticale"
L["OPT_NPH_MARKER_Y_OFFSET_DESC"] = "Muove il marcatore verticalmente"
L["OPT_NPH_WARNING1"] = [=[ATTENZIONE: I name-plate dei nemici sono disattivati. HHTD non può aggiungere la croce rossa.
Puoi attivare i name-plate attraverso le opzioni di interfaccia di WoW.]=]
L["OPT_NPH_WARNING2"] = [=[ATTENZIONE: I name-plate per gli alleati sono disattivati. HHTD non può aggiungere il simbolo di curatore.
Puoi attivare i name-plate attraverso le opzioni di interfaccia di WoW.]=]
L["OPT_OFF"] = "disattivato"
L["OPT_OFF_DESC"] = "Disattiva HHTD"
L["OPT_ON"] = "attivato"
L["OPT_ON_DESC"] = "Attiva HHTD"
L["OPT_POST_ANNOUNCE_CHANNEL"] = "Canale di invio"
L["OPT_POST_ANNOUNCE_CHANNEL_DESC"] = "Decidi in quale canale inviare i tuoi annunci"
L["OPT_POST_ANNOUNCE_DESCRIPTION"] = [=[|cFFFF0000IMPORTANTE:|r Scrivi |cff40ff40/hhtdp|r o assegna un tasto per annunciare curatori alleati da proteggere e curatori nemici da puntare.

(vedi assegnazione tasti nel menu di World of Warcraft)
]=]
L["OPT_POST_ANNOUNCE_ENABLE"] = "Annunci in chat"
L["OPT_POST_ANNOUNCE_ENABLE_DESC"] = "Attiva funzioni di annuncio al raid."
L["OPT_POST_ANNOUNCE_HUMAMNS_ONLY"] = "Solo umani"
L["OPT_POST_ANNOUNCE_HUMAMNS_ONLY_DESC"] = "Non includere NPC negli annunci."
L["OPT_POST_ANNOUNCE_KILL_MESSAGE"] = "Testo per curatori nemici"
L["OPT_POST_ANNOUNCE_KILL_MESSAGE_DESC"] = [=[Scrivi un messaggio per incitare la tua squadra ad attaccare i curatori nemici.

Devi usare la parola chiave [HEALERS] da qualche parte, che verrà automaticamente rimpiazzata dai nomi degli attuali curatori attivi.]=]
L["OPT_POST_ANNOUNCE_MESSAGE_TOO_SHORT"] = "Il tuo messaggio è troppo corto!"
L["OPT_POST_ANNOUNCE_MESSAGES_EQUAL"] = "C'è un messaggio per gli amici e uno per i nemici, non possono essere lo stesso."
L["OPT_POST_ANNOUNCE_MISSING_KEYWORD"] = "Manca la parola [HEALERS]"
L["OPT_POST_ANNOUNCE_NUMBER"] = "Numero di curatori"
L["OPT_POST_ANNOUNCE_NUMBER_DESC"] = "Imposta quanti curatori includere in ogni annuncio."
L["OPT_POST_ANNOUNCE_POST_MESSAGE_ISSUE"] = "C'è qualcosa di sbagliato in uno dei testi di annuncio."
L["OPT_POST_ANNOUNCE_PROTECT_MESSAGE"] = "Testo per i curatori amici"
L["OPT_POST_ANNOUNCE_PROTECT_MESSAGE_DESC"] = [=[Scrivi un messaggio per incitare la tua squadra a proteggere i curatori amici.

Devi usare la parola chiave [HEALERS] da qualche parte, che verrà automaticamente rimpiazzata dai nomi degli attuali curatori attivi.]=]
L["OPT_POST_ANNOUNCE_SETTINGS"] = "Impostazioni di annuncio al raid"
L["OPT_POST_ANNOUNCE_THROTTLE"] = "Frequenza annunci"
L["OPT_POST_ANNOUNCE_THROTTLE_DESC"] = "Imposta il tempo minimo in secondi tra ogni possibile annuncio."
L["OPT_PVE"] = "Attiva in PVE"
L["OPT_PVE_DESC"] = "HHTD funzionerà anche per gli NPC."
L["OPT_PVPHEALERSSPECSONLY"] = "Solo giocatori curatori"
L["OPT_PVPHEALERSSPECSONLY_DESC"] = "Rileva solo giocatori specializzati come curatori."
L["OPT_SET_FRIENDLY_HEALERS_ROLE"] = "Imposta ruolo curatori amici"
L["OPT_SET_FRIENDLY_HEALERS_ROLE_DESC"] = "Imposta automaticamente il ruolo di HEALER ai curatori amici rilevati nel raid (se possibile)"
L["OPT_SOUNDS"] = "Avvisi sonori"
L["OPT_SOUNDS_DESC"] = "HHTD attiverà un suono specifico quando passerai il mouse sopra un curatore nemico o lo prenderai in target"
L["OPT_STRICTGUIDPVE"] = "Rilevazione PVE accurata"
L["OPT_STRICTGUIDPVE_DESC"] = "Quando più NPC condividono lo stesso nome, HHTD aggiungerà una croce solo sopra a quelli che effettivamente avranno curato invece che a tutti loro. Nota che il più delle volte avrai bisogno di prendere in target o passare il mouse su di un'unità prima che la croce appaia."
L["OPT_TESTONTARGET"] = "Prova il comportamento di HHTD sul target attuale"
L["OPT_TESTONTARGET_DESC"] = "Segnerà il tuo target attuale come un curatore per farti vedere cosa succede."
L["OPT_TESTONTARGET_ENOTARGET"] = "Devi avere in target qualcosa"
L["OPT_USE_HEALER_MINIMUM_HEAL_AMOUNT"] = "Usa filtro di cura minima"
L["OPT_USE_HEALER_MINIMUM_HEAL_AMOUNT_DESC"] = "Un personaggio dovrà curare della quantità specificata prima di essere considerato curatore."
L["OPT_VERSION"] = "versione"
L["OPT_VERSION_DESC"] = "Mostra versione e data di rilascio"
L["PARTY"] = "Party"
L["RELEASE_DATE"] = "Data di rilascio:"
L["SAY"] = "Say"
L["VERSION"] = "versione:"
L["YELL"] = "Yell"
L["YOU_GOT_HER"] = "%sPresa|r!"
L["YOU_GOT_HIM"] = "%sPreso|r!"
L["YOU_GOT_IT"] = "%sPreso|r!"
    end
end
