CREATE TABLE [dbo].[CP_ProdInfo] (
	[Prod_ID] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[Prod_Code] [varchar] (25) NOT NULL ,
	[PI_Name] [nvarchar] (64) NOT NULL ,
	[PI_AID] [varchar] (10) NULL ,
	[PT_ID] [int] NOT NULL ,
	[PI_Spec] [varchar] (50) NULL ,
	[Unit_ID] [int] NULL ,
	[PI_Unit] [varchar] (20) NOT NULL ,
	[PI_Price] [numeric](18, 4) NOT NULL ,
	[PI_Cost] [numeric](18, 4) NOT NULL ,
	[PI_Date] [varchar] (10) NULL ,
	[PI_Grade] [varchar] (10) NULL ,
	[PI_MaintTerm] [int] NULL ,
	[PI_Picture] [int] NULL ,
	[PI_Desc] [text] NULL ,
	[PI_Memo] [text] NULL ,
	[PI_Int01] [int] NULL ,
	[PI_Int02] [int] NULL ,
	[PI_Int03] [int] NULL ,
	[PI_Dec01] [numeric](18, 4) NULL ,
	[PI_Dec02] [numeric](18, 4) NULL ,
	[PI_Dec03] [numeric](18, 4) NULL ,
	[PI_Char01] [varchar] (64) NULL ,
	[PI_Char02] [varchar] (64) NULL ,
	[PI_Char03] [varchar] (64) NULL ,
	[PI_Char04] [varchar] (64) NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[CP_ProdType] (
	[PT_ID] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[PT_Code] [varchar] (20) NOT NULL ,
	[PT_Name] [nvarchar] (50) NOT NULL ,
	[PT_ProdSN] [int] NULL ,
	[PT_Levels] [int] NULL ,
	[PT_Path] [varchar] (100) NULL ,
	[PT_ParentID] [int] NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[FW_CareAdvice] (
	[Ca_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[CA_Code] [varchar] (20) NULL ,
	[CA_Type] [varchar] (20) NULL ,
	[CA_CustID] [text] NULL ,
	[CA_Subject] [varchar] (100) NULL ,
	[CA_Content] [text] NULL ,
	[CA_Days] [int] NULL ,
	[CA_Flag] [bit] NULL ,
	[Contact_ID] [int] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[FW_FdbkPrg] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[Fdbk_id] [varchar] (10) NOT NULL ,
	[Fp_PrgId] [varchar] (10) NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[FW_FdbkTask] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[Fdbk_ID] [varchar] (10) NOT NULL ,
	[FT_TaskID] [varchar] (10) NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[FW_Feedback] (
	[Fdbk_ID] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[Fdbk_Code] [varchar] (20) NOT NULL ,
	[Fdbk_SrcType] [varchar] (10) NULL ,
	[Fdbk_SrcID] [int] NULL ,
	[Fdbk_Type] [varchar] (10) NULL ,
	[Fdbk_TargetType] [varchar] (10) NULL ,
	[Fdbk_TargetID] [varchar] (10) NULL ,
	[Fdbk_TargetName] [varchar] (100) NULL ,
	[Fdbk_subject] [varchar] (50) NULL ,
	[Fdbk_priority] [varchar] (10) NULL ,
	[Fdbk_Dispose] [varchar] (100) NULL ,
	[Fdbk_Desc] [text] NULL ,
	[Fdbk_Result] [text] NULL ,
	[Fdbk_Date] [datetime] NULL ,
	[Fdbk_Acceptor] [int] NULL ,
	[Fdbk_FinishDate] [datetime] NULL ,
	[Fdbk_Flag] [bit] NULL ,
	[Fdbk_Status] [varchar] (10) NULL ,
	[Fdbk_ExecEmp] [text] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[FW_Holiday] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NULL ,
	[ho_month] [smallint] NOT NULL ,
	[ho_day] [smallint] NOT NULL ,
	[ho_name] [varchar] (30) NOT NULL ,
	[ho_wish] [text] NULL ,
	[ho_remind] [char] (1) NULL ,
	[ho_ahead] [int] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[FW_MaintCard] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[MC_ID] [varchar] (20) NOT NULL ,
	[Prod_ID] [int] NOT NULL ,
	[MC_SerialNo] [varchar] (40) NULL ,
	[MC_BuyDate] [smalldatetime] NULL ,
	[Mc_TermDate] [smalldatetime] NULL ,
	[MC_Sell] [varchar] (100) NULL ,
	[MC_Acceptor] [int] NULL ,
	[cust_id] [int] NULL ,
	[mc_contact] [varchar] (32) NULL ,
	[mc_addr] [varchar] (128) NULL ,
	[mc_phone] [varchar] (32) NULL ,
	[mc_postcode] [varchar] (10) NULL ,
	[mc_email] [varchar] (64) NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[FW_MaintRec] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[MC_ID] [varchar] (20) NOT NULL ,
	[MR_Date] [datetime] NULL ,
	[MR_Desc] [varchar] (256) NULL ,
	[MR_Charge] [numeric](18, 4) NULL ,
	[MR_Status] [varchar] (10) NULL ,
	[MR_Repairer] [int] NULL ,
	[MR_TaskID] [varchar] (20) NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[FW_MaintTask] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[MR_ID] [varchar] (10) NOT NULL ,
	[MT_TaskID] [varchar] (10) NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[FW_SrvcRule] (
	[sr_ID] [int] NOT NULL ,
	[own_Id] [varchar] (10) NOT NULL ,
	[sr_Code] [varchar] (20) NOT NULL ,
	[sr_subject] [varchar] (100) NOT NULL ,
	[sr_content] [text] NULL ,
	[sr_type] [int] NULL ,
	[sr_dept] [int] NULL ,
	[sr_filename] [varchar] (100) NULL ,
	[sr_filepath] [varchar] (200) NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[JB_Contact] (
	[ct_id] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[ct_name] [nvarchar] (50) NOT NULL ,
	[ct_aid] [nvarchar] (10) NULL ,
	[ct_sex] [nvarchar] (50) NULL ,
	[ct_married] [bit] NULL ,
	[ct_birthday] [datetime] NULL ,
	[ct_title] [nvarchar] (50) NULL ,
	[ct_dept] [nvarchar] (50) NULL ,
	[ct_addr] [nvarchar] (100) NULL ,
	[ct_postcode] [varchar] (10) NULL ,
	[ct_phone] [varchar] (20) NULL ,
	[ct_fax] [varchar] (20) NULL ,
	[ct_mobile] [varchar] (20) NULL ,
	[ct_pager] [nvarchar] (100) NULL ,
	[ct_email] [nvarchar] (60) NULL ,
	[ct_Hphone] [nvarchar] (50) NULL ,
	[ct_biz] [nvarchar] (50) NULL ,
	[ct_memo] [text] NULL ,
	[ct_flag] [bit] NULL ,
	[ct_type] [varchar] (5) NULL ,
	[cust_id] [int] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[JB_CustContact] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[cust_id] [int] NOT NULL ,
	[contact_id] [int] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[JB_CustEvent] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[cust_id] [int] NULL ,
	[ce_subject] [nvarchar] (128) NULL ,
	[event_type] [int] NULL ,
	[contact_id] [int] NULL ,
	[emp_id] [int] NULL ,
	[ce_begin] [datetime] NULL ,
	[ce_end] [datetime] NULL ,
	[ce_info] [nvarchar] (128) NULL ,
	[ce_desc] [text] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[JB_CustInfo] (
	[CI_ID] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[CI_Code] [varchar] (10) NOT NULL ,
	[CI_Name] [nvarchar] (100) NOT NULL ,
	[CI_AID] [varchar] (10) NULL ,
	[CI_Type] [varchar] (5) NULL ,
	[CI_Abbr] [varchar] (20) NULL ,
	[Province_ID] [int] NULL ,
	[City_ID] [int] NULL ,
	[District_ID] [int] NULL ,
	[Area_ID] [int] NULL ,
	[GT_ID] [int] NULL ,
	[Trade_ID] [int] NULL ,
	[CK_ID] [int] NULL ,
	[CS_ID] [int] NULL ,
	[CI_Scale] [nvarchar] (20) NULL ,
	[CI_Fund] [numeric](18, 4) NULL ,
	[CI_Legal] [nvarchar] (50) NULL ,
	[CI_Addr] [nvarchar] (100) NULL ,
	[CI_PostCode] [varchar] (10) NULL ,
	[CI_Phone1] [varchar] (50) NULL ,
	[ci_phone2] [varchar] (50) NULL ,
	[CI_Fax] [varchar] (50) NULL ,
	[CI_Mobile] [varchar] (50) NULL ,
	[CI_Pager] [varchar] (50) NULL ,
	[CI_Email] [varchar] (60) NULL ,
	[CI_Web] [varchar] (50) NULL ,
	[CI_Bank] [varchar] (30) NULL ,
	[CI_Account] [varchar] (30) NULL ,
	[CI_Credit] [numeric](18, 4) NULL ,
	[CI_TotalSales] [numeric](18, 4) NULL ,
	[CI_Arrearage] [numeric](18, 4) NULL ,
	[CI_Turnover] [numeric](18, 4) NULL ,
	[Contact_ID] [int] NULL ,
	[Emp_ID] [int] NULL ,
	[CI_Forbid] [bit] NULL ,
	[CI_Desc] [text] NULL ,
	[CI_Int01] [int] NULL ,
	[CI_Int02] [int] NULL ,
	[CI_Int03] [int] NULL ,
	[CI_Dec01] [numeric](18, 4) NULL ,
	[CI_Dec02] [numeric](18, 4) NULL ,
	[CI_Dec03] [numeric](18, 4) NULL ,
	[CI_Char01] [varchar] (64) NULL ,
	[CI_Char02] [varchar] (64) NULL ,
	[CI_Char03] [varchar] (64) NULL ,
	[CI_Char04] [varchar] (64) NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[JB_CustRequire] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[cust_id] [int] NULL ,
	[cr_date] [datetime] NULL ,
	[cr_maker] [int] NULL ,
	[cr_kind] [int] NULL ,
	[cr_desc] [text] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[JB_EmpCust] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[cust_id] [int] NOT NULL ,
	[emp_id] [int] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[JB_RivalInfo] (
	[ri_id] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[cust_id] [int] NULL ,
	[RI_Type] [char] (10) NULL ,
	[RI_Name] [nvarchar] (50) NOT NULL ,
	[CK_ID] [int] NULL ,
	[Area_ID] [int] NULL ,
	[RI_Fund] [numeric](18, 4) NULL ,
	[RI_StaffNum] [int] NULL ,
	[RI_Turnover] [numeric](18, 4) NULL ,
	[RI_Addr] [nvarchar] (100) NULL ,
	[RI_PostCode] [varchar] (10) NULL ,
	[RI_Phone] [varchar] (20) NULL ,
	[RI_Fax] [varchar] (20) NULL ,
	[RI_Email] [varchar] (40) NULL ,
	[RI_Desc] [text] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[JB_RivalProd] (
	[own_id] [varchar] (10) NOT NULL ,
	[RI_ID] [int] NOT NULL ,
	[RP_ID] [int] NOT NULL ,
	[RP_Name] [nvarchar] (50) NOT NULL ,
	[RP_Type] [nvarchar] (50) NULL ,
	[RP_Unit] [nvarchar] (50) NULL ,
	[RP_Price] [numeric](18, 4) NULL ,
	[RP_Strength] [text] NULL ,
	[RP_Weakness] [text] NULL ,
	[RP_Tactic] [text] NULL ,
	[RP_Memo] [text] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[JB_SupplyInfo] (
	[SP_id] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[cust_id] [int] NULL ,
	[SP_Name] [nvarchar] (50) NOT NULL ,
	[SP_Contact] [nvarchar] (20) NULL ,
	[SP_Addr] [nvarchar] (100) NULL ,
	[SP_PostCode] [nvarchar] (10) NULL ,
	[SP_Phone] [nvarchar] (50) NULL ,
	[SP_Fax] [nvarchar] (50) NULL ,
	[SP_Email] [nvarchar] (50) NULL ,
	[SP_http] [nvarchar] (50) NULL ,
	[SP_Desc] [text] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[JC_ActResult] (
	[ar_id] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[ar_name] [nvarchar] (50) NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[JC_ActType] (
	[at_id] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[at_name] [nvarchar] (50) NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[JC_ActionDef] (
	[rid] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[dept_id] [varchar] (10) NULL ,
	[ad_Name] [nvarchar] (50) NOT NULL ,
	[ad_type] [varchar] (10) NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[JC_Area] (
	[area_id] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[area_code] [varchar] (20) NOT NULL ,
	[area_name] [nvarchar] (50) NOT NULL ,
	[area_rootid] [int] NULL ,
	[area_baseid] [int] NULL ,
	[levels] [int] NULL ,
	[path] [varchar] (100) NULL ,
	[parentID] [int] NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[JC_Campaign] (
	[rid] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[cp_content] [nvarchar] (50) NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[JC_CustKind] (
	[ck_id] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[ck_name] [nvarchar] (50) NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[JC_EventType] (
	[et_id] [int] NOT NULL ,
	[own_id] [varchar] (50) NULL ,
	[et_name] [nvarchar] (50) NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[JC_ExpenseType] (
	[et_id] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[et_name] [nvarchar] (50) NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[JC_GradeType] (
	[rid] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[gt_name] [nvarchar] (50) NOT NULL ,
	[gt_type] [varchar] (10) NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[JC_LostSales] (
	[rid] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[ls_content] [nvarchar] (50) NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[JC_OpptPhase] (
	[op_id] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[op_name] [nvarchar] (50) NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[JC_OpptStatus] (
	[os_id] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[os_name] [nvarchar] (50) NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[JC_OpptType] (
	[ot_id] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[ot_name] [nvarchar] (50) NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[JC_PayMode] (
	[pm_id] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[pm_name] [nvarchar] (50) NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[JC_Possible] (
	[rid] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[possible_scope] [varchar] (50) NULL ,
	[possible_max] [int] NULL ,
	[possible_min] [int] NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[JC_Progress] (
	[rid] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[prg_content] [nvarchar] (50) NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[JC_Region] (
	[JR_ID] [int] NOT NULL ,
	[own_id] [varchar] (20) NULL ,
	[JR_Name] [nvarchar] (20) NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[JC_RequireType] (
	[rt_id] [int] NOT NULL ,
	[own_id] [varchar] (10) NULL ,
	[rt_name] [nvarchar] (50) NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[JC_SourceType] (
	[rid] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[st_name] [nvarchar] (50) NOT NULL ,
	[st_type] [varchar] (10) NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[JC_TaskStatus] (
	[rid] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[ts_status] [nvarchar] (50) NULL ,
	[ts_type] [varchar] (10) NOT NULL ,
	[ts_delete] [bit] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[JC_Trade] (
	[trade_id] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[trade_name] [nvarchar] (50) NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[JC_TypeDef] (
	[td_id] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[td_name] [varchar] (50) NULL ,
	[td_type] [varchar] (10) NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[JC_Unit] (
	[rid] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[unit_name] [nvarchar] (50) NOT NULL ,
	[unit_spec] [varchar] (20) NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[JT_Owner] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[own_Name] [varchar] (100) NOT NULL ,
	[own_EngName] [varchar] (255) NULL ,
	[own_Abbr] [varchar] (20) NULL ,
	[own_Addr] [varchar] (100) NULL ,
	[own_Manager] [varchar] (20) NULL ,
	[own_web] [varchar] (100) NULL ,
	[own_Email] [varchar] (40) NULL ,
	[own_Phone] [varchar] (20) NULL ,
	[own_Fax] [varchar] (20) NULL ,
	[own_PostCode] [varchar] (10) NULL ,
	[own_City] [varchar] (20) NULL ,
	[own_Province] [varchar] (20) NULL ,
	[own_Flag] [bit] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[Pub_Attach] (
	[Att_id] [int] NOT NULL ,
	[Att_SrcType] [varchar] (20) NULL ,
	[Att_SrcID] [int] NULL ,
	[Att_Mime] [varchar] (50) NULL ,
	[Att_CreateDate] [datetime] NULL ,
	[Att_Subject] [nvarchar] (100) NULL ,
	[Att_FileName] [varchar] (256) NULL ,
	[Att_Desc] [text] NULL ,
	[Att_Flag] [bit] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[Pub_Attach_Content] (
	[Att_ID] [int] NOT NULL ,
	[Att_Content] [image] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[Pub_BillCode] (
	[Own_id] [varchar] (10) NOT NULL ,
	[BC_MaxID] [int] NOT NULL ,
	[BC_Type] [varchar] (10) NOT NULL ,
	[BC_Prefix] [varchar] (10) NULL ,
	[BC_SerialLen] [int] NULL ,
	[BC_Date] [datetime] NULL ,
	[BC_HasDate] [bit] NULL ,
	[BC_AutoIncrease] [bit] NULL ,
	[BC_Use] [bit] NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[Pub_Calendar] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[Emp_id] [int] NOT NULL ,
	[Cal_Date] [datetime] NOT NULL ,
	[Cal_StartTime] [datetime] NOT NULL ,
	[Cal_EndTime] [datetime] NULL ,
	[Cal_Subject] [varchar] (50) NOT NULL ,
	[Cal_Location] [varchar] (20) NULL ,
	[Cal_Type] [varchar] (20) NOT NULL ,
	[Task_ID] [varchar] (20) NULL ,
	[Cal_Desc] [text] NULL ,
	[Cal_Remind] [int] NULL ,
	[Cal_Feedback] [text] NULL ,
	[Cal_read] [char] (1) NULL ,
	[Cal_replier] [varchar] (20) NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[Pub_DefType] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[DT_ID] [varchar] (10) NOT NULL ,
	[DT_ParentName] [varchar] (30) NOT NULL ,
	[DT_PropName] [varchar] (30) NOT NULL ,
	[DT_DataType] [varchar] (10) NOT NULL ,
	[DT_DataLength] [int] NOT NULL ,
	[DT_Precision] [int] NOT NULL ,
	[DT_Location] [varchar] (10) NOT NULL ,
	[DT_Memo] [varchar] (100) NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[Pub_Email] (
	[Email_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[Email_Name] [varchar] (50) NULL ,
	[Email_Addr] [varchar] (50) NULL ,
	[Email_Flag] [char] (10) NULL ,
	[Type_ID] [int] NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[Pub_EmailBox] (
	[PE_ID] [int] NOT NULL ,
	[Emp_ID] [int] NULL ,
	[PE_SendAddr] [nvarchar] (50) NULL ,
	[PE_ReceAddr] [nvarchar] (50) NULL ,
	[PE_Subject] [nvarchar] (500) NULL ,
	[PE_Content] [ntext] NULL ,
	[PE_AttFlag] [char] (1) NULL ,
	[PE_Type] [varchar] (10) NULL ,
	[PE_InDate] [datetime] NULL ,
	[PE_Read] [char] (1) NULL ,
	[Message_ID] [varchar] (200) NULL ,
	[Att_File] [varchar] (200) NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[Pub_Event] (
	[pe_id] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[pe_subject] [nvarchar] (128) NULL ,
	[pe_type] [int] NULL ,
	[pe_Addr] [nvarchar] (255) NULL ,
	[pe_startdate] [datetime] NULL ,
	[pe_enddate] [datetime] NULL ,
	[pe_content] [text] NULL ,
	[pe_priority] [nvarchar] (20) NOT NULL ,
	[emp_id] [int] NULL ,
	[pe_empid] [int] NULL ,
	[pe_baseid] [int] NULL ,
	[pe_readed] [char] (1) NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[Pub_Login] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[Login_Name] [varchar] (20) NOT NULL ,
	[Login_Pwd] [varchar] (20) NULL ,
	[Login_Type] [varchar] (10) NULL ,
	[Login_Status] [bit] NULL ,
	[Emp_ID] [int] NOT NULL ,
	[Login_Forbid] [bit] NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[Pub_Meeting] (
	[PM_ID] [int] NOT NULL ,
	[Own_ID] [varchar] (50) NULL ,
	[Dept_ID] [int] NULL ,
	[Cust_ID] [int] NULL ,
	[PM_Date] [datetime] NULL ,
	[PM_Subject] [nvarchar] (200) NULL ,
	[PM_Manager] [varchar] (50) NULL ,
	[Emp_ID] [int] NULL ,
	[PM_Docent] [varchar] (50) NULL ,
	[PM_Count] [int] NULL ,
	[PM_Standard] [varchar] (50) NULL ,
	[PM_InCome] [numeric](18, 4) NULL ,
	[PM_PayOut] [numeric](18, 4) NULL ,
	[PM_Balance] [numeric](18, 4) NULL ,
	[PM_Charge] [numeric](18, 4) NULL ,
	[PM_Profit] [numeric](18, 4) NULL ,
	[PM_Memo] [text] NULL ,
	[PM_Discount] [varchar] (50) NULL ,
	[PM_Type] [varchar] (50) NULL ,
	[PM_Flag] [varchar] (2) NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[Pub_Memo] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[M_Title] [nvarchar] (255) NULL ,
	[M_Content] [text] NULL ,
	[M_Date] [datetime] NULL ,
	[Emp_ID] [int] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[Pub_MsgBoard] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[MB_Subject] [varchar] (100) NULL ,
	[MB_Time] [datetime] NULL ,
	[MB_Content] [text] NULL ,
	[Emp_ID] [int] NULL ,
	[MB_Sender] [int] NULL ,
	[MB_Read] [bit] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[Pub_Pending] (
	[PD_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[Emp_ID] [int] NOT NULL ,
	[PD_Status] [int] NULL ,
	[PD_Subject] [varchar] (50) NULL ,
	[PD_TgtID] [int] NULL ,
	[PD_TgtName] [varchar] (100) NULL ,
	[PD_Type] [varchar] (20) NULL ,
	[PD_Date] [datetime] NULL ,
	[PD_FinDate] [datetime] NULL ,
	[PD_TaskID] [int] NULL ,
	[PD_Read] [bit] NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[Pub_Progress] (
	[prg_ID] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[Task_Id] [int] NULL ,
	[Prg_Code] [varchar] (20) NOT NULL ,
	[Prg_Type] [char] (10) NULL ,
	[prg_objID] [int] NULL ,
	[prg_objType] [nvarchar] (10) NULL ,
	[prg_contactID] [int] NULL ,
	[Prg_Executor] [int] NULL ,
	[Prg_Subject] [varchar] (50) NULL ,
	[Prg_StartDate] [datetime] NULL ,
	[Prg_EndDate] [datetime] NULL ,
	[Prg_Action] [int] NULL ,
	[Prg_CampType] [int] NULL ,
	[Prg_Cost] [numeric](18, 4) NULL ,
	[Prg_Desc] [text] NULL ,
	[prg_finish] [char] (1) NULL ,
	[prg_priority] [nvarchar] (10) NULL ,
	[prg_Result] [int] NULL ,
	[Prg_Memo] [text] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[Pub_Session] (
	[session_id] [varchar] (128) NOT NULL ,
	[session_ip] [varchar] (30) NULL ,
	[session_time] [datetime] NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[Pub_Task] (
	[Task_ID] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[Task_Code] [varchar] (20) NULL ,
	[Task_Subject] [varchar] (50) NOT NULL ,
	[Task_ObjID] [int] NULL ,
	[Task_Object] [varchar] (100) NULL ,
	[Task_ObjType] [varchar] (10) NULL ,
	[Task_Type] [varchar] (10) NULL ,
	[Task_Manager] [int] NULL ,
	[Task_Status] [int] NULL ,
	[Task_StartDate] [datetime] NULL ,
	[Task_priority] [varchar] (20) NULL ,
	[Task_EndDate] [datetime] NULL ,
	[Task_Budget] [numeric](18, 4) NULL ,
	[Task_Cost] [numeric](18, 4) NULL ,
	[Task_Flag] [char] (1) NULL ,
	[Task_Result] [nvarchar] (255) NULL ,
	[Task_Desc] [text] NULL ,
	[Task_Source] [int] NULL ,
	[Contact_ID] [int] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[Pub_Template] (
	[temp_id] [int] IDENTITY (1, 1) NOT NULL ,
	[temp_name] [nvarchar] (100) NULL ,
	[temp_type] [nvarchar] (50) NULL ,
	[temp_CoName] [nvarchar] (100) NULL ,
	[temp_CoEngName] [nvarchar] (255) NULL ,
	[temp_Content] [text] NULL ,
	[temp_Manager] [nvarchar] (50) NULL ,
	[temp_Flag] [char] (10) NULL ,
	[emp_id] [int] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_ActExpense] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[act_id] [int] NULL ,
	[ae_type] [int] NULL ,
	[ae_expense] [numeric](18, 4) NULL ,
	[ae_date] [datetime] NULL ,
	[emp_id] [int] NULL ,
	[ae_checker] [int] NULL ,
	[ae_memo] [nvarchar] (128) NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_Activity] (
	[act_id] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[oppt_id] [int] NULL ,
	[act_subject] [nvarchar] (100) NULL ,
	[cust_id] [int] NULL ,
	[act_type] [int] NULL ,
	[act_action] [int] NULL ,
	[act_priority] [nvarchar] (10) NULL ,
	[act_createdate] [datetime] NULL ,
	[act_start] [datetime] NULL ,
	[act_end] [datetime] NULL ,
	[act_duration] [int] NULL ,
	[act_finish] [bit] NULL ,
	[act_result] [int] NULL ,
	[act_expense] [numeric](18, 4) NULL ,
	[act_maker] [int] NULL ,
	[act_executor] [int] NULL ,
	[act_memo] [nvarchar] (200) NULL ,
	[act_closedesc] [nvarchar] (200) NULL ,
	[contact_id] [int] NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_BaseRec] (
	[XB_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [nvarchar] (10) NULL ,
	[Cont_ID] [int] NOT NULL ,
	[XB_Date] [datetime] NOT NULL ,
	[XB_Amount] [int] NOT NULL ,
	[XB_Content] [nvarchar] (50) NULL ,
	[XB_Desc] [text] NULL ,
	[Emp_ID] [int] NOT NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_ConChgRec] (
	[XC_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [nvarchar] (10) NULL ,
	[Cont_ID] [int] NOT NULL ,
	[XC_Date] [datetime] NOT NULL ,
	[XC_Amount] [int] NOT NULL ,
	[XC_Content] [nvarchar] (50) NULL ,
	[XC_Desc] [text] NULL ,
	[Emp_ID] [int] NOT NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_Contract] (
	[CR_ID] [int] NOT NULL ,
	[Own_ID] [varchar] (50) NOT NULL ,
	[CR_Code] [varchar] (50) NOT NULL ,
	[Cust_ID] [int] NULL ,
	[So_ID] [int] NULL ,
	[CR_Type] [int] NULL ,
	[CR_Sale] [int] NULL ,
	[CR_Manager] [int] NULL ,
	[CR_Advisor] [int] NULL ,
	[Contact_ID] [int] NULL ,
	[CR_SignDate] [datetime] NULL ,
	[CR_StartDate] [datetime] NULL ,
	[CR_PreDate] [datetime] NULL ,
	[CR_FactDate] [datetime] NULL ,
	[CR_PreDays] [int] NULL ,
	[CR_FactDays] [int] NULL ,
	[CR_Amount] [numeric](18, 4) NULL ,
	[CR_RecDate] [datetime] NULL ,
	[CR_RecAmount] [numeric](18, 4) NULL ,
	[CR_Evection] [nvarchar] (100) NULL ,
	[CR_Check] [char] (1) NULL ,
	[CR_rule] [nvarchar] (100) NULL ,
	[CR_Schedule] [int] NULL ,
	[CR_Feedback] [nvarchar] (255) NULL ,
	[CR_Attest] [char] (1) NULL ,
	[CR_AttCompany] [nvarchar] (50) NULL ,
	[CR_Memo] [text] NULL ,
	[CR_ReferRate] [numeric](18, 0) NULL ,
	[CR_TrainRate] [numeric](18, 0) NULL ,
	[CR_Flag] [varchar] (2) NULL ,
	[CR_Discount] [numeric](18, 2) NULL ,
	[CR_Reason] [nvarchar] (50) NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_ContractDetail] (
	[CD_ID] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[CT_ID] [varchar] (10) NOT NULL ,
	[CD_Title] [varchar] (50) NULL ,
	[CD_levels] [int] NULL ,
	[CD_parentid] [int] NULL ,
	[CD_Content] [text] NULL ,
	[CD_path] [varchar] (100) NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_ContractText] (
	[CT_ID] [int] NOT NULL ,
	[own_id] [nvarchar] (10) NULL ,
	[CT_Name] [nvarchar] (50) NULL ,
	[CT_Type] [int] NULL ,
	[CT_Desc] [nvarchar] (200) NULL ,
	[XC_ID] [int] NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_CustFunds] (
	[own_id] [varchar] (10) NOT NULL ,
	[cust_id] [int] NOT NULL ,
	[cf_amountinit] [numeric](18, 4) NULL ,
	[cf_profitinit] [numeric](18, 4) NULL ,
	[cf_receiveinit] [numeric](18, 4) NULL ,
	[cf_amount] [numeric](18, 0) NULL ,
	[cf_profit] [numeric](18, 4) NULL ,
	[cf_receive] [numeric](18, 4) NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_Opportunity] (
	[oppt_id] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[oppt_subject] [nvarchar] (128) NULL ,
	[cust_id] [int] NULL ,
	[oppt_source] [int] NULL ,
	[oppt_type] [int] NULL ,
	[oppt_phase] [int] NULL ,
	[phase_id] [int] NULL ,
	[oppt_status] [int] NULL ,
	[oppt_valuable] [nvarchar] (20) NULL ,
	[oppt_createdate] [smalldatetime] NULL ,
	[oppt_start] [smalldatetime] NULL ,
	[oppt_end] [smalldatetime] NULL ,
	[oppt_close] [bit] NULL ,
	[oppt_succeed] [bit] NULL ,
	[oppt_reason] [int] NULL ,
	[oppt_closedate] [smalldatetime] NULL ,
	[oppt_closedesc] [nvarchar] (200) NULL ,
	[oppt_maker] [int] NULL ,
	[oppt_manager] [int] NULL ,
	[oppt_revenue] [numeric](18, 4) NULL ,
	[oppt_probability] [numeric](18, 4) NULL ,
	[oppt_memo] [nvarchar] (200) NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_OpptContact] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NULL ,
	[oppt_id] [int] NULL ,
	[contact_id] [int] NULL ,
	[oc_main] [bit] NULL ,
	[oc_degree] [nvarchar] (64) NULL ,
	[oc_force] [nvarchar] (64) NULL ,
	[oc_tactic] [nvarchar] (128) NULL ,
	[oc_memo] [nvarchar] (128) NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_OpptEmp] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[oppt_id] [int] NULL ,
	[emp_id] [int] NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_OpptPhase] (
	[phase_id] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[oppt_id] [int] NOT NULL ,
	[oppt_phase] [int] NOT NULL ,
	[phase_begin] [datetime] NULL ,
	[phase_end] [datetime] NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_OpptProd] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NULL ,
	[oppt_id] [int] NULL ,
	[prod_id] [int] NULL ,
	[op_price] [numeric](18, 4) NULL ,
	[op_qty] [numeric](18, 4) NULL ,
	[op_amount] [numeric](18, 4) NULL ,
	[op_memo] [nvarchar] (128) NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_OpptRival] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[oppt_id] [int] NOT NULL ,
	[ri_id] [int] NULL ,
	[rp_id] [int] NULL ,
	[or_main] [bit] NULL ,
	[or_strength] [nvarchar] (200) NULL ,
	[or_weakness] [nvarchar] (200) NULL ,
	[or_tactic] [nvarchar] (200) NULL ,
	[or_memo] [text] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_Plan_D] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[plan_id] [int] NOT NULL ,
	[plan_object] [int] NOT NULL ,
	[plan_type] [varchar] (10) NULL ,
	[plan_year] [int] NULL ,
	[plan_month1] [numeric](18, 4) NULL ,
	[plan_month2] [numeric](18, 4) NULL ,
	[plan_month3] [numeric](18, 4) NULL ,
	[plan_month4] [numeric](18, 4) NULL ,
	[plan_month5] [numeric](18, 4) NULL ,
	[plan_month6] [numeric](18, 4) NULL ,
	[plan_month7] [numeric](18, 4) NULL ,
	[plan_month8] [numeric](18, 4) NULL ,
	[plan_month9] [numeric](18, 4) NULL ,
	[plan_month10] [numeric](18, 4) NULL ,
	[plan_month11] [numeric](18, 4) NULL ,
	[plan_month12] [numeric](18, 4) NULL ,
	[plan_subtotal] [numeric](18, 4) NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_Plan_H] (
	[plan_id] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[plan_code] [varchar] (20) NULL ,
	[plan_type] [varchar] (10) NULL ,
	[plan_subject] [nvarchar] (128) NULL ,
	[plan_year] [int] NULL ,
	[plan_maker] [int] NULL ,
	[plan_amount] [numeric](18, 4) NULL ,
	[plan_createdate] [smalldatetime] NULL ,
	[plan_memo] [nvarchar] (128) NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_Plan_Temp_D] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[plan_id] [int] NOT NULL ,
	[plan_object] [int] NOT NULL ,
	[emp_id] [int] NOT NULL ,
	[plan_type] [varchar] (10) NULL ,
	[plan_year] [int] NULL ,
	[plan_month1] [numeric](18, 4) NULL ,
	[plan_month2] [numeric](18, 4) NULL ,
	[plan_month3] [numeric](18, 4) NULL ,
	[plan_month4] [numeric](18, 4) NULL ,
	[plan_month5] [numeric](18, 4) NULL ,
	[plan_month6] [numeric](18, 4) NULL ,
	[plan_month7] [numeric](18, 4) NULL ,
	[plan_month8] [numeric](18, 4) NULL ,
	[plan_month9] [numeric](18, 4) NULL ,
	[plan_month10] [numeric](18, 4) NULL ,
	[plan_month11] [numeric](18, 4) NULL ,
	[plan_month12] [numeric](18, 4) NULL ,
	[plan_subtotal] [numeric](18, 4) NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_QP_D] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[qp_id] [int] NOT NULL ,
	[prod_id] [int] NOT NULL ,
	[qp_discount] [numeric](18, 4) NULL ,
	[qp_taxrate] [numeric](18, 4) NULL ,
	[qp_price] [numeric](18, 4) NULL ,
	[qp_lastprice] [numeric](18, 4) NULL ,
	[qp_qty] [numeric](18, 4) NULL ,
	[qp_amount] [numeric](18, 4) NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_QP_H] (
	[qp_id] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[qp_code] [varchar] (20) NOT NULL ,
	[cust_id] [int] NOT NULL ,
	[contact_id] [int] NULL ,
	[oppt_id] [int] NULL ,
	[qp_date] [smalldatetime] NULL ,
	[qp_createdate] [smalldatetime] NULL ,
	[qp_memo] [text] NULL ,
	[qp_maker] [int] NULL ,
	[qp_sales] [int] NULL ,
	[qp_checker] [int] NULL ,
	[qp_amount] [numeric](18, 4) NULL ,
	[qp_check] [char] (1) NULL ,
	[qp_close] [bit] NULL ,
	[qp_closedate] [smalldatetime] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_SO_D] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[so_id] [int] NOT NULL ,
	[prod_id] [int] NOT NULL ,
	[so_price] [numeric](18, 4) NULL ,
	[so_discount] [numeric](18, 4) NULL ,
	[so_taxrate] [numeric](18, 4) NULL ,
	[so_lastprice] [numeric](18, 4) NULL ,
	[so_qty] [numeric](18, 4) NULL ,
	[so_deliveryqty] [numeric](18, 4) NULL ,
	[so_amount] [numeric](18, 4) NULL ,
	[so_qp_id] [int] NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_SO_Delivery] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[so_id] [int] NOT NULL ,
	[prod_id] [int] NOT NULL ,
	[del_date] [smalldatetime] NULL ,
	[del_qty] [numeric](18, 4) NULL ,
	[del_operator] [int] NULL ,
	[del_memo] [nvarchar] (128) NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_SO_H] (
	[so_id] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[so_code] [varchar] (20) NOT NULL ,
	[cust_id] [int] NOT NULL ,
	[so_createdate] [smalldatetime] NULL ,
	[so_deliverydate] [smalldatetime] NULL ,
	[so_deliveryaddr] [nvarchar] (50) NULL ,
	[so_sales] [int] NULL ,
	[contact_id] [int] NULL ,
	[oppt_id] [int] NULL ,
	[so_source] [int] NULL ,
	[so_maker] [int] NULL ,
	[so_checker] [int] NULL ,
	[so_memo] [nvarchar] (128) NULL ,
	[so_check] [char] (1) NULL ,
	[so_amount] [numeric](18, 4) NULL ,
	[so_profit] [numeric](18, 4) NULL ,
	[so_paidamount] [numeric](18, 4) NULL ,
	[so_close] [bit] NULL ,
	[so_closedate] [smalldatetime] NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_SO_Receive] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[so_id] [int] NULL ,
	[rec_date] [smalldatetime] NULL ,
	[rec_amount] [numeric](18, 0) NULL ,
	[rec_mode] [int] NULL ,
	[rec_sales] [int] NULL ,
	[rec_memo] [nvarchar] (128) NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_Temp_D] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[emp_id] [int] NOT NULL ,
	[note_code] [varchar] (20) NOT NULL ,
	[prod_id] [int] NULL ,
	[price] [numeric](18, 4) NULL ,
	[lastprice] [numeric](18, 4) NULL ,
	[discount] [numeric](18, 4) NULL ,
	[taxrate] [numeric](18, 4) NULL ,
	[qty] [numeric](18, 4) NULL ,
	[amount] [numeric](18, 4) NULL ,
	[rel_note_id] [int] NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_Thread] (
	[XT_ID] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [nvarchar] (10) NULL ,
	[XT_Code] [nvarchar] (20) NULL ,
	[XT_Name] [nvarchar] (50) NULL ,
	[XT_Source] [int] NULL ,
	[XT_CreateDate] [datetime] NULL ,
	[XT_Contact] [nvarchar] (20) NULL ,
	[XT_Title] [nvarchar] (20) NULL ,
	[XT_ConTel] [nvarchar] (20) NULL ,
	[XT_Email] [nvarchar] (50) NULL ,
	[XT_Sex] [nvarchar] (2) NULL ,
	[XT_Company] [nvarchar] (50) NULL ,
	[Xt_Trade] [int] NULL ,
	[XT_CoAddr] [nvarchar] (100) NULL ,
	[XT_CoTel] [nvarchar] (20) NULL ,
	[XT_Area] [int] NULL ,
	[XT_Region] [int] NULL ,
	[XT_Desc] [text] NULL ,
	[Emp_ID] [int] NULL ,
	[XT_Check] [char] (1) NULL ,
	[Cust_ID] [int] NULL ,
	[Contact_ID] [int] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[XS_ThreadAction] (
	[TA_ID] [int] NOT NULL ,
	[own_id] [nvarchar] (10) NULL ,
	[XT_ID] [int] NULL ,
	[TA_Subject] [nvarchar] (50) NULL ,
	[TA_StartDate] [datetime] NULL ,
	[TA_EndDate] [datetime] NULL ,
	[TA_Sort] [int] NULL ,
	[TA_ExecEmp] [int] NULL ,
	[TA_Desc] [text] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[XT_Approve] (
	[emp_id] [int] NOT NULL ,
	[doc_type] [varchar] (10) NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[XT_Dept] (
	[Dept_ID] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[Dept_Code] [varchar] (10) NOT NULL ,
	[Dept_Name] [varchar] (50) NOT NULL ,
	[Dept_levels] [int] NULL ,
	[Dept_parentid] [int] NULL ,
	[Dept_path] [varchar] (100) NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[XT_Employee] (
	[Emp_ID] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[Emp_Code] [varchar] (10) NOT NULL ,
	[Emp_Name] [varchar] (40) NOT NULL ,
	[Emp_IdCard] [varchar] (20) NULL ,
	[Emp_Sex] [varchar] (2) NULL ,
	[Emp_Birthday] [datetime] NULL ,
	[Emp_Native] [varchar] (40) NULL ,
	[Emp_Education] [varchar] (20) NULL ,
	[Dept_ID] [int] NULL ,
	[Emp_Title] [varchar] (20) NULL ,
	[Emp_Ophone] [varchar] (20) NULL ,
	[Emp_Mobile] [varchar] (20) NULL ,
	[Emp_Hphone] [varchar] (20) NULL ,
	[Emp_Email] [varchar] (60) NULL ,
	[Emp_Role] [varchar] (10) NULL ,
	[Emp_Addr] [varchar] (100) NULL ,
	[Emp_Forbid] [bit] NULL ,
	[Emp_Picture] [int] NULL ,
	[Emp_Memo] [text] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[XT_Log] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[log_time] [datetime] NOT NULL ,
	[Emp_ID] [int] NOT NULL ,
	[Log_Name] [varchar] (20) NOT NULL ,
	[Log_Action] [varchar] (20) NULL ,
	[Log_Table] [varchar] (20) NULL ,
	[Log_IP] [varchar] (20) NULL ,
	[Log_Desc] [varchar] (128) NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[XT_Module] (
	[mod_id] [int] NOT NULL ,
	[mod_code] [varchar] (10) NULL ,
	[mod_name] [varchar] (30) NOT NULL ,
	[mod_type] [varchar] (5) NULL ,
	[mod_seq] [int] NOT NULL ,
	[mod_parent] [int] NOT NULL ,
	[mod_level] [int] NULL ,
	[mod_HaveSub] [bit] NULL ,
	[mod_read] [bit] NULL ,
	[mod_edit] [bit] NULL ,
	[mod_delete] [bit] NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[XT_Role] (
	[role_id] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[role_name] [nvarchar] (50) NOT NULL ,
	[role_right] [varchar] (100) NULL ,
	[role_desc] [nvarchar] (128) NULL ,
	[role_customer] [char] (1) NULL ,
	[role_contact] [char] (1) NULL ,
	[role_oppt] [char] (1) NULL ,
	[role_act] [char] (1) NULL ,
	[role_qp] [char] (1) NULL ,
	[role_so] [char] (1) NULL ,
	[role_service] [char] (1) NULL ,
	[role_care] [char] (1) NULL ,
	[role_market] [char] (1) NULL ,
	[role_meeting] [char] (1) NULL ,
	[role_train] [char] (1) NULL ,
	[role_cont] [char] (1) NULL ,
	[role_calendar] [char] (1) NULL ,
	[role_email] [char] (1) NULL ,
	[role_event] [char] (1) NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[ZS_DocInfo] (
	[DI_ID] [int] NOT NULL ,
	[own_Id] [varchar] (10) NOT NULL ,
	[DI_Code] [varchar] (20) NOT NULL ,
	[DI_subject] [varchar] (100) NOT NULL ,
	[DI_content] [text] NULL ,
	[DT_ID] [int] NULL ,
	[DI_FileName] [varchar] (200) NULL ,
	[DI_FilePath] [varchar] (200) NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[ZS_DocType] (
	[DT_ID] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[DT_Code] [varchar] (10) NOT NULL ,
	[DT_Name] [varchar] (50) NOT NULL ,
	[DT_levels] [int] NULL ,
	[DT_parentid] [int] NULL ,
	[DT_path] [varchar] (100) NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[ZS_KnowInfo] (
	[KI_ID] [int] NOT NULL ,
	[own_Id] [varchar] (10) NOT NULL ,
	[KI_Code] [varchar] (20) NOT NULL ,
	[KI_subject] [varchar] (100) NOT NULL ,
	[KI_content] [text] NULL ,
	[KT_ID] [int] NULL ,
	[KI_FileName] [varchar] (200) NULL ,
	[KI_FilePath] [varchar] (200) NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[ZS_KnowType] (
	[KT_ID] [int] NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[KT_Code] [varchar] (10) NOT NULL ,
	[KT_Name] [varchar] (50) NOT NULL ,
	[KT_levels] [int] NULL ,
	[KT_parentid] [int] NULL ,
	[KT_path] [varchar] (100) NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[prg_expense] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[own_id] [varchar] (10) NOT NULL ,
	[prg_id] [int] NOT NULL ,
	[cust_id] [int] NULL ,
	[pe_expense] [numeric](18, 4) NULL ,
	[pe_type] [int] NULL ,
	[pe_date] [datetime] NULL ,
	[pe_checker] [int] NULL ,
	[emp_id] [int] NULL ,
	[pe_desc] [nvarchar] (255) NULL ,
	[pe_srctype] [varchar] (20) NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[pub_bbsforum] (
	[rid] [int] IDENTITY (1, 1) NOT NULL ,
	[Own_ID] [varchar] (10) NOT NULL ,
	[BF_Type] [char] (1) NULL ,
	[Emp_ID] [int] NULL ,
	[BF_levels] [varchar] (50) NULL ,
	[BF_Title] [varchar] (300) NULL ,
	[BF_Content] [text] NULL ,
	[BF_Date] [datetime] NULL ,
	[BF_Clickcount] [int] NULL ,
	[BF_replycount] [int] NULL ,
	[BF_imageid] [char] (10) NULL ,
	[BF_rootid] [int] NULL ,
	[BF_baseid] [int] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[xs_CrtExpense] (
	[ce_id] [int] NOT NULL ,
	[own_id] [char] (10) NULL ,
	[cr_id] [int] NULL ,
	[task_id] [int] NULL ,
	[ce_name] [varchar] (100) NULL ,
	[ce_days] [int] NULL ,
	[ce_charge] [numeric](18, 0) NULL ,
	[ce_chargerate] [char] (10) NULL 
) ON [PRIMARY]
GO

ALTER TABLE [dbo].[CP_ProdInfo] WITH NOCHECK ADD 
	CONSTRAINT [PK_CP_ProdInfo] PRIMARY KEY  CLUSTERED 
	(
		[Prod_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[CP_ProdType] WITH NOCHECK ADD 
	CONSTRAINT [PK_CP_ProdType] PRIMARY KEY  CLUSTERED 
	(
		[PT_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[FW_CareAdvice] WITH NOCHECK ADD 
	CONSTRAINT [PK_FW_CareAdvice] PRIMARY KEY  CLUSTERED 
	(
		[Ca_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[FW_FdbkPrg] WITH NOCHECK ADD 
	CONSTRAINT [PK_FW_FdbkPrg] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[FW_FdbkTask] WITH NOCHECK ADD 
	CONSTRAINT [PK_FW_FdbkTask] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[FW_Feedback] WITH NOCHECK ADD 
	CONSTRAINT [PK_FW_Feedback] PRIMARY KEY  CLUSTERED 
	(
		[own_id],
		[Fdbk_Code]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[FW_Holiday] WITH NOCHECK ADD 
	CONSTRAINT [PK_FW_Holiday] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[FW_MaintCard] WITH NOCHECK ADD 
	CONSTRAINT [PK_FW_MaintCard] PRIMARY KEY  CLUSTERED 
	(
		[own_id],
		[MC_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[FW_MaintRec] WITH NOCHECK ADD 
	CONSTRAINT [PK_FW_MaintRec] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[FW_MaintTask] WITH NOCHECK ADD 
	CONSTRAINT [PK_FW_MaintTask] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[FW_SrvcRule] WITH NOCHECK ADD 
	CONSTRAINT [PK_FW_SrvcRule] PRIMARY KEY  CLUSTERED 
	(
		[own_Id],
		[sr_Code]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JB_Contact] WITH NOCHECK ADD 
	CONSTRAINT [PK_JB_Contact] PRIMARY KEY  CLUSTERED 
	(
		[ct_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JB_CustContact] WITH NOCHECK ADD 
	CONSTRAINT [PK_JB_CustContact] PRIMARY KEY  CLUSTERED 
	(
		[own_id],
		[cust_id],
		[contact_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JB_CustEvent] WITH NOCHECK ADD 
	CONSTRAINT [PK_JB_CustEvent] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JB_CustInfo] WITH NOCHECK ADD 
	CONSTRAINT [PK_JB_CustInfo] PRIMARY KEY  CLUSTERED 
	(
		[CI_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JB_CustRequire] WITH NOCHECK ADD 
	CONSTRAINT [PK_JB_CustRequire] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JB_EmpCust] WITH NOCHECK ADD 
	CONSTRAINT [PK_JB_EmpCust] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JB_RivalInfo] WITH NOCHECK ADD 
	CONSTRAINT [PK_JB_RivalInfo] PRIMARY KEY  CLUSTERED 
	(
		[ri_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JB_RivalProd] WITH NOCHECK ADD 
	CONSTRAINT [PK_JB_RivalProd] PRIMARY KEY  CLUSTERED 
	(
		[RP_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JB_SupplyInfo] WITH NOCHECK ADD 
	CONSTRAINT [PK_JB_SupplyInfo] PRIMARY KEY  CLUSTERED 
	(
		[SP_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JC_ActResult] WITH NOCHECK ADD 
	CONSTRAINT [PK_JC_ActResult] PRIMARY KEY  CLUSTERED 
	(
		[ar_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JC_ActType] WITH NOCHECK ADD 
	CONSTRAINT [PK_JC_ActType] PRIMARY KEY  CLUSTERED 
	(
		[at_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JC_ActionDef] WITH NOCHECK ADD 
	CONSTRAINT [PK_JC_ActionDef] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JC_Area] WITH NOCHECK ADD 
	CONSTRAINT [PK_JC_Area] PRIMARY KEY  CLUSTERED 
	(
		[area_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JC_Campaign] WITH NOCHECK ADD 
	CONSTRAINT [PK_JC_Campaign] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JC_CustKind] WITH NOCHECK ADD 
	CONSTRAINT [PK_JC_CustKind] PRIMARY KEY  CLUSTERED 
	(
		[ck_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JC_EventType] WITH NOCHECK ADD 
	CONSTRAINT [PK_jc_eventtype] PRIMARY KEY  CLUSTERED 
	(
		[et_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JC_ExpenseType] WITH NOCHECK ADD 
	CONSTRAINT [PK_JC_ExpenseType] PRIMARY KEY  CLUSTERED 
	(
		[et_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JC_GradeType] WITH NOCHECK ADD 
	CONSTRAINT [PK_JC_GradeType] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JC_LostSales] WITH NOCHECK ADD 
	CONSTRAINT [PK_JC_LostSales] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JC_OpptPhase] WITH NOCHECK ADD 
	CONSTRAINT [PK_JC_OpptPhase] PRIMARY KEY  CLUSTERED 
	(
		[op_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JC_OpptStatus] WITH NOCHECK ADD 
	CONSTRAINT [PK_JC_OpptStatus] PRIMARY KEY  CLUSTERED 
	(
		[os_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JC_OpptType] WITH NOCHECK ADD 
	CONSTRAINT [PK_JC_OpptType] PRIMARY KEY  CLUSTERED 
	(
		[ot_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JC_PayMode] WITH NOCHECK ADD 
	CONSTRAINT [PK_JC_PayMode] PRIMARY KEY  CLUSTERED 
	(
		[pm_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JC_Possible] WITH NOCHECK ADD 
	CONSTRAINT [PK_jc_possible] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JC_Progress] WITH NOCHECK ADD 
	CONSTRAINT [PK_JC_Progress] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JC_Region] WITH NOCHECK ADD 
	CONSTRAINT [PK_JC_Region] PRIMARY KEY  CLUSTERED 
	(
		[JR_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JC_RequireType] WITH NOCHECK ADD 
	CONSTRAINT [PK_JC_RequireType] PRIMARY KEY  CLUSTERED 
	(
		[rt_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JC_SourceType] WITH NOCHECK ADD 
	CONSTRAINT [PK_JC_SourceType] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JC_TaskStatus] WITH NOCHECK ADD 
	CONSTRAINT [PK_JC_TaskStatus] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JC_Trade] WITH NOCHECK ADD 
	CONSTRAINT [PK_JC_Tread] PRIMARY KEY  CLUSTERED 
	(
		[trade_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JC_TypeDef] WITH NOCHECK ADD 
	CONSTRAINT [PK_JC_TypeDef] PRIMARY KEY  CLUSTERED 
	(
		[td_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JC_Unit] WITH NOCHECK ADD 
	CONSTRAINT [PK_JC_Unit] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[JT_Owner] WITH NOCHECK ADD 
	CONSTRAINT [PK_JT_Owner] PRIMARY KEY  CLUSTERED 
	(
		[own_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[Pub_Attach] WITH NOCHECK ADD 
	CONSTRAINT [PK_Pub_Attach] PRIMARY KEY  CLUSTERED 
	(
		[Att_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[Pub_Attach_Content] WITH NOCHECK ADD 
	CONSTRAINT [PK_Pub_Attach_Content] PRIMARY KEY  CLUSTERED 
	(
		[Att_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[Pub_BillCode] WITH NOCHECK ADD 
	CONSTRAINT [PK_Pub_BillCode] PRIMARY KEY  CLUSTERED 
	(
		[Own_id],
		[BC_Type]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[Pub_Calendar] WITH NOCHECK ADD 
	CONSTRAINT [PK_Pub_Calendar] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[Pub_DefType] WITH NOCHECK ADD 
	CONSTRAINT [PK_Pub_DefType] PRIMARY KEY  CLUSTERED 
	(
		[own_id],
		[DT_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[Pub_Email] WITH NOCHECK ADD 
	CONSTRAINT [PK_Pub_Email] PRIMARY KEY  CLUSTERED 
	(
		[Email_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[Pub_EmailBox] WITH NOCHECK ADD 
	CONSTRAINT [PK_Pub_EmailBox] PRIMARY KEY  CLUSTERED 
	(
		[PE_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[Pub_Event] WITH NOCHECK ADD 
	CONSTRAINT [PK_Pub_Event] PRIMARY KEY  CLUSTERED 
	(
		[pe_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[Pub_Login] WITH NOCHECK ADD 
	CONSTRAINT [PK_Pub_Login] PRIMARY KEY  CLUSTERED 
	(
		[Login_Name]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[Pub_Meeting] WITH NOCHECK ADD 
	CONSTRAINT [PK_Pub_Meeting] PRIMARY KEY  CLUSTERED 
	(
		[PM_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[Pub_Memo] WITH NOCHECK ADD 
	CONSTRAINT [PK_Pub_Memo] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[Pub_MsgBoard] WITH NOCHECK ADD 
	CONSTRAINT [PK_Pub_MsgBoard] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[Pub_Pending] WITH NOCHECK ADD 
	CONSTRAINT [PK_Pub_Pending] PRIMARY KEY  CLUSTERED 
	(
		[PD_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[Pub_Progress] WITH NOCHECK ADD 
	CONSTRAINT [PK_Pub_Progress] PRIMARY KEY  CLUSTERED 
	(
		[own_id],
		[Prg_Code]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[Pub_Session] WITH NOCHECK ADD 
	CONSTRAINT [PK_Pub_Session] PRIMARY KEY  CLUSTERED 
	(
		[session_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[Pub_Task] WITH NOCHECK ADD 
	CONSTRAINT [PK_Pub_Task] PRIMARY KEY  CLUSTERED 
	(
		[Task_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XS_ActExpense] WITH NOCHECK ADD 
	CONSTRAINT [PK_XS_ActExpense] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XS_Activity] WITH NOCHECK ADD 
	CONSTRAINT [PK_XS_Activity] PRIMARY KEY  CLUSTERED 
	(
		[act_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XS_ConChgRec] WITH NOCHECK ADD 
	CONSTRAINT [PK_XS_ConChgRec] PRIMARY KEY  CLUSTERED 
	(
		[XC_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XS_Contract] WITH NOCHECK ADD 
	CONSTRAINT [PK_XS_Contract] PRIMARY KEY  CLUSTERED 
	(
		[CR_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XS_ContractDetail] WITH NOCHECK ADD 
	CONSTRAINT [PK_XS_ContractDetail] PRIMARY KEY  CLUSTERED 
	(
		[CD_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XS_ContractText] WITH NOCHECK ADD 
	CONSTRAINT [PK_XS_ContractText] PRIMARY KEY  CLUSTERED 
	(
		[CT_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XS_CustFunds] WITH NOCHECK ADD 
	CONSTRAINT [PK_XS_CustFunds] PRIMARY KEY  CLUSTERED 
	(
		[own_id],
		[cust_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XS_Opportunity] WITH NOCHECK ADD 
	CONSTRAINT [PK_XS_Opportunity] PRIMARY KEY  CLUSTERED 
	(
		[oppt_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XS_OpptContact] WITH NOCHECK ADD 
	CONSTRAINT [PK_XS_OpptContact] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XS_OpptPhase] WITH NOCHECK ADD 
	CONSTRAINT [PK_XS_OpptPhase] PRIMARY KEY  CLUSTERED 
	(
		[phase_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XS_OpptRival] WITH NOCHECK ADD 
	CONSTRAINT [PK_XS_OpptRival] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XS_Plan_D] WITH NOCHECK ADD 
	CONSTRAINT [PK_XS_Plan_D] PRIMARY KEY  CLUSTERED 
	(
		[plan_id],
		[plan_object]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XS_Plan_H] WITH NOCHECK ADD 
	CONSTRAINT [PK_XS_Plan_H] PRIMARY KEY  CLUSTERED 
	(
		[plan_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XS_Plan_Temp_D] WITH NOCHECK ADD 
	CONSTRAINT [PK_XS_Plan_Temp_D] PRIMARY KEY  CLUSTERED 
	(
		[plan_id],
		[plan_object],
		[emp_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XS_QP_D] WITH NOCHECK ADD 
	CONSTRAINT [PK_XS_QP_D] PRIMARY KEY  CLUSTERED 
	(
		[own_id],
		[qp_id],
		[prod_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XS_QP_H] WITH NOCHECK ADD 
	CONSTRAINT [PK_XS_QP_H] PRIMARY KEY  CLUSTERED 
	(
		[qp_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XS_SO_D] WITH NOCHECK ADD 
	CONSTRAINT [PK_XS_SO_D] PRIMARY KEY  CLUSTERED 
	(
		[own_id],
		[so_id],
		[prod_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XS_SO_Delivery] WITH NOCHECK ADD 
	CONSTRAINT [PK_XS_SO_Delivery] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XS_SO_H] WITH NOCHECK ADD 
	CONSTRAINT [PK_XS_SO_H] PRIMARY KEY  CLUSTERED 
	(
		[so_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XS_Thread] WITH NOCHECK ADD 
	CONSTRAINT [PK_XS_Thread] PRIMARY KEY  CLUSTERED 
	(
		[XT_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XS_ThreadAction] WITH NOCHECK ADD 
	CONSTRAINT [PK_XS_ThreadAction] PRIMARY KEY  CLUSTERED 
	(
		[TA_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XT_Approve] WITH NOCHECK ADD 
	CONSTRAINT [PK_XT_Approve] PRIMARY KEY  CLUSTERED 
	(
		[emp_id],
		[doc_type]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XT_Dept] WITH NOCHECK ADD 
	CONSTRAINT [PK_XT_Dept] PRIMARY KEY  CLUSTERED 
	(
		[Dept_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XT_Employee] WITH NOCHECK ADD 
	CONSTRAINT [PK_XT_Employee] PRIMARY KEY  CLUSTERED 
	(
		[Emp_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XT_Log] WITH NOCHECK ADD 
	CONSTRAINT [PK_XT_Log] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XT_Module] WITH NOCHECK ADD 
	CONSTRAINT [PK_XT_Module] PRIMARY KEY  CLUSTERED 
	(
		[mod_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[XT_Role] WITH NOCHECK ADD 
	CONSTRAINT [PK_XT_Role] PRIMARY KEY  CLUSTERED 
	(
		[role_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[ZS_DocInfo] WITH NOCHECK ADD 
	CONSTRAINT [PK_ZS_DocInfo] PRIMARY KEY  CLUSTERED 
	(
		[DI_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[ZS_DocType] WITH NOCHECK ADD 
	CONSTRAINT [PK_ZS_DocType] PRIMARY KEY  CLUSTERED 
	(
		[DT_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[ZS_KnowInfo] WITH NOCHECK ADD 
	CONSTRAINT [PK_ZS_KnowInfo] PRIMARY KEY  CLUSTERED 
	(
		[KI_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[ZS_KnowType] WITH NOCHECK ADD 
	CONSTRAINT [PK_ZS_KnowType] PRIMARY KEY  CLUSTERED 
	(
		[KT_ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[prg_expense] WITH NOCHECK ADD 
	CONSTRAINT [PK_prg_expense] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[pub_bbsforum] WITH NOCHECK ADD 
	CONSTRAINT [PK_pub_bbsforum] PRIMARY KEY  CLUSTERED 
	(
		[rid]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[xs_CrtExpense] WITH NOCHECK ADD 
	CONSTRAINT [PK_xs_expenseive] PRIMARY KEY  CLUSTERED 
	(
		[ce_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[CP_ProdType] ADD 
	CONSTRAINT [DF_CP_ProdType_PT_ProdSN] DEFAULT (0) FOR [PT_ProdSN]
GO

ALTER TABLE [dbo].[FW_MaintRec] ADD 
	CONSTRAINT [DF_FW_MaintRec_MR_Charge] DEFAULT (0) FOR [MR_Charge]
GO

ALTER TABLE [dbo].[JB_Contact] ADD 
	CONSTRAINT [DF_JB_Contact_ct_sex] DEFAULT (1) FOR [ct_sex],
	CONSTRAINT [DF_JB_Contact_ct_married] DEFAULT (0) FOR [ct_married],
	CONSTRAINT [DF_JB_Contact_ct_flag] DEFAULT (0) FOR [ct_flag]
GO

ALTER TABLE [dbo].[JB_CustInfo] ADD 
	CONSTRAINT [DF_JB_CustInfo_Contact_ID] DEFAULT (0) FOR [Contact_ID],
	CONSTRAINT [DF_JB_CustInfo_CI_Forbid] DEFAULT (0) FOR [CI_Forbid]
GO

ALTER TABLE [dbo].[JC_Area] ADD 
	CONSTRAINT [DF_JC_Area_area_rootid] DEFAULT (0) FOR [area_rootid],
	CONSTRAINT [DF_JC_Area_area_baseid] DEFAULT (0) FOR [area_baseid]
GO

ALTER TABLE [dbo].[JC_TaskStatus] ADD 
	CONSTRAINT [DF_JC_TaskStatus_ts_delete] DEFAULT (1) FOR [ts_delete]
GO

ALTER TABLE [dbo].[JT_Owner] ADD 
	CONSTRAINT [DF_JT_Owner_own_Flag] DEFAULT (1) FOR [own_Flag]
GO

ALTER TABLE [dbo].[Pub_Attach] ADD 
	CONSTRAINT [DF_Pub_Attach_Att_Flag] DEFAULT (1) FOR [Att_Flag]
GO

ALTER TABLE [dbo].[Pub_BillCode] ADD 
	CONSTRAINT [DF_Pub_BillCode_BC_MaxID] DEFAULT (0) FOR [BC_MaxID],
	CONSTRAINT [DF_Pub_BillCode_BC_SerialLen] DEFAULT (4) FOR [BC_SerialLen],
	CONSTRAINT [DF_Pub_BillCode_BC_HasDate] DEFAULT (1) FOR [BC_HasDate],
	CONSTRAINT [DF_Pub_BillCode_BC_AutoIncrease] DEFAULT (1) FOR [BC_AutoIncrease],
	CONSTRAINT [DF_Pub_BillCode_BC_Use] DEFAULT (1) FOR [BC_Use]
GO

ALTER TABLE [dbo].[Pub_Login] ADD 
	CONSTRAINT [DF_Pub_Login_Login_Status] DEFAULT (0) FOR [Login_Status],
	CONSTRAINT [DF_Pub_Login_Login_Forbid] DEFAULT (0) FOR [Login_Forbid]
GO

ALTER TABLE [dbo].[Pub_MsgBoard] ADD 
	CONSTRAINT [DF_Pub_MsgBoard_MB_Read] DEFAULT (0) FOR [MB_Read]
GO

ALTER TABLE [dbo].[Pub_Pending] ADD 
	CONSTRAINT [DF_Pub_Pending_PD_Date] DEFAULT (getdate()) FOR [PD_Date]
GO

ALTER TABLE [dbo].[Pub_Progress] ADD 
	CONSTRAINT [DF_Pub_Progress_Prg_Cost] DEFAULT (0) FOR [Prg_Cost]
GO

ALTER TABLE [dbo].[Pub_Task] ADD 
	CONSTRAINT [DF_Pub_Task_Task_Budget] DEFAULT (0) FOR [Task_Budget],
	CONSTRAINT [DF_Pub_Task_Task_Cost] DEFAULT (0) FOR [Task_Cost],
	CONSTRAINT [DF_Pub_Task_Task_Flag] DEFAULT (0) FOR [Task_Flag]
GO

ALTER TABLE [dbo].[XS_Activity] ADD 
	CONSTRAINT [DF_XS_Activity_act_finish] DEFAULT (0) FOR [act_finish],
	CONSTRAINT [DF_XS_Activity_act_expense] DEFAULT (0) FOR [act_expense]
GO

ALTER TABLE [dbo].[XS_Contract] ADD 
	CONSTRAINT [DF_XS_Contract_CR_RecAmount] DEFAULT (0) FOR [CR_RecAmount],
	CONSTRAINT [DF_XS_Contract_CR_ReferRate] DEFAULT (0) FOR [CR_ReferRate],
	CONSTRAINT [DF_XS_Contract_CR_TrainRate] DEFAULT (0) FOR [CR_TrainRate],
	CONSTRAINT [DF_XS_Contract_CR_Discount] DEFAULT (0) FOR [CR_Discount]
GO

ALTER TABLE [dbo].[XS_CustFunds] ADD 
	CONSTRAINT [DF_XS_CustFunds_cf_amountinit] DEFAULT (0) FOR [cf_amountinit],
	CONSTRAINT [DF_XS_CustFunds_cf_profitinit] DEFAULT (0) FOR [cf_profitinit],
	CONSTRAINT [DF_XS_CustFunds_cf_receiveinit] DEFAULT (0) FOR [cf_receiveinit],
	CONSTRAINT [DF_XS_CustFunds_cf_amount] DEFAULT (0) FOR [cf_amount],
	CONSTRAINT [DF_XS_CustFunds_cf_profit] DEFAULT (0) FOR [cf_profit],
	CONSTRAINT [DF_XS_CustFunds_cf_receive] DEFAULT (0) FOR [cf_receive]
GO

ALTER TABLE [dbo].[XS_Opportunity] ADD 
	CONSTRAINT [DF_XS_Opportunity_oppt_close] DEFAULT (0) FOR [oppt_close],
	CONSTRAINT [DF_XS_Opportunity_oppt_succeed] DEFAULT (0) FOR [oppt_succeed]
GO

ALTER TABLE [dbo].[XS_OpptContact] ADD 
	CONSTRAINT [DF_XS_OpptContact_oc_main] DEFAULT (0) FOR [oc_main]
GO

ALTER TABLE [dbo].[XS_OpptProd] ADD 
	CONSTRAINT [DF_XS_OpptProd_op_price] DEFAULT (0) FOR [op_price],
	CONSTRAINT [DF_XS_OpptProd_op_qty] DEFAULT (0) FOR [op_qty],
	CONSTRAINT [DF_XS_OpptProd_op_amount] DEFAULT (0) FOR [op_amount]
GO

ALTER TABLE [dbo].[XS_OpptRival] ADD 
	CONSTRAINT [DF_XS_OpptRival_or_main] DEFAULT (0) FOR [or_main]
GO

ALTER TABLE [dbo].[XS_Plan_D] ADD 
	CONSTRAINT [DF_XS_Plan_D_plan_month1] DEFAULT (0) FOR [plan_month1],
	CONSTRAINT [DF_XS_Plan_D_plan_month2] DEFAULT (0) FOR [plan_month2],
	CONSTRAINT [DF_XS_Plan_D_plan_month3] DEFAULT (0) FOR [plan_month3],
	CONSTRAINT [DF_XS_Plan_D_plan_month4] DEFAULT (0) FOR [plan_month4],
	CONSTRAINT [DF_XS_Plan_D_plan_month5] DEFAULT (0) FOR [plan_month5],
	CONSTRAINT [DF_XS_Plan_D_plan_month6] DEFAULT (0) FOR [plan_month6],
	CONSTRAINT [DF_XS_Plan_D_plan_month7] DEFAULT (0) FOR [plan_month7],
	CONSTRAINT [DF_XS_Plan_D_plan_month8] DEFAULT (0) FOR [plan_month8],
	CONSTRAINT [DF_XS_Plan_D_plan_month9] DEFAULT (0) FOR [plan_month9],
	CONSTRAINT [DF_XS_Plan_D_plan_month10] DEFAULT (0) FOR [plan_month10],
	CONSTRAINT [DF_XS_Plan_D_plan_month11] DEFAULT (0) FOR [plan_month11],
	CONSTRAINT [DF_XS_Plan_D_plan_month12] DEFAULT (0) FOR [plan_month12],
	CONSTRAINT [DF_XS_Plan_D_plan_subtotal] DEFAULT (0) FOR [plan_subtotal]
GO

ALTER TABLE [dbo].[XS_Plan_H] ADD 
	CONSTRAINT [DF_XS_Plan_H_plan_amount] DEFAULT (0) FOR [plan_amount]
GO

ALTER TABLE [dbo].[XS_Plan_Temp_D] ADD 
	CONSTRAINT [DF_XS_Plan_Temp_D_month1] DEFAULT (0) FOR [plan_month1],
	CONSTRAINT [DF_XS_Plan_Temp_D_month2] DEFAULT (0) FOR [plan_month2],
	CONSTRAINT [DF_XS_Plan_Temp_D_month3] DEFAULT (0) FOR [plan_month3],
	CONSTRAINT [DF_XS_Plan_Temp_D_month4] DEFAULT (0) FOR [plan_month4],
	CONSTRAINT [DF_XS_Plan_Temp_D_month5] DEFAULT (0) FOR [plan_month5],
	CONSTRAINT [DF_XS_Plan_Temp_D_month6] DEFAULT (0) FOR [plan_month6],
	CONSTRAINT [DF_XS_Plan_Temp_D_month7] DEFAULT (0) FOR [plan_month7],
	CONSTRAINT [DF_XS_Plan_Temp_D_month8] DEFAULT (0) FOR [plan_month8],
	CONSTRAINT [DF_XS_Plan_Temp_D_month9] DEFAULT (0) FOR [plan_month9],
	CONSTRAINT [DF_XS_Plan_Temp_D_month10] DEFAULT (0) FOR [plan_month10],
	CONSTRAINT [DF_XS_Plan_Temp_D_month11] DEFAULT (0) FOR [plan_month11],
	CONSTRAINT [DF_XS_Plan_Temp_D_month12] DEFAULT (0) FOR [plan_month12],
	CONSTRAINT [DF_XS_Plan_Temp_D_subtotal] DEFAULT (0) FOR [plan_subtotal]
GO

ALTER TABLE [dbo].[XS_QP_H] ADD 
	CONSTRAINT [DF_XS_QP_H_qp_close] DEFAULT (0) FOR [qp_close]
GO

ALTER TABLE [dbo].[XS_SO_D] ADD 
	CONSTRAINT [DF_XS_SO_D_so_deliveryqty] DEFAULT (0) FOR [so_deliveryqty]
GO

ALTER TABLE [dbo].[XS_SO_H] ADD 
	CONSTRAINT [DF_XS_SO_H_so_check] DEFAULT (0) FOR [so_check],
	CONSTRAINT [DF_XS_SO_H_so_amount] DEFAULT (0) FOR [so_amount],
	CONSTRAINT [DF_XS_SO_H_so_profit] DEFAULT (0) FOR [so_profit],
	CONSTRAINT [DF_XS_SO_H_so_paidamount] DEFAULT (0) FOR [so_paidamount],
	CONSTRAINT [DF_XS_SO_H_so_close] DEFAULT (0) FOR [so_close]
GO

ALTER TABLE [dbo].[XS_Thread] ADD 
	CONSTRAINT [DF_XS_Thread_XT_Check] DEFAULT (0) FOR [XT_Check],
	CONSTRAINT [DF_XS_Thread_Cust_ID] DEFAULT (0) FOR [Cust_ID],
	CONSTRAINT [DF_XS_Thread_Contact_ID] DEFAULT (0) FOR [Contact_ID]
GO

ALTER TABLE [dbo].[XT_Employee] ADD 
	CONSTRAINT [DF_XT_Employee_Emp_Sex] DEFAULT ('') FOR [Emp_Sex],
	CONSTRAINT [DF_XT_Employee_Emp_Forbid] DEFAULT (0) FOR [Emp_Forbid]
GO

ALTER TABLE [dbo].[XT_Module] ADD 
	CONSTRAINT [DF_XT_Module_mod_check] DEFAULT (1) FOR [mod_read],
	CONSTRAINT [DF_XT_Module_mod_view] DEFAULT (1) FOR [mod_edit],
	CONSTRAINT [DF_XT_Module_mod_delete] DEFAULT (1) FOR [mod_delete]
GO

ALTER TABLE [dbo].[XT_Role] ADD 
	CONSTRAINT [DF_XT_Role_role_customer] DEFAULT (1) FOR [role_customer],
	CONSTRAINT [DF_XT_Role_role_contact] DEFAULT (1) FOR [role_contact],
	CONSTRAINT [DF_XT_Role_role_oppt] DEFAULT (1) FOR [role_oppt],
	CONSTRAINT [DF_XT_Role_role_act] DEFAULT (1) FOR [role_act],
	CONSTRAINT [DF_XT_Role_role_qp] DEFAULT (1) FOR [role_qp],
	CONSTRAINT [DF_XT_Role_role_so] DEFAULT (1) FOR [role_so]
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE VIEW dbo.view_Activity
AS
SELECT a.act_id, a.own_id, a.oppt_id, a.act_subject, a.cust_id, a.contact_id, a.act_type, 
      a.act_action, a.act_priority, a.act_createdate, a.act_start, a.act_end, a.act_finish, 
      a.act_result, a.act_expense, a.act_maker, a.act_executor, a.act_duration, 
      a.act_memo, c.CI_Name, c.CI_Forbid, o.oppt_subject, at.at_name, e.Emp_Name,  e.dept_id, 
      e.Emp_Forbid, ad.ad_Name
FROM dbo.XS_Opportunity o RIGHT OUTER JOIN
      dbo.JB_CustInfo c INNER JOIN
      dbo.XT_Employee e INNER JOIN
      dbo.XS_Activity a ON e.Emp_ID = a.act_executor ON c.CI_ID = a.cust_id INNER JOIN
      dbo.JC_ActType at ON a.act_type = at.at_id INNER JOIN
      dbo.JC_ActionDef ad ON a.act_action = ad.rid ON o.oppt_id = a.oppt_id

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE VIEW dbo.view_Opportunity
AS
SELECT o.oppt_id, o.own_id, o.oppt_subject, o.cust_id, o.oppt_source, o.oppt_type, 
      o.oppt_phase, o.oppt_status, o.oppt_valuable, o.oppt_createdate, o.oppt_start, 
      o.oppt_end, o.oppt_close, o.oppt_succeed, o.oppt_closedate, o.oppt_maker, 
      o.oppt_manager, o.oppt_revenue, o.oppt_probability, o.phase_id,
      o.oppt_memo, e.Emp_Name, e.Emp_forbid, e.dept_id, 
      c.CI_Name,c.CI_forbid, ot.ot_name, st.st_name, op.op_name, os.os_name
FROM dbo.XS_Opportunity o INNER JOIN
      dbo.JB_CustInfo c ON o.cust_id = c.CI_ID LEFT OUTER  JOIN
      dbo.XT_Employee e ON o.oppt_manager = e.Emp_ID LEFT OUTER JOIN
      dbo.JC_OpptPhase op ON o.oppt_phase = op.op_id LEFT OUTER JOIN
      dbo.JC_OpptStatus os ON o.oppt_status = os.os_id LEFT OUTER JOIN
      dbo.JC_OpptType ot ON o.oppt_type = ot.ot_id LEFT OUTER JOIN
      dbo.JC_SourceType st ON o.oppt_source = st.rid

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE VIEW dbo.view_contract
AS
SELECT CR_ID, CI.CI_Name, XS_Contract.Cust_ID, Area_Name, JC_TypeDef.td_name, 
      JB_Contact.ct_name, CI.City_ID, XS_Contract.CR_SignDate, XS_Contract.CR_Check, 
      XT_Employee.Emp_Name AS SaleName, XT_Employee_1.Emp_Name AS Manager, 
      XT_Employee_2.Emp_Name AS Advistor, JG.Gt_Name
FROM XT_Employee INNER JOIN
      XS_Contract INNER JOIN
      JB_CustInfo CI ON XS_Contract.Cust_ID = CI.CI_ID INNER JOIN
      JC_TypeDef ON XS_Contract.CR_Type = JC_TypeDef.td_id INNER JOIN
      JB_Contact ON XS_Contract.Contact_ID = JB_Contact.ct_id ON 
      XT_Employee.Emp_ID = XS_Contract.CR_Sale INNER JOIN
      XT_Employee XT_Employee_1 ON 
      XS_Contract.CR_Manager = XT_Employee_1.Emp_ID INNER JOIN
      XT_Employee XT_Employee_2 ON 
      XS_Contract.CR_Advisor = XT_Employee_2.Emp_ID INNER JOIN
      JC_Area JA ON JA.area_ID = Province_ID INNER JOIN
      JC_GradeType JG ON CI.GT_ID = JG.rid
WHERE XS_Contract.CR_Check = '0' AND city_id IS NULL AND 
      XS_Contract.own_id = 'fw001'
UNION ALL
SELECT CR_ID, CI.CI_Name, XS_Contract.Cust_ID, Area_Name, JC_TypeDef.td_name, 
      JB_Contact.ct_name, CI.City_ID, XS_Contract.CR_SignDate, XS_Contract.CR_Check, 
      XT_Employee.Emp_Name AS SaleName, XT_Employee_1.Emp_Name AS Manager, 
      XT_Employee_2.Emp_Name AS Advistor, JG.Gt_Name
FROM XT_Employee INNER JOIN
      XS_Contract INNER JOIN
      JB_CustInfo CI ON XS_Contract.Cust_ID = CI.CI_ID INNER JOIN
      JC_TypeDef ON XS_Contract.CR_Type = JC_TypeDef.td_id INNER JOIN
      JB_Contact ON XS_Contract.Contact_ID = JB_Contact.ct_id ON 
      XT_Employee.Emp_ID = XS_Contract.CR_Sale INNER JOIN
      XT_Employee XT_Employee_1 ON 
      XS_Contract.CR_Manager = XT_Employee_1.Emp_ID INNER JOIN
      XT_Employee XT_Employee_2 ON 
      XS_Contract.CR_Advisor = XT_Employee_2.Emp_ID INNER JOIN
      JC_Area JA ON JA.area_ID = City_ID INNER JOIN
      JC_GradeType JG ON CI.GT_ID = JG.rid
WHERE XS_Contract.CR_Check = '0' AND XS_Contract.own_id = 'fw001'

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE VIEW dbo.vw_ServiceAct
AS
SELECT dbo.Pub_Progress.Task_Id, dbo.Pub_Progress.prg_ID, 
      dbo.Pub_Progress.prg_objID, dbo.Pub_Progress.prg_objType, 
      dbo.Pub_Progress.Prg_Subject, dbo.Pub_Progress.Prg_StartDate, 
      dbo.Pub_Progress.Prg_Cost, dbo.Pub_Task.Task_Subject, 
      dbo.XT_Employee.Emp_Name, dbo.Pub_Progress.Prg_EndDate, 
      dbo.Pub_Progress.Prg_Code, dbo.Pub_Progress.own_id, dbo.XT_Employee.Dept_ID, 
      dbo.Pub_Progress.Prg_Type, dbo.Pub_Progress.prg_finish, 
      dbo.JC_ActionDef.ad_Name, dbo.Pub_Progress.Prg_Action, 
      dbo.Pub_Progress.Prg_Executor
FROM dbo.Pub_Progress INNER JOIN
      dbo.XT_Employee ON 
      dbo.Pub_Progress.Prg_Executor = dbo.XT_Employee.Emp_ID LEFT OUTER JOIN
      dbo.JC_ActionDef ON 
      dbo.Pub_Progress.Prg_Action = dbo.JC_ActionDef.rid INNER JOIN
      dbo.Pub_Task ON dbo.Pub_Progress.Task_Id = dbo.Pub_Task.Task_ID

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE Procedure oppt_pipeline
	(
		@begin datetime,
		@end datetime
	)
As
/* set nocount on */
select    
jc_opptphase.op_name as phasename,
jc_opptphase.op_id as phaseid,
vopptphase.oppt_id as phasecount,
vopptphase.oppt_amount as phaseamount,
(vopptphase.oppt_possible) as phasepossible,
vopptphase.oppt_saleamount as phasesaleamount,
(voppt.opptcount) as allopptcount,
case when voppt.opptcount=0 then 0 else round(((vopptphase.oppt_id*100)/voppt.opptcount),2) end as phasepercent,
voppt.lmoney as allopptamount,
case when voppt.lmoney=0 then 0 else round(((vopptphase.oppt_amount/voppt.lmoney) *100),2) end as amountpercent 
from 
( jc_opptphase 
  left outer join 
   (
     select
        oppt.oppt_phase, count(distinct (oppt.oppt_id))as oppt_id,
        sum(distinct (oppt.oppt_revenue)) as oppt_amount,
        avg(oppt.oppt_probability) as oppt_possible,
        (sum(distinct (oppt.oppt_revenue))* (avg(oppt.oppt_probability)/100))as oppt_saleamount
     from
        xs_opportunity oppt
     where
        (oppt.oppt_start >= @begin and oppt.oppt_start <= @end and oppt.oppt_close = 0)
     group by oppt.oppt_phase
    )vopptphase on vopptphase.oppt_phase = jc_opptphase.op_id),
 (
  select
    count(oppt_id) as opptcount, sum(oppt_revenue) as lmoney
  from
    xs_opportunity
  where
    (xs_opportunity.oppt_start >= @begin and xs_opportunity.oppt_start <= @end and xs_opportunity.oppt_close = 0)
 ) voppt
order by jc_opptphase.op_id	
	
	return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE Procedure oppt_possible
	(
		@begin datetime,
		@end datetime
	)
As
	/* set nocount on */
	
select 
jc_possible.rid as possibleid,
jc_possible.possible_scope, 
voppt.lcount as countoppt,
vopptproduct.oppt_amount,
vopptproduct.possibleamount,
vopptmonth.lcount as countmonthoppt,
vopptnmonth.lcount as countnmonthoppt,
vopptweek.lcount as countweekoppt,
vopptother.lcount as countotheroppt
from jc_possible
left outer join (
select p.possible_scope, count(o.oppt_id) as lcount 
from xs_opportunity o left outer join jc_possible p on o.oppt_probability >= p.possible_min and o.oppt_probability < p.possible_max
where (o.oppt_start >= @begin and o.oppt_start <= @end) and o.oppt_close = 0
group by p.possible_scope
)voppt on voppt.possible_scope=jc_possible.possible_scope
left outer join (
select p.possible_scope, sum(o.oppt_revenue) as oppt_amount, sum(o.oppt_revenue * o.oppt_probability/100) as possibleamount
from xs_opportunity o left outer join jc_possible p on o.oppt_probability >= p.possible_min and o.oppt_probability < p.possible_max
where (o.oppt_start >= @begin and o.oppt_start <= @end) and o.oppt_close = 0
group by p.possible_scope
)vopptproduct on vopptproduct.possible_scope=jc_possible.possible_scope
left outer join (
select p.possible_scope, count(o.oppt_id) as lcount
from xs_opportunity o left outer join jc_possible p on o.oppt_probability >= p.possible_min and o.oppt_probability < p.possible_max
where datediff(week, o.oppt_end, getdate())=0 
and  (o.oppt_start >= @begin and o.oppt_start <= @end) and o.oppt_close = 0
group by p.possible_scope
)vopptweek on vopptweek.possible_scope = jc_possible.possible_scope
left outer join (
select p.possible_scope, count(o.oppt_id) as lcount
from xs_opportunity o left outer join jc_possible p on o.oppt_probability >= p.possible_min and o.oppt_probability < p.possible_max
where month(getdate()) = month(o.oppt_end)  
and  (o.oppt_start >= @begin and o.oppt_start <= @end) and o.oppt_close = 0
group by p.possible_scope
)vopptmonth on vopptmonth.possible_scope = jc_possible.possible_scope
left outer join (
select p.possible_scope, count(o.oppt_id) as lcount
from xs_opportunity o left outer join jc_possible p on o.oppt_probability >= p.possible_min and o.oppt_probability < p.possible_max
where (month(getdate()) + 1) = month(o.oppt_end) 
and (o.oppt_start >= @begin and o.oppt_start <= @end) and o.oppt_close = 0
group by p.possible_scope
)vopptnmonth on vopptnmonth.possible_scope = jc_possible.possible_scope
left outer join (
select p.possible_scope, count(o.oppt_id) as lcount
from xs_opportunity o left outer join jc_possible p on o.oppt_probability >= p.possible_min and o.oppt_probability < p.possible_max
where o.oppt_close = 0
and (month(getdate()) <> month(o.oppt_end) and ((month(getdate())+1) <> month(o.oppt_end)) or o.oppt_end is null)
and (o.oppt_start >= @begin and o.oppt_start <= @end  and o.oppt_close = 0)  
group by p.possible_scope
)vopptother on vopptother.possible_scope=jc_possible.possible_scope	
	
	return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE Procedure oppt_promote
	(
		@begin datetime,
		@end datetime
	)
As
	
select 
jc_opptphase.op_id as phaseid,
jc_opptphase.op_name as phasename,
vmaxopptphase.opptphasedays,
vopptphase1.lopptcount as opptcount1,
vopptphase7.lopptcount as opptcount7,
vopptphase15.lopptcount as opptcount15,
vopptphase30.lopptcount as opptcount30,
vopptphase40.lopptcount as opptcount40,
vcuroppt.lopptcount as opptcount 
from 
jc_opptphase
left outer join
(select max(datediff(dy, p.phase_begin, getdate())) as opptphasedays, o.oppt_phase 
from xs_opportunity o left outer join xs_opptphase p on o.phase_id=p.phase_id
where (o.oppt_start >= @begin and o.oppt_start <= @end and o.oppt_close = 0)
group by o.oppt_phase)vmaxopptphase
on vmaxopptphase.oppt_phase=jc_opptphase.op_id
left outer join
(select count(distinct(o.oppt_id)) as lopptcount,o.oppt_phase
from xs_opportunity o left outer join xs_opptphase p on o.phase_id=p.phase_id
where (o.oppt_start >= @begin and o.oppt_start <= @end and o.oppt_close = 0)
and  (datediff(dy,p.phase_begin,getdate())>=0 
and datediff(dy,p.phase_begin,getdate())<=3)
group by o.oppt_phase) vopptphase1
on vopptphase1.oppt_phase=jc_opptphase.op_id
left outer join
(select count(distinct(o.oppt_id)) as lopptcount,o.oppt_phase
from xs_opportunity o left outer join xs_opptphase p on o.phase_id=p.phase_id
where (o.oppt_start >= @begin and o.oppt_start <= @end and o.oppt_close = 0)
and  (datediff(dy,p.phase_begin,getdate())>3 
and datediff(dy,p.phase_begin,getdate())<=7)
group by o.oppt_phase) vopptphase7
on vopptphase7.oppt_phase=jc_opptphase.op_id
left outer join
(select count(distinct(o.oppt_id)) as lopptcount,o.oppt_phase
from xs_opportunity o left outer join xs_opptphase p on o.phase_id=p.phase_id
where (o.oppt_start >= @begin and o.oppt_start <= @end and o.oppt_close = 0)
and  (datediff(dy,p.phase_begin,getdate())>7 
and datediff(dy,p.phase_begin,getdate())<=15)
group by o.oppt_phase) vopptphase15
on vopptphase15.oppt_phase=jc_opptphase.op_id
left outer join
(select count(distinct(o.oppt_id)) as lopptcount,o.oppt_phase
from xs_opportunity o left outer join xs_opptphase p on o.phase_id=p.phase_id
where (o.oppt_start >= @begin and o.oppt_start <= @end and o.oppt_close = 0)
and  (datediff(dy,p.phase_begin,getdate())>15 
and datediff(dy,p.phase_begin,getdate())<=30)
group by o.oppt_phase) vopptphase30
on vopptphase30.oppt_phase=jc_opptphase.op_id
left outer join
(select count(distinct(o.oppt_id)) as lopptcount,o.oppt_phase
from xs_opportunity o left outer join xs_opptphase p on o.phase_id=p.phase_id
where (o.oppt_start >= @begin and o.oppt_start <= @end and o.oppt_close = 0)
and  (datediff(dy,p.phase_begin,getdate())>30) 
group by o.oppt_phase) vopptphase40
on vopptphase40.oppt_phase=jc_opptphase.op_id
left outer join(select count(distinct(o.oppt_id)) as lopptcount,o.oppt_phase
from xs_opportunity o left outer join xs_opptphase p on o.phase_id=p.phase_id
where (o.oppt_start >= @begin and o.oppt_start <= @end and o.oppt_close = 0)
group by o.oppt_phase) vcuroppt
on  vcuroppt.oppt_phase=jc_opptphase.op_id
order by jc_opptphase.op_id	
	
	return

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO


Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(2,'fw001','000002-0002','IBM','p001',174,'X220',1,'',26800,23800,'','׼',Null,Null,'aaaaa','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(5,'fw001','000-0011','ʾ743DF','c11',170,'17紿ƽ',1,'̨',1500,1200,'','',Null,Null,'fasfsdfasdfasdf','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(6,'fw001','000-P004','ʾ753DF','c22',170,'17紿ƽ',1,'̨',1600,1400,'1000','dsfsdf',Null,Null,'','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(7,'fw001','000-P005','ʾ755DF','c12',170,'17紿ƽ',1,'̨',1900,1500,'100','',Null,Null,'','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(9,'fw001','000-P006','ʾ750S','c13',170,'17',1,'̨',1400,1300,'100','',Null,Null,'','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(10,'fw001','004001-0009','T18SC','c14',186,'ģ˫Ƶ',1,'̨',1000,500,'100','',Null,Null,'','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(11,'fw001','004001-0002','T28SC','c15',186,'ģ˫Ƶ',1,'̨',1200,600,'100','',Null,Null,'','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(12,'fw001','004001-0003','T29SC','c165',186,'ģƵWAP',1,'̨',1400,700,'100','',Null,Null,'','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(13,'fw001','004002-0001','T39mc','c144',187,',WAP,GPRS',1,'̨',2800,1000,'100','',Null,Null,'','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(14,'fw001','004001-0001','Motorola V66','c1334',186,'ģƵWAP',1,'̨',2900,1000,'100','',Null,Null,'','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(15,'fw001','004002-0002','Motorola V60','c144',187,',Ƶ,WAP',1,'̨',4500,1200,'100','',Null,Null,'','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(18,'fw001','004001-0010','Motorola V8088','c33',186,',˫Ƶ,WAP',1,'̨',2200,1200,'100','',Null,Null,'','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(19,'fw001','004001-0008','Nokia 8210','ccc',186,',˫Ƶ',1,'̨',1800,1000,'100','',Null,Null,'','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(20,'fw001','004001-0006','Nokia 8250','c333',186,',˫Ƶ,WAP',1,'̨',2500,1200,'100','',Null,Null,'','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(22,'fw001','004001-0004','Nokia 8850','c212',186,',˫Ƶ',1,'̨',3000,1200,'100','',Null,Null,'','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(23,'fw001','004001-0007','Nokia 3310','c34',186,',˫Ƶ',1,'̨',1500,800,'100','',Null,Null,'','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(24,'fw001','004001-0005','Siemens 6688','c344',186,',˫Ƶ,WAP',1,'̨',3500,2000,'100','',Null,Null,'','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(25,'fw001','004001-0011','Motorola V998+','c433',186,',˫Ƶ',1,'̨',1800,800,'100','',Null,Null,'','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(26,'fw001','000-0014','Seagate U6ST320413A','c123',170,'20.4G/IDE/2M/5400rpm',1,'̨',640,500,'120','',Null,Null,'','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(27,'fw001','000-P021','Seagate ST340016A','d333',170,'40G/IDE/2M/7200rpm',1,'̨',845,600,'140','',Null,Null,'','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(28,'fw001','000-P022','IBM 60AVER07','33',170,'60G/2M/7200rpm',1,'',1090,800,'100','',Null,8,'','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(29,'fw001','000-P023','Acerʾ77V','d33',170,'17/.27mm',1,'̨',1399,1200,'100','',Null,6,'','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(30,'fw001','000-P024','Philipsʾ107G','c333d',170,'17/.28mm',1,'̨',1720,1300,'1000','ffffffffff',222,Null,'dfasffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff','ffffffffffffffffffffffffffffffffffffffffffffffffffffffff',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(31,'fw001','000-P025','Philipsʾ105S','e33',170,'15/.28mm',1,'̨',1050,800,'140','',Null,Null,'','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(33,'fw001','p00002-0001','EPSON1600K','1600k',170,'A4',Null,'̨',1500,1200,'1400','',12,Null,'test','test',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(34,'fw001','000001-0009','ϵͳ','LEGEND',173,'sdfds',Null,'̨',16800,10000,'','dsfsdf',12,21,'','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(35,'fw001','p03-0001','aaaa','',172,',',Null,'',34556,3434,'','',Null,Null,'','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into CP_ProdInfo( Prod_ID,own_id,Prod_Code,PI_Name,PI_AID,PT_ID,PI_Spec,Unit_ID,PI_Unit,PI_Price,PI_Cost,PI_Date,PI_Grade,PI_MaintTerm,PI_Picture,PI_Desc,PI_Memo,PI_Int01,PI_Int02,PI_Int03,PI_Dec01,PI_Dec02,PI_Dec03,PI_Char01,PI_Char02,PI_Char03,PI_Char04 ) Values(36,'fw001','000002003-0001','IBMʼǱ','',191,'sdfsdf',Null,'',16852,8523,'','',Null,9,'','',Null,Null,Null,Null,Null,Null,'','','','')
GO

Insert Into CP_ProdType( PT_ID,own_id,PT_Code,PT_Name,PT_ProdSN,PT_Levels,PT_Path,PT_ParentID ) Values(170,'fw001','000','Ϳ豸ϵͳ',14,0,'-',0)
Insert Into CP_ProdType( PT_ID,own_id,PT_Code,PT_Name,PT_ProdSN,PT_Levels,PT_Path,PT_ParentID ) Values(171,'fw001','p00','е˵绰',0,0,'-',0)
Insert Into CP_ProdType( PT_ID,own_id,PT_Code,PT_Name,PT_ProdSN,PT_Levels,PT_Path,PT_ParentID ) Values(172,'fw001','p03','޳ֻܽתʽ',1,0,'-',0)
Insert Into CP_ProdType( PT_ID,own_id,PT_Code,PT_Name,PT_ProdSN,PT_Levels,PT_Path,PT_ParentID ) Values(173,'fw001','000001','ҵͿϵͳ',10,1,'-170-',170)
Insert Into CP_ProdType( PT_ID,own_id,PT_Code,PT_Name,PT_ProdSN,PT_Levels,PT_Path,PT_ParentID ) Values(174,'fw001','000002','ĩͿϵͳ',2,1,'-170-',170)
Insert Into CP_ProdType( PT_ID,own_id,PT_Code,PT_Name,PT_ProdSN,PT_Levels,PT_Path,PT_ParentID ) Values(176,'fw001','000001003','Ϳϵͳ',1,2,'-170-173-',173)
Insert Into CP_ProdType( PT_ID,own_id,PT_Code,PT_Name,PT_ProdSN,PT_Levels,PT_Path,PT_ParentID ) Values(177,'fw001','000001004','ҵͿϵͳ',3,2,'-170-173-',173)
Insert Into CP_ProdType( PT_ID,own_id,PT_Code,PT_Name,PT_ProdSN,PT_Levels,PT_Path,PT_ParentID ) Values(178,'fw001','000002001','IBMõ',3,2,'-170-174-',174)
Insert Into CP_ProdType( PT_ID,own_id,PT_Code,PT_Name,PT_ProdSN,PT_Levels,PT_Path,PT_ParentID ) Values(179,'fw001','000002002','IBM220',2,2,'-170-174-',174)
Insert Into CP_ProdType( PT_ID,own_id,PT_Code,PT_Name,PT_ProdSN,PT_Levels,PT_Path,PT_ParentID ) Values(181,'fw001','p00002','ʽӡ',1,1,'-171-',171)
Insert Into CP_ProdType( PT_ID,own_id,PT_Code,PT_Name,PT_ProdSN,PT_Levels,PT_Path,PT_ParentID ) Values(182,'fw001','p00003','īӡ',0,1,'-171-',171)
Insert Into CP_ProdType( PT_ID,own_id,PT_Code,PT_Name,PT_ProdSN,PT_Levels,PT_Path,PT_ParentID ) Values(183,'fw001','p00004','ӡ',0,1,'-171-',171)
Insert Into CP_ProdType( PT_ID,own_id,PT_Code,PT_Name,PT_ProdSN,PT_Levels,PT_Path,PT_ParentID ) Values(184,'fw001','p00003001','Cancelӡ',0,2,'-171-182-',182)
Insert Into CP_ProdType( PT_ID,own_id,PT_Code,PT_Name,PT_ProdSN,PT_Levels,PT_Path,PT_ParentID ) Values(185,'fw001','004','޳ܽƽ',5,0,'-',0)
Insert Into CP_ProdType( PT_ID,own_id,PT_Code,PT_Name,PT_ProdSN,PT_Levels,PT_Path,PT_ParentID ) Values(186,'fw001','004001','޳ֻܽ',3,1,'-185-',185)
Insert Into CP_ProdType( PT_ID,own_id,PT_Code,PT_Name,PT_ProdSN,PT_Levels,PT_Path,PT_ParentID ) Values(187,'fw001','004002','޳ܽӻ',4,1,'-185',185)
Insert Into CP_ProdType( PT_ID,own_id,PT_Code,PT_Name,PT_ProdSN,PT_Levels,PT_Path,PT_ParentID ) Values(189,'fw001','p00003001002','Cancel 2000',0,3,'-171-182-184',184)
Insert Into CP_ProdType( PT_ID,own_id,PT_Code,PT_Name,PT_ProdSN,PT_Levels,PT_Path,PT_ParentID ) Values(190,'fw001','p00003001002002','Cancel 2000A',50,4,'-171-182-184189',189)
Insert Into CP_ProdType( PT_ID,own_id,PT_Code,PT_Name,PT_ProdSN,PT_Levels,PT_Path,PT_ParentID ) Values(191,'fw001','000002003','IMBʼǱ',1,2,'-170-191-',174)
Insert Into CP_ProdType( PT_ID,own_id,PT_Code,PT_Name,PT_ProdSN,PT_Levels,PT_Path,PT_ParentID ) Values(192,'fw001','000003','ϵͳ',0,1,'-192-',170)
Insert Into CP_ProdType( PT_ID,own_id,PT_Code,PT_Name,PT_ProdSN,PT_Levels,PT_Path,PT_ParentID ) Values(193,'fw001','000004','ճͿϵͳ',0,1,'-193-',170)
GO

Insert Into FW_Holiday( own_id,ho_month,ho_day,ho_name,ho_wish,ho_remind,ho_ahead ) Values('fw001','1','1','Ԫ','֣','0',0)
Insert Into FW_Holiday( own_id,ho_month,ho_day,ho_name,ho_wish,ho_remind,ho_ahead ) Values('fw001','1','24','','ã','1',Null)
Insert Into FW_Holiday( own_id,ho_month,ho_day,ho_name,ho_wish,ho_remind,ho_ahead ) Values('fw001','2','14','˽','˽ڿ','0',Null)
Insert Into FW_Holiday( own_id,ho_month,ho_day,ho_name,ho_wish,ho_remind,ho_ahead ) Values('fw001','3','15','Ȩ','ǵĲƷû⣡','0',Null)
Insert Into FW_Holiday( own_id,ho_month,ho_day,ho_name,ho_wish,ho_remind,ho_ahead ) Values('fw001','5','1','Ͷ','տ֣','0',Null)
Insert Into FW_Holiday( own_id,ho_month,ho_day,ho_name,ho_wish,ho_remind,ho_ahead ) Values('fw001','6','1','ʶͯ','Сѽտ֣','0',Null)
Insert Into FW_Holiday( own_id,ho_month,ho_day,ho_name,ho_wish,ho_remind,ho_ahead ) Values('fw001','3','8','Ů','ףŮʿտ֣','0',Null)
Insert Into FW_Holiday( own_id,ho_month,ho_day,ho_name,ho_wish,ho_remind,ho_ahead ) Values('fw001','8','1','','','0',Null)
Insert Into FW_Holiday( own_id,ho_month,ho_day,ho_name,ho_wish,ho_remind,ho_ahead ) Values('fw001','9','10','ʦ','տ֣','1',3)
Insert Into FW_Holiday( own_id,ho_month,ho_day,ho_name,ho_wish,ho_remind,ho_ahead ) Values('fw001','10','1','','տ֣','1',25)
Insert Into FW_Holiday( own_id,ho_month,ho_day,ho_name,ho_wish,ho_remind,ho_ahead ) Values('fw001','12','25','ʥ','տ֣','0',Null)
Insert Into FW_Holiday( own_id,ho_month,ho_day,ho_name,ho_wish,ho_remind,ho_ahead ) Values('fw001','9','9','','һȥɽ','1',3)
Insert Into FW_Holiday( own_id,ho_month,ho_day,ho_name,ho_wish,ho_remind,ho_ahead ) Values('fw001','3','12','ֲ',' ','1',0)
Insert Into FW_Holiday( own_id,ho_month,ho_day,ho_name,ho_wish,ho_remind,ho_ahead ) Values('fw001','5','4','','˿֣','1',0)
Insert Into FW_Holiday( own_id,ho_month,ho_day,ho_name,ho_wish,ho_remind,ho_ahead ) Values('fw001','7','1','','йһ·ߺã','0',Null)
Insert Into FW_Holiday( own_id,ho_month,ho_day,ho_name,ho_wish,ho_remind,ho_ahead ) Values('fw001','4','2','˽','ǮˣԲ𿪸Ц˽ڣ','1',10)
Insert Into FW_Holiday( own_id,ho_month,ho_day,ho_name,ho_wish,ho_remind,ho_ahead ) Values('fw001','4','4','dfds','','1',5)
GO

Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(1,'fw001','Сë','','0','0','1927-4-4','ܼ','','23423423','410022','020-33778899','020-2009990','138-58993333','xcvsfd','ty@yu.com','020-45441414','ɶ','rtree','0','',3)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(2,'fw001','Ŵǧ','','0','0','1900-1-1','ܼ','','ddd','8999444','040-39383838','9999999','139-98377778','','zdqian@dtda.com','','','','0','',6)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(3,'fw001','ɽ','','0','0','1900-1-1','ܾ','','','510345','020-5678990','020-5678990','020-5678990','','jiang@sina.com','',' ','ɵط','0','',6)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(5,'fw001','ͬ','','1','0','1900-1-1','ž','','콨ĳ·10','','010-82922205','010-82923987','13902412363','','liust@Hsj.com','','','','0','',19)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(6,'fw001','','','1','0','1900-1-1','ž','','Ϻϵ·238Ž17C','','','','13826331254','','cds@hkyy.com','','ɶ','','0','',20)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(7,'fw001','Ʊ','','1','0','1900-1-1','г','','Ͼҵ·199Ŷ10','','025-2336896','','13825469871','','wltong@botong.com','','','','0','',21)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(8,'fw001','','','1','1','1900-1-1','ž','','ͬ־·87','','0431-5671405','','13922012365','','pax@jdgm.com','','','ͯ','0','',22)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(9,'fw001','л','','1','1','1900-1-1','ܼ','','Ͽж·11A12¥','','022-23673423','','13922105698','','xdxin@yiqixin.com','','','','0','',23)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(10,'fw001','̷','','1','1','1900-1-1','۲','','·ͥ԰B3','100080','010-62143126','010-62143127','13822256984','','tsx@jhsm.com','020-45417285','','','0','',5)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(11,'fw001','','','1','0','1900-1-1','ͻ','','ɳнű·','','0731-8744534','','13923659847','','htx@huayou.com','','4','','0','',13)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(12,'fw001','','','0','0','1900-1-1','','','','','','','13922456957','','','','','','0','',25)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(13,'fw001','֧','','0','1','1900-1-1','','','','','','','13502659842','','wuq@boke.com','','','ʱ','1','',24)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(14,'fw001','','','0','0','1900-1-1','','','ʨ·170ź鷢8¥ ','','','','13525695633','','xtq@ayxd.com','','','','0','',26)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(15,'fw001','','','0','0','1900-1-1','','','Ż濪Ƽ5203','','','','13602589432','','','','','','1','',27)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(16,'fw001','Ϧ','','0','0','1900-1-1','','','','','','','','','','','','','0','',14)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(17,'fw001','','','0','0','1900-1-1','','','','','','','','','','','','','0','',4)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(18,'fw001','ں','','0','0','1900-1-1','','','','','','','','','','','','','0','',28)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(19,'fw001','','DFG','0','0','','','','fth','','82112270','','','','','','','','1','',1399)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(20,'fw001','FDHFF','','1','0','','','','fth','','82112270','','','','','','','','0','',1399)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(21,'fw001','Ϊ','','1','0','','','','﹡ӱӿ콨Ƽ뿪˹','','82123717','','','','','','','','1','',1398)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(22,'fw001','','','0','0','','','','ghjryfyjyfr','565655','82122875','5455455','','','','','','','1','',1397)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(23,'fw001','','','1','0','','','','','4344434','82118643','343434','','','','','','','1','',1395)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(24,'fw001','ŷ','','0','0','','','','Ϻ','444443','82118523','453333','','','','','','','1','',1396)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(25,'fw001','','','1','0','','','','','','82111446','','','','','','','','1','',1394)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(26,'fw001','Ŷ','','1','0','','','','ݵ͹','','82121872','','','','','','','','1','',1393)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(27,'fw001','Ŷ','','1','0','','','','','','82127806','','','','','','','','1','',1389)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(28,'fw001','','','1','0','','','','jnjcvjc','','24419664','','','','','','','','1','',1388)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(29,'fw001','ܽɽ','','1','0','','','','','','82118665','','','','','','','','1','',1387)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(30,'fw001','','','1','0','','','','','','82112498','','','','','','','','1','',1386)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(31,'fw001','yug','','1','0','','','','','','82120057','','','','','','','','1','',1385)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(32,'fw001','','','1','0','','','','Ŷ','','8211309','','','','','','','','1','',1384)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(33,'fw001','','','1','0','','','','hiohihuihuo','','82127443','','','','','','','','1','',1381)
Insert Into JB_Contact( ct_id,own_id,ct_name,ct_aid,ct_sex,ct_married,ct_birthday,ct_title,ct_dept,ct_addr,ct_postcode,ct_phone,ct_fax,ct_mobile,ct_pager,ct_email,ct_Hphone,ct_biz,ct_memo,ct_flag,ct_type,cust_id ) Values(34,'fw001','ҳ','','1','0','','','','ձ','','82118111','','','','','','','','1','',1380)
GO

Insert Into JB_CustContact( own_id,cust_id,contact_id ) Values('fw001',1,7)
Insert Into JB_CustContact( own_id,cust_id,contact_id ) Values('fw001',14,5)
Insert Into JB_CustContact( own_id,cust_id,contact_id ) Values('fw001',14,6)
Insert Into JB_CustContact( own_id,cust_id,contact_id ) Values('fw001',14,8)
GO

Insert Into JB_CustEvent( cust_id,ce_subject,event_type,contact_id,emp_id,ce_begin,ce_end,ce_info,ce_desc ) Values(14,'ͻѯSFA',1,21,5,'2002-4-14','2002-4-14','','𸴿ͻһЩƷܸͻ')
Insert Into JB_CustEvent( cust_id,ce_subject,event_type,contact_id,emp_id,ce_begin,ce_end,ce_info,ce_desc ) Values(3,'ʿ',1,Null,2,'2002-4-16','2002-4-16','','')
Insert Into JB_CustEvent( cust_id,ce_subject,event_type,contact_id,emp_id,ce_begin,ce_end,ce_info,ce_desc ) Values(28,'sdfsdf',2,Null,5,'2002-6-10 10:00:00','2002-6-10 19:00:00','','')
GO

Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(3,'Fw001','CUST00004','˽ʤ','HLJS','bp','ɽൺ',10,55,Null,Null,14,4,3,7,'ҵ',0,'','ൺ','','','','','','','','','','',10,Null,Null,Null,0,4,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(4,'Fw001','CUST00001','ȷƼ޹˾','XFKJ','bp','',28,35,37,1,13,1,6,7,'ҵ',0,'','жɽ356Ŷɽ','123445','020-85369423','020-85632145','345345','','','micbos@online.sh.cn','www.microbos.com','','sdfsdfsdf',12345,Null,Null,Null,0,2,'0','sfdsf',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(5,'Fw001','CUST00002','Ƽ','JHSM','bp','',1,47,0,2,Null,2,Null,16,'',0,'','·ͥ԰B3','100080','010-62143126','','010-62143127','','','avicit@avicit.com','www.avicit.com','','',500000,Null,Null,Null,15,2,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(6,'Fw001','CUST00003','̫Ƽ޹˾','DTD','bp','chen',2,48,0,2,13,2,Null,15,'Сҵ',30000,'Ԫ־','Ϻл·755ţ¥19A','','021-64669897','021-64152871','021-64669897','','','amawu@dsh.com.cn','','','',0,Null,Null,Null,6,2,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(9,'fw001','CUST00005','ʳ޹˾','HTYS','cust','',2,48,0,0,15,1,5,15,'ҵ',0,'','зخ','123456','343545345','34534545','34353545','4564564576','','sfsd@3c.dom','fsdfsdf','sdfdsfsd','fsfsdf',342354,Null,Null,Null,5,Null,'1','sdfsdf',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(13,'fw001','CUST00008','װι˾','HUAYOU','cust','',27,54,0,0,16,2,0,0,'Сҵ',0,'','ɳнű·','','0731-8744534','','','138-34789234','','hu@oop.com','','','',0,Null,Null,Null,16,2,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(14,'fw001','CUST00006','ȹ˾','p01','cust','p0923',28,35,0,0,17,1,8,7,'Сҵ',1000,'100','','','020-84564566','','','','','','','','',0,Null,Null,Null,0,9,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(17,'fw001','CUST00009','ݸؿƼ޹˾','GZGT','','',28,35,37,0,15,5,8,15,'ҵ',Null,'','·1Ž2714','510600','020-87567159','020-87534872','020-87567159','','','sales@gsoft.com.cn','www.getsoft.com.cn','','',0,Null,Null,Null,8,9,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(19,'fw001','CUST00011','ʱƼ˾','HTS','','',1,47,0,0,14,0,3,18,'ҵ',Null,'','콨ĳ·10','','010-82922205','','010-82923987','','','erp@hollysys.com.cn','www.hollysys.com.cn','','',0,Null,Null,Null,10,12,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(20,'fw001','CUST00012','ó','HKYY','','',7,59,Null,Null,14,Null,8,Null,'',Null,'','ϵ·238Ž17C','','0411-2722229','021-64646574','0411-2722936','','','net_up@cmmail.com','','','',0,Null,Null,Null,11,12,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(21,'fw001','CUST00013','ʳƷ˾','BTGG','','',10,60,Null,Null,15,Null,Null,Null,'',Null,'','ҵ·199Ŷ10','','0537-2037979','','0537-2038925','','','butone@pubne.com','www.fast.com.tw','','',0,Null,Null,Null,12,12,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(22,'fw001','CUST00014','ǽ蹤̹˾','JDGY','','',10,60,Null,Null,14,Null,Null,Null,'',Null,'','ൺ','','0532-6879358','','0532-6879358','','','webmaster@goeasy.net','www.goeasy.com.cn','','',0,Null,Null,Null,13,1,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(23,'fw001','CUST00015','ǿƼ˾','YQX','','',3,Null,0,Null,16,Null,Null,Null,'',Null,'','Ͽж·11A12¥','','022-23673423','','','','','market@qi-xing.com','','','',0,Null,Null,Null,14,1,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(24,'fw001','CUST00016','ͨ','BKGM','','',10,60,Null,Null,15,Null,Null,Null,'',Null,'','·3¥10C','','0631-5813226','','1631-5819163','','','syst@anyi.com.cn','www.bokesoft.com','','',0,Null,Null,Null,13,1,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(25,'fw001','CUST00017','򿪷ȼ˾','AYD','','',3,Null,Null,Null,16,Null,Null,Null,'',Null,'','','','022-25328490','','022-25325296','','','anyi@cta.cq.cn','','','',0,Null,Null,Null,17,1,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(26,'fw001','CUST00018','Ӽ','AYX','','',3,Null,Null,Null,16,5,Null,18,'',Null,'','ʨ·170ź鷢8¥ ','','022-26390265','','022-26812741','','','','','','',0,Null,Null,Null,0,1,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(27,'fw001','CUST00019','徾۰˾','HGZM','','',3,Null,Null,Null,15,Null,Null,17,'',Null,'','濪Ƽ5203','','022-24375386','','022-24375387','','','','','','',0,Null,Null,Null,15,1,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(28,'fw001','CUST00020','߿Ƽ','','','',10,60,Null,Null,14,1,Null,7,'',Null,'','ׯ22','','022-25322023','','022-25302024','','','','','','',0,Null,Null,Null,0,1,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(29,'fw001','tj-20066','','','','',64,Null,Null,Null,14,Null,Null,Null,'',Null,'','ձ','','82118111','','','','','uihuio@8u89.com','www.fedd.com','','',0,Null,Null,Null,34,Null,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(30,'fw001','tj-20067','Ǽ','','','',65,Null,Null,Null,15,Null,Null,Null,'',Null,'','hiohihuihuo','','82127443','','','','','yguuu@uihui.com','www.uo.com','','',0,Null,Null,Null,33,Null,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(31,'fw001','tj-20068','ͨ','','','',63,Null,Null,Null,16,Null,Null,Null,'',Null,'','','','82122875','','','','','yghyui@uui.com','www,yugg.com','','',0,Null,Null,Null,0,Null,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(32,'fw001','tj-20069','й','','','',1,Null,Null,Null,14,Null,Null,Null,'',Null,'','yuiguio','','82112830','','','','','hjj@uiu.com','www.ihu.com','','',0,Null,Null,Null,0,Null,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(33,'fw001','tj-20070','Ϻ','','','',7,Null,Null,Null,14,Null,Null,Null,'',Null,'','Ŷ','','8211309','','','','','uiwhq@hui.com','www.ioij.com','','',0,Null,Null,Null,32,Null,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(34,'fw001','tj-20071','','','','',4,Null,Null,Null,14,Null,Null,Null,'',Null,'','ּ','','82120057','','','','','ghhjgy@ghu.com','www.hoij.com','','',0,Null,Null,Null,31,Null,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(35,'fw001','tj-20072','','','','',28,Null,Null,Null,Null,Null,Null,Null,'',Null,'','Ŷ','','82112498','','','','','yugyu@yugyui.com','www.iji.com','','',0,Null,Null,Null,30,Null,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(36,'fw001','tj-20073','','','','',28,Null,Null,Null,14,Null,Null,14,'',Null,'','','','82118665','','','','','yuyu@uighu.com','www.hug.com','','',0,Null,Null,Null,29,Null,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(37,'fw001','tj-20074','ݱ','','','',3,Null,Null,Null,15,Null,Null,7,'',Null,'','jnjcvjc','','24419664','','','','','ughhu@hj.com','www.yuuh.com','','',0,Null,Null,Null,28,Null,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(38,'fw001','786','ĵ','','','',28,35,37,Null,Null,Null,Null,Null,'',Null,'','','','82127806','','','','','huu@iouj.com','www.huh.com','','',0,Null,Null,Null,27,Null,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(39,'fw001','tj-20079','','','','',1,Null,Null,Null,14,Null,Null,Null,'',Null,'','ݵ͹','','82121872','','','','','ede@sina.com','','','',0,Null,Null,Null,26,Null,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(40,'fw001','tj-20080','Ϻ','','','',1,47,50,Null,14,2,3,7,'',Null,'','','','82111446','','','','','gg@uihu.com','www.ygu.com','','',0,Null,Null,Null,25,Null,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(41,'fw001','787','ݱ','','','',28,35,39,1,15,2,3,14,'ҵ',Null,'','','4344434','82118643','3434344','343434','136454343434','','ygui@ihif.com','www.uhui.com','','',0,Null,Null,Null,23,Null,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(42,'fw001','tj-20082','ĵ','','','',2,48,Null,2,17,9,Null,7,'',Null,'','Ϻ','444443','82118523','34444444','453333','136453354334','','fhu@uhfuio.com','www.cjnui.com','','',0,Null,Null,Null,24,Null,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(43,'fw001','tj-20083','','bgh','','',1,47,49,3,16,9,3,7,'ҵ',Null,'','','565655','82122875','54564545','5455455','1356776766','','yughu@eifhui.com','www.yudsyu.com.cn','rtyrtt','78888885',1000,Null,Null,Null,22,Null,'0','fght',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(44,'fw001','tj-20084','','','','',1,Null,Null,Null,20,2,Null,7,'',Null,'','˹','','82123717','','','','','heee@sohu.com','','','',0,Null,Null,Null,21,Null,'0','',Null,Null,Null,Null,Null,Null,'','','','')
Insert Into JB_CustInfo( CI_ID,own_id,CI_Code,CI_Name,CI_AID,CI_Type,CI_Abbr,Province_ID,City_ID,District_ID,Area_ID,GT_ID,Trade_ID,CK_ID,CS_ID,CI_Scale,CI_Fund,CI_Legal,CI_Addr,CI_PostCode,CI_Phone1,ci_phone2,CI_Fax,CI_Mobile,CI_Pager,CI_Email,CI_Web,CI_Bank,CI_Account,CI_Credit,CI_TotalSales,CI_Arrearage,CI_Turnover,Contact_ID,Emp_ID,CI_Forbid,CI_Desc,CI_Int01,CI_Int02,CI_Int03,CI_Dec01,CI_Dec02,CI_Dec03,CI_Char01,CI_Char02,CI_Char03,CI_Char04 ) Values(45,'fw001','tj-20085','TCL','ty','','',28,35,37,1,14,5,3,7,'ҵ',Null,'','','674475','82112270','56745545','76768776','13845645645','','zhub@kjoij.com','www.jeruiui.com','','6877785',0,Null,Null,Null,19,Null,'0','hjjjjjjy',Null,Null,Null,Null,Null,Null,'','','','')
GO

Insert Into JB_RivalInfo( ri_id,own_id,cust_id,RI_Type,RI_Name,CK_ID,Area_ID,RI_Fund,RI_StaffNum,RI_Turnover,RI_Addr,RI_PostCode,RI_Phone,RI_Fax,RI_Email,RI_Desc ) Values(2,'fw001',Null,'ownrival  ','Oracle',3,Null,10000000,50,50000000,'Bei Jing','100018','010-654321','010-654321','','')
Insert Into JB_RivalInfo( ri_id,own_id,cust_id,RI_Type,RI_Name,CK_ID,Area_ID,RI_Fund,RI_StaffNum,RI_Turnover,RI_Addr,RI_PostCode,RI_Phone,RI_Fax,RI_Email,RI_Desc ) Values(3,'fw001',Null,'ownrival  ','ͬ˾',Null,Null,333,33,3333,'fsdafasdf','3333333','333333','3333','se@sdf.cod','fasfasdf""')
Insert Into JB_RivalInfo( ri_id,own_id,cust_id,RI_Type,RI_Name,CK_ID,Area_ID,RI_Fund,RI_StaffNum,RI_Turnover,RI_Addr,RI_PostCode,RI_Phone,RI_Fax,RI_Email,RI_Desc ) Values(4,'fw001',Null,'ownrival  ','fasdf',Null,Null,Null,Null,Null,'','','','','','')
Insert Into JB_RivalInfo( ri_id,own_id,cust_id,RI_Type,RI_Name,CK_ID,Area_ID,RI_Fund,RI_StaffNum,RI_Turnover,RI_Addr,RI_PostCode,RI_Phone,RI_Fax,RI_Email,RI_Desc ) Values(5,'fw001',25,'custrival ','test',3,Null,Null,Null,Null,'dfsf','','','','','')
Insert Into JB_RivalInfo( ri_id,own_id,cust_id,RI_Type,RI_Name,CK_ID,Area_ID,RI_Fund,RI_StaffNum,RI_Turnover,RI_Addr,RI_PostCode,RI_Phone,RI_Fax,RI_Email,RI_Desc ) Values(6,'fw001',28,'custrival ','esfd',Null,Null,Null,Null,Null,'','','','','','')
GO

Insert Into JB_RivalProd( own_id,RI_ID,RP_ID,RP_Name,RP_Type,RP_Unit,RP_Price,RP_Strength,RP_Weakness,RP_Tactic,RP_Memo ) Values('fw001',1,1,'ISO9000','ѯ֤','',20000,'dfasdf','fasdfasdf','','')
Insert Into JB_RivalProd( own_id,RI_ID,RP_ID,RP_Name,RP_Type,RP_Unit,RP_Price,RP_Strength,RP_Weakness,RP_Tactic,RP_Memo ) Values('fw001',1,2,'SFA Software','dfdasf','',12000,'asdf','dfas','','fasdfasdfds')
Insert Into JB_RivalProd( own_id,RI_ID,RP_ID,RP_Name,RP_Type,RP_Unit,RP_Price,RP_Strength,RP_Weakness,RP_Tactic,RP_Memo ) Values('fw001',2,6,'','','̨',3000,'very good','color','','I come back!')
Insert Into JB_RivalProd( own_id,RI_ID,RP_ID,RP_Name,RP_Type,RP_Unit,RP_Price,RP_Strength,RP_Weakness,RP_Tactic,RP_Memo ) Values('fw001',2,7,'','','̨',3000,'very good','color','','I come back!')
Insert Into JB_RivalProd( own_id,RI_ID,RP_ID,RP_Name,RP_Type,RP_Unit,RP_Price,RP_Strength,RP_Weakness,RP_Tactic,RP_Memo ) Values('fw001',2,9,'ԱЧ','dfasfdasdf','asdfasdf',333,'dfasdfasdfa','sdfasdfasdf','','<%%><h1>chen</h1>')
Insert Into JB_RivalProd( own_id,RI_ID,RP_ID,RP_Name,RP_Type,RP_Unit,RP_Price,RP_Strength,RP_Weakness,RP_Tactic,RP_Memo ) Values('FW001',2,10,'ʹϵͳ','','',20000,'','','','')
Insert Into JB_RivalProd( own_id,RI_ID,RP_ID,RP_Name,RP_Type,RP_Unit,RP_Price,RP_Strength,RP_Weakness,RP_Tactic,RP_Memo ) Values('fw001',3,11,'CRM','','',18000,'','','','')
Insert Into JB_RivalProd( own_id,RI_ID,RP_ID,RP_Name,RP_Type,RP_Unit,RP_Price,RP_Strength,RP_Weakness,RP_Tactic,RP_Memo ) Values('fw001',3,12,'','','',150000,'','','','')
Insert Into JB_RivalProd( own_id,RI_ID,RP_ID,RP_Name,RP_Type,RP_Unit,RP_Price,RP_Strength,RP_Weakness,RP_Tactic,RP_Memo ) Values('fw001',3,13,'CRM','','',200000,'','','','')
Insert Into JB_RivalProd( own_id,RI_ID,RP_ID,RP_Name,RP_Type,RP_Unit,RP_Price,RP_Strength,RP_Weakness,RP_Tactic,RP_Memo ) Values('fw001',3,14,'dasdf','','',Null,'fasdfasdfasdf','','','')
Insert Into JB_RivalProd( own_id,RI_ID,RP_ID,RP_Name,RP_Type,RP_Unit,RP_Price,RP_Strength,RP_Weakness,RP_Tactic,RP_Memo ) Values('fw001',3,15,'Software','','',Null,'asdfasdf','asdfasfas','fasdfasdfasdf','asdfasdfasdfasdfasdfasdf')
Insert Into JB_RivalProd( own_id,RI_ID,RP_ID,RP_Name,RP_Type,RP_Unit,RP_Price,RP_Strength,RP_Weakness,RP_Tactic,RP_Memo ) Values('fw001',1,16,'SFA','','',1200,'','','','ע˵')
GO

Insert Into JB_SupplyInfo( SP_id,own_id,cust_id,SP_Name,SP_Contact,SP_Addr,SP_PostCode,SP_Phone,SP_Fax,SP_Email,SP_http,SP_Desc ) Values(1,'fw001',913,'4wetrerter','erter','erterte','','456456','','','','')
GO

Insert Into JC_ActionDef( rid,own_id,dept_id,ad_Name,ad_type ) Values(1,'Fw001','fw001','½','market')
Insert Into JC_ActionDef( rid,own_id,dept_id,ad_Name,ad_type ) Values(3,'Fw001','fw001','绰','sales')
Insert Into JC_ActionDef( rid,own_id,dept_id,ad_Name,ad_type ) Values(4,'Fw001','fw001','ʼ','sales')
Insert Into JC_ActionDef( rid,own_id,dept_id,ad_Name,ad_type ) Values(5,'Fw001','fw001','ʺ','care')
Insert Into JC_ActionDef( rid,own_id,dept_id,ad_Name,ad_type ) Values(6,'Fw001','fw001','','care')
Insert Into JC_ActionDef( rid,own_id,dept_id,ad_Name,ad_type ) Values(7,'Fw001','fw001','֯ѵ','service')
Insert Into JC_ActionDef( rid,own_id,dept_id,ad_Name,ad_type ) Values(8,'Fw001','fw001','ά','service')
Insert Into JC_ActionDef( rid,own_id,dept_id,ad_Name,ad_type ) Values(58,'fw001','fw001','ﱸ','market')
Insert Into JC_ActionDef( rid,own_id,dept_id,ad_Name,ad_type ) Values(59,'fw001','fw001','ִ','market')
Insert Into JC_ActionDef( rid,own_id,dept_id,ad_Name,ad_type ) Values(60,'fw001','fw001','ѷ','market')
Insert Into JC_ActionDef( rid,own_id,dept_id,ad_Name,ad_type ) Values(61,'fw001','fw001','ڶ׶','market')
Insert Into JC_ActionDef( rid,own_id,dept_id,ad_Name,ad_type ) Values(109,'fw001','','Լ','sales')
Insert Into JC_ActionDef( rid,own_id,dept_id,ad_Name,ad_type ) Values(110,'fw001','','ݷ','sales')
Insert Into JC_ActionDef( rid,own_id,dept_id,ad_Name,ad_type ) Values(111,'fw001','','','sales')
Insert Into JC_ActionDef( rid,own_id,dept_id,ad_Name,ad_type ) Values(112,'fw001','','豸װ','service')
GO

Insert Into JC_ActResult( ar_id,own_id,ar_name ) Values(1,'fw001','ۻٽ')
Insert Into JC_ActResult( ar_id,own_id,ar_name ) Values(2,'fw001','ٽͻϵ')
Insert Into JC_ActResult( ar_id,own_id,ar_name ) Values(3,'fw001','ͻȷ')
Insert Into JC_ActResult( ar_id,own_id,ar_name ) Values(4,'fw001','ͻ')
GO

Insert Into JC_ActType( at_id,own_id,at_name ) Values(1,'fw001','νӴ')
Insert Into JC_ActType( at_id,own_id,at_name ) Values(2,'fw001','ϵά')
Insert Into JC_ActType( at_id,own_id,at_name ) Values(3,'fw001','Ŀ֤')
Insert Into JC_ActType( at_id,own_id,at_name ) Values(4,'fw001','')
Insert Into JC_ActType( at_id,own_id,at_name ) Values(5,'fw001','ֵ')
Insert Into JC_ActType( at_id,own_id,at_name ) Values(6,'fw001','̸')
Insert Into JC_ActType( at_id,own_id,at_name ) Values(7,'fw001','ȷ')
GO

Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(1,'fw001','BJ','',0,0,0,'-0-001',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(2,'fw001','SH','Ϻ',0,0,0,'-0-002',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(3,'fw001','TJ','',0,0,0,'-0-003',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(4,'fw001','CQ','',0,0,0,'-0-004',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(5,'fw001','HLJ','',0,0,0,'-0-005',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(6,'fw001','JL','',0,0,0,'-0-006',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(7,'fw001','LN','',0,0,0,'-0-007',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(8,'fw001','HBHB','ӱ',0,0,0,'-0-008',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(9,'fw001','HN','',0,0,0,'-0-009',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(10,'fw001','HBSD','ɽ',0,0,0,'-0-010',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(11,'fw001','SX','ɽ',0,0,0,'-0-011',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(12,'fw001','GH','',0,0,0,'-0-012',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(13,'fw001','NX','',0,0,0,'-0-013',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(14,'fw001','QH','ຣ',0,0,0,'-0-014',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(15,'fw001','XJ','½',0,0,0,'-0-015',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(16,'fw001','XZ','',0,0,0,'-0-016',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(17,'fw001','AH','',0,0,0,'-0-017',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(18,'fw001','HBSX','',0,0,0,'-0-018',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(19,'fw001','SQ','Ĵ',0,0,0,'-0-019',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(20,'fw001','YN','',0,0,0,'-0-020',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(21,'fw001','NMG','ɹ',0,0,0,'-0-021',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(22,'fw001','GUZ','',0,0,0,'-0-022',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(23,'fw001','JS','',0,0,0,'-0-023',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(24,'fw001','ZJ','㽭',0,0,0,'-0-024',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(25,'fw001','JXI','',0,0,0,'-0-025',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(26,'fw001','HUB','',0,0,0,'-0-026',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(27,'fw001','HUN','',0,0,0,'-0-027',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(28,'fw001','GD','㶫',0,0,0,'-0-028',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(29,'fw001','GX','',0,0,0,'-0-029',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(30,'fw001','FJ','',0,0,0,'-0-030',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(31,'fw001','HAN','',0,0,0,'-0-031',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(32,'fw001','XG','',0,0,0,'-0-032',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(33,'fw001','AM','',0,0,0,'-0-033',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(34,'fw001','TW','̨',0,0,0,'-0-034',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(35,'fw001','GDGZ','',0,0,1,'-0-028-035',28)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(36,'fw001','GDSZ','',0,0,1,'-0-028-036',28)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(37,'fw001','GZTH','',0,0,2,'-0-028-035-037',35)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(38,'fw001','GZHZ','',0,0,2,'-0-028-035-038',35)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(39,'fw001','GZDS','ɽ',0,0,2,'-0-028-035-039',35)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(40,'fw001','GZYS','Խ',0,0,2,'-0-028-035-040',35)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(41,'fw001','GZBY','',0,0,2,'-0-028-035-041',35)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(42,'fw001','GZLW','',0,0,2,'-0-028-035-042',35)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(43,'fw001','GZHP','',0,0,2,'-0-028-035-043',35)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(44,'fw001','GZPY','خ',0,0,2,'-0-028-035-044',35)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(45,'fw001','GZFC','',0,0,2,'-0-028-035-045',35)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(46,'fw001','GZHD','',0,0,2,'-0-028-035-046',35)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(47,'fw001','BJS','',0,0,1,'-0-001-047',1)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(48,'fw001','SHS','Ϻ',0,0,1,'-0-002-048',2)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(49,'fw001','BJCY','',0,0,2,'-0-001-047-049',47)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(50,'fw001','BJHD','',0,0,2,'-0-001-047-050',47)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(52,'fw001','SZFT','',0,0,2,'-0-028-036-052',36)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(53,'fw001','SZLH','޺',0,0,2,'-0-028-036-053',36)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(54,'fw001','HNCS','ɳ',0,0,1,'-0-027-054',27)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(55,'fw001','SDJN','',0,0,1,'-0-010-055',10)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(56,'fw001','STQ','̨',0,0,2,'-0-001-047-056',47)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(57,'fw001','SZNS','ɽ',0,0,2,'-0-028-036-057',36)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(58,'fw001','HNYY','',0,0,1,'-0-027-058',27)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(59,'fw001','LNDL','',0,0,1,'-0-007-059',7)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(60,'fw001','SDQD','ൺ',0,0,1,'-0-010-060',10)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(61,'fw001','am00001','',0,0,0,'-0-061',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(62,'fw001','af00001','Ϸǵ',0,0,0,'-0-062',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(63,'fw001','788','',0,0,0,'-0-063',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(64,'fw001','566','ձ',0,0,0,'-0-064',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(65,'fw001','787','',0,0,0,'-0-065',0)
Insert Into JC_Area( area_id,own_id,area_code,area_name,area_rootid,area_baseid,levels,path,parentID ) Values(66,'fw001','895','˹',0,0,0,'-0-066',0)
GO

Insert Into JC_CustKind( ck_id,own_id,ck_name ) Values(3,'Fw001','ҵ')
Insert Into JC_CustKind( ck_id,own_id,ck_name ) Values(5,'Fw001','ۡ¡̨ҵ')
Insert Into JC_CustKind( ck_id,own_id,ck_name ) Values(6,'Fw001','ɷҵ')
Insert Into JC_CustKind( ck_id,own_id,ck_name ) Values(7,'fw001','ҵ')
Insert Into JC_CustKind( ck_id,own_id,ck_name ) Values(8,'fw001','Ӫҵ')
Insert Into JC_CustKind( ck_id,own_id,ck_name ) Values(9,'fw001','ҵ')
GO

Insert Into JC_EventType( et_id,own_id,et_name ) Values(1,'fw001','Ʒѯ')
Insert Into JC_EventType( et_id,own_id,et_name ) Values(2,'fw001','۸ѯ')
Insert Into JC_EventType( et_id,own_id,et_name ) Values(3,'fw001','ѯ')
Insert Into JC_EventType( et_id,own_id,et_name ) Values(4,'fw001','ʾ')
Insert Into JC_EventType( et_id,own_id,et_name ) Values(5,'fw001','')
Insert Into JC_EventType( et_id,own_id,et_name ) Values(6,'fw001','òƷ')
Insert Into JC_EventType( et_id,own_id,et_name ) Values(7,'fw001','μѵ')
Insert Into JC_EventType( et_id,own_id,et_name ) Values(8,'fw001','ѯ')
Insert Into JC_EventType( et_id,own_id,et_name ) Values(9,'fw001','')
GO

Insert Into JC_ExpenseType( et_id,own_id,et_name ) Values(1,'fw001','ס޷')
Insert Into JC_ExpenseType( et_id,own_id,et_name ) Values(2,'fw001','ɻƱ')
Insert Into JC_ExpenseType( et_id,own_id,et_name ) Values(3,'fw001','ͷ')
Insert Into JC_ExpenseType( et_id,own_id,et_name ) Values(4,'fw001','')
Insert Into JC_ExpenseType( et_id,own_id,et_name ) Values(5,'fw001','Ʒ')
Insert Into JC_ExpenseType( et_id,own_id,et_name ) Values(6,'fw001','ַ')
Insert Into JC_ExpenseType( et_id,own_id,et_name ) Values(7,'fw001','ϴ·')
Insert Into JC_ExpenseType( et_id,own_id,et_name ) Values(8,'fw001','')
Insert Into JC_ExpenseType( et_id,own_id,et_name ) Values(9,'fw001','绰')
Insert Into JC_ExpenseType( et_id,own_id,et_name ) Values(10,'fw001','')
Insert Into JC_ExpenseType( et_id,own_id,et_name ) Values(11,'fw001','Ʊ')
Insert Into JC_ExpenseType( et_id,own_id,et_name ) Values(12,'fw001','⳵')
Insert Into JC_ExpenseType( et_id,own_id,et_name ) Values(13,'fw001','޷')
Insert Into JC_ExpenseType( et_id,own_id,et_name ) Values(14,'fw001','')
Insert Into JC_ExpenseType( et_id,own_id,et_name ) Values(15,'fw001','ͣ')
Insert Into JC_ExpenseType( et_id,own_id,et_name ) Values(16,'fw001','ͨз')
Insert Into JC_ExpenseType( et_id,own_id,et_name ) Values(17,'fw001','ͷ')
Insert Into JC_ExpenseType( et_id,own_id,et_name ) Values(18,'fw001','˷')
Insert Into JC_ExpenseType( et_id,own_id,et_name ) Values(19,'fw001','')
GO

Insert Into JC_GradeType( rid,own_id,gt_name,gt_type ) Values(14,'fw001','ƿͻ','cust')
Insert Into JC_GradeType( rid,own_id,gt_name,gt_type ) Values(15,'fw001','ƿͻ','cust')
Insert Into JC_GradeType( rid,own_id,gt_name,gt_type ) Values(16,'fw001','ͭƿͻ','cust')
Insert Into JC_GradeType( rid,own_id,gt_name,gt_type ) Values(17,'fw001','ͨͻ','cust')
Insert Into JC_GradeType( rid,own_id,gt_name,gt_type ) Values(18,'fw001','Ǳڿͻ','cust')
Insert Into JC_GradeType( rid,own_id,gt_name,gt_type ) Values(19,'fw001','ǩԼͻ','cust')
Insert Into JC_GradeType( rid,own_id,gt_name,gt_type ) Values(20,'fw001','ֱӿͻ','cust')
Insert Into JC_GradeType( rid,own_id,gt_name,gt_type ) Values(21,'fw001','','cust')
Insert Into JC_GradeType( rid,own_id,gt_name,gt_type ) Values(22,'fw001','','cust')
Insert Into JC_GradeType( rid,own_id,gt_name,gt_type ) Values(23,'fw001','','cust')
GO

Insert Into JC_LostSales( rid,own_id,ls_content ) Values(1,'Fw001','۹')
Insert Into JC_LostSales( rid,own_id,ls_content ) Values(2,'Fw001','ṩŻ')
Insert Into JC_LostSales( rid,own_id,ls_content ) Values(3,'Fw001','ͻԲƷ')
Insert Into JC_LostSales( rid,own_id,ls_content ) Values(4,'Fw001','ͻԷ̬Ȳ')
Insert Into JC_LostSales( rid,own_id,ls_content ) Values(5,'Fw001','ͻԸʽ')
Insert Into JC_LostSales( rid,own_id,ls_content ) Values(6,'Fw001','ͻԽʽ')
GO

Insert Into JC_OpptPhase( op_id,own_id,op_name ) Values(1,'fw001','10%ʼӴ')
Insert Into JC_OpptPhase( op_id,own_id,op_name ) Values(2,'fw001','20%ͻȤ')
Insert Into JC_OpptPhase( op_id,own_id,op_name ) Values(3,'fw001','30%Ȥȷ')
Insert Into JC_OpptPhase( op_id,own_id,op_name ) Values(4,'fw001','40%ͻ෽ѡ')
Insert Into JC_OpptPhase( op_id,own_id,op_name ) Values(5,'fw001','50%ͻѡ')
Insert Into JC_OpptPhase( op_id,own_id,op_name ) Values(6,'fw001','60%Ϻ')
Insert Into JC_OpptPhase( op_id,own_id,op_name ) Values(7,'fw001','70%ͨ')
Insert Into JC_OpptPhase( op_id,own_id,op_name ) Values(8,'fw001','80%')
Insert Into JC_OpptPhase( op_id,own_id,op_name ) Values(9,'fw001','90%¶')
Insert Into JC_OpptPhase( op_id,own_id,op_name ) Values(10,'fw001','100%')
GO

Insert Into JC_OpptStatus( os_id,own_id,os_name ) Values(1,'fw001','ɹ')
Insert Into JC_OpptStatus( os_id,own_id,os_name ) Values(2,'fw001','')
Insert Into JC_OpptStatus( os_id,own_id,os_name ) Values(3,'fw001','')
Insert Into JC_OpptStatus( os_id,own_id,os_name ) Values(4,'fw001','ʧ')
Insert Into JC_OpptStatus( os_id,own_id,os_name ) Values(5,'fw001','')
Insert Into JC_OpptStatus( os_id,own_id,os_name ) Values(6,'fw001','ر')
GO

Insert Into JC_OpptType( ot_id,own_id,ot_name ) Values(1,'fw001','ͨ')
Insert Into JC_OpptType( ot_id,own_id,ot_name ) Values(2,'fw001','ظ')
Insert Into JC_OpptType( ot_id,own_id,ot_name ) Values(3,'fw001','ֱ')
GO

Insert Into JC_PayMode( pm_id,own_id,pm_name ) Values(1,'fw001','ֽ')
Insert Into JC_PayMode( pm_id,own_id,pm_name ) Values(2,'fw001','֧Ʊ')
GO

Insert Into JC_Possible( rid,own_id,possible_scope,possible_max,possible_min ) Values(1,'fw001','0-10%',10,0)
Insert Into JC_Possible( rid,own_id,possible_scope,possible_max,possible_min ) Values(2,'fw001','10-20%',20,10)
Insert Into JC_Possible( rid,own_id,possible_scope,possible_max,possible_min ) Values(3,'fw001','20-30%',30,20)
Insert Into JC_Possible( rid,own_id,possible_scope,possible_max,possible_min ) Values(4,'fw001','30-40%',40,30)
Insert Into JC_Possible( rid,own_id,possible_scope,possible_max,possible_min ) Values(5,'fw001','40-50%',50,40)
Insert Into JC_Possible( rid,own_id,possible_scope,possible_max,possible_min ) Values(6,'fw001','50-60%',60,50)
Insert Into JC_Possible( rid,own_id,possible_scope,possible_max,possible_min ) Values(7,'fw001','60-70%',70,60)
Insert Into JC_Possible( rid,own_id,possible_scope,possible_max,possible_min ) Values(8,'fw001','70-80%',80,70)
Insert Into JC_Possible( rid,own_id,possible_scope,possible_max,possible_min ) Values(9,'fw001','80-90%',90,80)
Insert Into JC_Possible( rid,own_id,possible_scope,possible_max,possible_min ) Values(10,'fw001','90-100%',100,90)
GO

Insert Into JC_Progress( rid,own_id,prg_content ) Values(1,'fw001','')
Insert Into JC_Progress( rid,own_id,prg_content ) Values(2,'fw001','֪ͨ')
Insert Into JC_Progress( rid,own_id,prg_content ) Values(3,'fw001','绰')
Insert Into JC_Progress( rid,own_id,prg_content ) Values(4,'fw001','')
Insert Into JC_Progress( rid,own_id,prg_content ) Values(5,'fw001','ʼ')
Insert Into JC_Progress( rid,own_id,prg_content ) Values(6,'fw001','ݷÿͻ')
Insert Into JC_Progress( rid,own_id,prg_content ) Values(7,'fw001','')
Insert Into JC_Progress( rid,own_id,prg_content ) Values(8,'fw001','')
GO

Insert Into JC_Region( JR_ID,own_id,JR_Name ) Values(1,'fw001','ϵ')
Insert Into JC_Region( JR_ID,own_id,JR_Name ) Values(2,'fw001','е')
Insert Into JC_Region( JR_ID,own_id,JR_Name ) Values(3,'fw001','')
Insert Into JC_Region( JR_ID,own_id,JR_Name ) Values(4,'fw001','')
Insert Into JC_Region( JR_ID,own_id,JR_Name ) Values(5,'fw001','')
Insert Into JC_Region( JR_ID,own_id,JR_Name ) Values(6,'fw001','')
Insert Into JC_Region( JR_ID,own_id,JR_Name ) Values(7,'fw001','')
GO

Insert Into JC_RequireType( rt_id,own_id,rt_name ) Values(1,'fw001','ʹû')
Insert Into JC_RequireType( rt_id,own_id,rt_name ) Values(2,'fw001','ʹص')
Insert Into JC_RequireType( rt_id,own_id,rt_name ) Values(3,'fw001','Դ')
Insert Into JC_RequireType( rt_id,own_id,rt_name ) Values(4,'fw001','Ȥ')
GO

Insert Into JC_SourceType( rid,own_id,st_name,st_type ) Values(1,'Fw001','','sales')
Insert Into JC_SourceType( rid,own_id,st_name,st_type ) Values(2,'Fw001','ӹ','sales')
Insert Into JC_SourceType( rid,own_id,st_name,st_type ) Values(3,'Fw001','г','sales')
Insert Into JC_SourceType( rid,own_id,st_name,st_type ) Values(5,'Fw001','','sales')
Insert Into JC_SourceType( rid,own_id,st_name,st_type ) Values(7,'Fw001','Ͽͻ','cust')
Insert Into JC_SourceType( rid,own_id,st_name,st_type ) Values(14,'fw001','','cust')
Insert Into JC_SourceType( rid,own_id,st_name,st_type ) Values(15,'fw001','Ʒ','cust')
Insert Into JC_SourceType( rid,own_id,st_name,st_type ) Values(16,'fw001','ͨ','cust')
Insert Into JC_SourceType( rid,own_id,st_name,st_type ) Values(17,'fw001','˽','cust')
Insert Into JC_SourceType( rid,own_id,st_name,st_type ) Values(18,'fw001','ϵͻ','cust')
Insert Into JC_SourceType( rid,own_id,st_name,st_type ) Values(20,'fw001','ھ','sales')
Insert Into JC_SourceType( rid,own_id,st_name,st_type ) Values(21,'fw001','ϼ','sales')
Insert Into JC_SourceType( rid,own_id,st_name,st_type ) Values(22,'fw001','','sales')
Insert Into JC_SourceType( rid,own_id,st_name,st_type ) Values(23,'fw001','绰','sales')
Insert Into JC_SourceType( rid,own_id,st_name,st_type ) Values(24,'fw001','WEB/ʼ','sales')
Insert Into JC_SourceType( rid,own_id,st_name,st_type ) Values(25,'fw001','ɹ','so')
Insert Into JC_SourceType( rid,own_id,st_name,st_type ) Values(26,'fw001','ֱ','so')
GO

Insert Into JC_TaskStatus( rid,own_id,ts_status,ts_type,ts_delete ) Values(6,'Fw001','½','market','0')
Insert Into JC_TaskStatus( rid,own_id,ts_status,ts_type,ts_delete ) Values(9,'Fw001','','market','0')
Insert Into JC_TaskStatus( rid,own_id,ts_status,ts_type,ts_delete ) Values(11,'Fw001','½','sales','0')
Insert Into JC_TaskStatus( rid,own_id,ts_status,ts_type,ts_delete ) Values(13,'Fw001','½','care','0')
Insert Into JC_TaskStatus( rid,own_id,ts_status,ts_type,ts_delete ) Values(16,'Fw001','','sales','0')
Insert Into JC_TaskStatus( rid,own_id,ts_status,ts_type,ts_delete ) Values(17,'Fw001','','sales','0')
Insert Into JC_TaskStatus( rid,own_id,ts_status,ts_type,ts_delete ) Values(19,'Fw001','','care','0')
Insert Into JC_TaskStatus( rid,own_id,ts_status,ts_type,ts_delete ) Values(20,'Fw001','','care','0')
Insert Into JC_TaskStatus( rid,own_id,ts_status,ts_type,ts_delete ) Values(22,'Fw001','','sales','0')
Insert Into JC_TaskStatus( rid,own_id,ts_status,ts_type,ts_delete ) Values(23,'Fw001','ʧ','sales','0')
Insert Into JC_TaskStatus( rid,own_id,ts_status,ts_type,ts_delete ) Values(24,'Fw001','ʧ','service','0')
Insert Into JC_TaskStatus( rid,own_id,ts_status,ts_type,ts_delete ) Values(25,'Fw001','ʧ','care','0')
Insert Into JC_TaskStatus( rid,own_id,ts_status,ts_type,ts_delete ) Values(26,'Fw001','߻','care','0')
Insert Into JC_TaskStatus( rid,own_id,ts_status,ts_type,ts_delete ) Values(27,'Fw001','߻','service','0')
Insert Into JC_TaskStatus( rid,own_id,ts_status,ts_type,ts_delete ) Values(28,'Fw001','߻','sales','0')
Insert Into JC_TaskStatus( rid,own_id,ts_status,ts_type,ts_delete ) Values(29,'Fw001','߻','market','0')
Insert Into JC_TaskStatus( rid,own_id,ts_status,ts_type,ts_delete ) Values(430,'fw001','sdsdf','sell','1')
Insert Into JC_TaskStatus( rid,own_id,ts_status,ts_type,ts_delete ) Values(440,'Fw001','','market','0')
Insert Into JC_TaskStatus( rid,own_id,ts_status,ts_type,ts_delete ) Values(442,'fw001','½','service','1')
Insert Into JC_TaskStatus( rid,own_id,ts_status,ts_type,ts_delete ) Values(443,'fw001','','service','1')
GO

Insert Into JC_Trade( trade_id,own_id,trade_name ) Values(1,'Fw001','ҵ')
Insert Into JC_Trade( trade_id,own_id,trade_name ) Values(2,'Fw001','ҵ')
Insert Into JC_Trade( trade_id,own_id,trade_name ) Values(4,'Fw001','ʳƷӹҵ')
Insert Into JC_Trade( trade_id,own_id,trade_name ) Values(5,'Fw001','ҵ')
Insert Into JC_Trade( trade_id,own_id,trade_name ) Values(6,'Fw001','֯ҵ')
Insert Into JC_Trade( trade_id,own_id,trade_name ) Values(7,'Fw001','ҵ')
Insert Into JC_Trade( trade_id,own_id,trade_name ) Values(8,'Fw001','')
Insert Into JC_Trade( trade_id,own_id,trade_name ) Values(9,'fw001','ҵ')
Insert Into JC_Trade( trade_id,own_id,trade_name ) Values(10,'fw001','Ƶҵ')
Insert Into JC_Trade( trade_id,own_id,trade_name ) Values(11,'fw001','ҵ')
Insert Into JC_Trade( trade_id,own_id,trade_name ) Values(12,'fw001','ҵ')
Insert Into JC_Trade( trade_id,own_id,trade_name ) Values(13,'fw001','ҵ')
Insert Into JC_Trade( trade_id,own_id,trade_name ) Values(14,'fw001','ҵ')
Insert Into JC_Trade( trade_id,own_id,trade_name ) Values(15,'fw001','ҵ')
Insert Into JC_Trade( trade_id,own_id,trade_name ) Values(16,'fw001','زҵ')
GO

Insert Into JC_TypeDef( td_id,own_id,td_name,td_type ) Values(1,'fw001','ýѯ','info')
Insert Into JC_TypeDef( td_id,own_id,td_name,td_type ) Values(4,'fw001','гѯ','info')
Insert Into JC_TypeDef( td_id,own_id,td_name,td_type ) Values(5,'fw001','ҵ','info')
Insert Into JC_TypeDef( td_id,own_id,td_name,td_type ) Values(6,'fw001','׼ƶ','doc')
Insert Into JC_TypeDef( td_id,own_id,td_name,td_type ) Values(8,'fw001','׼ƶ','doc')
Insert Into JC_TypeDef( td_id,own_id,td_name,td_type ) Values(9,'fw001','׼ƶ','doc')
Insert Into JC_TypeDef( td_id,own_id,td_name,td_type ) Values(10,'fw001','ķ','info')
Insert Into JC_TypeDef( td_id,own_id,td_name,td_type ) Values(11,'fw001','','info')
Insert Into JC_TypeDef( td_id,own_id,td_name,td_type ) Values(12,'fw001','߻','info')
Insert Into JC_TypeDef( td_id,own_id,td_name,td_type ) Values(13,'fw001','ۺͬ','contract')
Insert Into JC_TypeDef( td_id,own_id,td_name,td_type ) Values(14,'fw001','Ʒͬ','contract')
Insert Into JC_TypeDef( td_id,own_id,td_name,td_type ) Values(15,'fw001','Ͷͬ','contract')
Insert Into JC_TypeDef( td_id,own_id,td_name,td_type ) Values(21,'fw001','ͻ','care')
Insert Into JC_TypeDef( td_id,own_id,td_name,td_type ) Values(22,'fw001','ֵͻ','care')
Insert Into JC_TypeDef( td_id,own_id,td_name,td_type ) Values(23,'fw001','Aͻ','care')
Insert Into JC_TypeDef( td_id,own_id,td_name,td_type ) Values(24,'fw001','Bͻ','care')
Insert Into JC_TypeDef( td_id,own_id,td_name,td_type ) Values(25,'fw001','ƿͻ','email')
Insert Into JC_TypeDef( td_id,own_id,td_name,td_type ) Values(26,'fw001','ƿͻ','email')
Insert Into JC_TypeDef( td_id,own_id,td_name,td_type ) Values(27,'fw001','Ǳڿͻ','email')
Insert Into JC_TypeDef( td_id,own_id,td_name,td_type ) Values(28,'fw001','ֱӿͻ','email')
Insert Into JC_TypeDef( td_id,own_id,td_name,td_type ) Values(29,'fw001','ͭƿͻ','email')
Insert Into JC_TypeDef( td_id,own_id,td_name,td_type ) Values(30,'fw001','','email')
Insert Into JC_TypeDef( td_id,own_id,td_name,td_type ) Values(31,'fw001','','email')
Insert Into JC_TypeDef( td_id,own_id,td_name,td_type ) Values(32,'fw001','ƿͻ','care')
Insert Into JC_TypeDef( td_id,own_id,td_name,td_type ) Values(33,'fw001','ƿͻ','care')
GO

Insert Into JC_Unit( rid,own_id,unit_name,unit_spec ) Values(1,'Fw001','̨','')
Insert Into JC_Unit( rid,own_id,unit_name,unit_spec ) Values(2,'Fw001','','')
Insert Into JC_Unit( rid,own_id,unit_name,unit_spec ) Values(3,'Fw001','','')
Insert Into JC_Unit( rid,own_id,unit_name,unit_spec ) Values(4,'Fw001','','')
Insert Into JC_Unit( rid,own_id,unit_name,unit_spec ) Values(5,'Fw001','','')
Insert Into JC_Unit( rid,own_id,unit_name,unit_spec ) Values(6,'Fw001','','')
Insert Into JC_Unit( rid,own_id,unit_name,unit_spec ) Values(7,'fw001','֧','')
GO

Insert Into JT_Owner( own_id,own_Name,own_EngName,own_Abbr,own_Addr,own_Manager,own_web,own_Email,own_Phone,own_Fax,own_PostCode,own_City,own_Province,own_Flag ) Values('fw001','ݸ޹˾','GuangZhou Fuwise Software LTD.CO','Fuwise','','AAA','http://www.fuwise.com','market@fuwise.com','','','','','','1')
GO

Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',40,Null,33,2,'2002-6-5',1,1,'','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',43,Null,1000,1,'2002-6-5',1,1,'drgf','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',43,Null,2563,2,'2002-6-12',1,1,'dfd','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',44,Null,1200,1,'2002-6-5',1,1,'סޡ','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',44,Null,2000,2,'2002-6-6',1,1,'Ʊ','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',44,Null,2500,3,'2002-6-5',1,1,'ͻԷ','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',45,Null,1000,4,'2002-6-4',3,1,'ffd','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',45,Null,1450,2,'2002-6-19',1,1,'dff','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',45,Null,800,1,'2002-6-3',1,1,'fff','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',46,Null,3246.23,5,'2002-6-12',2,1,'','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',50,Null,1335,2,'2002-6-5',1,1,'','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',50,Null,2120,1,'2002-6-4',1,1,'','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',51,Null,1230,9,'2002-6-4',1,1,'','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',51,Null,325,11,'2002-6-4',1,1,'','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',52,Null,2343,1,'2002-6-4',1,1,'fgfg','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',52,Null,1351,2,'2002-6-12',1,1,'ff','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',52,Null,3434,3,'2002-6-4',1,1,'','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',53,Null,4234,4,'2002-6-13',1,1,'','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',53,Null,3433,5,'2002-6-5',1,1,'dsfdsf','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',53,Null,3455,3,'2002-6-12',1,1,'','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',53,Null,3456,6,'2002-6-5',1,1,'','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',53,Null,4546,2,'2002-6-4',1,1,'','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',54,Null,2343,3,'2002-6-5',1,1,'','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',54,Null,3433,5,'2002-6-4',1,1,'sdfds','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',55,Null,333,5,'2002-6-12',1,1,'343','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',55,Null,2342,8,'2002-6-28',1,1,'dfgfdg','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',70,Null,1233,1,'2002-6-25',1,1,'','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',70,Null,325.36,3,'2002-6-26',1,1,'','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',71,Null,1452,2,'2002-6-25',1,1,'','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',71,Null,1232.69,4,'2002-6-27',1,1,'','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',72,Null,962,9,'2002-6-27',1,1,'','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',72,Null,123.85,10,'2002-6-25',1,1,'','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',72,Null,365,19,'2002-6-27',1,1,'','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',70,Null,635.28,4,'2002-6-17',1,1,'','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',15,6,3453,2,'2002-6-26',1,1,'ffffff','sales')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',15,6,3000,3,'2002-6-26',1,1,'rterty','sales')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',15,6,4355,9,'2002-6-26',1,1,'fgdfg','sales')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',15,6,4554,4,'2002-6-26',1,1,'dgfdg','sales')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',74,18,123,7,'2002-6-26',1,1,'rrrrrr','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',74,18,453,8,'2002-6-26',1,1,'ertertr','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',60,26,343,3,'2002-6-27',1,1,'','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',74,18,3243,4,'2002-6-27',1,1,'ffsdd','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',74,18,334,4,'2002-6-27',1,1,'dsf','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',74,18,543,9,'2002-6-27',1,1,'dffs','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',74,18,332,9,'2002-6-27',1,1,'dfsddf','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',74,18,3432,10,'2002-6-27',1,1,'sdffgd','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',74,18,3455,14,'2002-6-27',1,1,'sdfd','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',74,18,343,6,'2002-6-26',1,1,'rtereryy','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',74,18,233,3,'2002-6-26',1,1,'df','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',74,18,343,18,'2002-6-26',1,1,'sdfgdfff','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',15,6,3455,6,'2002-6-27',1,1,'dfgg','sales')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',90,21,3333,3,'2002-7-9',1,1,'','market')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',88,26,1235,2,'2002-9-12',1,1,'','service')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',3,Null,20000,Null,'2002-9-11',2,Null,'','contract')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',3,Null,1333,Null,'2002-9-10',2,Null,'','contract')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',2,Null,1000,Null,'2002-9-3',2,Null,'','contract')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',8,Null,2000,Null,'2002-9-10',9,Null,'','contract')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',7,Null,2000,Null,'2002-9-27',3,Null,'','contract')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',7,Null,2500,Null,'2002-10-24',3,Null,'','contract')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',89,27,23453,1,'2002-9-17',1,1,'','care')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',91,26,2343,2,'2002-9-12',1,1,'','service')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',28,1384,10000,8,'2003-6-30',1,1,'xzXZCZ','sales')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',15,Null,2000,Null,'2003-6-9',2,Null,'','contract')
Insert Into prg_expense( own_id,prg_id,cust_id,pe_expense,pe_type,pe_date,pe_checker,emp_id,pe_desc,pe_srctype ) Values('fw001',15,Null,10000,Null,'2003-6-23',2,Null,'asf','contract')
GO

Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('fw001',0,'AREA','',3,'','0','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('fw001',0,'BP','BP',4,'','0','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('fw001',0,'CANDIDATE','CAND',4,'','0','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'CP-IP','CP-IP',4,'2002-3-9','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'CP-PD','CP-PD',4,'2002-2-18','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('fw001',27,'CUSTOMER','CUST',5,'2002-1-17','0','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('fw001',0,'DEPARTMENT','DEPT',4,'','0','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('fw001',0,'EMPLOYEE','EMP',4,'','0','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',1,'FW-CP','FW-CP',4,'2002-7-12','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',7,'FW-CS','FW-CS',4,'2002-6-18','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',1,'FW-CT','FW-CT',4,'2002-9-7','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',2,'FW-FB','FW-FB',4,'2002-7-11','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'FW-MC','FW-MC',4,'','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',2,'FW-PRG','FW-PRG',4,'2002-9-3','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('FW001',1,'FW-SR','FW-SR',4,'2003-2-17','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',1,'FW-TSK','FW-TSK',4,'2002-7-11','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'FX-CH','FX-CH',4,'2001-12-20','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'FX-CN','FX-CN',4,'2002-1-25','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',1,'FX-CS','FX-CS',4,'2002-1-17','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',2,'FX-PAY','FX-PAY',4,'2002-1-17','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'FX-PL','FX-PL',4,'2002-1-25','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('fw001',1,'FX-RS','FX-RS',4,'2002-1-17','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',1,'FX-RTN','FX-RTN',4,'2002-1-17','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'FX-SO','FX-SO',4,'','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',1,'JG-MP','JG-MP',4,'2002-2-18','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'KC-IS','KC-IS',4,'2002-1-25','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'KC-OS','KC-OS',4,'2002-1-18','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'KC-TS','KC-TS',4,'2002-1-19','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('fw001',0,'PRODUCT','',4,'','0','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('fw001',0,'STORE','STORE',4,'','0','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'XS-AP','XS-AP',4,'2002-1-23','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'XS-CS','XS-CS',4,'2002-1-17','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('fw001',0,'XS-GP','XS-GP',4,'2002-1-23','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'XS-LD','XS-LD',4,'2002-2-3','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'XS-PAY','XS-PAY',4,'2002-1-25','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'XS-PP','XS-PP',4,'2002-1-28','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'XS-PRG','XS-PRG',4,'2001-7-18','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',10,'XS-QTN','XS-QP',4,'2003-6-24','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'XS-RTN','XS-RTN',4,'2002-1-25','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',26,'XS-SO','XS-S0',5,'2003-6-23','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('fw001',0,'XS-SP','XS-SP',4,'2002-1-27','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'XS-TSK','XS-TSK',4,'2002-1-28','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'ZH-CG','ZH-CG',4,'','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'ZH-CO','ZH-CO',4,'2002-1-18','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'ZH-EP','ZH-EP',4,'2002-1-24','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'ZH-PL','ZH-PL',4,'2002-2-23','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',1,'ZH-PRG','ZH-PRG',4,'2002-7-12','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'ZH-QP','ZH-QP',4,'2002-2-6','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'ZH-RTN','ZH-RTN',4,'2002-1-24','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',1,'ZH-TSK','ZH-TSK',4,'2002-7-11','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'ZL-MS','ZL-MS',4,'2002-2-19','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('Fw001',0,'ZL-PL','ZL-PL',4,'2002-2-20','1','1','1')
Insert Into Pub_BillCode( Own_id,BC_MaxID,BC_Type,BC_Prefix,BC_SerialLen,BC_Date,BC_HasDate,BC_AutoIncrease,BC_Use ) Values('fw001',0,'ZL-SF','ZL-SF',4,'','1','1','1')
GO

Insert Into Pub_Calendar( own_id,Emp_id,Cal_Date,Cal_StartTime,Cal_EndTime,Cal_Subject,Cal_Location,Cal_Type,Task_ID,Cal_Desc,Cal_Remind,Cal_Feedback,Cal_read,Cal_replier ) Values('fw001',1,'2002-10-26','2002-10-26 8:00:00','2002-10-26 10:13:00','aaaa','','1','','dfdfg',Null,'drgdrtyer','1','')
Insert Into Pub_Calendar( own_id,Emp_id,Cal_Date,Cal_StartTime,Cal_EndTime,Cal_Subject,Cal_Location,Cal_Type,Task_ID,Cal_Desc,Cal_Remind,Cal_Feedback,Cal_read,Cal_replier ) Values('fw001',1,'2002-11-25','2002-11-25 9:00:00','2002-11-25 10:12:00','sdfdsf','','1','','sdfsdf',Null,'sdfsd','1','')
Insert Into Pub_Calendar( own_id,Emp_id,Cal_Date,Cal_StartTime,Cal_EndTime,Cal_Subject,Cal_Location,Cal_Type,Task_ID,Cal_Desc,Cal_Remind,Cal_Feedback,Cal_read,Cal_replier ) Values('fw001',1,'2003-6-10','2003-6-10','2003-6-10 23:18:00','xcv','','1','','xcvcx',Null,'','1','')
Insert Into Pub_Calendar( own_id,Emp_id,Cal_Date,Cal_StartTime,Cal_EndTime,Cal_Subject,Cal_Location,Cal_Type,Task_ID,Cal_Desc,Cal_Remind,Cal_Feedback,Cal_read,Cal_replier ) Values('fw001',1,'2003-6-11','2003-6-11','2003-6-11 23:18:00','dsf','','1','','sdfsd',Null,'','1','')
Insert Into Pub_Calendar( own_id,Emp_id,Cal_Date,Cal_StartTime,Cal_EndTime,Cal_Subject,Cal_Location,Cal_Type,Task_ID,Cal_Desc,Cal_Remind,Cal_Feedback,Cal_read,Cal_replier ) Values('fw001',1,'2003-6-15','2003-6-15 13:15:00','2003-6-15 23:17:00','bcbchgj','','1','','gjgjgdhj',Null,'sdfgdsfgdfg','1','')
Insert Into Pub_Calendar( own_id,Emp_id,Cal_Date,Cal_StartTime,Cal_EndTime,Cal_Subject,Cal_Location,Cal_Type,Task_ID,Cal_Desc,Cal_Remind,Cal_Feedback,Cal_read,Cal_replier ) Values('fw001',1,'2003-6-15','2003-6-15','2003-6-15 23:18:00','bcvxbxcbxc','','1','','ghghh',Null,'sdfsdfsdfsdfsdfs','1','')
Insert Into Pub_Calendar( own_id,Emp_id,Cal_Date,Cal_StartTime,Cal_EndTime,Cal_Subject,Cal_Location,Cal_Type,Task_ID,Cal_Desc,Cal_Remind,Cal_Feedback,Cal_read,Cal_replier ) Values('fw001',1,'2003-6-18','2003-6-18 9:30:00','','ݷûص޹˾ͻ','','1','','ط˫',Null,'','0','')
Insert Into Pub_Calendar( own_id,Emp_id,Cal_Date,Cal_StartTime,Cal_EndTime,Cal_Subject,Cal_Location,Cal_Type,Task_ID,Cal_Desc,Cal_Remind,Cal_Feedback,Cal_read,Cal_replier ) Values('fw001',1,'2003-6-25','2003-6-25 9:00:00','','˾','','1','','п
',Null,'','0','')
Insert Into Pub_Calendar( own_id,Emp_id,Cal_Date,Cal_StartTime,Cal_EndTime,Cal_Subject,Cal_Location,Cal_Type,Task_ID,Cal_Desc,Cal_Remind,Cal_Feedback,Cal_read,Cal_replier ) Values('fw001',1,'2003-6-17','2003-6-17 7:30:00','2003-6-17 13:23:00','sdfg','','1','','dfgfd',Null,'','1','')
GO

Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('ȷƼ޹˾','micbos@online.sh.cn','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('ϴ洺','avicit@avicit.com','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('̫Ƽ޹˾','amawu@dsh.com.cn','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('װι˾','hu@oop.com','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('ݸؿƼ޹˾','sales@gsoft.com.cn','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('ʱƼ˾','erp@hollysys.com.cn','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('ó','net_up@cmmail.com','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('ʳƷ˾','butone@pubne.com','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('ǽ蹤̹˾','webmaster@goeasy.net','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('ǿƼ˾','market@qi-xing.com','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('ͨ','syst@anyi.com.cn','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('򿪷ȼ˾','anyi@cta.cq.cn','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('','uihuio@8u89.com','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('Ǽ','yguuu@uihui.com','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('ͨ','yghyui@uui.com','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('й','hjj@uiu.com','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('Ϻ','uiwhq@hui.com','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('','ghhjgy@ghu.com','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('','yugyu@yugyui.com','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('','yuyu@uighu.com','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('ݱ','ughhu@hj.com','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('ĵ','huu@iouj.com','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('','ede@sina.com','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('Ϻ','gg@uihu.com','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('ݱ','ygui@ihif.com','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('ĵ','fhu@uhfuio.com','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('','yughu@eifhui.com','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('','heee@sohu.com','',25)
Insert Into Pub_Email( Email_Name,Email_Addr,Email_Flag,Type_ID ) Values('TCL','zhub@kjoij.com','',25)
GO

Insert Into Pub_EmailBox( PE_ID,Emp_ID,PE_SendAddr,PE_ReceAddr,PE_Subject,PE_Content,PE_AttFlag,PE_Type,PE_InDate,PE_Read,Message_ID,Att_File ) Values(22,1,'zhang@fuwise.com','yzsbz@21cn.com','sdfsd','fsdfsdf','1','OUT','2003-1-22 10:23:50','0','','')
Insert Into Pub_EmailBox( PE_ID,Emp_ID,PE_SendAddr,PE_ReceAddr,PE_Subject,PE_Content,PE_AttFlag,PE_Type,PE_InDate,PE_Read,Message_ID,Att_File ) Values(23,1,'zhang@fuwise.com','yzsbz@163.com','sdfsd','fsdfsdf','1','OUT','2003-1-22 10:23:50','0','','')
GO

Insert Into Pub_Login( own_id,Login_Name,Login_Pwd,Login_Type,Login_Status,Emp_ID,Login_Forbid ) Values('fw001','admin','admin','','0',17,'0')
Insert Into Pub_Login( own_id,Login_Name,Login_Pwd,Login_Type,Login_Status,Emp_ID,Login_Forbid ) Values('fw001','baolh','888888','','0',10,'0')
Insert Into Pub_Login( own_id,Login_Name,Login_Pwd,Login_Type,Login_Status,Emp_ID,Login_Forbid ) Values('fw001','ljc','1234','','0',2,'0')
Insert Into Pub_Login( own_id,Login_Name,Login_Pwd,Login_Type,Login_Status,Emp_ID,Login_Forbid ) Values('fw001','qdf','888888','','0',12,'1')
Insert Into Pub_Login( own_id,Login_Name,Login_Pwd,Login_Type,Login_Status,Emp_ID,Login_Forbid ) Values('fw001','wyx','888888','','0',13,'1')
Insert Into Pub_Login( own_id,Login_Name,Login_Pwd,Login_Type,Login_Status,Emp_ID,Login_Forbid ) Values('fw001','wzm','1234','','0',16,'1')
Insert Into Pub_Login( own_id,Login_Name,Login_Pwd,Login_Type,Login_Status,Emp_ID,Login_Forbid ) Values('fw001','wzz','1234','','0',14,'1')
Insert Into Pub_Login( own_id,Login_Name,Login_Pwd,Login_Type,Login_Status,Emp_ID,Login_Forbid ) Values('fw001','yb','888888','','0',15,'1')
Insert Into Pub_Login( own_id,Login_Name,Login_Pwd,Login_Type,Login_Status,Emp_ID,Login_Forbid ) Values('fw001','demo','8888','','0',1,'0')
Insert Into Pub_Login( own_id,Login_Name,Login_Pwd,Login_Type,Login_Status,Emp_ID,Login_Forbid ) Values('fw001','zsh','1234','','0',3,'0')
Insert Into Pub_Login( own_id,Login_Name,Login_Pwd,Login_Type,Login_Status,Emp_ID,Login_Forbid ) Values('fw001','zxx','zxx','','0',5,'0')
GO

Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(89,'fw001',5,'FW-CP-20020712-0001','care      ',27,'ͻ',0,1,'ά','2002-7-12 16:51:00','2002-7-12 16:51:00',5,1,23453,'','0','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(86,'fw001',3,'FW-PRG-20020711-0001','service   ',26,'ͻ',0,1,'','2002-7-11 11:39:00','2002-7-11 12:12:00',7,2,0,'','1','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(88,'fw001',3,'FW-PRG-20020711-0002','service   ',26,'ͻ',0,1,'','2002-7-11 15:45:00','2002-7-11 15:45:00',7,1,1235,'','0','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(91,'fw001',18,'FW-PRG-20020903-0001','service   ',26,'ͻ',19,1,'ʿƵ','2002-9-3 10:10:00','2002-9-3 10:10:00',7,2,2343,'','0','ͨ',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(92,'fw001',18,'FW-PRG-20020903-0002','service   ',26,'ͻ',19,1,'˰ȴ','2002-9-3 10:10:00','2002-9-3 10:10:00',8,2,0,'','0','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(17,'fw001',67,'XS-PRG-20010718-0003','sales     ',Null,'',Null,1,'efef','2001-7-13','2001-7-13',Null,Null,32423,'','0','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(44,'fw001',71,'ZH-PRG-20020617-0003','market    ',Null,'',Null,1,'һ׶','2002-6-7','2002-6-17 15:15:00',1,1,5700,'','1','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(45,'fw001',71,'ZH-PRG-20020617-0004','market    ',Null,'',Null,1,'ڶ׶','2002-6-15','2002-6-17 15:15:00',58,1,3250,'','1','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(46,'fw001',71,'ZH-PRG-20020617-0005','market    ',Null,'',Null,1,'׶','2002-6-6','2002-6-17 15:15:00',61,3,3246.23,'','1','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(50,'fw001',72,'ZH-PRG-20020617-0006','market    ',Null,'',Null,2,'µȵ','2002-6-7','2002-6-17 17:17:00',1,1,3455,'','1','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(51,'fw001',72,'ZH-PRG-20020617-0007','market    ',Null,'',Null,3,'ʿ','2002-6-11','2002-6-17 17:17:00',59,1,1555,'','1','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(52,'fw001',64,'ZH-PRG-20020617-0008','market    ',Null,'',Null,2,'sdfsdf','2002-6-13','2002-6-17 20:20:00',58,2,7128,'','1','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(53,'fw001',64,'ZH-PRG-20020617-0009','market    ',Null,'',Null,2,'sdfdsfs','2002-6-7','2002-6-17 20:20:00',1,2,19124,'dfdfg','1','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(54,'fw001',75,'ZH-PRG-20020618-0001','market    ',Null,'',Null,5,'dsfdsf','2002-6-7','2002-6-18 9:09:00',58,2,5776,'dsfd ','1','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(55,'fw001',75,'ZH-PRG-20020618-0002','market    ',Null,'',Null,3,'sdffdsfsd','2002-6-11','2002-6-18 9:09:00',59,4,2675,'','1','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(60,'fw001',74,'ZH-PRG-20020618-0003','market    ',Null,'',Null,1,'Ϸ','2002-6-10','',1,1,343,'','0','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(63,'fw001',82,'ZH-PRG-20020619-0001','market    ',Null,'',Null,2,'ʿˮ','2002-6-8','',59,1,0,'','0','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(64,'fw001',82,'ZH-PRG-20020619-0002','market    ',Null,'',Null,3,'ȵط','2002-6-12','',58,1,0,'','0','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(65,'fw001',82,'ZH-PRG-20020619-0003','market    ',Null,'',Null,1,'ʦʿ','2002-6-14','',59,3,0,'','0','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(66,'fw001',74,'ZH-PRG-20020619-0004','market    ',Null,'',Null,3,'','2002-6-14','',1,4,0,'','0','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(67,'fw001',74,'ZH-PRG-20020619-0005','market    ',Null,'',Null,9,'ʮֵ','2002-6-17','',59,5,0,'','0','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(69,'fw001',74,'ZH-PRG-20020619-0007','market    ',Null,'',Null,10,'ȵ','2002-6-13','',58,1,0,'','0','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(70,'fw001',83,'ZH-PRG-20020619-0008','market    ',Null,'',Null,1,'ͳһ','2002-6-15','2002-6-20 10:10:00',58,1,2193.64,'','1','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(71,'fw001',83,'ZH-PRG-20020619-0009','market    ',Null,'',Null,2,'ɶ','2002-6-12','2002-6-15 16:16:00',59,2,2684.69,'','1','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(72,'fw001',83,'ZH-PRG-20020619-0010','market    ',Null,'',Null,3,'ʿͬ','2002-6-7','2002-6-19 16:16:00',59,3,1450.85,'','1','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(73,'fw001',74,'ZH-PRG-20020620-0002','market    ',Null,'',Null,3,'ertret','2002-6-20','',58,5,0,'','0','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(74,'fw001',88,'ZH-PRG-20020620-0003','market    ',Null,'',Null,3,'sdfsdf','2002-6-18','',58,1,12834,'','0','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(81,'fw001',74,'ZH-PRG-20020626-0001','market    ',Null,'',Null,1,'wwwwwww','2002-6-11','',59,1,0,'','0','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(82,'fw001',82,'ZH-PRG-20020626-0002','market    ',Null,'',Null,5,'qqqqqqq','2002-6-27','',59,2,0,'','0','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(84,'fw001',74,'ZH-PRG-20020627-0002','market    ',Null,'',Null,3,'sfsdf','2002-6-21','',59,4,0,'','0','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(85,'fw001',74,'ZH-PRG-20020627-0003','market    ',Null,'',Null,3,'dsfee','2002-6-11','',1,3,0,'','0','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(87,'fw001',4,'ZH-PRG-20020711-0001','market    ',27,'ͻ',0,3,'test','2002-7-11 15:44:00','2002-7-11 15:15:00',58,2,0,'','1','',Null,'')
Insert Into Pub_Progress( prg_ID,own_id,Task_Id,Prg_Code,Prg_Type,prg_objID,prg_objType,prg_contactID,Prg_Executor,Prg_Subject,Prg_StartDate,Prg_EndDate,Prg_Action,Prg_CampType,Prg_Cost,Prg_Desc,prg_finish,prg_priority,prg_Result,Prg_Memo ) Values(90,'fw001',4,'ZH-PRG-20020712-0001','market    ',27,'ͻ',0,2,'Ʒ','2002-7-12 16:56:00','',1,2,0,'','0','',Null,'')
GO

Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(1,'fw001','ZH-TSK-20020709-0001','dddd',28,'еҵ','ͻ','market',1,6,'2002-7-9','','2002-7-11',0,0,'1','','',Null,0)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(3,'fw001','FW-CT-20020711-0001','˷θ',26,'','ͻ','service',3,27,'2002-7-11','ͨ','',2000,1235,'0','','',Null,0)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(4,'fw001','ZH-TSK-20020711-0001','test',27,'Żݹ޹˾','ͻ','market',1,6,'2002-7-11','','2002-7-11',0,0,'0','','',Null,20)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(5,'fw001','FW-CT-20020712-0001','ά',27,'','ͻ','care',2,13,'2002-7-12','','',0,23453,'0','','',Null,0)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(18,'fw001','FW-CT-20020802-0001','test',26,'','ͻ','service',5,442,'2002-8-2','ͨ','',3000,2343,'0','','',Null,0)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(19,'fw001','FW-CT-20020802-0002','test',25,'','ͻ','care',1,13,'2002-8-2','','2002-9-1',0,0,'1','','',Null,0)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(21,'fw001','FW-CT-20020901-0001','ddddd',18,'','ͻ','care',1,13,'2002-9-1','','',0,0,'0','','',Null,9)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(22,'fw001','','ϵ',1,'ѯ','','contract',Null,Null,'2002-7-3','','2002-7-23',0,0,'0','','',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(23,'fw001','','ISO 9000 ʶѵ',1,'ѯʼѵʦ','','contract',Null,Null,'2002-7-1','','2002-8-31',0,0,'0','','',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(24,'fw001','','ϵļĲ߻ѵ',1,'ѯʼĿС','','contract',Null,Null,'2002-8-1','','2002-10-31',0,0,'0','','',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(26,'fw001','','ϵѵ',1,'ѯ','','contract',Null,Null,'2002-9-1','','2002-11-30',0,0,'0','','',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(27,'fw001','','󼰹',1,'˾ԱĿС','','contract',Null,Null,'2002-10-1','','2002-11-30',0,0,'0','','',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(28,'fw001','','֤׼֤',1,'ĿС鼰֤','','contract',Null,Null,'2002-11-1','','2002-11-30',0,0,'0','','',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(29,'fw001','','ϵ',2,'ѯ','','contract',Null,Null,'2002-9-1','','2002-9-30',0,0,'0','','',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(30,'fw001','','ISO 9000 ʶѵ',2,'ѯʼѵʦ','','contract',Null,Null,'2002-9-1','','2002-10-31',0,0,'0','','',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(31,'fw001','','ϵļĲ߻ѵ',2,'ѯʼĿС','','contract',Null,Null,'2002-6-1','','2002-9-30',0,0,'0','','',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(32,'fw001','','ϵѵ',2,'ѯ','','contract',Null,Null,'2002-10-1','','2002-12-31',0,0,'0','','',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(33,'fw001','','󼰹',2,'˾ԱĿС','','contract',Null,Null,'2002-11-1','','2002-12-31',0,0,'0','','',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(35,'fw001','','һ׶Σϵ',3,'ѯ','','contract',Null,Null,'2002-9-4','','2002-9-12',0,0,'0','','׶һ',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(36,'fw001','','ڶ׶ΣIS0 9000 ʶѵ',3,'ѯʼѵʦ','','contract',Null,Null,'2002-9-4','','2002-9-12',0,0,'0','','׶ζ',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(37,'fw001','','׶Σϵļ뿪',3,'ѯʼĿС','','contract',Null,Null,'2002-9-4','','2002-10-31',0,0,'0','','',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(38,'fw001','','Ľ׶Σϵѵ',3,'ѯ','','contract',Null,Null,'2002-9-4','','2002-11-30',0,0,'0','','',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(39,'fw001','','׶ΣԱѵ󼰹',3,'˾ԱĿС','','contract',Null,Null,'2002-10-1','','2002-10-31',0,0,'0','','',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(40,'fw001','','test',7,'test','','contract',Null,Null,'2002-9-5','','2002-9-30',0,0,'0','','',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(41,'fw001','','test',8,'test','','contract',Null,Null,'2002-9-5','','2002-9-9',0,0,'0','','et',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(42,'fw001','','sdtet',8,'etwt','','contract',Null,Null,'2002-9-5','','2002-10-31',0,0,'0','','',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(43,'fw001','','sdfsd',8,'sdfsd','','contract',Null,Null,'2002-9-5','','2002-11-30',0,0,'0','','',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(44,'fw001','','sdsdf',8,'sfsdfsdgf','','contract',Null,Null,'2002-9-5','','2002-12-31',0,0,'0','','',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(48,'fw001','','sddfdf',9,'sdf','','contract',Null,Null,'2002-9-16','','2002-11-30',0,0,'0','','sdfsd',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(49,'fw001','','dsfds',10,'sdf','','contract',Null,Null,'2002-9-16','','2003-1-30',0,0,'0','','sdf',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(50,'fw001','','hhdf',12,'ghdfdf','','contract',Null,Null,'2003-3-5','','2003-3-30',0,0,'0','','hdfdf',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(51,'fw001','','df',13,'ddf','','contract',Null,Null,'2003-6-8','','2003-6-30',0,0,'0','','dsfdsf',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(52,'fw001','','cfb',13,'fg','','contract',Null,Null,'2003-6-8','','2003-6-24',0,0,'0','','fg',Null,Null)
Insert Into Pub_Task( Task_ID,own_id,Task_Code,Task_Subject,Task_ObjID,Task_Object,Task_ObjType,Task_Type,Task_Manager,Task_Status,Task_StartDate,Task_priority,Task_EndDate,Task_Budget,Task_Cost,Task_Flag,Task_Result,Task_Desc,Task_Source,Contact_ID ) Values(53,'fw001','','Լֵͻйػ',17,'','ͻ','care',2,Null,'2003-6-17','','',0,0,'0','','',Null,Null)
GO

Insert Into XS_ActExpense( own_id,act_id,ae_type,ae_expense,ae_date,emp_id,ae_checker,ae_memo ) Values('fw001',13,2,1234,'2002-4-3',1,1,'')
Insert Into XS_ActExpense( own_id,act_id,ae_type,ae_expense,ae_date,emp_id,ae_checker,ae_memo ) Values('fw001',13,1,250,'2002-5-2',1,1,'ddd')
GO

Insert Into XS_Activity( act_id,own_id,oppt_id,act_subject,cust_id,act_type,act_action,act_priority,act_createdate,act_start,act_end,act_duration,act_finish,act_result,act_expense,act_maker,act_executor,act_memo,act_closedesc,contact_id ) Values(13,'fw001',22,'Ǣ̸Ե',4,1,3,'ͨ','2002-4-2','2002-4-2 22:50:00','2002-5-21 18:18:00',0,'1',4,1484,1,3,'','',22)
Insert Into XS_Activity( act_id,own_id,oppt_id,act_subject,cust_id,act_type,act_action,act_priority,act_createdate,act_start,act_end,act_duration,act_finish,act_result,act_expense,act_maker,act_executor,act_memo,act_closedesc,contact_id ) Values(14,'fw001',20,'sdfdsf',3,2,3,'','2002-4-3','2002-4-3 17:39:00','2002-4-11 21:21:00',0,'1',2,0,1,1,'sdfsdf','',5)
Insert Into XS_Activity( act_id,own_id,oppt_id,act_subject,cust_id,act_type,act_action,act_priority,act_createdate,act_start,act_end,act_duration,act_finish,act_result,act_expense,act_maker,act_executor,act_memo,act_closedesc,contact_id ) Values(15,'fw001',12,'dd',6,1,3,'','2002-6-10','2002-6-10 10:44:00','2002-9-1 9:09:00',0,'1',1,18817,1,1,'','',0)
Insert Into XS_Activity( act_id,own_id,oppt_id,act_subject,cust_id,act_type,act_action,act_priority,act_createdate,act_start,act_end,act_duration,act_finish,act_result,act_expense,act_maker,act_executor,act_memo,act_closedesc,contact_id ) Values(16,'fw001',Null,'test10',28,1,3,'','2002-6-14','2002-6-14 18:11:00','2002-6-14 18:11:00',Null,'1',2,0,1,1,'','',0)
Insert Into XS_Activity( act_id,own_id,oppt_id,act_subject,cust_id,act_type,act_action,act_priority,act_createdate,act_start,act_end,act_duration,act_finish,act_result,act_expense,act_maker,act_executor,act_memo,act_closedesc,contact_id ) Values(17,'fw001',25,'ʿ',14,1,3,'ͨ','2002-11-29','2002-11-29 15:00:00','',Null,'0',Null,0,1,1,'','',0)
Insert Into XS_Activity( act_id,own_id,oppt_id,act_subject,cust_id,act_type,act_action,act_priority,act_createdate,act_start,act_end,act_duration,act_finish,act_result,act_expense,act_maker,act_executor,act_memo,act_closedesc,contact_id ) Values(18,'fw001',25,'ʮʿ',14,1,3,'ͨ','2002-11-29','2002-11-29 15:01:00','',Null,'0',Null,0,1,5,'','',16)
Insert Into XS_Activity( act_id,own_id,oppt_id,act_subject,cust_id,act_type,act_action,act_priority,act_createdate,act_start,act_end,act_duration,act_finish,act_result,act_expense,act_maker,act_executor,act_memo,act_closedesc,contact_id ) Values(19,'fw001',24,'ϵά',6,4,109,'ͨ','2003-6-15','2003-6-15 22:22:00','',Null,'0',Null,0,1,1,'ӴɺŶ','',3)
Insert Into XS_Activity( act_id,own_id,oppt_id,act_subject,cust_id,act_type,act_action,act_priority,act_createdate,act_start,act_end,act_duration,act_finish,act_result,act_expense,act_maker,act_executor,act_memo,act_closedesc,contact_id ) Values(20,'fw001',13,'лΪŶ',4,3,109,'','2003-6-15','2003-6-15 22:26:00','',Null,'0',Null,0,1,1,'Ԥ9','',17)
Insert Into XS_Activity( act_id,own_id,oppt_id,act_subject,cust_id,act_type,act_action,act_priority,act_createdate,act_start,act_end,act_duration,act_finish,act_result,act_expense,act_maker,act_executor,act_memo,act_closedesc,contact_id ) Values(21,'fw001',19,'۸֤',4,5,110,'','2003-6-15','2003-6-15 22:28:00','',Null,'0',Null,0,1,1,'
','',17)
Insert Into XS_Activity( act_id,own_id,oppt_id,act_subject,cust_id,act_type,act_action,act_priority,act_createdate,act_start,act_end,act_duration,act_finish,act_result,act_expense,act_maker,act_executor,act_memo,act_closedesc,contact_id ) Values(22,'fw001',Null,'hgfdsgdfsgdsfhdfsh',1396,6,109,'','2003-6-15','2003-6-15 22:57:00','2003-6-15 22:57:00',Null,'1',2,0,1,1,'gsdfgdfsg','gfdsgdfsghsd',0)
Insert Into XS_Activity( act_id,own_id,oppt_id,act_subject,cust_id,act_type,act_action,act_priority,act_createdate,act_start,act_end,act_duration,act_finish,act_result,act_expense,act_maker,act_executor,act_memo,act_closedesc,contact_id ) Values(23,'fw001',Null,'fasdfasfasd',1397,5,110,'','2003-6-15','2003-6-15 22:58:00','2003-6-15 22:58:00',Null,'1',1,0,1,1,'fdsafs','fdsaf',0)
Insert Into XS_Activity( act_id,own_id,oppt_id,act_subject,cust_id,act_type,act_action,act_priority,act_createdate,act_start,act_end,act_duration,act_finish,act_result,act_expense,act_maker,act_executor,act_memo,act_closedesc,contact_id ) Values(24,'fw001',30,'Ʒ֤',1380,6,110,'','2003-6-15','2003-6-15 23:31:00','',Null,'0',Null,0,1,1,'','',0)
Insert Into XS_Activity( act_id,own_id,oppt_id,act_subject,cust_id,act_type,act_action,act_priority,act_createdate,act_start,act_end,act_duration,act_finish,act_result,act_expense,act_maker,act_executor,act_memo,act_closedesc,contact_id ) Values(25,'fw001',31,'',1381,5,109,'ͨ','2003-6-15','2003-6-15 23:32:00','',Null,'0',Null,0,1,1,'','',0)
Insert Into XS_Activity( act_id,own_id,oppt_id,act_subject,cust_id,act_type,act_action,act_priority,act_createdate,act_start,act_end,act_duration,act_finish,act_result,act_expense,act_maker,act_executor,act_memo,act_closedesc,contact_id ) Values(26,'fw001',28,'ֵ',1388,5,110,'ͨ','2003-6-15','2003-6-15 23:33:00','',Null,'0',Null,0,1,1,'','',0)
Insert Into XS_Activity( act_id,own_id,oppt_id,act_subject,cust_id,act_type,act_action,act_priority,act_createdate,act_start,act_end,act_duration,act_finish,act_result,act_expense,act_maker,act_executor,act_memo,act_closedesc,contact_id ) Values(27,'fw001',29,'Ʒ֤',1382,6,109,'ͨ','2003-6-15','2003-6-15 23:34:00','',Null,'0',Null,0,1,1,'','',0)
Insert Into XS_Activity( act_id,own_id,oppt_id,act_subject,cust_id,act_type,act_action,act_priority,act_createdate,act_start,act_end,act_duration,act_finish,act_result,act_expense,act_maker,act_executor,act_memo,act_closedesc,contact_id ) Values(28,'fw001',8,'ֵ',1384,6,109,'','2003-6-15','2003-6-15 23:37:00','',Null,'0',Null,10000,1,1,'','',0)
Insert Into XS_Activity( act_id,own_id,oppt_id,act_subject,cust_id,act_type,act_action,act_priority,act_createdate,act_start,act_end,act_duration,act_finish,act_result,act_expense,act_maker,act_executor,act_memo,act_closedesc,contact_id ) Values(29,'fw001',22,'jgmbm,bv,b,',1397,5,3,'','2003-6-24','2003-6-24 9:51:00','',Null,'0',Null,0,1,1,',bv,b,bm,nm,nm,nm,mm','',22)
GO

Insert Into XS_Contract( CR_ID,Own_ID,CR_Code,Cust_ID,So_ID,CR_Type,CR_Sale,CR_Manager,CR_Advisor,Contact_ID,CR_SignDate,CR_StartDate,CR_PreDate,CR_FactDate,CR_PreDays,CR_FactDays,CR_Amount,CR_RecDate,CR_RecAmount,CR_Evection,CR_Check,CR_rule,CR_Schedule,CR_Feedback,CR_Attest,CR_AttCompany,CR_Memo,CR_ReferRate,CR_TrainRate,CR_Flag,CR_Discount,CR_Reason ) Values(2,'fw001','TJ-1001',27,1,13,9,1,9,20,'2002-9-20','','2002-12-31','',Null,Null,4000,'',1000,'','1','',112,'','','','test',2000,3000,'',Null,'')
Insert Into XS_Contract( CR_ID,Own_ID,CR_Code,Cust_ID,So_ID,CR_Type,CR_Sale,CR_Manager,CR_Advisor,Contact_ID,CR_SignDate,CR_StartDate,CR_PreDate,CR_FactDate,CR_PreDays,CR_FactDays,CR_Amount,CR_RecDate,CR_RecAmount,CR_Evection,CR_Check,CR_rule,CR_Schedule,CR_Feedback,CR_Attest,CR_AttCompany,CR_Memo,CR_ReferRate,CR_TrainRate,CR_Flag,CR_Discount,CR_Reason ) Values(3,'fw001','tj-0001',28,1,16,1,3,3,24,'2002-9-4','','2002-11-27','2002-9-5',Null,34,2356,'',0,'','2','',114,'dfg','','','',2000,3000,'',Null,'')
Insert Into XS_Contract( CR_ID,Own_ID,CR_Code,Cust_ID,So_ID,CR_Type,CR_Sale,CR_Manager,CR_Advisor,Contact_ID,CR_SignDate,CR_StartDate,CR_PreDate,CR_FactDate,CR_PreDays,CR_FactDays,CR_Amount,CR_RecDate,CR_RecAmount,CR_Evection,CR_Check,CR_rule,CR_Schedule,CR_Feedback,CR_Attest,CR_AttCompany,CR_Memo,CR_ReferRate,CR_TrainRate,CR_Flag,CR_Discount,CR_Reason ) Values(7,'fw001','df ',28,1,15,3,5,2,24,'2002-6-5','','2002-10-31','',Null,Null,4500,'2002-10-24',4500,'','1','',113,'','','','',2333,3333,'',Null,'')
Insert Into XS_Contract( CR_ID,Own_ID,CR_Code,Cust_ID,So_ID,CR_Type,CR_Sale,CR_Manager,CR_Advisor,Contact_ID,CR_SignDate,CR_StartDate,CR_PreDate,CR_FactDate,CR_PreDays,CR_FactDays,CR_Amount,CR_RecDate,CR_RecAmount,CR_Evection,CR_Check,CR_rule,CR_Schedule,CR_Feedback,CR_Attest,CR_AttCompany,CR_Memo,CR_ReferRate,CR_TrainRate,CR_Flag,CR_Discount,CR_Reason ) Values(8,'fw001','DL-00003',17,1,14,5,2,9,8,'2002-9-5','','2002-12-31','2002-11-28',0,345,4000,'',2000,'','3','',113,'','','','',2000,3000,'',Null,'')
Insert Into XS_Contract( CR_ID,Own_ID,CR_Code,Cust_ID,So_ID,CR_Type,CR_Sale,CR_Manager,CR_Advisor,Contact_ID,CR_SignDate,CR_StartDate,CR_PreDate,CR_FactDate,CR_PreDays,CR_FactDays,CR_Amount,CR_RecDate,CR_RecAmount,CR_Evection,CR_Check,CR_rule,CR_Schedule,CR_Feedback,CR_Attest,CR_AttCompany,CR_Memo,CR_ReferRate,CR_TrainRate,CR_Flag,CR_Discount,CR_Reason ) Values(9,'fw001','DL-0001',27,1,16,3,10,5,15,'2002-9-16','','2002-12-31','',0,0,6000,'',0,'','0','100Ԫ/',113,'','','','',2000,3000,'',0,'')
Insert Into XS_Contract( CR_ID,Own_ID,CR_Code,Cust_ID,So_ID,CR_Type,CR_Sale,CR_Manager,CR_Advisor,Contact_ID,CR_SignDate,CR_StartDate,CR_PreDate,CR_FactDate,CR_PreDays,CR_FactDays,CR_Amount,CR_RecDate,CR_RecAmount,CR_Evection,CR_Check,CR_rule,CR_Schedule,CR_Feedback,CR_Attest,CR_AttCompany,CR_Memo,CR_ReferRate,CR_TrainRate,CR_Flag,CR_Discount,CR_Reason ) Values(10,'fw001','xcvcx',28,1,15,1,5,0,24,'2002-9-16','','2003-6-30','',0,0,78959,'',0,'','0','',114,'','','','',3433,4444,'',0,'')
Insert Into XS_Contract( CR_ID,Own_ID,CR_Code,Cust_ID,So_ID,CR_Type,CR_Sale,CR_Manager,CR_Advisor,Contact_ID,CR_SignDate,CR_StartDate,CR_PreDate,CR_FactDate,CR_PreDays,CR_FactDays,CR_Amount,CR_RecDate,CR_RecAmount,CR_Evection,CR_Check,CR_rule,CR_Schedule,CR_Feedback,CR_Attest,CR_AttCompany,CR_Memo,CR_ReferRate,CR_TrainRate,CR_Flag,CR_Discount,CR_Reason ) Values(11,'fw001','q4qew',27,1,16,3,10,5,15,'2002-11-12','','2002-11-14','',0,0,0,'',0,'','0','',113,'','','','',234,234,'',0,'')
Insert Into XS_Contract( CR_ID,Own_ID,CR_Code,Cust_ID,So_ID,CR_Type,CR_Sale,CR_Manager,CR_Advisor,Contact_ID,CR_SignDate,CR_StartDate,CR_PreDate,CR_FactDate,CR_PreDays,CR_FactDays,CR_Amount,CR_RecDate,CR_RecAmount,CR_Evection,CR_Check,CR_rule,CR_Schedule,CR_Feedback,CR_Attest,CR_AttCompany,CR_Memo,CR_ReferRate,CR_TrainRate,CR_Flag,CR_Discount,CR_Reason ) Values(12,'fw001','ff44',1399,1,13,1,1,0,19,'2002-11-28','','2002-11-30','',0,0,0,'',0,'','0','',112,'','','','',34534,3454,'',0,'')
Insert Into XS_Contract( CR_ID,Own_ID,CR_Code,Cust_ID,So_ID,CR_Type,CR_Sale,CR_Manager,CR_Advisor,Contact_ID,CR_SignDate,CR_StartDate,CR_PreDate,CR_FactDate,CR_PreDays,CR_FactDays,CR_Amount,CR_RecDate,CR_RecAmount,CR_Evection,CR_Check,CR_rule,CR_Schedule,CR_Feedback,CR_Attest,CR_AttCompany,CR_Memo,CR_ReferRate,CR_TrainRate,CR_Flag,CR_Discount,CR_Reason ) Values(13,'fw001','2222',1399,1,13,1,1,3,19,'2003-6-1','','2003-6-30','',0,0,0,'',0,'','0','',113,'','','','',1354,241,'',0,'')
Insert Into XS_Contract( CR_ID,Own_ID,CR_Code,Cust_ID,So_ID,CR_Type,CR_Sale,CR_Manager,CR_Advisor,Contact_ID,CR_SignDate,CR_StartDate,CR_PreDate,CR_FactDate,CR_PreDays,CR_FactDays,CR_Amount,CR_RecDate,CR_RecAmount,CR_Evection,CR_Check,CR_rule,CR_Schedule,CR_Feedback,CR_Attest,CR_AttCompany,CR_Memo,CR_ReferRate,CR_TrainRate,CR_Flag,CR_Discount,CR_Reason ) Values(14,'fw001','44444',1399,1,14,1,1,1,20,'2002-11-28','','2002-11-30','',0,0,0,'',0,'rgr','1','rtre',113,'','','','',4444,4444,'',0,'')
Insert Into XS_Contract( CR_ID,Own_ID,CR_Code,Cust_ID,So_ID,CR_Type,CR_Sale,CR_Manager,CR_Advisor,Contact_ID,CR_SignDate,CR_StartDate,CR_PreDate,CR_FactDate,CR_PreDays,CR_FactDays,CR_Amount,CR_RecDate,CR_RecAmount,CR_Evection,CR_Check,CR_rule,CR_Schedule,CR_Feedback,CR_Attest,CR_AttCompany,CR_Memo,CR_ReferRate,CR_TrainRate,CR_Flag,CR_Discount,CR_Reason ) Values(15,'fw001','aaaaa',5,14,13,1,1,Null,10,'2003-6-23','','2003-6-30','',Null,Null,22000,'2003-6-23',12000,'','0','',Null,'','','','',0,0,'',0,'')
Insert Into XS_Contract( CR_ID,Own_ID,CR_Code,Cust_ID,So_ID,CR_Type,CR_Sale,CR_Manager,CR_Advisor,Contact_ID,CR_SignDate,CR_StartDate,CR_PreDate,CR_FactDate,CR_PreDays,CR_FactDays,CR_Amount,CR_RecDate,CR_RecAmount,CR_Evection,CR_Check,CR_rule,CR_Schedule,CR_Feedback,CR_Attest,CR_AttCompany,CR_Memo,CR_ReferRate,CR_TrainRate,CR_Flag,CR_Discount,CR_Reason ) Values(16,'fw001','123543',4,15,13,10,1,Null,0,'2003-6-23','','','',Null,Null,977460,'',0,'','1','',Null,'','','','',0,0,'',0,'')
Insert Into XS_Contract( CR_ID,Own_ID,CR_Code,Cust_ID,So_ID,CR_Type,CR_Sale,CR_Manager,CR_Advisor,Contact_ID,CR_SignDate,CR_StartDate,CR_PreDate,CR_FactDate,CR_PreDays,CR_FactDays,CR_Amount,CR_RecDate,CR_RecAmount,CR_Evection,CR_Check,CR_rule,CR_Schedule,CR_Feedback,CR_Attest,CR_AttCompany,CR_Memo,CR_ReferRate,CR_TrainRate,CR_Flag,CR_Discount,CR_Reason ) Values(17,'fw001','526689',1393,16,13,2,1,Null,0,'2003-6-23','','','2003-6-23',Null,Null,184058,'',0,'','2','',Null,'e5tyr','','','',0,0,'',0,'')
GO

Insert Into XS_ContractDetail( CD_ID,own_id,CT_ID,CD_Title,CD_levels,CD_parentid,CD_Content,CD_path ) Values(1,'fw001','1','һ Ŀ',0,0,'[1] ĿԼ 
¼Ƽ׷ָ¼ҷΪʣ׷ISO 9001(2000) ׼ϵ 
   [2] Ŀҷ 
׷ơʵʩISO 9001(2000)ϵﵽĿ꣺ 

׷ԱɹʵʩЧάISO 9001(2000)ϵ 

ڳֿԼĻϣͨЧáݵķʽΪɹʹϵ֤׼ISO 9001(2000)ҵ

ҵͬźְ໥֮ӿڵõǿĽŶӺ

̺ϵĳƣӹ˿ȡ

 
   [3] ĿΧ 
˺ͬΪ׷ƣĿΧǣ --ֲĵ͡棬ó  
   [4] ѯ 
׷ӦISO 9000ĿС飬Ŀȫ̽󸽲ͬѯ׶Σ׷ԱISO 9001(2000)ҷʵָ½С ISO 9001(2000) ĿĹ֯ṹͼ ISO 9001(2000) ָίԱ Ŀ-ߴ С С С С ҷѯ̷ͼ ļ ȻҵΪ ϵ ȻȻִ ϵļ ISO9000 ϵҪΪο  
','-1-')
Insert Into XS_ContractDetail( CD_ID,own_id,CT_ID,CD_Title,CD_levels,CD_parentid,CD_Content,CD_path ) Values(2,'fw001','1',' ѯ',0,0,'һ׶Σϵ 
   1ϵ 
ڴ˽׶ΣѯʽҵϵطҵļеֿΪˣѯʽÿ뻷ڽ벿Ÿ˽̸ʹҵܸõ˽롢ISO 9001(2000)׼ϵҪĲࡣҪҵʵṩҵĿǰ״  
   2 ύ  
һΪϵISO9001(2000)׼ϵҪֵȱԼ۲ϵ棻

һݰϸʱ䰲뷽ǵ֪ԼĿԤڵĿʵʩƻ

ĿָίԱ͹СĽ飬ȷǰĿꡣ 
 
   ڶ׶ΣISO 90002000ʶѵ 
   1ѵ  
Ϊȷɹʵʩ ISO 9001(2000)ϵ, ѯʽΪҵȫԱISO 9001(2000)ʶѵ  
   2ѵص㼰ʩ 
ҷṩѵص㼰ʩаҡͶӰǡҷṩѵ  
   3ѵ 
a) ISO 90002000棩Ĳ94
b) ISO90002000)ݡԭ 
Թ˿Ϊ 

쵼

ȫԱ

Ľ

̵Ĺ

ϵͳĹ

ʵΪݵľ

Ĺϵ

c) ISO90002000棩׼Ҫ 

ϵҪļҪ 

ְ𣺹ŵĿꣻְȨޣڲͨ 

ԴԴѵʶʩ

ʵʩ˿Ҫȷ˿͵Ĺͨ淶뿪ɹĿƣĿƣ̵Ŀƣʶ˿ͲƲĹвͼ豸Ĺ 

͸Ľ˿ȵĵ飻ڲˣ̵ļأݷԤʩ 

d) ڱ׼İ 

ҵʵĽļѵʱѵ¸׶βҵΪʲôҪʵʩISO9000 

ISO 9001(2000)׼ϵҪ

ʵʩISO 9001(2000)ϵ弰Ч

ISO 9001(2000)ϵʵʩҪ

֤

 
   ׶Σϵļ뿪 
   1ϵļѵ  
ڴ˽׶ΣѯʽϵļνбдͰʲôбдļСѵ 
   2׷ҷϵļ 
ֲᡢļҵָ¼˽׶νѯָ½УְΪ 

ϵļƻ 

ѯʽڷʼ׷ 

ĿСԱ۲ָдϵļ

ļ 

A ֲĿ 
ڴ˽׶ΣѯӦְ 

׷ĿСԱۿֲ᣻ 

ƶʵʩ 

ϵ棬ȷݣü׷зISO 9001(2000)ϵҪļȷļʵԣ 

ָĿСԱֲᡣ

B ļĿ ڴ˽׶ΣѯӦְ 

ĿСԱֲĳ

ȫгļȷֲӡټıݣԿ׷ǰơ߻йļмԾ֣ 

ָĿСԱļ 

C ҵָ¼ 

ļӦɼ׷Աпƣѯʸ轨顣 

ĿʶӦм¼Ƿ뱸

עļд׶ΣҵСִʱдʽָ  
   3 ļķ 
ļɺҵļй涨иزԹʵʩ 
   Ľ׶: ϵѵ 
    1 ϵʵʩǰѵ 
ϵļʽʵʩ֮ǰϵļӦͬͲɡѯʽļϵʵʩǰѵΪɹʵʩϵ׼ѵʩصɼ׷ṩ 
   2ϵʵʩ 
ڴ˽׶Σѯʽָ׷ϵʵʩȷ׷ϤϵȫϵУΪάϵû˽׶εʵʩʩ·棺 
A ѯʽļϵʵʩزԱ 顣
B  ISO 9001(2000) ϵʵʩڼ䣬ѯʵְΪ 

Լ顢ָķʽԱļʵʩ 

ϵʵʩ׶β3£ʱ䣬ѯʽĿС ϵеԽ顣

ÿһţ¼ǷȫȷжϵǷЧС

ڼ׷ϵʵʩ׼ʱѯƼ֤ʱ䡣

׷Ƽ֤صԷ 
 
   ׶: Աѵ󼰹  
   1Աڲ 
׷ӦĿСҪԱμҷԱѵࡣҪμԱΪĿСԱԱòĿУΪ1000Ա/ˣ 
   2 ָ׷Աǰ׼  
μ󣬰Ա 

ָԱд󱨸棬ָԱֵĲϸƶʩо 

󱨸ĻϣŹ׼ʱ㽨֤ 
 
   3 ˽, ׷ٿ顣 
μӷΪҵĸ߲ߣĿС飬ѯʣָĽУʵʩϵЧ,бҪ,޸ġ 
   ׶: ֤׼Ӧѵ֤ 
   ڴ˽׶ΣѯʵְΪ 
ϵ׼ʱѯʽ׷֤ 

֤ϵ֤ðա 

ṩ֤ǰѵ 

ϯȫ 

֤ύ˱Ļϣָ׷ƶʩ 

׷ɹ֤ͨĿ 
 
','-2-')
Insert Into XS_ContractDetail( CD_ID,own_id,CT_ID,CD_Title,CD_levels,CD_parentid,CD_Content,CD_path ) Values(3,'fw001','1',' ͬȰ',0,0,'ΪʵȽؽϵؽȫĿΪ7¡˾߶ӣĿС鼰ѯãĿпǰ 
ISO 90012000     ϵ  Ŀ    ----رΪ򱦸ִ޹˾  
 ѵ /  ѯ    20014------200210 
ϵ ѯ  
2. ISO9000 ʶѵ  ѯѵʦ  
3. ϵļĲ߻ѵ ѯʼĿС  
4. ϵѵ ѯ 
5. 󼰹 ˾ԱĿС 
6. ֤׼֤ ĿС֤ 
 
','-3-')
Insert Into XS_ContractDetail( CD_ID,own_id,CT_ID,CD_Title,CD_levels,CD_parentid,CD_Content,CD_path ) Values(4,'fw001','2','һʦ',0,0,'ʿ','-4-')
Insert Into XS_ContractDetail( CD_ID,own_id,CT_ID,CD_Title,CD_levels,CD_parentid,CD_Content,CD_path ) Values(5,'fw001','1',' ֧',0,0,'1. Ŀ 10 % ǩͬʱ֧ 
   2. Ŀ 40 % ļ֧. 
   3. Ŀ 50 % ֳ֤֧ͨ 
','-5-')
Insert Into XS_ContractDetail( CD_ID,own_id,CT_ID,CD_Title,CD_levels,CD_parentid,CD_Content,CD_path ) Values(6,'fw001','1',' ͬΥԼ',0,0,'κһΥͬԼΥԼӦٲίԱйع涨еΥԼΡ','-6-')
Insert Into XS_ContractDetail( CD_ID,own_id,CT_ID,CD_Title,CD_levels,CD_parentid,CD_Content,CD_path ) Values(7,'fw001','2','ʿʮֵķ',0,0,'ʿʮ','-7-')
Insert Into XS_ContractDetail( CD_ID,own_id,CT_ID,CD_Title,CD_levels,CD_parentid,CD_Content,CD_path ) Values(8,'fw001','2','ʿĵڷֵ',0,0,'ʿʿƵ
ʦǴʦ','-8-')
GO

Insert Into XS_ContractText( CT_ID,own_id,CT_Name,CT_Type,CT_Desc,XC_ID ) Values(1,'fw001','sdf',13,'sdfsd',Null)
Insert Into XS_ContractText( CT_ID,own_id,CT_Name,CT_Type,CT_Desc,XC_ID ) Values(2,'fw001','ǵķǵķ',17,'ǵķǵķ ',Null)
GO

Insert Into xs_CrtExpense( ce_id,own_id,cr_id,task_id,ce_name,ce_days,ce_charge,ce_chargerate ) Values(1,'fw001     ',3,35,'ϵ',10,10000,'ѯ  ')
Insert Into xs_CrtExpense( ce_id,own_id,cr_id,task_id,ce_name,ce_days,ce_charge,ce_chargerate ) Values(2,'fw001     ',3,35,'ύ',3,3000,'ѯ  ')
Insert Into xs_CrtExpense( ce_id,own_id,cr_id,task_id,ce_name,ce_days,ce_charge,ce_chargerate ) Values(3,'fw001     ',3,37,'ϵļ߻ѵ',2,2000,'ѯ  ')
Insert Into xs_CrtExpense( ce_id,own_id,cr_id,task_id,ce_name,ce_days,ce_charge,ce_chargerate ) Values(4,'fw001     ',3,36,'IS0 9000 ʶѵ',2,4000,'ѵ  ')
Insert Into xs_CrtExpense( ce_id,own_id,cr_id,task_id,ce_name,ce_days,ce_charge,ce_chargerate ) Values(5,'fw001     ',3,37,'ļķ',0,0,'ѯ  ')
Insert Into xs_CrtExpense( ce_id,own_id,cr_id,task_id,ce_name,ce_days,ce_charge,ce_chargerate ) Values(6,'fw001     ',3,37,'ϵļıд',5,5000,'ѯ  ')
Insert Into xs_CrtExpense( ce_id,own_id,cr_id,task_id,ce_name,ce_days,ce_charge,ce_chargerate ) Values(7,'fw001     ',3,38,'ϵʵʩǰѵļͬʱУ',1,1000,'ѯ  ')
Insert Into xs_CrtExpense( ce_id,own_id,cr_id,task_id,ce_name,ce_days,ce_charge,ce_chargerate ) Values(8,'fw001     ',2,29,'ϵ',2,4000,'ѯ  ')
Insert Into xs_CrtExpense( ce_id,own_id,cr_id,task_id,ce_name,ce_days,ce_charge,ce_chargerate ) Values(9,'fw001     ',7,40,'fte',2,4666,'ѯ  ')
Insert Into xs_CrtExpense( ce_id,own_id,cr_id,task_id,ce_name,ce_days,ce_charge,ce_chargerate ) Values(10,'fw001     ',8,41,'dfd',2,4000,'ѯ  ')
Insert Into xs_CrtExpense( ce_id,own_id,cr_id,task_id,ce_name,ce_days,ce_charge,ce_chargerate ) Values(11,'fw001     ',9,48,'sdfd',3,6000,'ѯ  ')
Insert Into xs_CrtExpense( ce_id,own_id,cr_id,task_id,ce_name,ce_days,ce_charge,ce_chargerate ) Values(12,'fw001     ',10,49,'asd',23,78959,'ѯ  ')
GO

Insert Into XS_CustFunds( own_id,cust_id,cf_amountinit,cf_profitinit,cf_receiveinit,cf_amount,cf_profit,cf_receive ) Values('fw001',9,0,0,0,45000,0,0)
Insert Into XS_CustFunds( own_id,cust_id,cf_amountinit,cf_profitinit,cf_receiveinit,cf_amount,cf_profit,cf_receive ) Values('fw001',13,0,0,0,76515,0,14000)
GO

Insert Into XS_Opportunity( oppt_id,own_id,oppt_subject,cust_id,oppt_source,oppt_type,oppt_phase,phase_id,oppt_status,oppt_valuable,oppt_createdate,oppt_start,oppt_end,oppt_close,oppt_succeed,oppt_reason,oppt_closedate,oppt_closedesc,oppt_maker,oppt_manager,oppt_revenue,oppt_probability,oppt_memo ) Values(7,'fw001','Test',9,1,Null,2,1,2,'߼ֵ','2002-3-21','2002-3-21','2002-3-31','1','1',Null,'2002-3-31','',1,5,0,10,'')
Insert Into XS_Opportunity( oppt_id,own_id,oppt_subject,cust_id,oppt_source,oppt_type,oppt_phase,phase_id,oppt_status,oppt_valuable,oppt_createdate,oppt_start,oppt_end,oppt_close,oppt_succeed,oppt_reason,oppt_closedate,oppt_closedesc,oppt_maker,oppt_manager,oppt_revenue,oppt_probability,oppt_memo ) Values(8,'fw001','豸',1384,5,Null,5,2,2,'ֵһ','2002-3-21','2002-3-21','2002-3-21','0','0',Null,'','',1,5,100000,10,'')
Insert Into XS_Opportunity( oppt_id,own_id,oppt_subject,cust_id,oppt_source,oppt_type,oppt_phase,phase_id,oppt_status,oppt_valuable,oppt_createdate,oppt_start,oppt_end,oppt_close,oppt_succeed,oppt_reason,oppt_closedate,oppt_closedesc,oppt_maker,oppt_manager,oppt_revenue,oppt_probability,oppt_memo ) Values(9,'fw001','sdfasdfasdf',10,Null,Null,1,3,Null,'','2002-3-21','2002-3-21','2002-3-27','0','0',Null,'','',1,1,5000,0,'')
Insert Into XS_Opportunity( oppt_id,own_id,oppt_subject,cust_id,oppt_source,oppt_type,oppt_phase,phase_id,oppt_status,oppt_valuable,oppt_createdate,oppt_start,oppt_end,oppt_close,oppt_succeed,oppt_reason,oppt_closedate,oppt_closedesc,oppt_maker,oppt_manager,oppt_revenue,oppt_probability,oppt_memo ) Values(10,'fw001','ҵģҪһµԡ',5,5,1,1,6,Null,'ֵһ','2002-3-30','2002-3-30','2002-3-5','1','1',Null,'2002-6-28','',1,Null,105200,10,'')
Insert Into XS_Opportunity( oppt_id,own_id,oppt_subject,cust_id,oppt_source,oppt_type,oppt_phase,phase_id,oppt_status,oppt_valuable,oppt_createdate,oppt_start,oppt_end,oppt_close,oppt_succeed,oppt_reason,oppt_closedate,oppt_closedesc,oppt_maker,oppt_manager,oppt_revenue,oppt_probability,oppt_memo ) Values(13,'fw001','ϵ',1393,5,3,4,43,1,'߼ֵ','2002-4-2','2003-6-30','2003-6-30','0','0',Null,'','',1,5,500000,40,'ŶػΪŶŶ')
Insert Into XS_Opportunity( oppt_id,own_id,oppt_subject,cust_id,oppt_source,oppt_type,oppt_phase,phase_id,oppt_status,oppt_valuable,oppt_createdate,oppt_start,oppt_end,oppt_close,oppt_succeed,oppt_reason,oppt_closedate,oppt_closedesc,oppt_maker,oppt_manager,oppt_revenue,oppt_probability,oppt_memo ) Values(19,'fw001','蹺һͿ豸',1386,22,2,1,28,2,'ֵһ','2002-4-2','2003-6-20','2003-6-30','0','0',Null,'','',1,5,100000,10,'')
Insert Into XS_Opportunity( oppt_id,own_id,oppt_subject,cust_id,oppt_source,oppt_type,oppt_phase,phase_id,oppt_status,oppt_valuable,oppt_createdate,oppt_start,oppt_end,oppt_close,oppt_succeed,oppt_reason,oppt_closedate,oppt_closedesc,oppt_maker,oppt_manager,oppt_revenue,oppt_probability,oppt_memo ) Values(20,'fw001','緿ϵ',1396,1,2,6,44,1,'߼ֵ','2002-4-2','2003-6-14','2003-6-30','0','0',Null,'','',1,10,500000,60,'ۻŶڻŶŶŶ')
Insert Into XS_Opportunity( oppt_id,own_id,oppt_subject,cust_id,oppt_source,oppt_type,oppt_phase,phase_id,oppt_status,oppt_valuable,oppt_createdate,oppt_start,oppt_end,oppt_close,oppt_succeed,oppt_reason,oppt_closedate,oppt_closedesc,oppt_maker,oppt_manager,oppt_revenue,oppt_probability,oppt_memo ) Values(21,'fw001','aaaaaaaa',6,Null,Null,2,30,Null,'','2002-4-2','2002-4-2','2002-4-11','1','0',1,'2002-4-2','',1,Null,0,10,'')
Insert Into XS_Opportunity( oppt_id,own_id,oppt_subject,cust_id,oppt_source,oppt_type,oppt_phase,phase_id,oppt_status,oppt_valuable,oppt_createdate,oppt_start,oppt_end,oppt_close,oppt_succeed,oppt_reason,oppt_closedate,oppt_closedesc,oppt_maker,oppt_manager,oppt_revenue,oppt_probability,oppt_memo ) Values(22,'fw001','Ϳ豸',1397,3,1,7,45,2,'߼ֵ','2002-4-2','2003-6-12','2003-6-30','0','0',Null,'','',1,10,100000,70,'Ŷۺڻۺ8λŶŶ')
Insert Into XS_Opportunity( oppt_id,own_id,oppt_subject,cust_id,oppt_source,oppt_type,oppt_phase,phase_id,oppt_status,oppt_valuable,oppt_createdate,oppt_start,oppt_end,oppt_close,oppt_succeed,oppt_reason,oppt_closedate,oppt_closedesc,oppt_maker,oppt_manager,oppt_revenue,oppt_probability,oppt_memo ) Values(24,'fw001','¯ϵ',1398,2,3,9,42,2,'߼ֵ','2002-4-3','2003-6-5','2003-6-20','0','0',Null,'','',1,2,100000,90,'')
Insert Into XS_Opportunity( oppt_id,own_id,oppt_subject,cust_id,oppt_source,oppt_type,oppt_phase,phase_id,oppt_status,oppt_valuable,oppt_createdate,oppt_start,oppt_end,oppt_close,oppt_succeed,oppt_reason,oppt_closedate,oppt_closedesc,oppt_maker,oppt_manager,oppt_revenue,oppt_probability,oppt_memo ) Values(25,'fw001','Ϳ豸',1392,1,1,5,41,2,'߼ֵ','2002-4-14','2002-4-10','2003-6-26','0','0',Null,'','',5,5,500000,40,'ȹ˾ڽϰʵʩOAϵͳĹƻù˾˽гνӴҹ˾İ칫ϵͳƷȤ')
Insert Into XS_Opportunity( oppt_id,own_id,oppt_subject,cust_id,oppt_source,oppt_type,oppt_phase,phase_id,oppt_status,oppt_valuable,oppt_createdate,oppt_start,oppt_end,oppt_close,oppt_succeed,oppt_reason,oppt_closedate,oppt_closedesc,oppt_maker,oppt_manager,oppt_revenue,oppt_probability,oppt_memo ) Values(26,'fw001','test',21,Null,Null,1,40,Null,'','2002-6-10','2002-6-10','2002-6-13','1','1',Null,'2002-6-25','',1,Null,0,10,'')
Insert Into XS_Opportunity( oppt_id,own_id,oppt_subject,cust_id,oppt_source,oppt_type,oppt_phase,phase_id,oppt_status,oppt_valuable,oppt_createdate,oppt_start,oppt_end,oppt_close,oppt_succeed,oppt_reason,oppt_closedate,oppt_closedesc,oppt_maker,oppt_manager,oppt_revenue,oppt_probability,oppt_memo ) Values(27,'fw001','aaaaaaa',1400,Null,Null,1,Null,Null,'','2003-6-11','2003-6-11','2003-6-11','0','0',Null,'','',1,1,Null,Null,'')
Insert Into XS_Opportunity( oppt_id,own_id,oppt_subject,cust_id,oppt_source,oppt_type,oppt_phase,phase_id,oppt_status,oppt_valuable,oppt_createdate,oppt_start,oppt_end,oppt_close,oppt_succeed,oppt_reason,oppt_closedate,oppt_closedesc,oppt_maker,oppt_manager,oppt_revenue,oppt_probability,oppt_memo ) Values(28,'fw001','Ϳ豸',1388,1,2,2,46,2,'߼ֵ','2003-6-15','2003-6-15','2003-7-31','0','0',Null,'','',1,1,100000,20,'')
Insert Into XS_Opportunity( oppt_id,own_id,oppt_subject,cust_id,oppt_source,oppt_type,oppt_phase,phase_id,oppt_status,oppt_valuable,oppt_createdate,oppt_start,oppt_end,oppt_close,oppt_succeed,oppt_reason,oppt_closedate,oppt_closedesc,oppt_maker,oppt_manager,oppt_revenue,oppt_probability,oppt_memo ) Values(29,'fw001','豸',1382,3,1,8,47,2,'߼ֵ','2003-6-15','2003-6-15','2003-8-26','0','0',Null,'','',1,2,1000001,80,'')
Insert Into XS_Opportunity( oppt_id,own_id,oppt_subject,cust_id,oppt_source,oppt_type,oppt_phase,phase_id,oppt_status,oppt_valuable,oppt_createdate,oppt_start,oppt_end,oppt_close,oppt_succeed,oppt_reason,oppt_closedate,oppt_closedesc,oppt_maker,oppt_manager,oppt_revenue,oppt_probability,oppt_memo ) Values(30,'fw001','ʩ',1380,3,1,5,48,Null,'','2003-6-15','2003-6-15','2003-6-28','0','0',Null,'','',1,1,2222220,50,'')
Insert Into XS_Opportunity( oppt_id,own_id,oppt_subject,cust_id,oppt_source,oppt_type,oppt_phase,phase_id,oppt_status,oppt_valuable,oppt_createdate,oppt_start,oppt_end,oppt_close,oppt_succeed,oppt_reason,oppt_closedate,oppt_closedesc,oppt_maker,oppt_manager,oppt_revenue,oppt_probability,oppt_memo ) Values(31,'fw001','豸',1381,2,2,9,49,Null,'','2003-6-15','2003-6-15','2003-6-30','0','0',Null,'','',1,5,222220,90,'')
Insert Into XS_Opportunity( oppt_id,own_id,oppt_subject,cust_id,oppt_source,oppt_type,oppt_phase,phase_id,oppt_status,oppt_valuable,oppt_createdate,oppt_start,oppt_end,oppt_close,oppt_succeed,oppt_reason,oppt_closedate,oppt_closedesc,oppt_maker,oppt_manager,oppt_revenue,oppt_probability,oppt_memo ) Values(32,'fw001','sdfdsf',1400,Null,Null,1,Null,Null,'','2003-6-18','2003-6-18','2003-6-18','0','0',Null,'','',1,1,Null,Null,'')
GO

Insert Into XS_OpptContact( own_id,oppt_id,contact_id,oc_main,oc_degree,oc_force,oc_tactic,oc_memo ) Values('fw001',20,5,'0','','','','')
Insert Into XS_OpptContact( own_id,oppt_id,contact_id,oc_main,oc_degree,oc_force,oc_tactic,oc_memo ) Values('fw001',13,7,'0','г','оȨ','','')
Insert Into XS_OpptContact( own_id,oppt_id,contact_id,oc_main,oc_degree,oc_force,oc_tactic,oc_memo ) Values('fw001',19,5,'0','','','','')
Insert Into XS_OpptContact( own_id,oppt_id,contact_id,oc_main,oc_degree,oc_force,oc_tactic,oc_memo ) Values('fw001',22,5,'0','','','','')
Insert Into XS_OpptContact( own_id,oppt_id,contact_id,oc_main,oc_degree,oc_force,oc_tactic,oc_memo ) Values('fw001',24,7,'0','','','','')
Insert Into XS_OpptContact( own_id,oppt_id,contact_id,oc_main,oc_degree,oc_force,oc_tactic,oc_memo ) Values('fw001',26,23,'0','','','','')
Insert Into XS_OpptContact( own_id,oppt_id,contact_id,oc_main,oc_degree,oc_force,oc_tactic,oc_memo ) Values('fw001',27,21,'0','','','','')
Insert Into XS_OpptContact( own_id,oppt_id,contact_id,oc_main,oc_degree,oc_force,oc_tactic,oc_memo ) Values('fw001',32,35,'0','','','','')
GO

Insert Into XS_OpptEmp( own_id,oppt_id,emp_id ) Values('fw001',7,4)
Insert Into XS_OpptEmp( own_id,oppt_id,emp_id ) Values('fw001',7,5)
Insert Into XS_OpptEmp( own_id,oppt_id,emp_id ) Values('fw001',5,5)
Insert Into XS_OpptEmp( own_id,oppt_id,emp_id ) Values('fw001',5,4)
Insert Into XS_OpptEmp( own_id,oppt_id,emp_id ) Values('fw001',5,9)
Insert Into XS_OpptEmp( own_id,oppt_id,emp_id ) Values('fw001',5,10)
Insert Into XS_OpptEmp( own_id,oppt_id,emp_id ) Values('fw001',20,2)
Insert Into XS_OpptEmp( own_id,oppt_id,emp_id ) Values('fw001',20,1)
Insert Into XS_OpptEmp( own_id,oppt_id,emp_id ) Values('fw001',20,3)
Insert Into XS_OpptEmp( own_id,oppt_id,emp_id ) Values('fw001',20,9)
Insert Into XS_OpptEmp( own_id,oppt_id,emp_id ) Values('fw001',20,12)
GO

Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(1,'fw001',7,1,'2002-3-21','2002-3-21')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(2,'fw001',8,3,'2002-3-21','2002-3-22')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(3,'fw001',9,1,'2002-3-21','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(4,'fw001',7,2,'2002-3-21','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(5,'fw001',8,5,'2002-3-22','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(6,'fw001',10,1,'2002-3-30','2002-6-28')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(7,'fw001',11,1,'2002-3-30','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(8,'fw001',12,2,'2002-3-30','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(9,'fw001',13,1,'2002-4-2','2003-6-15')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(10,'fw001',14,1,'2002-4-2','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(11,'fw001',14,1,'2002-4-2','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(12,'fw001',15,1,'2002-4-2','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(13,'fw001',16,1,'2002-4-2','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(14,'fw001',17,1,'2002-4-2','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(15,'fw001',18,1,'2002-4-2','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(16,'fw001',15,2,'2002-4-2','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(17,'fw001',16,1,'2002-4-2','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(18,'fw001',17,1,'2002-4-2','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(19,'fw001',17,1,'2002-4-2','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(20,'fw001',18,1,'2002-4-2','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(21,'fw001',18,1,'2002-4-2','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(22,'fw001',18,1,'2002-4-2','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(23,'fw001',19,1,'2002-4-2','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(24,'fw001',18,1,'2002-4-2','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(25,'fw001',19,2,'2002-4-2','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(26,'fw001',20,2,'2002-4-2','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(27,'fw001',21,1,'2002-4-2','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(28,'fw001',19,1,'2002-4-2','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(29,'fw001',20,1,'2002-4-2','2003-6-15')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(30,'fw001',21,2,'2002-4-2','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(31,'fw001',22,1,'2002-4-2','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(32,'fw001',22,1,'2002-4-2','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(33,'fw001',22,1,'2002-4-2','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(34,'fw001',22,1,'2002-4-2','2003-6-15')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(35,'fw001',23,2,'2002-4-2','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(36,'fw001',23,1,'2002-4-3','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(37,'fw001',24,1,'2002-4-3','2003-6-15')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(38,'fw001',25,1,'2002-4-14','2003-6-15')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(39,'fw001',26,1,'2002-5-21','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(40,'fw001',26,1,'2002-6-10','2002-6-25')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(41,'fw001',25,5,'2003-6-15','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(42,'fw001',24,9,'2003-6-15','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(43,'fw001',13,4,'2003-6-15','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(44,'fw001',20,6,'2003-6-15','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(45,'fw001',22,7,'2003-6-15','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(46,'fw001',28,2,'2003-6-15','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(47,'fw001',29,8,'2003-6-15','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(48,'fw001',30,5,'2003-6-15','')
Insert Into XS_OpptPhase( phase_id,own_id,oppt_id,oppt_phase,phase_begin,phase_end ) Values(49,'fw001',31,9,'2003-6-15','')
GO

Insert Into XS_OpptProd( own_id,oppt_id,prod_id,op_price,op_qty,op_amount,op_memo ) Values('fw001',1,13,100,200,20000,'Test')
Insert Into XS_OpptProd( own_id,oppt_id,prod_id,op_price,op_qty,op_amount,op_memo ) Values('fw001',1,14,2900,10,29000,'')
Insert Into XS_OpptProd( own_id,oppt_id,prod_id,op_price,op_qty,op_amount,op_memo ) Values('fw001',7,22,3000,2,6000,'asdfasdfa')
GO

Insert Into XS_OpptRival( own_id,oppt_id,ri_id,rp_id,or_main,or_strength,or_weakness,or_tactic,or_memo ) Values('fw001',5,5,14,'0','','','','')
Insert Into XS_OpptRival( own_id,oppt_id,ri_id,rp_id,or_main,or_strength,or_weakness,or_tactic,or_memo ) Values('fw001',7,3,14,'0','asdfasdf','asdfasdf','asdfas','test')
Insert Into XS_OpptRival( own_id,oppt_id,ri_id,rp_id,or_main,or_strength,or_weakness,or_tactic,or_memo ) Values('fw001',5,3,13,'1','ƷȽϳ','ȫ','','')
GO

Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',1,1,'EMPLOYEE',2002,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',1,2,'EMPLOYEE',2002,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',1,3,'EMPLOYEE',2002,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',1,4,'EMPLOYEE',2002,1,2,3,4,5,6,7,8,9,10,11,12,78)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',1,5,'EMPLOYEE',2002,1,2,3,4,5,6,7,8,9,10,11,12,78)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',2,15,'PRODUCT',2002,1,2,3,4,5,6,7,8,9,10,11,12,78)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',2,22,'PRODUCT',2002,1,2,3,4,5,6,7,8,9,10,11,12,78)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',2,23,'PRODUCT',2002,10,20,30,40,50,60,70,80,90,100,110,120,780)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',2,24,'PRODUCT',2002,1,2,3,4,5,6,7,8,9,10,11,12,78)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',3,4,'AREA',2002,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',3,5,'AREA',2002,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',3,35,'AREA',2002,1,2,3,4,5,6,7,8,9,10,11,12,78)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',3,36,'AREA',2002,10,10,20,30,40,50,60,70,80,90,11,10,481)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',3,47,'AREA',2002,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',4,1,'EMPLOYEE',2003,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',4,2,'EMPLOYEE',Null,101,10,20,30,100,0,0,0,0,0,0,0,261)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',5,2,'PRODUCT',Null,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',6,35,'AREA',2003,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',6,59,'AREA',2003,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',6,62,'AREA',2003,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',6,63,'AREA',2003,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',6,64,'AREA',2003,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',6,65,'AREA',2003,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',7,35,'AREA',2001,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',7,39,'AREA',2001,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',7,61,'AREA',2001,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',8,1,'EMPLOYEE',Null,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',8,4,'EMPLOYEE',1999,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',8,5,'EMPLOYEE',Null,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',9,1,'EMPLOYEE',2001,33,33,3,33,33,33,33,33,33,33,33,33,366)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',9,2,'EMPLOYEE',2001,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',9,3,'EMPLOYEE',2001,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',9,4,'EMPLOYEE',2001,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',9,5,'EMPLOYEE',2001,33,333,33,3,3,3,33,33,3,3,3,3,486)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',11,2,'AREA',2005,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',11,24,'AREA',2005,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',11,25,'AREA',2005,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',11,27,'AREA',2005,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',11,28,'AREA',2005,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',11,29,'AREA',2005,1,0,0,0,0,0,0,0,0,0,0,0,1)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',11,30,'AREA',2005,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',11,50,'AREA',2005,0,0,0,0,0,0,0,0,0,0,0,0,0)
Insert Into XS_Plan_D( own_id,plan_id,plan_object,plan_type,plan_year,plan_month1,plan_month2,plan_month3,plan_month4,plan_month5,plan_month6,plan_month7,plan_month8,plan_month9,plan_month10,plan_month11,plan_month12,plan_subtotal ) Values('fw001',13,50,'AREA',2007,0,0,0,0,0,0,0,0,0,0,0,0,0)
GO

Insert Into XS_Plan_H( plan_id,own_id,plan_code,plan_type,plan_subject,plan_year,plan_maker,plan_amount,plan_createdate,plan_memo ) Values(1,'fw001','Plan2002','EMPLOYEE','2002Աۼƻ',2002,1,156,'2002-1-29','2002')
Insert Into XS_Plan_H( plan_id,own_id,plan_code,plan_type,plan_subject,plan_year,plan_maker,plan_amount,plan_createdate,plan_memo ) Values(2,'fw001','plan2002','PRODUCT','2002ȲƷۼƻ',2002,1,1014,'2002-1-29','')
Insert Into XS_Plan_H( plan_id,own_id,plan_code,plan_type,plan_subject,plan_year,plan_maker,plan_amount,plan_createdate,plan_memo ) Values(3,'fw001','plan2002','AREA','2002ۼƻ',2002,1,559,'2002-1-29','Test')
Insert Into XS_Plan_H( plan_id,own_id,plan_code,plan_type,plan_subject,plan_year,plan_maker,plan_amount,plan_createdate,plan_memo ) Values(4,'fw001','plan2003','EMPLOYEE','2003Աۼƻ',2003,1,261,'2002-1-29','')
Insert Into XS_Plan_H( plan_id,own_id,plan_code,plan_type,plan_subject,plan_year,plan_maker,plan_amount,plan_createdate,plan_memo ) Values(5,'fw001','plan2004','PRODUCT','sssss',2004,1,0,'2002-1-29','')
Insert Into XS_Plan_H( plan_id,own_id,plan_code,plan_type,plan_subject,plan_year,plan_maker,plan_amount,plan_createdate,plan_memo ) Values(6,'fw001','plan2003','AREA','2003ۼƻ',2003,1,0,'2002-1-29','')
Insert Into XS_Plan_H( plan_id,own_id,plan_code,plan_type,plan_subject,plan_year,plan_maker,plan_amount,plan_createdate,plan_memo ) Values(7,'fw001','plan2001','AREA','2001ۼƻ',2001,1,0,'2002-2-1','')
Insert Into XS_Plan_H( plan_id,own_id,plan_code,plan_type,plan_subject,plan_year,plan_maker,plan_amount,plan_createdate,plan_memo ) Values(8,'fw001','plan1999','EMPLOYEE','1999Աۼƻ',1999,1,0,'2002-2-3','')
Insert Into XS_Plan_H( plan_id,own_id,plan_code,plan_type,plan_subject,plan_year,plan_maker,plan_amount,plan_createdate,plan_memo ) Values(9,'fw001','plan2001','EMPLOYEE','2001Աۼƻ',2001,1,852,'2002-3-11','sadasd')
Insert Into XS_Plan_H( plan_id,own_id,plan_code,plan_type,plan_subject,plan_year,plan_maker,plan_amount,plan_createdate,plan_memo ) Values(11,'fw001','plan2005','AREA','ۼƻ',2005,1,1,'2002-3-30','')
Insert Into XS_Plan_H( plan_id,own_id,plan_code,plan_type,plan_subject,plan_year,plan_maker,plan_amount,plan_createdate,plan_memo ) Values(13,'fw001','sdfsdf','AREA','rgdfs',2007,1,0,'2002-5-23','')
GO

Insert Into XS_QP_D( own_id,qp_id,prod_id,qp_discount,qp_taxrate,qp_price,qp_lastprice,qp_qty,qp_amount ) Values('fw001',1,10,100,0,Null,1000,10,10000)
Insert Into XS_QP_D( own_id,qp_id,prod_id,qp_discount,qp_taxrate,qp_price,qp_lastprice,qp_qty,qp_amount ) Values('fw001',1,11,100,0,Null,1200,10,12000)
Insert Into XS_QP_D( own_id,qp_id,prod_id,qp_discount,qp_taxrate,qp_price,qp_lastprice,qp_qty,qp_amount ) Values('fw001',2,18,100,0,Null,2200,10,22000)
Insert Into XS_QP_D( own_id,qp_id,prod_id,qp_discount,qp_taxrate,qp_price,qp_lastprice,qp_qty,qp_amount ) Values('fw001',2,24,100,0,Null,3500,10,35000)
Insert Into XS_QP_D( own_id,qp_id,prod_id,qp_discount,qp_taxrate,qp_price,qp_lastprice,qp_qty,qp_amount ) Values('fw001',3,2,100,5,Null,28140,1,28140)
Insert Into XS_QP_D( own_id,qp_id,prod_id,qp_discount,qp_taxrate,qp_price,qp_lastprice,qp_qty,qp_amount ) Values('fw001',3,6,100,0,Null,1600,2,3200)
Insert Into XS_QP_D( own_id,qp_id,prod_id,qp_discount,qp_taxrate,qp_price,qp_lastprice,qp_qty,qp_amount ) Values('fw001',4,14,100,0,Null,2900,10,29000)
Insert Into XS_QP_D( own_id,qp_id,prod_id,qp_discount,qp_taxrate,qp_price,qp_lastprice,qp_qty,qp_amount ) Values('fw001',4,18,100,0,Null,2200,5,11000)
Insert Into XS_QP_D( own_id,qp_id,prod_id,qp_discount,qp_taxrate,qp_price,qp_lastprice,qp_qty,qp_amount ) Values('fw001',4,22,100,0,Null,3000,10,30000)
Insert Into XS_QP_D( own_id,qp_id,prod_id,qp_discount,qp_taxrate,qp_price,qp_lastprice,qp_qty,qp_amount ) Values('fw001',4,32,100,0,Null,1500,10,15000)
Insert Into XS_QP_D( own_id,qp_id,prod_id,qp_discount,qp_taxrate,qp_price,qp_lastprice,qp_qty,qp_amount ) Values('fw001',4,33,100,0,Null,1500,5,7500)
Insert Into XS_QP_D( own_id,qp_id,prod_id,qp_discount,qp_taxrate,qp_price,qp_lastprice,qp_qty,qp_amount ) Values('fw001',4,34,100,0,Null,16800,33,554400)
Insert Into XS_QP_D( own_id,qp_id,prod_id,qp_discount,qp_taxrate,qp_price,qp_lastprice,qp_qty,qp_amount ) Values('fw001',4,35,100,0,Null,34556,10,345560)
Insert Into XS_QP_D( own_id,qp_id,prod_id,qp_discount,qp_taxrate,qp_price,qp_lastprice,qp_qty,qp_amount ) Values('fw001',7,2,100,0,Null,26800,2,53600)
Insert Into XS_QP_D( own_id,qp_id,prod_id,qp_discount,qp_taxrate,qp_price,qp_lastprice,qp_qty,qp_amount ) Values('fw001',7,5,100,0,Null,1500,10,15000)
Insert Into XS_QP_D( own_id,qp_id,prod_id,qp_discount,qp_taxrate,qp_price,qp_lastprice,qp_qty,qp_amount ) Values('fw001',7,9,100,0,Null,1400,5,7000)
Insert Into XS_QP_D( own_id,qp_id,prod_id,qp_discount,qp_taxrate,qp_price,qp_lastprice,qp_qty,qp_amount ) Values('fw001',7,26,100,0,Null,640,10,6400)
Insert Into XS_QP_D( own_id,qp_id,prod_id,qp_discount,qp_taxrate,qp_price,qp_lastprice,qp_qty,qp_amount ) Values('fw001',7,29,100,0,Null,1399,2,2798)
Insert Into XS_QP_D( own_id,qp_id,prod_id,qp_discount,qp_taxrate,qp_price,qp_lastprice,qp_qty,qp_amount ) Values('fw001',7,33,100,0,Null,1500,10,15000)
Insert Into XS_QP_D( own_id,qp_id,prod_id,qp_discount,qp_taxrate,qp_price,qp_lastprice,qp_qty,qp_amount ) Values('fw001',7,36,100,0,Null,16852,5,84260)
Insert Into XS_QP_D( own_id,qp_id,prod_id,qp_discount,qp_taxrate,qp_price,qp_lastprice,qp_qty,qp_amount ) Values('fw001',8,5,100,0,Null,1500,5,7500)
Insert Into XS_QP_D( own_id,qp_id,prod_id,qp_discount,qp_taxrate,qp_price,qp_lastprice,qp_qty,qp_amount ) Values('fw001',8,11,100,0,Null,1200,12,14400)
Insert Into XS_QP_D( own_id,qp_id,prod_id,qp_discount,qp_taxrate,qp_price,qp_lastprice,qp_qty,qp_amount ) Values('fw001',8,18,100,0,Null,2200,10,22000)
GO

Insert Into XS_QP_H( qp_id,own_id,qp_code,cust_id,contact_id,oppt_id,qp_date,qp_createdate,qp_memo,qp_maker,qp_sales,qp_checker,qp_amount,qp_check,qp_close,qp_closedate ) Values(1,'fw001','XS-QP-20020414-0001',5,Null,Null,'2002-4-1','2002-4-14','',2,1,1,22000,'1','0','')
Insert Into XS_QP_H( qp_id,own_id,qp_code,cust_id,contact_id,oppt_id,qp_date,qp_createdate,qp_memo,qp_maker,qp_sales,qp_checker,qp_amount,qp_check,qp_close,qp_closedate ) Values(2,'fw001','XS-QP-20020414-0002',17,Null,Null,'2002-4-10','2002-4-14','',5,1,1,57000,'2','1','2003-6-13')
Insert Into XS_QP_H( qp_id,own_id,qp_code,cust_id,contact_id,oppt_id,qp_date,qp_createdate,qp_memo,qp_maker,qp_sales,qp_checker,qp_amount,qp_check,qp_close,qp_closedate ) Values(3,'fw001','XS-QP-20020521-0003',5,15,10,'2002-5-21','2002-5-21','',1,9,Null,31340,'','0','')
Insert Into XS_QP_H( qp_id,own_id,qp_code,cust_id,contact_id,oppt_id,qp_date,qp_createdate,qp_memo,qp_maker,qp_sales,qp_checker,qp_amount,qp_check,qp_close,qp_closedate ) Values(4,'fw001','XS-QP-20020522-0001',4,0,0,'2002-5-22','2002-5-22','',1,10,1,999960,'1','0','')
Insert Into XS_QP_H( qp_id,own_id,qp_code,cust_id,contact_id,oppt_id,qp_date,qp_createdate,qp_memo,qp_maker,qp_sales,qp_checker,qp_amount,qp_check,qp_close,qp_closedate ) Values(6,'fw001','XS-QP-20020522-0006',16,0,0,'2002-5-22','2002-5-22','',1,12,Null,0,'','1','2002-6-25')
Insert Into XS_QP_H( qp_id,own_id,qp_code,cust_id,contact_id,oppt_id,qp_date,qp_createdate,qp_memo,qp_maker,qp_sales,qp_checker,qp_amount,qp_check,qp_close,qp_closedate ) Values(7,'fw001','XS-QP-20030623-0001',1393,0,13,'2003-6-23','2003-6-23','',1,2,1,184058,'1','0','')
Insert Into XS_QP_H( qp_id,own_id,qp_code,cust_id,contact_id,oppt_id,qp_date,qp_createdate,qp_memo,qp_maker,qp_sales,qp_checker,qp_amount,qp_check,qp_close,qp_closedate ) Values(8,'fw001','XS-QP-20030624-0001',1388,28,28,'2003-6-24','2003-6-24','',1,2,Null,43900,'','0','')
GO

Insert Into XS_SO_D( own_id,so_id,prod_id,so_price,so_discount,so_taxrate,so_lastprice,so_qty,so_deliveryqty,so_amount,so_qp_id ) Values('fw001',4,12,Null,100,0,1400,10,0,14000,Null)
Insert Into XS_SO_D( own_id,so_id,prod_id,so_price,so_discount,so_taxrate,so_lastprice,so_qty,so_deliveryqty,so_amount,so_qp_id ) Values('fw001',4,18,Null,100,0,2200,10,0,22000,2)
Insert Into XS_SO_D( own_id,so_id,prod_id,so_price,so_discount,so_taxrate,so_lastprice,so_qty,so_deliveryqty,so_amount,so_qp_id ) Values('fw001',4,24,Null,100,0,3500,10,0,35000,2)
Insert Into XS_SO_D( own_id,so_id,prod_id,so_price,so_discount,so_taxrate,so_lastprice,so_qty,so_deliveryqty,so_amount,so_qp_id ) Values('fw001',8,5,Null,100,0,1500,10,0,15000,Null)
Insert Into XS_SO_D( own_id,so_id,prod_id,so_price,so_discount,so_taxrate,so_lastprice,so_qty,so_deliveryqty,so_amount,so_qp_id ) Values('fw001',11,33,Null,100,0,1500,10,0,15000,Null)
Insert Into XS_SO_D( own_id,so_id,prod_id,so_price,so_discount,so_taxrate,so_lastprice,so_qty,so_deliveryqty,so_amount,so_qp_id ) Values('fw001',12,10,Null,100,0,1000,10,0,10000,1)
Insert Into XS_SO_D( own_id,so_id,prod_id,so_price,so_discount,so_taxrate,so_lastprice,so_qty,so_deliveryqty,so_amount,so_qp_id ) Values('fw001',12,11,Null,100,0,1200,10,0,12000,1)
Insert Into XS_SO_D( own_id,so_id,prod_id,so_price,so_discount,so_taxrate,so_lastprice,so_qty,so_deliveryqty,so_amount,so_qp_id ) Values('fw001',13,10,Null,100,0,1000,10,0,10000,1)
Insert Into XS_SO_D( own_id,so_id,prod_id,so_price,so_discount,so_taxrate,so_lastprice,so_qty,so_deliveryqty,so_amount,so_qp_id ) Values('fw001',13,11,Null,100,0,1200,10,0,12000,1)
Insert Into XS_SO_D( own_id,so_id,prod_id,so_price,so_discount,so_taxrate,so_lastprice,so_qty,so_deliveryqty,so_amount,so_qp_id ) Values('fw001',14,10,Null,100,0,1000,10,10,10000,1)
Insert Into XS_SO_D( own_id,so_id,prod_id,so_price,so_discount,so_taxrate,so_lastprice,so_qty,so_deliveryqty,so_amount,so_qp_id ) Values('fw001',14,11,Null,100,0,1200,10,10,12000,1)
Insert Into XS_SO_D( own_id,so_id,prod_id,so_price,so_discount,so_taxrate,so_lastprice,so_qty,so_deliveryqty,so_amount,so_qp_id ) Values('fw001',15,14,Null,100,0,2900,10,5,29000,4)
Insert Into XS_SO_D( own_id,so_id,prod_id,so_price,so_discount,so_taxrate,so_lastprice,so_qty,so_deliveryqty,so_amount,so_qp_id ) Values('fw001',15,18,Null,100,0,2200,5,0,11000,4)
Insert Into XS_SO_D( own_id,so_id,prod_id,so_price,so_discount,so_taxrate,so_lastprice,so_qty,so_deliveryqty,so_amount,so_qp_id ) Values('fw001',15,22,Null,100,0,3000,10,0,30000,4)
Insert Into XS_SO_D( own_id,so_id,prod_id,so_price,so_discount,so_taxrate,so_lastprice,so_qty,so_deliveryqty,so_amount,so_qp_id ) Values('fw001',15,33,Null,100,0,1500,5,0,7500,4)
Insert Into XS_SO_D( own_id,so_id,prod_id,so_price,so_discount,so_taxrate,so_lastprice,so_qty,so_deliveryqty,so_amount,so_qp_id ) Values('fw001',15,34,Null,100,0,16800,33,0,554400,4)
Insert Into XS_SO_D( own_id,so_id,prod_id,so_price,so_discount,so_taxrate,so_lastprice,so_qty,so_deliveryqty,so_amount,so_qp_id ) Values('fw001',15,35,Null,100,0,34556,10,0,345560,4)
Insert Into XS_SO_D( own_id,so_id,prod_id,so_price,so_discount,so_taxrate,so_lastprice,so_qty,so_deliveryqty,so_amount,so_qp_id ) Values('fw001',16,2,Null,100,0,26800,2,0,53600,7)
Insert Into XS_SO_D( own_id,so_id,prod_id,so_price,so_discount,so_taxrate,so_lastprice,so_qty,so_deliveryqty,so_amount,so_qp_id ) Values('fw001',16,5,Null,100,0,1500,10,0,15000,7)
Insert Into XS_SO_D( own_id,so_id,prod_id,so_price,so_discount,so_taxrate,so_lastprice,so_qty,so_deliveryqty,so_amount,so_qp_id ) Values('fw001',16,9,Null,100,0,1400,5,0,7000,7)
Insert Into XS_SO_D( own_id,so_id,prod_id,so_price,so_discount,so_taxrate,so_lastprice,so_qty,so_deliveryqty,so_amount,so_qp_id ) Values('fw001',16,26,Null,100,0,640,10,0,6400,7)
Insert Into XS_SO_D( own_id,so_id,prod_id,so_price,so_discount,so_taxrate,so_lastprice,so_qty,so_deliveryqty,so_amount,so_qp_id ) Values('fw001',16,29,Null,100,0,1399,2,0,2798,7)
Insert Into XS_SO_D( own_id,so_id,prod_id,so_price,so_discount,so_taxrate,so_lastprice,so_qty,so_deliveryqty,so_amount,so_qp_id ) Values('fw001',16,33,Null,100,0,1500,10,0,15000,7)
Insert Into XS_SO_D( own_id,so_id,prod_id,so_price,so_discount,so_taxrate,so_lastprice,so_qty,so_deliveryqty,so_amount,so_qp_id ) Values('fw001',16,36,Null,100,0,16852,5,0,84260,7)
GO

Insert Into XS_SO_Delivery( so_id,prod_id,del_date,del_qty,del_operator,del_memo ) Values(14,10,'2003-6-23',10,1,'')
Insert Into XS_SO_Delivery( so_id,prod_id,del_date,del_qty,del_operator,del_memo ) Values(14,11,'2003-6-23',10,1,'')
Insert Into XS_SO_Delivery( so_id,prod_id,del_date,del_qty,del_operator,del_memo ) Values(15,14,'2003-6-23',5,1,'')
GO

Insert Into XS_SO_H( so_id,own_id,so_code,cust_id,so_createdate,so_deliverydate,so_deliveryaddr,so_sales,contact_id,oppt_id,so_source,so_maker,so_checker,so_memo,so_check,so_amount,so_profit,so_paidamount,so_close,so_closedate ) Values(3,'fw001','XS-S0-20020521-00003',4,'2002-5-21','','',10,22,22,0,1,Null,'','0',0,0,0,'1','2002-8-20')
Insert Into XS_SO_H( so_id,own_id,so_code,cust_id,so_createdate,so_deliverydate,so_deliveryaddr,so_sales,contact_id,oppt_id,so_source,so_maker,so_checker,so_memo,so_check,so_amount,so_profit,so_paidamount,so_close,so_closedate ) Values(4,'fw001','XS-S0-20020521-00004',17,'2002-5-21','','',2,Null,0,0,1,1,'','1',71000,0,0,'1','2002-6-26')
Insert Into XS_SO_H( so_id,own_id,so_code,cust_id,so_createdate,so_deliverydate,so_deliveryaddr,so_sales,contact_id,oppt_id,so_source,so_maker,so_checker,so_memo,so_check,so_amount,so_profit,so_paidamount,so_close,so_closedate ) Values(7,'fw001','XS-S0-20020522-00013',9,'2002-5-22','2002-5-30','sdfs',2,Null,0,0,1,1,'','2',0,0,0,'1','2002-5-22')
Insert Into XS_SO_H( so_id,own_id,so_code,cust_id,so_createdate,so_deliverydate,so_deliveryaddr,so_sales,contact_id,oppt_id,so_source,so_maker,so_checker,so_memo,so_check,so_amount,so_profit,so_paidamount,so_close,so_closedate ) Values(8,'fw001','XS-S0-20020522-00014',19,'2002-5-22','2002-5-24','',9,Null,0,0,1,1,'','1',15000,0,0,'0','')
Insert Into XS_SO_H( so_id,own_id,so_code,cust_id,so_createdate,so_deliverydate,so_deliveryaddr,so_sales,contact_id,oppt_id,so_source,so_maker,so_checker,so_memo,so_check,so_amount,so_profit,so_paidamount,so_close,so_closedate ) Values(10,'fw001','XS-S0-20020522-00016',13,'2002-5-22','2002-5-24','',3,Null,0,0,1,1,'','2',0,0,10000,'0','')
Insert Into XS_SO_H( so_id,own_id,so_code,cust_id,so_createdate,so_deliverydate,so_deliveryaddr,so_sales,contact_id,oppt_id,so_source,so_maker,so_checker,so_memo,so_check,so_amount,so_profit,so_paidamount,so_close,so_closedate ) Values(11,'fw001','XS-S0-20020522-00017',5,'2002-5-22','2002-5-23','',9,Null,8,0,1,1,'','1',15000,0,0,'1','2002-6-25')
Insert Into XS_SO_H( so_id,own_id,so_code,cust_id,so_createdate,so_deliverydate,so_deliveryaddr,so_sales,contact_id,oppt_id,so_source,so_maker,so_checker,so_memo,so_check,so_amount,so_profit,so_paidamount,so_close,so_closedate ) Values(12,'fw001','XS-S0-20030623-00001',5,'2003-6-23','','',1,Null,Null,Null,1,Null,'','0',22000,0,0,'0','')
Insert Into XS_SO_H( so_id,own_id,so_code,cust_id,so_createdate,so_deliverydate,so_deliveryaddr,so_sales,contact_id,oppt_id,so_source,so_maker,so_checker,so_memo,so_check,so_amount,so_profit,so_paidamount,so_close,so_closedate ) Values(13,'fw001','XS-S0-20030623-00023',5,'2003-6-23','','',1,Null,Null,Null,1,Null,'','0',22000,0,0,'0','')
Insert Into XS_SO_H( so_id,own_id,so_code,cust_id,so_createdate,so_deliverydate,so_deliveryaddr,so_sales,contact_id,oppt_id,so_source,so_maker,so_checker,so_memo,so_check,so_amount,so_profit,so_paidamount,so_close,so_closedate ) Values(14,'fw001','XS-S0-20030623-00024',5,'2003-6-23','','',1,Null,Null,Null,1,Null,'','0',22000,0,0,'0','')
Insert Into XS_SO_H( so_id,own_id,so_code,cust_id,so_createdate,so_deliverydate,so_deliveryaddr,so_sales,contact_id,oppt_id,so_source,so_maker,so_checker,so_memo,so_check,so_amount,so_profit,so_paidamount,so_close,so_closedate ) Values(15,'fw001','XS-S0-20030623-00025',4,'2003-6-23','','',10,0,0,Null,1,Null,'','0',977460,0,0,'0','')
Insert Into XS_SO_H( so_id,own_id,so_code,cust_id,so_createdate,so_deliverydate,so_deliveryaddr,so_sales,contact_id,oppt_id,so_source,so_maker,so_checker,so_memo,so_check,so_amount,so_profit,so_paidamount,so_close,so_closedate ) Values(16,'fw001','XS-S0-20030623-00026',1393,'2003-6-23','','',2,0,13,Null,1,Null,'','0',184058,0,0,'0','')
GO

Insert Into XS_SO_Receive( so_id,rec_date,rec_amount,rec_mode,rec_sales,rec_memo ) Values(10,'2002-8-2',10000,Null,3,'')
GO

Insert Into XS_Thread( own_id,XT_Code,XT_Name,XT_Source,XT_CreateDate,XT_Contact,XT_Title,XT_ConTel,XT_Email,XT_Sex,XT_Company,Xt_Trade,XT_CoAddr,XT_CoTel,XT_Area,XT_Region,XT_Desc,Emp_ID,XT_Check,Cust_ID,Contact_ID ) Values('fw001','0002','ͷ豸',20,'2003-6-17','ΰ˳','','021-52548526','234fs@dd.com','Ů','˼أʵҵ޹˾',5,'ƹϷɳ¸¸¸','',3,4,'fgdfg',14,'0',0,0)
Insert Into XS_Thread( own_id,XT_Code,XT_Name,XT_Source,XT_CreateDate,XT_Contact,XT_Title,XT_ConTel,XT_Email,XT_Sex,XT_Company,Xt_Trade,XT_CoAddr,XT_CoTel,XT_Area,XT_Region,XT_Desc,Emp_ID,XT_Check,Cust_ID,Contact_ID ) Values('fw001','0003','sdfsdf',1,'2003-6-18','sdfsdf','sdfs','020-2258285','','','sdfsdf',5,'sdf','',1,2,'sdfsdf',17,'0',0,0)
Insert Into XS_Thread( own_id,XT_Code,XT_Name,XT_Source,XT_CreateDate,XT_Contact,XT_Title,XT_ConTel,XT_Email,XT_Sex,XT_Company,Xt_Trade,XT_CoAddr,XT_CoTel,XT_Area,XT_Region,XT_Desc,Emp_ID,XT_Check,Cust_ID,Contact_ID ) Values('fw001','sf','sdf',2,'2003-6-18','sdfds','','','','','sfsd',6,'','',0,0,'',12,'1',0,0)
GO

Insert Into XS_ThreadAction( TA_ID,own_id,XT_ID,TA_Subject,TA_StartDate,TA_EndDate,TA_Sort,TA_ExecEmp,TA_Desc ) Values(1,'fw001',8,'as','2003-6-11','2003-6-30',1,2,'')
Insert Into XS_ThreadAction( TA_ID,own_id,XT_ID,TA_Subject,TA_StartDate,TA_EndDate,TA_Sort,TA_ExecEmp,TA_Desc ) Values(2,'fw001',9,'sdfsd','2003-6-17','2003-6-30',1,2,'')
GO

Insert Into XT_Approve( emp_id,doc_type ) Values(1,'CONT')
Insert Into XT_Approve( emp_id,doc_type ) Values(1,'QP')
Insert Into XT_Approve( emp_id,doc_type ) Values(1,'SO')
Insert Into XT_Approve( emp_id,doc_type ) Values(2,'CONT')
Insert Into XT_Approve( emp_id,doc_type ) Values(2,'QP')
Insert Into XT_Approve( emp_id,doc_type ) Values(2,'SO')
Insert Into XT_Approve( emp_id,doc_type ) Values(3,'CONT')
Insert Into XT_Approve( emp_id,doc_type ) Values(3,'QP')
Insert Into XT_Approve( emp_id,doc_type ) Values(3,'SO')
Insert Into XT_Approve( emp_id,doc_type ) Values(5,'SO')
GO

Insert Into XT_Dept( Dept_ID,own_id,Dept_Code,Dept_Name,Dept_levels,Dept_parentid,Dept_path ) Values(2,'fw001','00001','ܹ˾',0,0,'-2-')
Insert Into XT_Dept( Dept_ID,own_id,Dept_Code,Dept_Name,Dept_levels,Dept_parentid,Dept_path ) Values(5,'fw001','cust','ͻ',0,0,'-5-')
Insert Into XT_Dept( Dept_ID,own_id,Dept_Code,Dept_Name,Dept_levels,Dept_parentid,Dept_path ) Values(6,'fw001','gc0001','ݸܳ',0,0,'-6-')
Insert Into XT_Dept( Dept_ID,own_id,Dept_Code,Dept_Name,Dept_levels,Dept_parentid,Dept_path ) Values(9,'fw001','sale','۲',0,0,'-9-')
Insert Into XT_Dept( Dept_ID,own_id,Dept_Code,Dept_Name,Dept_levels,Dept_parentid,Dept_path ) Values(10,'fw001','bj','۴',1,9,'-9-9-')
Insert Into XT_Dept( Dept_ID,own_id,Dept_Code,Dept_Name,Dept_levels,Dept_parentid,Dept_path ) Values(11,'fw001','sh','Ϻ۴',1,9,'-9-11-')
Insert Into XT_Dept( Dept_ID,own_id,Dept_Code,Dept_Name,Dept_levels,Dept_parentid,Dept_path ) Values(12,'fw001','cd','۴',1,9,'-9-12-')
Insert Into XT_Dept( Dept_ID,own_id,Dept_Code,Dept_Name,Dept_levels,Dept_parentid,Dept_path ) Values(13,'fw001','0001','Ϻֹ˾',1,2,'-2-13-')
Insert Into XT_Dept( Dept_ID,own_id,Dept_Code,Dept_Name,Dept_levels,Dept_parentid,Dept_path ) Values(14,'fw001','0002','ݷֹ˾',1,2,'-2-14-')
Insert Into XT_Dept( Dept_ID,own_id,Dept_Code,Dept_Name,Dept_levels,Dept_parentid,Dept_path ) Values(15,'fw001','0003','人ֹ˾',1,2,'-2-15-')
Insert Into XT_Dept( Dept_ID,own_id,Dept_Code,Dept_Name,Dept_levels,Dept_parentid,Dept_path ) Values(16,'fw001','000001','ڷֳ',1,6,'-6-16-')
Insert Into XT_Dept( Dept_ID,own_id,Dept_Code,Dept_Name,Dept_levels,Dept_parentid,Dept_path ) Values(17,'fw001','0000002','ൺֳ',1,6,'-6-17-')
Insert Into XT_Dept( Dept_ID,own_id,Dept_Code,Dept_Name,Dept_levels,Dept_parentid,Dept_path ) Values(18,'fw001','wh','人۴',1,9,'-9-18-')
Insert Into XT_Dept( Dept_ID,own_id,Dept_Code,Dept_Name,Dept_levels,Dept_parentid,Dept_path ) Values(19,'fw001','sz','۴',1,9,'-9-19-')
Insert Into XT_Dept( Dept_ID,own_id,Dept_Code,Dept_Name,Dept_levels,Dept_parentid,Dept_path ) Values(20,'fw001','qd','ൺ۴',1,9,'-9-20-')
Insert Into XT_Dept( Dept_ID,own_id,Dept_Code,Dept_Name,Dept_levels,Dept_parentid,Dept_path ) Values(21,'fw001','000003','ƹϢ',0,0,'-21-')
GO

Insert Into XT_Employee( Emp_ID,own_id,Emp_Code,Emp_Name,Emp_IdCard,Emp_Sex,Emp_Birthday,Emp_Native,Emp_Education,Dept_ID,Emp_Title,Emp_Ophone,Emp_Mobile,Emp_Hphone,Emp_Email,Emp_Role,Emp_Addr,Emp_Forbid,Emp_Picture,Emp_Memo ) Values(1,'Fw001','emp0003','','450104197011204563','','1970-11-20','','',11,'гҵԱ','020-12345678','013923261554','021-85642317','zhang@fuwise.com','2','','0',Null,'')
Insert Into XT_Employee( Emp_ID,own_id,Emp_Code,Emp_Name,Emp_IdCard,Emp_Sex,Emp_Birthday,Emp_Native,Emp_Education,Dept_ID,Emp_Title,Emp_Ophone,Emp_Mobile,Emp_Hphone,Emp_Email,Emp_Role,Emp_Addr,Emp_Forbid,Emp_Picture,Emp_Memo ) Values(2,'Fw001','emp0002','','','','','','',13,'гҵԱ','','','','','4','','0',Null,'')
Insert Into XT_Employee( Emp_ID,own_id,Emp_Code,Emp_Name,Emp_IdCard,Emp_Sex,Emp_Birthday,Emp_Native,Emp_Education,Dept_ID,Emp_Title,Emp_Ophone,Emp_Mobile,Emp_Hphone,Emp_Email,Emp_Role,Emp_Addr,Emp_Forbid,Emp_Picture,Emp_Memo ) Values(3,'Fw001','emp0001','Ž','246010819650103789','','1965-1-3','','',13,'гܼ','020-12345678','','','coo@yahoo.com','1','','0',Null,'')
Insert Into XT_Employee( Emp_ID,own_id,Emp_Code,Emp_Name,Emp_IdCard,Emp_Sex,Emp_Birthday,Emp_Native,Emp_Education,Dept_ID,Emp_Title,Emp_Ophone,Emp_Mobile,Emp_Hphone,Emp_Email,Emp_Role,Emp_Addr,Emp_Forbid,Emp_Picture,Emp_Memo ) Values(5,'fw001','emp0006','','','','2001-10-2','Hong Kong','',6,'Actor','020-85695694','123456','020-23569887','zhouxx@sina.com','4','Hong&nbsp;Kong','0',Null,'test''<aaa>')
Insert Into XT_Employee( Emp_ID,own_id,Emp_Code,Emp_Name,Emp_IdCard,Emp_Sex,Emp_Birthday,Emp_Native,Emp_Education,Dept_ID,Emp_Title,Emp_Ophone,Emp_Mobile,Emp_Hphone,Emp_Email,Emp_Role,Emp_Addr,Emp_Forbid,Emp_Picture,Emp_Memo ) Values(10,'fw001','emp0005','Դ','','Ů','','','',13,'','020-85679471','','020-85698725','','2','','0',Null,'')
Insert Into XT_Employee( Emp_ID,own_id,Emp_Code,Emp_Name,Emp_IdCard,Emp_Sex,Emp_Birthday,Emp_Native,Emp_Education,Dept_ID,Emp_Title,Emp_Ophone,Emp_Mobile,Emp_Hphone,Emp_Email,Emp_Role,Emp_Addr,Emp_Forbid,Emp_Picture,Emp_Memo ) Values(12,'fw001','emp0007','ϼ','','','','','',15,'','020-85648221','','','','4','','0',Null,'')
Insert Into XT_Employee( Emp_ID,own_id,Emp_Code,Emp_Name,Emp_IdCard,Emp_Sex,Emp_Birthday,Emp_Native,Emp_Education,Dept_ID,Emp_Title,Emp_Ophone,Emp_Mobile,Emp_Hphone,Emp_Email,Emp_Role,Emp_Addr,Emp_Forbid,Emp_Picture,Emp_Memo ) Values(13,'fw001','emp0008','ų','','','','','',13,'','','','','','4','','0',Null,'')
Insert Into XT_Employee( Emp_ID,own_id,Emp_Code,Emp_Name,Emp_IdCard,Emp_Sex,Emp_Birthday,Emp_Native,Emp_Education,Dept_ID,Emp_Title,Emp_Ophone,Emp_Mobile,Emp_Hphone,Emp_Email,Emp_Role,Emp_Addr,Emp_Forbid,Emp_Picture,Emp_Memo ) Values(14,'fw001','emp0009','','','','','','',13,'','020-84523698','','','','5','','0',Null,'')
Insert Into XT_Employee( Emp_ID,own_id,Emp_Code,Emp_Name,Emp_IdCard,Emp_Sex,Emp_Birthday,Emp_Native,Emp_Education,Dept_ID,Emp_Title,Emp_Ophone,Emp_Mobile,Emp_Hphone,Emp_Email,Emp_Role,Emp_Addr,Emp_Forbid,Emp_Picture,Emp_Memo ) Values(15,'fw001','emp0010','Ԭ','','','','','',2,'','020-85629554','','','yuanb@yahoo.com','4','','1',3,'')
Insert Into XT_Employee( Emp_ID,own_id,Emp_Code,Emp_Name,Emp_IdCard,Emp_Sex,Emp_Birthday,Emp_Native,Emp_Education,Dept_ID,Emp_Title,Emp_Ophone,Emp_Mobile,Emp_Hphone,Emp_Email,Emp_Role,Emp_Addr,Emp_Forbid,Emp_Picture,Emp_Memo ) Values(16,'Fw001','emp0011','','480504196004051233','','1960-4-5','','',20,'CEO','020-12345678','','','ceo@sdiye.com','4','','0',Null,'')
Insert Into XT_Employee( Emp_ID,own_id,Emp_Code,Emp_Name,Emp_IdCard,Emp_Sex,Emp_Birthday,Emp_Native,Emp_Education,Dept_ID,Emp_Title,Emp_Ophone,Emp_Mobile,Emp_Hphone,Emp_Email,Emp_Role,Emp_Addr,Emp_Forbid,Emp_Picture,Emp_Memo ) Values(17,'fw001','emp0000','Ա','','','','㶫','˶ʿ',2,'','020-87589585','13825684321','020-85469871','webmaster@micso.com','5','','0',13,'')
GO

Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(1,'JC','','JC',1,0,0,'1','1','0','0')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(2,'JC','ͻ','JC',2,1,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(3,'JC','','JC',3,1,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(4,'JC','','JC',4,1,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(5,'JC','г','JC',5,1,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(6,'JC','','JC',6,1,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(7,'JC','','JC',7,1,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(8,'JC','','JC',8,1,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(9,'JC','','JC',9,1,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(10,'JC','ն','JC',10,1,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(11,'JB','Ϣ','JB',1,0,0,'1','1','0','0')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(12,'JB','ͻ','JB',2,11,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(13,'JB','ͻ','JB',3,11,1,'0','1','1','0')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(14,'JB','ϵ','JB',4,11,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(15,'JB','','JB',5,11,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(16,'JB','Ʒ','JB',6,11,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(17,'JB','ƷϢ','JB',7,11,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(18,'XS','۹','XS',1,0,0,'1','1','0','0')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(19,'XS','ճ̰','XS',2,18,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(20,'XS','','XS',3,18,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(21,'XS','ۻ','XS',4,18,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(22,'XS','','XS',5,18,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(23,'XS','۽','XS',6,18,1,'0','1','1','0')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(24,'XS','߷','XS',7,18,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(25,'XS','Ǩʱ','XS',8,18,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(26,'XS','ɸ','XS',9,18,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(27,'XS','۵','XS',10,18,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(28,'XS','۶','XS',11,18,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(29,'KH','','KH',1,0,0,'1','1','0','0')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(30,'KH','ͻ','KH',2,29,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(31,'KH','','KH',3,29,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(32,'KH','','KH',4,29,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(33,'KH','ػ','KH',5,29,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(34,'KH','ػ','KH',6,29,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(35,'KH','ػ','KH',7,29,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(36,'KH','رػ','KH',8,29,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(37,'SC','г','SC',1,0,0,'1','1','0','0')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(38,'SC','гĿ','SC',2,37,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(39,'SC','г','SC',3,37,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(40,'SC','ʼ','SC',4,37,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(41,'SJ','','SJ',1,0,0,'1','1','0','0')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(42,'SJ','','SJ',2,41,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(43,'SJ','¼','SJ',3,41,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(44,'SJ','¼','SJ',4,41,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(45,'ZS','֪ʶ','ZS',1,0,0,'1','1','0','0')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(46,'ZS','ĵ','ZS',2,45,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(47,'ZS','ĵ','ZS',3,45,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(48,'ZS','֪ʶ','ZS',4,45,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(49,'ZS','֪ʶ','ZS',5,45,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(50,'FX','','FX',1,0,0,'1','1','0','0')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(51,'FX','۷','FX',2,50,1,'0','1','0','0')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(52,'FX','','FX',3,50,1,'0','1','0','0')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(53,'FX','÷','FX',4,50,1,'0','1','0','0')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(54,'FX','г','FX',5,50,1,'0','1','0','0')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(55,'FX','ͻ','FX',6,50,1,'0','1','0','0')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(56,'FX','Ա','FX',7,50,1,'0','1','0','0')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(57,'FX','Ʒ','FX',8,50,1,'0','1','0','0')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(58,'FX','ͬ','FX',9,512,1,'0','1','0','0')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(59,'XT','ϵͳ','XT',1,0,0,'1','1','0','0')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(60,'XT','˾Ϣ','XT',2,59,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(61,'XT','','XT',3,59,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(62,'XT','ְԱ','XT',4,59,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(63,'XT','ɫ','XT',5,59,1,'0','1','1','1')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(64,'XT','Ȩ','XT',6,59,1,'0','1','1','0')
Insert Into XT_Module( mod_id,mod_code,mod_name,mod_type,mod_seq,mod_parent,mod_level,mod_HaveSub,mod_read,mod_edit,mod_delete ) Values(65,'XT','־','XT',7,59,1,'0','1','1','1')
GO

Insert Into XT_Role( role_id,own_id,role_name,role_right,role_desc,role_customer,role_contact,role_oppt,role_act,role_qp,role_so,role_service,role_care,role_market,role_meeting,role_train,role_cont,role_calendar,role_email,role_event ) Values(1,'fw001','ܾ','1333333333132333313333233331131333111133131331333311111111111333323','','3','3','3','3','3','3','3','3','3','1',' ','1','1','1','1')
Insert Into XT_Role( role_id,own_id,role_name,role_right,role_desc,role_customer,role_contact,role_oppt,role_act,role_qp,role_so,role_service,role_care,role_market,role_meeting,role_train,role_cont,role_calendar,role_email,role_event ) Values(2,'fw001','ܼ','13333333331323333133332333331313333113331311133331111111111333323','','3','3','3','3','3',' ','3','3','3','3',' ','3','3','3','3')
Insert Into XT_Role( role_id,own_id,role_name,role_right,role_desc,role_customer,role_contact,role_oppt,role_act,role_qp,role_so,role_service,role_care,role_market,role_meeting,role_train,role_cont,role_calendar,role_email,role_event ) Values(3,'fw001','۾','13333333331323333100030333111313331111331313111131111111110000000','','2','2','2','1','1','2','2','2','2','1',' ','1','1','1','3')
Insert Into XT_Role( role_id,own_id,role_name,role_right,role_desc,role_customer,role_contact,role_oppt,role_act,role_qp,role_so,role_service,role_care,role_market,role_meeting,role_train,role_cont,role_calendar,role_email,role_event ) Values(4,'fw001','ҵԱ','0000000000120222210002022211121222111133131220000000000000000000000','','1','1','1','1','1','1','1','1','1','1',' ','1','1','1','1')
Insert Into XT_Role( role_id,own_id,role_name,role_right,role_desc,role_customer,role_contact,role_oppt,role_act,role_qp,role_so,role_service,role_care,role_market,role_meeting,role_train,role_cont,role_calendar,role_email,role_event ) Values(5,'fw001','ϵͳԱ','13333333330000000000000000000000000000000000000000000000001333323','Administrator Group','3','3','3','3','3','3','3','3','3','1',' ','1','1','1','1')
GO

Insert Into ZS_DocInfo( DI_ID,own_Id,DI_Code,DI_subject,DI_content,DT_ID,DI_FileName,DI_FilePath ) Values(3,'fw001','FW-SR-20021024-0003','r','sdf',1,'21-readme.txt','')
Insert Into ZS_DocInfo( DI_ID,own_Id,DI_Code,DI_subject,DI_content,DT_ID,DI_FileName,DI_FilePath ) Values(4,'fw001','FW-SR-20021024-0006','ert','erert',3,'4-readme.txt','')
GO

Insert Into ZS_DocType( DT_ID,own_id,DT_Code,DT_Name,DT_levels,DT_parentid,DT_path ) Values(1,'fw001','001','׼ƶ',0,0,'-1-')
Insert Into ZS_DocType( DT_ID,own_id,DT_Code,DT_Name,DT_levels,DT_parentid,DT_path ) Values(2,'fw001','002','׼ƶ',0,0,'-2-')
Insert Into ZS_DocType( DT_ID,own_id,DT_Code,DT_Name,DT_levels,DT_parentid,DT_path ) Values(3,'fw001','003','׼ƶ',0,0,'-3-')
Insert Into ZS_DocType( DT_ID,own_id,DT_Code,DT_Name,DT_levels,DT_parentid,DT_path ) Values(4,'fw001','asD','dasfFS',1,1,'-1-4-')
GO

Insert Into ZS_KnowInfo( KI_ID,own_Id,KI_Code,KI_subject,KI_content,KT_ID,KI_FileName,KI_FilePath ) Values(6,'fw001','FW-SR-20021024-0012','cvz','xzxc',1,'6k-װ˵.txt','')
Insert Into ZS_KnowInfo( KI_ID,own_Id,KI_Code,KI_subject,KI_content,KT_ID,KI_FileName,KI_FilePath ) Values(7,'fw001','FW-SR-20021024-0013','ccvc','xcv',1,'7k-readme.txt','')
Insert Into ZS_KnowInfo( KI_ID,own_Id,KI_Code,KI_subject,KI_content,KT_ID,KI_FileName,KI_FilePath ) Values(8,'fw001','FW-SR-20021217-0001','sdfds','sdf',2,'8k-Book1.xls','')
Insert Into ZS_KnowInfo( KI_ID,own_Id,KI_Code,KI_subject,KI_content,KT_ID,KI_FileName,KI_FilePath ) Values(9,'fw001','FW-SR-20021217-0002','hcvncv','cncn',1,'9k-ҵά.doc','')
Insert Into ZS_KnowInfo( KI_ID,own_Id,KI_Code,KI_subject,KI_content,KT_ID,KI_FileName,KI_FilePath ) Values(10,'fw001','FW-SR-20021217-0003','bcxvb','cxbx',3,'10k-ҵά.doc','')
GO

Insert Into ZS_KnowType( KT_ID,own_id,KT_Code,KT_Name,KT_levels,KT_parentid,KT_path ) Values(1,'fw001','001','ýѯ',0,0,'-1-')
Insert Into ZS_KnowType( KT_ID,own_id,KT_Code,KT_Name,KT_levels,KT_parentid,KT_path ) Values(2,'fw001','002','гѯ',0,0,'-2-')
Insert Into ZS_KnowType( KT_ID,own_id,KT_Code,KT_Name,KT_levels,KT_parentid,KT_path ) Values(3,'fw001','003','ҵ',0,0,'-3-')
Insert Into ZS_KnowType( KT_ID,own_id,KT_Code,KT_Name,KT_levels,KT_parentid,KT_path ) Values(4,'fw001','004','ķ',0,0,'-4-')
Insert Into ZS_KnowType( KT_ID,own_id,KT_Code,KT_Name,KT_levels,KT_parentid,KT_path ) Values(5,'fw001','005','',0,0,'-5-')
Insert Into ZS_KnowType( KT_ID,own_id,KT_Code,KT_Name,KT_levels,KT_parentid,KT_path ) Values(6,'fw001','006','߻',0,0,'-6-')
GO
