# 2.1 升级指南

- 2.1 版本主要增加了底层驱动 [hyperf/engine](https://github.com/hyperf/engine)，允许 `Hyperf` 框架跑在 `Swoole` 或 `Swow` 之上。
- PHP 最低版本由 7.2 修改为 7.3

> Swow 暂为预览版本，请谨慎使用。

## 修改 Hyperf 组件版本

直接将 `composer.json` 中的 `hyperf/*` 统一修改为 `2.1.*` 即可。

```json
{
    "require": {
        "php": ">=7.3",
        "ext-json": "*",
        "ext-openssl": "*",
        "ext-pdo": "*",
        "ext-pdo_mysql": "*",
        "ext-redis": "*",
        "ext-swoole": ">=4.5",
        "hyperf/async-queue": "2.1.*",
        "hyperf/cache": "2.1.*",
        "hyperf/command": "2.1.*",
        "hyperf/config": "2.1.*",
        "hyperf/constants": "2.1.*",
        "hyperf/contract": "2.1.*",
        "hyperf/database": "2.1.*",
        "hyperf/db-connection": "2.1.*",
        "hyperf/di": "2.1.*",
        "hyperf/dispatcher": "2.1.*",
        "hyperf/event": "2.1.*",
        "hyperf/exception-handler": "2.1.*",
        "hyperf/framework": "2.1.*",
        "hyperf/guzzle": "2.1.*",
        "hyperf/http-server": "2.1.*",
        "hyperf/logger": "2.1.*",
        "hyperf/model-cache": "2.1.*",
        "hyperf/pool": "2.1.*",
        "hyperf/process": "2.1.*",
        "hyperf/redis": "2.1.*",
        "hyperf/server": "2.1.*",
        "hyperf/utils": "2.1.*"
    },
    "require-dev": {
        "friendsofphp/php-cs-fixer": "^2.14",
        "hyperf/devtool": "2.1.*",
        "hyperf/testing": "2.1.*",
        "mockery/mockery": "^1.0",
        "phpstan/phpstan": "^0.12.18",
        "swoole/ide-helper": "dev-master",
        "symfony/var-dumper": "^5.1"
    }
}
```

后面只需要执行 `composer update -o`，就可以正常完成升级了。

## 增加 optimize-autoloader 配置

因为 `Hyperf` 自从 `2.0` 开始，需要使用到 `composer` 生成的 `class_map`，这就要求用户每次更新依赖都要使用 `-o` 进行优化，但很多用户从来没有这个习惯。
于是我们建议在 `composer.json` 中增加对应配置，以满足这个需要。

```json
{
    "config": {
        "optimize-autoloader": true,
        "sort-packages": true
    }
}
```

## 修改 SwooleEvent

类 `Hyperf\Server\SwooleEvent` 在 `2.1` 中已经更名为 `Hyperf\Server\Event`，所以我们需要在 `server.php` 配置中修改对应代码。

> SwooleEvent 会在 3.0 中正式被移除，请尽快修改为 Event

```php
<?php

declare(strict_types=1);

use Hyperf\Server\Event;
use Hyperf\Server\Server;

return [
    'mode' => SWOOLE_BASE,
    'servers' => [
        [
            'name' => 'http',
            'type' => Server::SERVER_HTTP,
            'host' => '0.0.0.0',
            'port' => 9501,
            'sock_type' => SWOOLE_SOCK_TCP,
            'callbacks' => [
                Event::ON_REQUEST => [Hyperf\HttpServer\Server::class, 'onRequest'],
            ],
        ],
    ],
    'callbacks' => [
        Event::ON_BEFORE_START => [Hyperf\Framework\Bootstrap\ServerStartCallback::class, 'beforeStart'],
        Event::ON_WORKER_START => [Hyperf\Framework\Bootstrap\WorkerStartCallback::class, 'onWorkerStart'],
        Event::ON_PIPE_MESSAGE => [Hyperf\Framework\Bootstrap\PipeMessageCallback::class, 'onPipeMessage'],
        Event::ON_WORKER_EXIT => [Hyperf\Framework\Bootstrap\WorkerExitCallback::class, 'onWorkerExit'],
    ],
];
```

## 分页器

因为组件 `hyperf/paginator` 已从 `hyperf/database` 依赖中移除。所以在 database 中使用到分页器的同学，还需要额外引入 `hyperf/paginator` 组件。

## 修改 DBAL 版本

倘若使用了 `doctrine/dbal` 组件，则需要升级到 `^3.0` 版本。

## 移除组件 doctrine/common

`doctrine/common` 组件与 `hyperf/utils` 存在依赖冲突。故需要从 `composer.json` 中移除此组件。

```bash
# 移除组件
composer remove doctrine/common
# 更新
composer update "hyperf/*" -o
```

## 注意事项

- 尽量不要将老项目的引擎修改为 Swow，如果想要使用 Swow，请尽量在新项目中尝试。因为 Swow 并不是 Swoole 的替代品，所以并不是所有 Swoole 的场景，都能在 Swow 中找到对应的替代方案。
