# 程式設計須知

這裡收集各種通過 Hyperf 程式設計前應該知曉的知識點或內容點。

## 不能通過全域性變數獲取屬性引數

在 `PHP-FPM` 下可以通過全域性變數獲取到請求的引數，伺服器的引數等，在 `Hyperf` 和 `Swoole` 內，都 **無法** 通過 `$_GET/$_POST/$_REQUEST/$_SESSION/$_COOKIE/$_SERVER`等`$_`開頭的變數獲取到任何屬性引數。

## 通過容器獲取的類都是單例

通過依賴注入容器獲取的都是程序內持久化的，是多個協程共享的，所以不能包含任何的請求唯一的資料或協程唯一的資料，這型別的資料都通過協程上下文去處理，具體請仔細閱讀 [依賴注入](zh-tw/di.md) 和 [協程](zh-tw/coroutine.md) 章節。

## 專案部署

> 官方的 Dockerfile 已經完成了以下操作。

線上程式碼部署時，請務必開啟 `scan_cacheable`。

開啟此配置後，首次掃描時會生成代理類和註解快取，再次啟動時，則可以直接使用快取，極大優化記憶體使用率和啟動速度。因為跳過了掃描階段，所以會依賴 `Composer Class Map`，故我們必須要執行 `--optimize-autoloader` 優化索引。

綜上，線上更新程式碼，重啟專案前，需要執行以下命令

```bash
# 優化 Composer 索引
composer dump-autoload -o
# 生成代理類和註解快取
php bin/hyperf.php
```
