# 2.1 升級指南

- 2.1 版本主要增加了底層驅動 [hyperf/engine](https://github.com/hyperf/engine)，允許 `Hyperf` 框架跑在 `Swoole` 或 `Swow` 之上。
- PHP 最低版本由 7.2 修改為 7.3

> Swow 暫為預覽版本，請謹慎使用。

## 修改 Hyperf 元件版本

直接將 `composer.json` 中的 `hyperf/*` 統一修改為 `2.1.*` 即可。

```json
{
    "require": {
        "php": ">=7.3",
        "ext-json": "*",
        "ext-openssl": "*",
        "ext-pdo": "*",
        "ext-pdo_mysql": "*",
        "ext-redis": "*",
        "ext-swoole": ">=4.5",
        "hyperf/async-queue": "2.1.*",
        "hyperf/cache": "2.1.*",
        "hyperf/command": "2.1.*",
        "hyperf/config": "2.1.*",
        "hyperf/constants": "2.1.*",
        "hyperf/contract": "2.1.*",
        "hyperf/database": "2.1.*",
        "hyperf/db-connection": "2.1.*",
        "hyperf/di": "2.1.*",
        "hyperf/dispatcher": "2.1.*",
        "hyperf/event": "2.1.*",
        "hyperf/exception-handler": "2.1.*",
        "hyperf/framework": "2.1.*",
        "hyperf/guzzle": "2.1.*",
        "hyperf/http-server": "2.1.*",
        "hyperf/logger": "2.1.*",
        "hyperf/model-cache": "2.1.*",
        "hyperf/pool": "2.1.*",
        "hyperf/process": "2.1.*",
        "hyperf/redis": "2.1.*",
        "hyperf/server": "2.1.*",
        "hyperf/utils": "2.1.*"
    },
    "require-dev": {
        "friendsofphp/php-cs-fixer": "^2.14",
        "hyperf/devtool": "2.1.*",
        "hyperf/testing": "2.1.*",
        "mockery/mockery": "^1.0",
        "phpstan/phpstan": "^0.12.18",
        "swoole/ide-helper": "dev-master",
        "symfony/var-dumper": "^5.1"
    }
}
```

後面只需要執行 `composer update -o`，就可以正常完成升級了。

## 增加 optimize-autoloader 配置

因為 `Hyperf` 自從 `2.0` 開始，需要使用到 `composer` 生成的 `class_map`，這就要求使用者每次更新依賴都要使用 `-o` 進行優化，但很多使用者從來沒有這個習慣。
於是我們建議在 `composer.json` 中增加對應配置，以滿足這個需要。

```json
{
    "config": {
        "optimize-autoloader": true,
        "sort-packages": true
    }
}
```

## 修改 SwooleEvent

類 `Hyperf\Server\SwooleEvent` 在 `2.1` 中已經更名為 `Hyperf\Server\Event`，所以我們需要在 `server.php` 配置中修改對應程式碼。

> SwooleEvent 會在 3.0 中正式被移除，請儘快修改為 Event

```php
<?php

declare(strict_types=1);

use Hyperf\Server\Event;
use Hyperf\Server\Server;

return [
    'mode' => SWOOLE_BASE,
    'servers' => [
        [
            'name' => 'http',
            'type' => Server::SERVER_HTTP,
            'host' => '0.0.0.0',
            'port' => 9501,
            'sock_type' => SWOOLE_SOCK_TCP,
            'callbacks' => [
                Event::ON_REQUEST => [Hyperf\HttpServer\Server::class, 'onRequest'],
            ],
        ],
    ],
    'callbacks' => [
        Event::ON_BEFORE_START => [Hyperf\Framework\Bootstrap\ServerStartCallback::class, 'beforeStart'],
        Event::ON_WORKER_START => [Hyperf\Framework\Bootstrap\WorkerStartCallback::class, 'onWorkerStart'],
        Event::ON_PIPE_MESSAGE => [Hyperf\Framework\Bootstrap\PipeMessageCallback::class, 'onPipeMessage'],
        Event::ON_WORKER_EXIT => [Hyperf\Framework\Bootstrap\WorkerExitCallback::class, 'onWorkerExit'],
    ],
];
```

## 分頁器

因為元件 `hyperf/paginator` 已從 `hyperf/database` 依賴中移除。所以在 database 中使用到分頁器的同學，還需要額外引入 `hyperf/paginator` 元件。

## 修改 DBAL 版本

倘若使用了 `doctrine/dbal` 元件，則需要升級到 `^3.0` 版本。

## 移除元件 doctrine/common

`doctrine/common` 元件與 `hyperf/utils` 存在依賴衝突。故需要從 `composer.json` 中移除此元件。

```bash
# 移除元件
composer remove doctrine/common
# 更新
composer update "hyperf/*" -o
```

## 注意事項

- 儘量不要將老專案的引擎修改為 Swow，如果想要使用 Swow，請儘量在新專案中嘗試。因為 Swow 並不是 Swoole 的替代品，所以並不是所有 Swoole 的場景，都能在 Swow 中找到對應的替代方案。
