# 版本說明

## 版本規則

Hyperf 採用 x.y.z 的版本號規則來命名各個版本，如 1.2.3 版本，1 即為 x，2 即為 y，3 即為 z，您可以根據該版本規則來制定您對 Hyperf 框架的更新計劃。
- x 表示一個重大版本，當 Hyperf 的核心進行大量的重構變動時，或當存在大量的破壞性 API 變更時，會作為一個 x 版本釋出，x 版本變更通常來說是無法與之前的 x 版本相容，但也不一定代表完全無法相容，具體根據對應版本的升級指南來進行甄別。
- y 表示一個主要功能迭代版本，當一些公開的 API 進行了破壞性的變更後，包括公開 API 的變更和刪除，導致前置版本可能無法相容的時候，會以 y 版本來進行釋出。
- z 表示一個完全相容的修復版本，當對各個元件的已有功能進行 BUG 修復或安全修復時，會選擇以一個 z 版本來發布，當一個 BUG 導致了某個功能完全無法使用時，亦可能在 z 版本內修復這個 BUG 時對 API 進行破壞性變更，但由於功能此前已經完全無法使用故此類變更不會以 y 版本來發布，除了 BUG 修復，z 版本也可能會包括一些新增的功能或元件，這些功能和元件均不會影響此前的程式碼使用。

## 升級版本

當您希望升級 Hyperf 版本時，如果是對 x 和 y 版本的升級，請根據文件內對應版本的升級指南來進行操作。如您希望對 z 版本進行升級，可直接在您的專案的根目錄執行 `composer update hyperf` 命令來對依賴包進行更新，我們不建議您單獨升級某一個元件的版本，而是統一升級所有元件來獲得更加一致的體驗。