#include-once
#include <APIConstants.au3>
#include <GUIConstantsEx.au3>
#include <WinAPIEx.au3>

Global $__MsgPopup[5][3] = [[4, 3, 0], _
		[-1, -1, -1], _ ; Previous GUI
		[-1, -1, -1], _ ; GUIMsgPopup
		[-1, -1, ""], _ ; ControlID
		[-1, -1, ""]] ; Taskbar Animation

#cs
	Opt("TrayMenuMode", 3)

	#include <Constants.au3>
	Global $aArray, $iHidden = 0

	$aArray = _MsgPopup_Create(-1, @SystemDir & "\user32.dll", -4, "Example", 330, 50, 2)
	_MsgPopup_Show(0)

	While 1
	Switch GUIGetMsg()
	Case $aArray[1]
	ExitLoop
	EndSwitch

	Switch TrayGetMsg()
	Case $TRAY_EVENT_PRIMARYDOUBLE
	Switch $iHidden
	Case 0
	_MsgPopup_Hide()
	$iHidden = 1
	Case 1
	_MsgPopup_Show()
	$iHidden = 0
	EndSwitch
	EndSwitch
	WEnd
	_MsgPopup_Close()
#ce

Func _MsgPopup_Close()
	_MsgPopup_Delete(1)
EndFunc   ;==>_MsgPopup_Close

Func _MsgPopup_Create($hHandle, $sIcon, $iIcon, $sData, $iWidth = 270, $iHeight = 150, $iWait = 1, $iTime = 3.5)
	Local $aLocation, $aReturn[5] = ["-GUIHandle", "-CrossControlID", "-AnimationSlideIn", "-AnimationSlideOut", "-IconControlID"], $bColor = 0x000000, $hGUI, $iBegin, $iExit, $iLabel, $iLeft = 5

	_MsgPopup_Close()

	If $hHandle = -1 Then
		$iLabel = GUICtrlCreateLabel("", -99, -99, 1, 1)
		$hHandle = _WinAPI_GetParent(GUICtrlGetHandle($iLabel))
		If @error Or $hHandle = 0 Then
			$hHandle = WinGetHandle(AutoItWinGetTitle())
		EndIf
		GUICtrlDelete($iLabel)
	EndIf

	$aLocation = _MsgPopup_Location($iWidth, $iHeight)

	$hGUI = GUICreate("", $iWidth, $iHeight, $aLocation[0], $aLocation[1], $WS_POPUPWINDOW, BitOR($WS_EX_TOOLWINDOW, $WS_EX_TOPMOST), $hHandle)
	$iExit = _MsgPopup_Cross($iWidth, $bColor)

	$__MsgPopup[1][0] = $hHandle
	$__MsgPopup[2][0] = $hGUI
	$__MsgPopup[2][1] = $iWidth
	$__MsgPopup[2][2] = $iHeight
	$__MsgPopup[3][0] = $iExit
	$__MsgPopup[3][1] = $bColor
	$__MsgPopup[4][0] = $aLocation[2]
	$__MsgPopup[4][1] = $aLocation[3]

	$aReturn[0] = $hGUI
	$aReturn[1] = $iExit
	$aReturn[2] = $aLocation[2]
	$aReturn[3] = $aLocation[3]
	$aReturn[4] = -1

	If $sIcon <> "" Then
		$aReturn[4] = GUICtrlCreateIcon($sIcon, $iIcon, 5, 5, 32, 32)
		$iLeft = 45
	EndIf

	If $iWait = 2 Then
		AdlibRegister("_MsgPopup_Monitor", 100)
		Return $aReturn
	EndIf

	If $sData <> "" Then
		GUICtrlCreateLabel($sData, $iLeft, 5, $iWidth - 70, $iHeight - 10)
		GUICtrlSetFont(-1, 9)
		GUICtrlSetBkColor(-1, $GUI_BKCOLOR_TRANSPARENT)
	EndIf

	_MsgPopup_Show(0)

	$iTime *= 1000
	If $iWait = 0 Then
		GUIRegisterMsg($WM_MOUSEACTIVATE, "_MsgPopup_WM_MOUSEACTIVATE")
		AdlibRegister("_MsgPopup_Monitor", 100)
		AdlibRegister("_MsgPopup_Timer", $iTime)
		Return $hGUI
	EndIf

	_WinAPI_EmptyWorkingSet()
	$iBegin = TimerInit()
	While 1
		_MsgPopup_ExitMonitor($hGUI, $iExit, $bColor)

		If TimerDiff($iBegin) > $iTime Then
			ExitLoop
		EndIf

		Switch GUIGetMsg()
			Case $GUI_EVENT_CLOSE, $iExit
				ExitLoop

		EndSwitch
	WEnd
	_MsgPopup_Close()
EndFunc   ;==>_MsgPopup_Create

Func _MsgPopup_Cross($iWidth, $bColor)
	Local $iLabel, $sFont = "Ms Shell", $sData = "x"
	If FileExists(_WinAPI_ShellGetSpecialFolderPath($CSIDL_FONTS) & "\WebDings.ttf") Then
		$sData = "r"
		$sFont = "WebDings"
	EndIf
	$iLabel = GUICtrlCreateLabel($sData, $iWidth - 20, 0, 15, 15)
	GUICtrlSetFont(-1, 10, Default, Default, $sFont)
	GUICtrlSetBkColor(-1, $GUI_BKCOLOR_TRANSPARENT)
	GUICtrlSetColor(-1, $bColor)
	Return $iLabel
EndFunc   ;==>_MsgPopup_Cross

Func _MsgPopup_Delete($iDelete)
	If $__MsgPopup[2][0] = -1 Then
		Return SetError(1, 0, 0)
	EndIf

	_WinAPI_AnimateWindow($__MsgPopup[2][0], $__MsgPopup[4][1], 250)

	If $iDelete Then
		GUIDelete($__MsgPopup[2][0])
		GUIRegisterMsg($WM_MOUSEACTIVATE, "")
		_MsgPopup_Shutdown()
	EndIf
EndFunc   ;==>_MsgPopup_Delete

Func _MsgPopup_ExitMonitor($hHandle, $iControlID, ByRef $bColor, $bHoverColor = 0xC0C0C0, $bOriginalColor = 0x000000)
	Local $aControlGetPos, $aWinGetPos, $iLeft, $iTop

	$aWinGetPos = WinGetPos($hHandle)
	If @error Then
		Return 0
	EndIf
	$aControlGetPos = ControlGetPos($hHandle, "", $iControlID)
	If @error Then
		Return 0
	EndIf
	$iLeft = $aControlGetPos[0] + $aWinGetPos[0]
	$iTop = $aControlGetPos[1] + $aWinGetPos[1]

	Local $aMouseGetPos = MouseGetPos()
	If ($aMouseGetPos[0] >= $iLeft And $aMouseGetPos[0] <= $iLeft + $aControlGetPos[2]) And ($aMouseGetPos[1] >= $iTop And $aMouseGetPos[1] <= $iTop + $aControlGetPos[3]) Then
		If $bColor = $bOriginalColor Then
			GUICtrlSetColor($iControlID, $bHoverColor)
			$bColor = $bHoverColor
		EndIf
	Else
		If $bColor = $bHoverColor Then
			GUICtrlSetColor($iControlID, $bOriginalColor)
			$bColor = $bOriginalColor
		EndIf
	EndIf
EndFunc   ;==>_MsgPopup_ExitMonitor

Func _MsgPopup_Hide()
	_MsgPopup_Delete(0)
EndFunc   ;==>_MsgPopup_Hide

Func _MsgPopup_Location($iWidth, $iHeight) ; Idea was initially from Melba23 in his Toast UDF, but modifed by guinness.
	Local $aReturn[4] = [-1, -1, BitOR($AW_SLIDE, $AW_VER_NEGATIVE), BitOR($AW_SLIDE, $AW_VER_POSITIVE, $AW_HIDE)], $aState, $aWinGetPos, $ABM_GETSTATE = 0x00000004, $SPI_GETWORKAREA = 0x0030, $tWorkArea

	$aState = DllCall('shell32.dll', 'uint', 'SHAppBarMessage', 'dword', $ABM_GETSTATE, 'ptr*', 0)
	If @error = 0 And BitAND($aState[0], 0x01) Then
		$aWinGetPos = WinGetPos("[CLASS:Shell_TrayWnd]")
		If @error Then
			Return SetError(1, 0, $aReturn)
		EndIf

		If $aWinGetPos[1] > 0 Then
			$aReturn[0] = @DesktopWidth - $iWidth - 10
			$aReturn[1] = $aWinGetPos[1] - $iHeight - 2
		ElseIf $aWinGetPos[0] > 0 Then
			$aReturn[0] = $aWinGetPos[0] - $iWidth - 2
			$aReturn[1] = @DesktopHeight - $iHeight - 10
			$aReturn[2] = BitOR($AW_SLIDE, $AW_HOR_NEGATIVE)
			$aReturn[3] = BitOR($AW_SLIDE, $AW_HOR_POSITIVE, $AW_HIDE)
		ElseIf $aWinGetPos[2] >= @DesktopWidth Then
			$aReturn[0] = @DesktopWidth - $iWidth - 10
			$aReturn[1] = $aWinGetPos[1] + $aWinGetPos[3]
			$aReturn[2] = BitOR($AW_SLIDE, $AW_VER_POSITIVE)
			$aReturn[3] = BitOR($AW_SLIDE, $AW_VER_NEGATIVE, $AW_HIDE)
		ElseIf $aWinGetPos[3] >= @DesktopHeight Then
			$aReturn[0] = $aWinGetPos[0] + $aWinGetPos[2]
			$aReturn[1] = @DesktopHeight - $iHeight - 10
			$aReturn[2] = BitOR($AW_SLIDE, $AW_HOR_POSITIVE)
			$aReturn[3] = BitOR($AW_SLIDE, $AW_HOR_NEGATIVE, $AW_HIDE)
		EndIf
	Else
		$tWorkArea = DllStructCreate($tagRECT)
		_WinAPI_SystemParametersInfo($SPI_GETWORKAREA, 0, DllStructGetPtr($tWorkArea))
		If @error Then
			Return SetError(1, 0, $aReturn)
		EndIf
		Local $aWinGetPosEx[4] = [DllStructGetData($tWorkArea, "Left"), DllStructGetData($tWorkArea, "Top"), _
				DllStructGetData($tWorkArea, "Right"), DllStructGetData($tWorkArea, "Bottom")]

		If $aWinGetPosEx[3] <> @DesktopHeight Then
			$aReturn[0] = @DesktopWidth - $iWidth - 10
			$aReturn[1] = $aWinGetPosEx[3] - $iHeight - 2
		ElseIf $aWinGetPosEx[2] <> @DesktopWidth Then
			$aReturn[0] = $aWinGetPosEx[2] - $iWidth - 2
			$aReturn[1] = @DesktopHeight - $iHeight - 10
			$aReturn[2] = BitOR($AW_SLIDE, $AW_HOR_NEGATIVE)
			$aReturn[3] = BitOR($AW_SLIDE, $AW_HOR_POSITIVE, $AW_HIDE)
		ElseIf $aWinGetPosEx[1] <> 0 Then
			$aReturn[0] = @DesktopWidth - $iWidth - 10
			$aReturn[1] = $aWinGetPosEx[1]
			$aReturn[2] = BitOR($AW_SLIDE, $AW_VER_POSITIVE)
			$aReturn[3] = BitOR($AW_SLIDE, $AW_VER_NEGATIVE, $AW_HIDE)
		ElseIf $aWinGetPosEx[0] <> 0 Then
			$aReturn[0] = $aWinGetPosEx[0]
			$aReturn[1] = @DesktopHeight - $iHeight - 10
			$aReturn[2] = BitOR($AW_SLIDE, $AW_HOR_POSITIVE)
			$aReturn[3] = BitOR($AW_SLIDE, $AW_HOR_NEGATIVE, $AW_HIDE)
		EndIf
	EndIf
	Return $aReturn
EndFunc   ;==>_MsgPopup_Location

Func _MsgPopup_Monitor()
	Return _MsgPopup_ExitMonitor($__MsgPopup[2][0], $__MsgPopup[3][0], $__MsgPopup[3][1])
EndFunc   ;==>_MsgPopup_Monitor

Func _MsgPopup_Show($iActivate = 1)
	_WinAPI_AnimateWindow($__MsgPopup[2][0], $__MsgPopup[4][0], 250)
	If $iActivate Then
		GUISetState(@SW_SHOW, $__MsgPopup[2][0])
	Else
		GUISetState(@SW_SHOWNOACTIVATE, $__MsgPopup[2][0])
	EndIf
EndFunc   ;==>_MsgPopup_Show

Func _MsgPopup_Shutdown()
	For $A = 1 To $__MsgPopup[0][0]
		For $B = 0 To $__MsgPopup[0][1] - 1
			$__MsgPopup[$A][$B] = -1
		Next
	Next
EndFunc   ;==>_MsgPopup_Shutdown

Func _MsgPopup_Startup()
	Return _MsgPopup_Shutdown()
EndFunc   ;==>_MsgPopup_Startup

Func _MsgPopup_Timer()
	AdlibUnRegister("_MsgPopup_Monitor")
	AdlibUnRegister("_MsgPopup_Timer")
	_MsgPopup_Close()
EndFunc   ;==>_MsgPopup_Timer

Func _MsgPopup_WM_MOUSEACTIVATE($hWnd, $iMsg, $iwParam, $ilParam)
	#forceref $hWnd, $iMsg, $iwParam, $ilParam
	Local $aGUIGetCursorInfo
	$aGUIGetCursorInfo = GUIGetCursorInfo($__MsgPopup[2][0])
	If @error Then
		Return 0
	EndIf
	If $aGUIGetCursorInfo[4] = $__MsgPopup[3][0] Then
		Return _MsgPopup_Close()
	EndIf
	Return 'GUI_RUNDEFMSG'
EndFunc   ;==>_MsgPopup_WM_MOUSEACTIVATE
