#AutoIt3Wrapper_Au3Check_Parameters=-d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6 -w 7
#cs
	Program Created By:						softwarespot
	Last Textual Changes In This Script:	31st January 2012
	The Program Can Be Run By Selecting: 	<Keyndicate.exe>

	Thanks To The Following...

	Icon -->
	Help --> Thanks to dmg for the original idea as well as creating the key state icons.

	License:
	Display the state of the CapsLock, NumLock and ScrollLock keys.
	Copyright (C) 2012 softwarespot

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.
#ce
#NoTrayIcon

#AutoIt3Wrapper_Icon=Bin\ICON_1.ico
#AutoIt3Wrapper_Outfile=Keyndicate.exe
#AutoIt3Wrapper_UseUpx=Y
#AutoIt3Wrapper_Res_Description=Display the state of the CapsLock, NumLock and ScrollLock keys.
#AutoIt3Wrapper_Res_Fileversion=1.2.3.1
#AutoIt3Wrapper_Res_LegalCopyright=softwarespot (C) 2012
#AutoIt3Wrapper_Res_Language=2057
#AutoIt3Wrapper_Res_Field=Website|
#AutoIt3Wrapper_Res_Field=E-Mail|comment at the website
#AutoIt3Wrapper_UseX64=N
#AutoIt3Wrapper_Run_Obfuscator=Y
#Obfuscator_Parameters=/SF /SV /OM /CS=0 /CN=0
#AutoIt3Wrapper_res_requestedExecutionLevel=asInvoker
#AutoIt3Wrapper_Outfile_Type=exe
#AutoIt3Wrapper_Compile_Both=Y

#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\1\0.ico ; -5 To -12
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\1\1.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\1\2.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\1\3.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\1\12.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\1\13.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\1\23.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\1\123.ico

#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\2\0.ico ; -13 To -20
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\2\1.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\2\2.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\2\3.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\2\12.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\2\13.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\2\23.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\2\123.ico

#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\3\0.ico ; -21 To -28
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\3\1.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\3\2.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\3\3.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\3\12.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\3\13.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\3\23.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\3\123.ico

#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\4\0.ico ; -29 To -36
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\4\1.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\4\2.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\4\3.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\4\12.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\4\13.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\4\23.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\4\123.ico

#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\5\0.ico ; -37 To -44
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\5\1.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\5\2.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\5\3.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\5\12.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\5\13.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\5\23.ico
#AutoIt3Wrapper_Res_Icon_Add=Bin\Icons\5\123.ico

#AutoIt3Wrapper_Res_File_Add=Bin\Flags\br.gif, 10, br
#AutoIt3Wrapper_Res_File_Add=Bin\Flags\cn.gif, 10, cn
#AutoIt3Wrapper_Res_File_Add=Bin\Flags\de.gif, 10, de
#AutoIt3Wrapper_Res_File_Add=Bin\Flags\dk.gif, 10, dk
#AutoIt3Wrapper_Res_File_Add=Bin\Flags\ee.gif, 10, ee
#AutoIt3Wrapper_Res_File_Add=Bin\Flags\es.gif, 10, es
#AutoIt3Wrapper_Res_File_Add=Bin\Flags\fi.gif, 10, fi
#AutoIt3Wrapper_Res_File_Add=Bin\Flags\fr.gif, 10, fr
#AutoIt3Wrapper_Res_File_Add=Bin\Flags\gb.gif, 10, gb
#AutoIt3Wrapper_Res_File_Add=Bin\Flags\hu.gif, 10, hu
#AutoIt3Wrapper_Res_File_Add=Bin\Flags\it.gif, 10, it
#AutoIt3Wrapper_Res_File_Add=Bin\Flags\jp.gif, 10, jp
#AutoIt3Wrapper_Res_File_Add=Bin\Flags\nl.gif, 10, nl
#AutoIt3Wrapper_Res_File_Add=Bin\Flags\no.gif, 10, no
#AutoIt3Wrapper_Res_File_Add=Bin\Flags\pl.gif, 10, pl
#AutoIt3Wrapper_Res_File_Add=Bin\Flags\pt.gif, 10, pt
#AutoIt3Wrapper_Res_File_Add=Bin\Flags\ro.gif, 10, ro
#AutoIt3Wrapper_Res_File_Add=Bin\Flags\rs.gif, 10, rs
#AutoIt3Wrapper_Res_File_Add=Bin\Flags\ru.gif, 10, ru
#AutoIt3Wrapper_Res_File_Add=Bin\Flags\se.gif, 10, se
#AutoIt3Wrapper_Res_File_Add=Bin\Flags\unknown.gif, 10, unknown

#include <EditConstants.au3>
#include <GUIComboBoxEx.au3>
#include <GUIImageList.au3>
#include <Resources.au3>
#include <WinAPIEx.au3> ; Download From http://www.autoitscript.com/forum/topic/98712-winapiex-udf/ by Yashied.

#include "Includes\_Language.au3" ; By softwarespot.
#include "Includes\_MsgPopup.au3" ; By softwarespot.
#include "Includes\_Startup.au3" ; By softwarespot >> http://www.autoitscript.com/forum/topic/124508-startup/

_SetVariables()

Opt("SendCapslockMode", 0)
Opt("TrayMenuMode", 3)

Global $__ComboBoxLanguage, $__LanguageChange = 0, $__ComboBoxIcon, $__IconChange = 0

_SingletonEx("A79BDF4A-3C5F-11E1-8FF7-1A56F46DA8A5")
If @error Then
	Exit
EndIf

OnAutoItExitRegister("_Exit")
_GDIPlus_Startup()
_Main()

Func _Main()
	Local $aMonitor[4][5] = [[3, 5, -1, -2, "-IconName"], _
			[$VK_CAPITAL, 0, 1, "CapsLock", ""], _ ; Key, State, Icon, Name, Text String.
			[$VK_NUMLOCK, 0, 2, "NumLock", ""], _
			[$VK_SCROLL, 0, 3, "ScrollLock", ""]]
	Local $aTrayMenu[6][3] = [[5, 3], _
			["-ID", 'ABOUT', 'About'], _
			["-ID", ''], _
			["-ID", 'FREEZE', 'Freeze'], _
			["-ID", ''], _
			["-ID", 'EXIT', 'Exit']]
	Local $iIsFrozen = 0, $iIsFrozenShown = 0, $iIsRun = 0, $iMsg = 0, $iShowMsg = _Is("ShowMsg", 0), $iWait = _Is("Wait", 2), $sStateString = ""

	For $A = 1 To $aTrayMenu[0][0]
		$aTrayMenu[$A][0] = TrayCreateItem(_GetLanguage($aTrayMenu[$A][1], $aTrayMenu[$A][2]))
	Next

	TraySetClick(8)

	_WinAPI_EmptyWorkingSet()
	While 1
		Sleep(20)
		$sStateString = _Monitor($aMonitor, $iIsFrozen)
		If @error And $iIsRun And $iShowMsg Then
			If $iIsFrozenShown Then
				$iIsFrozenShown = 0
				ContinueLoop
			EndIf
			_MsgPopup_Close()
			_MsgPopup_Create(-1, @AutoItExe, 0, $sStateString, 270, 40, 0, $iWait)
			If $iIsFrozen Then
				$iIsFrozenShown = 1
			EndIf
		EndIf

		If $iIsRun = 0 Then
			$iIsRun = 1
		EndIf

		$iMsg = TrayGetMsg()
		Switch $iMsg
			Case $aTrayMenu[5][0]
				ExitLoop

			Case $TRAY_EVENT_PRIMARYDOWN
				_GUI($aMonitor, $iIsFrozen, 0)
				If @extended Then ; Language change.
					For $A = 1 To $aTrayMenu[0][0]
						TrayItemSetText($aTrayMenu[$A][0], _GetLanguage($aTrayMenu[$A][1], $aTrayMenu[$A][2]))
					Next
				EndIf
				$iShowMsg = _Is("ShowMsg", 0)
				$iWait = _Is("Wait", 2)

			Case Else
				If $iMsg > 0 Then
					For $A = 1 To $aTrayMenu[0][0]
						If $iMsg = $aTrayMenu[$A][0] Then
							Switch $aTrayMenu[$A][1]
								Case "ABOUT"
									_GUI($aMonitor, $iIsFrozen, 1)
									If @extended Then ; Language change.
										For $A = 1 To $aTrayMenu[0][0]
											TrayItemSetText($aTrayMenu[$A][0], _GetLanguage($aTrayMenu[$A][1], $aTrayMenu[$A][2]))
										Next
									EndIf
									$iShowMsg = _Is("ShowMsg", 0)
									$iWait = _Is("Wait", 2)

								Case "EXIT"
									ExitLoop

								Case "FREEZE"
									If $iIsFrozen Then
										$iIsFrozen = 0
										TrayItemSetState($aTrayMenu[3][0], $TRAY_UNCHECKED)
									Else
										$iIsFrozen = 1
										TrayItemSetState($aTrayMenu[3][0], $TRAY_CHECKED)
									EndIf

							EndSwitch
							ExitLoop
						EndIf
					Next
				EndIf
		EndSwitch
	WEnd
EndFunc   ;==>_Main

Func _Exit()
	_GDIPlus_Shutdown()
	Exit
EndFunc   ;==>_Exit

Func _GetIcon($iIcon)
	Local $aArray[9] = [8, _
			0, 1, 2, 3, 12, 13, 23, 123], _
			$iIndex = (Number(IniRead(@ScriptDir & "\Settings.ini", "General", "Icon", 0)) * 8) - 5

	For $A = 1 To $aArray[0]
		If $iIcon = $aArray[$A] Then
			Return $iIndex
		EndIf
		$iIndex -= 1
	Next
EndFunc   ;==>_GetIcon

Func _GetKeyText($sData, $iState)
	Local $sState = _GetToggle($iState)
	Local $sKey = StringUpper($sData)
	Return _GetLanguage($sKey & "_" & StringUpper($sState), $sData & " is " & $sState)
EndFunc   ;==>_GetKeyText

Func _GetRelativeSize($iTotalWidth, $iTotalHeight, $iWidth, $iHeight)
	Local $aReturn[2] = [$iTotalWidth, $iTotalHeight]
	If $iWidth < $iHeight Then
		$aReturn[0] = Int($iTotalWidth * $iWidth / $iHeight)
		$aReturn[1] = Int($iTotalHeight)
	Else
		$aReturn[1] = Int($iTotalHeight * $iHeight / $iWidth)
		$aReturn[0] = Int($iTotalWidth)
	EndIf
	Return $aReturn
EndFunc   ;==>_GetRelativeSize

Func _GetToggle($iState)
	Local $sState
	If $iState Then
		$sState = "On"
	Else
		$sState = "Off"
	EndIf
	Return $sState
EndFunc   ;==>_GetToggle

Func _GUI(ByRef $aMonitor, $iIsFrozen, $iShowAbout)
	Local $aGUI, $aLabels[$aMonitor[0][0] + 1] = [0, -1, -1, -1], $aLanguage[1][5] = [[0, 5, 0]], $aLanguageCombo, $bColor_1 = 0x000000, $bColor_2 = 0x000000, $bColor_3 = 0x000000, _
			$hCombo, $hImageList, $iAbout, $iHeight = 270, $iHeightHalf, $iImage, $iIndex, $iMsg, $iSettingsChange = 0, $iShowMsg, $iStartup, $iState, $iTab, $iTabItem1, $iTabItem2, $iTop = 45, _
			$iWait, $iWidth = 350, $sData, $sLanguage, $sLanguagePrevious
	Local $aIcons[6][2] = [[5, 2], _
			["KeyboardKeys", 0], _
			["BlueBars", -1], _
			["GreenBars", -2], _
			["Black 'N' White Bars", -3], _
			["Black 'N' White Circles", -4]], _
			$hComboIcons, $hImageListIcons, $iDefaultIcon, $iIconIndex = 5, $sDefaultIcon, $sDefaultIconPrevious
	TraySetClick(0)

	$aGUI = _MsgPopup_Create(-1, "", "", "", $iWidth, $iHeight, 2)
	_MsgPopup_Show(0)
	$iHeightHalf = ($iHeight / 2)

	$iImage = GUICtrlCreateIcon(@AutoItExe, $aMonitor[0][4], 5, 5)

	For $A = 1 To $aMonitor[0][0]
		$aLabels[0] += 1
		$aLabels[$aLabels[0]] = GUICtrlCreateLabel($aMonitor[$A][4], 65, $iTop, $iWidth - 90, 18)
		GUICtrlSetBkColor($aLabels[$aLabels[0]], $GUI_BKCOLOR_TRANSPARENT)
		GUICtrlSetFont($aLabels[$aLabels[0]], 9)
		$iTop += 20
	Next

	GUICtrlCreateLabel("", 65, 5, $iWidth - 90, $iHeightHalf - 50)
	_LanguageAdd($aLanguage, -1, 'TIP_MSG_1', 'This is the current state of the CapsLock, NumLock && ScrollLock keys.')
	GUICtrlSetFont(-1, 9)
	GUICtrlSetBkColor(-1, $GUI_BKCOLOR_TRANSPARENT)

	$iTab = GUICtrlCreateTab(5, $iHeightHalf - 20, $iWidth - 10, $iHeightHalf + 15)
	$iTabItem1 = GUICtrlCreateTabItem(_GetLanguage('SETTINGS', 'Settings'))
	_LanguageAdd($aLanguage, -1, 'SETTINGS', 'Settings')

	$iShowMsg = GUICtrlCreateCheckbox(_GetLanguage('TIP_SETTINGS_1', 'Display notifications when the state of a key is changed.'), 10, $iHeightHalf + 10, $iWidth - 20, 20)
	_LanguageAdd($aLanguage, $iShowMsg, 'TIP_SETTINGS_1', 'Display notifications when the state of a key is changed.')
	If _Is("ShowMsg", 0) Then
		GUICtrlSetState($iShowMsg, $GUI_CHECKED)
	EndIf

	$iStartup = GUICtrlCreateCheckbox(_GetLanguage('TIP_SETTINGS_2', 'Start with Windows.'), 10, $iHeightHalf + 35, $iWidth - 20, 20)
	_LanguageAdd($aLanguage, $iStartup, 'TIP_SETTINGS_2', 'Start with Windows.')
	If _Is("Startup", 0) Then
		GUICtrlSetState($iStartup, $GUI_CHECKED)
	EndIf

	GUICtrlCreateLabel(_GetLanguage('TIP_SETTINGS_3', 'Time to wait before closing (seconds)') & ":", 10, $iHeightHalf + 60, $iWidth - 100, 20)
	_LanguageAdd($aLanguage, -1, 'TIP_SETTINGS_3', 'Time to wait before closing (seconds)', "", ":")
	$iWait = GUICtrlCreateInput(_Is("Wait", 2), $iWidth - 100, $iHeightHalf + 60, 30, 20, $ES_NUMBER)

	GUICtrlCreateLabel("", 10, $iHeight - 55, $iWidth - 20, 20)
	_LanguageAdd($aLanguage, -1, 'LANGUAGE', 'GUI language', "", ":")
	$hCombo = _GUICtrlComboBoxEx_Create($aGUI[0], "", 10, $iHeight - 35, 140, 260, $CBS_DROPDOWNLIST)
	$__ComboBoxLanguage = $hCombo

	$hComboIcons = _GUICtrlComboBoxEx_Create($aGUI[0], "", 155, $iHeight - 35, 140, 260, $CBS_DROPDOWNLIST)
	$__ComboBoxIcon = $hComboIcons

	$sDefaultIcon = $aIcons[1][0]
	$iDefaultIcon = Number(IniRead(@ScriptDir & "\Settings.ini", "General", "Icon", 0))
	$hImageListIcons = _GUIImageList_Create(16, 16, 5, 3)
	For $A = 1 To $aIcons[0][0]
		_GUIImageList_AddIcon($hImageListIcons, @AutoItExe, $iIconIndex, True)
		$iIndex = _GUICtrlComboBoxEx_AddString($hComboIcons, $aIcons[$A][0], $A - 1, $A - 1)
		If $iDefaultIcon == $aIcons[$A][1] Then
			$sDefaultIcon = $aIcons[$A][0]
			$sDefaultIconPrevious = $sDefaultIcon
			_GUICtrlComboBoxEx_SetCurSel($hComboIcons, $iIndex)
		EndIf
		$iIconIndex += 8
	Next
	_GUICtrlComboBoxEx_SetImageList($hComboIcons, $hImageListIcons)

	$iTabItem2 = GUICtrlCreateTabItem(_GetLanguage('ABOUT', 'About'))
	_LanguageAdd($aLanguage, -1, 'ABOUT', 'About')

	$iAbout = GUICtrlCreateLabel("", 10, $iHeightHalf + 10, $iWidth - 20, $iHeightHalf - 20)
	GUICtrlSetData(-1, _GetLanguage("TIP_MSG_2", "%PROGRAMNAME% visually displays the current state of the CapsLock, NumLock and ScrollLock keys in the tray menu. @NL @NL The application has been created by %COPYRIGHT%.") & _
			@CRLF & @CRLF & _
			_GetLanguageAuthor('LANGUAGE_AUTHOR', 'Thanks to %LANGUAGEAUTHOR% for the %LANGUAGE% translation. The translation was created on the %LANGUAGEUPDATED%.'))
	GUICtrlCreateTabItem("")

	$hImageList = _GUIImageList_Create(16, 16, 5, 3)
	_GUICtrlComboBoxEx_SetImageList($hCombo, $hImageList)

	If $iShowAbout Then ; Show About Tab.
		GUICtrlSetState($iTabItem2, $GUI_SHOW)
		ControlMove($aGUI[0], "", $hCombo, -99, -99) ; Hide The ComboBox.
	Else; Show Settings Tab.
		GUICtrlSetState($iTabItem1, $GUI_SHOW)
		ControlMove($aGUI[0], "", $hCombo, 10, $iHeight - 35) ; Show The ComboBox.
	EndIf

	$sLanguage = _GetLanguageCurrent()
	$sLanguagePrevious = $sLanguage
	$aLanguageCombo = _GetLanguageList(0)
	For $A = 1 To $aLanguageCombo[0]
		$iIndex = _GUICtrlComboBoxEx_AddString($hCombo, $aLanguageCombo[$A], $A - 1, $A - 1)
		_GUICtrl_AddImage($hCombo, $iIndex, $hImageList, _GetLanguageCode($aLanguageCombo[$A]), 1)
		If $sLanguage == $aLanguageCombo[$A] Then
			_GUICtrlComboBoxEx_SetCurSel($hCombo, $iIndex)
		EndIf
	Next

	GUIRegisterMsg($WM_COMMAND, "WM_COMMAND")
	_MsgPopup_Show()

	_WinAPI_EmptyWorkingSet()
	While 1
		_MsgPopup_ExitMonitor($aGUI[0], $aLabels[1], $bColor_1)
		_MsgPopup_ExitMonitor($aGUI[0], $aLabels[2], $bColor_2)
		_MsgPopup_ExitMonitor($aGUI[0], $aLabels[3], $bColor_3)

		_Monitor($aMonitor, $iIsFrozen)
		If @error Then
			For $A = 1 To $aLabels[0]
				GUICtrlSetData($aLabels[$A], $aMonitor[$A][4])
			Next
			GUICtrlSetImage($iImage, @AutoItExe, $aMonitor[0][4])
		EndIf

		If $__LanguageChange Then ; Monitor Change Of Language Combo.
			$__LanguageChange = 0
			_GUICtrlComboBoxEx_GetItemText($hCombo, _GUICtrlComboBoxEx_GetCurSel($hCombo), $sLanguage) ; Set Language.
			If $sLanguage = $sLanguagePrevious Then
				ContinueLoop
			EndIf
			_SetLanguageCurrent($sLanguage)
			$sLanguagePrevious = $sLanguage

			_LanguageUpdate($aLanguage)

			GUICtrlSetData($iAbout, _GetLanguage("TIP_MSG_2", "%PROGRAMNAME% visually displays the current state of the CapsLock, NumLock and ScrollLock keys in the tray menu. @NL @NL The application has been created by %COPYRIGHT%.") & _
					@CRLF & @CRLF & _
					_GetLanguageAuthor('LANGUAGE_AUTHOR', 'Thanks to %LANGUAGEAUTHOR% for the %LANGUAGE% translation. The translation was created on the %LANGUAGEUPDATED%.'))

			For $A = 1 To $aLabels[0]
				$aMonitor[$A][4] = _GetKeyText($aMonitor[$A][3], $aMonitor[$A][1])
				GUICtrlSetData($aLabels[$A], $aMonitor[$A][4])
				$sData &= $aMonitor[$A][4] & @CRLF
			Next
			TraySetToolTip($sData)
			$iSettingsChange += 1
		EndIf

		If $__IconChange Then
			$__IconChange = 0
			_GUICtrlComboBoxEx_GetItemText($hComboIcons, _GUICtrlComboBoxEx_GetCurSel($hComboIcons), $sDefaultIcon)
			If $sDefaultIcon = $sDefaultIconPrevious Then
				ContinueLoop
			EndIf
			For $A = 1 To $aIcons[0][0]
				If $sDefaultIcon = $aIcons[$A][0] Then
					$iDefaultIcon = $aIcons[$A][1]
					$sDefaultIconPrevious = $sDefaultIcon
					IniWrite(@ScriptDir & "\Settings.ini", "General", "Icon", $iDefaultIcon)
					ExitLoop
				EndIf
			Next
			$aMonitor[0][4] = _GetIcon($aMonitor[0][2])
			GUICtrlSetImage($iImage, @AutoItExe, $aMonitor[0][4])
			TraySetIcon(@AutoItExe, $aMonitor[0][4])
		EndIf

		$iMsg = GUIGetMsg()
		Switch $iMsg
			Case $aGUI[1]
				ExitLoop

			Case $iStartup
				$iState = Number(_IsChecked($iStartup))
				If $iState Then
					_StartupFolder_Install(_ProgramName())
				Else
					_StartupFolder_Uninstall(_ProgramName())
				EndIf
				IniWrite(@ScriptDir & "\Settings.ini", "General", "Startup", $iState)

			Case $iTab ; Hide The ComboBox.
				Switch GUICtrlRead($iTab, 1)
					Case $iTabItem1
						ControlMove($aGUI[0], "", $hCombo, 10, $iHeight - 35)
						ControlMove($aGUI[0], "", $hComboIcons, 155, $iHeight - 35)

					Case Else
						If $hCombo And $hComboIcons Then
							ControlMove($aGUI[0], "", $hCombo, -99, -99)
							ControlMove($aGUI[0], "", $hComboIcons, -99, -99)
						EndIf

				EndSwitch

			Case Else
				For $A = 1 To $aLabels[0]
					If $iMsg = $aLabels[$A] Then
						Send("{" & $aMonitor[$A][3] & " " & _GetToggle(Number(Not $aMonitor[$A][1])) & "}") ; _WinAPI_Keybd_Event
						ExitLoop
					EndIf
				Next

		EndSwitch

		Switch TrayGetMsg()
			Case $TRAY_EVENT_PRIMARYDOWN, $TRAY_EVENT_SECONDARYDOWN
				ExitLoop

		EndSwitch
	WEnd

	$iWait = Number(GUICtrlRead($iWait))
	If $iWait <= 0 Or $iWait > 30 Then
		$iWait = 2
	EndIf
	IniWrite(@ScriptDir & "\Settings.ini", "General", "ShowMsg", Number(_IsChecked($iShowMsg)))
	IniWrite(@ScriptDir & "\Settings.ini", "General", "Wait", $iWait)

	_MsgPopup_Close()
	TraySetClick(8)
	Return SetError(0, $iSettingsChange, 0)
EndFunc   ;==>_GUI

Func _GUICtrl_AddImage($hHandle, $iIndex, ByRef $hImageList, $sImageFile, $iType) ; Taken From: http://www.autoitscript.com/forum/topic/113827-thumbnail-of-a-file/page__view__findpost__p__799038
	Local $aBitmap, $aImage, $aImageSize, $aRelativeSize, $hGraphic, $hImageFile, $iHeight, $iWidth
	$aImageSize = _GUIImageList_GetIconSize($hImageList)

	$hImageFile = _ResourceGetAsImage($sImageFile)
	If @error Then
		$hImageFile = _ResourceGetAsImage("unknown")
	EndIf

	$iWidth = _GDIPlus_ImageGetWidth($hImageFile)
	$iHeight = _GDIPlus_ImageGetHeight($hImageFile)

	$aRelativeSize = _GetRelativeSize($aImageSize[0], $aImageSize[1], $iWidth, $iHeight)
	$aImage = DllCall($ghGDIPDll, 'int', 'GdipGetImageThumbnail', 'ptr', $hImageFile, 'int', $aImageSize[0], 'int', $aImageSize[1], 'ptr*', 0, 'ptr', 0, 'ptr', 0)
	$hGraphic = _GDIPlus_ImageGetGraphicsContext($aImage[4])
	_GDIPlus_GraphicsClear($hGraphic, 0)
	_GDIPlus_GraphicsDrawImageRect($hGraphic, $hImageFile, ($aImageSize[0] - $aRelativeSize[0]) / 2, ($aImageSize[1] - $aRelativeSize[1]) / 2, $aRelativeSize[0], $aRelativeSize[1])
	$aBitmap = DllCall($ghGDIPDll, 'int', 'GdipCreateHICONFromBitmap', 'ptr', $aImage[4], 'ptr*', 0)
	_GDIPlus_GraphicsDispose($hGraphic)
	_GDIPlus_ImageDispose($aImage[4])
	_GDIPlus_ImageDispose($hImageFile)
	If $aBitmap[2] = 0 Then
		Return SetError(1, 0, 0)
	EndIf
	_GUIImageList_ReplaceIcon($hImageList, -1, $aBitmap[2])
	Switch $iType
		Case 1 ; ComboBox
			_GUICtrlComboBoxEx_SetItemImage($hHandle, $iIndex, _GUIImageList_GetImageCount($hImageList) - 1)

		Case 2 ; ListView
			; Not Required.

	EndSwitch
	_WinAPI_DestroyIcon($aBitmap[2])
	Return 1
EndFunc   ;==>_GUICtrl_AddImage

Func _Is($sData, $sDefault = 0, $sSection = "General")
	Return Number(IniRead(@ScriptDir & "\Settings.ini", $sSection, $sData, $sDefault))
EndFunc   ;==>_Is

Func _IsChecked($iControlID)
	Return BitAND(GUICtrlRead($iControlID), $GUI_CHECKED) = $GUI_CHECKED
EndFunc   ;==>_IsChecked

Func _LanguageAdd(ByRef $aArray, $iControlID, $sData, $sDefault, $sBefore = "", $sAfter = "")
	If ($aArray[0][0] + 1) >= $aArray[0][2] Then
		$aArray[0][2] = ($aArray[0][0] + 1) * 2
		ReDim $aArray[$aArray[0][2]][$aArray[0][1]]
	EndIf
	$aArray[0][0] += 1
	If $iControlID = -1 Then
		$iControlID = _WinAPI_GetDlgCtrlID(GUICtrlGetHandle($iControlID))
	EndIf
	$aArray[$aArray[0][0]][0] = $iControlID
	$aArray[$aArray[0][0]][1] = $sData
	$aArray[$aArray[0][0]][2] = $sDefault
	$aArray[$aArray[0][0]][3] = $sBefore
	$aArray[$aArray[0][0]][4] = $sAfter
	GUICtrlSetData($iControlID, $sBefore & _GetLanguage($sData, $sDefault) & $sAfter)
EndFunc   ;==>_LanguageAdd

Func _LanguageUpdate($aArray)
	For $A = 1 To $aArray[0][0]
		GUICtrlSetData($aArray[$A][0], $aArray[$A][3] & _GetLanguage($aArray[$A][1], $aArray[$A][2]) & $aArray[$A][4])
	Next
EndFunc   ;==>_LanguageUpdate

Func _Monitor(ByRef $aMonitor, $iIsFrozen)
	Local $iError = 0, $iState = 0, $iStateChange = 0, $sGUIData = "", $sTrayData = ""

	If $iIsFrozen Then
		For $A = 1 To $aMonitor[0][0]
			If BitAND(_WinAPI_GetKeyState($aMonitor[$A][0]), 1) <> $aMonitor[$A][1] Then
				Send("{" & $aMonitor[$A][3] & " " & _GetToggle($aMonitor[$A][1]) & "}")
				$iStateChange = 1
			EndIf
		Next
		Return SetError($iStateChange, 0, _GetLanguage('ISFROZEN', 'Currently %PROGRAMNAME% is frozen.'))
	EndIf

	$aMonitor[0][2] = 0
	For $A = 1 To $aMonitor[0][0]
		$iState = BitAND(_WinAPI_GetKeyState($aMonitor[$A][0]), 1)

		If $iState <> $aMonitor[$A][1] Then
			$iStateChange = 1
		EndIf

		If $iState Then
			$aMonitor[0][2] &= $aMonitor[$A][2]
		EndIf
		$aMonitor[$A][4] = _GetKeyText($aMonitor[$A][3], $iState)

		If $iStateChange Then
			$iStateChange = 0
			$sGUIData &= $aMonitor[$A][4] & @CRLF
		EndIf
		$sTrayData &= $aMonitor[$A][4] & @CRLF
		$aMonitor[$A][1] = $iState
	Next

	If $aMonitor[0][2] <> $aMonitor[0][3] Then
		$aMonitor[0][3] = $aMonitor[0][2]
		$aMonitor[0][4] = _GetIcon($aMonitor[0][2])
		TraySetIcon(@AutoItExe, $aMonitor[0][4])
		TraySetToolTip($sTrayData)
		$iError = 1
	EndIf
	Return SetError($iError, "", $sGUIData)
EndFunc   ;==>_Monitor

Func _SingletonEx($sTitleID) ; Idea by KaFu.
	Local $hWnd
	$hWnd = WinGetHandle($sTitleID)
	For $A = 1 To $CmdLine[0]
		If $CmdLine[$A] = "/Restart" Then
			Sleep(200)
			ExitLoop
		EndIf
	Next
	If IsHWnd($hWnd) Then
		Return SetError(1, 0, $hWnd)
	EndIf
	AutoItWinSetTitle($sTitleID)
	Return WinGetHandle($sTitleID)
EndFunc   ;==>_SingletonEx

Func WM_COMMAND($hWnd, $iMsg, $iwParam, $ilParam)
	#forceref $hWnd, $iMsg, $ilParam
	Local $hComboBox_1, $hComboBox_2, $hWndFrom, $iHiWord

	$hComboBox_1 = $__ComboBoxLanguage
	$hComboBox_2 = $__ComboBoxIcon
	$hWndFrom = $ilParam
	$iHiWord = _WinAPI_HiWord($iwParam)

	Switch $hWndFrom
		Case $hComboBox_1
			Switch $iHiWord
				Case $CBN_EDITCHANGE, $CBN_SELCHANGE
					$__LanguageChange = 1

			EndSwitch
		Case $hComboBox_2
			Switch $iHiWord
				Case $CBN_EDITCHANGE, $CBN_SELCHANGE
					$__IconChange = 1

			EndSwitch
	EndSwitch
	Return $GUI_RUNDEFMSG
EndFunc   ;==>WM_COMMAND

#region Start >>>>> Additional Language Strings <<<<<
#cs
	_GetLanguage('ABOUT', 'About')
	_GetLanguage('CAPSLOCK_OFF', 'CapsLock is Off')
	_GetLanguage('CAPSLOCK_ON', 'CapsLock is On')
	_GetLanguage('EXIT', 'Exit')
	_GetLanguage('FREEZE', 'Freeze')
	_GetLanguage('LANGUAGE', 'GUI language')
	_GetLanguage('NUMLOCK_OFF', 'NumLock is Off')
	_GetLanguage('NUMLOCK_ON', 'NumLock is On')
	_GetLanguage('SCROLLLOCK_OFF', 'ScrollLock is Off')
	_GetLanguage('SCROLLLOCK_ON', 'ScrollLock is On')
	_GetLanguage('TIP_MSG_1', 'This is the current state of the CapsLock, NumLock && ScrollLock keys.')
	_GetLanguage("TIP_MSG_2", "%PROGRAMNAME% visually displays the current state of the CapsLock, NumLock and ScrollLock keys in the tray menu. @NL @NL The application has been created by %COPYRIGHT%.")
#ce
#region End >>>>> Additional Language Strings <<<<<
