#!/bin/sh
#
# Execute avast! programs in safe environment.
# 
# Variables affecting this script:
# 
#    AVAST_PREFIX ..... Sets prefix to avast! installation; default is to
#                       autodetect it and standard value is
#                       /usr/lib/avast4workstation.
#    AVAST_FAILSAFE ... If set to "1", bundled version of GTK+ and X11
#                       libraries will be used even if there's system
#                       version available. Use in case of problems with GTK+.
#

PATH=/bin:/usr/bin:/usr/local/bin:$PATH
export PATH

# -----------------------------------------------------------------------
# Find avast! installation directory:
# -----------------------------------------------------------------------

if test -z $AVAST_PREFIX ; then
    dirn=`dirname $0`
    basen=`basename $0`
    if test -d $dirn/../lib/avast4workstation ; then
        AVAST_PREFIX=`cd $dirn/../lib/avast4workstation && pwd`
    fi

    if test ! -f $AVAST_PREFIX/lib/libavastengine-4.so.7 ; then
        # try to resolve the symlink
        file2=`ls -l $dirn/$basen | sed -e 's,.* -> \(.*\),\1,'`

        if test -f "$file2" ; then
            dir2=`dirname $file2`
            if test -d $dir2/../../avast4workstation ; then
                AVAST_PREFIX=`cd $dir2/.. && pwd`
            fi
        fi
    fi

    export AVAST_PREFIX
fi

# -----------------------------------------------------------------------
# Check the license key and VPS database for non-GUI users:
# -----------------------------------------------------------------------

programname=`basename $0`
if test "$programname" = "avast" ; then
	key=""
	if test -f ~/.avast/avastrc ; then
		key=`grep key= ~/.avast/avastrc | cut -d "=" -f 2`
	fi

	if test -z "$key" ; then
		echo "Couldn't find a registration key in ~/.avast/avastrc file!"
		echo "Please register avast! at http://www.avast.com/i_kat_207.php?lang=ENG"
		echo "to get the key."
		echo "NOTE: if avast! rejects the key, remove ~/.avast/avastrc file and"
		echo "run this script again with a valid key."
		echo
		echo "Please enter the key here:"
		read regkey
		echo

		if [ -f ~/.avast/avastrc ]; then
			mv -f ~/.avast/avastrc ~/.avast/avastrc.prev
		else
			mkdir -p ~/.avast
		fi

		echo "[licence]" > ~/.avast/avastrc
		echo "key=$regkey" >> ~/.avast/avastrc
		chmod 600 ~/.avast/avastrc

		if [ -f ~/.avast/avastrc.prev ]; then
			cat ~/.avast/avastrc.prev | grep -v '\[licence\]' | grep -v 'key=' >> ~/.avast/avastrc
			rm ~/.avast/avastrc.prev
		fi
	fi

	if test ! -f ~/.avast/400.vps ; then
		if test -f $AVAST_PREFIX/var/400.vps ; then
			cp $AVAST_PREFIX/var/400.vps ~/.avast
			echo "Base virus definition file installed."
			echo "Please run 'avast-update' to download the latest available."
			echo
		else
			echo "Can't find base virus definition file"
			echo "Please run 'avast-update' to download the latest available."
			echo
			exit 22
		fi
	fi
fi

# -----------------------------------------------------------------------
# Detect presence of GTK+ and X11 libraries:
# -----------------------------------------------------------------------

has_avastengine=0
has_esmtp=0
has_gtk=0
has_x11=0

if test `uname -m` = "x86_64" ; then
    # use all included libraries when running on 64bit platform
    AVAST_FAILSAFE=1
fi

if test "x$AVAST_FAILSAFE" != "x1" ; then
    if test "x`$AVAST_PREFIX/bin/testlibs-avastengine 2>/dev/null`" = xOK ; then
        has_avastengine=1
    fi
    if test "x`$AVAST_PREFIX/bin/testlibs-esmtp 2>/dev/null`" = xOK ; then
        has_esmtp=1
    fi
    if test "x`$AVAST_PREFIX/bin/testlibs-x11 2>/dev/null`" = xOK ; then
        has_x11=1
    fi
    if test "x`$AVAST_PREFIX/bin/testlibs-gtk 2>/dev/null`" = xOK ; then
        has_gtk=1
    fi
fi

if test $has_avastengine = 0 ; then
    LD_LIBRARY_PATH=$AVAST_PREFIX/lib:$LD_LIBRARY_PATH
    export LD_LIBRARY_PATH
fi

if test $has_esmtp = 0 ; then
    LD_LIBRARY_PATH=$AVAST_PREFIX/lib-esmtp:$LD_LIBRARY_PATH
    export LD_LIBRARY_PATH
fi

if test $has_x11 = 0 ; then
    LD_LIBRARY_PATH=$AVAST_PREFIX/lib-x11:$LD_LIBRARY_PATH
    export LD_LIBRARY_PATH
fi

if test $has_gtk = 0 ; then
    LD_LIBRARY_PATH=$AVAST_PREFIX/lib-gtk2:$LD_LIBRARY_PATH
    export LD_LIBRARY_PATH
fi

# -----------------------------------------------------------------------
# Changes to dynamic linker behavior:
# -----------------------------------------------------------------------

# Make sure that our libraries are used in cases when we don't want
# system-wide versions:
#LD_LIBRARY_PATH=$AVAST_PREFIX/lib:$LD_LIBRARY_PATH
#export LD_LIBRARY_PATH

# Make sure that NPTL pthreads implementation is not used, our binaries are
# compiled on old system. This ensures compatibility with 2.6-based systems
# such as SuSE 9.1:
#LD_ASSUME_KERNEL="2.4.1"
#export LD_ASSUME_KERNEL


# -----------------------------------------------------------------------
# Run the program:
# -----------------------------------------------------------------------

AVAST4DATADIR=$HOME/.avast
export AVAST4DATADIR

$AVAST_PREFIX/bin/$programname $*
