#!/bin/sh

#
# This script tries to find KDE and GNOME installations and installs
# menu entries and icons for them. All actions are logged into uninst.log file
# in the same directory as the script and can be rolled back when uninstalling.
#
# Usage: install-desktop-entries.sh install|uninstall [DESTDIR]
#

PATH=/bin:/usr/bin:$PATH

if [ $# -eq 0 ] || [ "$1" != install ] && [ "$1" != uninstall ]; then
    echo "This script tries to add/remove avast! menu entries for KDE and GNOME"
    echo "Usage: install-desktop-entries.sh install|uninstall [DESTDIR]"
    exit 1
fi

MODE=$1
DESTDIR=$2

dirn=`dirname $0`
datadir=`cd $dirn && pwd`
bindir="$datadir/../../../bin"
logfile=${datadir}/uninst.log

install_symlink()
{
    if test ! -f ${DESTDIR}$2 ; then
        ln -sf ${DESTDIR}$datadir/$1 ${DESTDIR}$2
        echo "rm -f $2" >>$logfile
    fi
}


install_debian_menu()
{
    menufile=/usr/lib/menu/avast4workstation
    cat << EOF > $menufile
?package(avast4workstation):command="avastgui" \
icon="avastgui.png" needs="X11" section="System/File Tools" \
title="avast! Antivirus" longtitle="avast! Antivirus"
EOF

    echo "rm -f $menufile" >>$logfile
    echo 'if [ -x /usr/bin/update-menus ]; then /usr/bin/update-menus || true ; fi' >>$logfile

    if [ -x /usr/bin/update-menus ]; then /usr/bin/update-menus || true ; fi
}


if test "$MODE" = install ; then
    echo "# avast! desktop uninstallation script" >$logfile

    searchpaths="/usr /usr/local /opt/kde* /opt/gnome* $KDEDIR"
    for prefix in $searchpaths ; do

        # install freedesktop.org-compliant desktop entries:
        if test -d $prefix/share/applications ; then
            install_symlink avast.desktop \
                $prefix/share/applications/avast.desktop
        fi

        # install application icon:
        themes="hicolor gnome"
        for theme in $themes ; do
            if test -d $prefix/share/icons/$theme/48x48/apps ; then
                install_symlink ../icons/avast-appicon.png \
                    $prefix/share/icons/$theme/48x48/apps/avastgui.png
            fi
        done

        # install KDE service menu item (quick scan):
        if test -d $prefix/share/apps/konqueror/servicemenus ; then
            install_symlink avast-quickscan.desktop \
                $prefix/share/apps/konqueror/servicemenus/avast-quickscan.desktop
        fi

    done

    # install the icon into /usr/share/pixmaps, for other WMs:
    if test -d /usr/share/pixmaps ; then
        install_symlink ../icons/avast-appicon.png \
                        /usr/share/pixmaps/avastgui.png
    fi

    # ditto /usr/share/icons, e.g. for Debian menu system:
    if test -d /usr/share/icons ; then
        install_symlink ../icons/avast-appicon.png \
                        /usr/share/icons/avastgui.png
    fi

    # Debian/Mandrake menu system:
    if test -f /etc/mandrake-release -o -f /etc/debian_release ; then
        if test -d /usr/lib/menu ; then
	    install_debian_menu
	fi
    fi
fi

if test "$MODE" = uninstall ; then
    sh $logfile
    rm -f $logfile
fi
