@extends($_viewFrame)

@section('pageTitleMain','会员VIP')

{!! \ModStart\ModStart::css('vendor/Member/style/member.css') !!}
{!! \ModStart\ModStart::js('asset/common/payPage.js') !!}
@section('bodyAppend')
    @parent
    <script>
        $(function () {
            new window.api.payPage({
                device: 'pc',
                server: '/member_vip/buy',
                postData: function () {
                    return {
                        vipId: $('.pb-member-vip .vip-list .item.active').attr('data-vip-id')
                    };
                }
            });
            var $items = $('.pb-member-vip .vip-list .item');
            $items.on('click', function () {
                $items.removeClass('active');
                $(this).addClass('active');
                window.api.base.post('/member_vip/calc',{vipId:$(this).attr('data-vip-id')},function (res) {
                    $('[data-vip-type]').html(res.data.type);
                    $('[data-vip-price]').html(res.data.price);
                    $('[data-vip-expire]').html(res.data.expire);
                    $('[data-vip-info]').show();
                });
                return false;
            });
        });
    </script>
@endsection

@section('bodyContent')

    <div class="ub-container">

        <div class="ub-breadcrumb">
            <a href="/">首页</a>
            <a href="/member_vip">开通会员</a>
        </div>

        <div class="ub-panel">
            <div class="head">
                <div class="title">开通/续费会员</div>
            </div>
            <div class="body pb-member-vip">
                <div class="vip-current">
                    @if(!empty(\Module\Member\Auth\MemberVip::get()))
                        您当前是
                        <span class="ub-color-vip ub-text-bold">{{\Module\Member\Auth\MemberVip::get('title')}}</span>
                        ，
                        过期时间为：{{\Module\Member\Auth\MemberUser::get('vipExpire')}}
                    @endif
                </div>
                <div class="vip-list">
                    <div class="row">
                        @foreach($memberVips as $memberVip)
                            @if(!$memberVip['isDefault'])
                                <div class="col-md-3">
                                    <div class="item" data-vip-id="{{$memberVip['id']}}">
                                        <div class="title">
                                            {{$memberVip['title']}}
                                        </div>
                                        <div class="price">
                                            ￥{{$memberVip['price']}}
                                        </div>
                                        <div class="content">
                                            {!! $memberVip['content'] !!}
                                        </div>
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    </div>
                </div>
                <div class="pay-price" data-vip-info style="display:none;">
                    <span class="ub-text-warning" data-vip-type>-</span>
                    需要支付 <span class="ub-text-warning">￥</span><span class="ub-text-warning" data-vip-price>-</span>
                    ，
                    购买后<span class="ub-text-warning" data-vip-expire>-</span>过期
                </div>
                @if( \Module\Vendor\Pay\Util\PayUtil::hasPay() )
                    <div class="ub-list-pay" style="padding:.5rem;">
                        @if(\Module\Vendor\Pay\Util\PayUtil::isAlipayEnable())
                            <a class="item" href="javascript:;"
                               data-type="{{\Module\Vendor\Pay\Type\PayType::ALIPAY}}">
                                <img class="icon" src="@asset('asset/image/pay/alipay.jpg')"/>
                                支付宝
                            </a>
                        @endif
                        @if(\Module\Vendor\Pay\Util\PayUtil::isWechatEnable())
                            <a class="item" href="javascript:;"
                               data-type="{{\Module\Vendor\Pay\Type\PayType::WECHAT}}">
                                <img class="icon" src="@asset('asset/image/pay/wechat.jpg')"/>
                                微信支付
                            </a>
                        @endif
                    </div>
                @endif
                <div class="pay-submit">
                    <a href="javascript:;" class="btn btn-lg btn-primary" data-pay-submit>确定支付</a>
                </div>
            </div>
        </div>
    </div>


@endsection