<?php
 namespace Module\ShortLink\Api\Controller; use Illuminate\Routing\Controller; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use ModStart\Core\Util\FormatUtil; use ModStart\Core\Util\TimeUtil; use Module\Member\Auth\MemberUser; use Module\Member\Support\MemberLoginCheck; use Module\ShortLink\Util\LinkDomainUtil; use Module\ShortLink\Util\LinkUtil; class LinkController extends Controller implements MemberLoginCheck { public function generate() { $input = InputPackage::buildFromInput(); $urlBase = $input->getTrimString('urlBase'); $urls = $input->getTrimString('urls'); $minutes = $input->getInteger('minutes'); if (null === LinkDomainUtil::getByUrlBase($urlBase)) { return Response::jsonError('域名不存在'); } $filteredUrls = []; foreach (explode("\n", $urls) as $line) { $line = trim($line); if (empty($line)) { continue; } if (FormatUtil::isUrl($line)) { $filteredUrls[] = $line; } } if (empty($filteredUrls)) { return Response::jsonError('请输入网址'); } if (count($filteredUrls) > 100) { return Response::jsonError('一次最多生成100条URL'); } $minutes = intval($minutes); $minutes = max(0, $minutes); if ($minutes > TimeUtil::MINUTE_PERIOD_YEAR) { $minutes = TimeUtil::MINUTE_PERIOD_YEAR; } $results = []; foreach ($filteredUrls as $filteredUrl) { $ret = LinkUtil::generate(MemberUser::id(), $urlBase, $filteredUrl, $minutes); if (Response::isSuccess($ret)) { $results[] = [ 'status' => 'SUCCESS', 'statusMsg' => null, 'url' => $filteredUrl, 'shortUrl' => $ret['data']['_link'], ]; } else { $results[] = [ 'status' => 'ERROR', 'statusMsg' => $ret['msg'], 'url' => $filteredUrl, 'shortUrl' => null, ]; } } return Response::jsonSuccessData($results); } }