<?php
 namespace Module\ShortLink\Job; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Job\BaseJob; use ModStart\Core\Util\LBSUtil; use Module\ShortLink\Type\LinkVisitStatus; class LinkVisitJob extends BaseJob { private $visitId = 0; public static function create($visitId) { $job = new LinkVisitJob(); $job->visitId = $visitId; $job->delay(0); $job->onQueue('All'); app('Illuminate\Contracts\Bus\Dispatcher')->dispatch($job); } public function handle() { $visit = ModelUtil::get('link_visit', $this->visitId); if (empty($visit) || $visit['status'] != LinkVisitStatus::WAIT_PROCESS) { return; } $result = LBSUtil::locationByIP($visit['ip']); $update = []; if (!empty($result['country'])) { $update['ipCountry'] = $result['country']; } if (!empty($result['province'])) { $update['ipProvince'] = $result['province']; } if (!empty($result['city'])) { $update['ipCity'] = $result['city']; } $update['status'] = LinkVisitStatus::PROCESSED; ModelUtil::update('link_visit', $this->visitId, $update); } }