@extends('modstart::layout.frame')

@section('pageFavIco',\ModStart\Core\Assets\AssetsUtil::fix(modstart_config('siteFavIco')))
@section('pageTitle')@yield('pageTitleMain','') - {{modstart_config('siteName')}}@endsection
@section('pageKeywords',modstart_config('siteKeywords'))
@section('pageDescription',modstart_config('pageDescription'))

{!! \ModStart\ModStart::js('asset/common/qrcode.js') !!}

@section('headAppend')
    @parent
    <script>
        window.__config = {
            IsMemberLogin: {{empty($_memberUser)?'false':'true'}}
        }
    </script>
    <link rel="stylesheet" href="{{\ModStart\Core\Assets\AssetsUtil::fix('theme/'.modstart_config('siteTemplate','default').'/css/style.css')}}"/>
    {!! modstart_config('systemCounter') !!}
    <style type="text/css">
        @if(modstart_config('sitePrimaryColor',null))
            :root{
                --theme-color-primary: {{modstart_config('sitePrimaryColor')}};
                --theme-color-primary-light: {{modstart_config('sitePrimaryColor')}};
                --theme-color-primary-dark: {{modstart_config('sitePrimaryColor')}};
            }
        @endif
    </style>
@endsection

@section('bodyAppend')
    @parent
    {!! modstart_config('systemCounterBody') !!}
@endsection

@section('body')

    @include('theme.default.pc.share.header')

    @section('bodyContent')
    @show

    @include('theme.default.pc.share.footer')


@endsection
