@extends($_viewFrame)

@section('pageTitle',modstart_config('siteName').' - '.modstart_config('siteSlogan'))

@section('bodyAppend')
    @parent
    <script src="@asset('asset/vendor/vue.js')"></script>
    <script src="@asset('asset/vendor/element-ui/index.js')"></script>
    <script src="@asset('vendor/ShortLink/entry/linkGenerator.js')"></script>
@endsection

@section('bodyContent')

    @include('module::Banner.View.pc.public.banner',['position'=>'home','bannerRatio'=>'4-1'])

    <div class="ub-container">
        <div style="max-width:800px;margin:0 auto;padding:2rem 0;">
            <div id="linkGenerator">
                <div class="ub-loading" style="background:#FFF;line-height:4rem;">
                    <i class="iconfont icon-Refresh animate-rotate"></i>
                    正在加载
                </div>
            </div>
        </div>
    </div>

    <div class="ub-container">
        <div class="ub-content">
            <div class="head">
                <div class="title">产品特性</div>
                <div class="sub-title">成熟的短链接方案，提升您对用户的分析与留存</div>
            </div>
            <div class="body">
                <div class="row">
                    <div class="col-3">
                        <div class="item-a">
                            <div class="image ub-cover-1-1 contain" style="transform:scale(0.8);background-image:url(@asset('theme/default/images/icon/tech.png'));"></div>
                            <div class="title">多域名</div>
                            <div class="slogan">支持多域名可选访问</div>
                        </div>
                    </div>
                    <div class="col-3">
                        <div class="item-a">
                            <div class="image ub-cover-1-1 contain" style="transform:scale(0.8);background-image:url(@asset('theme/default/images/icon/report.png'));"></div>
                            <div class="title">分析报表</div>
                            <div class="slogan">统统收集并实时绘制报表</div>
                        </div>
                    </div>
                    <div class="col-3">
                        <div class="item-a">
                            <div class="image ub-cover-1-1 contain"  style="transform:scale(0.8);background-image:url(@asset('theme/default/images/icon/manage.png'));"></div>
                            <div class="title">链接管理</div>
                            <div class="slogan">生成的短连接可集中管理</div>
                        </div>
                    </div>
                    <div class="col-3">
                        <div class="item-a">
                            <div class="image ub-cover-1-1 contain"  style="transform:scale(0.7);background-image:url(@asset('theme/default/images/icon/api.png'));"></div>
                            <div class="title">强大API</div>
                            <div class="slogan">基于API方式访问功能更强大</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="ub-container">
        <div class="ub-content">
            <div class="head">
                <div class="title">应用场景</div>
                <div class="sub-title">助力各行业领域线上推广</div>
            </div>
            <div class="body">
                <div class="item-e">
                    <div class="image">
                        <div class="cover ub-cover-3-2 contain" style="background-image:url(@asset('theme/default/images/cover/sms.svg'));"></div>
                    </div>
                    <div class="text">
                        <div class="title">
                            短信推广
                        </div>
                        <div class="sub-title">
                            跳转快速稳定，提高用户体验、推广效果
                        </div>
                        <div class="desc">
                            <p>提供优质短链接访问域名，生成在短信中可被识别的短链接</p>
                            <p>同时保障短链接能正常跳转访问，且访问速度稳定快速</p>
                        </div>
                    </div>
                </div>
                <div class="item-e">
                    <div class="image">
                        <div class="cover ub-cover-1-1 contain" style="background-image:url(@asset('theme/default/images/cover/group.svg'));"></div>
                    </div>
                    <div class="text">
                        <div class="title">
                            社群推广
                        </div>
                        <div class="sub-title">
                            防误拦截屏蔽，保障推广内容有效性
                        </div>
                        <div class="desc">
                            <p>24小时监测推广链接访问情况，多重链接防护技术</p>
                            <p>保证推广内容能有效展示，杜绝广告劫持</p>
                        </div>
                    </div>
                </div>
                <div class="item-e">
                    <div class="image">
                        <div class="cover ub-cover-1-1 contain" style="background-image:url(@asset('theme/default/images/cover/it.svg'));"></div>
                    </div>
                    <div class="text">
                        <div class="title">
                            线上媒体推广
                        </div>
                        <div class="sub-title">
                            全国连通性高，保障全国各地链接打开率
                        </div>
                        <div class="desc">
                            <p>实时监控链接打开情况</p>
                            <p>保障全国各地区、各运营商网络环境下能正常打开推广短链接，提高推广转化率</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div style="background:#EEE;padding:4rem 0;margin:1rem 0;">
        <div class="ub-content">
            <div class="head">
                <div class="title">准备好提升你的品牌，发掘新的受众了吗？</div>
            </div>
            <div class="foot">
                <div class="action">
                    <a href="/member" class="btn btn-lg btn-primary">立即体验</a>
                </div>
            </div>
        </div>
    </div>

    <div class="ub-container">
        @include('module::Partner.View.pc.public.partner',['position'=>'home'])
    </div>

@endsection