<?php
 namespace ModStart\Module; use Illuminate\Support\Facades\Artisan; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Response; use ModStart\Core\Util\FileUtil; class ModuleManager { const MODULE_ENABLE_LIST = 'moduleEnableList'; public static function install($module) { try { BizException::throwsIf(L('Module Invalid'), !self::isExists($module)); $installeds = self::listUserInstalledModules(); $basic = self::getModuleBasic($module); BizException::throwsIf('Module basic empty', !$basic); foreach ($basic['require'] as $one) { if (!isset($installeds[$one])) { return Response::generateError(L('Module %s depend on %s, install fail', $module, $one)); } } $output = null; try { $exitCode = Artisan::call("modstart:module-install", ['module' => $module]); $output = trim(Artisan::output()); if (0 !== $exitCode) { return Response::generate(-1, "ERROR:$exitCode", ['output' => $output]); } } catch (\Exception $e) { return Response::generateError("ERROR:" . $e->getMessage()); } if (!isset($installeds[$module])) { $installeds[$module] = [ 'config' => [] ]; modstart_config()->setArray(self::MODULE_ENABLE_LIST, $installeds); } return Response::generateSuccessData(['output' => $output]); } catch (BizException $e) { return Response::generateError($e->getMessage()); } } public static function uninstall($module) { BizException::throwsIf(L('Module Invalid'), !self::isExists($module)); $installeds = self::listUserInstalledModules(); BizException::throwsIf(L('Module Has Been Installed'), !isset($installeds[$module])); foreach ($installeds as $one => $_) { $basic = self::getModuleBasic($one); BizException::throwsIf('Module config empty', !$basic); if (in_array($module, $basic['require'])) { return Response::generateError(L('Module %s depend on %s, uninstall fail', $one, $module)); } } try { $exitCode = Artisan::call("modstart:module-uninstall", ['module' => $module]); if (0 !== $exitCode) { return Response::generate(-1, "ERROR:$exitCode"); } } catch (\Exception $e) { return Response::generateError("ERROR:" . $e->getMessage()); } unset($installeds[$module]); modstart_config()->setArray(self::MODULE_ENABLE_LIST, $installeds); return Response::generateSuccess(); } public static function isExists($name) { return file_exists(self::path($name, 'config.php')); } public static function path($module, $path = '') { return base_path(self::relativePath($module, $path)); } public static function relativePath($module, $path = '') { return "module/$module" . ($path ? "/" . trim($path, '/') : ''); } public static function isSystemModule($module) { $modules = config('module.system', []); return isset($modules[$module]); } public static function isModuleInstalled($name) { if (!self::isExists($name)) { return false; } $modules = self::listAllInstalledModules(); return isset($modules[$name]); } public static function getModuleBasic($name) { if (file_exists($path = self::path($name, 'config.php'))) { return array_merge([ 'name' => 'None', 'type' => ModuleType::PLUGIN, 'title' => 'None', 'version' => '1.0.0', 'require' => [], 'author' => 'Author', 'description' => 'Description', 'config' => [], 'needInstall' => false, 'providers' => [], ], (include $path)); } return null; } public static function listLocalModules() { $files = FileUtil::listFiles(base_path('module')); $modules = []; foreach ($files as $v) { $basic = self::getModuleBasic($v['filename']); if (empty($basic)) continue; $modules[$v['filename']] = $basic; } return $modules; } public static function listUserInstalledModules() { return modstart_config()->getArray(self::MODULE_ENABLE_LIST); } public static function listAllInstalledModules() { static $modules = null; if (null !== $modules) { return $modules; } $modules = config('module.system', []); try { $modules = array_merge(self::listUserInstalledModules(), $modules); } catch (\Exception $e) { } return $modules; } public static function listAllInstalledModulesInRequiredOrder() { $modules = self::listAllInstalledModules(); $modules = array_keys($modules); $moduleInfoMap = []; foreach ($modules as $module) { $basic = self::getModuleBasic($module); if (empty($basic)) { continue; } $moduleInfoMap[$module] = $basic['require']; } $orderedModules = []; for ($i = 0; $i < 100; $i++) { foreach ($modules as $module) { if (in_array($module, $orderedModules)) { continue; } $allPassed = true; if (!empty($moduleInfoMap[$module])) { foreach ($moduleInfoMap[$module] as $requireModule) { if (!in_array($requireModule, $orderedModules)) { $allPassed = false; } } } if ($allPassed) { $orderedModules[] = $module; } } if (count($orderedModules) == count($modules)) { break; } } return $orderedModules; } public static function getInstalledModuleInfo($module) { $modules = self::listAllInstalledModules(); return isset($modules[$module]) ? $modules[$module] : null; } public static function saveUserInstalledModuleConfig($module, $config) { $modules = self::listUserInstalledModules(); if (!empty($modules[$module])) { $modules[$module]['config'] = array_merge($modules[$module]['config'], $config); } modstart_config()->setArray(self::MODULE_ENABLE_LIST, $modules); } public static function getModuleConfig($module, $key, $default = null) { $moduleInfo = self::getInstalledModuleInfo($module); if (isset($moduleInfo['config'][$key])) { return $moduleInfo['config'][$key]; } return $default; } public static function getModuleConfigArray($module, $key, $default = []) { $value = @json_decode(self::getModuleConfig($module, $key), true); if (empty($value)) { $value = $default; } return $value; } public static function getModuleConfigBoolean($module, $key, $default = false) { return !!self::getModuleConfig($module, $key, $default); } public static function getModuleConfigKeyValueItems($module, $key, $default = []) { $value = self::getModuleConfigArray($module, $key, $default); $result = []; if (!empty($value) && is_array($value)) { foreach ($value as $item) { if (isset($item['k']) && isset($item['v'])) { $result[$item['k']] = $item['v']; } } } return $result; } public static function getModuleConfigKeyValueItem($module, $key, $itemKey, $default = null) { $items = self::getModuleConfigKeyValueItems($module, $key); if (isset($items[$itemKey])) { return $items[$itemKey]; } return $default; } public static function listInstalledModuleAdminMenu() { $menus = []; foreach (self::listAllInstalledModules() as $module => $_) { if (file_exists($file = self::path($module, 'Admin/config.php'))) { $config = (require $file); if (!empty($config['menu'])) { $menus = array_merge($menus, $config['menu']); } } } return $menus; } }