-- water reflection, based on a posting
-- FAST!
-- on the  ArtWeaver forum by Singerxy
-- modified for Pixopedia by Sinia Petri http://www.sigmapi-design.com, 2014
-- 
-- try these values for example:
-- ywavelength = 0.001
-- yamplitude = 10
-- rangefactor = 0.2
-- xwavelength = 2
-- xcenter = 0.1

-- init images/process objects
imgA = TLuaImageWrap(inputImage)
imgB = TLuaImageWrap(outputImage)
proC = TLuaProcessWrap(procObj)

ywavelength = 0.01
yamplitude = 50
rangefactor = 0.5
xwavelength = 10
xcenter = 0.5

iWidth, iHeight = imgA:GetImageSize() 
y0 = iHeight/2
x0 = iWidth*xcenter
done = 0
total = y0
y_curr = y0
for y= y0, iHeight-1 do
  for x= 0, iWidth-1 do
    tempy = y/y0
    x1 = (1-tempy) * yamplitude * math.sin(tempy * tempy * rangefactor /ywavelength)
   
    x2 = (1-tempy)*(1-tempy) * yamplitude * math.sin((x-x0) * rangefactor / xwavelength)
    h,s,l = imgA:GetImageHSV(x+x1+x2,y)
    l = (1+tempy)*l
    imgB:SetImageHSV(x, iHeight-y, h, s, l)
    if (y > y_curr) then
       done = done + 1
       proC:ShowProgress(done, total)
       y_curr = y
    end   
  end
end