// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef _ADDFILETHREAD_H_
#define _ADDFILETHREAD_H_

#include "mfc.h"                       // CTypedPtrList - audited 4 Nov 2004

#include <wx/string.h>                 // wxString
#include <wx/thread.h>                 // wxThread

class CPartFile;
struct UnknownFile_Struct;

class CAddFileThread: protected wxThread
{
public:
    CAddFileThread();

    static void Setup();
    static void Shutdown();

    static void AddFile(wxString path, wxString name, CPartFile* = NULL);
    static int GetCount();

protected:
    virtual bool InitInstance()
    {
        return true;
    }

    virtual wxThread::ExitCode Entry();
    virtual void OnExit() { }

private:
    wxThread* m_Thread;

    // Setted to non-zero to end the thread
    static volatile int m_endWaitingForHashList;

    // Lock for the wait list and the conditions
    static wxMutex m_lockWaitingForHashList;

    // Signaled when something is added to the wait list.
    static wxCondition m_runWaitingForHashList;

    // The wait list itself
    static CTypedPtrList<CPtrList, UnknownFile_Struct *> m_sWaitingForHashList;
};

#endif // _ADDFILETHREAD_H_
