// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef _CMEMFILE_H_
#define _CMEMFILE_H_

// something that looks like the MFC CMemFile

#include "CFile.h"                     // CFile - audited 5 Nov 2004

class CMemFile : public CFile {
public:
    CMemFile(unsigned int growBytes=1024);
    CMemFile(unsigned char* buffer,unsigned int bufferSize,unsigned int growBytes=0);
    void Attach(unsigned char* buffer,unsigned int buffserSize,unsigned int growBytes=0);
    unsigned char* Detach();
    virtual ~CMemFile();
    virtual unsigned long GetPosition() {return fPosition;};
    virtual bool GetStatus(unsigned long none) const {return 1;};
    off_t Seek(off_t offset,wxSeekMode from=wxFromStart);
    virtual void SetLength(unsigned long newLen);
    unsigned long GetLength() { return fFileSize; };
    off_t Read(void* buf,off_t length);
    size_t Write(const void* buf,size_t length);
//  virtual void Abort();
//  virtual void Flush();
    virtual bool Close();

private:
    void enlargeBuffer(unsigned long size);

    unsigned long fLength;
    unsigned int fGrowBytes;
    unsigned long fPosition;
    unsigned long fBufferSize;
    unsigned long fFileSize;
    int deleteBuffer;
    unsigned char* fBuffer;
};

#endif // _CMEMFILE_H_
