// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "ClientDetailDialog.h"             // Needed for Module's Prototype(s) - audited 6 Nov 2004

#include "ClientCredits.h"                  // Needed for CClientCredits - audited 5 Nov 2004
#include "KnownFile.h"                      // Needed for CKnownFile - audited 5 Nov 2004
#include "muuli_wdr.h"                      // Needed for clientDetails - audited 4 Nov 2004
#include "otherfunctions.h"                 // Needed for GetResString - audited 4 Nov 2004
#include "server.h"                         // Needed for CServer - audited 5 Nov 2004
#include "ServerList.h"                     // Needed for CServerList - audited 5 Nov 2004
#include "SharedFileList.h"                 // Needed for CSharedFileList - audited 5 Nov 2004
#include "updownclient.h"                   // Needed for CUpDownClient - audited 5 Nov 2004
#include "xmule.h"                          // Needed for theApp

#include <arpa/inet.h>
#include <iomanip>                          // Needed for std::setfill
#include <netdb.h>
#include <netinet/in.h>
#include <sstream>                          // Needed for std::ostringstream
#include <string>                           // Needed for std::string
#include <sys/socket.h>
#include <wx/intl.h>                        // Needed for _
#include <wx/sizer.h>                       // Needed for wxSizer
#include <wx/stattext.h>                    // Needed for wxStaticText

#define GetDlgItem(a,b) wxStaticCast(FindWindowById((a)),b)
#define IsDlgButtonChecked(x) XRCCTRL(*this,#x,wxCheckBox)->GetValue()
#define CheckDlgButton(x,y) XRCCTRL(*this,#x,wxCheckBox)->SetValue(y)

BEGIN_EVENT_TABLE(CClientDetailDialog, wxDialog)
EVT_BUTTON(ID_CLOSEWND, CClientDetailDialog::OnBnClose)
END_EVENT_TABLE()

//IMPLEMENT_DYNAMIC(CClientDetailDialog, CDialog)
CClientDetailDialog::CClientDetailDialog(wxWindow *parent, CUpDownClient *client)
: wxDialog(parent, 9997, wxT("Client Details"), wxDefaultPosition, wxDefaultSize,
wxDEFAULT_DIALOG_STYLE |wxSYSTEM_MENU)
//: CDialog(CClientDetailDialog::IDD, 0)
{
    m_client = client;
    wxSizer *content = clientDetails(this, TRUE);
    content->Show(this, TRUE);
    Centre();
    OnInitDialog();
}

CClientDetailDialog::~CClientDetailDialog()
{
}

void CClientDetailDialog::OnBnClose(wxCommandEvent &evt)
{
    EndModal(0);
}

bool CClientDetailDialog::OnInitDialog()
{
    Localize();

    if (m_client->GetUserName())
    {
        GetDlgItem(ID_DNAME, wxStaticText)->SetLabel(wxString(m_client->GetUserName(), *wxConvCurrent));
    }
    else
    {
        GetDlgItem(ID_DNAME, wxStaticText)->SetLabel(wxT("?"));
    }

    if (m_client->GetUserName())
    {
        std::stringstream in;

        for (uint16_t i = 0; i != 16; ++i)
        {
            in << std::setfill('0') << std::setw(2) << std::hex << static_cast<unsigned int>(m_client->GetUserHash()[i]);
        }

        GetDlgItem(ID_DHASH, wxStaticText)->SetLabel(wxString(in.str().c_str(), *wxConvCurrent));
    }
    else
    {
        GetDlgItem(ID_DHASH, wxStaticText)->SetLabel(wxT("?"));
    }

    {
        std::stringstream in;
        switch (m_client->GetClientSoft())
        {
            case SO_UNKNOWN:
            {
                GetDlgItem(ID_DSOFT, wxStaticText)->SetLabel(wxT("?"));
                GetDlgItem(ID_DVERSION, wxStaticText)->SetLabel(wxT("?"));
                break;
            }
            case SO_EMULE:
            case SO_OLDEMULE:
            case SO_CDONKEY:
            case SO_AMULE:
            case SO_SHAREAZA:
            case SO_XMULE:
            {
                GetDlgItem(ID_DSOFT, wxStaticText)->SetLabel(_("eMule"));
                wxUint8 version = m_client->GetMuleVersion();

                if (version == 0x0)
                {
                    in << wxT("?");
                }
                else if (version != 0x99)
                {
                    if (m_client->GetClientModString().empty() == false)
                    {
                        in << "[ " << m_client->GetClientModString() << " ]";
                        
                    }
                    else
                    {
                        in << "v0." << std::setfill('0') << std::setw(2) << int(m_client->GetMuleVersion());
                    }
                }
                else
                {
                    in << m_client->GetClientVerString();
                }

                break;
            }
            case SO_EDONKEYHYBRID:
            case SO_EDONKEY:
                GetDlgItem(ID_DSOFT, wxStaticText)->SetLabel(_("eDonkey"));
                in << "v" << m_client->GetVersion();
                break;
            case SO_MLDONKEY:
                GetDlgItem(ID_DSOFT, wxStaticText)->SetLabel(_("Old MlDonkey"));
                in << "v" << m_client->GetVersion();
                break;
            case SO_NEW_MLDONKEY:
                GetDlgItem(ID_DSOFT, wxStaticText)->SetLabel(_("New MlDonkey"));
                in << "v" << m_client->GetVersion();
                break;
        }

        GetDlgItem(ID_DVERSION, wxStaticText)->SetLabel(wxString(in.str().c_str(), *wxConvCurrent));
    }

    {
        std::stringstream in;
        in << m_client->GetUserID() << " (";
    
        if (m_client->HasLowID())
        {
           in << _("Low");
        }
        else
        {
           in << _("High");
        }

        in << ")";
        GetDlgItem(ID_DID, wxStaticText)->SetLabel(wxString(in.str().c_str(), *wxConvCurrent));
    }

    {
        std::stringstream in;
        in << m_client->GetFullIP() << ":" << m_client->GetUserPort();
        GetDlgItem(ID_DIP, wxStaticText)->SetLabel(wxString(in.str().c_str(), *wxConvCurrent));
    }

    if (m_client->GetServerIP())
    {
        in_addr server;
        server.s_addr = m_client->GetServerIP();
        GetDlgItem(ID_DSIP, wxStaticText)->SetLabel(wxString(inet_ntoa(server), *wxConvCurrent));
        CServer* cserver = theApp.serverlist->GetServerByAddress(inet_ntoa(server), m_client->GetServerPort());

        if (cserver)
        {
            GetDlgItem(ID_DSNAME, wxStaticText)->SetLabel(wxString(cserver->GetListName(), wxConvUTF8));
        }
        else
        {
            GetDlgItem(ID_DSNAME, wxStaticText)->SetLabel(wxT("?"));
        }
    }
    else
    {
        GetDlgItem(ID_DSIP, wxStaticText)->SetLabel(wxT("?"));
        GetDlgItem(ID_DSNAME, wxStaticText)->SetLabel(wxT("?"));
    }

    if (m_client->Credits())
    {
        unsigned char* key;

        std::stringstream in;
        switch (m_client->Credits()->GetCurrentIdentState(m_client->GetIP()))
        {
            case IS_IDNEEDED:
                GetDlgItem(ID_SECI, wxStaticText)->SetLabel(wxT("in progress"));
                break;
            case IS_IDFAILED:
                key = static_cast<unsigned char *>(m_client->Credits()->GetKey());
                in << std::setfill('0') << std::setw(8) << std::hex 
                   << static_cast<unsigned int>(key[0])
                   << static_cast<unsigned int>(key[1]);
                in << std::setfill('0') << std::setw(4) << std::hex 
                   << static_cast<unsigned int>(key[2] % 65535);

                GetDlgItem(ID_SECI, wxStaticText)->SetLabel(_("not supported"));
                GetDlgItem(ID_PUBK, wxStaticText)->SetLabel(wxString(in.str().c_str(), *wxConvCurrent));
                break;
            case IS_IDENTIFIED:
                key = static_cast<unsigned char *>(m_client->Credits()->GetKey());
                in << std::setfill('0') << std::setw(8) << std::hex 
                   << static_cast<unsigned int>(key[0])
                   << static_cast<unsigned int>(key[1]);
                in << std::setfill('0') << std::setw(4) << std::hex 
                   << static_cast<unsigned int>(key[2] % 65535);
                
                GetDlgItem(ID_SECI, wxStaticText)->SetLabel(_("is identified"));
                GetDlgItem(ID_PUBK, wxStaticText)->SetLabel(wxString(in.str().c_str(), *wxConvCurrent));
                break;
            case IS_IDBADGUY:
                key = static_cast<unsigned char *>(m_client->Credits()->GetKey());
                in << std::setfill('0') << std::setw(8) << std::hex 
                   << static_cast<unsigned int>(key[0])
                   << static_cast<unsigned int>(key[1]);
                in << std::setfill('0') << std::setw(4) << std::hex 
                   << static_cast<unsigned int>(key[2] % 65535);
                
                GetDlgItem(ID_SECI, wxStaticText)->SetLabel(_("Client=BadGuy"));
                GetDlgItem(ID_PUBK, wxStaticText)->SetLabel(wxString(in.str().c_str(), *wxConvCurrent));
                break;
            default:
                GetDlgItem(ID_SECI, wxStaticText)->SetLabel(_("State unknown"));
                GetDlgItem(ID_PUBK, wxStaticText)->SetLabel(wxT(""));
                break;
        }
    }
    else
    {
        GetDlgItem(ID_SECI, wxStaticText)->SetLabel(_("is waiting"));
        GetDlgItem(ID_PUBK, wxStaticText)->SetLabel(wxT(""));
    }

    CKnownFile *file = theApp.sharedfiles->GetFileByID(m_client->GetUploadFileID());

    if (file)
    {
        GetDlgItem(ID_DDOWNLOADING, wxStaticText)->SetLabel(wxString(file->GetFileName(), *wxConvCurrent));
    }
    else
    {
        GetDlgItem(ID_DDOWNLOADING, wxStaticText)->SetLabel(wxT("-"));
    }
    
    GetDlgItem(ID_DDUP, wxStaticText)->SetLabel(CastItoXBytes(m_client->GetTransferedDown()));
    GetDlgItem(ID_DDOWN, wxStaticText)->SetLabel(CastItoXBytes(m_client->GetTransferedUp()));

    {
        std::stringstream in;
        in << std::fixed << std::setprecision(1) << static_cast<float>(m_client->GetDownloadDatarate()) / 1024.0f
           << " " << _("KB/s");
        GetDlgItem(ID_DAVUR, wxStaticText)->SetLabel(wxString(in.str().c_str(), *wxConvCurrent));
    }
    {
        std::stringstream in;
        in << std::fixed << std::setprecision(1) << static_cast<float>(m_client->GetDatarate()) / 1024.0f
           << " " << _("KB/s");
        GetDlgItem(ID_DAVDR, wxStaticText)->SetLabel(wxString(in.str().c_str(), *wxConvCurrent));
    }

    if (m_client->Credits())
    {
        std::stringstream in;
        GetDlgItem(ID_DUPTOTAL, wxStaticText)->SetLabel(CastItoXBytes(m_client->Credits()->GetDownloadedTotal()));
        GetDlgItem(ID_DDOWNTOTAL, wxStaticText)->SetLabel(CastItoXBytes(m_client->Credits()->GetUploadedTotal()));
        in << std::fixed << std::setprecision(1) << m_client->Credits()->GetScoreRatio(m_client->GetIP());
        GetDlgItem(ID_DRATIO, wxStaticText)->SetLabel(wxString(in.str().c_str(), *wxConvCurrent));
    }
    else
    {
        GetDlgItem(ID_DDOWNTOTAL, wxStaticText)->SetLabel(wxT("?"));
        GetDlgItem(ID_DUPTOTAL, wxStaticText)->SetLabel(wxT("?"));
        GetDlgItem(ID_DRATIO, wxStaticText)->SetLabel(wxT("?"));
    }

    if (m_client->GetUserName())
    {
        std::stringstream in;
        in << std::fixed << std::setprecision(1) << m_client->GetScore(m_client->IsDownloading(), true);
        GetDlgItem(ID_DRATING, wxStaticText)->SetLabel(wxString(in.str().c_str(), *wxConvCurrent));
    }
    else
    {
        GetDlgItem(ID_DRATING, wxStaticText)->SetLabel(wxT("?"));;
    }
    
    if (m_client->GetUploadState() != US_NONE)
    {
        std::stringstream in;
        in << m_client->GetScore(m_client->IsDownloading(), false);
        GetDlgItem(ID_DSCORE, wxStaticText)->SetLabel(wxString(in.str().c_str(), *wxConvCurrent));
    }
    else
    {
        GetDlgItem(ID_DSCORE, wxStaticText)->SetLabel(wxT("-"));
    }
    
    return true;
}

#if 0
BEGIN_MESSAGE_MAP(CClientDetailDialog, CDialog)
END_MESSAGE_MAP()
#endif

// CClientDetailDialog message handlers
void CClientDetailDialog::Localize()
{
#if 0
    GetDlgItem(IDC_STATIC30)->SetWindowText(GetResString(IDS_CD_GENERAL));
    GetDlgItem(IDC_STATIC31)->SetWindowText(GetResString(IDS_CD_UNAME));
    GetDlgItem(IDC_STATIC32)->SetWindowText(GetResString(IDS_CD_UHASH));
    GetDlgItem(IDC_STATIC33)->SetWindowText(GetResString(IDS_CD_CSOFT));
    GetDlgItem(IDC_STATIC34)->SetWindowText(GetResString(IDS_CD_UIP));
    GetDlgItem(IDC_STATIC35)->SetWindowText(GetResString(IDS_CD_SIP));
    GetDlgItem(IDC_STATIC36)->SetWindowText(GetResString(IDS_CD_VERSION));
    GetDlgItem(IDC_STATIC37)->SetWindowText(GetResString(IDS_CD_UID));
    GetDlgItem(IDC_STATIC38)->SetWindowText(GetResString(IDS_CD_SNAME));
    GetDlgItem(IDC_STATIC40)->SetWindowText(GetResString(IDS_CD_TRANS));
    GetDlgItem(IDC_STATIC41)->SetWindowText(GetResString(IDS_CD_CDOWN));
    GetDlgItem(IDC_STATIC42)->SetWindowText(GetResString(IDS_CD_DOWN));
    GetDlgItem(IDC_STATIC43)->SetWindowText(GetResString(IDS_CD_ADOWN));
    GetDlgItem(IDC_STATIC44)->SetWindowText(GetResString(IDS_CD_TDOWN));
    GetDlgItem(IDC_STATIC45)->SetWindowText(GetResString(IDS_CD_UP));
    GetDlgItem(IDC_STATIC46)->SetWindowText(GetResString(IDS_CD_AUP));
    GetDlgItem(IDC_STATIC47)->SetWindowText(GetResString(IDS_CD_TUP));
    GetDlgItem(IDC_STATIC50)->SetWindowText(GetResString(IDS_CD_SCORES));
    GetDlgItem(IDC_STATIC51)->SetWindowText(GetResString(IDS_CD_MOD));
    GetDlgItem(IDC_STATIC52)->SetWindowText(GetResString(IDS_CD_RATING));
    GetDlgItem(IDC_STATIC53)->SetWindowText(GetResString(IDS_CD_USCORE));
    GetDlgItem(IDOK)->SetWindowText(GetResString(IDS_FD_CLOSE));
    SetWindowText(GetResString(IDS_CD_TITLE));
#endif
}

