// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "CommentDialog.h"                  // Needed for this Interface's Prototype

#include "KnownFile.h"                      // Needed for CKnownFile
#include "otherfunctions.h"                 // Needed for GetResString
#include "xmule.h"                          // Needed for GetColor

#include <wx/combobox.h>                    // Needed for wxComboBox
#include <wx/panel.h>                       // Needed for wxPanel
#include <wx/textctrl.h>                    // Needed for wxTextCtrl

#if defined(HAVE_XRC)
    #include <wx/xrc/xmlres.h>              // Needed for wxXmlResource
    #define GetDlgItem(x,clas) XRCCTRL(*this, #x, clas)
#else
    #include <wx/button.h>                  // Needed for wxButton
    #include <wx/sizer.h>                   // Needed for wxBoxSizer
    #include <wx/statbox.h>                 // Needed for wxStaticBox
    #include <wx/stattext.h>                // Needed for wxStaticText

    #define GetDlgItem(id, type) (static_cast<type *>(this->FindWindow(id)))

enum
{
    IDC_CMT_TEXT
};
#endif

BEGIN_EVENT_TABLE(CCommentDialog, wxDialog)
    EVT_BUTTON(wxID_OK, CCommentDialog::OnBnClickedApply)
END_EVENT_TABLE()

CCommentDialog::CCommentDialog(wxWindow *parent, CKnownFile *file):
    wxDialog(parent, -1, _("File Comments"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE |wxSYSTEM_MENU)
{
    m_file = file;
#if defined(HAVE_XRC)
    wxXmlResource::Get()->LoadDialog(this, parent, "DLG_COMMENT");
#else
    CCommentDialog* item1 = this;

    wxBoxSizer* item2 = new wxBoxSizer(wxVERTICAL);

    wxStaticBox* item3Static = new wxStaticBox(item1, wxID_ANY, _("Comment this file (This text will be shown to all users)"));
    wxStaticBoxSizer* item3 = new wxStaticBoxSizer(item3Static, wxVERTICAL);
    item2->Add(item3, 0, wxGROW|wxALL, 5);

    wxTextCtrl* item4 = new wxTextCtrl( item1, IDC_CMT_TEXT, _T(""), wxPoint(24, 32), wxSize(500, 26), 0 );
    item3->Add(item4, 0, wxALIGN_LEFT|wxALL, 5);

    wxStaticText* item5 = new wxStaticText( item1, wxID_STATIC, _("For a film, you can remark about its length, story, its language, or whether it is a fake release."), wxDefaultPosition, wxDefaultSize, 0 );
    item3->Add(item5, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxBOTTOM|wxADJUST_MINSIZE, 5);

    wxBoxSizer* item6 = new wxBoxSizer(wxHORIZONTAL);
    item2->Add(item6, 0, wxGROW|wxALL, 5);

    wxStaticBox* item7Static = new wxStaticBox(item1, wxID_ANY, _("File quality"));
    wxStaticBoxSizer* item7 = new wxStaticBoxSizer(item7Static, wxVERTICAL);
    item6->Add(item7, 1, wxALIGN_BOTTOM|wxALL, 5);

    wxString* item8Strings = NULL;
    wxComboBox* item8 = new wxComboBox( item1, IDC_RATELIST, _T(""), wxPoint(24, 200), wxSize(255, 100), 0, item8Strings, wxCB_DROPDOWN );
    item7->Add(item8, 0, wxALIGN_LEFT|wxALL, 5);

    wxStaticText* item9 = new wxStaticText( item1, wxID_STATIC, _("Choose the file's rating or advise others if the file is invalid!"), wxDefaultPosition, wxDefaultSize, 0 );
    item7->Add(item9, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxBOTTOM|wxADJUST_MINSIZE, 5);

    wxBoxSizer* item10 = new wxBoxSizer(wxVERTICAL);
    item6->Add(item10, 0, wxALIGN_BOTTOM|wxALL, 5);

    wxButton* item11 = new wxButton( item1, wxID_OK, _("Apply"), wxPoint(211, 268), wxSize(82, 24), 0 );
    item10->Add(item11, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

    wxButton* item12 = new wxButton( item1, wxID_CANCEL, _("Cancel"), wxPoint(302, 268), wxSize(87, 24), 0 );
    item10->Add(item12, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

    item1->SetSizerAndFit(item2);
    item1->SetAutoLayout(TRUE);
#endif

    Center();
    ratebox = GetDlgItem(IDC_RATELIST, wxComboBox);
    OnInitDialog();
}

CCommentDialog::~CCommentDialog()
{
}

void CCommentDialog::OnBnClickedApply(wxCommandEvent &evt)
{
    wxString SValue;
    SValue = GetDlgItem(IDC_CMT_TEXT, wxTextCtrl)->GetValue();
    m_file->SetFileComment(wxString(SValue));
    m_file->SetFileRate((int8_t) ratebox->GetSelection());
    EndModal(0);
}

bool CCommentDialog::OnInitDialog()
{
    Localize();
    GetDlgItem(IDC_CMT_TEXT, wxTextCtrl)->SetValue(m_file->GetFileComment());
    GetDlgItem(IDC_CMT_TEXT, wxTextCtrl)->SetMaxLength(50);
    return TRUE;
}

void CCommentDialog::Localize(void)
{
    while (ratebox->GetCount() > 0)
    {
        ratebox->Delete(0);
    }

    ratebox->Append(GetResString(IDS_CMT_NOTRATED));
    ratebox->Append(GetResString(IDS_CMT_FAKE));
    ratebox->Append(GetResString(IDS_CMT_POOR));
    ratebox->Append(GetResString(IDS_CMT_GOOD));
    ratebox->Append(GetResString(IDS_CMT_FAIR));
    ratebox->Append(GetResString(IDS_CMT_EXCELLENT));
    ratebox->SetSelection(m_file->GetFileRate());

    wxString strTitle;
    strTitle.Printf(GetResString(IDS_CMT_TITLE), wxString(m_file->GetFileName(), *wxConvCurrent).GetData());
    SetTitle(strTitle);
}

