// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef _EMSOCKET_H_
#define _EMSOCKET_H_

#include "mfc.h"                            // CList - 4 Nov 2004

#include <stdint.h>                         // uint16_t
#include <wx/socket.h>                      // wxSocketClient

class Packet;

#define ERR_WRONGHEADER 0x01
#define ERR_TOOBIG      0x02

#define ES_DISCONNECTED 0xFF
#define ES_NOTCONNECTED 0x00
#define ES_CONNECTED    0x01

#define PACKET_HEADER_SIZE 6

class CEMSocket : public wxSocketClient
{
    DECLARE_DYNAMIC_CLASS(CEMSocket)
public:
    CEMSocket();
    ~CEMSocket();

    // controlpackets have a higher priority
    bool SendPacket(Packet* packet, bool delpacket = true, bool controlpacket = true);

    bool IsBusy() { return sendbuffer; }
    bool IsConnected() { return (byConnected==ES_CONNECTED); }
    uint8_t GetConState() { return byConnected; }
    void SetDownloadLimit(uint32_t limit);
    void DisableDownloadLimit();
    bool AsyncSelect(long lEvent);

    virtual void PacketReceived(Packet* packet) {}
    virtual void OnError(int nErrorCode) {}
    virtual void OnClose(int nErrorCode);
    virtual void OnSend(int nErrorCode);
    virtual void OnReceive(int nErrorCode);
    uint8_t byConnected;

    private:
    void ClearQueues();
    int Send(char* lpBuf,int nBufLen,int nFlags = 0);

    uint32_t downloadlimit;
    bool limitenabled;
    bool pendingOnReceive;

    // Download partial header
    char* pendingHeader[PACKET_HEADER_SIZE];
    uint32_t pendingHeaderSize;

    // Download partial packet
    Packet* pendingPacket;
    uint32_t pendingPacketSize;

    char* sendbuffer;
    uint32_t sendblen;
    uint32_t sent;
    bool m_bLinkedPackets;

    CList<Packet*, Packet*> controlpacket_queue;
    CList<Packet*, Packet*> standartpacket_queue;
};

#endif // _EMSOCKET_H_
