// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef _FRIENDLIST_H_
#define _FRIENDLIST_H_

#include <stdint.h>                    // uint16_t uint32_t
#include <wx/list.h>                   // wxList

class CFriend;
class CFriendListCtrl;
class CUpDownClient;

WX_DECLARE_LIST(CFriend, FriendList);

class CFriendList
{
public:
    CFriendList();
    ~CFriendList();

    bool IsAlreadyFriend( uint32_t tm_dwLastUsedIP, uint32_t tm_nLastUsedPort );
    void SaveList();
    bool LoadList();
    void RefreshFriend(CFriend* torefresh);
    CFriend* LinkFriend(unsigned char* achUserHash, uint32_t m_dwIp, uint16_t m_nPort);
    void SetWindow(CFriendListCtrl* NewWnd)  {m_wndOutput = NewWnd;}
    void ShowFriends();
    void AddFriend(CUpDownClient* toadd);
    void AddFriend( unsigned char tm_abyUserhash[16], uint32_t tm_dwLastSeen, uint32_t tm_dwLastUsedIP, uint32_t tm_nLastUsedPort, uint32_t tm_dwLastChatted, wxString tm_strName, uint32_t tm_dwHasHash);
    void RemoveFriend(CFriend* todel);
    void RemoveAllFriendSlots();
    void Process();

private:
    FriendList m_listFriends;
    CFriendListCtrl* m_wndOutput;
    uint32_t m_nLastSaved;
};

#endif // _FRIENDLIST_H_
