// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef _IPFILTER_H
#define _IPFILTER_H

#include "mfc.h"                       // CArray

#include <wx/string.h>                 // wxString
#include <stdint.h>                    // uint32_t

struct IPRange_Struct
{
    uint32_t  IPstart;
    uint32_t  IPend;
    uint8_t   filter;
    wxString  description;
};

class CIPFilter
{
public:
	CIPFilter();
	~CIPFilter();
	void	AddBannedIPRange(uint32_t IPfrom,uint32_t IPto,uint8_t filter, wxString desc);
	void	RemoveAllIPs();
	int		LoadFromFile();
	void	SaveToFile();
	bool	IsFiltered(uint32_t IP2test);
	wxString GetLastHit()				{ return lasthit;}
	uint16_t	BanCount()					{ return iplist.GetCount(); }
private:
	wxString lasthit;
	//CMutex m_Mutex;
	CArray<IPRange_Struct*,IPRange_Struct*> iplist;
};

#endif
