// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifdef PRECOMP
#	include "xmule-headers.h"
#else
#	include "KnownFile.h"
#	include "KnownFileList.h"
#	include "otherfunctions.h"
#	include "SafeFile.h"
#	include "wintypes.h"
#	include "xmule.h"
#endif

#include <wx/utils.h>
#include <sstream>
#include <iomanip>

using std::setfill;
using std::setw;
using std::hex;

static wxString KnownFileHash(const wxString filename, uint32_t date, uint32_t size)
{
    std::ostringstream internalbuffer;
    internalbuffer << filename << setfill('0') << setw(8) << hex << static_cast<long unsigned int>(date) << setfill('0') << setw(8) << hex << static_cast<long unsigned int>(size);
    return wxString(internalbuffer.str().c_str(), *wxConvCurrent);
}

static wxString KnownFileHash(CKnownFile *file)
{
    return KnownFileHash(file->GetFileName(), file->GetFileDate(), file->GetFileSize());
}

CKnownFileList::CKnownFileList(const char *in_appdir)
{
    appdir = nstrdup(in_appdir);
    accepted = 0;
    requested = 0;
    transfered = 0;
    Init();
}

CKnownFileList::~CKnownFileList()
{
    // TODO: Rather find the source of the lock leakage
    //	list_mut.Unlock();
    Clear();
}

bool CKnownFileList::Init()
{
    CKnownFile *Record = 0;
    CSafeFile file;
    /*try*/
    {
        wxString fullpath;
        std::ostringstream internalbuffer;
        internalbuffer << appdir << "known.met";
        fullpath = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
        if (!wxFileExists(fullpath))
        {
            //CFile::modeRead|CFile::osSequentialScan)) {
            delete[] fullpath;
            return false;
        }
        uint8_t header;
        file.Open(fullpath);
        file.Read( &header, 1);
        if (header != MET_HEADER)
        {
            file.Close();
            return false;
        }
        //CSingleLock sLock(&list_mut,true); // to make sure that its thread-safe
        wxMutexLocker sLock(list_mut);
        uint32_t RecordsNumber;
        file.Read( &RecordsNumber, 4);
        for (uint32_t i = 0 ; i != RecordsNumber ; i++)
        {
            Record = new CKnownFile();
            Record->LoadFromFile( &file);
            if (!Append(Record))
            delete Record;
        }
        //sLock.Unlock();
        file.Close();
        return true;
    }
#if 0
    catch(CFileException *error)
    {
        if (error->m_cause == CFileException::endOfFile)
        theApp.xmuledlg->AddLogLine(true, GetResString(IDS_ERR_SERVERMET_BAD));
        else
        {
            char buffer[150];
            error->GetErrorMessage(buffer, 150);
            theApp.xmuledlg->AddLogLine(true, GetResString(IDS_ERR_SERVERMET_UNKNOWN), buffer);
        }
        //memleak fix:
        error->Delete();
        return false;
    }
#endif
}

void CKnownFileList::Save()
{
    FILE *file = 0;
    char *fullpath = new char[strlen(appdir) + 1024];
    strcpy(fullpath, appdir);
    strcat(fullpath, "known.met");
    if (! (file = fopen(fullpath, "wb")))
    {
        delete[] fullpath;
        fullpath = NULL;
        return;
    }
    delete[] fullpath;
    fullpath = NULL;
    wxMutexLocker sLock(list_mut);
    fputc(MET_HEADER, file);
    uint32_t RecordsNumber = m_map.size();
    fwrite( &RecordsNumber, 4, 1, file);
    KnownFileMap::iterator it = m_map.begin();
    for (uint32_t i = 0 ; i != RecordsNumber ; i++, it++)
    {
        if (it == m_map.end())
        // TODO: Throw an exception:
        break;
        it->second->WriteToFile(file);
    }
    fclose(file);
}

void CKnownFileList::Clear()
{
    wxMutexLocker sLock(list_mut);
    for (KnownFileMap::iterator it = m_map.begin() ; it != m_map.end() ; it++)
    delete it->second;
    m_map.clear();
    delete[] appdir;
}

CKnownFile *CKnownFileList::FindKnownFile(const wxString filename, uint32_t in_date, uint32_t in_size)
{
    wxMutexLocker sLock(list_mut);
    KnownFileMap::iterator it = m_map.find(KnownFileHash(filename, in_date, in_size));
    if (it != m_map.end())
    return it->second;
    return 0;
}

bool CKnownFileList::SafeAddKFile(CKnownFile *toadd)
{
    wxMutexLocker sLock(list_mut);
    return Append(toadd);
}

bool CKnownFileList::Append(CKnownFile *Record)
{
    wxString HashString = KnownFileHash(Record);
    KnownFileMap::iterator it = m_map.find(HashString);
    if (it == m_map.end())
    {
        m_map[HashString] = Record;
        return true;
    }
    else
    {
        return false;
    }
}

