// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef KNOWNFILELIST_H
#define KNOWNFILELIST_H

class CKnownFile;
#include "xmule.h"

#include <wx/hashmap.h>
WX_DECLARE_HASH_MAP(wxString,CKnownFile*,wxStringHash,wxStringEqual,KnownFileMap);

class CKnownFileList
{
//	friend class CSharedFilesWnd;
//	friend class CFileStatistic;
public:
	CKnownFileList(const char* in_appdir);
	~CKnownFileList();
	bool	SafeAddKFile(CKnownFile* toadd);
	bool	Init();
	void	Save();
	void	Clear();
	CKnownFile*	FindKnownFile(const wxString filename,uint32_t in_date,uint32_t in_size);


	uint16_t requested;
	uint32_t transfered;
	uint16_t accepted;

private:
	wxMutex	list_mut;

	bool	Append(CKnownFile*);
	char*	appdir;

	KnownFileMap	m_map;
};



#endif
