// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef _NEWFUNCTIONS
#define _NEWFUNCTIONS

#include <stdint.h>                         // uint32_t

#define		MAPCLIENTS_MAX		30000

typedef struct _MAP
{
	_MAP*	next;
	_MAP* 	prev;
	long int Data;
	long int Data2;
	unsigned char *Key;
}

MAP;

extern uint32_t globaldata2;

extern MAP* ToDelete_ClientReqSockets;
extern MAP* ToDelete_UpDownClients;

uint32_t MapData(MAP* pos);
unsigned char *MapDataKey(MAP* pos);
void MapData_Init(MAP *&base);
MAP* MapData_Find(MAP* base,void *tofind, int length);
uint32_t MapData_GetCount(MAP *base);
void *MapData_GetIt(MAP* pos);
MAP* MapData_GetNext(MAP* next);
void MapData_Append(MAP *base,void *data, void *key=NULL, int length=0);
void MapData_Insert(MAP *base,void *data, void *key=NULL, int length=0);
MAP* MapData_Remove(MAP *base,MAP *todelete);
void MapData_RemoveAll(MAP* base);

#endif
