// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef _QUEUELISTCTRL_H_
#define _QUEUELISTCTRL_H_

#include "MuleListCtrl.h"              // CMuleListCtrl

#include <stdint.h>                    // uint32_t
#include <sys/timeb.h>

class CUpDownClient;

#define SW_HIDE 1
#define SW_SHOW 2

class CQueueListCtrl : public CMuleListCtrl
{
  //DECLARE_DYNAMIC(CQueueListCtrl)

public:
	CQueueListCtrl();
	CQueueListCtrl(wxWindow*& parent,int id,const wxPoint& pos,wxSize siz,int flags);

	virtual ~CQueueListCtrl();
	void	Init();
	void InitSort();
	void	AddClient(CUpDownClient* client);
	void	RemoveClient(CUpDownClient* client);
	void	RefreshClient(CUpDownClient* client);
	void	Hide() {/*ShowWindow(SW_HIDE);*/}
	void	Visable() {/*ShowWindow(SW_SHOW);*/}
	void	Localize();

	//virtual bool OnCommand(WPARAM wParam,LPARAM lParam );
protected:
	/*
	static int CALLBACK SortProc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort);
	afx_msg	void OnColumnClick( NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnNMRclick(NMHDR *pNMHDR, LRESULT *pResult);
	DECLARE_MESSAGE_MAP()
	*/
	static int SortProc(long lp1,long lp2,long lpsort);
	void OnNMRclick(wxMouseEvent& evt);
	void OnColumnClick(wxODListEvent& evt);
	bool ProcessEvent(wxEvent& evt);
	virtual void OnDrawItem(int item,wxDC* dc,const wxRect& rc,const wxRect& rectHL,bool hl);

private:
	bool		 asc_sort[8];	 
	wxImageList imagelist;
	wxMenu*	   m_ClientMenu;
	// Barry - Refresh the queue every 10 seconds
	wxTimer  m_hTimer;
 public:
	static void  QueueUpdateTimer(); //HWND hwnd, x::UINT uiMsg, x::UINT idEvent, x::DWORD dwTime);
	void OnTimer(wxTimerEvent& evt);

	void	ShowSelectedUserDetails();
	wxBrush* m_hilightBrush,*m_hilightUnfocusBrush;
DECLARE_EVENT_TABLE()
};

#endif // _QUEUELISTCTRL_H_
