// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifdef PRECOMP
#	include "xmule-headers.h"
#else
#	include "wintypes.h"
#	include "SafeFile.h"
#endif

CSafeFile::CSafeFile(x::LPCSTR lpszFileName, x::UINT nOpenFlags)
: CFile(wxString(lpszFileName, *wxConvCurrent), (CFile::OpenMode) nOpenFlags)
//:CFile(lpszFileName,nOpenFlags)
{
    // Nothing to do here
}

CSafeFile::CSafeFile(): CFile()
{
}

x::UINT CSafeFile::Read(void *lpBuf, x::UINT nCount)
{
    if (Tell() + nCount > Length())
    {
        //		AfxThrowFileException(CFileException::endOfFile,0,GetFileName());
        return(x::UINT) - 1;
    }
    return CFile::Read(lpBuf, nCount);
}

CSafeMemFile::CSafeMemFile(x::BYTE *lpBuffer, x::UINT nBufferSize, x::UINT nGrowBytes)
: CMemFile(lpBuffer, nBufferSize, nGrowBytes)
{
    // Nothing to do here
}

CSafeMemFile::CSafeMemFile(x::UINT nGrowBytes): CMemFile(nGrowBytes)
{
}

x::UINT CSafeMemFile::Read(void *lpBuf, x::UINT nCount)
{
    if (GetPosition() + nCount > this->GetLength())
    {
        //		AfxThrowFileException(CFileException::endOfFile,0,GetFileName());
        return 0;
    }
    return CMemFile::Read(lpBuf, nCount);
}

