// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef _SHAREDFILESLIST_H
#define _SHAREDFILESLIST_H

#include "MapKey.h"                         // Needed for CCKey - audited 5 Nov 2004
#include "mfc.h"                            // Needed for CTypedPtrList - audited 4 Nov 2004

#include <map>                              // Needed for std::map
#include <stdint.h>                         // Needed for uint32_t
#include <wx/thread.h>                      // Needed for wxMutex

class CAddFileThread;
class CKnownFile;
class CKnownFileList;
class CMemFile;
class CPreferences;
class CServerConnect;
class CSharedFilesCtrl;
struct UnknownFile_Struct;

typedef std::map<CCKey, CKnownFile*> CKnownFileMap;

class CSharedFileList
{
    friend class CSharedFilesCtrl;
    friend class CClientReqSocket;
public:
    CSharedFileList(CPreferences* in_prefs, CServerConnect* in_server, CKnownFileList* in_filelist);
    ~CSharedFileList();
    void SendListToServer();
    void Reload(bool sendtoserver = true, bool firstload = false);
    void SafeAddKFile(CKnownFile* toadd, bool bOnlyAdd = false);
    void SetOutputCtrl(CSharedFilesCtrl* in_ctrl);
    void RemoveFile(CKnownFile* toremove);
    wxMutex list_mut;
    CKnownFile* GetFileByID(unsigned char* filehash);
    short GetFilePriorityByID(unsigned char* filehash);
    CKnownFile* GetFileByIndex(int index);
    CKnownFileList* filelist;
    void CreateOfferedFilePacket(CKnownFile* cur_file,CMemFile* files);
    uint64_t GetDatasize();

    uint16_t GetCount()
    {
        return m_Files_map.size();
    }

    void UpdateItem(CKnownFile* toupdate);
    void AddFilesFromDirectory(const wxString& directory);
    void GetSharedFilesByDirectory(const wxString& directory, CTypedPtrList<CPtrList, CKnownFile*>& list);

private:
    void FindSharedFiles();

    CKnownFileMap m_Files_map;
    CPreferences* app_prefs;
    CServerConnect* server;
    CSharedFilesCtrl* output;
    CAddFileThread* m_Thread;
};

#endif
