// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifdef PRECOMP
#	include "xmule-headers.h"
#else
#	include "ClientList.h"
#	include "DownloadQueue.h"
#include "ListenSocket.h"                   // CListenSocket - audited 5 Nov 2004
#	include "muuli_wdr.h"
#include "Preferences.h"                    // CPreferences::GetStatsColor
#include "ServerList.h"                     // Need for CServerList - audited 5 Nov 2004
#include "SharedFileList.h"                 // Needed for CSharedFileList
#include "sockets.h"                        // Needed for CServerConnect - audited 5 Nov 2004
#	include "StatisticsDlg.h"
#	include "UploadQueue.h"
#	include "xmule.h"
#endif

#include <DynPrefs/DynPrefs.h>              // Needed for DynamicPreferences

#include <map>                              // std::map
#include <wx/settings.h>
#include <wx/sizer.h>                       // Needed for wxSizer
#include <wx/stattext.h>                    // wxStaticText
#include <iostream>
#include <sstream>
#include <iomanip>

using std::cout;
using std::endl;
using std::setprecision;
using std::setw;
using std::hex;
using std::uppercase;

#define ID_EXPORT_HTML 20001

BEGIN_EVENT_TABLE(CStatisticsDlg, wxPanel)
   EVT_MENU(ID_EXPORT_HTML, CStatisticsDlg::ExportHTMLEvent)
END_EVENT_TABLE()

CStatisticsDlg::CStatisticsDlg(wxWindow *pParent):
   wxPanel(pParent, CStatisticsDlg::IDD)
{
    SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOWFRAME));
    wxSizer *content = statsDlg(this, TRUE);
    content->Show(this, TRUE);
    m_DownloadOMeter = dynamic_cast<COScopeCtrl *>(FindWindowByName(wxT("dloadScope")));
    m_UploadOMeter = dynamic_cast<COScopeCtrl *>(FindWindowByName(wxT("uloadScope")));
    m_Statistics = dynamic_cast<COScopeCtrl *>(FindWindowByName(wxT("otherScope")));
    stattree = dynamic_cast<wxTreeCtrl *>(FindWindowByName(wxT("statTree")));
#if 0
    COScopeCtrl *tmp = new COScopeCtrl(3, this);
    testSizer->Add(tmp, 1, wxGROW |wxALL |wxALIGN_CENTRE |wxLEFT, 5);
    testSizer->Layout();
    m_DownloadOMeter = *tmp;

    // let's play around a bit
    // can't. preferences are created later
    m_DownloadOMeter->SetRange(0, DynPrefs::Get<long>("capacities-download") + 4, 0);
    m_DownloadOMeter->SetRange(0, DynPrefs::Get<long>("capacities-download") + 4, 1);
    m_DownloadOMeter->SetRange(0, DynPrefs::Get<long>("capacities-download") + 4, 2);
    m_DownloadOMeter->SetYUnits(GetResString(IDS_KBYTESEC));
#endif

    maxDownavg = 0.0;
}

CStatisticsDlg::~CStatisticsDlg()
{
}

void CStatisticsDlg::Init()
{
    // called after preferences get initialised
    m_DownloadOMeter->SetBackgroundColor(RGB(0, 0, 64));
    m_DownloadOMeter->SetGridColor(RGB(192, 192, 255));
    m_DownloadOMeter->SetRange(0, DynPrefs::Get<long>("capacities-download") + 4, 0);
    m_DownloadOMeter->SetRange(0, DynPrefs::Get<long>("capacities-download") + 4, 1);
    m_DownloadOMeter->SetRange(0, DynPrefs::Get<long>("capacities-download") + 4, 2);
    m_DownloadOMeter->SetPlotColor(RGB(0, 128, 0), 0);
    m_DownloadOMeter->SetPlotColor(RGB(0, 210, 0), 1);
    m_DownloadOMeter->SetPlotColor(RGB(128, 255, 128), 2);
    m_DownloadOMeter->SetYUnits(GetResString(IDS_KBYTESEC));
    m_UploadOMeter->SetBackgroundColor(RGB(0, 0, 64));
    m_UploadOMeter->SetGridColor(RGB(192, 192, 255));
    m_UploadOMeter->SetRange(0, DynPrefs::Get<long>("capacities-upload") + 4, 0);
    m_UploadOMeter->SetRange(0, DynPrefs::Get<long>("capacities-upload") + 4, 1);
    m_UploadOMeter->SetRange(0, DynPrefs::Get<long>("capacities-upload") + 4, 2);
    m_UploadOMeter->SetPlotColor(RGB(140, 0, 0), 0);
    m_UploadOMeter->SetPlotColor(RGB(200, 0, 0), 1);
    m_UploadOMeter->SetPlotColor(RGB(255, 128, 128), 2);
    m_UploadOMeter->SetYUnits(GetResString(IDS_KBYTESEC));
    m_Statistics->SetBackgroundColor(RGB(0, 0, 64));
    m_Statistics->SetGridColor(RGB(192, 192, 255));
    m_Statistics->SetRanges(0, 100);
    // This does not work!
    //  m_Statistics->autofitYscale=true;
    m_Statistics->autofitYscale = false;
    m_Statistics->SetPlotColor(RGB(192, 0, 192), 0);
    m_Statistics->SetPlotColor(RGB(150, 150, 255), 1);
    m_Statistics->SetPlotColor(RGB(255, 192, 255), 2);
    m_Statistics->SetPlotColor(RGB(255, 255, 128), 3);
    m_Statistics->SetYUnits(wxT(""));
    m_Statistics->SetXUnits(GetResString(IDS_TIME));
    // setup tree
    wxTreeItemId root = stattree->AddRoot(_("Statistics"));
    h_uptime = stattree->InsertItem(root, 0L, GetResString(IDS_FSTAT_WAITING));
    h_transfer = stattree->AppendItem(root, GetResString(IDS_FSTAT_TRANSFER));
    tran0 = stattree->AppendItem(h_transfer, GetResString(IDS_FSTAT_WAITING));
    h_upload = stattree->AppendItem(h_transfer, GetResString(IDS_TW_UPLOADS));
    up1 = stattree->AppendItem(h_upload, GetResString(IDS_FSTAT_WAITING));
    up2 = stattree->AppendItem(h_upload, GetResString(IDS_FSTAT_WAITING));
    up3 = stattree->AppendItem(h_upload, GetResString(IDS_FSTAT_WAITING));
    up4 = stattree->AppendItem(h_upload, GetResString(IDS_FSTAT_WAITING));
    up5 = stattree->AppendItem(h_upload, GetResString(IDS_FSTAT_WAITING));
    up6 = stattree->AppendItem(h_upload, GetResString(IDS_FSTAT_WAITING));
    up7 = stattree->AppendItem(h_upload, GetResString(IDS_FSTAT_WAITING));
    up8 = stattree->AppendItem(h_upload, GetResString(IDS_FSTAT_WAITING));
    up9 = stattree->AppendItem(h_upload, GetResString(IDS_FSTAT_WAITING));
    up10 = stattree->AppendItem(h_upload, GetResString(IDS_FSTAT_WAITING));
    h_download = stattree->AppendItem(h_transfer, GetResString(IDS_TW_DOWNLOADS));
    down1 = stattree->AppendItem(h_download, GetResString(IDS_FSTAT_WAITING));
    down2 = stattree->AppendItem(h_download, GetResString(IDS_FSTAT_WAITING));
    down3 = stattree->AppendItem(h_download, GetResString(IDS_FSTAT_WAITING));
    down4 = stattree->AppendItem(h_download, GetResString(IDS_FSTAT_WAITING));
    down5 = stattree->AppendItem(h_download, GetResString(IDS_FSTAT_WAITING));
    down6 = stattree->AppendItem(h_download, GetResString(IDS_FSTAT_WAITING));
    down7 = stattree->AppendItem(h_download, GetResString(IDS_FSTAT_WAITING));
    h_connection = stattree->AppendItem(root, GetResString(IDS_FSTAT_CONNECTION));
    con1 = stattree->AppendItem(h_connection, GetResString(IDS_FSTAT_WAITING));
    con2 = stattree->AppendItem(h_connection, GetResString(IDS_FSTAT_WAITING));
    con12 = stattree->AppendItem(h_connection, GetResString(IDS_FSTAT_WAITING));
    con13 = stattree->AppendItem(h_connection, GetResString(IDS_FSTAT_WAITING));
    con3 = stattree->AppendItem(h_connection, GetResString(IDS_FSTAT_WAITING));
    con4 = stattree->AppendItem(h_connection, GetResString(IDS_FSTAT_WAITING));
    con5 = stattree->AppendItem(h_connection, GetResString(IDS_FSTAT_WAITING));
    con6 = stattree->AppendItem(h_connection, GetResString(IDS_FSTAT_WAITING));
    con7 = stattree->AppendItem(h_connection, GetResString(IDS_FSTAT_WAITING));
    con8 = stattree->AppendItem(h_connection, GetResString(IDS_FSTAT_WAITING));
    con9 = stattree->AppendItem(h_connection, GetResString(IDS_FSTAT_WAITING));
    h_clients = stattree->AppendItem(root, GetResString(IDS_CLIENTS));
    cli1 = stattree->AppendItem(h_clients, GetResString(IDS_FSTAT_WAITING));
    cli_versions[0] = stattree->AppendItem(cli1, GetResString(IDS_FSTAT_WAITING));
    cli_versions[1] = stattree->AppendItem(cli1, GetResString(IDS_FSTAT_WAITING));
    cli_versions[2] = stattree->AppendItem(cli1, GetResString(IDS_FSTAT_WAITING));
    cli_versions[3] = stattree->AppendItem(cli1, GetResString(IDS_FSTAT_WAITING));
    cli8 = stattree->AppendItem(h_clients, GetResString(IDS_FSTAT_WAITING));
    //  cli10= stattree->AppendItem(h_clients,GetResString(IDS_FSTAT_WAITING));
    cli2 = stattree->AppendItem(h_clients, GetResString(IDS_FSTAT_WAITING));
    cli_versions[4] = stattree->AppendItem(cli2, GetResString(IDS_FSTAT_WAITING));
    cli_versions[5] = stattree->AppendItem(cli2, GetResString(IDS_FSTAT_WAITING));
    cli_versions[6] = stattree->AppendItem(cli2, GetResString(IDS_FSTAT_WAITING));
    cli_versions[7] = stattree->AppendItem(cli2, GetResString(IDS_FSTAT_WAITING));
    cli3 = stattree->AppendItem(h_clients, GetResString(IDS_FSTAT_WAITING));
    cli_versions[8] = stattree->AppendItem(cli3, GetResString(IDS_FSTAT_WAITING));
    cli_versions[9] = stattree->AppendItem(cli3, GetResString(IDS_FSTAT_WAITING));
    cli_versions[10] = stattree->AppendItem(cli3, GetResString(IDS_FSTAT_WAITING));
    cli_versions[11] = stattree->AppendItem(cli3, GetResString(IDS_FSTAT_WAITING));
    cli4 = stattree->AppendItem(h_clients, GetResString(IDS_FSTAT_WAITING));
    cli5 = stattree->AppendItem(h_clients, GetResString(IDS_FSTAT_WAITING));
    cli9 = stattree->AppendItem(h_clients, GetResString(IDS_FSTAT_WAITING));
    cli6 = stattree->AppendItem(h_clients, GetResString(IDS_FSTAT_WAITING));
    cli7 = stattree->AppendItem(h_clients, GetResString(IDS_STATS_FILTEREDCLIENTS));
    h_servers = stattree->AppendItem(root, GetResString(IDS_FSTAT_SERVERS));
    srv1 = stattree->AppendItem(h_servers, GetResString(IDS_FSTAT_WAITING));
    srv2 = stattree->AppendItem(h_servers, GetResString(IDS_FSTAT_WAITING));
    srv3 = stattree->AppendItem(h_servers, GetResString(IDS_FSTAT_WAITING));
    srv4 = stattree->AppendItem(h_servers, GetResString(IDS_FSTAT_WAITING));
    srv5 = stattree->AppendItem(h_servers, GetResString(IDS_FSTAT_WAITING));
    srv6 = stattree->AppendItem(h_servers, GetResString(IDS_FSTAT_WAITING));
    srv7 = stattree->AppendItem(h_servers, GetResString(IDS_FSTAT_WAITING));
    srv8 = stattree->AppendItem(h_servers, GetResString(IDS_FSTAT_WAITING));
    srv9 = stattree->AppendItem(h_servers, GetResString(IDS_FSTAT_WAITING));
    h_shared = stattree->AppendItem(root, GetResString(IDS_SHAREDFILES));
    shar1 = stattree->AppendItem(h_shared, GetResString(IDS_FSTAT_WAITING));
    shar2 = stattree->AppendItem(h_shared, GetResString(IDS_FSTAT_WAITING));
    shar3 = stattree->AppendItem(h_shared, GetResString(IDS_FSTAT_WAITING));
    stattree->Expand(root);
    stattree->Expand(h_uptime);
    //,TVE_EXPAND);:
    stattree->Expand(h_transfer);
    //,TVE_EXPAND);:
    stattree->Expand(h_connection);
    //,TVE_EXPAND);:
    stattree->Expand(h_clients);
    //,TVE_EXPAND);:
    stattree->Expand(h_servers);
    // ,TVE_EXPAND);:
    stattree->Expand(h_shared);
    //,TVE_EXPAND);:
    stattree->Expand(h_upload);
    //,TVE_EXPAND);:
    stattree->Expand(h_download);
    RepaintMeters();
    m_ilastMaxConnReached = 0;
    peakconnections = 0;
    totalconnectionchecks = 0;
    averageconnections = 0;
    activeconnections = 0;
    maxDown = 0;
}

void CStatisticsDlg::RepaintMeters()
{
    m_DownloadOMeter->SetBackgroundColor(theApp.glob_prefs->GetStatsColor(0));
    m_DownloadOMeter->SetGridColor(theApp.glob_prefs->GetStatsColor(1));
    m_DownloadOMeter->SetPlotColor(theApp.glob_prefs->GetStatsColor(4), 0);
    m_DownloadOMeter->SetPlotColor(theApp.glob_prefs->GetStatsColor(3), 1);
    m_DownloadOMeter->SetPlotColor(theApp.glob_prefs->GetStatsColor(2), 2);
    m_UploadOMeter->SetBackgroundColor(theApp.glob_prefs->GetStatsColor(0));
    m_UploadOMeter->SetGridColor(theApp.glob_prefs->GetStatsColor(1));
    m_UploadOMeter->SetPlotColor(theApp.glob_prefs->GetStatsColor(7), 0);
    m_UploadOMeter->SetPlotColor(theApp.glob_prefs->GetStatsColor(6), 1);
    m_UploadOMeter->SetPlotColor(theApp.glob_prefs->GetStatsColor(5), 2);
    m_Statistics->SetBackgroundColor(theApp.glob_prefs->GetStatsColor(0));
    m_Statistics->SetGridColor(theApp.glob_prefs->GetStatsColor(1));
    m_Statistics->SetPlotColor(theApp.glob_prefs->GetStatsColor(10), 0);
    m_Statistics->SetPlotColor(theApp.glob_prefs->GetStatsColor(8), 1);
    //m_Statistics.SetPlotColor( theApp.glob_prefs->GetStatsColor(10),2) ;
    m_Statistics->SetPlotColor(theApp.glob_prefs->GetStatsColor(9), 3);
    SetupLegend(IDC_C0_2, 0, 1);
    SetupLegend(IDC_C0_3, 1, 1);
    SetupLegend(IDC_C0, 2, 1);
    SetupLegend(IDC_C1_2, 0, 2);
    SetupLegend(IDC_C1_3, 1, 2);
    SetupLegend(IDC_C1, 2, 2);
    SetupLegend(IDC_S0, 1, 3);
    SetupLegend(IDC_S1, 0, 3);
    //SetupLegend( IDC_S2, 2 ,3);
    SetupLegend(IDC_S3, 3, 3);
}

void CStatisticsDlg::SetupLegend(int ResIdx, int ElmtIdx, int legendNr)
{
    //CRect Rect;
    //GetDlgItem( ResIdx )->GetWindowRect( Rect );
    //ScreenToClient( Rect );
    wxPanel* ctrl = dynamic_cast<wxPanel *>(FindWindow(ResIdx));
    if (ctrl == NULL)
    {
        cout << "no control (" << ResIdx << ")"  << endl;
        exit(1);
    }
    if (legendNr == 1)
    {
        //m_Led1[ ElmtIdx ].Create( WS_VISIBLE | WS_CHILD, Rect, this );
        //m_Led1[ ElmtIdx ].SetBackgroundColor( m_DownloadOMeter.GetPlotColor( ElmtIdx ) );
        //m_Led1[ ElmtIdx ].SetFrameColor( RGB( 0x00, 0x00, 0x00 ) );
        ctrl->SetBackgroundColour((x::COLORREF) m_DownloadOMeter->GetPlotColor(ElmtIdx));
//        ctrl->SetFrameColor((x::COLORREF) RGB(0, 0, 0));
    }
    else if(legendNr == 2)
    {
        //m_Led2[ ElmtIdx ].Create( WS_VISIBLE | WS_CHILD, Rect, this );
        //m_Led2[ ElmtIdx ].SetBackgroundColor( m_UploadOMeter.GetPlotColor( ElmtIdx ) );
        //m_Led2[ ElmtIdx ].SetFrameColor( RGB( 0x00, 0x00, 0x00 ) );
        ctrl->SetBackgroundColour((x::COLORREF) m_UploadOMeter->GetPlotColor(ElmtIdx));
//        ctrl->SetFrameColor((x::COLORREF) RGB(0, 0, 0));
    }
    else if(legendNr == 3)
    {
        //m_Led3[ ElmtIdx ].Create( WS_VISIBLE | WS_CHILD, Rect, this );
        //m_Led3[ ElmtIdx ].SetBackgroundColor( m_Statistics.GetPlotColor( ElmtIdx ) );
        //m_Led3[ ElmtIdx ].SetFrameColor( RGB( 0x00, 0x00, 0x00 ) );
        ctrl->SetBackgroundColour((x::COLORREF) m_Statistics->GetPlotColor(ElmtIdx));
//        ctrl->SetFrameColor((x::COLORREF) RGB(0, 0, 0));
    }
}

void CStatisticsDlg::SetCurrentRate(float uploadrate, float downloadrate)
{
    // Update scaling of the active connections graph
    static uint32_t savedMaxConns;
    if (savedMaxConns != DynPrefs::Get<long>("max-connections"))
    {
        savedMaxConns = DynPrefs::Get<long>("max-connections");
        unsigned x = 1, by = 1;
        unsigned max = 100;
        if (savedMaxConns < max)
        {
            x = max / savedMaxConns;
            if (max < (x *savedMaxConns))
            x--;
            max = max / x;
        }
        else
        {
            by = (savedMaxConns + max - 1) / max;
            if ((by *max) < savedMaxConns)
            by++;
            max = max *by;
        }
        wxString txt = wxString::Format(GetResString(IDS_ST_ACTIVEC), x, by);
        wxStaticCast(wxWindow::FindWindowById(ID_ACTIVEC), wxStaticText)->SetLabel(txt);
        m_Statistics->SetRange(0, max, 1);
    }
    double m_dPlotDataUp[ 3 ];
    double m_dPlotDataDown[ 3 ];
    int myStats[6];
    // current rate
    m_dPlotDataDown[2] = downloadrate;
    m_dPlotDataUp[2] = uploadrate;
    if (maxDown < downloadrate) maxDown = downloadrate;
    // Websever [kuchin]
//    UpDown* updown = new UpDown();
//    updown->upload = uploadrate;
//    updown->download = downloadrate;
//    theApp.webserver->AddStatsLine(updown);
    // averages
    m_dPlotDataDown[0] = GetAvgDownloadRate(AVG_SESSION);
    m_dPlotDataUp[0] = GetAvgUploadRate(AVG_SESSION);
    m_dPlotDataDown[1] = GetAvgDownloadRate(AVG_TIME);
    m_dPlotDataUp[1] = GetAvgUploadRate(AVG_TIME);
    // show
    m_DownloadOMeter->AppendPoints(m_dPlotDataDown);
    m_UploadOMeter->AppendPoints(m_dPlotDataUp);
    // get Partialfiles summary
    activeconnections = theApp.listensocket->GetOpenSockets();
    theApp.downloadqueue->GetDownloadStats(myStats);
    m_dPlotDataMore[0] = theApp.uploadqueue->GetUploadQueueLength();
    //myStats[0];:
    m_dPlotDataMore[1] = activeconnections;
    //theApp.uploadqueue->GetWaitingUserCount();:
    m_dPlotDataMore[2] = 0;
    m_dPlotDataMore[3] = myStats[1];
    //for (int i=0;i<4;i++) if (m_dPlotDataMore[i]>theApp.glob_prefs->GetStatsMax()) {resize=true;theApp.glob_prefs->GetStatsMax()=(int)m_dPlotDataMore[i];}
    //if (resize) m_Statistics.SetRanges(0, theApp.glob_prefs->GetStatsMax()+15) ;
    m_Statistics->AppendPoints(m_dPlotDataMore);
}

void CStatisticsDlg::UpdateConnectionsStatus()
{
    if (peakconnections < activeconnections)
    peakconnections = activeconnections;
    if (theApp.serverconnect->IsConnected())
    {
        totalconnectionchecks++;
        float percent;
        percent = (float)((float)(totalconnectionchecks - 1) / (float) totalconnectionchecks);
        if (percent > .99)
        percent = (float) .99;
        averageconnections = (averageconnections *percent) + (float)((float) activeconnections * (float)(1 - percent));
    }
}

float CStatisticsDlg::GetMaxConperFiveModifier()
{
    //This is a alpha test.. Will clean up for b version.
    float SpikeSize = theApp.listensocket->GetOpenSockets() - averageconnections;
    if (SpikeSize < 1)
    return 1;
    float SpikeTolerance = 25.0 * static_cast<float>(DynPrefs::Get<long>("max-per-5")) / 10.0;
    if (SpikeSize > SpikeTolerance)
    return 0;
    float Modifier = (1 - (SpikeSize/SpikeTolerance));
    return Modifier;
}

void CStatisticsDlg::RecordRate()
{
    if (theApp.stat_transferStarttime == 0) return;
    // every second
    downrateHistory.push_front(theApp.stat_sessionReceivedBytes);
    uprateHistory.push_front(theApp.stat_sessionSentBytes);
    // limit to maxmins
    while ((int) downrateHistory.size() > (int)(DynPrefs::Get<long>("graph-average") * 60)) downrateHistory.pop_back();
    while ((int) uprateHistory.size() > (int)(DynPrefs::Get<long>("graph-average") * 60)) uprateHistory.pop_back();
}

void CStatisticsDlg::ShowStatistics()
{
    std::ostringstream internalbuffer;
    wxString cbuffer;
    wxString cbuffer2;
    bool resize;
    x::DWORD running;
    int myStats[11];
    float DownAvgRate;
    resize = false;
    theApp.downloadqueue->GetDownloadStats(myStats);
    uint64_t DownOHTotal = theApp.downloadqueue->GetDownDataOverheadFileRequest() + theApp.downloadqueue->GetDownDataOverheadSourceExchange() + theApp.downloadqueue->GetDownDataOverheadServer() + theApp.downloadqueue->GetDownDataOverheadOther();
    uint64_t DownOHTotalPackets = theApp.downloadqueue->GetDownDataOverheadFileRequestPackets() + theApp.downloadqueue->GetDownDataOverheadSourceExchangePackets() + theApp.downloadqueue->GetDownDataOverheadServerPackets() + theApp.downloadqueue->GetDownDataOverheadOtherPackets();
    cbuffer = wxT("Uptime: ");
    stattree->SetItemText(h_uptime, cbuffer);
    cbuffer.Printf(GetResString(IDS_STATS_DDATA), CastItoXBytes(theApp.stat_sessionReceivedBytes) .GetData(), CastItoXBytes(theApp.stat_sessionReceivedBytes + theApp.glob_prefs->GetTotalDownloaded()) .GetData());
    stattree->SetItemText(down1, cbuffer);
    cbuffer.Printf(GetResString(IDS_TOVERHEAD), CastItoXBytes(DownOHTotal) .GetData(), CastItoIShort(DownOHTotalPackets) .GetData());
    stattree->SetItemText(down2, cbuffer);
    cbuffer.Printf(GetResString(IDS_FROVERHEAD), CastItoXBytes(theApp.downloadqueue->GetDownDataOverheadFileRequest()) .GetData(), CastItoIShort(theApp.downloadqueue->GetDownDataOverheadFileRequestPackets()) .GetData());
    stattree->SetItemText(down3, cbuffer);
    cbuffer.Printf(GetResString(IDS_SSOVERHEAD), CastItoXBytes(theApp.downloadqueue->GetDownDataOverheadSourceExchange()) .GetData(), CastItoIShort(theApp.downloadqueue->GetDownDataOverheadSourceExchangePackets()) .GetData());
    stattree->SetItemText(down4, cbuffer);
    cbuffer.Printf(GetResString(IDS_SOVERHEAD), CastItoXBytes(theApp.downloadqueue->GetDownDataOverheadServer()) .GetData(), CastItoIShort(theApp.downloadqueue->GetDownDataOverheadServerPackets()) .GetData());
    stattree->SetItemText(down5, cbuffer);
    cbuffer.Printf(GetResString(IDS_STATS_FOUNDSRC), myStats[0]);
    stattree->SetItemText(down6, cbuffer);
    cbuffer.Printf(GetResString(IDS_STATS_ACTDL), myStats[1]);
    stattree->SetItemText(down7, cbuffer);
    uint64_t UpOHTotal = theApp.uploadqueue->GetUpDataOverheadFileRequest() + theApp.uploadqueue->GetUpDataOverheadSourceExchange() + theApp.uploadqueue->GetUpDataOverheadServer() + theApp.uploadqueue->GetUpDataOverheadOther();
    uint64_t UpOHTotalPackets = theApp.uploadqueue->GetUpDataOverheadFileRequestPackets() + theApp.uploadqueue->GetUpDataOverheadSourceExchangePackets() + theApp.uploadqueue->GetUpDataOverheadServerPackets() + theApp.uploadqueue->GetUpDataOverheadOtherPackets();
    cbuffer.Printf(GetResString(IDS_STATS_UDATA), CastItoXBytes(theApp.stat_sessionSentBytes) .GetData(), CastItoXBytes(theApp.stat_sessionSentBytes + theApp.glob_prefs->GetTotalUploaded()) .GetData());
    stattree->SetItemText(up1, cbuffer);
    cbuffer.Printf(GetResString(IDS_TOVERHEAD), CastItoXBytes(UpOHTotal) .GetData(), CastItoIShort(UpOHTotalPackets) .GetData());
    stattree->SetItemText(up2, cbuffer);
    cbuffer.Printf(GetResString(IDS_FROVERHEAD), CastItoXBytes(theApp.uploadqueue->GetUpDataOverheadFileRequest()) .GetData(), CastItoIShort(theApp.uploadqueue->GetUpDataOverheadFileRequestPackets()) .GetData());
    stattree->SetItemText(up3, cbuffer);
    cbuffer.Printf(GetResString(IDS_SSOVERHEAD), CastItoXBytes(theApp.uploadqueue->GetUpDataOverheadSourceExchange()) .GetData(), CastItoIShort(theApp.uploadqueue->GetUpDataOverheadSourceExchangePackets()) .GetData());
    stattree->SetItemText(up4, cbuffer);
    cbuffer.Printf(GetResString(IDS_SOVERHEAD), CastItoXBytes(theApp.uploadqueue->GetUpDataOverheadServer()) .GetData(), CastItoIShort(theApp.uploadqueue->GetUpDataOverheadServerPackets()) .GetData());
    stattree->SetItemText(up5, cbuffer);
    cbuffer.Printf(GetResString(IDS_STATS_ACTUL), theApp.uploadqueue->GetUploadQueueLength());
    stattree->SetItemText(up6, cbuffer);
    cbuffer.Printf(GetResString(IDS_STATS_WAITINGUSERS), theApp.uploadqueue->GetWaitingUserCount());
    stattree->SetItemText(up7, cbuffer);
    cbuffer.Printf(GetResString(IDS_STATS_SUCCUPCOUNT), theApp.uploadqueue->GetSuccessfullUpCount());
    stattree->SetItemText(up8, cbuffer);
    cbuffer.Printf(GetResString(IDS_STATS_FAILUPCOUNT), theApp.uploadqueue->GetFailedUpCount());
    stattree->SetItemText(up9, cbuffer);
    running = theApp.uploadqueue->GetAverageUpTime();
    cbuffer.Printf(GetResString(IDS_STATS_AVEUPTIME), CastSecondsToHM(running) .GetData());
    stattree->SetItemText(up10, cbuffer);
    if (theApp.stat_transferStarttime > 0)
    {
        cbuffer.Printf(GetResString(IDS_STATS_AVGDL), GetAvgDownloadRate(AVG_SESSION));
        stattree->SetItemText(con1, cbuffer);
        cbuffer.Printf(GetResString(IDS_STATS_AVGUL), GetAvgUploadRate(AVG_SESSION));
        stattree->SetItemText(con2, cbuffer);
        DownAvgRate = GetAvgDownloadRate(AVG_SESSION);
        if (maxDownavg < DownAvgRate) maxDownavg = DownAvgRate;
        cbuffer.Printf(GetResString(IDS_STATS_MAXAVGDL), maxDownavg);
        stattree->SetItemText(con12, cbuffer);
        cbuffer.Printf(GetResString(IDS_STATS_MAXDL), maxDown);
        stattree->SetItemText(con13, cbuffer);
    }
    if (theApp.stat_reconnects > 0) cbuffer.Printf(GetResString(IDS_STATS_RECONNECTS), theApp.stat_reconnects - 1);
    else cbuffer.Printf(GetResString(IDS_STATS_RECONNECTS), 0);
    stattree->SetItemText(con3, cbuffer);
    if (theApp.stat_transferStarttime == 0) cbuffer.Printf(GetResString(IDS_STATS_WAITTRANSF));
    else
    {
        running = (GetTickCount() - theApp.stat_transferStarttime) /1000;
        cbuffer.Printf(GetResString(IDS_TRANSFERTIME), CastSecondsToHM(running) .GetData());
    }
    stattree->SetItemText(con4, cbuffer);
    if (theApp.Start_time > 0)
    {
        running = (GetTickCount() - theApp.Start_time) /1000;
        cbuffer = wxString(wxT("Uptime: ")) + CastSecondsToHM(running);
        stattree->SetItemText(h_uptime, cbuffer);
    }
    if (theApp.stat_serverConnectTime == 0) cbuffer.Printf(GetResString(IDS_STATS_WAITCONN));
    else
    {
        running = (GetTickCount() - theApp.stat_serverConnectTime) /1000;
        cbuffer.Printf(GetResString(IDS_STATS_CONNECTEDSINCE), CastSecondsToHM(running) .GetData());
    }
    stattree->SetItemText(con5, cbuffer);
    if (theApp.stat_sessionReceivedBytes > 0 &&theApp.stat_sessionSentBytes > 0)
    if (theApp.stat_sessionReceivedBytes < theApp.stat_sessionSentBytes)
    {
        internalbuffer << GetResString(IDS_STATS_RATIO).mb_str(*wxConvCurrent) << " " << setprecision(2) << (float) theApp.stat_sessionSentBytes/theApp.stat_sessionReceivedBytes << " : 1";
        cbuffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
        internalbuffer.str("");
        stattree->SetItemText(tran0, cbuffer);
    }
    else
    {
        internalbuffer << GetResString(IDS_STATS_RATIO).mb_str(*wxConvCurrent) << " 1 : " << setprecision(2) << (float) theApp.stat_sessionReceivedBytes/theApp.stat_sessionSentBytes;
        cbuffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
        internalbuffer.str("");
        stattree->SetItemText(tran0, cbuffer);
    }
    // shared files stats
    cbuffer.Printf(GetResString(IDS_SHAREDFILESCOUNT), theApp.sharedfiles->GetCount());
    stattree->SetItemText(shar1, cbuffer);
    uint64_t allsize = theApp.sharedfiles->GetDatasize();
    cbuffer.Printf(GetResString(IDS_SF_SIZE), CastItoXBytes(allsize) .GetData());
    stattree->SetItemText(shar2, cbuffer);
    if (theApp.sharedfiles->GetCount() != 0)
    cbuffer2 = CastItoXBytes((uint64_t) allsize/theApp.sharedfiles->GetCount());
    else
    {
        cbuffer2 = wxT("-");
    }
    cbuffer.Printf(GetResString(IDS_SF_AVERAGESIZE), cbuffer2.GetData());
    stattree->SetItemText(shar3, cbuffer);
    // get clientversion-counts
    // statsclientstatus : original idea and code by xrmb
    std::map<uint16_t, uint32_t> clientVersionEDonkey;
    std::map<uint16_t, uint32_t> clientVersionEDonkeyHybrid;
    std::map<uint8_t, uint32_t> clientVersionEMule;

    uint32_t totalclient;
    theApp.clientlist->GetStatistics(totalclient, myStats, &clientVersionEDonkey, &clientVersionEDonkeyHybrid, &clientVersionEMule);
    totalclient -= myStats[0];
    if (!totalclient)
    totalclient = 1;
    internalbuffer << "eMule: " << myStats[2] << " (" << setw(1) << setprecision(1) << (double) 100 *myStats[2]/totalclient << "%%)";
    cbuffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
    internalbuffer.str("");
    stattree->SetItemText(cli1, cbuffer);
    //	cbuffer.Printf(_("LMule: %i (%1.1f%%)"),myStats[8],(double)100*myStats[8]/totalclient);stattree->SetItemText(cli10, cbuffer);
    internalbuffer << "xMule: " << myStats[6] << " (" << setw(1) << setprecision(1) << (double) 100 *myStats[6]/totalclient << "%%)";
    cbuffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
    internalbuffer.str("");
    stattree->SetItemText(cli8, cbuffer);
    internalbuffer << "eDonkeyHybrid: " << myStats[4] << " (" << setw(1) << setprecision(1) << (double) 100 *myStats[4]/totalclient << "%%)";
    cbuffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
    internalbuffer.str("");
    stattree->SetItemText(cli2, cbuffer);
    internalbuffer << "eDonkey: " << myStats[1] << " (" << setw(1) << setprecision(1) << (double) 100 *myStats[1]/totalclient << "%%)";
    cbuffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
    internalbuffer.str("");
    stattree->SetItemText(cli3, cbuffer);
    internalbuffer << "cDonkey: " << myStats[5] << " (" << setw(1) << setprecision(1) << (double) 100 *myStats[5]/totalclient << "%%)";
    cbuffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
    internalbuffer.str("");
    stattree->SetItemText(cli4, cbuffer);
    internalbuffer << "Old MLDonkey: " << myStats[3] << " (" << setw(1) << setprecision(1) << (double) 100 *myStats[3]/totalclient << "%%)";
    cbuffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
    internalbuffer.str("");
    stattree->SetItemText(cli5, cbuffer);
    internalbuffer << "New MLDonkey: " << myStats[7] << " (" << setw(1) << setprecision(1) << (double) 100 *myStats[7]/totalclient << "%%)";
    cbuffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
    internalbuffer.str("");
    stattree->SetItemText(cli9, cbuffer);
    cbuffer.Printf(GetResString(IDS_STATS_UNKNOWNCLIENT) .GetData(), myStats[0]);
    stattree->SetItemText(cli6, cbuffer);
    cbuffer.Printf(GetResString(IDS_STATS_FILTEREDCLIENTS) .GetData(), theApp.stat_filteredclients);
    stattree->SetItemText(cli7, cbuffer);
    //if (stattree->GetItemState(cli3, TVIS_EXPANDED)&&TVIS_EXPANDED == TVIS_EXPANDED ) {
    if (stattree->IsExpanded(cli3))
    {
        uint32_t totcnt = myStats[1];
        //--- find top 4 eDonkey client versions ---
        uint32_t currtop = 0;
        uint32_t lasttop = 0xFFFFFFFF;

        for (uint32_t i = 0; i < 4; ++i)
        {
            uint32_t topver = 0;
            uint32_t topcnt = 0;
            double topper = 0;

            std::map<uint16_t, uint32_t>::const_iterator it;
            it = clientVersionEDonkey.begin();

            while (it != clientVersionEDonkey.end())
            {
                const uint16_t ver(it->first);
                const uint32_t cnt(it->second);

                ++it;

                if (currtop < ver && (ver < lasttop && ver != 0x91))
                {
                    double percent = (double) cnt/totcnt;

                    if (lasttop == 0xFFFFFFFF && ((totcnt > 75 && ((cnt <= 2) || percent < 0.01)) || (totcnt > 50 && cnt <= 1)))
                    {
                        continue;
                    }

                    topper = percent;
                    topver = ver;
                    topcnt = cnt;
                    currtop = ver;
                }
            }

            lasttop = currtop;
            currtop = 0;

            if (topcnt)
            {
                internalbuffer << "v" << topver << ": " << topcnt << " (" << setw(1) << setprecision(1) << topper * 100 << "%%)";
                cbuffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
                internalbuffer.str("");
            }
            else
            {
                cbuffer = wxT("");
            }

            stattree->SetItemText(cli_versions[i + 8], cbuffer);
        }
    }
    //if (stattree->GetItemState(cli2, TVIS_EXPANDED)&&TVIS_EXPANDED == TVIS_EXPANDED ) {
    if (stattree->IsExpanded(cli2))
    {
        uint32_t totcnt = myStats[4];
        //--- find top 4 eDonkey Hybrid client versions ---
        uint32_t currtop = 0;
        uint32_t lasttop = 0xFFFFFFFF;
        for (uint32_t i = 0; i < 4; ++i)
        {
            uint32_t topver = 0;
            uint32_t topcnt = 0;
            double topper = 0;

            std::map<uint16_t, uint32_t>::const_iterator it;
            it = clientVersionEDonkeyHybrid.begin();

            while (it != clientVersionEDonkeyHybrid.end())
            {
                const uint16_t ver(it->first);
                const uint32_t cnt(it->second);

                ++it;

                if (currtop < ver && ver < lasttop && ver != 0x91)
                {
                    double percent = (double) cnt/totcnt;

                    if (lasttop == 0xFFFFFFFF && ((totcnt > 75 && ((cnt <= 2) || percent < 0.01)) || (totcnt > 50 && cnt <= 1)))
                    {

                        continue;
                    }

                    topper = percent;
                    topver = ver;
                    topcnt = cnt;
                    currtop = ver;
                }
            }

            lasttop = currtop;
            currtop = 0;

            if (topcnt)
            {
                internalbuffer << "v" << topver << ": " << topcnt << " (" << setw(1) << setprecision(1) << topper * 100 << "%%)";
                cbuffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
                internalbuffer.str("");
            }
            else
            {
                cbuffer = wxT("");
            }

            stattree->SetItemText(cli_versions[i + 4], cbuffer);
        }
    }
    //if (stattree->GetItemState(cli1, TVIS_EXPANDED)&&TVIS_EXPANDED == TVIS_EXPANDED ) {
    if (stattree->IsExpanded(cli1))
    {
        uint32_t totcnt = myStats[2];
        //--- find top 4 eMule client versions ---
        uint32_t currtop = 0;
        uint32_t lasttop = 0xFFFFFFFF;

        for (uint32_t i = 0 ; i < 4 ; i++)
        {
            uint32_t topver = 0;
            uint32_t topcnt = 0;
            double topper = 0;

            std::map<uint8_t, uint32_t>::const_iterator it;
            it = clientVersionEMule.begin();

            while (it != clientVersionEMule.end())
            {
                const uint8_t ver(it->first);
                const uint32_t cnt(it->second);

                ++it;

                if (currtop < ver && ver < lasttop)
                {
                    double percent = (double) cnt/totcnt;

                    if (lasttop == 0xFFFFFFFF && ((totcnt > 75 && ((cnt <= 2) || percent < 0.01)) || (totcnt > 50 && cnt <= 1)))
                    {
                        continue;
                    }

                    topper = percent;
                    topver = ver;
                    topcnt = cnt;
                    currtop = ver;
                }
            }

            lasttop = currtop;
            currtop = 0;

            if (topcnt)
            {
                internalbuffer << "v0." << setw(2) << setfill('0') << hex << uppercase << topver << ": " << topcnt << " (" << setw(1) << setprecision(1) << topper * 100 << "%%)";
                cbuffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
                internalbuffer.str("");
            }
            else
            {
                cbuffer = wxT("");
            }

            stattree->SetItemText(cli_versions[i], cbuffer);
        }
        // xrmb
    }
    // get serverstats
    uint32_t servtotal;
    uint32_t servfail;
    uint32_t servuser;
    uint32_t servfile;
    uint32_t servtuser;
    uint32_t servtfile;
    float servocc;
    theApp.serverlist->GetStatus(servtotal, servfail, servuser, servfile, servtuser, servtfile, servocc);
    internalbuffer << GetResString(IDS_SF_WORKING).mb_str(*wxConvCurrent) << ": " << servtotal - servfail;
    cbuffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
    internalbuffer.str("");
    stattree->SetItemText(srv1, cbuffer);
    internalbuffer << GetResString(IDS_SF_FAIL).mb_str(*wxConvCurrent) << ": " << servfail;
    cbuffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
    internalbuffer.str("");
    stattree->SetItemText(srv2, cbuffer);
    internalbuffer << GetResString(IDS_SF_TOTAL).mb_str(*wxConvCurrent) << ": " << servtotal;
    cbuffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
    internalbuffer.str("");
    stattree->SetItemText(srv3, cbuffer);
    internalbuffer << GetResString(IDS_SF_DELCOUNT).mb_str(*wxConvCurrent) << ": " << theApp.serverlist->GetDeletedServerCount();
    cbuffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
    internalbuffer.str("");
    stattree->SetItemText(srv4, cbuffer);
    internalbuffer << GetResString(IDS_SF_WUSER).mb_str(*wxConvCurrent) << ": " << servuser;
    cbuffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
    internalbuffer.str("");
    stattree->SetItemText(srv5, cbuffer);
    internalbuffer << GetResString(IDS_SF_WFILE).mb_str(*wxConvCurrent) << ": " << servfile;
    cbuffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
    internalbuffer.str("");
    stattree->SetItemText(srv6, cbuffer);
    internalbuffer << GetResString(IDS_SF_USER).mb_str(*wxConvCurrent) << ": " << servtuser;
    cbuffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
    internalbuffer.str("");
    stattree->SetItemText(srv7, cbuffer);
    internalbuffer << GetResString(IDS_SF_FILE).mb_str(*wxConvCurrent) << ": " << servtfile;
    cbuffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
    internalbuffer.str("");
    stattree->SetItemText(srv8, cbuffer);
    internalbuffer << GetResString(IDS_SF_ACTIVECON).mb_str(*wxConvCurrent) << ": " << activeconnections;
    cbuffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
    internalbuffer.str("");
    stattree->SetItemText(con6, cbuffer);
    cbuffer.Printf(GetResString(IDS_SF_SRVOCC), servocc);
    stattree->SetItemText(srv9, cbuffer);
    uint32_t m_itemp = theApp.listensocket->GetMaxConnectionReached();
    if (m_itemp != m_ilastMaxConnReached)
    {
        char osDate[60];
        //_strtime( osTime );
        //_strdate( osDate );
        time_t mytime = time(NULL);
        struct tm *now = localtime( &mytime);
        strftime(osDate, sizeof(osDate) - 1, "%d.%m.%Y %H:%M:%S", now);
        internalbuffer << GetResString(IDS_SF_MAXCONLIMITREACHED).mb_str(*wxConvCurrent) << ": " << m_itemp << " : " << osDate;
        cbuffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
        internalbuffer.str("");
        stattree->SetItemText(con7, cbuffer);
        m_ilastMaxConnReached = m_itemp;
    }
    else if(m_itemp == 0)
    {
        internalbuffer << GetResString(IDS_SF_MAXCONLIMITREACHED).mb_str(*wxConvCurrent) << ": " << m_itemp;
        cbuffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
        internalbuffer.str("");
        stattree->SetItemText(con7, cbuffer);
    }
    if (theApp.serverconnect->IsConnected())
    {
        internalbuffer << GetResString(IDS_SF_AVGCON).mb_str(*wxConvCurrent) << ": " << (int) averageconnections;
        cbuffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
        internalbuffer.str("");
        stattree->SetItemText(con8, cbuffer);
    }
    else
    {
        stattree->SetItemText(con8, GetResString(IDS_STATS_WAITCONN));
    }
    internalbuffer << GetResString(IDS_SF_PEAKCON).mb_str(*wxConvCurrent) << ": " << peakconnections;
    cbuffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
    internalbuffer.str("");
    stattree->SetItemText(con9, cbuffer);
}

float CStatisticsDlg::GetAvgDownloadRate(int averageType)
{
    if (averageType == AVG_SESSION)
    {
        if (theApp.stat_transferStarttime == 0) return 0;
        x::DWORD running = (GetTickCount() - theApp.stat_transferStarttime) /1000;
        if (running < 5) return 0;
        return(float)(theApp.stat_sessionReceivedBytes/1024) / running;
    }
    else
    {
        if (downrateHistory.size() == 0) return 0;
        uint64_t sum;
        sum = downrateHistory.front();
        if ((int) downrateHistory.size() >= (int)DynPrefs::Get<long>("graph-average") * 60) sum -= downrateHistory.back();
        return (float)(sum/1024) / downrateHistory.size();
    }
}

float CStatisticsDlg::GetAvgUploadRate(int averageType)
{
    if (averageType == AVG_SESSION)
    {
        if (theApp.stat_transferStarttime == 0) return 0;
        x::DWORD running = (GetTickCount() - theApp.stat_transferStarttime) /1000;
        if (running < 5) return 0;
        return(float)(theApp.stat_sessionSentBytes/1024) / running;
    }
    else
    {
        if (uprateHistory.size() == 0) return 0;
        uint64_t sum = uprateHistory.front();
        if ((int) uprateHistory.size() >= (int)(DynPrefs::Get<long>("graph-average") * 60)) sum -= uprateHistory.back();
        return(float)(sum/1024) /uprateHistory.size();
    }
}

#if 0
void CStatisticsDlg::OnShowWindow(bool bShow, x::UINT nStatus)
{
}

void CStatisticsDlg::OnSize(x::UINT nType, int cx, int cy)
{
    CResizableDialog::OnSize(nType, cx, cy);
    // TODO: Add your message handler code here
    //this will cause COScopeCtrl::OnSizeCall
    CRect rc;
    GetDlgItem(IDC_UPLOAD)->GetWindowRect( &rc);
    ScreenToClient( &rc);
    m_DownloadOMeter.MoveWindow( &rc);
    //OnSize:
}

#endif

void CStatisticsDlg::ShowInterval()
{
    //EnableWindow( FALSE );
    int shownSecs = 319 * DynPrefs::Get<long>("graph-delay");
    if (shownSecs == 0)
    {
        m_DownloadOMeter->SetXUnits(GetResString(IDS_STOPPED));
        m_UploadOMeter->SetXUnits(GetResString(IDS_STOPPED));
    }
    else
    {
        wxString tmpstr = CastSecondsToHM(shownSecs);
        m_UploadOMeter->SetXUnits(tmpstr.GetData());
        m_DownloadOMeter->SetXUnits(tmpstr.GetData());
    }
    //UpdateData(FALSE);
    //EnableWindow( TRUE );
}

void CStatisticsDlg::SetARange(bool SetDownload, int maxValue)
{
    if (SetDownload)
    {
        m_DownloadOMeter->SetRange(0, maxValue + 4, 0);
        m_DownloadOMeter->SetRange(0, maxValue + 4, 1);
        m_DownloadOMeter->SetRange(0, maxValue + 4, 2);
    }
    else
    {
        m_UploadOMeter->SetRange(0, maxValue + 4, 0);
        m_UploadOMeter->SetRange(0, maxValue + 4, 1);
        m_UploadOMeter->SetRange(0, maxValue + 4, 2);
    }
}

#if 0
void CStatisticsDlg::Localize()
{
    GetDlgItem(IDC_STATIC_D3)->SetWindowText(GetResString(IDS_ST_DOWNLOAD));
    GetDlgItem(IDC_STATIC_U)->SetWindowText(GetResString(IDS_ST_UPLOAD));
    GetDlgItem(IDC_STATIC_D)->SetWindowText(GetResString(IDS_ST_CURRENT));
    GetDlgItem(IDC_STATIC_U2)->SetWindowText(GetResString(IDS_ST_CURRENT));
    GetDlgItem(IDC_STATIC_D2)->SetWindowText(GetResString(IDS_ST_SESSION));
    GetDlgItem(IDC_STATIC_U3)->SetWindowText(GetResString(IDS_ST_SESSION));
    GetDlgItem(IDC_STATIC_S2)->SetWindowText(GetResString(IDS_ST_ACTIVED));
    GetDlgItem(IDC_STATIC_S0)->SetWindowText(GetResString(IDS_ST_ACTIVEC));
    GetDlgItem(IDC_STATIC_S1)->SetWindowText(GetResString(IDS_ST_ACTIVEU));
    GetDlgItem(IDC_STATIC_S3)->SetWindowText(GetResString(IDS_ST_WAITINGU));
    wxString value;
    value.Printf(" (%u mins)", theApp.glob_prefs->GetStatsAverageMinutes());
    GetDlgItem(IDC_TIMEAVG1)->SetWindowText(GetResString(IDS_AVG) + value);
    GetDlgItem(IDC_TIMEAVG2)->SetWindowText(GetResString(IDS_AVG) + value);
}

#endif

// the idea: we must dispatch this request to the main thread as web thread
// can't touch the GUI controls. Only allowed function is wxPostEvent which
// unfortunately just passes the event, so we must implement a wxCondition
// so we can wait until the main thread has processed the request and built
// a valid string for us.
wxString CStatisticsDlg::ExportHTML()
{
    // only one shall pass
    wxCriticalSectionLocker locker(exportCrit);
    // then lock the signalling mutex
    wxCondition myCond(exportMutex);
    exportCondition = &myCond;
    exportMutex.Lock();
    // post the message
    wxCommandEvent evt(wxEVT_COMMAND_MENU_SELECTED, ID_EXPORT_HTML);
    wxPostEvent(this, evt);
    // and wait until it is completed
    exportCondition->Wait();
    // and now we can return the string
    exportMutex.Unlock();
    cout << "*** WEB THREAD: returning the value" << endl;
    return exportString;
}

void CStatisticsDlg::ExportHTMLEvent(wxCommandEvent &evt)
{
    int8_t ix;
    wxString temp;
    wxString text = wxT("");
    wxTreeItemId item;
    // update it
    ShowStatistics();
    item = stattree->GetRootItem();
    text = stattree->GetItemText(item);
    while (item)
    {
        item = stattree->GetNextVisible(item);
        if (!item) break;
        //,TVE_EXPAND);:
        stattree->Expand(item);
        temp = wxT("");
        
        for (ix = 0 ; ix < 3 * (int) stattree->GetItemData(item); ++ix)
        {
            temp += wxT("&nbsp;");
        }

        text += wxT("<br>") + temp + stattree->GetItemText(item);
    }
    // set the string
    exportString = text; 
    // and signal
    cout << "** MAIN THREAD: Return value ready." << endl;
    wxMutexLocker locker(exportMutex);
    exportCondition->Broadcast();
    cout << "** MAIN THREAD: All done." << endl;
}

