// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef SYSTRAY_H
#define SYSTRAY_H

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <glib.h>
#include <X11/Xatom.h>

#include <locale.h>
#include <config.h>
#include <sys/ioctl.h>
#include <sys/socket.h>                   // Needed for BSD systems
#include <net/if.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#ifdef __WXGTK__
#	include <unistd.h>
#endif

#ifdef __WXMAC__
#	include <sys/types.h>
#	include <sys/socket.h>
#endif

#include "eggtrayicon.h"
#include "wintypes.h"
#include "wx/window.h"
#include "wx/string.h"

#define GetRValue(rgb) (((rgb)>>16)&0xff)
#define GetGValue(rgb) (((rgb)>>8)&0xff)
#define GetBValue(rgb) ((rgb)&0xff)

//START - enkeyDEV(kei-kun) -TaskbarNotifier-
#define TBN_NULL				0
#define TBN_CHAT				1
#define TBN_DLOAD				2
#define TBN_LOG					3
#define TBN_IMPORTANTEVENT		4
#define TBN_NEWVERSION			5
//END - enkeyDEV(kei-kun) -TaskbarNotifier-

typedef struct _tagSIZE {
	int cx, cy;
} SIZE;

class CSysTray {	
public:
	CSysTray(wxWindow* parent_local, int desktopMode, const wxString& title);

	void Show(const wxChar* caption, int nMsgType, x::DWORD dwTimeToShow = 500, x::DWORD dwTimeToStay = 4000, x::DWORD dwTimeTOHide = 200);

	void TraySetToolTip(const char* data);
	void TraySetIcon(char** data, bool what = false, int* pVals = NULL);
	bool SetColorLevels(int* pLimits, x::COLORREF* pColors, int nEntries);

private:
	void setupProperties();
	void drawMeters(GdkPixmap* pix, GdkBitmap* mask, int* pBarData);
	void DrawIconMeter(GdkPixmap* pix, GdkBitmap* mask, int pBarData, int x);
	x::COLORREF GetMeterColor(int level);

	int desktopMode;
	wxWindow* parent;
	GtkWidget* status_docklet;
	GtkWidget* status_image;
	GtkTooltips* status_tooltips;
	SIZE m_sDimensions;

	int m_nSpacingWidth;
	int m_nNumBars;
	int m_nMaxVal;
	int m_nEntries;
};

#endif
