// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA


#ifndef _TRANSFERWND_H
#define _TRANSFERWND_H

#include <stdint.h>                         // Needed for uint32_t
#include <wx/panel.h>                       // Needed for wxPanel

class CUploadListCtrl;
class CDownloadListCtrl;
class CQueueListCtrl;
class CMuleNotebook;
class wxListCtrl;
class wxSplitterEvent;
class wxNotebookEvent;
class wxCommandEvent;
class wxMouseEvent;
class wxEvent;

class CTransferWnd : public wxPanel //CResizableDialog
{
  //DECLARE_DYNAMIC(CTransferWnd)
  DECLARE_DYNAMIC_CLASS(CTransferWnd)

public:
	CTransferWnd(wxWindow* pParent = NULL);   // standard constructor
	virtual ~CTransferWnd();
	void	ShowQueueCount(uint32_t number);
	void	SwitchUploadList(wxCommandEvent& evt);
	bool	OnInitDialog();
// Dialog Data
	CUploadListCtrl*		uploadlistctrl;
	CDownloadListCtrl*	downloadlistctrl;
	CQueueListCtrl*		queuelistctrl;
	//wxToolTip		m_ttip;
	bool			windowtransferstate;
protected:
	/*
	virtual bool PreTranslateMessage(MSG* pMsg);
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual bool OnInitDialog();
	virtual LRESULT DefWindowProc(x::UINT message, WPARAM wParam, LPARAM lParam);
	afx_msg bool OnToolTipNotify(x::UINT id, NMHDR *pNMH, LRESULT *pResult);
	*/

	void OnSelchangeDltab(wxNotebookEvent& evt);
	void OnNMRclickDLtab(wxMouseEvent& evt);
    void OnSashPositionChanged(wxSplitterEvent& event);

	int AddCategorie(wxString newtitle, wxString newincoming, wxString newcomment, bool addTab);
	void EditCatTabLabel(int index, wxString newlabel);

	CMuleNotebook* m_dlTab;

	DECLARE_EVENT_TABLE()

	//DECLARE_MESSAGE_MAP()

private:
    void HandleCatMenu(wxCommandEvent& event);
	wxString m_strToolTip;
	int m_iOldToolTipItemDown;
	int m_iOldToolTipItemUp;
	int m_iOldToolTipItemQueue;	
	int rightclickindex;
	bool CatMenu;
};

#endif
