// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef _UDPSOCKET_H_
#define _UDPSOCKET_H_

#include "packets.h"
#include "server.h"

#include <arpa/inet.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <wx/socket.h>

#define WM_DNSLOOKUPDONE WM_USER+280
// Client to Server communication
class CServerConnect;
class wxEvtHandler;

class CUDPSocket: public wxDatagramSocket //CAsyncSocket
{
    friend class CServerConnect;
    DECLARE_DYNAMIC_CLASS(CUDPSocket);

    CUDPSocket() : wxDatagramSocket(useless) {};
public:
    CUDPSocket(CServerConnect* in_serverconnect,wxIPV4address& addr);
    ~CUDPSocket();

    void SendPacket(Packet* packet,CServer* host);
    void DnsLookupDone(struct sockaddr_in* addr);
protected:
    void AsyncResolveDNS(x::LPCTSTR lpszHostAddress, x::UINT nHostPort);

public:
    virtual void OnReceive(int nErrorCode);
private:
    x::LPCTSTR m_lpszHostAddress;
    x::UINT m_nHostPort;
    struct sockaddr_in m_SaveAddr;

    void SendBuffer();
    void SendBuffer_NEW(wxUint32 hostip,wxUint16 port);
    bool ProcessPacket(unsigned char* packet, wxUint16 size, wxUint8 opcode, wxUint32 hostip, wxUint16 port);
    bool ProcessExtPacket(unsigned char* packet, wxUint16 size, wxUint8 opcode, wxUint32 hostip, wxUint16 port);
    CServerConnect* serverconnect;
    char* sendbuffer;
    uint32_t sendblen;
    CServer* cur_server;
    char DnsHostBuffer[1024]; //MAXGETHOSTSTRUCT]; // dns lookup structure
    wxIPV4address useless;
    wxEvtHandler* m_event_handler;
};

#endif // _UDPSOCKET_H_
