// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef ENDIANSWAP_H
#define ENDIANSWAP_H

#include "config.h"            // Needed for __BSDBOX__

#if !defined(__WIN32__)
    #if defined(__WXMAC__)
        #define __BIG_ENDIAN wxBIG_ENDIAN
        #define __LITTLE_ENDIAN wxLITTLE_ENDIAN
        #define __BYTE_ORDER wxBIG_ENDIAN
    #endif
    #if defined(__BSDBOX__)
        #include <machine/endian.h>
    #else
        #include <endian.h>
    #endif
#endif

#if __BYTE_ORDER == __LITTLE_ENDIAN
    #define ENDIAN_SWAP_16(x) (x)
    #define ENDIAN_SWAP_I_16(x) {}
    #define ENDIAN_SWAP_32(x) (x)
    #define ENDIAN_SWAP_I_32(x) {}
    #if defined __GNUC__ && __GNUC__ >= 2
        #define ENDIAN_SWAP_64(x) (x)
        #define ENDIAN_SWAP_I_64(x) {}
    #endif
#else
    #warning BIG ENDIAN BOX
    #define ENDIAN_SWAP_16(x) (wxUINT16_SWAP_ALWAYS(x))
    #define ENDIAN_SWAP_I_16(x) x = wxUINT16_SWAP_ALWAYS(x)
    #define ENDIAN_SWAP_32(x) (wxUINT32_SWAP_ALWAYS(x))
    #define ENDIAN_SWAP_I_32(x) x = wxUINT32_SWAP_ALWAYS(x)
    #if defined __GNUC__ && __GNUC__ >= 2
        #define ENDIAN_SWAP_64(x) (wxUINT64_SWAP_ALWAYS(x))
        #define ENDIAN_SWAP_I_64(x) x = wxUINT64_FROM_LE(x)
    #endif
#endif

#endif // ENDIANSWAP_H

