// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifdef PRECOMP
#	include "xmule-headers.h"
#endif

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#include "ldaemon.h"                        // Needed for this Interface's Prototype

#include <iostream>                         // std::cout
#include <sys/stat.h>                       // Needed for mkdir

using std::cout;
using std::endl;

CLDaemon::CLDaemon() {}

CLDaemon::~CLDaemon() {}

void CLDaemon::Init()
{
    char* names[] = 
    {
        "command",
        "status",
        "output",
        "server",
        "download",
        "upload"
    };

    wxString PrefDir(getenv("HOME"), *wxConvCurrent);
    PrefDir += wxT("/.xMule/nowindow");

    if (!wxDirExists(PrefDir))
    {
        wxMkdir(PrefDir, 0777);
    }

    // LD_COMMAND
    FName[0] = PrefDir + wxT("/") + wxString(names[0], *wxConvCurrent);

    if (Ftmp.Open (FName[0],wxFile::write))
    {
	Ftmp.Close();
    }
    else
    {
        cout << "Can't open nowindow file (" << names[0] << ")" << endl;
    }
    
    for (int i = LD_STATUS; i < LD_NUMBER; ++i)
    {
    	FName[i] = PrefDir + wxT("/") + wxString(names[i], *wxConvCurrent);
	wxRemoveFile(FName[i]);
    }
}

void CLDaemon::Print(wxString Data, int type, bool erase)
{
    wxFile::OpenMode open_type;

    if (erase)
    {
	open_type = wxFile::write;
    }
    else
    {
	open_type = wxFile::write_append;
    }

    if (!Ftmp.Open(FName[type], open_type)) { return; }

    Ftmp.Write(Data + wxT("\n"));
    Ftmp.Close();
}

bool CLDaemon::Read(wxString& Data, int type)
{
    int l, read;
    char* string;

    if (type < 0 || type >= LD_NUMBER) { return false; }

    if (!Ftmp.Open(FName[type],wxFile::read)) { return false; }

    l = Ftmp.Length();

    if (!l)
    {
	Ftmp.Close();
	return false;
    }

    string = new char[l + 1];
    read = Ftmp.Read(string, l);
    Ftmp.Close();
    string[read - 1] = 0;

    if (Ftmp.Create(FName[type], true))
    {
	Ftmp.Close();
    }

    if (read != l)
    {
	delete string;
	return false; 
    }

    Data = wxString(string, *wxConvCurrent);
    delete string;
    return true;
}

bool CLDaemon::ReadCommand()
{
    if (!Read(Command,LD_COMMAND)) { return false; }
    return true;
}

bool CLDaemon::Delete(int type)
{
    if (type < 0 || type >= LD_NUMBER) { return false; }
    return wxRemoveFile(FName[type]);
}
