// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA


#ifndef _XMULEDLG_H_
#define _XMULEDLG_H_

#include <stdint.h>                    // uint8_t uint32_t
#include <wx/imaglist.h>               // wxImageList
#include <wx/button.h>                 // wxButton
#include <wx/frame.h>                  // wxFrame
#include <wx/toolbar.h>                // wxToolBar
#include <wx/control.h>                // wxControl

class CTransferWnd;
class CServerWnd;
class CPreferencesDlg;
class CSharedFilesWnd;
class CSearchDlg;
class CChatWnd;
class CFlowChart;
class CStatisticsDlg;
class CSysTray;
class wxMenu;
class wxSocketEvent;
class wxTimerEvent;

enum APPState
{
    APP_STATE_RUNNING,
    APP_STATE_SHUTINGDOWN,
    APP_STATE_DONE,
    APP_STATE_STARTING
};

#define MP_RESTORE      4001
#define MP_CONNECT      4002
#define MP_DISCONNECT   4003
#define MP_EXIT         4004

class CKnownFileList;

class CxmuleDlg :public wxFrame
{
public:
    CxmuleDlg(wxWindow* pParent=NULL, wxString title=wxT(""));
    ~CxmuleDlg();

    void AddLogLine(bool addtostatusbar,const wxChar* line,...);
    void AddServerMessageLine(char* line,...);
    void ShowConnectionState(bool connected);
    void ShowConnectionState(bool connected,wxString server,bool iconOnly=false);
    void ShowNotifier(wxString Text, int MsgType, bool ForceSoundOFF = false);
    void ShowUserCount(uint32_t toshow,uint32_t filetoshow);
    void ShowMessageState(uint8_t iconnr);
    void SetActiveDialog(wxWindow* dlg);
    void ShowTransferRate(bool forceAll=true);
    void ShowStatistics();
    void Localize();
    void ResetLog();
    void ResetDebugLog();
    void StopTimer();
    // Barry - To find out if app is running or shutting/shut down
    bool IsRunning();
    void DoVersioncheck(bool manual);
    // has to be done in own method
    void createSystray(const wxString& title);
    void changeDesktopMode();

    CTransferWnd *transferwnd;
    CServerWnd *serverwnd;
    CPreferencesDlg *preferenceswnd;
    CSharedFilesWnd *sharedfileswnd;
    CSearchDlg *searchwnd;
    CFlowChart *flowchartwnd;
    CChatWnd *chatwnd;
    wxWindow *activewnd;
    CStatisticsDlg *statisticswnd;
    CSysTray *m_wndTaskbarNotifier;
    volatile APPState m_app_state; // added volatile to get some more security when accessing this as a shared object...
    uint8_t status;
    uint16_t lastbutton;
    int split_pos;

protected:
    void socketHandler(wxSocketEvent& event);
    void OnUQTimer(wxTimerEvent& evt);
    void OnUDPTimer(wxTimerEvent& evt);
    void OnSocketTimer(wxTimerEvent& evt);
    void OnQLTimer(wxTimerEvent& evt);
    void OnToolClick(wxCommandEvent& event);
    void btnPreferences(wxCommandEvent & ev);

 public:
    void OnFinishedHashing(wxCommandEvent& evt);
    void OnHashingShutdown(wxCommandEvent& evt);
    void OnDnsDone(wxCommandEvent& evt);
    void InitDialog();
    void OnBnConnect(wxCommandEvent& event);
    void OnClose(wxCloseEvent& evt);

    /* Public function to check which tab is active. Needed to check what to redraw. */
    int GetActiveDialog()   { return m_nActiveDialog; }
private:
    void OnInit();
    void ShutDown();
    void MinimizeDlg(wxIconizeEvent& event);
    wxString logtext;
    bool ready;
    wxBitmap transicons[4];

    uint32_t lastuprate;
    uint32_t lastdownrate;
    wxImageList imagelist;
    wxMenu* trayPopup;

    wxButton m_btnConnect;
    wxButton m_btnDownloads;
    wxButton m_btnServers;
    wxButton m_btnSearch;
    wxButton m_btnFiles;
    wxButton m_btnPreferences;
    wxButton m_btnMessages;
    wxButton m_btnStatistics;
    wxButton m_btnIrc;
    wxToolBar* m_wndToolbar;

    void StartConnection();
    void CloseConnection();
    void RestoreWindow();
    void UpdateTrayIcon(int procent);
    void OnFinishResize(wxSizeEvent& event);

    int m_nActiveDialog;

    DECLARE_EVENT_TABLE()
};

#endif // _XMULEDLG_H_
