prompt PL/SQL Developer import file
prompt Created on 20111115 by zhi
set feedback off
set define off
prompt Creating REGION...
create table REGION
(
  REGION_ID           NUMBER not null,
  REGION_CODE         VARCHAR2(100) not null,
  REGION_NAME         VARCHAR2(100) not null,
  PARENT_ID           NUMBER not null,
  REGION_LEVEL        NUMBER not null,
  REGION_ORDER        NUMBER not null,
  REGION_NAME_EN      VARCHAR2(100) default 1 not null,
  REGION_SHORTNAME_EN VARCHAR2(10) default 2 not null
)
tablespace DEMO
  pctfree 10
  initrans 1
  maxtrans 255
  storage
  (
    initial 256K
    minextents 1
    maxextents unlimited
  );
comment on column REGION.REGION_ID
  is 'id';
comment on column REGION.REGION_CODE
  is '';
comment on column REGION.REGION_NAME
  is '';
comment on column REGION.PARENT_ID
  is '';
comment on column REGION.REGION_LEVEL
  is '㼶';
comment on column REGION.REGION_ORDER
  is '˳';
comment on column REGION.REGION_NAME_EN
  is 'Ӣ';
comment on column REGION.REGION_SHORTNAME_EN
  is '';
alter table REGION
  add constraint REGION_KEY primary key (REGION_ID)
  using index 
  tablespace DEMO
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 128K
    minextents 1
    maxextents unlimited
  );

prompt Loading REGION...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2508, '450702', '', 259, 0, 0, 'Qinnan Qu', 'QNQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2514, '450803', '', 260, 0, 0, 'Gangnan Qu', 'GNQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2522, '450923', '', 261, 0, 0, 'Bobai Xian', 'BBA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2527, '451021', '', 262, 0, 0, 'Tianyang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2531, '451025', '', 262, 0, 0, 'Jingxi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2534, '451028', 'ҵ', 262, 0, 0, 'Leye Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2537, '451031', '¡ָ', 262, 0, 0, 'Longlin Gezu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2542, '451123', '', 263, 0, 0, 'Fuchuan Yaozu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2549, '451225', '޳', 264, 0, 0, 'Luocheng Mulaozu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2551, '451227', '', 264, 0, 0, 'Bama Yaozu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2554, '451281', '', 264, 0, 0, 'Yizhou Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2559, '451323', '', 265, 0, 0, 'Wuxuan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2561, '451381', 'ɽ', 265, 0, 0, 'Heshan Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2565, '451422', '', 266, 0, 0, 'Ningming Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1648, '360481', '', 162, 0, 0, 'Ruichang Shi', 'RCG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1650, '360502', 'ˮ', 163, 0, 0, 'Yushui Qu', 'YSR');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1651, '360521', '', 163, 0, 0, 'Fenyi Xian', 'FYI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1652, '360601', 'Ͻ', 164, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1654, '360622', '཭', 164, 0, 0, 'Yujiang Xian', 'YUJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1655, '360681', 'Ϫ', 164, 0, 0, 'Guixi Shi', 'GXS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1656, '360701', 'Ͻ', 165, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1658, '360721', '', 165, 0, 0, 'Gan Xian', 'GXN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1659, '360722', 'ŷ', 165, 0, 0, 'Xinfeng Xian ', 'XNF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1660, '360723', '', 165, 0, 0, 'Dayu Xian', 'DYX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1662, '360725', '', 165, 0, 0, 'Chongyi Xian', 'CYX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1663, '360726', 'Զ', 165, 0, 0, 'Anyuan Xian', 'AYN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1664, '360727', '', 165, 0, 0, 'Longnan Xian', 'LNX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1666, '360729', 'ȫ', 165, 0, 0, 'Quannan Xian', 'QNN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1667, '360730', '', 165, 0, 0, 'Ningdu Xian', 'NDU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1668, '360731', 'ڶ', 165, 0, 0, 'Yudu Xian', 'YUD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1670, '360733', '', 165, 0, 0, 'Huichang Xian', 'HIC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1671, '360734', 'Ѱ', 165, 0, 0, 'Xunwu Xian', 'XNW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1672, '360735', 'ʯ', 165, 0, 0, 'Shicheng Xian', 'SIC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1674, '360782', 'Ͽ', 165, 0, 0, 'Nankang Shi', 'NNK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1675, '360801', 'Ͻ', 166, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1676, '360802', '', 166, 0, 0, 'Jizhou Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1678, '360821', '', 166, 0, 0, 'Ji,an Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1679, '360822', 'ˮ', 166, 0, 0, 'Jishui Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1680, '360823', 'Ͽ', 166, 0, 0, 'Xiajiang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1682, '360825', '', 166, 0, 0, 'Yongfeng Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1683, '360826', '̩', 166, 0, 0, 'Taihe Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1684, '360827', '촨', 166, 0, 0, 'Suichuan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1686, '360829', '', 166, 0, 0, 'Anfu Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1687, '360830', '', 166, 0, 0, 'Yongxin Xian ', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1688, '360881', 'ɽ', 166, 0, 0, 'Jinggangshan Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1690, '360902', 'Ԭ', 167, 0, 0, 'Yuanzhou Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1691, '360921', '', 167, 0, 0, 'Fengxin Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1692, '360922', '', 167, 0, 0, 'Wanzai Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1694, '360924', '˷', 167, 0, 0, 'Yifeng Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1695, '360925', '', 167, 0, 0, 'Jing,an Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1696, '360926', 'ͭ', 167, 0, 0, 'Tonggu Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1697, '360981', '', 167, 0, 0, 'Fengcheng Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1698, '360982', '', 167, 0, 0, 'Zhangshu Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1699, '360983', '߰', 167, 0, 0, 'Gao,an Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1700, '361001', 'Ͻ', 168, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1701, '361002', 'ٴ', 168, 0, 0, 'Linchuan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1702, '361021', 'ϳ', 168, 0, 0, 'Nancheng Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1703, '361022', '质', 168, 0, 0, 'Lichuan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1704, '361023', 'Ϸ', 168, 0, 0, 'Nanfeng Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1705, '361024', '', 168, 0, 0, 'Chongren Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1706, '361025', 'ְ', 168, 0, 0, 'Le,an Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1707, '361026', '˻', 168, 0, 0, 'Yihuang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1708, '361027', 'Ϫ', 168, 0, 0, 'Jinxi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1709, '361028', 'Ϫ', 168, 0, 0, 'Zixi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1710, '361029', '', 168, 0, 0, 'Dongxiang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1711, '361030', '', 168, 0, 0, 'Guangchang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1712, '361101', 'Ͻ', 169, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1713, '361102', '', 169, 0, 0, 'Xinzhou Qu', 'XZQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1714, '361121', '', 169, 0, 0, 'Shangrao Xian ', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1715, '361122', '', 169, 0, 0, 'Guangfeng Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1716, '361123', 'ɽ', 169, 0, 0, 'Yushan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1717, '361124', 'Ǧɽ', 169, 0, 0, 'Qianshan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1718, '361125', '', 169, 0, 0, 'Hengfeng Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1719, '361126', '߮', 169, 0, 0, 'Yiyang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1720, '361127', '', 169, 0, 0, 'Yugan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1721, '361128', '۶', 169, 0, 0, 'Poyang Xian', 'PYX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1722, '361129', '', 169, 0, 0, 'Wannian Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1723, '361130', 'Դ', 169, 0, 0, 'Wuyuan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1724, '361181', '', 169, 0, 0, 'Dexing Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1725, '370101', 'Ͻ', 170, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1726, '370102', '', 170, 0, 0, 'Lixia Qu', 'LXQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1727, '370101', '', 170, 0, 0, 'Shizhong Qu', 'SZQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1728, '370104', '', 170, 0, 0, 'Huaiyin Qu', 'HYF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1729, '370105', '', 170, 0, 0, 'Tianqiao Qu', 'TQQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1730, '370112', '', 170, 0, 0, 'Licheng Qu', 'LCZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1731, '370113', '', 170, 0, 0, 'Changqing Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1732, '370124', 'ƽ', 170, 0, 0, 'Pingyin Xian', 'PYL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1733, '370125', '', 170, 0, 0, 'Jiyang Xian', 'JYL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1734, '370126', '̺', 170, 0, 0, 'Shanghe Xian', 'SGH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1735, '370181', '', 170, 0, 0, 'Zhangqiu Shi', 'ZQS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1736, '370201', 'Ͻ', 171, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1737, '370202', '', 171, 0, 0, 'Shinan Qu', 'SNQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1738, '370203', 'б', 171, 0, 0, 'Shibei Qu', 'SBQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1739, '370205', 'ķ', 171, 0, 0, 'Sifang Qu', 'SFQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1740, '370211', 'Ƶ', 171, 0, 0, 'Huangdao Qu', 'HDO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1741, '370212', 'ɽ', 171, 0, 0, 'Laoshan Qu', 'LQD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1742, '370213', '', 171, 0, 0, 'Licang Qu', 'LCT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1743, '370214', '', 171, 0, 0, 'Chengyang Qu', 'CEY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1744, '370281', '', 171, 0, 0, 'Jiaozhou Shi', 'JZS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1745, '370282', 'ī', 171, 0, 0, 'Jimo Shi', 'JMO');
commit;
prompt 100 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1746, '370283', 'ƽ', 171, 0, 0, 'Pingdu Shi', 'PDU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1747, '370284', '', 171, 0, 0, 'Jiaonan Shi', 'JNS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1748, '370285', '', 171, 0, 0, 'Laixi Shi', 'LXE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1749, '370301', 'Ͻ', 172, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1750, '370302', 'ʹ', 172, 0, 0, 'Zichuan Qu', 'ZCQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1751, '370303', 'ŵ', 172, 0, 0, 'Zhangdian Qu', 'ZDQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1752, '370304', 'ɽ', 172, 0, 0, 'Boshan Qu', 'BSZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1753, '370305', '', 172, 0, 0, 'Linzi Qu', 'LZQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1754, '370306', 'ܴ', 172, 0, 0, 'Zhoucun Qu', 'ZCN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1755, '370321', '̨', 172, 0, 0, 'Huantai Xian', 'HTL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1756, '370322', '', 172, 0, 0, 'Gaoqing Xian', 'GQG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1758, '370401', 'Ͻ', 173, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1759, '370402', '', 173, 0, 0, 'Shizhong Qu', 'SZZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1760, '370403', 'Ѧ', 173, 0, 0, 'Xuecheng Qu', 'XEC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1761, '370404', 'ỳ', 173, 0, 0, 'Yicheng Qu', 'YZZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1763, '370406', 'ɽͤ', 173, 0, 0, 'Shanting Qu', 'STG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1764, '370481', '', 173, 0, 0, 'Tengzhou Shi', 'TZO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1765, '370501', 'Ͻ', 174, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1766, '370502', 'Ӫ', 174, 0, 0, 'Dongying Qu', 'DYQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1768, '370521', '', 174, 0, 0, 'Kenli Xian', 'KLI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1769, '370522', '', 174, 0, 0, 'Lijin Xian', 'LJN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1771, '370601', 'Ͻ', 175, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1772, '370602', '֥', 175, 0, 0, 'Zhifu Qu', 'ZFQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1773, '370611', 'ɽ', 175, 0, 0, 'Fushan Qu', 'FUS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1774, '370612', 'Ĳƽ', 175, 0, 0, 'Muping Qu', 'MPQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1775, '370613', 'ɽ', 175, 0, 0, 'Laishan Qu', 'LYT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1777, '370681', '', 175, 0, 0, 'Longkou Shi', 'LKU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1778, '370682', '', 175, 0, 0, 'Laiyang Shi', 'LYD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1780, '370684', '', 175, 0, 0, 'Penglai Shi', 'PLI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1781, '370685', 'Զ', 175, 0, 0, 'Zhaoyuan Shi', 'ZYL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1783, '370687', '', 175, 0, 0, 'Haiyang Shi', 'HYL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1784, '370701', 'Ͻ', 176, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1785, '370702', 'Ϋ', 176, 0, 0, 'Weicheng Qu', 'WCG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1786, '370703', 'ͤ', 176, 0, 0, 'Hanting Qu', 'HNT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1788, '370705', '', 176, 0, 0, 'Kuiwen Qu', 'KWN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1789, '370724', '', 176, 0, 0, 'Linqu Xian', 'LNQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1791, '370781', '', 176, 0, 0, 'Qingzhou Shi', 'QGZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1792, '370782', '', 176, 0, 0, 'Zhucheng Shi', 'ZCL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1794, '370784', '', 176, 0, 0, 'Anqiu Shi', 'AQU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1795, '370785', '', 176, 0, 0, 'Gaomi Shi', 'GMI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1796, '370786', '', 176, 0, 0, 'Changyi Shi', 'CYL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1797, '370801', 'Ͻ', 177, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1798, '370802', '', 177, 0, 0, 'Shizhong Qu', 'SZU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1800, '370826', '΢ɽ', 177, 0, 0, 'Weishan Xian', 'WSA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1801, '370827', '̨', 177, 0, 0, 'Yutai Xian', 'YTL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1802, '370828', '', 177, 0, 0, 'Jinxiang Xian', 'JXG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1804, '370830', '', 177, 0, 0, 'Wenshang Xian', 'WNS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1805, '370831', 'ˮ', 177, 0, 0, 'Sishui Xian', 'SSH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1807, '370881', '', 177, 0, 0, 'Qufu Shi', 'QFU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1808, '370882', '', 177, 0, 0, 'Yanzhou Shi', 'YZL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1810, '370901', 'Ͻ', 178, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1811, '370902', '̩ɽ', 178, 0, 0, 'Taishan Qu', 'TSQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1812, '370911', '', 178, 0, 0, 'Daiyue Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1813, '370921', '', 178, 0, 0, 'Ningyang Xian', 'NGY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1814, '370923', 'ƽ', 178, 0, 0, 'Dongping Xian', 'DPG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1816, '370983', 'ʳ', 178, 0, 0, 'Feicheng Shi', 'FEC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1817, '371001', 'Ͻ', 179, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1818, '371002', '', 179, 0, 0, 'Huancui Qu', 'HNC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1820, '371082', 'ٳ', 179, 0, 0, 'Rongcheng Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1821, '371083', 'ɽ', 179, 0, 0, 'Rushan Shi', 'RSN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1822, '371101', 'Ͻ', 180, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1823, '371102', '', 180, 0, 0, 'Donggang Qu', 'DGR');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1824, '371103', 'ɽ', 180, 0, 0, 'Lanshan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1825, '371121', '', 180, 0, 0, 'Wulian Xian', 'WLN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1827, '371201', 'Ͻ', 181, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1828, '371202', '', 181, 0, 0, 'Laicheng Qu', 'LAC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3457, '652826', 'Ȼ', 369, 0, 0, 'Yanqi Huizu Zizhixian', 'YQI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3458, '652827', ';', 369, 0, 0, 'Hejing Xian', 'HJG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3459, '652828', '˶', 369, 0, 0, 'Hoxud Xian', 'HOX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3460, '652829', '', 369, 0, 0, 'Bohu(Bagrax) Xian', 'BHU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3462, '652922', '', 370, 0, 0, 'Wensu Xian', 'WSU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3463, '652923', '⳵', 370, 0, 0, 'Kuqa Xian', 'KUQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3464, '652924', 'ɳ', 370, 0, 0, 'Xayar Xian', 'XYR');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3465, '652925', 'º', 370, 0, 0, 'Xinhe(Toksu) Xian', 'XHT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3466, '652926', 'ݳ', 370, 0, 0, 'Baicheng(Bay) Xian', 'BCG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3467, '652927', 'ʲ', 370, 0, 0, 'Wushi(Uqturpan) Xian', 'WSH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3468, '652928', '', 370, 0, 0, 'Awat Xian', 'AWA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3469, '652929', 'ƺ', 370, 0, 0, 'Kalpin Xian', 'KAL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3470, '653001', 'ͼʲ', 371, 0, 0, 'Artux Shi', 'ART');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3471, '653022', '', 371, 0, 0, 'Akto Xian', 'AKT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3473, '653024', 'ǡ', 371, 0, 0, 'Wuqia(Ulugqat) Xian', 'WQA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3474, '653101', 'ʲ', 372, 0, 0, 'Kashi (Kaxgar) Shi', 'KHG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3475, '653121', '踽', 372, 0, 0, 'Shufu Xian', 'SFU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3477, '653123', 'Ӣɳ', 372, 0, 0, 'Yengisar Xian', 'YEN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3478, '653124', '', 372, 0, 0, 'Zepu(Poskam) Xian', 'ZEP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3479, '653125', 'ɯ', 372, 0, 0, 'Shache(Yarkant) Xian', 'SHC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3481, '653127', '', 372, 0, 0, 'Markit Xian', 'MAR');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3482, '653128', 'պ', 372, 0, 0, 'Yopurga Xian', 'YOP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3484, '653130', 'ͳ', 372, 0, 0, 'Bachu(Maralbexi) Xian', 'BCX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3486, '653201', '', 373, 0, 0, 'Hotan Shi', 'HTS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3487, '653221', '', 373, 0, 0, 'Hotan Xian', 'HOT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3488, '653222', 'ī', 373, 0, 0, 'Moyu(Karakax) Xian', 'MOY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3489, '653223', 'Ƥɽ', 373, 0, 0, 'Pishan(Guma) Xian', 'PSA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3490, '653224', '', 373, 0, 0, 'Lop Xian', 'LOP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3491, '653225', '', 373, 0, 0, 'Qira Xian', 'QIR');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3492, '653226', '', 373, 0, 0, 'Yutian(Keriya) Xian', 'YUT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3493, '653227', '', 373, 0, 0, 'Minfeng(Niya) Xian', 'MFG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3495, '654003', '', 374, 0, 0, 'Kuytun Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3496, '654021', '', 374, 0, 0, 'Yining(Gulja) Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3498, '654023', '', 374, 0, 0, 'Huocheng Xin', '2');
commit;
prompt 200 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3499, '654024', '', 374, 0, 0, 'Gongliu(Tokkuztara) Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3500, '654025', 'Դ', 374, 0, 0, 'Xinyuan(Kunes) Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3501, '654026', '', 374, 0, 0, 'Zhaosu(Mongolkure) Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3502, '654027', 'ؿ˹', 374, 0, 0, 'Tekes Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3503, '654028', 'տ', 374, 0, 0, 'Nilka Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3505, '654202', '', 375, 0, 0, 'Usu Shi', 'USU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3506, '654221', '', 375, 0, 0, 'Emin(Dorbiljin) Xian', 'EMN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3507, '654223', 'ɳ', 375, 0, 0, 'Shawan Xian', 'SWX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3509, '654225', 'ԣ', 375, 0, 0, 'Yumin(Qagantokay) Xian', 'YMN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3511, '654301', '̩', 376, 0, 0, 'Altay Shi', 'ALT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3512, '654321', '', 376, 0, 0, 'Burqin Xian', 'BUX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3513, '654322', '', 376, 0, 0, 'Fuyun(Koktokay) Xian', 'FYN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3514, '654323', '', 376, 0, 0, 'Fuhai(Burultokay) Xian', 'FHI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3515, '654324', 'ͺ', 376, 0, 0, 'Habahe(Kaba) Xian', 'HBH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3516, '654325', '', 376, 0, 0, 'Qinghe(Qinggil) Xian', 'QHX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3518, '659001', 'ʯ', 377, 0, 0, 'Shihezi Shi', 'SHZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3519, '659002', '', 377, 0, 0, 'Alaer Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3521, '659004', '', 377, 0, 0, 'Wujiaqu Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (109, '320100', 'Ͼ', 11, 0, 0, 'Nanjing Shi', 'NKG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (112, '320400', '', 11, 0, 0, 'Changzhou Shi', 'CZX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (116, '320800', '', 11, 0, 0, 'Huai,an Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (120, '321200', '̩', 11, 0, 0, 'Taizhou Shi', 'TZS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (123, '330200', '', 12, 0, 0, 'Ningbo Shi', 'NGB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (127, '330600', '', 12, 0, 0, 'Shaoxing Shi', 'SXG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (131, '331000', '̨', 12, 0, 0, 'Taizhou Shi', 'TZZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (135, '340300', '', 13, 0, 0, 'Bengbu Shi', 'BBU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (138, '340600', '', 13, 0, 0, 'Huaibei Shi', 'HBE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (142, '341100', '', 13, 0, 0, 'Chuzhou Shi', 'CUZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (146, '341500', '', 13, 0, 0, 'Liu,an Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (150, '350100', '', 14, 0, 0, 'Fuzhou Shi', 'FOC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (153, '350400', '', 14, 0, 0, 'Sanming Shi', 'SMS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (157, '350800', '', 14, 0, 0, 'Longyan Shi', 'LYF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (161, '360300', 'Ƽ', 15, 0, 0, 'Pingxiang Shi', 'PXS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (164, '360600', 'ӥ̶', 15, 0, 0, 'Yingtan Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (168, '361000', '', 15, 0, 0, 'Wuzhou Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (172, '370300', 'Ͳ', 16, 0, 0, 'Zibo Shi', 'ZBO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (176, '370700', 'Ϋ', 16, 0, 0, 'Weifang Shi', 'WEF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (180, '371100', '', 16, 0, 0, 'Rizhao Shi', 'RZH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (183, '371400', '', 16, 0, 0, 'Dezhou Shi', 'DZS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (187, '410100', '֣', 17, 0, 0, 'Zhengzhou Shi', 'CGO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (191, '410500', '', 17, 0, 0, 'Anyang Shi', 'AYS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (194, '410800', '', 17, 0, 0, 'Jiaozuo Shi', 'JZY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (198, '411200', 'Ͽ', 17, 0, 0, 'Sanmenxia Shi', 'SMX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (202, '411600', 'ܿ', 17, 0, 0, 'Zhoukou Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (206, '420300', 'ʮ', 18, 0, 0, 'Shiyan Shi', 'SYE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (210, '420800', '', 18, 0, 0, 'Jingmen Shi', 'JMS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (213, '421100', 'Ƹ', 18, 0, 0, 'Huanggang Shi', 'HE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (216, '422800', 'ʩ', 18, 0, 0, 'Enshi Tujiazu Miaozu Zizhizhou', 'ESH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (221, '430400', '', 19, 0, 0, 'Hengyang Shi', 'HNY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (224, '430700', '', 19, 0, 0, 'Changde Shi', 'CDE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (228, '431100', '', 19, 0, 0, 'Yongzhou Shi', 'YZS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (231, '433100', '', 19, 0, 0, 'Xiangxi Tujiazu Miaozu Zizhizhou ', 'XXZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (240, '440900', 'ï', 20, 0, 0, 'Maoming Shi', 'MMI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (244, '441500', 'β', 20, 0, 0, 'Shanwei Shi', 'SWE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (289, '511900', '', 24, 0, 0, 'Bazhong Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (420, '130108', 'ԣ', 37, 0, 0, 'Yuhua Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (423, '130124', '', 37, 0, 0, 'Luancheng Xian', 'LCG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (427, '130128', '', 37, 0, 0, 'Shenze Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (435, '130183', '', 37, 0, 0, 'Jinzhou Shi', 'JZJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (439, '130202', '·', 38, 0, 0, 'Lunan Qu', 'LNB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (443, '130207', '', 38, 0, 0, 'Fengnan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (447, '130225', 'ͤ', 38, 0, 0, 'Leting Xian', 'LTJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (455, '130303', 'ɽ', 39, 0, 0, 'Shanhaiguan Qu', 'SHG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (464, '130404', '', 40, 0, 0, 'Fuxing Qu', 'FXQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (467, '130423', '', 40, 0, 0, 'Linzhang Xian ', 'LNZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (472, '130428', '', 40, 0, 0, 'Feixiang Xian', 'FXJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (476, '130432', 'ƽ', 40, 0, 0, 'Guangping Xian ', 'GPX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (484, '130521', '̨', 41, 0, 0, 'Xingtai Xian', 'XTJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (488, '130525', '¡Ң', 41, 0, 0, 'Longyao Xian', 'LYO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (496, '130533', '', 41, 0, 0, 'Wei Xian ', 'WEX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (499, '130581', 'Ϲ', 41, 0, 0, 'Nangong Shi', 'NGO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (507, '130623', 'ˮ', 42, 0, 0, 'Laishui Xian', 'LSM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (511, '130627', '', 42, 0, 0, 'Tang Xian ', 'TAG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (518, '130634', '', 42, 0, 0, 'Quyang Xian ', 'QUY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (523, '130681', '', 42, 0, 0, 'Zhuozhou Shi', 'ZZO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (531, '130706', '»԰', 43, 0, 0, 'Xiahuayuan Qu ', 'XHY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (535, '130724', 'Դ', 43, 0, 0, 'Guyuan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (539, '130728', '', 43, 0, 0, 'Huai,an Xian', 'HAX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (547, '130803', '˫', 44, 0, 0, 'Shuangluan Qu', 'SLQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (549, '130821', 'е', 44, 0, 0, 'Chengde Xian', 'CDX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (553, '130825', '¡', 44, 0, 0, 'Longhua Xian', 'LHJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (558, '130902', '»', 45, 0, 0, 'Xinhua Qu', 'XHF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (563, '130924', '', 45, 0, 0, 'Haixing Xian', 'HXG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (566, '130927', 'Ƥ', 45, 0, 0, 'Nanpi Xian', 'NPI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (741, '150205', 'ʯ', 60, 0, 0, 'Shiguai Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (744, '150221', 'Ĭ', 60, 0, 0, 'Tumd Youqi', 'TUY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (747, '150301', 'Ͻ', 61, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (750, '150304', 'ڴ', 61, 0, 0, 'Ud Qu', 'UDQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (753, '150403', 'Ԫɽ', 62, 0, 0, 'Yuanbaoshan Qu', 'YBO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (764, '150501', 'Ͻ', 63, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (766, '150521', 'ƶ', 63, 0, 0, 'Horqin Zuoyi Zhongqi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (771, '150526', '³', 63, 0, 0, 'Jarud Qi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (777, '150624', 'п', 64, 0, 0, 'Otog Qi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (781, '150701', 'Ͻ', 65, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (787, '150725', '°Ͷ', 65, 0, 0, 'Chen Barag Qi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (790, '150781', '', 65, 0, 0, 'Manzhouli Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (793, '150784', '', 65, 0, 0, 'Ergun Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (798, '150822', '', 66, 0, 0, 'Dengkou Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (801, '150825', 'غ', 66, 0, 0, 'Urad Houqi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (805, '150921', '׿', 67, 0, 0, 'Zhuozi Xian', '2');
commit;
prompt 300 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (811, '150927', '', 67, 0, 0, 'Qahar Youyi Zhongqi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (820, '152224', 'ͻȪ', 68, 0, 0, 'Tuquan Xian', 'TUQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (826, '152525', '', 69, 0, 0, 'Dong Ujimqin Qi', 'DUJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (833, '152921', '', 70, 0, 0, 'Alxa Zuoqi', 'ALZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (836, '210101', 'Ͻ', 71, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (840, '210105', 'ʹ', 71, 0, 0, 'Huanggu Qu', 'HGU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (843, '210112', '', 71, 0, 0, 'Dongling Qu ', 'DLQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (850, '210201', 'Ͻ', 72, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (995, '220623', '׳', 90, 0, 0, 'Changbaichaoxianzuzizhi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1000, '220721', 'ǰ˹ɹ', 91, 0, 0, 'Qian Gorlos Mongolzu Zizhixian', 'QGO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1011, '222402', 'ͼ', 93, 0, 0, 'Tumen Shi', 'TME');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1015, '222406', '', 93, 0, 0, 'Helong Shi', 'HEL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1019, '230102', '', 94, 0, 0, 'Daoli Qu', 'DLH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1026, '230111', '', 94, 0, 0, 'Hulan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1031, '230127', 'ľ', 94, 0, 0, 'Mulan Xian ', 'MUL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1034, '230112', '', 94, 0, 0, 'Acheng Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1038, '230201', 'Ͻ', 95, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1045, '230208', '÷˹Ӷ', 95, 0, 0, 'Meilisidawoerzu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1051, '230229', 'ɽ', 95, 0, 0, 'Keshan Xian', 'KSN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1055, '230301', 'Ͻ', 96, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1058, '230304', 'ε', 96, 0, 0, 'Didao Qu', 'DDO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1062, '230321', '', 96, 0, 0, 'Jidong Xian', 'JID');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1066, '230402', '', 97, 0, 0, 'Xiangyang  Qu ', 'XYZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1073, '230422', '', 97, 0, 0, 'Suibin Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1077, '230505', 'ķ̨', 98, 0, 0, 'Sifangtai Qu', 'SFT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1081, '230523', '', 98, 0, 0, 'Baoqing Xian', 'BQG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1088, '230606', 'ͬ', 99, 0, 0, 'Datong Qu', 'DHD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1098, '230706', '', 100, 0, 0, 'Cuiluan Qu', 'CLN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1102, '230710', 'Ӫ', 100, 0, 0, 'Wuying Qu', 'WYQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1105, '230713', '', 100, 0, 0, 'Dailing Qu', 'DLY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1108, '230716', 'ϸ', 100, 0, 0, 'Shangganling Qu', 'SGL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1121, '230881', 'ͬ', 101, 0, 0, 'Tongjiang Shi', 'TOJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1125, '230903', 'ɽ', 102, 0, 0, 'Taoshan Qu', 'TSC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1128, '231001', 'Ͻ', 103, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1132, '231005', '', 103, 0, 0, 'Xi,an Qu', 'XAQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1297, '321324', '', 121, 0, 0, 'Sihong Xian', 'SIH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1301, '330104', '', 122, 0, 0, 'Jianggan Qu', 'JGQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1305, '330109', 'ɽ', 122, 0, 0, 'Xiaoshan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1309, '330182', '', 122, 0, 0, 'Jiande Shi', 'JDS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1313, '330203', '', 123, 0, 0, 'Haishu Qu', 'HNB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1317, '330211', '', 123, 0, 0, 'Zhenhai Qu', 'ZHF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1321, '330281', 'Ҧ', 123, 0, 0, 'Yuyao Shi', 'YYO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1325, '330302', '¹', 124, 0, 0, 'Lucheng Qu', 'LUW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1329, '330324', '', 124, 0, 0, 'Yongjia Xian', 'YJX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1333, '330329', '̩˳', 124, 0, 0, 'Taishun Xian', 'TSZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1341, '330481', '', 125, 0, 0, 'Haining Shi', 'HNG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1345, '330502', '', 126, 0, 0, 'Wuxing Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1349, '330523', '', 126, 0, 0, 'Anji Xian', 'AJI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1353, '330624', '²', 127, 0, 0, 'Xinchang Xian', 'XCX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1357, '330701', 'Ͻ', 128, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1361, '330726', 'ֽ', 128, 0, 0, 'Pujiang Xian ', 'PJG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1365, '330783', '', 128, 0, 0, 'Dongyang Shi', 'DGY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1369, '330803', '齭', 129, 0, 0, 'Qujiang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1373, '330881', 'ɽ', 129, 0, 0, 'Jiangshan Shi', 'JIS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1377, '330921', 'ɽ', 130, 0, 0, 'Daishan Xian', 'DSH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1381, '331003', '', 131, 0, 0, 'Huangyan Qu', 'HYT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1385, '331023', '̨', 131, 0, 0, 'Tiantai Xian', 'TTA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1389, '331101', 'Ͻ', 132, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1393, '331123', '', 132, 0, 0, 'Suichang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1397, '331127', '', 132, 0, 0, 'Jingning Shezu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1403, '340111', '', 133, 0, 0, 'Baohe Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1407, '340201', 'Ͻ', 1412, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1411, '340207', '𯽭', 1412, 0, 0, 'Jiujiang Qu', 'JJW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1581, '350626', 'ɽ', 155, 0, 0, 'Dongshan Xian', 'DSN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1585, '350681', '', 155, 0, 0, 'Longhai Shi', 'LHM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1589, '350722', 'ֳ', 156, 0, 0, 'Pucheng Xian', 'PCX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1593, '350781', '', 156, 0, 0, 'Shaowu Shi', 'SWU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1597, '350801', 'Ͻ', 157, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1601, '350823', 'Ϻ', 157, 0, 0, 'Shanghang Xian', 'SHF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1605, '350901', 'Ͻ', 158, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1609, '350923', '', 158, 0, 0, 'Pingnan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1613, '350981', '', 158, 0, 0, 'Fu,an Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1617, '360103', '', 159, 0, 0, 'Xihu Qu ', 'XHQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1620, '360111', 'ɽ', 159, 0, 0, 'Qingshanhu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1625, '360201', 'Ͻ', 160, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1629, '360281', 'ƽ', 160, 0, 0, 'Leping Shi', 'LEP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1633, '360321', '', 161, 0, 0, 'Lianhua Xian', 'LHG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1637, '360402', '®ɽ', 162, 0, 0, 'Lushan Qu', 'LSV');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1641, '360424', 'ˮ', 162, 0, 0, 'Xiushui Xian', 'XSG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1645, '360428', '', 162, 0, 0, 'Duchang Xian', 'DUC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1649, '360501', 'Ͻ', 163, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1653, '360602', 'º', 164, 0, 0, 'Yuehu Qu', 'YHY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1657, '360702', '¹', 165, 0, 0, 'Zhanggong Qu', 'ZGG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1661, '360724', '', 165, 0, 0, 'Shangyou Xian', 'SYO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1665, '360728', '', 165, 0, 0, 'Dingnan Xian', 'DNN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1669, '360732', '˹', 165, 0, 0, 'Xingguo Xian', 'XGG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1673, '360781', '', 165, 0, 0, 'Ruijin Shi', 'RJS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1677, '360803', 'ԭ', 166, 0, 0, 'Qingyuan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1681, '360824', '¸', 166, 0, 0, 'Xingan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1685, '360828', '', 166, 0, 0, 'Wan,an Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1689, '360901', 'Ͻ', 167, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1693, '360923', 'ϸ', 167, 0, 0, 'Shanggao Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1857, '371521', '', 184, 0, 0, 'Yanggu Xian ', 'YGU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1862, '371526', '', 184, 0, 0, 'Gaotang Xian', 'GTG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1866, '371621', '', 185, 0, 0, 'Huimin Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1870, '371625', '', 185, 0, 0, 'Boxing Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1875, '371722', '', 186, 0, 0, 'Shan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1878, '371725', '۩', 186, 0, 0, 'Yuncheng Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1882, '410101', 'Ͻ', 187, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1885, '410104', 'ܳǻ', 187, 0, 0, 'Guancheng Huizu Qu', 'GCH');
commit;
prompt 400 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1891, '410182', '', 187, 0, 0, 'Xingyang Shi', 'XYK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1895, '410201', 'Ͻ', 188, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1903, '410223', 'ξ', 188, 0, 0, 'Weishi Xian', 'WSI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1907, '410302', 'ϳ', 189, 0, 0, 'Laocheng Qu', 'LLY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1910, '410305', '', 189, 0, 0, 'Jianxi Qu', 'JXL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1914, '410323', '°', 189, 0, 0, 'Xin,an Xian', 'XAX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1919, '410328', '', 189, 0, 0, 'Luoning Xian', 'LNI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1923, '410402', '»', 190, 0, 0, 'Xinhua Qu', 'XHP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1927, '410421', '', 190, 0, 0, 'Baofeng Xian', 'BFG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1931, '410481', '', 190, 0, 0, 'Wugang Shi', 'WGY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1935, '410503', '', 191, 0, 0, 'Beiguan Qu', 'BGQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1939, '410523', '', 191, 0, 0, 'Tangyin Xian', 'TYI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1944, '410602', 'ɽ', 192, 0, 0, 'Heshan Qu', 'HSF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1949, '410701', 'Ͻ', 193, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1953, '410711', 'Ұ', 193, 0, 0, 'Muye Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1957, '410726', 'ӽ', 193, 0, 0, 'Yanjin Xian', 'YJN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1961, '410782', '', 193, 0, 0, 'Huixian Shi', 'HXS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1965, '410804', '', 194, 0, 0, 'Macun Qu', 'MCQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1969, '410823', '', 194, 0, 0, 'Wuzhi Xian', 'WZI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1973, '410883', '', 194, 0, 0, 'Mengzhou Shi', 'MZO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2136, '421081', 'ʯ', 212, 0, 0, 'Shishou Shi', 'SSO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2140, '421102', '', 213, 0, 0, 'Huangzhou Qu', 'HZC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2144, '421124', 'Ӣɽ', 213, 0, 0, 'Yingshan Xian', 'YSE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2148, '421181', '', 213, 0, 0, 'Macheng Shi', 'MCS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2152, '421221', '', 214, 0, 0, 'Jiayu Xian', 'JYX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2156, '421281', '', 214, 0, 0, 'Chibi Shi', 'CBI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2160, '422801', 'ʩ', 216, 0, 0, 'Enshi Shi', 'ESS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2164, '422825', '', 216, 0, 0, 'Xuan,en Xian', 'XEN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2168, '429004', '', 217, 0, 0, 'Xiantao Shi', 'XNT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2171, '429021', 'ũ', 217, 0, 0, 'Shennongjia Linqu', 'SNJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2177, '430111', '껨', 218, 0, 0, 'Yuhua Qu', 'YHA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2181, '430181', '', 218, 0, 0, 'Liuyang Shi', 'LYS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2185, '430204', 'ʯ', 219, 0, 0, 'Shifeng Qu', 'SFG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2189, '430224', '', 219, 0, 0, 'Chaling Xian', 'CAL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2193, '430302', '', 220, 0, 0, 'Yuhu Qu', 'YHU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2197, '430382', 'ɽ', 220, 0, 0, 'Shaoshan Shi', 'SSN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2201, '430407', 'ʯ', 221, 0, 0, 'Shigu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2205, '430422', '', 221, 0, 0, 'Hengnan Xian', 'HNX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2213, '430503', '', 222, 0, 0, 'Daxiang Qu', 'DXS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2217, '430523', '', 222, 0, 0, 'Shaoyang Xian', 'SYW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2221, '430528', '', 222, 0, 0, 'Xinning Xian', 'XNI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2227, '430611', 'ɽ', 223, 0, 0, 'Junshan Qu', 'JUS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2231, '430626', 'ƽ', 223, 0, 0, 'Pingjiang Xian', 'PJH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2239, '430723', '', 224, 0, 0, 'Li Xian', 'LXX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2243, '430781', '', 224, 0, 0, 'Jinshi Shi', 'JSS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2251, '430903', 'ɽ', 226, 0, 0, 'Heshan Qu', 'HSY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2405, '441501', 'Ͻ', 244, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2409, '441581', '½', 244, 0, 0, 'Lufeng Shi', 'LUF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2413, '441622', '', 245, 0, 0, 'Longchuan Xian', 'LCY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2417, '441701', 'Ͻ', 246, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2425, '441823', 'ɽ', 247, 0, 0, 'Yangshan Xian', 'YSN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2427, '441826', '', 247, 0, 0, 'Liannanyaozuzizhi Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2433, '445121', '', 250, 0, 0, 'Chao,an Xian', 'CAY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2441, '445301', 'Ͻ', 252, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2445, '445323', 'ư', 252, 0, 0, 'Yun,an Xian', 'YUA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2449, '450103', '', 253, 0, 0, 'Qingxiu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2452, '450108', '', 253, 0, 0, 'Liangqing Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2456, '450124', 'ɽ', 253, 0, 0, 'Mashan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2461, '450202', '', 254, 0, 0, 'Chengzhong Qu', 'CZG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2465, '450221', '', 254, 0, 0, 'Liujiang Xian', 'LUJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2473, '450303', '', 255, 0, 0, 'Diecai Qu', 'DCA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2477, '450321', '˷', 255, 0, 0, 'Yangshuo Xian', 'YSO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2481, '450325', '˰', 255, 0, 0, 'Xing,an Xian', 'XAG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2489, '450401', 'Ͻ', 256, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2493, '450421', '', 256, 0, 0, 'Cangwu Xian', 'CAW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2497, '450501', 'Ͻ', 257, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2501, '450521', '', 257, 0, 0, 'Hepu Xian', 'HPX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2505, '450621', '˼', 258, 0, 0, 'Shangsi Xian', 'SGS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2513, '450802', '۱', 260, 0, 0, 'Gangbei Qu', 'GBE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2517, '450881', 'ƽ', 260, 0, 0, 'Guiping Shi', 'GPS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2525, '451001', 'Ͻ', 262, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2648, '510129', '', 273, 0, 0, 'Dayi Xian', 'DYI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2651, '510181', '', 273, 0, 0, 'Dujiangyan Shi', 'DJY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2656, '510302', '', 274, 0, 0, 'Ziliujing Qu', 'ZLJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2666, '510421', '', 275, 0, 0, 'Miyi Xian', 'MIY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2670, '510503', 'Ϫ', 276, 0, 0, 'Naxi Qu', 'NXI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2674, '510524', '', 276, 0, 0, 'Xuyong Xian', 'XYO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2682, '510683', '', 277, 0, 0, 'Jinzhou Shi', 'MZU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2686, '510722', '̨', 278, 0, 0, 'Santai Xian', 'SNT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2690, '510726', 'Ǽ', 278, 0, 0, 'Beichuanqiangzuzizhi Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2700, '510824', 'Ϫ', 279, 0, 0, 'Cangxi Xian', 'CXC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2704, '510921', 'Ϫ', 280, 0, 0, 'Pengxi Xian', 'PXI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2708, '511002', '', 281, 0, 0, 'Shizhong Qu', 'SZM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2716, '511112', 'ͨ', 282, 0, 0, 'Wutongqiao Qu', 'WTQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2720, '511126', 'н', 282, 0, 0, 'Jiajiang Xian', 'JJC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2727, '511303', 'ƺ', 283, 0, 0, 'Gaoping Qu', 'GPQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2731, '511323', '', 283, 0, 0, 'Peng,an Xian', 'PGA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2735, '511401', 'Ͻ', 284, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2739, '511423', '', 284, 0, 0, 'Hongya Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2743, '511502', '', 285, 0, 0, 'Cuiping Qu', 'CPQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2752, '511529', 'ɽ', 285, 0, 0, 'Pingshan Xian', 'PSC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2756, '511622', 'ʤ', 286, 0, 0, 'Wusheng Xian', 'WSG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2760, '511702', 'ͨ', 287, 0, 0, 'Tongchuan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2769, '511821', 'ɽ', 288, 0, 0, 'Mingshan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2773, '511825', 'ȫ', 288, 0, 0, 'Tianquan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2777, '511902', '', 289, 0, 0, 'Bazhou Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2781, '512001', 'Ͻ', 290, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2790, '513225', 'կ', 291, 0, 0, 'Jiuzhaigou Xian', 'JZG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2794, '513229', '', 291, 0, 0, 'Barkam Xian', 'BAK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2935, '530126', 'ʯ', 303, 0, 0, 'Shilin Yizu Zizhixian', 'SLY');
commit;
prompt 500 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2947, '530326', '', 304, 0, 0, 'Huize Xian', 'HUZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2951, '530402', '', 305, 0, 0, 'Hongta Qu', 'HTA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2955, '530424', '', 305, 0, 0, 'Huaning Xian', 'HND');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2959, '530428', 'Ԫ', 305, 0, 0, 'Yuanjiang Hanizu Yizu Daizu Zizhixian', 'YJA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2969, '530622', 'ɼ', 307, 0, 0, 'Qiaojia Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2977, '530630', 'ˮ', 307, 0, 0, 'Shuifu Xian ', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2980, '530721', '', 308, 0, 0, 'Yulongnaxizuzizhi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (514, '130630', 'Դ', 42, 0, 0, 'Laiyuan Xian ', 'LIY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2989, '530824', 'ȴ', 309, 0, 0, 'Jinggu Daizu Yizu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2991, '530826', 'ǹ', 309, 0, 0, 'Jiangcheng Hanizu Yizu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2993, '530828', '', 309, 0, 0, 'Lancang Lahuzu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2999, '530923', '', 310, 0, 0, 'Yongde Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3001, '530925', '˫岼', 310, 0, 0, 'Shuangjiang Lahuzu Vazu Bulangzu Daizu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3008, '532325', 'Ҧ', 311, 0, 0, 'Yao,an Xian', 'YOA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3012, '532329', '䶨', 311, 0, 0, 'Wuding Xian', 'WDX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3016, '532503', '', 312, 0, 0, 'Mengzi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3019, '532525', 'ʯ', 312, 0, 0, 'Shiping Xian', 'SPG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3023, '532529', '', 312, 0, 0, 'Honghe Xian', 'HHX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3024, '532530', 'ƽ', 312, 0, 0, 'Jinping Miaozu Yaozu Daizu Zizhixian', 'JNP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3033, '532627', '', 313, 0, 0, 'Guangnan Xian', 'GGN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3037, '532823', '', 314, 0, 0, 'Mengla Xian', 'MLA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3039, '532922', '', 315, 0, 0, 'Yangbi Yizu Zizhixian', 'YGB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3044, '532927', 'Ρɽ', 315, 0, 0, 'Weishan Yizu Huizu Zizhixian', 'WSY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3050, '533102', '', 316, 0, 0, 'Ruili Shi', 'RUI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3054, '533124', '¤', 316, 0, 0, 'Longchuan Xian', 'LCN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3057, '533324', 'ɽŭ', 317, 0, 0, 'Gongshan Dulongzu Nuzu Zizhixian', 'GSN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3222, '610802', '', 333, 0, 0, 'Yuyang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3226, '610824', '', 333, 0, 0, 'Jingbian Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3230, '610828', '', 333, 0, 0, 'Jia Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3234, '610901', 'Ͻ', 334, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3238, '610923', '', 334, 0, 0, 'Ningshan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3242, '610927', 'ƺ', 334, 0, 0, 'Zhenping Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3246, '611002', '', 335, 0, 0, 'Shangzhou Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3250, '611024', 'ɽ', 335, 0, 0, 'Shanyang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3254, '620102', 'ǹ', 336, 0, 0, 'Chengguan Qu', 'CLZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3257, '620105', '', 336, 0, 0, 'Anning Qu', 'ANQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3261, '620123', '', 336, 0, 0, 'Yuzhong Xian', 'YZX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3265, '620321', '', 338, 0, 0, 'Yongchang Xian', 'YCF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3269, '620421', 'Զ', 339, 0, 0, 'Jingyuan Xian', 'JYH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3277, '620523', 'ʹ', 340, 0, 0, 'Gangu Xian', 'GGU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3279, '620525', 'żҴ', 340, 0, 0, 'Zhangjiachuan Huizu Zizhixian', 'ZJC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3286, '620702', '', 342, 0, 0, 'Ganzhou Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3288, '620722', '', 342, 0, 0, 'Minle Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3292, '620801', 'Ͻ', 343, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3296, '620823', '', 343, 0, 0, 'Chongxin Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3300, '620901', 'Ͻ', 344, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3305, '620924', '', 344, 0, 0, 'Aksay Kazakzu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3313, '621024', 'ˮ', 345, 0, 0, 'Heshui Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3317, '621101', 'Ͻ', 346, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3321, '621123', 'μԴ', 346, 0, 0, 'Weiyuan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3326, '621202', '䶼', 347, 0, 0, 'Wudu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3331, '621225', '', 347, 0, 0, 'Xihe Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3472, '653023', '', 371, 0, 0, 'Akqi Xian', 'AKQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3476, '653122', '', 372, 0, 0, 'Shule Xian', 'SHL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3480, '653126', 'Ҷ', 372, 0, 0, 'Yecheng(Kargilik) Xian', 'YEC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3483, '653129', '٤ʦ', 372, 0, 0, 'Jiashi(Payzawat) Xian', 'JSI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3485, '653131', 'ʲ', 372, 0, 0, 'Taxkorgan Tajik Zizhixian', 'TXK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3494, '654002', '', 374, 0, 0, 'Yining(Gulja) Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3497, '654022', '첼', 374, 0, 0, 'Qapqal Xibe Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3504, '654201', '', 375, 0, 0, 'Tacheng(Qoqek) Shi', 'TCS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3508, '654224', '', 375, 0, 0, 'Toli Xian', 'TLI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3510, '654226', 'Ͳɹ', 375, 0, 0, 'Hebukesaiermengguzizhi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3517, '654326', 'ľ', 376, 0, 0, 'Jeminay Xian', 'JEM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3520, '659003', 'ͼľ', 377, 0, 0, 'Tumushuke Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (7, '210000', 'ʡ', 1, 0, 0, 'Liaoning Sheng', 'LN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (11, '320000', 'ʡ', 1, 0, 0, 'Jiangsu Sheng', 'JS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (15, '360000', 'ʡ', 1, 0, 0, 'Jiangxi Sheng', 'JX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (19, '430000', 'ʡ', 1, 0, 0, 'Hunan Sheng', 'HN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (25, '520000', 'ʡ', 1, 0, 0, 'Guizhou Sheng', 'GZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (30, '630000', 'ຣʡ', 1, 0, 0, 'Qinghai Sheng', 'QH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (23, '500000', '', 1, 0, 0, 'Chongqing Shi', 'CQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (526, '130684', '߱', 42, 0, 0, 'Gaobeidian Shi', 'GBD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (543, '130732', '', 43, 0, 0, 'Chicheng Xian', 'CCX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (555, '130827', '', 44, 0, 0, 'Kuancheng Manzu Zizhixian', 'KCX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (569, '130930', 'ϴ', 45, 0, 0, 'Mengcun Huizu Zizhixian', 'MCN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (760, '150426', 'ţ', 62, 0, 0, 'Ongniud Qi', 'ONG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (774, '150621', '', 64, 0, 0, 'Dalad Qi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (784, '150722', 'ĪߴӶ', 65, 0, 0, 'Morin Dawa Daurzu Zizhiqi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (809, '150925', '', 67, 0, 0, 'Liangcheng Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (814, '150981', '', 67, 0, 0, 'Fengzhen Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (822, '152502', 'ֺ', 69, 0, 0, 'Xilinhot Shi', 'XLI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (829, '152528', '', 69, 0, 0, 'Xianghuang(Hobot Xar) Qi', 'XHG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (847, '210123', 'ƽ', 71, 0, 0, 'Kangping Xian', 'KPG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1007, '220822', 'ͨ', 92, 0, 0, 'Tongyu Xian', 'TGY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1042, '230205', 'Ϫ', 95, 0, 0, 'Ang,angxi Qu', 'AAX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1069, '230405', '˰', 97, 0, 0, 'Xing,an Qu', 'XAH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1085, '230603', '', 99, 0, 0, 'Longfeng Qu', 'LFQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1092, '230624', 'Ŷɹ', 99, 0, 0, 'Dorbod Mongolzu Zizhixian', 'DOM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1117, '230822', '', 101, 0, 0, 'Huanan Xian', 'HNH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2209, '430481', '', 221, 0, 0, 'Leiyang Shi', 'LEY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2223, '430581', '', 222, 0, 0, 'Wugang Shi', 'WGS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2235, '430702', '', 224, 0, 0, 'Wuling Qu', 'WLQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2246, '430811', 'Դ', 225, 0, 0, 'Wulingyuan Qu', 'WLY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2421, '441781', '', 246, 0, 0, 'Yangchun Shi', 'YCU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2437, '445221', 'Ҷ', 251, 0, 0, 'Jiedong Xian', 'JDX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2469, '450225', 'ˮ', 254, 0, 0, 'Rongshui Miaozu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2484, '450328', 'ʤ', 255, 0, 0, 'Longsheng Gezu Zizhixian', 'LSG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2509, '450703', 'ձ', 259, 0, 0, 'Qinbei Qu', 'QBQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2521, '450922', '½', 261, 0, 0, 'Luchuan Xian', 'LCJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2661, '510322', '˳', 274, 0, 0, 'Fushun Xian', 'FSH');
commit;
prompt 600 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2678, '510623', 'н', 277, 0, 0, 'Zhongjiang Xian', 'ZGJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2696, '510812', '', 279, 0, 0, 'Chaotian Qu', 'CTN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2712, '511028', '¡', 281, 0, 0, 'Longchang Xian', 'LCC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2722, '511132', '', 282, 0, 0, 'Ebian Yizu Zizhixian', 'EBN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2747, '511524', '', 285, 0, 0, 'Changning Xian', 'CNX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2764, '511724', '', 287, 0, 0, 'Dazhu Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2785, '512081', '', 290, 0, 0, 'Jianyang Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2933, '530124', '', 303, 0, 0, 'Fumin Xian', 'FMN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2938, '530129', 'Ѱ', 303, 0, 0, 'Xundian Huizu Yizu Zizhixian', 'XDN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2957, '530426', 'ɽ', 305, 0, 0, 'Eshan Yizu Zizhixian', 'ESN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2973, '530626', '罭', 307, 0, 0, 'Suijiang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2986, '530821', '', 309, 0, 0, 'Pu,er Hanizu Yizu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1757, '370323', 'Դ', 172, 0, 0, 'Yiyuan Xian', 'YIY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1762, '370405', '̨ׯ', 173, 0, 0, 'Tai,erzhuang Qu', 'TEZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1767, '370503', 'ӿ', 174, 0, 0, 'Hekou Qu', 'HKO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1770, '370523', '', 174, 0, 0, 'Guangrao Xian ', 'GRO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1776, '370634', '', 175, 0, 0, 'Changdao Xian', 'CDO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1779, '370683', '', 175, 0, 0, 'Laizhou Shi', 'LZG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1782, '370686', 'ϼ', 175, 0, 0, 'Qixia Shi', 'QXS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (186, '371700', '', 16, 3, 0, 'Heze Shi', 'HZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1787, '370704', '', 176, 0, 0, 'Fangzi Qu', 'FZQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2645, '510121', '', 273, 0, 0, 'Jintang Xian', 'JNT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2650, '510132', '½', 273, 0, 0, 'Xinjin Xian', 'XJC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2654, '510184', '', 273, 0, 0, 'Chongzhou Shi', 'CZO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2663, '510402', '', 275, 0, 0, 'Dong Qu', 'DQP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2669, '510502', '', 276, 0, 0, 'Jiangyang Qu', 'JYB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2675, '510525', '', 276, 0, 0, 'Gulin Xian', 'GUL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2680, '510681', '㺺', 277, 0, 0, 'Guanghan Shi', 'GHN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2685, '510704', '', 278, 0, 0, 'Youxian Qu', 'YXM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2691, '510727', 'ƽ', 278, 0, 0, 'Pingwu Xian', 'PWU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2697, '510821', '', 279, 0, 0, 'Wangcang Xian', 'WGC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2705, '510922', '', 280, 0, 0, 'Shehong Xian', 'SHE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2711, '511025', '', 281, 0, 0, 'Zizhong Xian', 'ZZC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2718, '511123', 'Ϊ', 282, 0, 0, 'Qianwei Xian', 'QWE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2723, '511133', '', 282, 0, 0, 'Mabian Yizu Zizhixian', 'MBN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2730, '511322', 'Ӫɽ', 283, 0, 0, 'Yingshan Xian', 'YGS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2734, '511381', '', 283, 0, 0, 'Langzhong Shi', 'LZJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2740, '511424', '', 284, 0, 0, 'Danling Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2746, '511523', '', 285, 0, 0, 'Jiang,an Xian', 'JAC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2750, '511527', '', 285, 0, 0, 'Junlian Xian', 'JNL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2757, '511623', 'ˮ', 286, 0, 0, 'Linshui Xian', 'LSH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2763, '511723', '', 287, 0, 0, 'Kaijiang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2771, '511823', 'Դ', 288, 0, 0, 'Hanyuan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2775, '511827', '', 288, 0, 0, 'Baoxing Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2780, '511923', 'ƽ', 289, 0, 0, 'Pingchang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2787, '513222', '', 291, 0, 0, 'Li Xian', 'LXC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2791, '513226', '', 291, 0, 0, 'Jinchuan Xian', 'JCH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2795, '513230', '', 291, 0, 0, 'Zamtang Xian', 'ZAM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2798, '513233', 'ԭ', 291, 0, 0, 'Hongyuan Xian', 'HOY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2800, '513322', '', 292, 0, 0, 'Luding(Jagsamka) Xian', 'LUD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2802, '513324', '', 292, 0, 0, 'Jiulong(Gyaisi) Xian', 'JLC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2879, '522229', '', 298, 0, 0, 'Songtao Miaozu Zizhixian', 'STM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2883, '522323', 'հ', 299, 0, 0, 'Pu,an Xian', 'PUA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2886, '522326', '', 299, 0, 0, 'Wangmo Xian', 'WMO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2889, '522401', 'Ͻ', 300, 0, 0, 'Bijie Shi', 'BJE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2892, '522424', 'ɳ', 300, 0, 0, 'Jinsha Xian', 'JSX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2895, '522427', '', 300, 0, 0, 'Weining Yizu Huizu Miaozu Zizhixian', 'WNG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2900, '522624', '', 301, 0, 0, 'Sansui Xian', 'SAS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2903, '522627', '', 301, 0, 0, 'Tianzhu Xian', 'TZU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2906, '522630', '̨', 301, 0, 0, 'Taijiang Xian', 'TJX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2909, '522633', 'ӽ', 301, 0, 0, 'Congjiang Xian', 'COJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2913, '522701', '', 302, 0, 0, 'Duyun Shi', 'DUY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2916, '522723', '', 302, 0, 0, 'Guiding Xian', 'GDG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2920, '522728', '޵', 302, 0, 0, 'Luodian Xian', 'LOD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2923, '522731', 'ˮ', 302, 0, 0, 'Huishui Xian', 'HUS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2926, '530102', '廪', 303, 0, 0, 'Wuhua Qu', 'WHA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2930, '530113', '', 303, 0, 0, 'Dongchuan Qu', 'DCU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2934, '530125', '', 303, 0, 0, 'Yiliang Xian', 'YIL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2937, '530128', '»Ȱ', 303, 0, 0, 'Luchuan Yizu Miaozu Zizhixian', 'LUC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2945, '530324', 'ƽ', 304, 0, 0, 'Luoping Xian', 'LPX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2949, '530381', '', 304, 0, 0, 'Xuanwei Shi', 'XWS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2954, '530423', 'ͨ', 305, 0, 0, 'Tonghai Xian', 'THI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2958, '530427', 'ƽ', 305, 0, 0, 'Xinping Yizu Daizu Zizhixian', 'XNP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2968, '530621', '³', 307, 0, 0, 'Ludian Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2972, '530625', '', 307, 0, 0, 'Yongshan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2976, '530629', '', 307, 0, 0, 'Weixin Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2983, '530724', '', 308, 0, 0, 'Ninglang Yizu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2988, '530823', '', 309, 0, 0, 'Jingdong Yizu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2992, '530827', '', 309, 0, 0, 'Menglian Daizu Lahuzu Vazu Zizixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3002, '530926', '', 310, 0, 0, 'Gengma Daizu Vazu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3005, '532322', '˫', 311, 0, 0, 'Shuangbai Xian', 'SBA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3010, '532327', '', 311, 0, 0, 'Yongren Xian', 'YRN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3014, '532501', '', 312, 0, 0, 'Gejiu Shi', 'GJU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3017, '532523', '', 312, 0, 0, 'Pingbian Miaozu Zizhixian', 'PBN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3103, '542330', 'ʲ', 322, 0, 0, 'Rinbung Xian', 'RIN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3106, '542333', 'ٰ', 322, 0, 0, 'Zhongba Xian', 'ZHB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3108, '542335', '¡', 322, 0, 0, 'Gyirong Xian', 'GIR');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3112, '542421', '', 323, 0, 0, 'Nagqu Xian', 'NAG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3116, '542425', '', 323, 0, 0, 'Amdo Xian', 'AMD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3119, '542428', '', 323, 0, 0, 'Bangoin Xian', 'BGX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3123, '542522', '', 324, 0, 0, 'Zanda Xian', 'ZAN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3127, '542526', '', 324, 0, 0, 'Gerze Xian', 'GER');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3130, '542622', '', 325, 0, 0, 'Gongbo,gyamda Xian', 'GOX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3133, '542625', '', 325, 0, 0, 'Bomi(Bowo) Xian', 'BMI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3140, '610111', '', 326, 0, 0, 'Baqiao Qu', 'BQQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3144, '610115', '', 326, 0, 0, 'Lintong Qu', 'LTG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3148, '610125', '', 326, 0, 0, 'Hu Xian', 'HUX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3156, '610302', 'μ', 328, 0, 0, 'Weibin Qu', 'WBQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3160, '610323', 'ɽ', 328, 0, 0, 'Qishan Xian', 'QIS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3164, '610328', 'ǧ', 328, 0, 0, 'Qianyang Xian', 'QNY');
commit;
prompt 700 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3169, '610402', 'ض', 329, 0, 0, 'Qindu Qu', 'QDU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3173, '610423', '', 329, 0, 0, 'Jingyang Xian', 'JGY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3176, '610426', '', 329, 0, 0, 'Yongshou Xian', 'YSH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3180, '610430', '', 329, 0, 0, 'Chunhua Xian', 'CHU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3185, '610521', '', 330, 0, 0, 'Hua Xian', 'HXN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3188, '610524', '', 330, 0, 0, 'Heyang Xian', 'HYK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3191, '610527', 'ˮ', 330, 0, 0, 'Baishui Xian', 'BSU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3194, '610582', '', 330, 0, 0, 'Huayin Shi', 'HYI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3199, '610623', 'ӳ', 331, 0, 0, 'Zichang Xian', 'ZCA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3202, '610626', '', 331, 0, 0, 'Wuqi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3206, '610630', '˴', 331, 0, 0, 'Yichuan Xian', 'YIC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3208, '610632', '', 331, 0, 0, 'Huangling Xian', 'HLG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1790, '370725', '', 176, 0, 0, 'Changle Xian', 'CLX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1793, '370783', 'ٹ', 176, 0, 0, 'Shouguang Shi', 'SGG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1799, '370811', 'γ', 177, 0, 0, 'Rencheng Qu', 'RCQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1803, '370829', '', 177, 0, 0, 'Jiaxiang Xian', 'JXP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1806, '370832', 'ɽ', 177, 0, 0, 'Liangshan Xian', 'LSN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1809, '370883', '޳', 177, 0, 0, 'Zoucheng Shi', 'ZCG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1815, '370982', '̩', 178, 0, 0, 'Xintai Shi', 'XTA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1819, '371081', 'ĵ', 179, 0, 0, 'Wendeng Shi', 'WDS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1826, '371122', '', 180, 0, 0, 'Ju Xian', 'JUX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1831, '371302', 'ɽ', 182, 0, 0, 'Lanshan Qu', 'LLS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1835, '371322', '۰', 182, 0, 0, 'Tancheng Xian', 'TCE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1839, '371326', 'ƽ', 182, 0, 0, 'Pingyi Xian', 'PYI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1842, '371329', '', 182, 0, 0, 'Linshu Xian', 'LSP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1847, '371423', '', 183, 0, 0, 'Qingyun Xian', 'QYL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1850, '371426', 'ƽԭ', 183, 0, 0, 'Pingyuan Xian', 'PYN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1854, '371482', '', 183, 0, 0, 'Yucheng Shi', 'YCL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1859, '371523', 'ƽ', 184, 0, 0, 'Chiping Xian ', 'CPG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1863, '371581', '', 184, 0, 0, 'Linqing Xian', 'LQS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2007, '411324', 'ƽ', 199, 0, 0, 'Zhenping Xian', 'ZPX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2010, '411327', '', 199, 0, 0, 'Sheqi Xian', 'SEQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2013, '411330', 'ͩ', 199, 0, 0, 'Tongbai Xian', 'TBX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2018, '411421', 'Ȩ', 200, 0, 0, 'Minquan Xian', 'MQY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2021, '411424', 'ϳ', 200, 0, 0, 'Zhecheng Xian', 'ZHC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2024, '411481', '', 200, 0, 0, 'Yongcheng Shi', 'YOC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2029, '411522', 'ɽ', 201, 0, 0, 'Guangshan Xian', 'GSX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2033, '411526', '괨', 201, 0, 0, 'Huangchuan Xian', 'HCU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2039, '411622', '', 202, 0, 0, 'Xihua Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2042, '411625', '', 202, 0, 0, 'Dancheng Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2045, '411628', '¹', 202, 0, 0, 'Luyi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2050, '411722', 'ϲ', 203, 0, 0, 'Shangcai Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2054, '411726', '', 203, 0, 0, 'Biyang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2059, '420102', '', 204, 0, 0, 'Jiang,an Qu', 'JAA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2063, '420106', '', 204, 0, 0, 'Wuchang Qu', 'WCQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2068, '420114', '̵', 204, 0, 0, 'Caidian Qu', 'CDN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2071, '420117', '', 204, 0, 0, 'Xinzhou Qu', 'XNZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2077, '420222', '', 205, 0, 0, 'Yangxin Xian', 'YXE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2081, '420303', '', 206, 0, 0, 'Zhangwan Qu', 'ZWQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2085, '420324', 'Ϫ', 206, 0, 0, 'Zhuxi Xian', 'ZXX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2089, '420502', '', 207, 0, 0, 'Xiling Qu', 'XLQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2094, '420525', 'Զ', 207, 0, 0, 'Yuan,an Xian', 'YAX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2097, '420528', '', 207, 0, 0, 'Changyang Tujiazu Zizhixian', 'CYA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2100, '420582', '', 207, 0, 0, 'Dangyang Shi', 'DYS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2232, '430681', '', 223, 0, 0, 'Miluo Shi', 'MLU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2237, '430721', '', 224, 0, 0, 'Anxiang Xian', 'AXG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2242, '430726', 'ʯ', 224, 0, 0, 'Shimen Xian', 'SHM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2248, '430822', 'ɣֲ', 225, 0, 0, 'Sangzhi Xian', 'SZT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2254, '430923', '', 226, 0, 0, 'Anhua Xian', 'ANH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2259, '431021', '', 227, 0, 0, 'Guiyang Xian', 'GYX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2262, '431024', 'κ', 227, 0, 0, 'Jiahe Xian', 'JAH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2265, '431027', '', 227, 0, 0, 'Guidong Xian', 'GDO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2270, '431103', 'ˮ̲', 228, 0, 0, 'Lengshuitan Qu', 'LST');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2273, '431123', '˫', 228, 0, 0, 'Shuangpai Xian', 'SPA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2277, '431127', 'ɽ', 228, 0, 0, 'Lanshan Xian', 'LNS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2279, '431129', '', 228, 0, 0, 'Jianghua Yaozu Zizhixian', 'JHX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2285, '431224', '', 229, 0, 0, 'Xupu Xian', 'XUP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2287, '431226', '', 229, 0, 0, 'Mayang Miaozu Zizhixian', 'MYX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2289, '431228', 'ƽ', 229, 0, 0, 'Zhijiang Dongzu Zizhixian', 'ZJX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2292, '431281', '齭', 229, 0, 0, 'Hongjiang Shi', 'HGJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2297, '431381', 'ˮ', 230, 0, 0, 'Lengshuijiang Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2300, '433122', 'Ϫ', 231, 0, 0, 'Luxi Xian', 'LXW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2303, '433125', '', 231, 0, 0, 'Baojing Xian', 'BJG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2306, '433130', 'ɽ', 231, 0, 0, 'Longshan Xian', 'LSR');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2312, '440106', '', 232, 0, 0, 'Tianhe Qu', 'THQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2317, '440114', '', 232, 0, 0, 'Huadu Qu', 'HDU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2321, '440203', '佭', 233, 0, 0, 'Wujiang Qu', 'WJQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2326, '440229', 'Դ', 233, 0, 0, 'Wengyuan Xian', 'WYN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2328, '440233', '·', 233, 0, 0, 'Xinfeng Xian', 'XFY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2332, '440303', '޺', 234, 0, 0, 'Luohu Qu', 'LHQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2443, '445321', '', 252, 0, 0, 'Xinxing Xian', 'XNX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2448, '450102', '', 253, 0, 0, 'Xingning Qu', 'XNE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2457, '450125', '', 253, 0, 0, 'Shanglin Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2462, '450203', '', 254, 0, 0, 'Yufeng Qu', 'YFQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2467, '450223', '¹կ', 254, 0, 0, 'Luzhai Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2470, '450226', '', 254, 0, 0, 'Sanjiang Dongzu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2478, '450322', 'ٹ', 255, 0, 0, 'Lingui Xian', 'LGI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2482, '450326', '', 255, 0, 0, 'Yongfu Xian', 'YFU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2488, '450332', '', 255, 0, 0, 'Gongcheng Yaozu Zizhixian', 'GGC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2496, '450481', 'Ϫ', 256, 0, 0, 'Cenxi Shi', 'CEX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2500, '450512', 'ɽ', 257, 0, 0, 'Tieshangangqu ', 'TSG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1829, '371203', 'ֳ', 181, 0, 0, 'Gangcheng Qu', 'GCQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1830, '371301', 'Ͻ', 182, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1832, '371311', 'ׯ', 182, 0, 0, 'Luozhuang Qu', 'LZU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1833, '371301', 'Ӷ', 182, 0, 0, 'Hedong Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1834, '371321', '', 182, 0, 0, 'Yinan Xian', 'YNN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1836, '371323', 'ˮ', 182, 0, 0, 'Yishui Xian', 'YIS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1837, '371324', 'ɽ', 182, 0, 0, 'Cangshan Xian', 'CSH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1838, '371325', '', 182, 0, 0, 'Fei Xian', 'FEI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1840, '371327', '', 182, 0, 0, 'Junan Xian', 'JNB');
commit;
prompt 800 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1841, '371328', '', 182, 0, 0, 'Mengyin Xian', 'MYL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1843, '371401', 'Ͻ', 183, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1844, '371402', '³', 183, 0, 0, 'Decheng Qu', 'DCD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1845, '371421', '', 183, 0, 0, 'Ling Xian', 'LXL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1846, '371422', '', 183, 0, 0, 'Ningjin Xian', 'NGJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1848, '371424', '', 183, 0, 0, 'Linyi xian', 'LYM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1849, '371425', '', 183, 0, 0, 'Qihe Xian', 'QIH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1851, '371427', 'Ľ', 183, 0, 0, 'Xiajin Xian', 'XAJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1852, '371428', '', 183, 0, 0, 'Wucheng Xian', 'WUC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1853, '371481', '', 183, 0, 0, 'Leling Shi', 'LEL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1855, '371501', 'Ͻ', 184, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1856, '371502', '', 184, 0, 0, 'Dongchangfu Qu', 'DCF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1858, '371522', 'ݷ', 184, 0, 0, 'Shen Xian', 'SHN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1860, '371524', '', 184, 0, 0, 'Dong,e Xian', 'DGE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1861, '371525', '', 184, 0, 0, 'Guan Xian', 'GXL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1864, '371601', 'Ͻ', 185, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1865, '371602', '', 185, 0, 0, 'Bincheng Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1867, '371622', '', 185, 0, 0, 'Yangxin Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1868, '371623', '', 185, 0, 0, 'Wudi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1869, '371624', 'մ', 185, 0, 0, 'Zhanhua Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1871, '371626', 'ƽ', 185, 0, 0, 'Zouping Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1873, '371702', 'ĵ', 186, 0, 0, 'Mudan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1874, '371721', '', 186, 0, 0, 'Cao Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1876, '371723', '', 186, 0, 0, 'Chengwu Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1877, '371724', 'Ұ', 186, 0, 0, 'Juye Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1879, '371726', '۲', 186, 0, 0, 'Juancheng Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1880, '371727', '', 186, 0, 0, 'Dingtao Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1881, '371728', '', 186, 0, 0, 'Dongming Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1883, '410102', 'ԭ', 187, 0, 0, 'Zhongyuan Qu', 'ZYQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1884, '410103', '', 187, 0, 0, 'Erqi Qu', 'EQQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1886, '410105', 'ˮ', 187, 0, 0, 'Jinshui Qu', 'JSU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1887, '410106', 'Ͻ', 187, 0, 0, 'Shangjie Qu', 'SJE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1888, '410108', 'ݼ', 187, 0, 0, 'Mangshan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1889, '410122', 'Ĳ', 187, 0, 0, 'Zhongmou Xian', 'ZMO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1890, '410181', '', 187, 0, 0, 'Gongyi Shi', 'GYI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1892, '410183', '', 187, 0, 0, 'Xinmi Shi', 'XMI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1893, '410184', '֣', 187, 0, 0, 'Xinzheng Shi', 'XZG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1894, '410185', 'Ƿ', 187, 0, 0, 'Dengfeng Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1896, '410202', 'ͤ', 188, 0, 0, 'Longting Qu', 'LTK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1897, '410203', '˳ӻ', 188, 0, 0, 'Shunhe Huizu Qu', 'SHR');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1899, '410205', '̨', 188, 0, 0, 'Yuwangtai Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1900, '410211', '', 188, 0, 0, 'Jinming Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1901, '410221', '', 188, 0, 0, 'Qi Xian', 'QIX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1902, '410222', 'ͨ', 188, 0, 0, 'Tongxu Xian', 'TXY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1904, '410224', '', 188, 0, 0, 'Kaifeng Xian', 'KFX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1905, '410225', '', 188, 0, 0, 'Lankao Xian', 'LKA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1906, '410301', 'Ͻ', 189, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1908, '410303', '', 189, 0, 0, 'Xigong Qu', 'XGL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1909, '410304', 'eӻ', 189, 0, 0, 'Chanhehuizu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1911, '410306', '', 189, 0, 0, 'Jili Qu', 'JLL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1912, '410311', '', 189, 0, 0, 'Luolong Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1913, '410322', 'Ͻ', 189, 0, 0, 'Mengjin Xian', 'MGJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1915, '410324', 'ﴨ', 189, 0, 0, 'Luanchuan Xian', 'LCK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1916, '410325', '', 189, 0, 0, 'Song Xian', 'SON');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1917, '410326', '', 189, 0, 0, 'Ruyang Xian', 'RUY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1918, '410327', '', 189, 0, 0, 'Yiyang Xian', 'YYY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1920, '410329', '', 189, 0, 0, 'Yichuan Xian', 'YCZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1921, '410381', 'ʦ', 189, 0, 0, 'Yanshi Shi', 'YST');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1922, '410401', 'Ͻ', 190, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1924, '410403', '', 190, 0, 0, 'Weidong Qu', 'WDG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1925, '410404', 'ʯ', 190, 0, 0, 'Shilong Qu', 'SIL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1926, '410411', 'տ', 190, 0, 0, 'Zhanhe Qu', 'ZHQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1928, '410422', 'Ҷ', 190, 0, 0, 'Ye Xian', 'YEX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1929, '410423', '³ɽ', 190, 0, 0, 'Lushan Xian', 'LUS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1932, '410482', '', 190, 0, 0, 'Ruzhou Shi', 'RZO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1933, '410501', 'Ͻ', 191, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1934, '410502', 'ķ', 191, 0, 0, 'Wenfeng Qu', 'WFQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1936, '410505', '', 191, 0, 0, 'Yindu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1937, '410506', '', 191, 0, 0, 'Longan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1938, '410522', '', 191, 0, 0, 'Anyang Xian', 'AYX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1940, '410526', '', 191, 0, 0, 'Hua Xian', 'HUA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1941, '410527', 'ڻ', 191, 0, 0, 'Neihuang Xian', 'NHG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1942, '410581', '', 191, 0, 0, 'Linzhou Shi', 'LZY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1943, '410601', 'Ͻ', 192, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1945, '410603', 'ɽ', 192, 0, 0, 'Shancheng Qu', 'SCB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1946, '410611', '俱', 192, 0, 0, 'Qibin Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1947, '410621', '', 192, 0, 0, 'Xun Xian', 'XUX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1948, '410622', '', 192, 0, 0, 'Qi Xian', 'QXY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1950, '410702', '', 193, 0, 0, 'Hongqi Qu', 'HQQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1951, '410703', '', 193, 0, 0, 'Weibin Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1952, '410704', 'Ȫ', 193, 0, 0, 'Fengquan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1954, '410721', '', 193, 0, 0, 'Xinxiang Xian', 'XXX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1955, '410724', '', 193, 0, 0, 'Huojia Xian', 'HOJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1956, '410725', 'ԭ', 193, 0, 0, 'Yuanyang Xian', 'YYA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1958, '410727', '', 193, 0, 0, 'Fengqiu Xian', 'FQU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1959, '410728', 'ԫ', 193, 0, 0, 'Changyuan Xian', 'CYU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1960, '410781', '', 193, 0, 0, 'Weihui Shi', 'WHS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1962, '410801', 'Ͻ', 194, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1963, '410802', '', 194, 0, 0, 'Jiefang Qu', 'JFQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1964, '410803', 'վ', 194, 0, 0, 'Zhongzhan Qu', 'ZZQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1966, '410811', 'ɽ', 194, 0, 0, 'Shanyang Qu', 'SYC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1967, '410821', '', 194, 0, 0, 'Xiuwu Xian', 'XUW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1968, '410822', '', 194, 0, 0, 'Bo,ai Xian', 'BOA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1970, '410825', '', 194, 0, 0, 'Wen Xian', 'WEN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1971, '419001', 'Դ', 194, 0, 0, 'Jiyuan Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1972, '410882', '', 194, 0, 0, 'Qinyang Shi', 'QYS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1974, '410901', 'Ͻ', 195, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1975, '410902', '', 195, 0, 0, 'Hualong Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1976, '410922', '', 195, 0, 0, 'Qingfeng Xian', 'QFG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1977, '410923', '', 195, 0, 0, 'Nanle Xian', 'NLE');
commit;
prompt 900 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1978, '410926', '', 195, 0, 0, 'Fan Xian', 'FAX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1979, '410927', '̨ǰ', 195, 0, 0, 'Taiqian Xian', 'TQN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1980, '410928', '', 195, 0, 0, 'Puyang Xian', 'PUY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1981, '411001', 'Ͻ', 196, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1982, '411002', 'κ', 196, 0, 0, 'Weidu Qu', 'WED');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1983, '411023', '', 196, 0, 0, 'Xuchang Xian', 'XUC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1984, '411024', '۳', 196, 0, 0, 'Yanling Xian', 'YLY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1985, '411025', '', 196, 0, 0, 'Xiangcheng Xian', 'XAC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1986, '411081', '', 196, 0, 0, 'Yuzhou Shi', 'YUZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1987, '411082', '', 196, 0, 0, 'Changge Shi', 'CGE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1988, '411101', 'Ͻ', 197, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1989, '411102', 'Դ', 197, 0, 0, 'Yuanhui Qu', 'YHI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1990, '411103', '۱', 197, 0, 0, 'Yancheng Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1991, '411104', '', 197, 0, 0, 'Zhaoling Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1992, '411121', '', 197, 0, 0, 'Wuyang Xian', 'WYG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1993, '411122', '', 197, 0, 0, 'Linying Xian', 'LNY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1994, '411201', 'Ͻ', 198, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1995, '411202', '', 198, 0, 0, 'Hubin Qu', 'HBI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1996, '411221', 'ų', 198, 0, 0, 'Mianchi Xian', 'MCI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1997, '411222', '', 198, 0, 0, 'Shan Xian', 'SHX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1998, '411224', '¬', 198, 0, 0, 'Lushi Xian', 'LUU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1999, '411281', '', 198, 0, 0, 'Yima Shi', 'YMA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2000, '411282', '鱦', 198, 0, 0, 'Lingbao Shi', 'LBS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2001, '411301', 'Ͻ', 199, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2002, '411302', '', 199, 0, 0, 'Wancheng Qu', 'WCN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2003, '411303', '', 199, 0, 0, 'Wolong Qu', 'WOL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2004, '411321', '', 199, 0, 0, 'Nanzhao Xian', 'NZO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2005, '411322', '', 199, 0, 0, 'Fangcheng Xian', 'FCX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2006, '411323', 'Ͽ', 199, 0, 0, 'Xixia Xian', 'XXY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2008, '411325', '', 199, 0, 0, 'Neixiang Xian', 'NXG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2009, '411326', '', 199, 0, 0, 'Xichuan Xian', 'XCY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2011, '411328', 'ƺ', 199, 0, 0, 'Tanghe Xian', 'TGH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2012, '411329', 'Ұ', 199, 0, 0, 'Xinye Xian', 'XYE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2014, '411381', '', 199, 0, 0, 'Dengzhou Shi', 'DGZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2015, '411401', 'Ͻ', 200, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2016, '411402', '԰', 200, 0, 0, 'Liangyuan Qu', 'LYY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2017, '411403', '', 200, 0, 0, 'Suiyang Qu', 'SYA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2019, '411422', '', 200, 0, 0, 'Sui Xian', 'SUI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2020, '411423', '', 200, 0, 0, 'Ningling Xian', 'NGL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2022, '411425', 'ݳ', 200, 0, 0, 'Yucheng Xian', 'YUC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2023, '411426', '', 200, 0, 0, 'Xiayi Xian', 'XAY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2025, '411501', 'Ͻ', 201, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2026, '411502', '', 201, 0, 0, 'Shihe Qu', 'SHU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2027, '411503', 'ƽ', 201, 0, 0, 'Pingqiao Qu', 'PQQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2028, '411521', 'ɽ', 201, 0, 0, 'Luoshan Xian', 'LSE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2030, '411523', '', 201, 0, 0, 'Xin Xian', 'XXI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2031, '411524', '̳', 201, 0, 0, 'Shangcheng Xian', 'SCX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2032, '411525', 'ʼ', 201, 0, 0, 'Gushi Xian', 'GSI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2034, '411527', '', 201, 0, 0, 'Huaibin Xian', 'HBN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2035, '411528', 'Ϣ', 201, 0, 0, 'Xi Xian', 'XIX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2036, '411601', 'Ͻ', 202, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2037, '411602', '', 202, 0, 0, 'Chuanhui Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2038, '411621', '', 202, 0, 0, 'Fugou Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2040, '411623', 'ˮ', 202, 0, 0, 'Shangshui Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2041, '411624', '', 202, 0, 0, 'Shenqiu Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2043, '411626', '', 202, 0, 0, 'Huaiyang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2044, '411627', '̫', 202, 0, 0, 'Taikang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2046, '411681', '', 202, 0, 0, 'Xiangcheng Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2047, '411701', 'Ͻ', 203, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2048, '411702', '', 203, 0, 0, 'Yicheng Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2049, '411721', 'ƽ', 203, 0, 0, 'Xiping Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2051, '411723', 'ƽ', 203, 0, 0, 'Pingyu Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2052, '411724', '', 203, 0, 0, 'Zhengyang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2053, '411725', 'ȷɽ', 203, 0, 0, 'Queshan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2055, '411727', '', 203, 0, 0, 'Runan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2056, '411728', 'ƽ', 203, 0, 0, 'Suiping Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2057, '411729', '²', 203, 0, 0, 'Xincai Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2058, '420101', 'Ͻ', 204, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2060, '420103', '', 204, 0, 0, 'Jianghan Qu', 'JHN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2061, '420104', '~', 204, 0, 0, 'Qiaokou Qu', 'QKQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2062, '420105', '', 204, 0, 0, 'Hanyang Qu', 'HYA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2064, '420107', 'ɽ', 204, 0, 0, 'Qingshan Qu', 'QSN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2065, '420111', 'ɽ', 204, 0, 0, 'Hongshan Qu', 'HSQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2066, '420112', '', 204, 0, 0, 'Dongxihu Qu', 'DXH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2067, '420113', '', 204, 0, 0, 'Hannan Qu', 'HNQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2069, '420115', '', 204, 0, 0, 'Jiangxia Qu', 'JXQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2070, '420116', '', 204, 0, 0, 'Huangpi Qu', 'HPI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2072, '420201', 'Ͻ', 205, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2073, '420202', 'ʯ', 205, 0, 0, 'Huangshigang Qu', 'HSG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2074, '420203', 'ɽ', 205, 0, 0, 'Xisaishan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2075, '420204', '½', 205, 0, 0, 'Xialu Qu', 'XAL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2076, '420205', 'ɽ', 205, 0, 0, 'Tieshan Qu', 'TSH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2078, '420281', 'ұ', 205, 0, 0, 'Daye Shi', 'DYE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2079, '420301', 'Ͻ', 206, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2080, '420302', 'é', 206, 0, 0, 'Maojian Qu', 'MJN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2082, '420321', '', 206, 0, 0, 'Yun Xian', 'YUN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2083, '420322', '', 206, 0, 0, 'Yunxi Xian', 'YNX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2084, '420323', 'ɽ', 206, 0, 0, 'Zhushan Xian', 'ZHS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2086, '420325', '', 206, 0, 0, 'Fang Xian', 'FAG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2087, '420381', '', 206, 0, 0, 'Danjiangkou Shi', 'DJK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2088, '420501', 'Ͻ', 207, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2090, '420503', 'Ҹ', 207, 0, 0, 'Wujiagang Qu', 'WJG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2091, '420504', '', 207, 0, 0, 'Dianjun Qu', 'DJN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2092, '420505', 'Vͤ', 207, 0, 0, 'Xiaoting Qu', 'XTQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2093, '420506', '', 207, 0, 0, 'Yiling Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2095, '420526', 'ɽ', 207, 0, 0, 'Xingshan Xian', 'XSX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2096, '420527', '', 207, 0, 0, 'Zigui Xian', 'ZGI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2098, '420529', '', 207, 0, 0, 'Wufeng Tujiazu Zizhixian', 'WFG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2099, '420581', '˶', 207, 0, 0, 'Yidu Shi', 'YID');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2101, '420583', '֦', 207, 0, 0, 'Zhijiang Shi', 'ZIJ');
commit;
prompt 1000 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2102, '420601', 'Ͻ', 208, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2103, '420602', '', 208, 0, 0, 'Xiangcheng Qu', 'XXF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2104, '420606', '', 208, 0, 0, 'Fancheng Qu', 'FNC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2105, '420607', '', 208, 0, 0, 'Xiangyang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2106, '420624', '', 208, 0, 0, 'Nanzhang Xian', 'NZH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2107, '420625', 'ȳ', 208, 0, 0, 'Gucheng Xian', 'GUC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2108, '420626', '', 208, 0, 0, 'Baokang Xian', 'BKG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2109, '420682', 'Ϻӿ', 208, 0, 0, 'Laohekou Shi', 'LHK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2110, '420683', '', 208, 0, 0, 'Zaoyang Shi', 'ZOY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2111, '420684', '˳', 208, 0, 0, 'Yicheng Shi', 'YCW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2112, '420701', 'Ͻ', 209, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2113, '420702', 'Ӻ', 209, 0, 0, 'Liangzihu Qu', 'LZI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2114, '420703', '', 209, 0, 0, 'Huarong Qu', 'HRQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2115, '420704', '', 209, 0, 0, 'Echeng Qu', 'ECQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2116, '420801', 'Ͻ', 210, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2117, '420802', '', 210, 0, 0, 'Dongbao Qu', 'DBQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2118, '420804', '޵', 210, 0, 0, 'Duodao Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2119, '420821', 'ɽ', 210, 0, 0, 'Jingshan Xian', 'JSA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2120, '420822', 'ɳ', 210, 0, 0, 'Shayang Xian', 'SYF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2121, '420881', '', 210, 0, 0, 'Zhongxiang Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2122, '420901', 'Ͻ', 211, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2123, '420902', 'Т', 211, 0, 0, 'Xiaonan Qu', 'XNA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2124, '420921', 'Т', 211, 0, 0, 'Xiaochang Xian', 'XOC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2125, '420922', '', 211, 0, 0, 'Dawu Xian', 'DWU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2126, '420923', '', 211, 0, 0, 'Yunmeng Xian', 'YMX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2127, '420981', 'Ӧ', 211, 0, 0, 'Yingcheng Shi', 'YCG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2128, '420982', '½', 211, 0, 0, 'Anlu Shi', 'ALU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2129, '420984', '', 211, 0, 0, 'Hanchuan Shi', 'HCH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2130, '421001', 'Ͻ', 212, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2131, '421002', 'ɳ', 212, 0, 0, 'Shashi Qu', 'SSJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2132, '421003', '', 212, 0, 0, 'Jingzhou Qu', 'JZQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2133, '421022', '', 212, 0, 0, 'Gong,an Xian', 'GGA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2134, '421023', '', 212, 0, 0, 'Jianli Xian', 'JLI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2135, '421024', '', 212, 0, 0, 'Jiangling Xian', 'JLX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2137, '421083', '', 212, 0, 0, 'Honghu Shi', 'HHU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2138, '421087', '', 212, 0, 0, 'Songzi Shi', 'SZF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2139, '421101', 'Ͻ', 213, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2141, '421121', 'ŷ', 213, 0, 0, 'Tuanfeng Xian', 'TFG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2142, '421122', '찲', 213, 0, 0, 'Hong,an Xian', 'HGA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2143, '421123', '', 213, 0, 0, 'Luotian Xian', 'LTE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2145, '421125', 'ˮ', 213, 0, 0, 'Xishui Xian', 'XSE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2146, '421126', 'ޭ', 213, 0, 0, 'Qichun Xian', 'QCN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2147, '421127', '÷', 213, 0, 0, 'Huangmei Xian', 'HGM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2149, '421182', 'Ѩ', 213, 0, 0, 'Wuxue Shi', 'WXE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2150, '421201', 'Ͻ', 214, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2151, '421202', '̰', 214, 0, 0, 'Xian,an Qu', 'XAN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2153, '421222', 'ͨ', 214, 0, 0, 'Tongcheng Xian', 'TCX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2154, '421223', '', 214, 0, 0, 'Chongyang Xian', 'CGY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2155, '421224', 'ͨɽ', 214, 0, 0, 'Tongshan Xian', 'TSA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2157, '421301', 'Ͻ', 215, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2158, '421303', '', 215, 0, 0, 'Zengdu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2159, '421381', 'ˮ', 215, 0, 0, 'Guangshui Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2161, '422802', '', 216, 0, 0, 'Lichuan Shi', 'LCE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2162, '422822', 'ʼ', 216, 0, 0, 'Jianshi Xian', 'JSE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2163, '422823', 'Ͷ', 216, 0, 0, 'Badong Xian', 'BDG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2165, '422826', '̷', 216, 0, 0, 'Xianfeng Xian', 'XFG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2166, '422827', '', 216, 0, 0, 'Laifeng Xian', 'LFG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2167, '422828', '׷', 216, 0, 0, 'Hefeng Xian', 'HEF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2169, '429005', 'Ǳ', 217, 0, 0, 'Qianjiang Shi', 'QNJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2170, '429006', '', 217, 0, 0, 'Tianmen Shi', 'TMS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2172, '430101', 'Ͻ', 218, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2173, '430102', 'ܽ', 218, 0, 0, 'Furong Qu', 'FRQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2174, '430103', '', 218, 0, 0, 'Tianxin Qu', 'TXQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2175, '430104', '´', 218, 0, 0, 'Yuelu Qu', 'YLU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2176, '430105', '', 218, 0, 0, 'Kaifu Qu', 'KFQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2178, '430121', 'ɳ', 218, 0, 0, 'Changsha Xian', 'CSA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2179, '430122', '', 218, 0, 0, 'Wangcheng Xian', 'WCH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2180, '430124', '', 218, 0, 0, 'Ningxiang Xian', 'NXX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2182, '430201', 'Ͻ', 219, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2183, '430202', '', 219, 0, 0, 'Hetang Qu', 'HTZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2184, '430203', '«', 219, 0, 0, 'Lusong Qu', 'LZZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2186, '430211', 'Ԫ', 219, 0, 0, 'Tianyuan Qu', 'TYQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2187, '430221', '', 219, 0, 0, 'Zhuzhou Xian', 'ZZX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2188, '430223', '', 219, 0, 0, 'You Xian', 'YOU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2190, '430225', '', 219, 0, 0, 'Yanling Xian', 'YLX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2191, '430281', '', 219, 0, 0, 'Liling Shi', 'LIL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2192, '430301', 'Ͻ', 220, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2194, '430304', '', 220, 0, 0, 'Yuetang Qu', 'YTG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2195, '430321', '̶', 220, 0, 0, 'Xiangtan Qu', 'XTX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2196, '430381', '', 220, 0, 0, 'Xiangxiang Shi', 'XXG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2198, '430401', 'Ͻ', 221, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2199, '430405', '', 221, 0, 0, 'Zhuhui Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2200, '430406', '', 221, 0, 0, 'Yanfeng Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2202, '430408', '', 221, 0, 0, 'Zhengxiang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2203, '430412', '', 221, 0, 0, 'Nanyue Qu', 'NYQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2204, '430421', '', 221, 0, 0, 'Hengyang Xian', 'HYO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2206, '430423', 'ɽ', 221, 0, 0, 'Hengshan Xian', 'HSH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2207, '430424', 'ⶫ', 221, 0, 0, 'Hengdong Xian', 'HED');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2208, '430426', '', 221, 0, 0, 'Qidong Xian', 'QDX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2210, '430482', '', 221, 0, 0, 'Changning Shi', 'CNS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2211, '430501', 'Ͻ', 222, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2212, '430502', '˫', 222, 0, 0, 'Shuangqing Qu', 'SGQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2214, '430511', '', 222, 0, 0, 'Beita Qu', 'BET');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2215, '430521', '۶', 222, 0, 0, 'Shaodong Xian', 'SDG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2216, '430522', '', 222, 0, 0, 'Xinshao Xian', 'XSO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2218, '430524', '¡', 222, 0, 0, 'Longhui Xian', 'LGH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2219, '430525', '', 222, 0, 0, 'Dongkou Xian', 'DGK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2220, '430527', '', 222, 0, 0, 'Suining Xian', 'SNX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2222, '430529', 'ǲ', 222, 0, 0, 'Chengbu Miaozu Zizhixian', 'CBU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2224, '430601', 'Ͻ', 223, 0, 0, 'Shixiaqu', '2');
commit;
prompt 1100 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2225, '430602', '¥', 223, 0, 0, 'Yueyanglou Qu', 'YYL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2226, '430603', 'Ϫ', 223, 0, 0, 'Yunxi Qu', 'YXI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2228, '430621', '', 223, 0, 0, 'Yueyang Xian', 'YYX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2229, '430623', '', 223, 0, 0, 'Huarong Xian', 'HRG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2230, '430624', '', 223, 0, 0, 'Xiangyin Xian', 'XYN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2233, '430682', '', 223, 0, 0, 'Linxiang Shi', 'LXY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2234, '430701', 'Ͻ', 224, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2236, '430703', '', 224, 0, 0, 'Dingcheng Qu', 'DCE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2238, '430722', '', 224, 0, 0, 'Hanshou Xian', 'HSO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2240, '430724', '', 224, 0, 0, 'Linli Xian', 'LNL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2241, '430725', 'Դ', 224, 0, 0, 'Taoyuan Xian', 'TOY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2244, '430801', 'Ͻ', 225, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2245, '430802', '', 225, 0, 0, 'Yongding Qu', 'YDQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2247, '430821', '', 225, 0, 0, 'Cili Xian', 'CLI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2249, '430901', 'Ͻ', 226, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2250, '430902', '', 226, 0, 0, 'Ziyang Qu', 'ZYC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2252, '430921', '', 226, 0, 0, 'Nan Xian', 'NXN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2253, '430922', 'ҽ', 226, 0, 0, 'Taojiang Xian', 'TJG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2255, '430981', '佭', 226, 0, 0, 'Yuanjiang Shi', 'YJS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2256, '431001', 'Ͻ', 227, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2257, '431002', '', 227, 0, 0, 'Beihu Qu', 'BHQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2258, '431003', '', 227, 0, 0, 'Suxian Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2260, '431022', '', 227, 0, 0, 'yizhang Xian', 'YZA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2261, '431023', '', 227, 0, 0, 'Yongxing Xian', 'YXX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2263, '431025', '', 227, 0, 0, 'Linwu Xian', 'LWX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2264, '431026', '', 227, 0, 0, 'Rucheng Xian', 'RCE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2266, '431028', '', 227, 0, 0, 'Anren Xian', 'ARN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2267, '431081', '', 227, 0, 0, 'Zixing Shi', 'ZXG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3350, '623027', 'ĺ', 349, 0, 0, 'Xiahe Xian', 'XHN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3351, '630101', 'Ͻ', 350, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3352, '630102', 'Ƕ', 350, 0, 0, 'Chengdong Qu', 'CDQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3353, '630103', '', 350, 0, 0, 'Chengzhong Qu', 'CZQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3354, '630104', '', 350, 0, 0, 'Chengxi Qu', 'CXQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3355, '630105', 'Ǳ', 350, 0, 0, 'Chengbei Qu', 'CBE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3357, '630122', '', 350, 0, 0, 'Huangzhong Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3358, '630123', 'Դ', 350, 0, 0, 'Huangyuan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3359, '632121', 'ƽ', 351, 0, 0, 'Ping,an Xian', 'PAN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3361, '632123', 'ֶ', 351, 0, 0, 'Ledu Xian', 'LDU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3362, '632126', '', 351, 0, 0, 'Huzhu Tuzu Zizhixian', 'HZT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3364, '632128', 'ѭ', 351, 0, 0, 'Xunhua Salazu Zizhixian', 'XUH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3365, '632221', 'Դ', 352, 0, 0, 'Menyuan Huizu Zizhixian', 'MYU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3367, '632223', '', 352, 0, 0, 'Haiyan Xian', 'HIY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3368, '632224', 'ղ', 352, 0, 0, 'Gangca Xian', 'GAN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3370, '632322', '', 353, 0, 0, 'Jainca Xian', 'JAI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3371, '632323', '', 353, 0, 0, 'Zekog Xian', 'ZEK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3373, '632521', '', 354, 0, 0, 'Gonghe Xian', 'GHE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3374, '632522', 'ͬ', 354, 0, 0, 'Tongde Xian', 'TDX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3375, '632523', '', 354, 0, 0, 'Guide Xian', 'GID');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3376, '632524', '˺', 354, 0, 0, 'Xinghai Xian', 'XHA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3378, '632621', '', 355, 0, 0, 'Maqen Xian', 'MAQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3379, '632622', '', 355, 0, 0, 'Baima Xian', 'BMX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3380, '632623', 'ʵ', 355, 0, 0, 'Gade Xian', 'GAD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3382, '632625', '', 355, 0, 0, 'Jigzhi Xian', 'JUZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3383, '632626', '', 355, 0, 0, 'Madoi Xian', 'MAD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3385, '632722', 'Ӷ', 356, 0, 0, 'Zadoi Xian', 'ZAD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3386, '632723', 'ƶ', 356, 0, 0, 'Chindu Xian', 'CHI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3387, '632724', 'ζ', 356, 0, 0, 'Zhidoi Xian', 'ZHI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3389, '632726', '', 356, 0, 0, 'Qumarleb Xian', 'QUM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3390, '632801', 'ľ', 357, 0, 0, 'Golmud Shi', 'GOS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3392, '632821', '', 357, 0, 0, 'Ulan Xian', 'ULA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3393, '632822', '', 357, 0, 0, 'Dulan Xian', 'DUL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3394, '632823', '', 357, 0, 0, 'Tianjun Xian', 'TJN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3395, '640101', 'Ͻ', 358, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3396, '640104', '', 358, 0, 0, 'Xingqing Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3397, '640105', '', 358, 0, 0, 'Xixia Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3398, '640106', '', 358, 0, 0, 'Jinfeng Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3400, '640122', '', 358, 0, 0, 'Helan Xian', 'HLN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3401, '640181', '', 358, 0, 0, 'Lingwu Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3402, '640201', 'Ͻ', 359, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3404, '640205', 'ũ', 359, 0, 0, 'Huinong Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3405, '640221', 'ƽ', 359, 0, 0, 'Pingluo Xian', 'PLO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3406, '640301', 'Ͻ', 360, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3407, '640302', 'ͨ', 360, 0, 0, 'Litong Qu', 'LTW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3408, '640323', 'γ', 360, 0, 0, 'Yanchi Xian', 'YCY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3410, '640381', 'ͭϿ', 360, 0, 0, 'Qingtongxia Xian', 'QTX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3411, '640401', 'Ͻ', 361, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3412, '640402', 'ԭ', 361, 0, 0, 'Yuanzhou Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3413, '640422', '', 361, 0, 0, 'Xiji Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3415, '640424', 'Դ', 361, 0, 0, 'Jingyuan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3416, '640425', '', 361, 0, 0, 'Pengyang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3417, '640501', 'Ͻ', 362, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3418, '640502', 'ɳͷ', 362, 0, 0, 'Shapotou Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3420, '640522', 'ԭ', 362, 0, 0, 'Haiyuan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3421, '650101', 'Ͻ', 363, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3422, '650102', 'ɽ', 363, 0, 0, 'Tianshan Qu', 'TSL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3423, '650103', 'ɳͿ', 363, 0, 0, 'Saybag Qu', 'SAY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3424, '650104', '', 363, 0, 0, 'Xinshi Qu', 'XSU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3426, '650106', 'ͷͺ', 363, 0, 0, 'Toutunhe Qu', 'TTH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3427, '650107', '', 363, 0, 0, 'Dabancheng Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3428, '650109', '׶', 363, 0, 0, 'Midong Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3429, '650121', '³ľ', 363, 0, 0, 'Urumqi Xian', 'URX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3430, '650201', 'Ͻ', 364, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3432, '650203', '', 364, 0, 0, 'Karamay Qu', 'KRQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3433, '650204', '׼̲', 364, 0, 0, 'Baijiantan Qu', 'BJT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3434, '650205', 'ڶ', 364, 0, 0, 'Orku Qu', 'ORK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3436, '652122', '۷', 365, 0, 0, 'Shanshan(piqan) Xian', 'SSX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3437, '652123', 'пѷ', 365, 0, 0, 'Toksun Xian', 'TOK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3441, '652301', '', 367, 0, 0, 'Changji Shi', 'CJS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3442, '652302', '', 367, 0, 0, 'Fukang Shi', 'FKG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3445, '652324', '˹', 367, 0, 0, 'Manas Xian', 'MAS');
commit;
prompt 1200 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3446, '652325', '̨', 367, 0, 0, 'Qitai Xian', 'QTA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3447, '652327', 'ľ', 367, 0, 0, 'Jimsar Xian', 'JIM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3449, '652701', '', 368, 0, 0, 'Bole(Bortala) Shi', 'BLE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3450, '652722', '', 368, 0, 0, 'Jinghe(Jing) Xian', 'JGH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3452, '652801', '', 369, 0, 0, 'Korla Shi', 'KOR');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3453, '652822', '̨', 369, 0, 0, 'Luntai(Bugur) Xian', 'LTX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3455, '652824', 'Ǽ', 369, 0, 0, 'Ruoqiang(Qakilik) Xian', 'RQG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (492, '130529', '¹', 41, 0, 0, 'Julu Xian', 'JLU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (503, '130603', '', 42, 0, 0, 'Beishi Qu', 'BSI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (944, '211402', 'ɽ', 84, 0, 0, 'Lianshan Qu', 'LSQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (945, '211403', '', 84, 0, 0, 'Longgang Qu', 'LGD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (946, '211404', 'Ʊ', 84, 0, 0, 'Nanpiao Qu', 'NPQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (947, '211421', '', 84, 0, 0, 'Suizhong Xian', 'SZL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (948, '211422', '', 84, 0, 0, 'Jianchang Xian', 'JCL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (949, '211481', '˳', 84, 0, 0, 'Xingcheng Shi', 'XCL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (950, '220101', 'Ͻ', 85, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (951, '220102', 'Ϲ', 85, 0, 0, 'Nanguan Qu', 'NGN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (952, '220103', '', 85, 0, 0, 'Kuancheng Qu', 'KCQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (953, '220104', '', 85, 0, 0, 'Chaoyang Qu ', 'CYC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (954, '220105', '', 85, 0, 0, 'Erdao Qu', 'EDQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (955, '220106', '԰', 85, 0, 0, 'Lvyuan Qu', 'LYQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (956, '220112', '˫', 85, 0, 0, 'Shuangyang Qu', 'SYQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (957, '220122', 'ũ', 85, 0, 0, 'Nong,an Xian ', 'NAJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (958, '220181', '̨', 85, 0, 0, 'Jiutai Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (959, '220182', '', 85, 0, 0, 'Yushu Shi', 'YSS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (960, '220183', '»', 85, 0, 0, 'Dehui Shi', 'DEH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (961, '220201', 'Ͻ', 86, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (962, '220202', '', 86, 0, 0, 'Changyi Qu', 'CYI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (963, '220203', '̶', 86, 0, 0, 'Longtan Qu', 'LTQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (964, '220204', 'Ӫ', 86, 0, 0, 'Chuanying Qu', 'CYJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (965, '220211', '', 86, 0, 0, 'Fengman Qu', 'FMQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (966, '220221', '', 86, 0, 0, 'Yongji Xian', 'YOJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (967, '220281', 'Ժ', 86, 0, 0, 'Jiaohe Shi', 'JHJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (968, '220282', '', 86, 0, 0, 'Huadian Shi', 'HDJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (969, '220283', '', 86, 0, 0, 'Shulan Shi', 'SLN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (970, '220284', 'ʯ', 86, 0, 0, 'Panshi Shi', 'PSI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (971, '220301', 'Ͻ', 87, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (972, '220302', '', 87, 0, 0, 'Tiexi Qu', 'TXS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (973, '220303', '', 87, 0, 0, 'Tiedong Qu ', 'TDQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (974, '220322', '', 87, 0, 0, 'Lishu Xian', 'LSU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (975, '220323', 'ͨ', 87, 0, 0, 'Yitong Manzu Zizhixian', 'YTO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (976, '220381', '', 87, 0, 0, 'Gongzhuling Shi', 'GZL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (977, '220382', '˫', 87, 0, 0, 'Shuangliao Shi', 'SLS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (978, '220401', 'Ͻ', 88, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (979, '220402', 'ɽ', 88, 0, 0, 'Longshan Qu', 'LGS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (980, '220403', '', 88, 0, 0, 'Xi,an Qu', 'XAA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (981, '220421', '', 88, 0, 0, 'Dongfeng Xian', 'DGF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (982, '220422', '', 88, 0, 0, 'Dongliao Xian ', 'DLX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (983, '220501', 'Ͻ', 89, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (984, '220502', '', 89, 0, 0, 'Dongchang Qu', 'DCT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (985, '220503', '', 89, 0, 0, 'Erdaojiang Qu', 'EDJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (986, '220521', 'ͨ', 89, 0, 0, 'Tonghua Xian ', 'THX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (987, '220523', '', 89, 0, 0, 'Huinan Xian ', 'HNA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (988, '220524', '', 89, 0, 0, 'Liuhe Xian ', 'LHC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (990, '220582', '', 89, 0, 0, 'Ji,an Shi', 'KNC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (991, '220601', 'Ͻ', 90, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (992, '220602', '˵', 90, 0, 0, 'Badaojiang Qu', 'BDJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (993, '220621', '', 90, 0, 0, 'Fusong Xian', 'FSG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (994, '220622', '', 90, 0, 0, 'Jingyu Xian', 'JYJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (996, '220605', 'Դ', 90, 0, 0, 'Jiangyuan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (997, '220681', 'ٽ', 90, 0, 0, 'Linjiang Shi', 'LIN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (998, '220701', 'Ͻ', 91, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (999, '220702', '', 91, 0, 0, 'Ningjiang Qu', 'NJA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1001, '220722', '', 91, 0, 0, 'Changling Xian', 'CLG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1002, '220723', 'Ǭ', 91, 0, 0, 'Qian,an Xian', 'QAJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1003, '220724', '', 91, 0, 0, 'Fuyu Xian', 'FYU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1004, '220801', 'Ͻ', 92, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1005, '220802', '䬱', 92, 0, 0, 'Taobei Qu', 'TBQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1006, '220821', '', 92, 0, 0, 'Zhenlai Xian', 'ZLA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1008, '220881', '', 92, 0, 0, 'Taonan Shi', 'TNS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1009, '220882', '', 92, 0, 0, 'Da,an Shi', 'DNA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1010, '222401', 'Ӽ', 93, 0, 0, 'Yanji Shi', 'YNJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1012, '222403', 'ػ', 93, 0, 0, 'Dunhua Shi', 'DHS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1013, '222404', '', 93, 0, 0, 'Hunchun Shi', 'HUC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1014, '222405', '', 93, 0, 0, 'Longjing Shi', 'LJJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1016, '222424', '', 93, 0, 0, 'Wangqing Xian', 'WGQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1017, '222426', 'ͼ', 93, 0, 0, 'Antu Xian', 'ATU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1018, '230101', 'Ͻ', 94, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1020, '230103', 'ϸ', 94, 0, 0, 'Nangang Qu', 'NGQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1021, '230104', '', 94, 0, 0, 'Daowai Qu', 'DWQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1022, '230110', '㷻', 94, 0, 0, 'Xiangfang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1024, '230108', 'ƽ', 94, 0, 0, 'Pingfang Qu', 'PFQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1025, '230109', 'ɱ', 94, 0, 0, 'Songbei Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1027, '230123', '', 94, 0, 0, 'Yilan Xian', 'YLH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1028, '230124', '', 94, 0, 0, 'Fangzheng Xian', 'FZH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1029, '230125', '', 94, 0, 0, 'Bin Xian', 'BNX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1030, '230126', '', 94, 0, 0, 'Bayan Xian', 'BYH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1032, '230128', 'ͨ', 94, 0, 0, 'Tonghe Xian', 'TOH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1033, '230129', '', 94, 0, 0, 'Yanshou Xian', 'YSU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1035, '230182', '˫', 94, 0, 0, 'Shuangcheng Shi', 'SCS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1036, '230183', '־', 94, 0, 0, 'Shangzhi Shi', 'SZI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1037, '230184', '峣', 94, 0, 0, 'Wuchang Shi', 'WCA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1039, '230202', 'ɳ', 95, 0, 0, 'Longsha Qu', 'LQQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1040, '230203', '', 95, 0, 0, 'Jianhua Qu', 'JHQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2268, '431101', 'Ͻ', 228, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2271, '431121', '', 228, 0, 0, 'Qiyang Xian', 'QJY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2272, '431122', '', 228, 0, 0, 'Dong,an Xian', 'DOA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2274, '431124', '', 228, 0, 0, 'Dao Xian', 'DAO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2275, '431125', '', 228, 0, 0, 'Jiangyong Xian', 'JYD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2276, '431126', 'Զ', 228, 0, 0, 'Ningyuan Xian', 'NYN');
commit;
prompt 1300 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2278, '431128', '', 228, 0, 0, 'Xintian Xian', 'XTN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2280, '431201', 'Ͻ', 229, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2281, '431202', '׳', 229, 0, 0, 'Hecheng Qu', 'HCG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2282, '431221', 'з', 229, 0, 0, 'Zhongfang Xian', 'ZFX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2283, '431222', '', 229, 0, 0, 'Yuanling Xian', 'YNL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2284, '431223', 'Ϫ', 229, 0, 0, 'Chenxi Xian', 'CXX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2286, '431225', 'ͬ', 229, 0, 0, 'Huitong Xian', 'HTG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2290, '431229', '嶱', 229, 0, 0, 'Jingzhou Miaozu Dongzu Zizhixian', 'JZO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2291, '431230', 'ͨ', 229, 0, 0, 'Tongdao Dongzu Zizhixian', 'TDD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2293, '431301', 'Ͻ', 230, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2294, '431302', '¦', 230, 0, 0, 'Louxing Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2295, '431321', '˫', 230, 0, 0, 'Shuangfeng Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2296, '431322', '»', 230, 0, 0, 'Xinhua Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2298, '431382', 'Դ', 230, 0, 0, 'Lianyuan Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2299, '433101', '', 231, 0, 0, 'Jishou Shi', 'JSO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2301, '433123', '', 231, 0, 0, 'Fenghuang Xian', 'FHX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2302, '433124', 'ԫ', 231, 0, 0, 'Huayuan Xian', 'HYH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2304, '433126', '', 231, 0, 0, 'Guzhang Xian', 'GZG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2305, '433127', '˳', 231, 0, 0, 'Yongshun Xian', 'YSF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2307, '440101', 'Ͻ', 232, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2308, '440115', 'ɳ', 232, 0, 0, 'Nansha Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2309, '440103', '', 232, 0, 0, 'Liwan Qu', 'LWQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2310, '440104', 'Խ', 232, 0, 0, 'Yuexiu Qu', 'YXU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2311, '440105', '', 232, 0, 0, 'Haizhu Qu', 'HZU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2313, '440116', 'ܸ', 232, 0, 0, 'Luogang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2314, '440111', '', 232, 0, 0, 'Baiyun Qu', 'BYN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2315, '440112', '', 232, 0, 0, 'Huangpu Qu', 'HPU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2316, '440113', 'خ', 232, 0, 0, 'Panyu Qu', 'PNY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2318, '440183', '', 232, 0, 0, 'Zengcheng Shi', 'ZEC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2319, '440184', 'ӻ', 232, 0, 0, 'Conghua Shi', 'CNH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2320, '440201', 'Ͻ', 233, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2322, '440204', '䥽', 233, 0, 0, 'Zhenjiang Qu', 'ZJQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2323, '440205', '', 233, 0, 0, 'Qujiang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2324, '440222', 'ʼ', 233, 0, 0, 'Shixing Xian', 'SXX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2325, '440224', 'ʻ', 233, 0, 0, 'Renhua Xian', 'RHA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2327, '440232', 'Դ', 233, 0, 0, 'Ruyuan Yaozu Zizhixian', 'RYN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2329, '440281', 'ֲ', 233, 0, 0, 'Lechang Shi', 'LEC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2330, '440282', '', 233, 0, 0, 'Nanxiong Shi', 'NXS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2331, '440301', 'Ͻ', 234, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2333, '440304', '', 234, 0, 0, 'Futian Qu', 'FTN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2334, '440305', 'ɽ', 234, 0, 0, 'Nanshan Qu', 'NSN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2335, '440306', '', 234, 0, 0, 'Bao,an Qu', 'BAQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2337, '440308', '', 234, 0, 0, 'Yan Tian Qu', 'YTQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2338, '440401', 'Ͻ', 235, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2339, '440402', '', 235, 0, 0, 'Xiangzhou Qu', 'XZQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2340, '440403', '', 235, 0, 0, 'Doumen Qu', 'DOU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2341, '440404', '', 235, 0, 0, 'Jinwan Qu', 'JW Q');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2342, '440501', 'Ͻ', 236, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2343, '440507', '', 236, 0, 0, 'Longhu Qu', 'LHH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2344, '440511', 'ƽ', 236, 0, 0, 'Jinping Qu', 'JPQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2345, '440512', '婽', 236, 0, 0, 'Haojiang Qu', 'HJ Q');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2346, '440513', '', 236, 0, 0, 'Chaoyang  Qu', 'CHY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2347, '440514', '', 236, 0, 0, 'Chaonan Qu', 'CN Q');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2348, '440515', 'κ', 236, 0, 0, 'Chenghai QU', 'CHS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2349, '440523', 'ϰ', 236, 0, 0, 'Nan,ao Xian', 'NAN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2350, '440601', 'Ͻ', 237, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2351, '440604', '', 237, 0, 0, 'Chancheng Qu', 'CC Q');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2352, '440605', 'Ϻ', 237, 0, 0, 'Nanhai Shi', 'NAH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2353, '440606', '˳', 237, 0, 0, 'Shunde Shi', 'SUD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2354, '440607', 'ˮ', 237, 0, 0, 'Sanshui Shi', 'SJQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2355, '440608', '', 237, 0, 0, 'Gaoming Shi', 'GOM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2356, '440701', 'Ͻ', 238, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2357, '440703', '', 238, 0, 0, 'Pengjiang Qu', 'PJJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2358, '440704', '', 238, 0, 0, 'Jianghai Qu', 'JHI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2359, '440705', '»', 238, 0, 0, 'Xinhui Shi', 'XIN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2360, '440781', '̨ɽ', 238, 0, 0, 'Taishan Shi', 'TSS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2361, '440783', 'ƽ', 238, 0, 0, 'Kaiping Shi', 'KPS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2362, '440784', 'ɽ', 238, 0, 0, 'Heshan Shi', 'HES');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2363, '440785', 'ƽ', 238, 0, 0, 'Enping Shi', 'ENP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2364, '440801', 'Ͻ', 239, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2365, '440802', '࿲', 239, 0, 0, 'Chikan Qu', 'CKQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2366, '440803', 'ϼɽ', 239, 0, 0, 'Xiashan Qu', 'XAS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2367, '440804', 'ͷ', 239, 0, 0, 'Potou Qu', 'PTU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2368, '440811', '', 239, 0, 0, 'Mazhang Qu', 'MZQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2369, '440823', 'Ϫ', 239, 0, 0, 'Suixi Xian', 'SXI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2370, '440825', '', 239, 0, 0, 'Xuwen Xian', 'XWN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2371, '440881', '', 239, 0, 0, 'Lianjiang Shi', 'LJS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2372, '440882', '', 239, 0, 0, 'Leizhou Shi', 'LEZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2373, '440883', '⴨', 239, 0, 0, 'Wuchuan Shi', 'WCS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2374, '440901', 'Ͻ', 240, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2375, '440902', 'ï', 240, 0, 0, 'Maonan Qu', 'MNQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2376, '440903', 'ï', 240, 0, 0, 'Maogang Qu', 'MGQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2377, '440923', '', 240, 0, 0, 'Dianbai Xian', 'DBI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2378, '440981', '', 240, 0, 0, 'Gaozhou Shi', 'GZO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2379, '440982', '', 240, 0, 0, 'Huazhou Shi', 'HZY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2380, '440983', '', 240, 0, 0, 'Xinyi Shi', 'XYY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2381, '441201', 'Ͻ', 241, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2382, '441202', '', 241, 0, 0, 'Duanzhou Qu', 'DZQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2383, '441203', '', 241, 0, 0, 'Dinghu Qu', 'DGH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2384, '441223', '', 241, 0, 0, 'Guangning Xian', 'GNG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2385, '441224', '', 241, 0, 0, 'Huaiji Xian', 'HJX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2386, '441225', '⿪', 241, 0, 0, 'Fengkai Xian', 'FKX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2387, '441226', '', 241, 0, 0, 'Deqing Xian', 'DQY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2388, '441283', 'Ҫ', 241, 0, 0, 'Gaoyao Xian', 'GYY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2389, '441284', 'Ļ', 241, 0, 0, 'Sihui Shi', 'SHI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2390, '441301', 'Ͻ', 242, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2391, '441302', 'ݳ', 242, 0, 0, 'Huicheng Qu', 'HCQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2392, '441303', '', 242, 0, 0, 'Huiyang Shi', 'HUY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2393, '441322', '', 242, 0, 0, 'Boluo Xian', 'BOL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2394, '441323', 'ݶ', 242, 0, 0, 'Huidong Xian', 'HID');
commit;
prompt 1400 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2395, '441324', '', 242, 0, 0, 'Longmen Xian', 'LMN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2396, '441401', 'Ͻ', 243, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2397, '441402', '÷', 243, 0, 0, 'Meijiang Qu', 'MJQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2398, '441421', '÷', 243, 0, 0, 'Mei Xian', 'MEX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2399, '441422', '', 243, 0, 0, 'Dabu Xian', 'DBX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2400, '441423', '˳', 243, 0, 0, 'Fengshun Xian', 'FES');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2401, '441424', '廪', 243, 0, 0, 'Wuhua Xian', 'WHY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2402, '441426', 'ƽԶ', 243, 0, 0, 'Pingyuan Xian', 'PYY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2403, '441427', '', 243, 0, 0, 'Jiaoling Xian', 'JOL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2404, '441481', '', 243, 0, 0, 'Xingning Shi', 'XNG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2406, '441502', '', 244, 0, 0, 'Chengqu', 'CQS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2407, '441521', '', 244, 0, 0, 'Haifeng Xian', 'HIF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2408, '441523', '½', 244, 0, 0, 'Luhe Xian', 'LHY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2410, '441601', 'Ͻ', 245, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2411, '441602', 'Դ', 245, 0, 0, 'Yuancheng Qu', 'YCQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2412, '441621', 'Ͻ', 245, 0, 0, 'Zijin Xian', 'ZJY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2414, '441623', 'ƽ', 245, 0, 0, 'Lianping Xian', 'LNP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2415, '441624', 'ƽ', 245, 0, 0, 'Heping Xian', 'HPY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2416, '441625', 'Դ', 245, 0, 0, 'Dongyuan Xian', 'DYN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2418, '441702', '', 246, 0, 0, 'Jiangcheng Qu', 'JCQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2419, '441721', '', 246, 0, 0, 'Yangxi Xian', 'YXY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2420, '441723', '', 246, 0, 0, 'Yangdong Xian', 'YGD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2422, '441801', 'Ͻ', 247, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2423, '441802', '', 247, 0, 0, 'Qingcheng Qu', 'QCQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2424, '441821', '', 247, 0, 0, 'Fogang Xian', 'FGY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2428, '441827', '', 247, 0, 0, 'Qingxin Xian', 'QGX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2429, '441881', 'Ӣ', 247, 0, 0, 'Yingde Shi', 'YDS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2430, '441882', '', 247, 0, 0, 'Lianzhou Shi', 'LZO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2431, '445101', 'Ͻ', 250, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2432, '445102', '', 250, 0, 0, 'Xiangqiao Qu', 'XQO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2434, '445122', 'ƽ', 250, 0, 0, 'Raoping Xian', 'RPG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2435, '445201', 'Ͻ', 251, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2436, '445202', 'ų', 251, 0, 0, 'Rongcheng Qu', 'RCH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2438, '445222', '', 251, 0, 0, 'Jiexi Xian', 'JEX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2439, '445224', '', 251, 0, 0, 'Huilai Xian', 'HLY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2440, '445281', '', 251, 0, 0, 'Puning Shi', 'PNG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2442, '445302', 'Ƴ', 252, 0, 0, 'Yuncheng Qu', 'YYF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2444, '445322', '', 252, 0, 0, 'Yunan Xian', 'YNK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2446, '445381', '޶', 252, 0, 0, 'Luoding Shi', 'LUO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2447, '450101', 'Ͻ', 253, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2450, '450105', '', 253, 0, 0, 'Jiangnan Qu', 'JNA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2451, '450107', '', 253, 0, 0, 'Xixiangtang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2453, '450109', '', 253, 0, 0, 'Yongning Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2454, '450122', '', 253, 0, 0, 'Wuming Xian', 'WMG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2455, '450123', '¡', 253, 0, 0, 'Long,an Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2458, '450126', '', 253, 0, 0, 'Binyang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2459, '450127', '', 253, 0, 0, 'Heng Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2460, '450201', 'Ͻ', 254, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2463, '450204', '', 254, 0, 0, 'Liunan Qu', 'LNU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2464, '450205', '', 254, 0, 0, 'Liubei Qu', 'LBE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2466, '450222', '', 254, 0, 0, 'Liucheng Xian', 'LCB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2468, '450224', 'ڰ', 254, 0, 0, 'Rong,an Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2471, '450301', 'Ͻ', 255, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2472, '450302', '', 255, 0, 0, 'Xiufeng Qu', 'XUF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2474, '450304', 'ɽ', 255, 0, 0, 'Xiangshan Qu', 'XSK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2475, '450305', '', 255, 0, 0, 'Qixing Qu', 'QXG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2476, '450311', 'ɽ', 255, 0, 0, 'Yanshan Qu', 'YSA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2479, '450323', '鴨', 255, 0, 0, 'Lingchuan Xian', 'LCU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2480, '450324', 'ȫ', 255, 0, 0, 'Quanzhou Xian', 'QZO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2483, '450327', '', 255, 0, 0, 'Guanyang Xian', 'GNY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2485, '450329', 'Դ', 255, 0, 0, 'Ziyuan Xian', 'ZYU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2486, '450330', 'ƽ', 255, 0, 0, 'Pingle Xian', 'PLE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2487, '450331', '', 255, 0, 0, 'Lipu Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2490, '450403', '', 256, 0, 0, 'Wanxiu Qu', 'WXQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2491, '450404', 'ɽ', 256, 0, 0, 'Dieshan Qu', 'DES');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2492, '450405', '', 256, 0, 0, 'Changzhou Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2494, '450422', '', 256, 0, 0, 'Teng Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2495, '450423', 'ɽ', 256, 0, 0, 'Mengshan Xian', 'MSA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2498, '450502', '', 257, 0, 0, 'Haicheng Qu', 'HCB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2499, '450503', '', 257, 0, 0, 'Yinhai Qu', 'YHB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2502, '450601', 'Ͻ', 258, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2503, '450602', 'ۿ', 258, 0, 0, 'Gangkou Qu', 'GKQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2504, '450603', '', 258, 0, 0, 'Fangcheng Qu', 'FCQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2506, '450681', '', 258, 0, 0, 'Dongxing Shi', 'DOX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2507, '450701', 'Ͻ', 259, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2510, '450721', 'ɽ', 259, 0, 0, 'Lingshan Xian', 'LSB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2511, '450722', 'ֱ', 259, 0, 0, 'Pubei Xian', 'PBE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2512, '450801', 'Ͻ', 260, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2515, '450804', '', 260, 0, 0, 'Tantang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2516, '450821', 'ƽ', 260, 0, 0, 'Pingnan Xian', 'PNN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2518, '450901', 'Ͻ', 261, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2519, '450902', '', 261, 0, 0, 'Yuzhou Qu', 'YZO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2520, '450921', '', 261, 0, 0, 'Rong Xian', 'ROG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2523, '450924', 'ҵ', 261, 0, 0, 'Xingye Xian', 'XGY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2524, '450981', '', 261, 0, 0, 'Beiliu Shi', 'BLS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2526, '451002', 'ҽ', 262, 0, 0, 'Youjiang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2528, '451022', 'ﶫ', 262, 0, 0, 'Tiandong Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2529, '451023', 'ƽ', 262, 0, 0, 'Pingguo Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2530, '451024', '±', 262, 0, 0, 'Debao Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2532, '451026', '', 262, 0, 0, 'Napo Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2533, '451027', '', 262, 0, 0, 'Lingyun Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2535, '451029', '', 262, 0, 0, 'Tianlin Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2536, '451030', '', 262, 0, 0, 'Xilin Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2538, '451101', 'Ͻ', 263, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2539, '451102', '˲', 263, 0, 0, 'Babu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2540, '451121', 'ƽ', 263, 0, 0, 'Zhaoping Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2541, '451122', 'ɽ', 263, 0, 0, 'Zhongshan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2543, '451201', 'Ͻ', 264, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2544, '451202', 'ǽ', 264, 0, 0, 'Jinchengjiang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2545, '451221', 'ϵ', 264, 0, 0, 'Nandan Xian', '2');
commit;
prompt 1500 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2546, '451222', '', 264, 0, 0, 'Tian,e Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2547, '451223', 'ɽ', 264, 0, 0, 'Fengshan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2548, '451224', '', 264, 0, 0, 'Donglan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2550, '451226', 'ë', 264, 0, 0, 'Huanjiang Maonanzu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2552, '451228', '', 264, 0, 0, 'Du,an Yaozu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2553, '451229', '', 264, 0, 0, 'Dahua Yaozu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2555, '451301', 'Ͻ', 265, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2556, '451302', '˱', 265, 0, 0, 'Xingbin Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2557, '451321', 'ó', 265, 0, 0, 'Xincheng Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2558, '451322', '', 265, 0, 0, 'Xiangzhou Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2560, '451324', '', 265, 0, 0, 'Jinxiu Yaozu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2336, '440307', '', 234, 0, 0, 'Longgang Qu', 'LGG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2562, '451401', 'Ͻ', 266, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2563, '451402', '', 266, 0, 0, 'Jiangzhou Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2564, '451421', '', 266, 0, 0, 'Fusui Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2566, '451423', '', 266, 0, 0, 'Longzhou Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2567, '451424', '', 266, 0, 0, 'Daxin Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2568, '451425', '', 266, 0, 0, 'Tiandeng Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (236, '440500', 'ͷ', 20, 0, 0, 'Shantou Shi', 'SWA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2569, '451481', 'ƾ', 266, 0, 0, 'Pingxiang Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2570, '460101', 'Ͻ', 267, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2571, '460105', 'Ӣ', 267, 0, 0, 'Xiuying Qu', 'XYH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2572, '460106', '', 267, 0, 0, 'LongHua Qu', 'LH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2573, '460107', 'ɽ', 267, 0, 0, 'QiongShan Qu', 'QS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2574, '460108', '', 267, 0, 0, 'MeiLan Qu', 'ML');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2575, '460201', 'Ͻ', 268, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2576, '469001', 'ָɽ', 269, 0, 0, 'Wuzhishan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2577, '469002', '', 269, 0, 0, 'Qionghai Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2578, '469003', '', 269, 0, 0, 'Danzhou Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2579, '469005', 'Ĳ', 269, 0, 0, 'Wenchang Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2580, '469006', '', 269, 0, 0, 'Wanning Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2581, '469007', '', 269, 0, 0, 'Dongfang Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2582, '469021', '', 269, 0, 0, 'Ding,an Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2583, '469022', 'Ͳ', 269, 0, 0, 'Tunchang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2584, '469023', '', 269, 0, 0, 'Chengmai Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2585, '469024', 'ٸ', 269, 0, 0, 'Lingao Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2586, '469025', 'ɳ', 269, 0, 0, 'Baisha Lizu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2588, '469027', 'ֶ', 269, 0, 0, 'Ledong Lizu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2589, '469028', 'ˮ', 269, 0, 0, 'Lingshui Lizu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2590, '469029', 'ͤ', 269, 0, 0, 'Baoting Lizu Miaozu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2591, '469030', '', 269, 0, 0, 'Qiongzhong Lizu Miaozu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2592, '469031', 'ɳȺ', 269, 0, 0, 'Xisha Qundao', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2593, '469032', 'ɳȺ', 269, 0, 0, 'Nansha Qundao', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2594, '469033', 'ɳȺĵ亣', 269, 0, 0, 'Zhongsha Qundao de Daojiao Jiqi Haiyu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2595, '500101', '', 270, 0, 0, 'Wanzhou Qu', 'WZO ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2596, '500102', '', 270, 0, 0, 'Fuling Qu', 'FLG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2597, '500103', '', 270, 0, 0, 'Yuzhong Qu', 'YZQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2599, '500105', '', 270, 0, 0, 'Jiangbei Qu', 'JBE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2600, '500106', 'ɳƺ', 270, 0, 0, 'Shapingba Qu', 'SPB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2601, '500107', '', 270, 0, 0, 'Jiulongpo Qu', 'JLP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2602, '500108', 'ϰ', 270, 0, 0, 'Nan,an Qu', 'NAQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2603, '500109', '', 270, 0, 0, 'Beibei Qu', 'BBE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2604, '500110', 'ʢ', 270, 0, 0, 'Wansheng Qu', 'WSQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2605, '500111', '˫', 270, 0, 0, 'Shuangqiao Qu', 'SQQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2606, '500112', '山', 270, 0, 0, 'Yubei Qu', 'YBE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2607, '500113', '', 270, 0, 0, 'Banan Qu', 'BNN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2608, '500114', 'ǭ', 270, 0, 0, 'Qianjiang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2609, '500115', '', 270, 0, 0, 'Changshou Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2610, '500222', '뽭', 271, 0, 0, 'Qijiang Xian', 'QJG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2611, '500223', '', 271, 0, 0, 'Tongnan Xian', 'TNN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2612, '500224', 'ͭ', 271, 0, 0, 'Tongliang Xian', 'TGL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2613, '500225', '', 271, 0, 0, 'Dazu Xian', 'DZX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2614, '500226', 'ٲ', 271, 0, 0, 'Rongchang Xian', 'RGC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2615, '500227', 'ɽ', 271, 0, 0, 'Bishan Xian', 'BSY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2616, '500228', 'ƽ', 271, 0, 0, 'Liangping Xian', 'LGP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2617, '500229', 'ǿ', 271, 0, 0, 'Chengkou Xian', 'CKO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2618, '500230', 'ᶼ', 271, 0, 0, 'Fengdu Xian', 'FDU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2619, '500231', '潭', 271, 0, 0, 'Dianjiang Xian', 'DJG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2620, '500232', '¡', 271, 0, 0, 'Wulong Xian', 'WLG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2621, '500233', '', 271, 0, 0, 'Zhong Xian', 'ZHX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2622, '500234', '', 271, 0, 0, 'Kai Xian', 'KAI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2623, '500235', '', 271, 0, 0, 'Yunyang Xian', 'YNY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2624, '500236', '', 271, 0, 0, 'Fengjie Xian', 'FJE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2625, '500237', 'ɽ', 271, 0, 0, 'Wushan Xian', 'WSN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2626, '500238', 'Ϫ', 271, 0, 0, 'Wuxi Xian', 'WXX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2627, '500240', 'ʯ', 271, 0, 0, 'Shizhu Tujiazu Zizhixian', 'SZY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2628, '500241', 'ɽ', 271, 0, 0, 'Xiushan Tujiazu Miaozu Zizhixian', 'XUS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2630, '500243', 'ˮ', 271, 0, 0, 'Pengshui Miaozu Tujiazu Zizhixian', 'PSU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2631, '500116', '', 272, 0, 0, 'Jiangjin Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2632, '500117', 'ϴ', 272, 0, 0, 'Hechuan Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2633, '500118', '', 272, 0, 0, 'Yongchuan Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2634, '500119', 'ϴ', 272, 0, 0, 'Nanchuan Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2635, '510101', 'Ͻ', 273, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2636, '510104', '', 273, 0, 0, 'Jinjiang Qu', 'JJQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2637, '510105', '', 273, 0, 0, 'Qingyang Qu', 'QYQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2638, '510106', 'ţ', 273, 0, 0, 'Jinniu Qu', 'JNU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2639, '510107', '', 273, 0, 0, 'Wuhou Qu', 'WHQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2640, '510108', 'ɻ', 273, 0, 0, 'Chenghua Qu', 'CHQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2641, '510112', 'Ȫ', 273, 0, 0, 'Longquanyi Qu', 'LQY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2642, '510113', '׽', 273, 0, 0, 'Qingbaijiang Qu', 'QBJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2643, '510114', '¶', 273, 0, 0, 'Xindu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2644, '510115', '½', 273, 0, 0, 'Wenjiang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2646, '510122', '˫', 273, 0, 0, 'Shuangliu Xian', 'SLU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2647, '510124', 'ۯ', 273, 0, 0, 'Pi Xian', 'PIX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2649, '510131', 'ѽ', 273, 0, 0, 'Pujiang Xian', 'PJX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2652, '510182', '', 273, 0, 0, 'Pengzhou Shi', 'PZS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2653, '510183', '', 273, 0, 0, 'Qionglai Shi', 'QLA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2655, '510301', 'Ͻ', 274, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2657, '510303', '', 274, 0, 0, 'Gongjing Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2658, '510304', '', 274, 0, 0, 'Da,an Qu', 'DAQ');
commit;
prompt 1600 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2659, '510311', '̲', 274, 0, 0, 'Yantan Qu', 'YTN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2660, '510321', '', 274, 0, 0, 'Rong Xian', 'RGX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2662, '510401', 'Ͻ', 275, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2664, '510403', '', 275, 0, 0, 'Xi Qu', 'XIQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2665, '510411', 'ʺ', 275, 0, 0, 'Renhe Qu', 'RHQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2667, '510422', 'α', 275, 0, 0, 'Yanbian Xian', 'YBN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2668, '510501', 'Ͻ', 276, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2671, '510504', '̶', 276, 0, 0, 'Longmatan Qu', 'LMT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2672, '510521', '', 276, 0, 0, 'Lu Xian', 'LUX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2673, '510522', 'Ͻ', 276, 0, 0, 'Hejiang Xian', 'HEJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2676, '510601', 'Ͻ', 277, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2677, '510603', '', 277, 0, 0, 'Jingyang Qu', 'JYF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2679, '510626', '޽', 277, 0, 0, 'Luojiang Xian', 'LOJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2681, '510682', 'ʲ', 277, 0, 0, 'Shifang Shi', 'SFS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2683, '510701', 'Ͻ', 278, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2684, '510703', '', 278, 0, 0, 'Fucheng Qu', 'FCM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2687, '510723', 'ͤ', 278, 0, 0, 'Yanting Xian', 'YTC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2688, '510724', '', 278, 0, 0, 'An Xian', 'AXN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2689, '510725', '', 278, 0, 0, 'Zitong Xian', 'ZTG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2692, '510781', '', 278, 0, 0, 'Jiangyou Shi', 'JYO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2693, '510801', 'Ͻ', 279, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2694, '511002', '', 279, 0, 0, 'Shizhong Qu', 'SZM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2695, '510811', 'Ԫ', 279, 0, 0, 'Yuanba Qu', 'YBQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2698, '510822', 'ന', 279, 0, 0, 'Qingchuan Xian', 'QCX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2699, '510823', '', 279, 0, 0, 'Jiange Xian', 'JGE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2701, '510901', 'Ͻ', 280, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2702, '510903', 'ɽ', 280, 0, 0, 'Chuanshan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2703, '510904', '', 280, 0, 0, 'Anju Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2706, '510923', 'Ӣ', 280, 0, 0, 'Daying Xian', 'DAY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2707, '511001', 'Ͻ', 281, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2709, '511011', '', 281, 0, 0, 'Dongxing Qu', 'DXQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2710, '511024', 'Զ', 281, 0, 0, 'Weiyuan Xian', 'WYU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2713, '511101', 'Ͻ', 282, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2714, '511102', '', 282, 0, 0, 'Shizhong Qu', 'SZP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2715, '511111', 'ɳ', 282, 0, 0, 'Shawan Qu', 'SWN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2717, '511113', 'ں', 282, 0, 0, 'Jinkouhe Qu', 'JKH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2719, '511124', '', 282, 0, 0, 'Jingyan Xian', 'JYA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2721, '511129', '崨', 282, 0, 0, 'Muchuan Xian', 'MCH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2724, '511181', 'üɽ', 282, 0, 0, 'Emeishan Shi', 'EMS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2725, '511301', 'Ͻ', 283, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2726, '511302', '˳', 283, 0, 0, 'Shunqing Xian', 'SQG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2728, '511304', '', 283, 0, 0, 'Jialing Qu', 'JLG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2729, '511321', 'ϲ', 283, 0, 0, 'Nanbu Xian', 'NBU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2732, '511324', '¤', 283, 0, 0, 'Yilong Xian', 'YLC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2733, '511325', '', 283, 0, 0, 'Xichong Xian', 'XCO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2736, '511402', '', 284, 0, 0, 'Dongpo Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2737, '511421', '', 284, 0, 0, 'Renshou Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2738, '511422', 'ɽ', 284, 0, 0, 'Pengshan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2741, '511425', '', 284, 0, 0, 'Qingshen Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2742, '511501', 'Ͻ', 285, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2744, '511521', '˱', 285, 0, 0, 'Yibin Xian', 'YBX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2745, '511522', 'Ϫ', 285, 0, 0, 'Nanxi Xian', 'NNX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2748, '511525', '', 285, 0, 0, 'Gao Xian', 'GAO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2749, '511526', '', 285, 0, 0, 'Gong Xian', 'GOG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2751, '511528', '', 285, 0, 0, 'Xingwen Xian', 'XWC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2753, '511601', 'Ͻ', 286, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2754, '511602', '㰲', 286, 0, 0, 'Guang,an Qu', 'GAQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2755, '511621', '', 286, 0, 0, 'Yuechi Xian', 'YCC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2759, '511701', 'Ͻ', 287, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2761, '511721', '', 287, 0, 0, 'Da Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2762, '511722', '', 287, 0, 0, 'Xuanhan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2765, '511725', '', 287, 0, 0, 'Qu Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2766, '511781', 'Դ', 287, 0, 0, 'Wanyuan Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2767, '511801', 'Ͻ', 288, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2768, '511802', '', 288, 0, 0, 'Yucheg Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2770, '511822', '', 288, 0, 0, 'Yingjing Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2772, '511824', 'ʯ', 288, 0, 0, 'Shimian Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2774, '511826', '«ɽ', 288, 0, 0, 'Lushan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2776, '511901', 'Ͻ', 289, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2778, '511921', 'ͨ', 289, 0, 0, 'Tongjiang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2779, '511922', 'Ͻ', 289, 0, 0, 'Nanjiang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2782, '512002', '㽭', 290, 0, 0, 'Yanjiang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2783, '512021', '', 290, 0, 0, 'Anyue Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2784, '512022', '', 290, 0, 0, 'Lezhi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2786, '513221', '봨', 291, 0, 0, 'Wenchuan Xian', 'WNC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2788, '513223', 'ï', 291, 0, 0, 'Mao Xian', 'MAO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2789, '513224', '', 291, 0, 0, 'Songpan Xian', 'SOP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2792, '513227', 'С', 291, 0, 0, 'Xiaojin Xian', 'XJX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2793, '513228', 'ˮ', 291, 0, 0, 'Heishui Xian', 'HIS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2796, '513231', '', 291, 0, 0, 'Aba(Ngawa) Xian', 'ABX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2797, '513232', '', 291, 0, 0, 'ZoigeXian', 'ZOI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2799, '513321', '', 292, 0, 0, 'Kangding(Dardo) Xian', 'KDX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2801, '513323', '', 292, 0, 0, 'Danba(Rongzhag) Xian', 'DBA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2803, '513325', 'Ž', 292, 0, 0, 'Yajiang(Nyagquka) Xian', 'YAJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2804, '513326', '', 292, 0, 0, 'Dawu Xian', 'DAW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (248, '441900', 'ݸ', 20, 0, 0, 'Dongguan Shi', 'DGG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2805, '513327', '¯', 292, 0, 0, 'Luhuo(Zhaggo) Xian', 'LUH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2806, '513328', '', 292, 0, 0, 'Garze Xian', 'GRZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2807, '513329', '', 292, 0, 0, 'Xinlong(Nyagrong) Xian', 'XLG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2808, '513330', '¸', 292, 0, 0, 'DegeXian', 'DEG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2809, '513331', '', 292, 0, 0, 'Baiyu Xian', 'BYC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2810, '513332', 'ʯ', 292, 0, 0, 'Serxv Xian', 'SER');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2811, '513333', 'ɫ', 292, 0, 0, 'Sertar Xian', 'STX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2812, '513334', '', 292, 0, 0, 'Litang Xian', 'LIT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2813, '513335', '', 292, 0, 0, 'Batang Xian', 'BTC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2814, '513336', '', 292, 0, 0, 'Xiangcheng(Qagcheng) Xian', 'XCC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2815, '513337', '', 292, 0, 0, 'Daocheng(Dabba) Xian', 'DCX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2816, '513338', '', 292, 0, 0, 'Derong Xian', 'DER');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2817, '513401', '', 293, 0, 0, 'Xichang Shi', 'XCA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2818, '513422', 'ľ', 293, 0, 0, 'Muli Zangzu Zizhixian', 'MLI');
commit;
prompt 1700 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2819, '513423', 'Դ', 293, 0, 0, 'Yanyuan Xian', 'YYU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2820, '513424', '²', 293, 0, 0, 'Dechang Xian', 'DEC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2821, '513425', '', 293, 0, 0, 'Huili Xian', 'HLI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2822, '513426', 'ᶫ', 293, 0, 0, 'Huidong Xian', 'HDG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2823, '513427', '', 293, 0, 0, 'Ningnan Xian', 'NIN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2824, '513428', 'ո', 293, 0, 0, 'Puge Xian', 'PGE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2825, '513429', '', 293, 0, 0, 'Butuo Xian', 'BTO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2826, '513430', '', 293, 0, 0, 'Jinyang Xian', 'JYW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2827, '513431', 'Ѿ', 293, 0, 0, 'Zhaojue Xian', 'ZJE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2828, '513432', 'ϲ', 293, 0, 0, 'Xide Xian', 'XDE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2829, '513433', '', 293, 0, 0, 'Mianning Xian', 'MNG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2830, '513434', 'Խ', 293, 0, 0, 'Yuexi Xian', 'YXC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2831, '513435', '', 293, 0, 0, 'Ganluo Xian', 'GLO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2832, '513436', '', 293, 0, 0, 'Meigu Xian', 'MEG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2833, '513437', 'ײ', 293, 0, 0, 'Leibo Xian', 'LBX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2834, '520101', 'Ͻ', 294, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2835, '520102', '', 294, 0, 0, 'Nanming Qu', 'NMQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2836, '520103', '', 294, 0, 0, 'Yunyan Qu', 'YYQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2837, '520111', 'Ϫ', 294, 0, 0, 'Huaxi Qu', 'HXI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2838, '520112', 'ڵ', 294, 0, 0, 'Wudang Qu', 'WDQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2839, '520113', '', 294, 0, 0, 'Baiyun Qu', 'BYU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2840, '520114', 'С', 294, 0, 0, 'Xiaohe Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2841, '520121', '', 294, 0, 0, 'Kaiyang Xian', 'KYG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2842, '520122', 'Ϣ', 294, 0, 0, 'Xifeng Xian', 'XFX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2843, '520123', '', 294, 0, 0, 'Xiuwen Xian', 'XWX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2844, '520181', '', 294, 0, 0, 'Qingzhen Shi', 'QZN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2845, '520201', 'ɽ', 295, 0, 0, 'Zhongshan Qu', 'ZSQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2846, '520203', '֦', 295, 0, 0, 'Liuzhi Tequ', 'LZT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2847, '520221', 'ˮ', 295, 0, 0, 'Shuicheng Xian', 'SUC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2848, '520222', '', 295, 0, 0, 'Pan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2849, '520301', 'Ͻ', 296, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2850, '520302', '컨', 296, 0, 0, 'Honghuagang Qu', 'HHG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2851, '520303', '㴨', 296, 0, 0, 'Huichuan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2852, '520321', '', 296, 0, 0, 'Zunyi Xian', 'ZYI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2853, '520322', 'ͩ', 296, 0, 0, 'Tongzi Xian', 'TZI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2854, '520323', '', 296, 0, 0, 'Suiyang Xian', 'SUY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2855, '520324', '', 296, 0, 0, 'Zhengan Xan', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2856, '520325', '', 296, 0, 0, 'Daozhen Gelaozu Miaozu Zizhixian', 'DZN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2857, '520326', '', 296, 0, 0, 'Wuchuan Gelaozu Miaozu Zizhixian', 'WCU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2858, '520327', '', 296, 0, 0, 'Fenggang Xian', 'FGG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2859, '520328', '̶', 296, 0, 0, 'Meitan Xian', 'MTN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2860, '520329', '', 296, 0, 0, 'Yuqing Xian', 'YUQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2861, '520330', 'ϰˮ', 296, 0, 0, 'Xishui Xian', 'XSI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2862, '520381', 'ˮ', 296, 0, 0, 'Chishui Shi', 'CSS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2863, '520382', 'ʻ', 296, 0, 0, 'Renhuai Shi', 'RHS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2864, '520401', 'Ͻ', 297, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2865, '520402', '', 297, 0, 0, 'Xixiu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2866, '520421', 'ƽ', 297, 0, 0, 'Pingba Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2867, '520422', 'ն', 297, 0, 0, 'Puding Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2869, '520424', '벼', 297, 0, 0, 'Guanling Buyeizu Miaozu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2870, '520425', '岼', 297, 0, 0, 'Ziyun Miaozu Buyeizu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2871, '522201', 'ͭ', 298, 0, 0, 'Tongren Shi', 'TRS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2872, '522222', '', 298, 0, 0, 'Jiangkou Xian', 'JGK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2873, '522223', '', 298, 0, 0, 'Yuping Dongzu Zizhixian', 'YPG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2874, '522224', 'ʯ', 298, 0, 0, 'Shiqian Xian', 'SQI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2875, '522225', '˼', 298, 0, 0, 'Sinan Xian', 'SNA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2876, '522226', 'ӡ', 298, 0, 0, 'Yinjiang Tujiazu Miaozu Zizhixian', 'YJY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2877, '522227', '½', 298, 0, 0, 'Dejiang Xian', 'DEJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2878, '522228', 'غ', 298, 0, 0, 'Yanhe Tujiazu Zizhixian', 'YHE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2880, '522230', 'ɽ', 298, 0, 0, 'Wanshan Tequ', 'WAS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2881, '522301', '', 299, 0, 0, 'Xingyi Shi', 'XYI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2882, '522322', '', 299, 0, 0, 'Xingren Xian', 'XRN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2884, '522324', '¡', 299, 0, 0, 'Qinglong Xian', 'QLG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2885, '522325', '', 299, 0, 0, 'Zhenfeng Xian', 'ZFG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2887, '522327', '', 299, 0, 0, 'Ceheng Xian', 'CEH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2888, '522328', '', 299, 0, 0, 'Anlong Xian', 'ALG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2890, '522422', '', 300, 0, 0, 'Dafang Xian', 'DAF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2891, '522423', 'ǭ', 300, 0, 0, 'Qianxi Xian', 'QNX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2893, '522425', '֯', 300, 0, 0, 'Zhijin Xian', 'ZJN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2894, '522426', 'Ӻ', 300, 0, 0, 'Nayong Xian', 'NYG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2896, '522428', '', 300, 0, 0, 'Hezhang Xian', 'HZA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2897, '522601', '', 301, 0, 0, 'Kaili Shi', 'KLS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2898, '522622', 'ƽ', 301, 0, 0, 'Huangping Xian', 'HPN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2899, '522623', 'ʩ', 301, 0, 0, 'Shibing Xian', 'SBG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2901, '522625', 'Զ', 301, 0, 0, 'Zhenyuan Xian', 'ZYX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2902, '522626', '᯹', 301, 0, 0, 'Cengong Xian', 'CGX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2904, '522628', '', 301, 0, 0, 'Jinping Xian', 'JPX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2905, '522629', '', 301, 0, 0, 'Jianhe Xian', 'JHE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2907, '522631', 'ƽ', 301, 0, 0, 'Liping Xian', 'LIP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2908, '522632', 'Ž', 301, 0, 0, 'Rongjiang Xian', 'RJG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2910, '522634', 'ɽ', 301, 0, 0, 'Leishan Xian', 'LSA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2911, '522635', '齭', 301, 0, 0, 'Majiang Xian', 'MAJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2912, '522636', 'կ', 301, 0, 0, 'Danzhai Xian', 'DZH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2914, '522702', 'Ȫ', 302, 0, 0, 'Fuquan Shi', 'FQN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2915, '522722', '', 302, 0, 0, 'Libo Xian', 'LBO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2917, '522725', 'Ͱ', 302, 0, 0, 'Weng,an Xian', 'WGA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2918, '522726', 'ɽ', 302, 0, 0, 'Dushan Xian', 'DSX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2919, '522727', 'ƽ', 302, 0, 0, 'Pingtang Xian', 'PTG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2921, '522729', '˳', 302, 0, 0, 'Changshun Xian', 'CSU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2922, '522730', '', 302, 0, 0, 'Longli Xian', 'LLI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2924, '522732', 'ˮ', 302, 0, 0, 'Sandu Suizu Zizhixian', 'SDU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2925, '530101', 'Ͻ', 303, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2927, '530103', '', 303, 0, 0, 'Panlong Qu', 'PLQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2928, '530111', 'ٶ', 303, 0, 0, 'Guandu Qu', 'GDU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2929, '530112', 'ɽ', 303, 0, 0, 'Xishan Qu', 'XSN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2931, '530121', 'ʹ', 303, 0, 0, 'Chenggong Xian', 'CGD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2932, '530122', '', 303, 0, 0, 'Jinning Xian', 'JND');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2936, '530127', '', 303, 0, 0, 'Songming Xian', 'SMI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2939, '530181', '', 303, 0, 0, 'Anning Shi', 'ANG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2940, '530301', 'Ͻ', 304, 0, 0, 'Shixiaqu', '2');
commit;
prompt 1800 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2941, '530302', '', 304, 0, 0, 'Qilin Xian', 'QLQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2942, '530321', '', 304, 0, 0, 'Malong Xian', 'MLO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2943, '530322', '½', 304, 0, 0, 'Luliang Xian', 'LLX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2944, '530323', 'ʦ', 304, 0, 0, 'Shizong Xian', 'SZD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2946, '530325', 'Դ', 304, 0, 0, 'Fuyuan Xian', 'FYD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2948, '530328', 'մ', 304, 0, 0, 'Zhanyi Xian', 'ZYD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2950, '530401', 'Ͻ', 305, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2952, '530421', '', 305, 0, 0, 'Jiangchuan Xian', 'JGC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2953, '530422', 'ν', 305, 0, 0, 'Chengjiang Xian', 'CGJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2956, '530425', '', 305, 0, 0, 'Yimen Xian', 'YMD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2960, '530501', 'Ͻ', 306, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2961, '530502', '¡', 306, 0, 0, 'Longyang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2962, '530521', 'ʩ', 306, 0, 0, 'Shidian Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2963, '530522', 'ڳ', 306, 0, 0, 'Tengchong Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2964, '530523', '', 306, 0, 0, 'Longling Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2965, '530524', '', 306, 0, 0, 'Changning Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2966, '530601', 'Ͻ', 307, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2967, '530602', '', 307, 0, 0, 'Zhaoyang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2970, '530623', 'ν', 307, 0, 0, 'Yanjin Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2971, '530624', '', 307, 0, 0, 'Daguan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2974, '530627', '', 307, 0, 0, 'Zhenxiong Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2975, '530628', '', 307, 0, 0, 'Yiliang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2978, '530701', 'Ͻ', 308, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2979, '530702', 'ų', 308, 0, 0, 'Gucheng Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2981, '530722', 'ʤ', 308, 0, 0, 'Yongsheng Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2982, '530723', 'ƺ', 308, 0, 0, 'Huaping Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2984, '530801', 'Ͻ', 309, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2985, '530802', '˼é', 309, 0, 0, 'Simao Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2987, '530822', 'ī', 309, 0, 0, 'Mojiang Hanizu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2994, '530829', '', 309, 0, 0, 'Ximeng Vazu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2995, '530901', 'Ͻ', 310, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2996, '530902', '', 310, 0, 0, 'Linxiang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2997, '530921', '', 310, 0, 0, 'Fengqing Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2998, '530922', '', 310, 0, 0, 'Yun Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3000, '530924', '', 310, 0, 0, 'Zhenkang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3003, '530927', 'Դ', 310, 0, 0, 'Cangyuan Vazu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3004, '532301', '', 311, 0, 0, 'Chuxiong Shi', 'CXS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3006, '532323', 'Ĳ', 311, 0, 0, 'Mouding Xian', 'MDI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3007, '532324', 'ϻ', 311, 0, 0, 'Nanhua Xian', 'NHA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3009, '532326', 'Ҧ', 311, 0, 0, 'Dayao Xian', 'DYO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3011, '532328', 'Ԫı', 311, 0, 0, 'Yuanmou Xian', 'YMO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3013, '532331', '»', 311, 0, 0, 'Lufeng Xian', 'LFX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3015, '532502', 'Զ', 312, 0, 0, 'Kaiyuan Shi', 'KYD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (431, '130132', 'Ԫ', 37, 0, 0, 'Yuanshi Xian', 'YSI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (451, '130281', '', 38, 0, 0, 'Zunhua Shi', 'ZNH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (457, '130321', '', 39, 0, 0, 'Qinglong Manzu Zizhixian', 'QLM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3018, '532524', 'ˮ', 312, 0, 0, 'Jianshui Xian', 'JSD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3020, '532526', '', 312, 0, 0, 'Mile Xian', 'MIL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3021, '532527', '', 312, 0, 0, 'Luxi Xian', 'LXD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3022, '532528', 'Ԫ', 312, 0, 0, 'Yuanyang Xian', 'YYD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3027, '532621', 'ɽ', 313, 0, 0, 'Wenshan Xian', 'WES');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3028, '532622', 'ɽ', 313, 0, 0, 'Yanshan Xian', 'YSD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3029, '532623', '', 313, 0, 0, 'Xichou Xian', 'XIC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3030, '532624', '', 313, 0, 0, 'Malipo Xian', 'MLP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3031, '532625', '', 313, 0, 0, 'Maguan Xian', 'MGN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3032, '532626', '', 313, 0, 0, 'Qiubei Xian', 'QBE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3034, '532628', '', 313, 0, 0, 'Funing Xian', 'FND');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3035, '532801', '', 314, 0, 0, 'Jinghong Shi', 'JHG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3036, '532822', 'º', 314, 0, 0, 'Menghai Xian', 'MHI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3038, '532901', '', 315, 0, 0, 'Dali Shi', 'DLS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3040, '532923', '', 315, 0, 0, 'Xiangyun Xian', 'XYD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3041, '532924', '', 315, 0, 0, 'Binchuan Xian', 'BCD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3042, '532925', 'ֶ', 315, 0, 0, 'Midu Xian', 'MDU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3025, '532531', '̴', 312, 0, 0, 'Lvchun Xian', 'LCX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3043, '532926', 'Ͻ', 315, 0, 0, 'Nanjian Yizu Zizhixian', 'NNJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3045, '532928', 'ƽ', 315, 0, 0, 'Yongping Xian', 'YPX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3046, '532929', '', 315, 0, 0, 'Yunlong Xian', 'YLO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3047, '532930', 'Դ', 315, 0, 0, 'Eryuan Xian', 'EYN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3048, '532931', '', 315, 0, 0, 'Jianchuan Xian', 'JIC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3049, '532932', '', 315, 0, 0, 'Heqing Xian', 'HQG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3051, '533103', 'â', 316, 0, 0, 'Luxi Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3052, '533122', '', 316, 0, 0, 'Lianghe Xian', 'LHD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3053, '533123', 'ӯ', 316, 0, 0, 'Yingjiang Xian', 'YGJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3055, '533321', 'ˮ', 317, 0, 0, 'Lushui Xian', 'LSX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3056, '533323', '', 317, 0, 0, 'Fugong Xian', 'FGO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3058, '533325', 'ƺ', 317, 0, 0, 'Lanping Baizu Pumizu Zizhixian', 'LPG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3059, '533421', '', 318, 0, 0, 'Xianggelila Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3060, '533422', '', 318, 0, 0, 'Deqen Xian', 'DQN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3061, '533423', 'ά', 318, 0, 0, 'Weixi Lisuzu Zizhixian', 'WXI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3062, '540101', 'Ͻ', 319, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3063, '540102', 'ǹ', 319, 0, 0, 'Chengguang Qu', 'CGN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3064, '540121', '', 319, 0, 0, 'Lhvnzhub Xian', 'LZB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3065, '540122', '', 319, 0, 0, 'Damxung Xian', 'DAM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3066, '540123', 'ľ', 319, 0, 0, 'Nyemo Xian', 'NYE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3067, '540124', 'ˮ', 319, 0, 0, 'Qvxv Xian', 'QUX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3068, '540125', '', 319, 0, 0, 'Doilungdeqen Xian', 'DOI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3069, '540126', '', 319, 0, 0, 'Dagze Xian', 'DAG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3070, '540127', 'ī񹤿', 319, 0, 0, 'Maizhokunggar Xian', 'MAI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3071, '542121', '', 320, 0, 0, 'Qamdo Xian', 'QAX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3072, '542122', '', 320, 0, 0, 'Jomda Xian', 'JOM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3073, '542123', '', 320, 0, 0, 'Konjo Xian', 'KON');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3074, '542124', '', 320, 0, 0, 'Riwoqe Xian', 'RIW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3075, '542125', '', 320, 0, 0, 'Dengqen Xian', 'DEN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3076, '542126', '', 320, 0, 0, 'Chagyab Xian', 'CHA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3077, '542127', '', 320, 0, 0, 'Baxoi Xian', 'BAX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3078, '542128', '', 320, 0, 0, 'Zogang Xian', 'ZOX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3079, '542129', 'â', 320, 0, 0, 'Mangkam Xian', 'MAN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3080, '542132', '¡', 320, 0, 0, 'Lhorong Xian', 'LHO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3081, '542133', '߰', 320, 0, 0, 'Banbar Xian', 'BAN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3082, '542221', '˶', 321, 0, 0, 'Nedong Xian', 'NED');
commit;
prompt 1900 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3083, '542222', '', 321, 0, 0, 'Chanang(Chatang) Xian', 'CNG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3084, '542223', '', 321, 0, 0, 'Gonggar Xian', 'GON');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3085, '542224', 'ɣ', 321, 0, 0, 'Sangri Xian', 'SRI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3086, '542225', '', 321, 0, 0, 'Qonggyai Xian', 'QON');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3087, '542226', '', 321, 0, 0, 'Qusum Xian', 'QUS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3088, '542227', '', 321, 0, 0, 'Comai Xian', 'COM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3089, '542228', '', 321, 0, 0, 'Lhozhag Xian', 'LHX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3090, '542229', 'Ӳ', 321, 0, 0, 'Gyaca Xian', 'GYA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3091, '542231', '¡', 321, 0, 0, 'Lhvnze Xian', 'LHZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3092, '542232', '', 321, 0, 0, 'Cona Xian', 'CON');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3093, '542233', '˿', 321, 0, 0, 'Nagarze Xian', 'NAX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3094, '542301', 'տ', 322, 0, 0, 'Xigaze Shi', 'XIG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3095, '542322', 'ľ', 322, 0, 0, 'Namling Xian', 'NAM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3096, '542323', '', 322, 0, 0, 'Gyangze Xian', 'GYZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3097, '542324', '', 322, 0, 0, 'Tingri Xian', 'TIN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3098, '542325', '', 322, 0, 0, 'Sa,gya Xian', 'SGX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3099, '542326', '', 322, 0, 0, 'Lhaze Xian', 'LAZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3100, '542327', '', 322, 0, 0, 'Ngamring Xian', 'NGA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3101, '542328', 'лͨ', 322, 0, 0, 'Xaitongmoin Xian', 'XTM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3102, '542329', '', 322, 0, 0, 'Bainang Xian', 'BAI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3104, '542331', '', 322, 0, 0, 'Kangmar Xian', 'KAN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3105, '542332', '', 322, 0, 0, 'Dinggye Xian', 'DIN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3107, '542334', 'Ƕ', 322, 0, 0, 'Yadong(Chomo) Xian', 'YDZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3109, '542336', 'ľ', 322, 0, 0, 'Nyalam Xian', 'NYA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3110, '542337', '', 322, 0, 0, 'Saga Xian', 'SAG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3111, '542338', 'ڰ', 322, 0, 0, 'Gamba Xian', 'GAM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3113, '542422', '', 323, 0, 0, 'Lhari Xian', 'LHR');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3114, '542423', '', 323, 0, 0, 'Biru Xian', 'BRU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3115, '542424', '', 323, 0, 0, 'Nyainrong Xian', 'NRO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3117, '542426', '', 323, 0, 0, 'Xainza Xian', 'XZX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3118, '542427', '', 323, 0, 0, 'Sog Xian', 'SOG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3120, '542429', '', 323, 0, 0, 'Baqen Xian', 'BQE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3121, '542430', '', 323, 0, 0, 'Nyima Xian', 'NYX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3122, '542521', '', 324, 0, 0, 'Burang Xian', 'BUR');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3124, '542523', '', 324, 0, 0, 'Gar Xian', 'GAR');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3125, '542524', '', 324, 0, 0, 'Rutog Xian', 'RUT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3126, '542525', 'Ｊ', 324, 0, 0, 'Ge,gyai Xian', 'GEG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3128, '542527', '', 324, 0, 0, 'Coqen Xian', 'COQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3129, '542621', '֥', 325, 0, 0, 'Nyingchi Xian', 'NYI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3131, '542623', '', 325, 0, 0, 'Mainling Xian', 'MAX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3132, '542624', 'ī', 325, 0, 0, 'Metog Xian', 'MET');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3134, '542626', '', 325, 0, 0, 'Zayv Xian', 'ZAY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3135, '542627', '', 325, 0, 0, 'Nang Xian', 'NGX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3136, '610101', 'Ͻ', 326, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3137, '610102', '³', 326, 0, 0, 'Xincheng Qu', 'XCK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3138, '610103', '', 326, 0, 0, 'Beilin Qu', 'BLQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3139, '610104', '', 326, 0, 0, 'Lianhu Qu', 'LHU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3141, '610112', 'δ', 326, 0, 0, 'Weiyang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3142, '610113', '', 326, 0, 0, 'Yanta Qu', 'YTA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3143, '610114', '', 326, 0, 0, 'Yanliang Qu', 'YLQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3145, '610116', '', 326, 0, 0, 'Changan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3146, '610122', '', 326, 0, 0, 'Lantian Xian', 'LNT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3147, '610124', '', 326, 0, 0, 'Zhouzhi Xian', 'ZOZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3149, '610126', '', 326, 0, 0, 'Gaoling Xian', 'GLS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3150, '610201', 'Ͻ', 327, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3151, '610202', '', 327, 0, 0, 'Wangyi Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3152, '610203', 'ӡ̨', 327, 0, 0, 'Yintai Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3153, '610204', 'ҫ', 327, 0, 0, 'Yaozhou Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3154, '610222', '˾', 327, 0, 0, 'Yijun Xian', 'YJU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3155, '610301', 'Ͻ', 328, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3157, '610303', '̨', 328, 0, 0, 'Jintai Qu', 'JTQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3158, '610304', '²', 328, 0, 0, 'Chencang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3159, '610322', '', 328, 0, 0, 'Fengxiang Xian', 'FXG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3161, '610324', '', 328, 0, 0, 'Fufeng Xian', 'FFG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3162, '610326', 'ü', 328, 0, 0, 'Mei Xian', 'MEI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3163, '610327', '¤', 328, 0, 0, 'Long Xian', 'LON');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3165, '610329', '', 328, 0, 0, 'Linyou Xian', 'LYP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3166, '610330', '', 328, 0, 0, 'Feng Xian', 'FEG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3167, '610331', '̫', 328, 0, 0, 'Taibai Xian', 'TBA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3168, '610401', 'Ͻ', 329, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3170, '610403', '', 329, 0, 0, 'Yangling Qu', 'YGL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3171, '610404', 'μ', 329, 0, 0, 'Weicheng Qu', 'WIC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3172, '610422', 'ԭ', 329, 0, 0, 'Sanyuan Xian', 'SYN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3174, '610424', 'Ǭ', 329, 0, 0, 'Qian Xian', 'QIA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3175, '610425', 'Ȫ', 329, 0, 0, 'Liquan Xian', 'LIQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3177, '610427', '', 329, 0, 0, 'Bin Xian', 'BIX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3178, '610428', '', 329, 0, 0, 'Changwu Xian', 'CWU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3179, '610429', 'Ѯ', 329, 0, 0, 'Xunyi Xian', 'XNY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3181, '610431', '书', 329, 0, 0, 'Wugong Xian', 'WGG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3182, '610481', 'ƽ', 329, 0, 0, 'Xingping Shi', 'XPG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3183, '610501', 'Ͻ', 330, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3184, '610502', 'μ', 330, 0, 0, 'Linwei Qu', 'LWE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3186, '610522', '', 330, 0, 0, 'Tongguan Xian', 'TGN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3187, '610523', '', 330, 0, 0, 'Dali Xian', 'DAL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3189, '610525', 'γ', 330, 0, 0, 'Chengcheng Xian', 'CCG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3190, '610526', 'ѳ', 330, 0, 0, 'Pucheng Xian', 'PUC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3192, '610528', 'ƽ', 330, 0, 0, 'Fuping Xian', 'FPX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3193, '610581', '', 330, 0, 0, 'Hancheng Shi', 'HCE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3195, '610601', 'Ͻ', 331, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3196, '610602', '', 331, 0, 0, 'Baota Qu', 'BTA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3197, '610621', 'ӳ', 331, 0, 0, 'Yanchang Xian', 'YCA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3198, '610622', 'Ӵ', 331, 0, 0, 'Yanchuan Xian', 'YCT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3200, '610624', '', 331, 0, 0, 'Ansai Xian', 'ANS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3201, '610625', '־', 331, 0, 0, 'Zhidan Xian', 'ZDN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3203, '610627', 'Ȫ', 331, 0, 0, 'Ganquan Xian', 'GQN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3204, '610628', '', 331, 0, 0, 'Fu Xian', 'FUX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3205, '610629', '崨', 331, 0, 0, 'Luochuan Xian', 'LCW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3207, '610631', '', 331, 0, 0, 'Huanglong Xian', 'HGL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3209, '610701', 'Ͻ', 332, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3210, '610702', '̨', 332, 0, 0, 'Hantai Qu', 'HTQ');
commit;
prompt 2000 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3211, '610721', '֣', 332, 0, 0, 'Nanzheng Xian', 'NZG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3212, '610722', 'ǹ', 332, 0, 0, 'Chenggu Xian', 'CGU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3214, '610724', '', 332, 0, 0, 'Xixiang Xian', 'XXA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3215, '610725', '', 332, 0, 0, 'Mian Xian', 'MIA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3217, '610727', '', 332, 0, 0, 'Lueyang Xian', 'LYC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3218, '610728', '', 332, 0, 0, 'Zhenba Xian', 'ZBA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3219, '610729', '', 332, 0, 0, 'Liuba Xian', 'LBA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3221, '610801', 'Ͻ', 333, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3223, '610821', 'ľ', 333, 0, 0, 'Shenmu Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3224, '610822', '', 333, 0, 0, 'Fugu Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3227, '610825', '', 333, 0, 0, 'Dingbian Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3228, '610826', '', 333, 0, 0, 'Suide Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3229, '610827', '֬', 333, 0, 0, 'Mizhi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3232, '610830', '彧', 333, 0, 0, 'Qingjian Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3233, '610831', '', 333, 0, 0, 'Zizhou Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3235, '610902', '', 334, 0, 0, 'Hanbin Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (480, '130481', '䰲', 40, 0, 0, 'Wu,an Shi', 'WUA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3236, '610921', '', 334, 0, 0, 'Hanyin Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3237, '610922', 'ʯȪ', 334, 0, 0, 'Shiquan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3239, '610924', '', 334, 0, 0, 'Ziyang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3240, '610925', '᰸', 334, 0, 0, 'Langao Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3241, '610926', 'ƽ', 334, 0, 0, 'Pingli Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3243, '610928', 'Ѯ', 334, 0, 0, 'Xunyang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3244, '610929', '׺', 334, 0, 0, 'Baihe Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3245, '611001', 'Ͻ', 335, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3247, '611021', '', 335, 0, 0, 'Luonan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3248, '611022', '', 335, 0, 0, 'Danfeng Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3249, '611023', '', 335, 0, 0, 'Shangnan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3251, '611025', '', 335, 0, 0, 'Zhen,an Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3252, '611026', 'ˮ', 335, 0, 0, 'Zhashui Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3253, '620101', 'Ͻ', 336, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3255, '620103', '', 336, 0, 0, 'Qilihe Qu', 'QLH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3256, '620104', '', 336, 0, 0, 'Xigu Qu', 'XGU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3258, '620111', '', 336, 0, 0, 'Honggu Qu', 'HOG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3259, '620121', '', 336, 0, 0, 'Yongdeng Xian', 'YDG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3260, '620122', '', 336, 0, 0, 'Gaolan Xian', 'GAL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3262, '620201', 'Ͻ', 337, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3263, '620301', 'Ͻ', 338, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3264, '620302', '', 338, 0, 0, 'Jinchuan Qu', 'JCU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3266, '620401', 'Ͻ', 339, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3267, '620402', '', 339, 0, 0, 'Baiyin Qu', 'BYB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3268, '620403', 'ƽ', 339, 0, 0, 'Pingchuan Qu', 'PCQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3270, '620422', '', 339, 0, 0, 'Huining xian', 'HNI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3271, '620423', '̩', 339, 0, 0, 'Jingtai Xian', 'JGT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3272, '620501', 'Ͻ', 340, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3274, '620502', '', 340, 0, 0, 'Beidao Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3275, '620521', 'ˮ', 340, 0, 0, 'Qingshui Xian', 'QSG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3276, '620522', 'ذ', 340, 0, 0, 'Qin,an Xian', 'QNA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3278, '620524', 'ɽ', 340, 0, 0, 'Wushan Xian', 'WSX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3280, '620601', 'Ͻ', 341, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3281, '620602', '', 341, 0, 0, 'Liangzhou Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3282, '620621', '', 341, 0, 0, 'Minqin Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3283, '620622', '', 341, 0, 0, 'Gulang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3284, '620623', 'ף', 341, 0, 0, 'Tianzhu Zangzu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3285, '620701', 'Ͻ', 342, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3287, '620721', 'ԣ', 342, 0, 0, 'Sunan Yugurzu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3289, '620723', '', 342, 0, 0, 'Linze Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3290, '620724', '̨', 342, 0, 0, 'Gaotai Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3291, '620725', 'ɽ', 342, 0, 0, 'Shandan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3293, '620802', '', 343, 0, 0, 'Kongdong Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3294, '620821', '', 343, 0, 0, 'Jingchuan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3295, '620822', '̨', 343, 0, 0, 'Lingtai Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3297, '620824', 'ͤ', 343, 0, 0, 'Huating Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3298, '620825', 'ׯ', 343, 0, 0, 'Zhuanglang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3299, '620826', '', 343, 0, 0, 'Jingning Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3301, '620902', '', 344, 0, 0, 'Suzhou Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3302, '620921', '', 344, 0, 0, 'Jinta Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3306, '620981', '', 344, 0, 0, 'Yumen Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3307, '620982', 'ػ', 344, 0, 0, 'Dunhuang Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3308, '621001', 'Ͻ', 345, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3309, '621002', '', 345, 0, 0, 'Xifeng Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3310, '621021', '', 345, 0, 0, 'Qingcheng Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3311, '621022', '', 345, 0, 0, 'Huan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3312, '621023', '', 345, 0, 0, 'Huachi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3314, '621025', '', 345, 0, 0, 'Zhengning Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3315, '621026', '', 345, 0, 0, 'Ning Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3316, '621027', 'ԭ', 345, 0, 0, 'Zhenyuan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3318, '621102', '', 346, 0, 0, 'Anding Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3319, '621121', 'ͨμ', 346, 0, 0, 'Tongwei Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3320, '621122', '¤', 346, 0, 0, 'Longxi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3322, '621124', '', 346, 0, 0, 'Lintao Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3323, '621125', '', 346, 0, 0, 'Zhang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3324, '621126', '', 346, 0, 0, 'Min Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3325, '621201', 'Ͻ', 347, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3327, '621221', '', 347, 0, 0, 'Cheng Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3328, '621222', '', 347, 0, 0, 'Wen Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3329, '621223', '崲', 347, 0, 0, 'Dangchang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3330, '621224', '', 347, 0, 0, 'Kang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3332, '621226', '', 347, 0, 0, 'Li Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3333, '621227', '', 347, 0, 0, 'Hui Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3334, '621228', '', 347, 0, 0, 'Liangdang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3335, '622901', '', 348, 0, 0, 'Linxia Shi', 'LXR');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3336, '622921', '', 348, 0, 0, 'Linxia Xian', 'LXF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3337, '622922', '', 348, 0, 0, 'Kangle Xian', 'KLE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3338, '622923', '', 348, 0, 0, 'Yongjing Xian', 'YJG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3339, '622924', '', 348, 0, 0, 'Guanghe Xian', 'GHX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3340, '622925', '', 348, 0, 0, 'Hezheng Xian', 'HZG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3341, '622926', '', 348, 0, 0, 'Dongxiangzu Zizhixian', 'DXZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3342, '622927', 'ʯɽ嶫', 348, 0, 0, 'Jishishan Bonanzu Dongxiangzu Salarzu Zizhixian', 'JSN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3343, '623001', '', 349, 0, 0, 'Hezuo Shi', 'HEZ');
commit;
prompt 2100 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3344, '623021', '̶', 349, 0, 0, 'Lintan Xian', 'LTN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3345, '623022', '׿', 349, 0, 0, 'Jone', 'JON');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3346, '623023', '', 349, 0, 0, 'Zhugqu Xian', 'ZQU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3347, '623024', '', 349, 0, 0, 'Tewo Xian', 'TEW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3348, '623025', '', 349, 0, 0, 'Maqu Xian', 'MQU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3349, '623026', 'µ', 349, 0, 0, 'Luqu Xian', 'LQU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (506, '130622', 'Է', 42, 0, 0, 'Qingyuan Xian', 'QYJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (508, '130624', 'ƽ', 42, 0, 0, 'Fuping Xian ', 'FUP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (509, '130625', 'ˮ', 42, 0, 0, 'Xushui Xian ', 'XSJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (510, '130626', '', 42, 0, 0, 'Dingxing Xian ', 'DXG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (512, '130628', '', 42, 0, 0, 'Gaoyang Xian ', 'GAY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (513, '130629', 'ݳ', 42, 0, 0, 'Rongcheng Xian ', 'RCX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (515, '130631', '', 42, 0, 0, 'Wangdu Xian ', 'WDU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (516, '130632', '', 42, 0, 0, 'Anxin Xian ', 'AXX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (517, '130633', '', 42, 0, 0, 'Yi Xian', 'YII');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (519, '130635', '', 42, 0, 0, 'Li Xian', 'LXJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (520, '130636', '˳ƽ', 42, 0, 0, 'Shunping Xian ', 'SPI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (521, '130637', 'Ұ', 42, 0, 0, 'Boye Xian ', 'BYE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (522, '130638', '', 42, 0, 0, 'Xiong Xian', 'XOX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (524, '130682', '', 42, 0, 0, 'Dingzhou Shi ', 'DZO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (525, '130683', '', 42, 0, 0, 'Anguo Shi ', 'AGO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (527, '130701', 'Ͻ', 43, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (528, '130702', 'Ŷ', 43, 0, 0, 'Qiaodong Qu', 'QDZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (529, '130703', '', 43, 0, 0, 'Qiaoxi Qu', 'QXI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (530, '130705', '', 43, 0, 0, 'Xuanhua Qu', 'XHZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (532, '130721', '', 43, 0, 0, 'Xuanhua Xian ', 'XHX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (533, '130722', 'ű', 43, 0, 0, 'Zhangbei Xian ', 'ZGB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (534, '130723', '', 43, 0, 0, 'Kangbao Xian', 'KBO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (536, '130725', '', 43, 0, 0, 'Shangyi Xian', 'SYK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (537, '130726', 'ε', 43, 0, 0, 'Yu Xian', 'YXJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (538, '130727', 'ԭ', 43, 0, 0, 'Yangyuan Xian', 'YYN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (540, '130729', 'ȫ', 43, 0, 0, 'Wanquan Xian ', 'WQN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (541, '130730', '', 43, 0, 0, 'Huailai Xian', 'HLA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (542, '130731', '¹', 43, 0, 0, 'Zhuolu Xian ', 'ZLU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (544, '130733', '', 43, 0, 0, 'Chongli Xian', 'COL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (545, '130801', 'Ͻ', 44, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (546, '130802', '˫', 44, 0, 0, 'Shuangqiao Qu ', 'SQO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (548, '130804', 'ӥӪӿ', 44, 0, 0, 'Yingshouyingzi Kuangqu', 'YSY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (550, '130822', '¡', 44, 0, 0, 'Xinglong Xian', 'XLJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (551, '130823', 'ƽȪ', 44, 0, 0, 'Pingquan Xian', 'PQN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (552, '130824', 'ƽ', 44, 0, 0, 'Luanping Xian ', 'LUP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (554, '130826', '', 44, 0, 0, 'Fengning Manzu Zizhixian', 'FNJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (556, '130828', 'Χɹ', 44, 0, 0, 'Weichang Manzu Menggolzu Zizhixian', 'WCJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (557, '130901', 'Ͻ', 45, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (559, '130903', '˺', 45, 0, 0, 'Yunhe Qu', 'YHC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (560, '130921', '', 45, 0, 0, 'Cang Xian', 'CAG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (561, '130922', '', 45, 0, 0, 'Qing Xian', 'QIG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (562, '130923', '', 45, 0, 0, 'Dongguang Xian ', 'DGU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (564, '130925', 'ɽ', 45, 0, 0, 'Yanshan Xian', 'YNS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (565, '130926', '', 45, 0, 0, 'Suning Xian ', 'SNG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (567, '130928', '', 45, 0, 0, 'Wuqiao Xian ', 'WUQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (568, '130929', '', 45, 0, 0, 'Xian Xian ', 'XXN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (570, '130981', 'ͷ', 45, 0, 0, 'Botou Shi ', 'BOT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (571, '130982', '', 45, 0, 0, 'Renqiu Shi', 'RQS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (572, '130983', '', 45, 0, 0, 'Huanghua Shi', 'HHJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (573, '130984', 'Ӽ', 45, 0, 0, 'Hejian Shi', 'HJN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (574, '131001', 'Ͻ', 46, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (575, '131002', '', 46, 0, 0, 'Anci Qu', 'ACI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (576, '131003', '', 46, 0, 0, 'Guangyang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (577, '131022', '̰', 46, 0, 0, 'Gu,an Xian', 'GUA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (578, '131023', '', 46, 0, 0, 'Yongqing Xian ', 'YQG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (579, '131024', '', 46, 0, 0, 'Xianghe Xian', 'XGH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (580, '131025', '', 46, 0, 0, 'Dacheng Xian', 'DCJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (581, '131026', 'İ', 46, 0, 0, 'Wen,an Xian', 'WEA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (582, '131028', '󳧻', 46, 0, 0, 'Dachang Huizu Zizhixian', 'DCG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (583, '131081', '', 46, 0, 0, 'Bazhou Shi', 'BZO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (584, '131082', '', 46, 0, 0, 'Sanhe Shi', 'SNH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (585, '131101', 'Ͻ', 47, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (586, '131102', 'ҳ', 47, 0, 0, 'Taocheng Qu', 'TOC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (588, '131122', '', 47, 0, 0, 'Wuyi Xian', 'WYI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (589, '131123', 'ǿ', 47, 0, 0, 'Wuqiang Xian ', 'WQG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (590, '131124', '', 47, 0, 0, 'Raoyang Xian', 'RYG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (592, '131126', 'ʳ', 47, 0, 0, 'Gucheng Xian', 'GCE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (593, '131127', '', 47, 0, 0, 'Jing Xian ', 'JIG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (595, '131181', '', 47, 0, 0, 'Jizhou Shi ', 'JIZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (596, '131182', '', 47, 0, 0, 'Shenzhou Shi', 'SNZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (597, '140101', 'Ͻ', 48, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (599, '140106', 'ӭ', 48, 0, 0, 'Yingze Qu', 'YZT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (600, '140107', 'ӻ', 48, 0, 0, 'Xinghualing Qu', 'XHL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (603, '140110', 'Դ', 48, 0, 0, 'Jinyuan Qu', 'JYM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (604, '140121', '', 48, 0, 0, 'Qingxu Xian ', 'QXU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (606, '140123', '¦', 48, 0, 0, 'Loufan Xian', 'LFA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (607, '140181', 'Ž', 48, 0, 0, 'Gujiao Shi', 'GUJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (608, '140201', 'Ͻ', 49, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (609, '140202', '', 49, 0, 0, 'Chengqu', 'CQD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (610, '140203', '', 49, 0, 0, 'Kuangqu', 'KQD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (612, '140212', '', 49, 0, 0, 'Xinrong Qu', 'XRQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (613, '140221', '', 49, 0, 0, 'Yanggao Xian ', 'YGO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (615, '140223', '', 49, 0, 0, 'Guangling Xian ', 'GLJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (616, '140224', '', 49, 0, 0, 'Lingqiu Xian ', 'LQX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (618, '140226', '', 49, 0, 0, 'Zuoyun Xian', 'ZUY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (619, '140227', 'ͬ', 49, 0, 0, 'Datong Xian ', 'DTX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (620, '140301', 'Ͻ', 50, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (621, '140302', '', 50, 0, 0, 'Chengqu', 'CQU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (622, '140303', '', 50, 0, 0, 'Kuangqu', 'KQY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (623, '140311', '', 50, 0, 0, 'Jiaoqu', 'JQY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (625, '140322', '', 50, 0, 0, 'Yu Xian', 'YUX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (626, '140401', 'Ͻ', 51, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (627, '140402', '', 51, 0, 0, 'Chengqu ', 'CQC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (628, '140411', '', 51, 0, 0, 'Jiaoqu', 'JQZ');
commit;
prompt 2200 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (629, '140421', '', 51, 0, 0, 'Changzhi Xian', 'CZI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (630, '140423', 'ԫ', 51, 0, 0, 'Xiangyuan Xian', 'XYJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (632, '140425', 'ƽ˳', 51, 0, 0, 'Pingshun Xian', 'PSX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (633, '140426', '', 51, 0, 0, 'Licheng Xian', 'LIC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (635, '140428', '', 51, 0, 0, 'Zhangzi Xian ', 'ZHZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (636, '140429', '', 51, 0, 0, 'Wuxiang Xian', 'WXG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (638, '140431', 'Դ', 51, 0, 0, 'Qinyuan Xian ', 'QYU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (639, '140481', 'º', 51, 0, 0, 'Lucheng Shi', 'LCS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (640, '140501', 'Ͻ', 52, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (641, '140502', '', 52, 0, 0, 'Chengqu ', 'CQJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (643, '140522', '', 52, 0, 0, 'Yangcheng Xian ', 'YGC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (645, '140525', '', 52, 0, 0, 'Zezhou Xian', 'ZEZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (646, '140581', 'ƽ', 52, 0, 0, 'Gaoping Shi ', 'GPG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (647, '140601', 'Ͻ', 53, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (648, '140602', '˷', 53, 0, 0, 'Shuocheng Qu', 'SCH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (650, '140621', 'ɽ', 53, 0, 0, 'Shanyin Xian', 'SYP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (651, '140622', 'Ӧ', 53, 0, 0, 'Ying Xian', 'YIG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (653, '140624', '', 53, 0, 0, 'Huairen Xian', 'HRN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (654, '140701', 'Ͻ', 54, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (655, '140702', 'ܴ', 54, 0, 0, 'Yuci Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (656, '140721', '', 54, 0, 0, 'Yushe Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (658, '140723', '˳', 54, 0, 0, 'Heshun Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (659, '140724', '', 54, 0, 0, 'Xiyang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (661, '140726', '̫', 54, 0, 0, 'Taigu Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (662, '140727', '', 54, 0, 0, 'Qi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (663, '140728', 'ƽң', 54, 0, 0, 'Pingyao Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (665, '140781', '', 54, 0, 0, 'Jiexiu Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (666, '140801', 'Ͻ', 55, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (667, '140802', 'κ', 55, 0, 0, 'Yanhu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (668, '140821', '', 55, 0, 0, 'Linyi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (669, '140822', '', 55, 0, 0, 'Wanrong Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (671, '140824', 'ɽ', 55, 0, 0, 'Jishan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (672, '140825', '', 55, 0, 0, 'Xinjiang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (674, '140827', 'ԫ', 55, 0, 0, 'Yuanqu Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (675, '140828', '', 55, 0, 0, 'Xia Xian ', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (677, '140830', 'ǳ', 55, 0, 0, 'Ruicheng Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (678, '140881', '', 55, 0, 0, 'Yongji Shi ', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (680, '140901', 'Ͻ', 56, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (681, '140902', 'ø', 56, 0, 0, 'Xinfu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (682, '140921', '', 56, 0, 0, 'Dingxiang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (683, '140922', '̨', 56, 0, 0, 'Wutai Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (684, '140923', '', 56, 0, 0, 'Dai Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (686, '140925', '', 56, 0, 0, 'Ningwu Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (687, '140926', '', 56, 0, 0, 'Jingle Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (689, '140928', 'կ', 56, 0, 0, 'Wuzhai Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (690, '140929', '', 56, 0, 0, 'Kelan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (691, '140930', '', 56, 0, 0, 'Hequ Xian ', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (693, '140932', 'ƫ', 56, 0, 0, 'Pianguan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (694, '140981', 'ԭƽ', 56, 0, 0, 'Yuanping Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (695, '141001', 'Ͻ', 57, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (696, '141002', 'Ң', 57, 0, 0, 'Yaodu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (698, '141022', '', 57, 0, 0, 'Yicheng Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (699, '141023', '', 57, 0, 0, 'Xiangfen Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (701, '141025', '', 57, 0, 0, 'Gu Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (702, '141026', '', 57, 0, 0, 'Anze Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (703, '141027', 'ɽ', 57, 0, 0, 'Fushan Xian ', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (705, '141029', '', 57, 0, 0, 'Xiangning Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (706, '141030', '', 57, 0, 0, 'Daning Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (708, '141032', '', 57, 0, 0, 'Yonghe Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (709, '141033', '', 57, 0, 0, 'Pu Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (710, '141034', '', 57, 0, 0, 'Fenxi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (712, '141082', '', 57, 0, 0, 'Huozhou Shi ', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (713, '141101', 'Ͻ', 58, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (714, '141102', 'ʯ', 58, 0, 0, 'Lishi Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (715, '141121', 'ˮ', 58, 0, 0, 'Wenshui Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (716, '141122', '', 58, 0, 0, 'Jiaocheng Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (717, '141123', '', 58, 0, 0, 'Xing Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (718, '141124', '', 58, 0, 0, 'Lin Xian ', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (719, '141125', '', 58, 0, 0, 'Liulin Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (720, '141126', 'ʯ¥', 58, 0, 0, 'Shilou Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (721, '141127', '', 58, 0, 0, 'Lan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (722, '141128', 'ɽ', 58, 0, 0, 'Fangshan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (723, '141129', '', 58, 0, 0, 'Zhongyang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (724, '141130', '', 58, 0, 0, 'Jiaokou Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (725, '141181', 'Т', 58, 0, 0, 'Xiaoyi Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (726, '141182', '', 58, 0, 0, 'Fenyang Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (727, '150101', 'Ͻ', 59, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (728, '150102', '³', 59, 0, 0, 'Xincheng Qu', 'XCN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (729, '150103', '', 59, 0, 0, 'Huimin Qu', 'HMQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (730, '150104', 'Ȫ', 59, 0, 0, 'Yuquan Qu', 'YQN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (731, '150105', '', 59, 0, 0, 'Saihan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (732, '150121', 'Ĭ', 59, 0, 0, 'Tumd Zuoqi', 'TUZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (733, '150122', 'п', 59, 0, 0, 'Togtoh Xian', 'TOG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (734, '150123', 'ָ', 59, 0, 0, 'Horinger Xian', 'HOR');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (735, '150124', 'ˮ', 59, 0, 0, 'Qingshuihe Xian', 'QSH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (736, '150125', '䴨', 59, 0, 0, 'Wuchuan Xian', 'WCX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (737, '150201', 'Ͻ', 60, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (738, '150202', '', 60, 0, 0, 'Donghe Qu', 'DHE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (739, '150203', '', 60, 0, 0, 'Kundulun Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (740, '150204', 'ɽ', 60, 0, 0, 'Qingshan Qu', 'QSB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (742, '150206', 'ƶ', 60, 0, 0, 'Baiyun Kuangqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (743, '150207', 'ԭ', 60, 0, 0, 'Jiuyuan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (745, '150222', '', 60, 0, 0, 'Guyang Xian', 'GYM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (746, '150223', 'ï', 60, 0, 0, 'Darhan Muminggan Lianheqi', 'DML');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (748, '150302', '', 61, 0, 0, 'Haibowan Qu', 'HBW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (749, '150303', '', 61, 0, 0, 'Hainan Qu', 'HNU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (751, '150401', 'Ͻ', 62, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (752, '150402', 'ɽ', 62, 0, 0, 'Hongshan Qu', 'HSZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (754, '150404', 'ɽ', 62, 0, 0, 'Songshan Qu', 'SSQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (757, '150423', '', 62, 0, 0, 'Bairin Youqi', 'BAY');
commit;
prompt 2300 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (758, '150424', '', 62, 0, 0, 'Linxi Xian', 'LXM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (759, '150425', 'ʲ', 62, 0, 0, 'Hexigten Qi', 'HXT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (761, '150428', '', 62, 0, 0, 'Harqin Qi', 'HAR');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (762, '150429', '', 62, 0, 0, 'Ningcheng Xian', 'NCH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (763, '150430', '', 62, 0, 0, 'Aohan Qi', 'AHN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (765, '150502', 'ƶ', 63, 0, 0, 'Keermi Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (767, '150522', 'ƶ', 63, 0, 0, 'Horqin Zuoyi Houqi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (768, '150523', '³', 63, 0, 0, 'Kailu Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (769, '150524', '', 63, 0, 0, 'Hure Qi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (770, '150525', '', 63, 0, 0, 'Naiman Qi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (772, '150581', 'ֹ', 63, 0, 0, 'Holingol Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (773, '150602', 'ʤ', 64, 0, 0, 'Dongsheng Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (775, '150622', '׼', 64, 0, 0, 'Jungar Qi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (776, '150623', 'пǰ', 64, 0, 0, 'Otog Qianqi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (778, '150625', '', 64, 0, 0, 'Hanggin Qi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (779, '150626', '', 64, 0, 0, 'Uxin Qi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (780, '150627', '', 64, 0, 0, 'Ejin Horo Qi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (782, '150702', '', 65, 0, 0, 'Hailaer Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (783, '150721', '', 65, 0, 0, 'Arun Qi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (785, '150723', '״', 65, 0, 0, 'Oroqen Zizhiqi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (788, '150726', '°Ͷ', 65, 0, 0, 'Xin Barag Zuoqi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (789, '150727', '°Ͷ', 65, 0, 0, 'Xin Barag Youqi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (791, '150782', 'ʯ', 65, 0, 0, 'Yakeshi Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (792, '150783', '', 65, 0, 0, 'Zalantun Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (794, '150785', '', 65, 0, 0, 'Genhe Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (795, '150801', 'Ͻ', 66, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (796, '150802', 'ٺ', 66, 0, 0, 'Linhe Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (797, '150821', 'ԭ', 66, 0, 0, 'Wuyuan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (799, '150823', 'ǰ', 66, 0, 0, 'Urad Qianqi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (800, '150824', '', 66, 0, 0, 'Urad Zhongqi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (802, '150826', '', 66, 0, 0, 'Hanggin Houqi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (803, '150901', 'Ͻ', 67, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (804, '150902', '', 67, 0, 0, 'Jining Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (806, '150922', '', 67, 0, 0, 'Huade Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (807, '150923', '̶', 67, 0, 0, 'Shangdu Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (808, '150924', '˺', 67, 0, 0, 'Xinghe Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (810, '150926', 'ǰ', 67, 0, 0, 'Qahar Youyi Qianqi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (812, '150928', '', 67, 0, 0, 'Qahar Youyi Houqi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (813, '150929', '', 67, 0, 0, 'Dorbod Qi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (815, '152201', '', 68, 0, 0, 'Ulan Hot Shi', 'ULO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (816, '152202', 'ɽ', 68, 0, 0, 'Arxan Shi', 'ARS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (819, '152223', '', 68, 0, 0, 'Jalaid Qi', 'JAL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (821, '152501', '', 69, 0, 0, 'Erenhot Shi', 'ERC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (823, '152522', '͸', 69, 0, 0, 'Abag Qi', 'ABG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (824, '152523', '', 69, 0, 0, 'Sonid Zuoqi', 'SOZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (825, '152524', '', 69, 0, 0, 'Sonid Youqi', 'SOY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (827, '152526', '', 69, 0, 0, 'Xi Ujimqin Qi', 'XUJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (828, '152527', '̫', 69, 0, 0, 'Taibus Qi', 'TAB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (830, '152529', '', 69, 0, 0, 'Zhengxiangbai(Xulun Hobot Qagan)Qi', 'ZXB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (831, '152530', '', 69, 0, 0, 'Zhenglan(Xulun Hoh)Qi', 'ZLM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (832, '152531', '', 69, 0, 0, 'Duolun (Dolonnur)Xian', 'DLM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (834, '152922', '', 70, 0, 0, 'Alxa Youqi', 'ALY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (835, '152923', '', 70, 0, 0, 'Ejin Qi', 'EJI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (837, '210102', 'ƽ', 71, 0, 0, 'Heping Qu', 'HEP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (838, '210103', '', 71, 0, 0, 'Shenhe Qu ', 'SHQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (839, '210104', '', 71, 0, 0, 'Dadong Qu ', 'DDQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (841, '210106', '', 71, 0, 0, 'Tiexi Qu', 'TXI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (842, '210111', 'ռ', 71, 0, 0, 'Sujiatun Qu', 'SJT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (844, '210113', '', 71, 0, 0, 'Xinchengzi Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (845, '210114', 'ں', 71, 0, 0, 'Yuhong Qu ', 'YHQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (846, '210122', '', 71, 0, 0, 'Liaozhong Xian', 'LZL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (848, '210124', '', 71, 0, 0, 'Faku Xian', 'FKU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (849, '210181', '', 71, 0, 0, 'Xinmin Shi', 'XMS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (851, '210202', 'ɽ', 72, 0, 0, 'Zhongshan Qu', 'ZSD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (852, '210203', '', 72, 0, 0, 'Xigang Qu', 'XGD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (853, '210204', 'ɳӿ', 72, 0, 0, 'Shahekou Qu', 'SHK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (854, '210211', 'ʾ', 72, 0, 0, 'Ganjingzi Qu', 'GJZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (855, '210212', '˳', 72, 0, 0, 'Lvshunkou Qu ', 'LSK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (856, '210213', '', 72, 0, 0, 'Jinzhou Qu', 'JZH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (857, '210224', '', 72, 0, 0, 'Changhai Xian', 'CHX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (858, '210281', '߷', 72, 0, 0, 'Wafangdian Shi', 'WFD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (859, '210282', '', 72, 0, 0, 'Pulandian Shi', 'PLD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (860, '210283', 'ׯ', 72, 0, 0, 'Zhuanghe Shi', 'ZHH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (861, '210301', 'Ͻ', 73, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (862, '210302', '', 73, 0, 0, 'Tiedong Qu ', 'TED');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (863, '210303', '', 73, 0, 0, 'Tiexi Qu', 'TXL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (864, '210304', 'ɽ', 73, 0, 0, 'Lishan Qu', 'LAS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (865, '210311', 'ǧɽ', 73, 0, 0, 'Qianshan Qu ', 'QSQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (866, '210321', '̨', 73, 0, 0, 'Tai,an Xian', 'TAX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (869, '210401', 'Ͻ', 74, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (870, '210402', '¸', 74, 0, 0, 'Xinfu Qu', 'XFU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (871, '210403', '', 74, 0, 0, 'Dongzhou Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (872, '210404', '', 74, 0, 0, 'Wanghua Qu', 'WHF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (873, '210411', '˳', 74, 0, 0, 'Shuncheng Qu', 'SCF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (875, '210422', '±', 74, 0, 0, 'Xinbinmanzuzizhi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (876, '210423', 'ԭ', 74, 0, 0, 'Qingyuanmanzuzizhi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (877, '210501', 'Ͻ', 75, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (878, '210502', 'ƽɽ', 75, 0, 0, 'Pingshan Qu', 'PSN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (879, '210503', 'Ϫ', 75, 0, 0, 'Xihu Qu ', 'XHB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (881, '210505', 'Ϸ', 75, 0, 0, 'Nanfen Qu', 'NFQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (882, '210521', 'Ϫ', 75, 0, 0, 'Benxi Manzu Zizhixian', 'BXX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (884, '210601', 'Ͻ', 76, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (885, '210602', 'Ԫ', 76, 0, 0, 'Yuanbao Qu', 'YBD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (886, '210603', '', 76, 0, 0, 'Zhenxing Qu ', 'ZXQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (887, '210604', '', 76, 0, 0, 'Zhen,an Qu', 'ZAQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (889, '210681', '', 76, 0, 0, 'Donggang Shi', 'DGS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (890, '210682', '', 76, 0, 0, 'Fengcheng Shi', 'FCL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (891, '210701', 'Ͻ', 77, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (892, '210702', '', 77, 0, 0, 'Guta Qu', 'GTQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (893, '210703', '', 77, 0, 0, 'Linghe Qu', 'LHF');
commit;
prompt 2400 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (894, '210711', '̫', 77, 0, 0, 'Taihe Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (896, '210727', '', 77, 0, 0, 'Yi Xian', 'YXL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (897, '210781', '躣', 77, 0, 0, 'Linghai Shi ', 'LHL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (899, '210801', 'Ͻ', 78, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (900, '210802', 'վǰ', 78, 0, 0, 'Zhanqian Qu', 'ZQQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (901, '210803', '', 78, 0, 0, 'Xishi Qu', 'XII');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (902, '210804', 'Ȧ', 78, 0, 0, 'Bayuquan Qu', 'BYQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (903, '210811', 'ϱ', 78, 0, 0, 'Laobian Qu', 'LOB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (905, '210882', 'ʯ', 78, 0, 0, 'Dashiqiao Shi', 'DSQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (906, '210901', 'Ͻ', 79, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (907, '210902', '', 79, 0, 0, 'Haizhou Qu', 'HZF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (908, '210903', '', 79, 0, 0, 'Xinqiu Qu', 'XQF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (909, '210904', '̫ƽ', 79, 0, 0, 'Taiping Qu', 'TPG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (911, '210911', 'ϸ', 79, 0, 0, 'Xihe Qu', 'XHO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (913, '210922', '', 79, 0, 0, 'Zhangwu Xian', 'ZWU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (914, '211001', 'Ͻ', 80, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (915, '211002', '', 80, 0, 0, 'Baita Qu', 'BTL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (916, '211003', 'ʥ', 80, 0, 0, 'Wensheng Qu', 'WST');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (917, '211004', 'ΰ', 80, 0, 0, 'Hongwei Qu', 'HWQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (918, '211005', '', 80, 0, 0, 'Gongchangling Qu', 'GCL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (920, '211021', '', 80, 0, 0, 'Liaoyang Xian', 'LYX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (921, '211081', '', 80, 0, 0, 'Dengta Shi', 'DTL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (922, '211101', 'Ͻ', 81, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (924, '211103', '¡̨', 81, 0, 0, 'Xinglongtai Qu', 'XLT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (925, '211121', '', 81, 0, 0, 'Dawa Xian', 'DWA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (926, '211122', 'ɽ', 81, 0, 0, 'Panshan Xian', 'PNS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (927, '211201', 'Ͻ', 82, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (929, '211204', '', 82, 0, 0, 'Qinghe Qu', 'QHQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (930, '211221', '', 82, 0, 0, 'Tieling Xian', 'TLG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (931, '211223', '', 82, 0, 0, 'Xifeng Xian', 'XIF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (933, '211281', 'ɽ', 82, 0, 0, 'Diaobingshan Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (934, '211282', 'ԭ', 82, 0, 0, 'Kaiyuan Shi', 'KYS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (935, '211301', 'Ͻ', 83, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (936, '211302', '˫', 83, 0, 0, 'Shuangta Qu', 'STQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (938, '211321', '', 83, 0, 0, 'Chaoyang Xian', 'CYG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (939, '211322', 'ƽ', 83, 0, 0, 'Jianping Xian', 'JPG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (941, '211381', 'Ʊ', 83, 0, 0, 'Beipiao Shi', 'BPO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (942, '211382', 'Դ', 83, 0, 0, 'Lingyuan Shi', 'LYK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (943, '211401', 'Ͻ', 84, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1396, '331126', 'Ԫ', 132, 0, 0, 'Qingyuan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1405, '340122', 'ʶ', 133, 0, 0, 'Feidong Xian', 'FDO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1410, '340203', '߮', 1412, 0, 0, 'Xinwu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1414, '340223', '', 1412, 0, 0, 'Nanling Xian', 'NLX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1424, '340402', 'ͨ', 136, 0, 0, 'Datong Qu', 'DTQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1041, '230204', '', 95, 0, 0, 'Tiefeng Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1043, '230206', '', 95, 0, 0, 'Hulan Ergi Qu', 'HUE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1044, '230207', 'ɽ', 95, 0, 0, 'Nianzishan Qu', 'NZS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1046, '230221', '', 95, 0, 0, 'Longjiang Xian', 'LGJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1047, '230223', '', 95, 0, 0, 'Yi,an Xian', 'YAN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1048, '230224', '̩', 95, 0, 0, 'Tailai Xian', 'TLA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1049, '230225', '', 95, 0, 0, 'Gannan Xian', 'GNX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1050, '230227', 'ԣ', 95, 0, 0, 'Fuyu Xian', 'FYX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1052, '230230', '˶', 95, 0, 0, 'Kedong Xian', 'KDO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1053, '230231', 'Ȫ', 95, 0, 0, 'Baiquan Xian', 'BQN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1054, '230281', 'ګ', 95, 0, 0, 'Nehe Shi', 'NEH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1056, '230302', '', 96, 0, 0, 'Jiguan Qu', 'JGU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1059, '230305', '', 96, 0, 0, 'Lishu Qu', 'LJX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1060, '230306', 'Ӻ', 96, 0, 0, 'Chengzihe Qu', 'CZH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1061, '230307', 'ɽ', 96, 0, 0, 'Mashan Qu', 'MSN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1064, '230382', 'ɽ', 96, 0, 0, 'Mishan Shi', 'MIS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1065, '230401', 'Ͻ', 97, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1067, '230403', 'ũ', 97, 0, 0, 'Gongnong Qu', 'GNH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1068, '230404', 'ɽ', 97, 0, 0, 'Nanshan Qu', 'NSQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1070, '230406', 'ɽ', 97, 0, 0, 'Dongshan Qu', 'DSA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1072, '230421', 'ܱ', 97, 0, 0, 'Luobei Xian', 'LUB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1074, '230501', 'Ͻ', 98, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1075, '230502', 'ɽ', 98, 0, 0, 'Jianshan Qu', 'JSQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1076, '230503', '붫', 98, 0, 0, 'Lingdong Qu', 'LDQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1078, '230506', 'ɽ', 98, 0, 0, 'Baoshan Qu', 'BSQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1080, '230522', '', 98, 0, 0, 'Youyi Xian', 'YYI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1082, '230524', 'ĺ', 98, 0, 0, 'Raohe Xian ', 'ROH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1083, '230601', 'Ͻ', 99, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1086, '230604', 'ú·', 99, 0, 0, 'Ranghulu Qu', 'RHL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1087, '230605', '', 99, 0, 0, 'Honggang Qu', 'HGD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1090, '230622', 'Դ', 99, 0, 0, 'Zhaoyuan Xian', 'ZYH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1091, '230623', 'ֵ', 99, 0, 0, 'Lindian Xian ', 'LDN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1093, '230701', 'Ͻ', 100, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1094, '230702', '', 100, 0, 0, 'Yichun Qu', 'YYC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1096, '230704', 'Ѻ', 100, 0, 0, 'Youhao Qu', 'YOH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1097, '230705', '', 100, 0, 0, 'Xilin Qu', 'XIL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1099, '230707', '', 100, 0, 0, 'Xinqing Qu', 'XQQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1101, '230709', 'ɽ', 100, 0, 0, 'Jinshantun Qu', 'JST');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1103, '230711', '', 100, 0, 0, 'Wumahe Qu', 'WMH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1106, '230714', '', 100, 0, 0, 'Wuyiling Qu', 'WYL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1107, '230715', '', 100, 0, 0, 'Hongxing Qu', 'HGX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1109, '230722', '', 100, 0, 0, 'Jiayin Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1110, '230781', '', 100, 0, 0, 'Tieli Shi', 'TEL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1111, '230801', 'Ͻ', 101, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1113, '230803', '', 101, 0, 0, 'Xiangyang  Qu ', 'XYQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1115, '230805', '', 101, 0, 0, 'Dongfeng Qu', 'DFQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1116, '230811', '', 101, 0, 0, 'Jiaoqu', 'JQJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1118, '230826', '봨', 101, 0, 0, 'Huachuan Xian', 'HCN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1120, '230833', 'Զ', 101, 0, 0, 'Fuyuan Xian', 'FUY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1122, '230882', '', 101, 0, 0, 'Fujin Shi', 'FUJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1123, '230901', 'Ͻ', 102, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1126, '230904', 'Ӻ', 102, 0, 0, 'Qiezihe Qu', 'QZI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1127, '230921', '', 102, 0, 0, 'Boli Xian', 'BLI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1129, '231002', '', 103, 0, 0, 'Dong,an Qu', 'DGA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1131, '231004', '', 103, 0, 0, 'Aimin Qu', 'AMQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1133, '231024', '', 103, 0, 0, 'Dongning Xian', 'DON');
commit;
prompt 2500 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1134, '231025', 'ֿ', 103, 0, 0, 'Linkou Xian', 'LKO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1136, '231083', '', 103, 0, 0, 'Hailin Shi', 'HLS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1137, '231084', '', 103, 0, 0, 'Ning,an Shi', 'NAI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1139, '231101', 'Ͻ', 104, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1140, '231102', '', 104, 0, 0, 'Aihui Qu', 'AHQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1141, '231121', '۽', 104, 0, 0, 'Nenjiang Xian', 'NJH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1142, '231123', 'ѷ', 104, 0, 0, 'Xunke Xian', 'XUK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1144, '231181', '', 104, 0, 0, 'Bei,an Shi', 'BAS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1145, '231182', '', 104, 0, 0, 'Wudalianchi Shi', 'WDL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1146, '231201', 'Ͻ', 105, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1147, '231202', '', 105, 0, 0, 'Beilin Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1149, '231222', '', 105, 0, 0, 'Lanxi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1150, '231223', '', 105, 0, 0, 'Qinggang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1152, '231225', 'ˮ', 105, 0, 0, 'Mingshui Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1153, '231226', '', 105, 0, 0, 'Suileng Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1154, '231281', '', 105, 0, 0, 'Anda Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1156, '231283', '', 105, 0, 0, 'Hailun Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1157, '232721', '', 106, 0, 0, 'Huma Xian', 'HUM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1158, '232722', '', 106, 0, 0, 'Tahe Xian', 'TAH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1160, '310101', '', 107, 0, 0, 'Huangpu Qu', 'HGP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1161, '310103', '¬', 107, 0, 0, 'Luwan Qu', 'LWN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1162, '310104', '', 107, 0, 0, 'Xuhui Qu', 'XHI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1164, '310106', '', 107, 0, 0, 'Jing,an Qu', 'JAQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1165, '310107', '', 107, 0, 0, 'Putuo Qu', 'PTQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1166, '310108', 'բ', 107, 0, 0, 'Zhabei Qu', 'ZBE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1167, '310109', '', 107, 0, 0, 'Hongkou Qu', 'HKQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1169, '310112', '', 107, 0, 0, 'Minhang Qu', 'MHQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1170, '310113', 'ɽ', 107, 0, 0, 'Baoshan Qu', 'BAO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1171, '310114', 'ζ', 107, 0, 0, 'Jiading Qu', 'JDG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1173, '310116', 'ɽ', 107, 0, 0, 'Jinshan Qu', 'JSH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1174, '310117', 'ɽ', 107, 0, 0, 'Songjiang Qu', 'SOJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1175, '310118', '', 107, 0, 0, 'Qingpu  Qu', 'QPU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1177, '310120', '', 107, 0, 0, 'Fengxian Qu', 'FXI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1178, '310230', '', 108, 0, 0, 'Chongming Xian', 'CMI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1179, '320101', 'Ͻ', 109, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1181, '320103', '', 109, 0, 0, 'Baixia Qu', 'BXQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1182, '320104', 'ػ', 109, 0, 0, 'Qinhuai Qu', 'QHU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1183, '320105', '', 109, 0, 0, 'Jianye Qu', 'JYQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1184, '320106', '¥', 109, 0, 0, 'Gulou Qu', 'GLQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1186, '320111', 'ֿ', 109, 0, 0, 'Pukou Qu', 'PKO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1187, '320113', 'ϼ', 109, 0, 0, 'Qixia Qu', 'QAX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1188, '320114', '껨̨', 109, 0, 0, 'Yuhuatai Qu', 'YHT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1425, '340403', '', 136, 0, 0, 'Tianjia,an Qu', 'TJA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1427, '340405', '˹ɽ', 136, 0, 0, 'Bagongshan Qu', 'BGS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1428, '340406', '˼', 136, 0, 0, 'Panji Qu', 'PJI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1429, '340421', '̨', 136, 0, 0, 'Fengtai Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1430, '340501', 'Ͻ', 137, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1431, '340502', 'ׯ', 137, 0, 0, 'Jinjiazhuang Qu', 'JJZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1432, '340503', 'ɽ', 137, 0, 0, 'Huashan Qu', 'HSM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1433, '340504', 'ɽ', 137, 0, 0, 'Yushan Qu', 'YSQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1434, '340521', 'Ϳ', 137, 0, 0, 'Dangtu Xian', 'DTU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1435, '340601', 'Ͻ', 138, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1436, '340602', 'ż', 138, 0, 0, 'Duji Qu', 'DJQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1437, '340603', 'ɽ', 138, 0, 0, 'Xiangshan Qu', 'XSA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1438, '340604', 'ɽ', 138, 0, 0, 'Lieshan Qu', 'LHB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1439, '340621', 'Ϫ', 138, 0, 0, 'Suixi Xian', 'SXW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1440, '340701', 'Ͻ', 139, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1441, '340702', 'ͭɽ', 139, 0, 0, 'Tongguanshan Qu', 'TGQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1442, '340703', 'ʨɽ', 139, 0, 0, 'Shizishan Qu', 'SZN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1443, '340711', '', 139, 0, 0, 'Jiaoqu', 'JTL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1444, '340721', 'ͭ', 139, 0, 0, 'Tongling Xian', 'TLX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1445, '340801', 'Ͻ', 140, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1446, '340802', 'ӭ', 140, 0, 0, 'Yingjiang Qu', 'YJQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1447, '340803', '', 140, 0, 0, 'Daguan Qu', 'DGQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1448, '340811', '', 140, 0, 0, 'Yixiu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1449, '340822', '', 140, 0, 0, 'Huaining Xian', 'HNW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1450, '340823', '', 140, 0, 0, 'Zongyang Xian', 'ZYW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1451, '340824', 'Ǳɽ', 140, 0, 0, 'Qianshan Xian', 'QSW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1452, '340825', '̫', 140, 0, 0, 'Taihu Xian', 'THU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1453, '340826', '', 140, 0, 0, 'Susong Xian', 'SUS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1454, '340827', '', 140, 0, 0, 'Wangjiang Xian', 'WJX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1455, '340828', '', 140, 0, 0, 'Yuexi Xian', 'YXW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1456, '340881', 'ͩ', 140, 0, 0, 'Tongcheng Shi', 'TCW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1457, '341001', 'Ͻ', 141, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1458, '341002', 'Ϫ', 141, 0, 0, 'Tunxi Qu', 'TXN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1459, '341003', 'ɽ', 141, 0, 0, 'Huangshan Qu', 'HSK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1460, '341004', '', 141, 0, 0, 'Huizhou Qu', 'HZQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1461, '341021', '', 141, 0, 0, 'She Xian', 'SEX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1462, '341022', '', 141, 0, 0, 'Xiuning Xian', 'XUN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1463, '341023', '', 141, 0, 0, 'Yi Xian', 'YIW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1464, '341024', '', 141, 0, 0, 'Qimen Xian', 'QMN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1465, '341101', 'Ͻ', 142, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1466, '341102', '', 142, 0, 0, 'Langya Qu', 'LYU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1467, '341103', '', 142, 0, 0, 'Nanqiao Qu', 'NQQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1468, '341122', '', 142, 0, 0, 'Lai,an Xian', 'LAX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1469, '341124', 'ȫ', 142, 0, 0, 'Quanjiao Xian', 'QJO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1470, '341125', 'Զ', 142, 0, 0, 'Dingyuan Xian', 'DYW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1471, '341126', '', 142, 0, 0, 'Fengyang Xian', 'FYG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1472, '341181', '쳤', 142, 0, 0, 'Tianchang Shi', 'TNC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1473, '341182', '', 142, 0, 0, 'Mingguang Shi', 'MGG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1474, '341201', 'Ͻ', 143, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1475, '341202', '', 143, 0, 0, 'Yingzhou Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1476, '341203', '򣶫', 143, 0, 0, 'Yingdong Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1477, '341204', 'Ȫ', 143, 0, 0, 'Yingquan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1478, '341221', 'Ȫ', 143, 0, 0, 'Linquan Xian', 'LQN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1479, '341222', '̫', 143, 0, 0, 'Taihe Xian', 'TIH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1480, '341225', '', 143, 0, 0, 'Funan Xian', 'FNX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1481, '341226', '', 143, 0, 0, 'Yingshang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1482, '341282', '', 143, 0, 0, 'Jieshou Shi', 'JSW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1483, '341301', 'Ͻ', 144, 0, 0, 'Shixiaqu', '2');
commit;
prompt 2600 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1484, '341302', '', 144, 0, 0, 'Yongqiao Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1485, '341321', 'ɽ', 144, 0, 0, 'Dangshan Xian', 'DSW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1486, '341322', '', 144, 0, 0, 'Xiao Xian', 'XIO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1487, '341323', '', 144, 0, 0, 'Lingbi Xian', 'LBI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1488, '341324', '', 144, 0, 0, 'Si Xian ', 'SIX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1489, '341401', 'Ͻ', 145, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1490, '341402', 'ӳ', 145, 0, 0, 'Juchao Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1491, '341421', '®', 145, 0, 0, 'Lujiang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1492, '341422', 'Ϊ', 145, 0, 0, 'Wuwei Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1493, '341423', 'ɽ', 145, 0, 0, 'Hanshan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1494, '341424', '', 145, 0, 0, 'He Xian ', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1495, '341501', 'Ͻ', 146, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1496, '341502', '', 146, 0, 0, 'Jinan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1497, '341503', 'ԣ', 146, 0, 0, 'Yuan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1498, '341521', '', 146, 0, 0, 'Shou Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1499, '341522', '', 146, 0, 0, 'Huoqiu Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1500, '341523', '', 146, 0, 0, 'Shucheng Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1501, '341524', 'կ', 146, 0, 0, 'Jingzhai Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1502, '341525', 'ɽ', 146, 0, 0, 'Huoshan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1503, '341601', 'Ͻ', 147, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1504, '341602', '۳', 147, 0, 0, 'Qiaocheng Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1505, '341621', '', 147, 0, 0, 'Guoyang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1506, '341622', 'ɳ', 147, 0, 0, 'Mengcheng Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1507, '341623', '', 147, 0, 0, 'Lixin Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1508, '341701', 'Ͻ', 148, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1509, '341702', '', 148, 0, 0, 'Guichi Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1510, '341721', '', 148, 0, 0, 'Dongzhi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1511, '341722', 'ʯ̨', 148, 0, 0, 'Shitai Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1512, '341723', '', 148, 0, 0, 'Qingyang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1513, '341801', 'Ͻ', 149, 0, 0, '1', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1514, '341802', '', 149, 0, 0, 'Xuanzhou Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1515, '341821', 'Ϫ', 149, 0, 0, 'Langxi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1516, '341822', '', 149, 0, 0, 'Guangde Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1517, '341823', '', 149, 0, 0, 'Jing Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1518, '341824', 'Ϫ', 149, 0, 0, 'Jixi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1519, '341825', '캵', 149, 0, 0, 'Jingde Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1520, '341881', '', 149, 0, 0, 'Ningguo Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1521, '350101', 'Ͻ', 150, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1522, '350102', '¥', 150, 0, 0, 'Gulou Qu', 'GLR');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1523, '350103', '̨', 150, 0, 0, 'Taijiang Qu', 'TJQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1524, '350104', 'ɽ', 150, 0, 0, 'Cangshan Qu', 'CSQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1525, '350105', 'β', 150, 0, 0, 'Mawei Qu', 'MWQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1526, '350111', '', 150, 0, 0, 'Jin,an Qu', 'JAF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1527, '350121', '', 150, 0, 0, 'Minhou Qu', 'MHO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1528, '350122', '', 150, 0, 0, 'Lianjiang Xian', 'LJF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1529, '350123', 'Դ', 150, 0, 0, 'Luoyuan Xian', 'LOY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1530, '350124', '', 150, 0, 0, 'Minqing Xian', 'MQG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1531, '350125', '̩', 150, 0, 0, 'Yongtai Xian', 'YTX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1532, '350128', 'ƽ̶', 150, 0, 0, 'Pingtan Xian', 'PTN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1533, '350181', '', 150, 0, 0, 'Fuqing Shi', 'FQS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1535, '350201', 'Ͻ', 151, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1536, '350203', '˼', 151, 0, 0, 'Siming Qu', 'SMQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1537, '350205', '', 151, 0, 0, 'Haicang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1538, '350206', '', 151, 0, 0, 'Huli Qu', 'HLQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1539, '350211', '', 151, 0, 0, 'Jimei Qu', 'JMQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1541, '350213', '谲', 151, 0, 0, 'Xiangan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1542, '350301', 'Ͻ', 152, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1543, '350302', '', 152, 0, 0, 'Chengxiang Qu', 'CXP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1544, '350303', '', 152, 0, 0, 'Hanjiang Qu', 'HJQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1545, '350304', '', 152, 0, 0, 'Licheng Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1546, '350305', '', 152, 0, 0, 'Xiuyu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1549, '350402', '÷', 153, 0, 0, 'Meilie Qu', 'MLQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1550, '350403', 'Ԫ', 153, 0, 0, 'Sanyuan Qu', 'SYB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1548, '350401', 'Ͻ', 153, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1551, '350421', 'Ϫ', 153, 0, 0, 'Mingxi Xian', 'MXI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1553, '350424', '', 153, 0, 0, 'Ninghua Xian', 'NGH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1554, '350425', '', 153, 0, 0, 'Datian Xian', 'DTM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1555, '350426', 'Ϫ', 153, 0, 0, 'Youxi Xian', 'YXF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1557, '350428', '', 153, 0, 0, 'Jiangle Xian', 'JLE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1558, '350429', '̩', 153, 0, 0, 'Taining Xian', 'TNG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1560, '350481', '', 153, 0, 0, 'Yong,an Shi', 'YAF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1561, '350501', 'Ͻ', 154, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1562, '350502', '', 154, 0, 0, 'Licheng Qu', 'LCQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1564, '350504', '彭', 154, 0, 0, 'Luojiang Qu', 'LJQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1565, '350505', 'Ȫ', 154, 0, 0, 'Quangang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1566, '350521', 'ݰ', 154, 0, 0, 'Hui,an Xian', 'HAF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1567, '350524', 'Ϫ', 154, 0, 0, 'Anxi Xian', 'ANX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1569, '350526', '»', 154, 0, 0, 'Dehua Xian', 'DHA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1570, '350527', '', 154, 0, 0, 'Jinmen Xian', 'JME');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1572, '350582', '', 154, 0, 0, 'Jinjiang Shi', 'JJG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1573, '350583', 'ϰ', 154, 0, 0, 'Nan,an Shi', 'NAS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1574, '350601', 'Ͻ', 155, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1576, '350603', '', 155, 0, 0, 'Longwen Qu', 'LWZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1577, '350622', '', 155, 0, 0, 'Yunxiao Xian', 'YXO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1578, '350623', '', 155, 0, 0, 'Zhangpu Xian', 'ZPU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1580, '350625', '̩', 155, 0, 0, 'Changtai Xian', 'CTA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1582, '350627', 'Ͼ', 155, 0, 0, 'Nanjing Xian', 'NJX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1584, '350629', '', 155, 0, 0, 'Hua,an Xian', 'HAN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1586, '350701', 'Ͻ', 156, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1587, '350702', 'ƽ', 156, 0, 0, 'Yanping Qu', 'YPQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1590, '350723', '', 156, 0, 0, 'Guangze Xian', 'GZE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1591, '350724', 'Ϫ', 156, 0, 0, 'Songxi Xian', 'SOX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1592, '350725', '', 156, 0, 0, 'Zhenghe Xian', 'ZGH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1595, '350783', '', 156, 0, 0, 'Jian,ou Shi', 'JOU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1596, '350784', '', 156, 0, 0, 'Jianyang Shi', 'JNY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1599, '350821', '͡', 157, 0, 0, 'Changting Xian', 'CTG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1600, '350822', '', 157, 0, 0, 'Yongding Xian', 'YDI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1603, '350825', '', 157, 0, 0, 'Liancheng Xian', 'LCF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1604, '350881', 'ƽ', 157, 0, 0, 'Zhangping Xian', 'ZGP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1606, '350902', '', 158, 0, 0, 'Jiaocheng Qu', '2');
commit;
prompt 2700 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1608, '350922', '', 158, 0, 0, 'Gutian Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1610, '350924', '', 158, 0, 0, 'Shouning Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1612, '350926', '', 158, 0, 0, 'Zherong Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1614, '350982', '', 158, 0, 0, 'Fuding Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1615, '360101', 'Ͻ', 159, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1616, '360102', '', 159, 0, 0, 'Donghu Qu', 'DHU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1619, '360105', '', 159, 0, 0, 'Wanli Qu', 'WLI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1621, '360121', 'ϲ', 159, 0, 0, 'Nanchang Xian', 'NCA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1623, '360123', '', 159, 0, 0, 'Anyi Xian', 'AYI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1624, '360124', '', 159, 0, 0, 'Jinxian Xian', 'JXX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1626, '360202', '', 160, 0, 0, 'Changjiang Qu', 'CJG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1628, '360222', '', 160, 0, 0, 'Fuliang Xian', 'FLX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1630, '360301', 'Ͻ', 161, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1631, '360302', 'Դ', 161, 0, 0, 'Anyuan Qu', 'AYQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1634, '360322', '', 161, 0, 0, 'Shangli Xian', 'SLI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1635, '360323', '«Ϫ', 161, 0, 0, 'Lixi Xian', 'LXP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1636, '360401', 'Ͻ', 162, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1638, '360403', '', 162, 0, 0, 'Xunyang Qu', 'XYC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1640, '360423', '', 162, 0, 0, 'Wuning Xian', 'WUN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1642, '360425', '', 162, 0, 0, 'Yongxiu Xian', 'YOX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1644, '360427', '', 162, 0, 0, 'Xingzi Xian', 'XZI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1646, '360429', '', 162, 0, 0, 'Hukou Xian', 'HUK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1647, '360430', '', 162, 0, 0, 'Pengze Xian', 'PZE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1189, '320115', '', 109, 0, 0, 'Jiangning Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1190, '320116', '', 109, 0, 0, 'Liuhe Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1191, '320124', 'ˮ', 109, 0, 0, 'Lishui Xian', 'LIS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1192, '320125', 'ߴ', 109, 0, 0, 'Gaochun Xian', 'GCN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1193, '320201', 'Ͻ', 110, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1194, '320202', '簲', 110, 0, 0, 'Chong,an Qu', 'CGA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1195, '320203', 'ϳ', 110, 0, 0, 'Nanchang Qu', 'NCG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1196, '320204', '', 110, 0, 0, 'Beitang Qu', 'BTQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1197, '320205', 'ɽ', 110, 0, 0, 'Xishan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1198, '320206', 'ɽ', 110, 0, 0, 'Huishan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1199, '320211', '', 110, 0, 0, 'Binhu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1200, '320281', '', 110, 0, 0, 'Jiangyin Shi', 'JIA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1201, '320282', '', 110, 0, 0, 'Yixing Shi', 'YIX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1202, '320301', 'Ͻ', 111, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1203, '320302', '¥', 111, 0, 0, 'Gulou Qu', 'GLU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1204, '320303', '', 111, 0, 0, 'Yunlong Qu', 'YLF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1206, '320305', '', 111, 0, 0, 'Jiawang Qu', 'JWQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1207, '320311', 'Ȫɽ', 111, 0, 0, 'Quanshan Qu', 'QSX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1208, '320321', '', 111, 0, 0, 'Feng Xian', 'FXN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1209, '320322', '', 111, 0, 0, 'Pei Xian', 'PEI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1210, '320312', 'ͭɽ', 111, 0, 0, 'Tongshan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1211, '320324', '', 111, 0, 0, 'Suining Xian', 'SNI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1212, '320381', '', 111, 0, 0, 'Xinyi Shi', 'XYW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1213, '320382', '', 111, 0, 0, 'Pizhou Shi', 'PZO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1214, '320401', 'Ͻ', 112, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1215, '320402', '', 112, 0, 0, 'Tianning Qu', 'TNQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1216, '320404', '¥', 112, 0, 0, 'Zhonglou Qu', 'ZLQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1217, '320405', '', 112, 0, 0, 'Qishuyan Qu', 'QSY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1218, '320411', '±', 112, 0, 0, 'Xinbei Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1219, '320412', '', 112, 0, 0, 'Wujin Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1220, '320481', '', 112, 0, 0, 'Liyang Shi', 'LYR');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1221, '320482', '̳', 112, 0, 0, 'Jintan Shi', 'JTS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1222, '320501', 'Ͻ', 113, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1223, '320502', '', 113, 0, 0, 'Canglang Qu', 'CLQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1224, '320503', 'ƽ', 113, 0, 0, 'Pingjiang Qu', 'PJQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1225, '320504', '', 113, 0, 0, 'Jinchang Qu', 'JCA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1226, '320505', '', 113, 0, 0, 'Huqiu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1227, '320506', '', 113, 0, 0, 'Wuzhong Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1228, '320507', '', 113, 0, 0, 'Xiangcheng Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1229, '320581', '', 113, 0, 0, 'Changshu Shi', 'CGS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1230, '320582', 'żҸ', 113, 0, 0, 'Zhangjiagang Shi ', 'ZJG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1231, '320583', 'ɽ', 113, 0, 0, 'Kunshan Shi', 'KUS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1232, '320584', '⽭', 113, 0, 0, 'Wujiang Shi', 'WUJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1233, '320585', '̫', 113, 0, 0, 'Taicang Shi', 'TAC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1234, '320601', 'Ͻ', 114, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1235, '320602', '紨', 114, 0, 0, 'Chongchuan Qu', 'CCQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1236, '320611', 'բ', 114, 0, 0, 'Gangzha Qu', 'GZQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1237, '320621', '', 114, 0, 0, 'Hai,an Xian', 'HIA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1238, '320623', '綫', 114, 0, 0, 'Rudong Xian', 'RDG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1239, '320681', '', 114, 0, 0, 'Qidong Shi', 'QID');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1240, '320682', '', 114, 0, 0, 'Rugao Shi', 'RGO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1241, '320612', 'ͨ', 114, 0, 0, 'Tongzhou Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1242, '320684', '', 114, 0, 0, 'Haimen Shi', 'HME');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1243, '320701', 'Ͻ', 115, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1244, '320703', '', 115, 0, 0, 'Lianyun Qu', 'LYB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1245, '320705', '', 115, 0, 0, 'Xinpu Qu', 'XPQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1246, '320706', '', 115, 0, 0, 'Haizhou Qu', 'HIZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1247, '320721', '', 115, 0, 0, 'Ganyu Xian', 'GYU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1248, '320722', '', 115, 0, 0, 'Donghai Xian', 'DHX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1249, '320723', '', 115, 0, 0, 'Guanyun Xian', 'GYS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1250, '320724', '', 115, 0, 0, 'Guannan Xian', 'GUN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1251, '320801', 'Ͻ', 116, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1252, '320802', '', 116, 0, 0, 'Qinghe Qu', 'QHH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1253, '320803', '', 116, 0, 0, 'Chuzhou Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1254, '320804', '', 116, 0, 0, 'Huaiyin Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1255, '320811', '', 116, 0, 0, 'Qingpu Qu', 'QPQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1256, '320826', 'ˮ', 116, 0, 0, 'Lianshui Xian', 'LSI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1257, '320829', '', 116, 0, 0, 'Hongze Xian', 'HGZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1258, '320830', '', 116, 0, 0, 'Xuyi Xian', 'XUY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1259, '320831', '', 116, 0, 0, 'Jinhu Xian', 'JHU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1260, '320901', 'Ͻ', 117, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1261, '320902', 'ͤ', 117, 0, 0, 'Tinghu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1262, '320903', 'ζ', 117, 0, 0, 'Yandu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1263, '320921', 'ˮ', 117, 0, 0, 'Xiangshui Xian', 'XSH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1264, '320922', '', 117, 0, 0, 'Binhai Xian', 'BHI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1265, '320923', '', 117, 0, 0, 'Funing Xian', 'FNG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1266, '320924', '', 117, 0, 0, 'Sheyang Xian', 'SEY');
commit;
prompt 2800 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1267, '320925', '', 117, 0, 0, 'Jianhu Xian', 'JIH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1268, '320981', '̨', 117, 0, 0, 'Dongtai Shi', 'DTS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1269, '320982', '', 117, 0, 0, 'Dafeng Shi', 'DFS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1270, '321001', 'Ͻ', 118, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1271, '321002', '', 118, 0, 0, 'Guangling Qu', 'GGL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1272, '321003', '', 118, 0, 0, 'Hanjiang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1273, '321011', 'ά', 118, 0, 0, 'Weiyang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1274, '321023', 'Ӧ', 118, 0, 0, 'Baoying Xian ', 'BYI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1275, '321081', '', 118, 0, 0, 'Yizheng Shi', 'YZE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1276, '321084', '', 118, 0, 0, 'Gaoyou Shi', 'GYO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1277, '321088', '', 118, 0, 0, 'Jiangdu Shi', 'JDU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1278, '321101', 'Ͻ', 119, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1279, '321102', '', 119, 0, 0, 'Jingkou Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1280, '321111', '', 119, 0, 0, 'Runzhou Qu', 'RZQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1281, '321112', 'ͽ', 119, 0, 0, 'Dantu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1282, '321181', '', 119, 0, 0, 'Danyang Xian', 'DNY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1283, '321182', '', 119, 0, 0, 'Yangzhong Shi', 'YZG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1284, '321183', '', 119, 0, 0, 'Jurong Shi', 'JRG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1285, '321201', 'Ͻ', 120, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1286, '321202', '', 120, 0, 0, 'Hailing Qu', 'HIL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1287, '321203', '߸', 120, 0, 0, 'Gaogang Qu', 'GGQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1288, '321281', '˻', 120, 0, 0, 'Xinghua Shi', 'XHS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1289, '321282', '', 120, 0, 0, 'Jingjiang Shi', 'JGJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1290, '321283', '̩', 120, 0, 0, 'Taixing Shi', 'TXG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1291, '321284', '', 120, 0, 0, 'Jiangyan Shi', 'JYS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1292, '321301', 'Ͻ', 121, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1293, '321302', '޳', 121, 0, 0, 'Sucheng Qu', 'SCE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1294, '321311', 'ԥ', 121, 0, 0, 'Suyu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1295, '321322', '', 121, 0, 0, 'Shuyang Xian', 'SYD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1296, '321323', '', 121, 0, 0, 'Siyang Xian ', 'SIY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1298, '330101', 'Ͻ', 122, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1299, '330102', 'ϳ', 122, 0, 0, 'Shangcheng Qu', 'SCQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1300, '330103', '³', 122, 0, 0, 'Xiacheng Qu', 'XCG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1302, '330105', '', 122, 0, 0, 'Gongshu Qu', 'GSQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1303, '330106', '', 122, 0, 0, 'Xihu Qu ', 'XHU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1304, '330108', '', 122, 0, 0, 'Binjiang Qu', 'BJQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1306, '330110', 'ຼ', 122, 0, 0, 'Yuhang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1307, '330122', 'ͩ®', 122, 0, 0, 'Tonglu Xian', 'TLU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1308, '330127', '', 122, 0, 0, 'Chun,an Xian', 'CAZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1310, '330183', '', 122, 0, 0, 'Fuyang Shi', 'FYZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1311, '330185', 'ٰ', 122, 0, 0, 'Lin,an Shi', 'LNA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1312, '330201', 'Ͻ', 123, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1314, '330204', '', 123, 0, 0, 'Jiangdong Qu', 'JDO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1315, '330205', '', 123, 0, 0, 'Jiangbei Qu', 'JBQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1318, '330212', '۴', 123, 0, 0, 'Yinzhou Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1319, '330225', 'ɽ', 123, 0, 0, 'Xiangshan Xian', 'YSZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1320, '330226', '', 123, 0, 0, 'Ninghai Xian', 'NHI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1323, '330283', '', 123, 0, 0, 'Fenghua Shi', 'FHU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1324, '330301', 'Ͻ', 124, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1326, '330303', '', 124, 0, 0, 'Longwan Qu', 'LWW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1327, '330304', '걺', 124, 0, 0, 'Ouhai Qu', 'OHQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1330, '330326', 'ƽ', 124, 0, 0, 'Pingyang Xian', 'PYG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1331, '330327', '', 124, 0, 0, 'Cangnan Xian', 'CAN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1334, '330381', '', 124, 0, 0, 'Rui,an Xian', 'RAS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1335, '330382', '', 124, 0, 0, 'Yueqing Shi', 'YQZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1336, '330401', 'Ͻ', 125, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1338, '330411', '', 125, 0, 0, 'Xiuzhou Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1340, '330424', '', 125, 0, 0, 'Haiyan Xian', 'HYN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1342, '330482', 'ƽ', 125, 0, 0, 'Pinghu Shi', 'PHU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1343, '330483', 'ͩ', 125, 0, 0, 'Tongxiang Shi', 'TXZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1344, '330501', 'Ͻ', 126, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1346, '330503', '', 126, 0, 0, 'Nanxun Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1348, '330522', '', 126, 0, 0, 'Changxing Xian', 'CXG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1350, '330601', 'Ͻ', 127, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1351, '330602', 'Խ', 127, 0, 0, 'Yuecheng Qu', 'YSX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1354, '330681', '', 127, 0, 0, 'Zhuji Shi', 'ZHJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1355, '330682', '', 127, 0, 0, 'Shangyu Shi', 'SYZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1358, '330702', 'ĳ', 128, 0, 0, 'Wucheng Qu', 'WCF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1359, '330703', '', 128, 0, 0, 'Jindong Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1360, '330723', '', 128, 0, 0, 'Wuyi Xian', 'WYX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1362, '330727', 'Ͱ', 128, 0, 0, 'Pan,an Xian', 'PAX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1364, '330782', '', 128, 0, 0, 'Yiwu Shi', 'YWS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1366, '330784', '', 128, 0, 0, 'Yongkang Shi', 'YKG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1367, '330801', 'Ͻ', 129, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1368, '330802', '³', 129, 0, 0, 'Kecheng Qu', 'KEC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1371, '330824', '', 129, 0, 0, 'Kaihua Xian', 'KHU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1372, '330825', '', 129, 0, 0, 'Longyou Xian ', 'LGY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1374, '330901', 'Ͻ', 130, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1376, '330903', '', 130, 0, 0, 'Putuo Qu', 'PTO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1378, '330922', '', 130, 0, 0, 'Shengsi Xian', 'SSZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1379, '331001', 'Ͻ', 131, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1380, '331002', '', 131, 0, 0, 'Jiaojiang Qu', 'JJT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1383, '331021', '', 131, 0, 0, 'Yuhuan Xian', 'YHN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1384, '331022', '', 131, 0, 0, 'Sanmen Xian', 'SMN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1386, '331024', 'ɾ', 131, 0, 0, 'Xianju Xian', 'XJU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1388, '331082', 'ٺ', 131, 0, 0, 'Linhai Shi', 'LHI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1390, '331102', '', 132, 0, 0, 'Liandu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1391, '331121', '', 132, 0, 0, 'Qingtian Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1394, '331124', '', 132, 0, 0, 'Songyang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1395, '331125', 'ƺ', 132, 0, 0, 'Yunhe Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1398, '331181', 'Ȫ', 132, 0, 0, 'Longquan Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1399, '340101', 'Ͻ', 133, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1400, '340102', '', 133, 0, 0, 'Yaohai Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1401, '340103', '®', 133, 0, 0, 'Luyang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1402, '340104', 'ɽ', 133, 0, 0, 'Shushan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1404, '340121', '', 133, 0, 0, 'Changfeng Xian', 'CFG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1406, '340123', '', 133, 0, 0, 'Feixi Xian', 'FIX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1408, '340202', '', 1412, 0, 0, 'Jinghu Qu', 'JHW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1409, '340208', 'ɽ', 1412, 0, 0, 'Matang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1412, '340200', 'ߺ', 134, 0, 0, 'Wuhu Shi', 'WHI');
commit;
prompt 2900 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1413, '340222', '', 1412, 0, 0, 'Fanchang Xian', 'FCH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1415, '340301', 'Ͻ', 135, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1416, '340302', 'Ӻ', 135, 0, 0, 'Longzihu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1417, '340303', 'ɽ', 135, 0, 0, 'Bangshan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1418, '340304', '', 135, 0, 0, 'Yuhui Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1419, '340311', '', 135, 0, 0, 'Huaishang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1420, '340321', 'Զ', 135, 0, 0, 'Huaiyuan Qu', 'HYW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1421, '340322', '', 135, 0, 0, 'Wuhe Xian', 'WHE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1422, '340323', '', 135, 0, 0, 'Guzhen Xian', 'GZX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1423, '340401', 'Ͻ', 136, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (71, '210100', '', 7, 0, 0, 'Shenyang Shi', 'SHE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (72, '210200', '', 7, 0, 0, 'Dalian Shi', 'DLC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (73, '210300', 'ɽ', 7, 0, 0, 'AnShan Shi', 'ASN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (74, '210400', '˳', 7, 0, 0, 'Fushun Shi', 'FSN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (75, '210500', 'Ϫ', 7, 0, 0, 'Benxi Shi', 'BXS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (76, '210600', '', 7, 0, 0, 'Dandong Shi', 'DDG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (77, '210700', '', 7, 0, 0, 'Jinzhou Shi', 'JNZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (78, '210800', 'Ӫ', 7, 0, 0, 'Yingkou Shi', 'YIK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (79, '210900', '', 7, 0, 0, 'Fuxin Shi', 'FXS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (80, '211000', '', 7, 0, 0, 'Liaoyang Shi', 'LYL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (81, '211100', '̽', 7, 0, 0, 'Panjin Shi', 'PJS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (82, '211200', '', 7, 0, 0, 'Tieling Shi', 'TLS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (83, '211300', '', 7, 0, 0, 'Chaoyang Shi', 'CYS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (84, '211400', '«', 7, 0, 0, 'Huludao Shi', 'HLD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (85, '220100', '', 8, 0, 0, 'Changchun Shi ', 'CGQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (86, '220200', '', 8, 0, 0, 'Jilin Shi ', 'JLS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (87, '220300', 'ƽ', 8, 0, 0, 'Siping Shi', 'SPS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (88, '220400', 'Դ', 8, 0, 0, 'Liaoyuan Shi', 'LYH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (89, '220500', 'ͨ', 8, 0, 0, 'Tonghua Shi', 'THS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (90, '220600', 'ɽ', 8, 0, 0, 'Baishan Shi', 'BSN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (91, '220700', 'ԭ', 8, 0, 0, 'Songyuan Shi', 'SYU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (92, '220800', '׳', 8, 0, 0, 'Baicheng Shi', 'BCS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (93, '222400', 'ӱ߳', 8, 0, 0, 'Yanbian Chosenzu Zizhizhou', 'YBZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (94, '230100', '', 9, 0, 0, 'Harbin Shi', 'HRB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (95, '230200', '', 9, 0, 0, 'Qiqihar Shi', 'NDG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (96, '230300', '', 9, 0, 0, 'Jixi Shi', 'JXI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (97, '230400', '׸', 9, 0, 0, 'Hegang Shi', 'HEG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (98, '230500', '˫Ѽɽ', 9, 0, 0, 'Shuangyashan Shi', 'SYS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (99, '230600', '', 9, 0, 0, 'Daqing Shi', 'DQG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (100, '230700', '', 9, 0, 0, 'Yichun Shi', 'YCH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (101, '230800', 'ľ˹', 9, 0, 0, 'Jiamusi Shi', 'JMU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (102, '230900', '̨', 9, 0, 0, 'Qitaihe Shi', 'QTH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (103, '231000', 'ĵ', 9, 0, 0, 'Mudanjiang Shi', 'MDG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (104, '231100', 'ں', 9, 0, 0, 'Heihe Shi', 'HEK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (105, '231200', '绯', 9, 0, 0, 'Suihua Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (106, '232700', '˰', 9, 0, 0, 'Da Hinggan Ling Diqu', 'DHL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (107, '310100', 'Ͻ', 10, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (108, '310200', '', 10, 0, 0, 'Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (110, '320200', '', 11, 0, 0, 'Wuxi Shi', 'WUX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (111, '320300', '', 11, 0, 0, 'Xuzhou Shi', 'XUZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (113, '320500', '', 11, 0, 0, 'Suzhou Shi', 'SZH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (114, '320600', 'ͨ', 11, 0, 0, 'Nantong Shi', 'NTG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (115, '320700', 'Ƹ', 11, 0, 0, 'Lianyungang Shi', 'LYG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (117, '320900', 'γ', 11, 0, 0, 'Yancheng Shi', 'YCK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (118, '321000', '', 11, 0, 0, 'Yangzhou Shi', 'YZH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (119, '321100', '', 11, 0, 0, 'Zhenjiang Shi', 'ZHE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (121, '321300', 'Ǩ', 11, 0, 0, 'Suqian Shi', 'SUQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (122, '330100', '', 12, 0, 0, 'Hangzhou Shi', 'HGH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1, 'й', 'й', 0, 0, 0, 'Zhong Guo', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2, '110000', '', 1, 0, 0, 'Beijing Shi', 'BJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3, '120000', '', 1, 0, 0, 'Tianjin Shi', 'TJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (4, '130000', 'ӱʡ', 1, 0, 0, 'Hebei Sheng', 'HE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (5, '140000', 'ɽʡ', 1, 0, 0, 'Shanxi Sheng ', 'SX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (6, '150000', 'ɹ', 1, 0, 0, 'Nei Mongol Zizhiqu', 'NM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (8, '220000', 'ʡ', 1, 0, 0, 'Jilin Sheng', 'JL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (9, '230000', 'ʡ', 1, 0, 0, 'Heilongjiang Sheng', 'HL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (10, '310000', 'Ϻ', 1, 0, 0, 'Shanghai Shi', 'SH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (12, '330000', '㽭ʡ', 1, 0, 0, 'Zhejiang Sheng', 'ZJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (13, '340000', 'ʡ', 1, 0, 0, 'Anhui Sheng', 'AH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (14, '350000', 'ʡ', 1, 0, 0, 'Fujian Sheng ', 'FJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (16, '370000', 'ɽʡ', 1, 0, 0, 'Shandong Sheng ', 'SD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (17, '410000', 'ʡ', 1, 0, 0, 'Henan Sheng', 'HA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (18, '420000', 'ʡ', 1, 0, 0, 'Hubei Sheng', 'HB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (20, '440000', '㶫ʡ', 1, 0, 0, 'Guangdong Sheng', 'GD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (251, '445200', '', 20, 0, 0, 'Jieyang Shi', 'JIY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (252, '445300', 'Ƹ', 20, 0, 0, 'Yunfu Shi', 'YFS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (253, '450100', '', 21, 0, 0, 'Nanning Shi', 'NNG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (254, '450200', '', 21, 0, 0, 'Liuzhou Shi', 'LZH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (255, '450300', '', 21, 0, 0, 'Guilin Shi', 'KWL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (256, '450400', '', 21, 0, 0, 'Wuzhou Shi', 'WUZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (257, '450500', '', 21, 0, 0, 'Beihai Shi', 'BHY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (258, '450600', 'Ǹ', 21, 0, 0, 'Fangchenggang Shi', 'FAN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (259, '450700', '', 21, 0, 0, 'Qinzhou Shi', 'QZH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (260, '450800', '', 21, 0, 0, 'Guigang Shi', 'GUG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (261, '450900', '', 21, 0, 0, 'Yulin Shi', 'YUL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (262, '451000', 'ɫ', 21, 0, 0, 'Baise Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (263, '451100', '', 21, 0, 0, 'Hezhou Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (264, '451200', 'ӳ', 21, 0, 0, 'Hechi Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (265, '451300', '', 21, 0, 0, 'Laibin Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (266, '451400', '', 21, 0, 0, 'Chongzuo Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (267, '460100', '', 22, 0, 0, 'Haikou Shi', 'HAK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (268, '460200', '', 22, 0, 0, 'Sanya Shi', 'SYX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (269, '469000', 'ʡֱϽؼ', 22, 0, 0, 'shengzhixiaxianjixingzhengquhua', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (270, '500100', 'Ͻ', 23, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (271, '500200', '', 23, 0, 0, 'Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (273, '510100', 'ɶ', 24, 0, 0, 'Chengdu Shi', 'CTU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (274, '510300', 'Թ', 24, 0, 0, 'Zigong Shi', 'ZGS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (276, '510500', '', 24, 0, 0, 'Luzhou Shi', 'LUZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (278, '510700', '', 24, 0, 0, 'Mianyang Shi', 'MYG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (279, '510800', 'Ԫ', 24, 0, 0, 'Guangyuan Shi', 'GYC');
commit;
prompt 3000 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (281, '511000', 'ڽ', 24, 0, 0, 'Neijiang Shi', 'NJS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (282, '511100', 'ɽ', 24, 0, 0, 'Leshan Shi', 'LES');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (285, '511500', '˱', 24, 0, 0, 'Yibin Shi', 'YBS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (286, '511600', '㰲', 24, 0, 0, 'Guang,an Shi', 'GAC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (287, '511700', '', 24, 0, 0, 'Dazhou Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (288, '511800', 'Ű', 24, 0, 0, 'Ya,an Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (21, '450000', '׳', 1, 0, 0, 'Guangxi Zhuangzu Zizhiqu', 'GX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (24, '510000', 'Ĵʡ', 1, 0, 0, 'Sichuan Sheng', 'SC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (26, '530000', 'ʡ', 1, 0, 0, 'Yunnan Sheng', 'YN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (27, '540000', '', 1, 0, 0, 'Xizang Zizhiqu', 'XZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (29, '620000', 'ʡ', 1, 0, 0, 'Gansu Sheng', 'GS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (31, '640000', 'Ļ', 1, 0, 0, 'Ningxia Huizu Zizhiqu', 'NX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (32, '650000', '½ά', 1, 0, 0, 'Xinjiang Uygur Zizhiqu', 'XJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (33, '110100', 'Ͻ', 2, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (34, '110200', '', 2, 0, 0, 'Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (35, '120100', 'Ͻ', 3, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (36, '120200', '', 3, 0, 0, 'Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (38, '130200', 'ɽ', 4, 0, 0, 'Tangshan Shi', 'TGS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (39, '130300', 'ػʵ', 4, 0, 0, 'Qinhuangdao Shi', 'SHP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (40, '130400', '', 4, 0, 0, 'Handan Shi', 'HDS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (42, '130600', '', 4, 0, 0, 'Baoding Shi', 'BDS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (43, '130700', 'żҿ', 4, 0, 0, 'Zhangjiakou Shi ', 'ZJK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (45, '130900', '', 4, 0, 0, 'Cangzhou Shi', 'CGZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (46, '131000', 'ȷ', 4, 0, 0, 'Langfang Shi', 'LFS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (48, '140100', '̫ԭ', 5, 0, 0, 'Taiyuan Shi', 'TYN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (49, '140200', 'ͬ', 5, 0, 0, 'Datong Shi ', 'DTG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (51, '140400', '', 5, 0, 0, 'Changzhi Shi', 'CZS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (52, '140500', '', 5, 0, 0, 'Jincheng Shi ', 'JCG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (54, '140700', '', 5, 0, 0, 'Jinzhong Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (55, '140800', '˳', 5, 0, 0, 'Yuncheng Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (56, '140900', '', 5, 0, 0, 'Xinzhou Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (58, '141100', '', 5, 0, 0, 'Lvliang Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (59, '150100', 'ͺ', 6, 0, 0, 'Hohhot Shi', 'Hhht');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (60, '150200', 'ͷ', 6, 0, 0, 'Baotou Shi ', 'BTS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (62, '150400', '', 6, 0, 0, 'Chifeng (Ulanhad)Shi', 'CFS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (64, '150600', '˹', 6, 0, 0, 'Eerduosi Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (65, '150700', 'ױ', 6, 0, 0, 'Hulunbeier Shi ', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (66, '150800', '׶', 6, 0, 0, 'Bayannaoer Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (67, '150900', '첼', 6, 0, 0, 'Wulanchabu Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (68, '152200', '˰', 6, 0, 0, 'Hinggan Meng', 'HIN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (69, '152500', 'ֹ', 6, 0, 0, 'Xilin Gol Meng', 'XGO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (124, '330300', '', 12, 0, 0, 'Wenzhou Shi', 'WNZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (125, '330400', '', 12, 0, 0, 'Jiaxing Shi', 'JIX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (126, '330500', '', 12, 0, 0, 'Huzhou Shi ', 'HZH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (129, '330800', '', 12, 0, 0, 'Quzhou Shi', 'QUZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (130, '330900', 'ɽ', 12, 0, 0, 'Zhoushan Shi', 'ZOS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (133, '340100', 'Ϸ', 13, 0, 0, 'Hefei Shi', 'HFE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (134, '340200', 'ߺ', 13, 0, 0, 'Wuhu Shi', 'WHI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (136, '340400', '', 13, 0, 0, 'Huainan Shi', 'HNS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (139, '340700', 'ͭ', 13, 0, 0, 'Tongling Shi', 'TOL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (140, '340800', '', 13, 0, 0, 'Anqing Shi', 'AQG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (143, '341200', '', 13, 0, 0, 'Fuyang Shi', 'FYS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (144, '341300', '', 13, 0, 0, 'Suzhou Shi', 'SUZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (145, '341400', '', 13, 0, 0, 'Chaohu Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (149, '341800', '', 13, 0, 0, 'Xuancheng Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (151, '350200', '', 14, 0, 0, 'Xiamen Shi', 'XMN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (152, '350300', '', 14, 0, 0, 'Putian Shi', 'PUT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (155, '350600', '', 14, 0, 0, 'Zhangzhou Shi', 'ZZU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (156, '350700', 'ƽ', 14, 0, 0, 'Nanping Shi', 'NPS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (159, '360100', 'ϲ', 15, 0, 0, 'Nanchang Shi', 'KHN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (160, '360200', '', 15, 0, 0, 'Jingdezhen Shi', 'JDZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (163, '360500', '', 15, 0, 0, 'Xinyu Shi', 'XYU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (165, '360700', '', 15, 0, 0, 'Ganzhou Shi', 'GZH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (166, '360800', '', 15, 0, 0, 'Ji,an Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (169, '361100', '', 15, 0, 0, 'Shangrao Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (170, '370100', '', 16, 0, 0, 'Jinan Shi', 'TNA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (173, '370400', 'ׯ', 16, 0, 0, 'Zaozhuang Shi', 'ZZG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (174, '370500', 'Ӫ', 16, 0, 0, 'Dongying Shi', 'DYG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (177, '370800', '', 16, 0, 0, 'Jining Shi', 'JNG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (178, '370900', '̩', 16, 0, 0, 'Tai,an Shi', 'TAI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (179, '371000', '', 16, 0, 0, 'Weihai Shi', 'WEH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (182, '371300', '', 16, 0, 0, 'Linyi Shi', 'LYI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (184, '371500', 'ĳ', 16, 0, 0, 'Liaocheng Shi', 'LCH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (188, '410200', '', 17, 0, 0, 'Kaifeng Shi', 'KFS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (189, '410300', '', 17, 0, 0, 'Luoyang Shi', 'LYA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (192, '410600', 'ױ', 17, 0, 0, 'Hebi Shi', 'HBS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (193, '410700', '', 17, 0, 0, 'Xinxiang Shi', 'XXS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (195, '410900', '', 17, 0, 0, 'Puyang Shi', 'PYS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (197, '411100', '', 17, 0, 0, 'Luohe Shi', 'LHS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (199, '411300', '', 17, 0, 0, 'Nanyang Shi', 'NYS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (200, '411400', '', 17, 0, 0, 'Shangqiu Shi', 'SQS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (203, '411700', 'פ', 17, 0, 0, 'Zhumadian Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (204, '420100', '人', 18, 0, 0, 'Wuhan Shi', 'WUH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3213, '610723', '', 332, 0, 0, 'Yang Xian', 'YGX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (207, '420500', '˲', 18, 0, 0, 'Yichang Shi', 'YCO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (208, '420600', '差', 18, 0, 0, 'Xiangfan Shi', 'XFN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (209, '420700', '', 18, 0, 0, 'Ezhou Shi', 'EZS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (211, '420900', 'Т', 18, 0, 0, 'Xiaogan Shi', 'XGE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (212, '421000', '', 18, 0, 0, 'Jingzhou Shi', 'JGZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (214, '421200', '', 18, 0, 0, 'Xianning Xian', 'XNS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (215, '421300', '', 18, 0, 0, 'Suizhou Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (217, '429000', 'ʡֱϽؼ', 18, 0, 0, 'shengzhixiaxianjixingzhengquhua', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (218, '430100', 'ɳ', 19, 0, 0, 'Changsha Shi', 'CSX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (219, '430200', '', 19, 0, 0, 'Zhuzhou Shi', 'ZZS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (220, '430300', '̶', 19, 0, 0, 'Xiangtan Shi', 'XGT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (222, '430500', '', 19, 0, 0, 'Shaoyang Shi', 'SYR');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (223, '430600', '', 19, 0, 0, 'Yueyang Shi', 'YYG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (225, '430800', 'żҽ', 19, 0, 0, 'Zhangjiajie Shi', 'ZJJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (226, '430900', '', 19, 0, 0, 'Yiyang Shi', 'YYS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (227, '431000', '', 19, 0, 0, 'Chenzhou Shi', 'CNZ');
commit;
prompt 3100 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (229, '431200', '', 19, 0, 0, 'Huaihua Shi', 'HHS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (230, '431300', '¦', 19, 0, 0, 'Loudi Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (232, '440100', '', 20, 0, 0, 'Guangzhou Shi', 'CAN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (233, '440200', 'ع', 20, 0, 0, 'Shaoguan Shi', 'HSC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (234, '440300', '', 20, 0, 0, 'Shenzhen Shi', 'SZX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (235, '440400', '麣', 20, 0, 0, 'Zhuhai Shi', 'ZUH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (237, '440600', 'ɽ', 20, 0, 0, 'Foshan Shi', 'FOS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (238, '440700', '', 20, 0, 0, 'Jiangmen Shi', 'JMN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (239, '440800', 'տ', 20, 0, 0, 'Zhanjiang Shi', 'ZHA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (241, '441200', '', 20, 0, 0, 'Zhaoqing Shi', 'ZQG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (242, '441300', '', 20, 0, 0, 'Huizhou Shi', 'HUI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (243, '441400', '÷', 20, 0, 0, 'Meizhou Shi', 'MXZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (245, '441600', 'Դ', 20, 0, 0, 'Heyuan Shi', 'HEY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (246, '441700', '', 20, 0, 0, 'Yangjiang Shi', 'YJI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (247, '441800', 'Զ', 20, 0, 0, 'Qingyuan Shi', 'QYN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (249, '442000', 'ɽ', 20, 0, 0, 'Zhongshan Shi', 'ZSN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (250, '445100', '', 20, 0, 0, 'Chaozhou Shi', 'CZY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (290, '512000', '', 24, 0, 0, 'Ziyang Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (291, '513200', 'ӲǼ', 24, 0, 0, 'Aba(Ngawa) Zangzu Qiangzu Zizhizhou', 'ABA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (292, '513300', 'β', 24, 0, 0, 'Garze Zangzu Zizhizhou', 'GAZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (293, '513400', 'ɽ', 24, 0, 0, 'Liangshan Yizu Zizhizhou', 'LSY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (294, '520100', '', 25, 0, 0, 'Guiyang Shi', 'KWE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (295, '520200', 'ˮ', 25, 0, 0, 'Liupanshui Shi', 'LPS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (296, '520300', '', 25, 0, 0, 'Zunyi Shi', 'ZNY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (297, '520400', '˳', 25, 0, 0, 'Anshun Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (298, '522200', 'ͭʵ', 25, 0, 0, 'Tongren Diqu', 'TRD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (299, '522300', 'ǭϲ', 25, 0, 0, 'Qianxinan Buyeizu Zizhizhou', 'QXZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (300, '522400', 'Ͻڵ', 25, 0, 0, 'Bijie Diqu', 'BJD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (302, '522700', 'ǭϲ', 25, 0, 0, 'Qiannan Buyeizu Miaozu Zizhizhou', 'QNZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (303, '530100', '', 26, 0, 0, 'Kunming Shi', 'KMG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (304, '530300', '', 26, 0, 0, 'Qujing Shi', 'QJS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (305, '530400', 'Ϫ', 26, 0, 0, 'Yuxi Shi', 'YXS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (306, '530500', 'ɽ', 26, 0, 0, 'Baoshan Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (307, '530600', 'ͨ', 26, 0, 0, 'Zhaotong Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (308, '530700', '', 26, 0, 0, 'Lijiang Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (309, '530800', 'ն', 26, 0, 0, 'Simao Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (310, '530900', 'ٲ', 26, 0, 0, 'Lincang Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (311, '532300', '', 26, 0, 0, 'Chuxiong Yizu Zizhizhou', 'CXD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (312, '532500', 'ӹ', 26, 0, 0, 'Honghe Hanizu Yizu Zizhizhou', 'HHZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (313, '532600', 'ɽ׳', 26, 0, 0, 'Wenshan Zhuangzu Miaozu Zizhizhou', 'WSZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (314, '532800', '˫ɴ', 26, 0, 0, 'Xishuangbanna Daizu Zizhizhou', 'XSB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (315, '532900', '', 26, 0, 0, 'Dali Baizu Zizhizhou', 'DLZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (316, '533100', 'º徰', 26, 0, 0, 'Dehong Daizu Jingpozu Zizhizhou', 'DHG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (317, '533300', 'ŭ', 26, 0, 0, 'Nujiang Lisuzu Zizhizhou', 'NUJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (318, '533400', '', 26, 0, 0, 'Deqen Zangzu Zizhizhou', 'DEZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (319, '540100', '', 27, 0, 0, 'Lhasa Shi', 'LXA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (320, '542100', '', 27, 0, 0, 'Qamdo Diqu', 'QAD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (321, '542200', 'ɽϵ', 27, 0, 0, 'Shannan Diqu', 'SND');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (322, '542300', 'տ', 27, 0, 0, 'Xigaze Diqu', 'XID');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (324, '542500', '', 27, 0, 0, 'Ngari Diqu', 'NGD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (325, '542600', '֥', 27, 0, 0, 'Nyingchi Diqu', 'NYD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (326, '610100', '', 28, 0, 0, 'Xi,an Shi', 'SIA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (327, '610200', 'ͭ', 28, 0, 0, 'Tongchuan Shi', 'TCN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (328, '610300', '', 28, 0, 0, 'Baoji Shi', 'BJI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (329, '610400', '', 28, 0, 0, 'Xianyang Shi', 'XYS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (330, '610500', 'μ', 28, 0, 0, 'Weinan Shi', 'WNA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (331, '610600', 'Ӱ', 28, 0, 0, 'Yan,an Shi', 'YNA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (332, '610700', '', 28, 0, 0, 'Hanzhong Shi', 'HZJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (333, '610800', '', 28, 0, 0, 'Yulin Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (334, '610900', '', 28, 0, 0, 'Ankang Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (335, '611000', '', 28, 0, 0, 'Shangluo Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (336, '620100', '', 29, 0, 0, 'Lanzhou Shi', 'LHW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (337, '620200', '', 29, 0, 0, 'Jiayuguan Shi', 'JYG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (338, '620300', '', 29, 0, 0, 'Jinchang Shi', 'JCS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (339, '620400', '', 29, 0, 0, 'Baiyin Shi', 'BYS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (340, '620500', 'ˮ', 29, 0, 0, 'Tianshui Shi', 'TSU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (341, '620600', '', 29, 0, 0, 'Wuwei Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (342, '620700', 'Ҵ', 29, 0, 0, 'Zhangye Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (343, '620800', 'ƽ', 29, 0, 0, 'Pingliang Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (344, '620900', 'Ȫ', 29, 0, 0, 'Jiuquan Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (345, '621000', '', 29, 0, 0, 'Qingyang Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (346, '621100', '', 29, 0, 0, 'Dingxi Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (347, '621200', '¤', 29, 0, 0, 'Longnan Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (348, '622900', 'Ļ', 29, 0, 0, 'Linxia Huizu Zizhizhou ', 'LXH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (349, '623000', 'ϲ', 29, 0, 0, 'Gannan Zangzu Zizhizhou', 'GNZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (350, '630100', '', 30, 0, 0, 'Xining Shi', 'XNN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (351, '632100', '', 30, 0, 0, 'Haidong Diqu', 'HDD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (352, '632200', '', 30, 0, 0, 'Haibei Zangzu Zizhizhou', 'HBZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (353, '632300', 'ϲ', 30, 0, 0, 'Huangnan Zangzu Zizhizhou', 'HNZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (354, '632500', 'ϲ', 30, 0, 0, 'Hainan Zangzu Zizhizhou', 'HNN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (355, '632600', '', 30, 0, 0, 'Golog Zangzu Zizhizhou', 'GOL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (356, '632700', '', 30, 0, 0, 'Yushu Zangzu Zizhizhou', 'YSZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (357, '632800', 'ɹ', 30, 0, 0, 'Haixi Mongolzu Zangzu Zizhizhou', 'HXZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (358, '640100', '', 31, 0, 0, 'Yinchuan Shi', 'INC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (359, '640200', 'ʯɽ', 31, 0, 0, 'Shizuishan Shi', 'SZS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (360, '640300', '', 31, 0, 0, 'Wuzhong Shi', 'WZS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (361, '640400', 'ԭ', 31, 0, 0, 'Guyuan Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (363, '650100', '³ľ', 32, 0, 0, 'Urumqi Shi', 'URC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (364, '650200', '', 32, 0, 0, 'Karamay Shi', 'KAR');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (365, '652100', '³', 32, 0, 0, 'Turpan Diqu', 'TUD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (366, '652200', 'ܵ', 32, 0, 0, 'Hami(kumul) Diqu', 'HMD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (367, '652300', '', 32, 0, 0, 'Changji Huizu Zizhizhou', 'CJZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (368, '652700', 'ɹ', 32, 0, 0, 'Bortala Monglo Zizhizhou', 'BOR');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (369, '652800', 'ɹ', 32, 0, 0, 'bayinguolengmengguzizhizhou', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (370, '652900', 'յ', 32, 0, 0, 'Aksu Diqu', 'AKD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (371, '653000', 'տ¶', 32, 0, 0, 'Kizilsu Kirgiz Zizhizhou', 'KIZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (372, '653100', 'ʲ', 32, 0, 0, 'Kashi(Kaxgar) Diqu', 'KSI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (373, '653200', '', 32, 0, 0, 'Hotan Diqu', 'HOD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (374, '654000', '', 32, 0, 0, 'Ili Kazak Zizhizhou', 'ILD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (375, '654200', 'ǵ', 32, 0, 0, 'Tacheng(Qoqek) Diqu', 'TCD');
commit;
prompt 3200 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (378, '110101', '', 33, 0, 0, 'Dongcheng Qu', 'DCQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (382, '110105', '', 33, 0, 0, 'Chaoyang Qu', 'CYQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (383, '110106', '̨', 33, 0, 0, 'Fengtai Qu', 'FTQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (385, '110108', '', 33, 0, 0, 'Haidian Qu', 'HDN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (386, '110109', 'ͷ', 33, 0, 0, 'Mentougou Qu', 'MTG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (388, '110112', 'ͨ', 33, 0, 0, 'Tongzhou Qu', 'TZQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (389, '110113', '˳', 33, 0, 0, 'Shunyi Qu', 'SYI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (390, '110114', 'ƽ', 33, 0, 0, 'Changping Qu', 'CP Q');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (392, '110116', '', 33, 0, 0, 'Huairou Qu', 'HR Q');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (393, '110117', 'ƽ', 33, 0, 0, 'Pinggu Qu', 'PG Q');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (395, '110229', '', 34, 0, 0, 'Yanqing Xian', 'YQX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (396, '120101', 'ƽ', 35, 0, 0, 'Heping Qu', 'HPG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (397, '120102', 'Ӷ', 35, 0, 0, 'Hedong Qu', 'HDQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (398, '120103', '', 35, 0, 0, 'Hexi Qu', 'HXQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (399, '120104', 'Ͽ', 35, 0, 0, 'Nankai Qu', 'NKQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (401, '120106', '', 35, 0, 0, 'Hongqiao Qu', 'HQO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (405, '120110', '', 35, 0, 0, 'Dongli Qu', 'DLI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (406, '120111', '', 35, 0, 0, 'Xiqing Qu', 'XQG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (407, '120112', '', 35, 0, 0, 'Jinnan Qu', 'JNQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (409, '120114', '', 35, 0, 0, 'Wuqing Qu', 'WQ Q');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (410, '120115', '', 35, 0, 0, 'Baodi Qu', 'BDI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (412, '120223', '', 36, 0, 0, 'Jinghai Xian', 'JHT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (413, '120225', '', 36, 0, 0, 'Ji Xian', 'JIT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (414, '130101', 'Ͻ', 37, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (415, '130102', '', 37, 0, 0, 'Chang,an Qu', 'CAQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (416, '130103', 'Ŷ', 37, 0, 0, 'Qiaodong Qu', 'QDQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (417, '130104', '', 37, 0, 0, 'Qiaoxi Qu', 'QXQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (418, '130105', '»', 37, 0, 0, 'Xinhua Qu', 'XHK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (419, '130107', '', 37, 0, 0, 'Jingxing Kuangqu', 'JXK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (422, '130123', '', 37, 0, 0, 'Zhengding Xian', 'ZDJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (425, '130126', '', 37, 0, 0, 'Lingshou Xian ', 'LSO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (426, '130127', '', 37, 0, 0, 'Gaoyi Xian', 'GYJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (429, '130130', '޼', 37, 0, 0, 'Wuji Xian', 'WJI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (430, '130131', 'ƽɽ', 37, 0, 0, 'Pingshan Xian', 'PSH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (432, '130133', '', 37, 0, 0, 'Zhao Xian', 'ZAO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (434, '130182', '޻', 37, 0, 0, 'Gaocheng Shi', 'GCS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (436, '130184', '', 37, 0, 0, 'Xinle Shi', 'XLE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (437, '130185', '¹Ȫ', 37, 0, 0, 'Luquan Shi', 'LUQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (438, '130201', 'Ͻ', 38, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (441, '130204', 'ұ', 38, 0, 0, 'Guye Qu', 'GYE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (442, '130205', 'ƽ', 38, 0, 0, 'Kaiping Qu', 'KPQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (444, '130208', '', 38, 0, 0, 'Fengrun Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (445, '130223', '', 38, 0, 0, 'Luan Xian', 'LUA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (448, '130227', 'Ǩ', 38, 0, 0, 'Qianxi Xian', 'QXX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (449, '130229', '', 38, 0, 0, 'Yutian Xian', 'YTJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (452, '130283', 'Ǩ', 38, 0, 0, 'Qian,an Shi', 'QAS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (453, '130301', 'Ͻ', 39, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (454, '130302', '', 39, 0, 0, 'Haigang Qu', 'HGG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (458, '130322', '', 39, 0, 0, 'Changli Xian', 'CGL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (459, '130323', '', 39, 0, 0, 'Funing Xian ', 'FUN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (460, '130324', '¬', 39, 0, 0, 'Lulong Xian', 'LLG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (461, '130401', 'Ͻ', 40, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (463, '130403', '̨', 40, 0, 0, 'Congtai Qu', 'CTQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (465, '130406', '', 40, 0, 0, 'Fengfeng Kuangqu', 'FFK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (468, '130424', 'ɰ', 40, 0, 0, 'Cheng,an Xian', 'CAJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (469, '130425', '', 40, 0, 0, 'Daming Xian', 'DMX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (471, '130427', '', 40, 0, 0, 'Ci Xian', 'CIX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (473, '130429', '', 40, 0, 0, 'Yongnian Xian', 'YON');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (474, '130430', '', 40, 0, 0, 'Qiu Xian', 'QIU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (475, '130431', '', 40, 0, 0, 'Jize Xian', 'JZE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (477, '130433', '', 40, 0, 0, 'Guantao Xian', 'GTO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (478, '130434', 'κ', 40, 0, 0, 'Wei Xian ', 'WEI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (479, '130435', '', 40, 0, 0, 'Quzhou Xian ', 'QZX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (481, '130501', 'Ͻ', 41, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (482, '130502', 'Ŷ', 41, 0, 0, 'Qiaodong Qu', 'QDG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (483, '130503', '', 41, 0, 0, 'Qiaoxi Qu', 'QXT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (485, '130522', 'ٳ', 41, 0, 0, 'Lincheng Xian ', 'LNC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (486, '130523', '', 41, 0, 0, 'Neiqiu Xian ', 'NQU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (487, '130524', '', 41, 0, 0, 'Baixiang Xian', 'BXG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (489, '130526', '', 41, 0, 0, 'Ren Xian', 'REN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (490, '130527', 'Ϻ', 41, 0, 0, 'Nanhe Xian', 'NHX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (491, '130528', '', 41, 0, 0, 'Ningjin Xian', 'NJN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (493, '130530', 'º', 41, 0, 0, 'Xinhe Xian ', 'XHJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (494, '130531', '', 41, 0, 0, 'Guangzong Xian ', 'GZJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (495, '130532', 'ƽ', 41, 0, 0, 'Pingxiang Xian', 'PXX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (497, '130534', '', 41, 0, 0, 'Qinghe Xian', 'QHE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (498, '130535', '', 41, 0, 0, 'Linxi Xian', 'LXI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (500, '130582', 'ɳ', 41, 0, 0, 'Shahe Shi', 'SHS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (501, '130601', 'Ͻ', 42, 0, 0, 'Shixiaqu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (502, '130600', '', 42, 0, 0, 'Xinshi Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (504, '130604', '', 42, 0, 0, 'Nanshi Qu', 'NSB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (505, '130621', '', 42, 0, 0, 'Mancheng Xian ', 'MCE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (277, '510600', '', 24, 0, 0, 'Deyang Shi', 'DEY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (280, '510900', '', 24, 0, 0, 'Suining Shi', 'SNS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (283, '511300', 'ϳ', 24, 0, 0, 'Nanchong Shi', 'NCO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (22, '460000', 'ʡ', 1, 0, 0, 'Hainan Sheng', 'HI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (28, '610000', 'ʡ', 1, 0, 0, 'Shanxi Sheng ', 'SN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (37, '130100', 'ʯׯ', 4, 0, 0, 'Shijiazhuang Shi', 'SJW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (41, '130500', '̨', 4, 0, 0, 'Xingtai Shi', 'XTS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (44, '130800', 'е', 4, 0, 0, 'Chengde Shi', 'CDS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (47, '131100', 'ˮ', 4, 0, 0, 'Hengshui Shi ', 'HGS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (50, '140300', 'Ȫ', 5, 0, 0, 'Yangquan Shi', 'YQS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (53, '140600', '˷', 5, 0, 0, 'Shuozhou Shi ', 'SZJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (57, '141000', 'ٷ', 5, 0, 0, 'Linfen Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (61, '150300', 'ں', 6, 0, 0, 'Wuhai Shi', 'WHM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (63, '150500', 'ͨ', 6, 0, 0, 'Tongliao Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (70, '152900', '', 6, 0, 0, 'Alxa Meng', 'ALM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (128, '330700', '', 12, 0, 0, 'Jinhua Shi', 'JHA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (132, '331100', 'ˮ', 12, 0, 0, 'Lishui Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (137, '340500', 'ɽ', 13, 0, 0, 'Ma,anshan Shi', 'MAA');
commit;
prompt 3300 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (141, '341000', 'ɽ', 13, 0, 0, 'Huangshan Shi', 'HSN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (147, '341600', '', 13, 0, 0, 'Bozhou Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (154, '350500', 'Ȫ', 14, 0, 0, 'Quanzhou Shi', 'QZJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (158, '350900', '', 14, 0, 0, 'Ningde Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (162, '360400', 'Ž', 15, 0, 0, 'Jiujiang Shi', 'JIU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (167, '360900', '˴', 15, 0, 0, 'Yichun Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (171, '370200', 'ൺ', 16, 0, 0, 'Qingdao Shi', 'TAO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (175, '370600', '̨', 16, 0, 0, 'Yantai Shi', 'YNT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (181, '371200', '', 16, 0, 0, 'Laiwu Shi', 'LWS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (185, '371600', '', 16, 0, 0, 'Binzhou Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (190, '410400', 'ƽɽ', 17, 0, 0, 'Pingdingshan Shi', 'PDS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (196, '411000', '', 17, 0, 0, 'Xuchang Shi', 'XCS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (201, '411500', '', 17, 0, 0, 'Xinyang Shi', 'XYG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (205, '420200', 'ʯ', 18, 0, 0, 'Huangshi Shi', 'HIS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (379, '110102', '', 33, 0, 0, 'Xicheng Qu', 'XCQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (384, '110107', 'ʯɽ', 33, 0, 0, 'Shijingshan Qu', 'SJS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (387, '110111', 'ɽ', 33, 0, 0, 'Fangshan Qu', 'FSQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (391, '110115', '', 33, 0, 0, 'Daxing Qu', 'DX Q');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (394, '110228', '', 34, 0, 0, 'Miyun Xian ', 'MYN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (400, '120105', 'ӱ', 35, 0, 0, 'Hebei Qu', 'HBQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (404, '120116', '', 35, 0, 0, 'Dagang Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (408, '120113', '', 35, 0, 0, 'Beichen Qu', 'BCQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (411, '120221', '', 36, 0, 0, 'Ninghe Xian', 'NHE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (421, '130121', '', 37, 0, 0, 'Jingxing Xian', 'JXJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (424, '130125', '', 37, 0, 0, 'Xingtang Xian', 'XTG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (428, '130129', '޻', 37, 0, 0, 'Zanhuang Xian', 'ZHG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (433, '130181', '', 37, 0, 0, 'Xinji Shi', 'XJS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (440, '130203', '·', 38, 0, 0, 'Lubei Qu', 'LBQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (446, '130224', '', 38, 0, 0, 'Luannan Xian', 'LNJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (450, '130230', 'ƺ', 38, 0, 0, 'Tanghai Xian ', 'THA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (456, '130304', '', 39, 0, 0, 'Beidaihe Qu', 'BDH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (462, '130402', 'ɽ', 40, 0, 0, 'Hanshan Qu', 'HHD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (466, '130421', '', 40, 0, 0, 'Handan Xian ', 'HDX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (470, '130426', '', 40, 0, 0, 'She Xian', 'SEJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (587, '131121', 'ǿ', 47, 0, 0, 'Zaoqiang Xian ', 'ZQJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (591, '131125', 'ƽ', 47, 0, 0, 'Anping Xian', 'APG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (594, '131128', '', 47, 0, 0, 'Fucheng Xian ', 'FCE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (598, '140105', 'С', 48, 0, 0, 'Xiaodian Qu', 'XDQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (601, '140108', 'ƺ', 48, 0, 0, 'Jiancaoping Qu', 'JCP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (605, '140122', '', 48, 0, 0, 'Yangqu Xian ', 'YGQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (611, '140211', 'Ͻ', 49, 0, 0, 'Nanjiao Qu', 'NJQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (614, '140222', '', 49, 0, 0, 'Tianzhen Xian ', 'TZE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (617, '140225', 'Դ', 49, 0, 0, 'Hunyuan Xian', 'HYM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (624, '140321', 'ƽ', 50, 0, 0, 'Pingding Xian', 'PDG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (631, '140424', '', 51, 0, 0, 'Tunliu Xian', 'TNL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (634, '140427', '', 51, 0, 0, 'Huguan Xian', 'HGN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (637, '140430', '', 51, 0, 0, 'Qin Xian', 'QIN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (642, '140521', 'ˮ', 52, 0, 0, 'Qinshui Xian', 'QSI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (644, '140524', '괨', 52, 0, 0, 'Lingchuan Xian', 'LGC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (649, '140603', 'ƽ³', 53, 0, 0, 'Pinglu Qu', 'PLU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (652, '140623', '', 53, 0, 0, 'Youyu Xian ', 'YOY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (657, '140722', 'Ȩ', 54, 0, 0, 'Zuoquan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (660, '140725', '', 54, 0, 0, 'Shouyang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (664, '140729', 'ʯ', 54, 0, 0, 'Lingshi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (670, '140823', 'ϲ', 55, 0, 0, 'Wenxi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (673, '140826', '', 55, 0, 0, 'Jiang Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (676, '140829', 'ƽ½', 55, 0, 0, 'Pinglu Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (679, '140882', 'ӽ', 55, 0, 0, 'Hejin Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (685, '140924', '', 56, 0, 0, 'Fanshi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (688, '140927', '', 56, 0, 0, 'Shenchi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (692, '140931', '', 56, 0, 0, 'Baode Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (697, '141021', '', 57, 0, 0, 'Quwo Xian ', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (700, '141024', '鶴', 57, 0, 0, 'Hongtong Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (704, '141028', '', 57, 0, 0, 'Ji Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (707, '141031', '', 57, 0, 0, 'Xi Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (711, '141081', '', 57, 0, 0, 'Houma Shi ', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (868, '210381', '', 73, 0, 0, 'Haicheng Shi', 'HCL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (874, '210421', '˳', 74, 0, 0, 'Fushun Xian', 'FSX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (880, '210504', 'ɽ', 75, 0, 0, 'Mingshan Qu', 'MSB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (883, '210522', '', 75, 0, 0, 'Huanren Manzu Zizhixian', 'HRL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (888, '210624', '', 76, 0, 0, 'Kuandian Manzu Zizhixian', 'KDN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (895, '210726', 'ɽ', 77, 0, 0, 'Heishan Xian', 'HSL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (898, '210782', '', 77, 0, 0, 'Beining Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (904, '210881', '', 78, 0, 0, 'Gaizhou Shi', 'GZU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (910, '210905', '', 79, 0, 0, 'Qinghemen Qu', 'QHM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1930, '410425', 'ۣ', 190, 0, 0, 'Jia Xian', 'JXY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (912, '210921', 'ɹ', 79, 0, 0, 'Fuxin Mongolzu Zizhixian', 'FXX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (919, '211011', '̫Ӻ', 80, 0, 0, 'Taizihe Qu', 'TZH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (923, '211102', '˫̨', 81, 0, 0, 'Shuangtaizi Qu', 'STZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (928, '211202', '', 82, 0, 0, 'Yinzhou Qu', 'YZU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (932, '211224', 'ͼ', 82, 0, 0, 'Changtu Xian', 'CTX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (937, '211303', '', 83, 0, 0, 'Longcheng Qu', 'LCL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (940, '211324', 'ɹ', 83, 0, 0, 'Harqin Zuoyi Mongolzu Zizhixian', 'HAZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3461, '652901', '', 370, 0, 0, 'Aksu Shi', 'AKS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (756, '150422', '', 62, 0, 0, 'Bairin Zuoqi', 'BAZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (817, '152221', 'ƶǰ', 68, 0, 0, 'Horqin Youyi Qianqi', 'HYQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2288, '431227', '»ζ', 229, 0, 0, 'Xinhuang Dongzu Zizhixian', 'XHD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2426, '441825', 'ɽ׳', 247, 0, 0, 'Lianshan Zhuangzu Yaozu Zizhixian', 'LSZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2587, '469026', '', 269, 0, 0, 'Changjiang Lizu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2598, '500104', 'ɿ', 270, 0, 0, 'Dadukou Qu', 'DDK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2629, '500242', '', 271, 0, 0, 'Youyang Tujiazu Miaozu Zizhixian', 'YUY');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2868, '520423', '', 297, 0, 0, 'Zhenning Buyeizu Miaozu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (2990, '530825', '', 309, 0, 0, 'Zhenyuan Yizu Hanizu Lahuzu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3026, '532532', 'ӿ', 312, 0, 0, 'Hekou Yaozu Zizhixian', 'HKM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3304, '620923', '౱ɹ', 344, 0, 0, 'Subei Monguzu Zizhixian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3439, '652222', '', 366, 0, 0, 'Barkol Kazak Zizhixian', 'BAR');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (989, '220581', '÷ӿ', 89, 0, 0, 'Meihekou Shi', 'MHK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1426, '340404', 'лҼ', 136, 0, 0, 'Xiejiaji Qu', 'XJJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (275, '510400', '֦', 24, 0, 0, 'Panzhihua Shi', 'PZH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (323, '542400', '', 27, 0, 0, 'Nagqu Diqu', 'NAD');
commit;
prompt 3400 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (376, '654300', '̩', 32, 0, 0, 'Altay Diqu', 'ALD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (602, '140109', '', 48, 0, 0, 'Wanbailin Qu', 'WBL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (755, '150421', '³ƶ', 62, 0, 0, 'Ar Horqin Qi', 'AHO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (786, '150724', '¿', 65, 0, 0, 'Ewenkizu Zizhiqi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (818, '152222', 'ƶ', 68, 0, 0, 'Horqin Youyi Zhongqi', 'HYZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (867, '210323', '', 73, 0, 0, 'Xiuyan Manzu Zizhixian', 'XYL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1898, '410204', '¥', 188, 0, 0, 'Gulou Qu', 'GLK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (301, '522600', 'ǭ嶱', 25, 0, 0, 'Qiandongnan Miaozu Dongzu Zizhizhou', 'QND');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (284, '511400', 'üɽ', 24, 0, 0, 'Meishan Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (148, '341700', '', 13, 0, 0, 'Chizhou Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (362, '640500', '', 31, 0, 0, 'Zhongwei Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3216, '610726', 'ǿ', 332, 0, 0, 'Ningqiang Xian', 'NQG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3220, '610730', 'ƺ', 332, 0, 0, 'Foping Xian', 'FPG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3225, '610823', 'ɽ', 333, 0, 0, 'Hengshan Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3231, '610829', 'Ɽ', 333, 0, 0, 'Wubu Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3356, '630121', 'ͨ', 350, 0, 0, 'Datong Huizu Tuzu Zizhixian', 'DAT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3360, '632122', 'ͻ', 351, 0, 0, 'Minhe Huizu Tuzu Zizhixian', 'MHE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3363, '632127', '¡', 351, 0, 0, 'Hualong Huizu Zizhixian', 'HLO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3366, '632222', '', 352, 0, 0, 'Qilian Xian', 'QLN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3369, '632321', 'ͬ', 353, 0, 0, 'Tongren Xian', 'TRN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3372, '632324', 'ɹ', 353, 0, 0, 'Henan Mongolzu Zizhixian', 'HNM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3377, '632525', '', 354, 0, 0, 'Guinan Xian', 'GNN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3381, '632624', '', 355, 0, 0, 'Tarlag Xian', 'TAR');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3384, '632721', '', 356, 0, 0, 'Yushu Xian', 'YSK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3388, '632725', 'ǫ', 356, 0, 0, 'Nangqen Xian', 'NQN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3391, '632802', '', 357, 0, 0, 'Delhi Shi', 'DEL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3399, '640121', '', 358, 0, 0, 'Yongning Xian', 'YGN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3403, '640202', '', 359, 0, 0, 'Dawukou Qu', 'DWK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3409, '640324', 'ͬ', 360, 0, 0, 'Tongxin Xian', 'TGX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3414, '640423', '¡', 361, 0, 0, 'Longde Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3419, '640521', '', 362, 0, 0, 'Zhongning Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3425, '650105', 'ˮĥ', 363, 0, 0, 'Shuimogou Qu', 'SMG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3431, '650202', 'ɽ', 364, 0, 0, 'Dushanzi Qu', 'DSZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3435, '652101', '³', 365, 0, 0, 'Turpan Shi', 'TUR');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3438, '652201', '', 366, 0, 0, 'Hami(kumul) Shi', 'HAM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3440, '652223', '', 366, 0, 0, 'Yiwu(Araturuk) Xian', 'YWX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3444, '652323', 'ͼ', 367, 0, 0, 'Hutubi Xian', 'HTB');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3448, '652328', 'ľݹ', 367, 0, 0, 'Mori Kazak Zizhixian', 'MOR');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3451, '652723', 'Ȫ', 368, 0, 0, 'Wenquan(Arixang) Xian', 'WNQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3454, '652823', 'ξ', 369, 0, 0, 'Yuli(Lopnur) Xian', 'YLI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (3456, '652825', 'ĩ', 369, 0, 0, 'Qiemo(Qarqan) Xian', 'QMO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1057, '230303', 'ɽ', 96, 0, 0, 'Hengshan Qu', 'HSD');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1063, '230381', '', 96, 0, 0, 'Hulin Shi', 'HUL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1071, '230407', 'ɽ', 97, 0, 0, 'Xingshan Qu', 'XSQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1079, '230521', '', 98, 0, 0, 'Jixian Xian', 'JXH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1084, '230602', 'ͼ', 99, 0, 0, 'Sairt Qu', 'SAI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1089, '230621', '', 99, 0, 0, 'Zhaozhou Xian', 'ZAZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1095, '230703', 'ϲ', 100, 0, 0, 'Nancha Qu', 'NCQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1100, '230708', 'Ϫ', 100, 0, 0, 'Meixi Qu', 'MXQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1104, '230712', '', 100, 0, 0, 'Tangwanghe Qu', 'TWH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1114, '230804', 'ǰ', 101, 0, 0, 'Qianjin Qu', 'QJQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1119, '230828', 'ԭ', 101, 0, 0, 'Tangyuan Xian', 'TYX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1124, '230902', '', 102, 0, 0, 'Xinxing Qu', 'XXQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1130, '231003', '', 103, 0, 0, 'Yangming Qu', 'YMQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1135, '231081', 'Һ', 103, 0, 0, 'Suifenhe Shi', 'SFE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1138, '231085', '', 103, 0, 0, 'Muling Shi', 'MLG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1143, '231124', '', 104, 0, 0, 'Sunwu Xian', 'SUW');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1148, '231221', '', 105, 0, 0, 'Wangkui Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1151, '231224', '찲', 105, 0, 0, 'Qing,an Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1155, '231282', 'ض', 105, 0, 0, 'Zhaodong Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1159, '232723', 'Į', 106, 0, 0, 'Mohe Xian', 'MOH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1163, '310105', '', 107, 0, 0, 'Changning Qu', 'CNQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1168, '310110', '', 107, 0, 0, 'Yangpu Qu', 'YPU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1172, '310115', 'ֶ', 107, 0, 0, 'Pudong Xinqu', 'PDX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1180, '320102', '', 109, 0, 0, 'Xuanwu Qu', 'XWU');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1185, '320107', '¹', 109, 0, 0, 'Xiaguan Qu', 'XGQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1534, '350182', '', 150, 0, 0, 'Changle Shi', 'CLS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1540, '350212', 'ͬ', 151, 0, 0, 'Tong,an Qu', 'TAQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1547, '350322', '', 152, 0, 0, 'Xianyou Xian', 'XYF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1552, '350423', '', 153, 0, 0, 'Qingliu Xian', 'QLX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1556, '350427', 'ɳ', 153, 0, 0, 'Sha Xian', 'SAX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1559, '350430', '', 153, 0, 0, 'Jianning Xian', 'JNF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1563, '350503', '', 154, 0, 0, 'Fengze Qu', 'FZE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1568, '350525', '', 154, 0, 0, 'Yongchun Xian', 'YCM');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1571, '350581', 'ʯʨ', 154, 0, 0, 'Shishi Shi', 'SHH');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1575, '350602', 'ܼ', 155, 0, 0, 'Xiangcheng Qu', 'XZZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1579, '350624', 'گ', 155, 0, 0, 'Zhao,an Xian', 'ZAF');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1583, '350628', 'ƽ', 155, 0, 0, 'Pinghe Xian', 'PHE');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1588, '350721', '˳', 156, 0, 0, 'Shunchang Xian', 'SCG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1594, '350782', 'ɽ', 156, 0, 0, 'Wuyishan Shi', 'WUS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1598, '350802', '', 157, 0, 0, 'Xinluo Qu', 'XNL');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1602, '350824', 'ƽ', 157, 0, 0, 'Wuping Xian', 'WPG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1607, '350921', 'ϼ', 158, 0, 0, 'Xiapu Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1611, '350925', '', 158, 0, 0, 'Zhouning Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1618, '360104', '', 159, 0, 0, 'Qingyunpu Qu', 'QYP');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1622, '360122', '½', 159, 0, 0, 'Xinjian Xian', 'XJN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1627, '360203', 'ɽ', 160, 0, 0, 'Zhushan Qu', 'ZSJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1632, '360313', '涫', 161, 0, 0, 'Xiangdong Qu', 'XDG');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1639, '360421', 'Ž', 162, 0, 0, 'Jiujiang Xian', 'JUJ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1643, '360426', '°', 162, 0, 0, 'De,an Xian', 'DEA');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1316, '330206', '', 123, 0, 0, 'Beilun Qu', 'BLN');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1322, '330282', 'Ϫ', 123, 0, 0, 'Cixi Shi', 'CXI');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1328, '330322', 'ͷ', 124, 0, 0, 'Dongtou Xian', 'DTO');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1332, '330328', 'ĳ', 124, 0, 0, 'Wencheng Xian', 'WCZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1339, '330421', '', 125, 0, 0, 'Jiashan Xian', 'JSK');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1347, '330521', '', 126, 0, 0, 'Deqing Xian', 'DQX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1352, '330621', '', 127, 0, 0, 'Shaoxing Xian', 'SXZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1356, '330683', '', 127, 0, 0, 'Shengzhou Shi', 'SGZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1363, '330781', 'Ϫ', 128, 0, 0, 'Lanxi Shi', 'LXZ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1370, '330822', 'ɽ', 129, 0, 0, 'Changshan Xian', 'CSN');
commit;
prompt 3500 records committed...
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1375, '330902', '', 130, 0, 0, 'Dinghai Qu', 'DHQ');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1382, '331004', '·', 131, 0, 0, 'Luqiao Qu', 'LQT');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1387, '331081', '', 131, 0, 0, 'Wenling Shi', 'WLS');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (1392, '331122', '', 132, 0, 0, 'Jinyun Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (4000, '620503', '', 340, 0, 0, 'Maiji Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (4001, '500116', '', 270, 0, 0, 'Jiangjin Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (4002, '500117', 'ϴ', 270, 0, 0, 'Hechuan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (4003, '500118', '', 270, 0, 0, 'Yongchuan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (4004, '500119', 'ϴ', 270, 0, 0, 'Nanchuan Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (4006, '340221', 'ߺ', 1412, 0, 0, 'Wuhu Xian', 'WHX');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (4100, '232701', 'Ӹ', 106, 0, 0, 'Jiagedaqi Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (4101, '232702', '', 106, 0, 0, 'Songling Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (4102, '232703', '', 106, 0, 0, 'Xinlin Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (4103, '232704', '', 106, 0, 0, 'Huzhong Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (4200, '330402', 'Ϻ', 125, 0, 0, 'Nanhu Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (4300, '360482', '', 162, 0, 0, 'Gongqingcheng Shi', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (4400, '640303', '±', 360, 0, 0, 'Hongsibao Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (4500, '620922', '', 344, 0, 0, 'Guazhou Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (4600, '421321', '', 215, 0, 0, 'Sui Xian', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (4700, '431102', '', 228, 0, 0, 'Lingling Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (4800, '451119', 'ƽ', 263, 0, 0, 'Pingguiguanli Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (4900, '510802', '', 279, 0, 0, 'Lizhou Qu', '2');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (5000, '511681', '', 286, 0, 0, 'Huaying Shi', 'HYC');
insert into REGION (REGION_ID, REGION_CODE, REGION_NAME, PARENT_ID, REGION_LEVEL, REGION_ORDER, REGION_NAME_EN, REGION_SHORTNAME_EN)
values (377, '659000', 'ֱϽؼ', 32, 0, 0, 'zizhiquzhixiaxianjixingzhengquhua', '2');
commit;
prompt 3524 records loaded
set feedback on
set define on
prompt Done.
