/* ============================================================
 * File  : frame_bk_media.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "frame_bk_media.h"

frame_bk_media::frame_bk_media ( QWidget * parent )
    : QFrame(parent)
{
	this->setAttribute(Qt::WA_DeleteOnClose);
        this->setMouseTracking(true);

        QPalette mypal = QApplication::palette();
        wg_color_1 = mypal.color(QPalette::Normal, QPalette::Text);

        wg_pix_001.load(":/Interface/Interface/fond_media.png");
        //this->setAttribute(Qt::WA_TranslucentBackground, true);
}

// ********************************
// *** DESSIN DU FOND DU WIDGET ***
// ********************************

void frame_bk_media::paintEvent(QPaintEvent *)
{
    QPainter p;
    p.begin(this);
    //p.setRenderHint(QPainter::Antialiasing,true);

    p.drawPixmap((this->width() - wg_pix_001.width())/2,((this->height() - wg_pix_001.height())/2)-20,wg_pix_001);
    p.setPen(wg_color_1);
    p.drawText(QRect(0,((this->height() - wg_pix_001.height())/2)+wg_pix_001.height()+5,this->width(),40), Qt::AlignCenter,tr("Deposez les medias\nde votre DVD ici"));
    p.end();
}

