/* ============================================================
 * File  : frame_tooltip.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "frame_tooltip.h"

frame_tooltip::frame_tooltip ( QWidget * parent )
    : QFrame(parent)
{
	this->setAttribute(Qt::WA_DeleteOnClose);
        this->hide();

        /*QGraphicsDropShadowEffect *myeffect = new QGraphicsDropShadowEffect();
        myeffect->setXOffset(1);
        myeffect->setYOffset(1);
        myeffect->setBlurRadius(2.0);*/

        myeffect = new QGraphicsOpacityEffect();
        myeffect->setOpacity(0.0);
        this->setAttribute(Qt::WA_TranslucentBackground, true);
        this->setGraphicsEffect(myeffect);
}

void frame_tooltip::f_show()
{
    this->show();
    this->raise();

    QPropertyAnimation *animation = new QPropertyAnimation(myeffect, "opacity");
    animation->setDuration(600);
    animation->setStartValue(0.0);
    animation->setEndValue(1.0);
    //animation->setEasingCurve(QEasingCurve::InOutCubic);
    animation->start();
}

void frame_tooltip::f_hide()
{
    QPropertyAnimation *animation = new QPropertyAnimation(myeffect, "opacity");
    connect(animation,SIGNAL(finished()),this,SLOT(f_leave()));
    animation->setDuration(600);
    animation->setStartValue(myeffect->opacity());
    animation->setEndValue(0.0);
    //animation->setEasingCurve(QEasingCurve::InOutCubic);
    animation->start();
}

void frame_tooltip::f_leave()
{
    this->hide();
}

// ********************************
// *** DESSIN DU FOND DU WIDGET ***
// ********************************

void frame_tooltip::paintEvent(QPaintEvent *)
{
        QPainter p;
	p.begin(this);
	p.setPen(Qt::NoPen);
	p.setRenderHint(QPainter::Antialiasing,true);
	//p.setBrush(QColor(59,53,45,200));
	QLinearGradient Gradient1(0.0,20.0,0.0,this->height()-30.0);
        Gradient1.setColorAt(0.0, QColor(40,40,40,230));
        Gradient1.setColorAt(0.7, QColor(40,40,40,200));
	p.setBrush(Gradient1);
        p.drawRoundedRect(0, 0, this->width()-10, this->height(),5,5,Qt::AbsoluteSize);
        static const QPointF points[3] = {
                QPointF(this->width()-10, (this->height()/2)-10),
                QPointF(this->width()-10, (this->height()/2)+10),
                QPointF(this->width(), (this->height()/2)),
	};
        p.setBrush(QColor(40,40,40,200));
        p.drawPolygon(points, 3);

        if ( wl_isdvd == 0 )
	{
                p.drawPixmap(this->width()-62,this->height()-52,QPixmap(":/Interface/Interface/reencode.png"),0,0,48,48);
	}
	else
	{
                p.drawPixmap(this->width()-62,this->height()-52,QPixmap(":/Interface/Interface/dvdformat.png"),0,0,48,48);
	}
	p.setPen(QColor(255,255,255));
        myfont.setPixelSize ( 9 );
	myfont.setBold(true);
	p.setFont(myfont);
        p.drawText(10,20,wl_pathname_media);
        myfont.setPixelSize ( 11 );
	myfont.setBold(false);
	p.setFont(myfont);
        p.drawText(10,45,tr("Resolution : ") + wl_width + "x" + wl_height + "   fps : " + wl_fps);
        p.drawText(10,60,tr("Duree : ") + wl_duree + " sec  " + tr("Format : ") + wl_format);
        p.drawText(10,75,tr("Canaux audio : ") + wl_audio_channel + "   " + tr("Chapitres : ") + wl_chapitres);
        p.end();
}

