/* ============================================================
 * File  : imageeditor.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QImageReader>
#include "imageeditor.h"

imageeditor::imageeditor ( QWidget * parent )
    : QLabel(parent)
{
	startcrop = 0;
	fadex=50;
	fadey=50;
	sizegomme = 20;
	this->setMouseTracking(true);
        //this->setScaledContents(true);
        //myparent = parent;
	opacgomme=0;

        crop_dx = 0;
        crop_ex = 0;
        crop_dy = 0;
        crop_ey = 0;

	colorgomme.setRed(0);
	colorgomme.setGreen(0);
	colorgomme.setBlue(0);

        valide_image = new QAction(tr("Valider"), this);
        valide_image->setIcon ( QIcon(":/Interface/Interface/select.png") );
        cancel_image = new QAction(tr("Annuler"), this);
        cancel_image->setIcon ( QIcon(":/Interface/Interface/cancel.png") );
        reset_image = new QAction(tr("Annuler le decoupage"), this);
        reset_image->setIcon ( QIcon(":/Interface/Interface/quoifaire.png") );

        connect(cancel_image, SIGNAL(triggered()), this, SLOT(f_cancel_image()));
        connect(valide_image, SIGNAL(triggered()), this, SLOT(f_valide_image()));
        connect(reset_image, SIGNAL(triggered()), this, SLOT(f_reset_image()));
}

// *** MENU CONTEXTUEL ***

void imageeditor::contextMenuEvent(QContextMenuEvent *event)
{
    QMenu menu(this);

    menu.addAction(reset_image);
    menu.addSeparator();
    menu.addAction(valide_image);
    menu.addAction(cancel_image);

    menu.exec(event->globalPos());
}

void imageeditor::f_reset_image()
{
    startcrop = 3;

    crop_dx = 0;
    crop_ex = 0;
    crop_dy = 0;
    crop_ey = 0;

    this->repaint();
}

void imageeditor::f_valide_image()
{
    emit s_valide_image();
}

void imageeditor::f_cancel_image()
{
    emit s_cancel_image();
}

/*void imageeditor::setImage(QPixmap pntimg2crop, QString pathname, int width, int height)
{
	path2crop = pathname;
	img2crop = pntimg2crop;
	img2resu.fill(QColor(0,0,0,0));
	img2resu = pntimg2crop;
	img2save = pntimg2crop;
	img32b = img2save.toImage();
	img32b = img32b.convertToFormat ( QImage::Format_ARGB32_Premultiplied, Qt::AutoColor );
	img32b_eraser = img32b.convertToFormat ( QImage::Format_ARGB32_Premultiplied, Qt::AutoColor );
	iwidth = width;
	iheight = height;
	realw = width;
	realh = height;
}*/

void imageeditor::mousePressEvent ( QMouseEvent * event ) 
{
	if ( startcrop == 3 )
	{
                if (!(event->buttons() & Qt::LeftButton)) return;
		crop_dx = event->x();
		crop_dy = event->y();
		startcrop = 1; 
	}
	else
	{
		if ( startcrop == 4 )
		{
			oldmx = event->x();
			oldmy = event->y();
                        startcrop = 2;
		}
		else
		{
                        /*if ( startcrop > 99 && event->buttons() & Qt::LeftButton )
			{
				QPainter p;
				p.begin(&img32b_eraser);
				QPainter::CompositionMode mode = (QPainter::CompositionMode)3;
				p.setCompositionMode ( mode );
				p.setBackgroundMode(Qt::TransparentMode);
				QPen pen;
				pen.setWidth(sizegomme);
				pen.setCapStyle(Qt::RoundCap);
				pen.setJoinStyle(Qt::RoundJoin);
				pen.setBrush(QColor(colorgomme.red(),colorgomme.green(),colorgomme.blue(),opacgomme));
				p.setPen(pen);
				p.drawLine ( oldmx, oldmy, event->x(), event->y() );
				p.end();
				img2resu = QPixmap::fromImage( img32b_eraser, (Qt::ColorOnly | Qt::ThresholdDither) );
			}
			pos_x = event->x();
			pos_y = event->y();
                        this->repaint();*/
		}
	}
}

void imageeditor::mouseReleaseEvent ( QMouseEvent * event )  
{
        if ( startcrop == 1 ) //|| startcrop == 2 )
	{
            if ( crop_dx-crop_ex != 0 && crop_dy-crop_ey !=0 )
            {
		if ( crop_dx > event->x() )
		{
			crop_ex = crop_dx;
			crop_dx = event->x();
		}
		if ( crop_dy > event->y() )
		{
			crop_ey = crop_dy;
			crop_dy = event->y();
		}
		startcrop = 4;
            }
            else
            {
                startcrop = 3;

                crop_dx = 0;
                crop_ex = 0;
                crop_dy = 0;
                crop_ey = 0;

                this->repaint();
            }
	}
}

void imageeditor::gocrop()
{
        /*img2resu = img2resu.copy ( crop_dx,crop_dy,crop_ex - crop_dx,crop_ey - crop_dy );
	img2save = img2resu;
	this->setPixmap(img2resu);
	this->setGeometry ((myparent->width() - img2resu.width())/2,(myparent->height() - img2resu.height())/2,img2resu.width(),img2resu.height());
	this->repaint();
	realw = img2resu.width();
        realh = img2resu.height();*/
}

void imageeditor::mouseMoveEvent ( QMouseEvent * event )
{
	if ( startcrop == 1 )
	{
                if (!(event->buttons() & Qt::LeftButton)) return;
		crop_ex = event->x();
                crop_ey = event->y();
                //emit moveoneditor(event->x(),event->y());
                this->repaint();
	}
	else
	{
		if ( startcrop == 2 )
		{
			if (!(event->buttons() & Qt::LeftButton)) return;
			crop_dx = crop_dx + (event->x()-oldmx);
			crop_dy = crop_dy + (event->y()-oldmy);

                        //qDebug() << crop_dx << " " << crop_dy << " " << crop_ex << " " << crop_ey << " " << event->x()-oldmx << " " << event->y()-oldmy;

                        crop_ex = crop_ex + (event->x()-oldmx);
                        crop_ey = crop_ey + (event->y()-oldmy);

			oldmx = event->x();
			oldmy = event->y();
                        //emit moveoneditor(event->x(),event->y());
                        this->repaint();
		}
                else
		{
                        /*if ( startcrop == 0 )
			{
				if (!(event->buttons() & Qt::LeftButton)) return;
				fadex = ((float)event->x() / (float)realw )*(float)100;
				fadey = ((float)event->y() / (float)realh)*(float)100;
                                emit moveoneditor(event->x(),event->y());
                                emit deplace_fade();
			}
			else
			{
				if ( startcrop > 99 && event->buttons() & Qt::LeftButton) 
				{
					QPainter p;
					p.begin(&img32b_eraser);
					QPainter::CompositionMode mode = (QPainter::CompositionMode)3;
					p.setCompositionMode ( mode );
					p.setBackgroundMode(Qt::TransparentMode);
					QPen pen;
					pen.setWidth(sizegomme);
					pen.setCapStyle(Qt::RoundCap);
					pen.setJoinStyle(Qt::RoundJoin);
					pen.setBrush(QColor(colorgomme.red(),colorgomme.green(),colorgomme.blue(),opacgomme));
					p.setPen(pen);
					p.drawLine ( oldmx, oldmy, event->x(), event->y() );
					p.end();
					img2resu = QPixmap::fromImage( img32b_eraser, (Qt::ColorOnly | Qt::ThresholdDither) );
				}
                        }*/
			pos_x = event->x();
			pos_y = event->y();
			this->repaint();
                }
	}
	oldmx = event->x();
	oldmy = event->y();

        //qDebug() << startcrop << " " << crop_dx << " " << crop_dy << " " << crop_ex << " " << crop_ey;
}

void imageeditor::paintEvent(QPaintEvent *)
{
	QPainter p;
	p.begin(this);
	p.drawPixmap ( 0,0,img2resu );
	if ( startcrop == 1 || startcrop == 2 || startcrop == 4 )
	{
            if ( crop_dx-crop_ex != 0 && crop_dy-crop_ey !=0 )
            {
                p.fillRect ( 0, 0, this->width(), this->height(), QBrush( QColor(10,10,10,200), Qt::SolidPattern ) );
		if ( crop_ex < 0 )
		{
			crop_ex2 = 0;
		}
		else
		{
			crop_ex2 = crop_ex;
		}
		if ( crop_ey < 0 )
		{
			crop_ey2 = 0;
		}
		else
		{
			crop_ey2 = crop_ey;
		}
		if ( crop_dx < 0 )
		{
			crop_dx2 = 0;
		}
		else
		{
			crop_dx2 = crop_dx;
		}
		if ( crop_dy < 0 )
		{
			crop_dy2 = 0;
		}
		else
		{
			crop_dy2 = crop_dy;
		}
		if ( crop_ex > crop_dx )
		{
			if ( crop_ey > crop_dy )
			{
				p.drawPixmap ( crop_dx2, crop_dy2, img2resu, crop_dx2, crop_dy2, crop_ex2 - crop_dx2, crop_ey2 - crop_dy2 );
			}
			else
			{
				p.drawPixmap ( crop_dx2, crop_ey2, img2resu, crop_dx2, crop_ey2, crop_ex2 - crop_dx2, crop_dy2 - crop_ey2 );
			}
		}
		else
		{
			if ( crop_ey > crop_dy )
			{
				p.drawPixmap ( crop_ex2, crop_dy2, img2resu, crop_ex2, crop_dy2, crop_dx2 - crop_ex2, crop_ey2 - crop_dy2 );
			}
			else
			{
				p.drawPixmap ( crop_ex2, crop_ey2, img2resu, crop_ex2, crop_ey2, crop_dx2 - crop_ex2, crop_dy2 - crop_ey2 );
			}
		}
		p.setPen ( Qt::DotLine );
		p.setPen ( Qt::white );
		p.drawRect ( crop_dx, crop_dy, crop_ex - crop_dx, crop_ey - crop_dy );
                p.drawLine(crop_dx+((crop_ex-crop_dx)/3),crop_dy,crop_dx+((crop_ex-crop_dx)/3),crop_ey);
                p.drawLine(crop_dx+(((crop_ex-crop_dx)/3)*2),crop_dy,crop_dx+(((crop_ex-crop_dx)/3)*2),crop_ey);

                p.drawLine(crop_dx, crop_dy+((crop_ey-crop_dy)/3),crop_ex,crop_dy+((crop_ey-crop_dy)/3));
                p.drawLine(crop_dx, crop_dy+(((crop_ey-crop_dy)/3)*2),crop_ex,crop_dy+(((crop_ey-crop_dy)/3)*2));
            }
	}
        /*else
	{
		if ( startcrop > 99 )
		{
			QPen pen;
         		pen.setStyle(Qt::DashDotLine);
       			pen.setWidth(1);
         		pen.setCapStyle(Qt::RoundCap);
         		pen.setJoinStyle(Qt::RoundJoin);
			p.setPen(pen);
			p.drawEllipse ( pos_x-(sizegomme/2), pos_y-(sizegomme/2), sizegomme, sizegomme );
		}
        }*/
	p.end();
}
