/* ============================================================
 * File  : media_browser.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#include <QtGui>

#include "mainfrm.h"
#include "userSettings.h"

void mainfrm::f_change_directory(QString directory)
{
	// **************************************
	// *** TRAITEMENT REPERTOIRE EN COURS ***
	// **************************************
	QDir tmpdir(directory);
	QStringList filters;
        filters << "*.mpg" << "*.MPG" << "*.mpeg" << "*.MPEG" << "*.avi" << "*.AVI" << "*.flv" << "*.FLV" << "*.mod" << "*.MOD" << "*.vob" << "*.VOB" << "*.dv" << "*.DV" << "*.mp4" << "*.MP4" << "*.mts" << "*.MTS" << "*.mov" << "*.MOV";
	tmpdir.setNameFilters(filters);
	tmpdir.setSorting(QDir::Name | QDir::IgnoreCase);

	QFileInfo infostr;
	QString wlfile;
	wg_int_004 = 0;
	nbre_vignettes = 0;

	media_media->clear();
	media_media->current_path = directory;

        //QDir currentDir = QDir::homePath();

      	QFile wmyfic(path_project + "/DVD/TEMP/extraimg.sh");

	if ( !wmyfic.open( QIODevice::WriteOnly ))
	{
		qDebug() << "ERROR CREATING EXTRACT SCRIPT IN : " + path_project + "/DVD/TEMP/";
		return;
	}
	else
	{
		QTextStream out(&wmyfic);
		out << "#!/bin/bash" << endl;
		out << "cd " + path_project + "/DVD/TEMP/" << endl;

		foreach (wlfile, tmpdir.entryList(QDir::AllDirs | QDir::Files, QDir::DirsFirst | QDir::IgnoreCase))
		{
                        if ( wlfile == "." || ( wlfile == ".." && directory == "/" ) )
			{
			}
			else
			{
				infostr.setFile(directory + "/" + wlfile);
				if ( infostr.isFile() == false )
				{
					QListWidgetItem *item = new QListWidgetItem(media_media);
                                        item->setIcon(QIcon(":/Interface/Interface/folder_theme.png"));
					item->setStatusTip(wlfile);
					item->setText(wlfile);
					wg_int_004++;
				}
				else
				{
                                        wg_string_006 = wlfile;
                                        wlfile = "";
                                        int wl_int_1 = 0;

                                        while ( wl_int_1 < wg_string_006.length())
                                        {
                                            if ( wg_string_006.mid(wl_int_1,1) == "\"" )
                                            {
                                                wlfile = wlfile + "\\" + "\"";
                                            }
                                            else
                                            {
                                                wlfile = wlfile + wg_string_006.mid(wl_int_1,1);
                                            }
                                            wl_int_1++;
                                        }
                                        out << "ffmpegthumbnailer -i \"" + directory + "/" + wlfile + "\" -t 15 -s 400 -q 10 -o \"" + QString::number(nbre_vignettes+wg_int_004) + ".jpg\"" << endl;
					QListWidgetItem *item = new QListWidgetItem(media_media);
					item->setIcon(QIcon(":/Interface/Interface/reload.png"));
					item->setStatusTip("$$VIDF");
					item->setText(wlfile);
					nbre_vignettes++;
				}
			}
		}
		out << "rm -f extraimg.sh" << endl;
		out << "exit" << endl;
		wmyfic.close();
	}
	if ( nbre_vignettes > 0 )
	{
		media_media->setDisabled(true);
		bt_close_navigator->setDisabled(true);

		this->setCursor(Qt::WaitCursor);

		QString program = "bash";
       		QStringList arguments;
       		arguments << path_project + "/DVD/TEMP/extraimg.sh";
		process_extract_img.setProcessChannelMode ( QProcess::MergedChannels );
		process_extract_img.start( program, arguments );
	}
}

void mainfrm::f_generation_vignette(int, QProcess::ExitStatus)
{
	// ********************************************
	// *** CHARGEMENT DES MINIATURES DES VIDEOS ***
	// ********************************************
	int wl_int_001=0;
	QListWidgetItem *mywidget = new QListWidgetItem;
        QPixmap wl_pix_001(90,80);
	while ( wl_int_001 < nbre_vignettes )
	{
		// *** FABRICATION DE LA MINIATURE ***
		wl_pix_001.fill(QColor(0,0,0,0));

		QPainter p;
		p.begin(&wl_pix_001);

		p.setPen(Qt::NoPen);
		p.setRenderHint(QPainter::Antialiasing,true);
                p.drawPixmap(0,0,QPixmap(path_project + "/DVD/TEMP/" + QString::number(wl_int_001+wg_int_004) + ".jpg").scaledToHeight(80,Qt::FastTransformation),0,0,117,114);
                //p.drawPixmap(0,0,QPixmap(":/Interface/Interface/case.png"),0,0,-1,-1);
		p.end();	

		mywidget = media_media->item(wl_int_001+wg_int_004);
		mywidget->setIcon(wl_pix_001);
		wl_int_001++;
	}
	this->unsetCursor();
	media_media->setEnabled(true);
	bt_close_navigator->setEnabled(true);
}

void mainfrm::f_move_directory()
{
	// ***************************************
	// *** DEPLACEMENT DANS L'ARBORESCENCE ***
	// ***************************************
	QList<QListWidgetItem *> selectdir = media_media->selectedItems();
	QListWidgetItem *dirtxt = new QListWidgetItem;
	dirtxt = selectdir.at(0);
        int wl_larg_txt = 0;

	if ( dirtxt->statusTip() == "$$VIDF" )
	{
		return;
	}
	if ( dirtxt->statusTip().mid(0,2) != ".." )
	{
		path_media_import = path_media_import + "/" + dirtxt->statusTip();

                QStringList wl_explode = path_media_import.split("/",QString::SkipEmptyParts);

                toolbar_bt4 *newpt = new toolbar_bt4(frame_support_path);
                connect(newpt, SIGNAL(chgdir(toolbar_bt4*)),this, SLOT(f_chgdir(toolbar_bt4*)));
                table_hdl_medbrow[wl_explode.count()-1] = newpt;

                QFontMetrics fm(newpt->myfont);
                wl_larg_txt = fm.width(dirtxt->statusTip());

                newpt->setGeometry(lengthbar+3,33,wl_larg_txt+15,26);
                lengthbar = lengthbar + newpt->width()+3;

                newpt->setText(dirtxt->statusTip());
                newpt->show();
                newpt->f_show();
	}
	else
	{
		if ( path_media_import.count('/', Qt::CaseSensitive) > 1 )
		{
			path_media_import = path_media_import.section('/', 0, path_media_import.count('/', Qt::CaseSensitive)-1, QString::SectionDefault);

                        QStringList wl_explode = path_media_import.split("/",QString::SkipEmptyParts);
                        lengthbar = lengthbar - table_hdl_medbrow[wl_explode.count()]->width()-3;
                        table_hdl_medbrow[wl_explode.count()]->f_delete(0);
                }
		else
		{
                        table_hdl_medbrow[0]->f_delete(0);
                        lengthbar = 24;
			path_media_import = "/";
		}
	}

	f_change_directory(path_media_import);
}

void mainfrm::f_chgdir(toolbar_bt4 *hdlbt)
{
    QString wl_path = "/";
    int wl_int_001 = 0;

    if ( hdlbt->text() != "/" )
    {
        while ( table_hdl_medbrow[wl_int_001] != hdlbt && wl_int_001 < 40 )
        {
            wl_path = wl_path + table_hdl_medbrow[wl_int_001]->text() + "/";
            wl_int_001++;
        }
        wl_path = wl_path + table_hdl_medbrow[wl_int_001]->text() + "/";
        wl_int_001++;
    }

    int maxdel = frame_support_path->children().count()-1;

    while ( wl_int_001 < maxdel )
    {
        lengthbar = lengthbar - table_hdl_medbrow[wl_int_001]->width()-3;
        table_hdl_medbrow[wl_int_001]->f_delete(100*wl_int_001);
        wl_int_001++;
    }

    path_media_import = wl_path;
    f_change_directory(path_media_import);
}

void mainfrm::f_drop_to_panel()
{
	// ********************************
	// *** CREATION DE LA MINIATURE ***
	// ********************************

	// *** RECHERCHE SI MEDIA DEJA IMPORTE ***

	int wl_int_001 = 0;
	QString wl_str_001;

	if ( frame_mediatheque->wl_pathname.mid(0,6) == "file:/" )
	{
		wl_str_001 = frame_mediatheque->wl_pathname.mid(7,frame_mediatheque->wl_pathname.length()-7);
	}
	else
	{
		wl_str_001 = frame_mediatheque->wl_pathname;
	}

	while ( wl_int_001 < nbre_medias )
	{
		if ( table_hdl_medias[wl_int_001]->pathname_media == wl_str_001 )
		{
			QMessageBox::information(this, name_application, tr("Desole mais ce media a deja ete importe."));
			return;
		}
		wl_int_001++;
	}

	//

	if ( nbre_medias > 59 )
	{
		QMessageBox::information(this, name_application, tr("Vous ne pouvez plus ajouter de nouveaux medias. Maximum atteint."));
		return;
	}

	if ( frame_mediatheque->wl_pathname.mid(0,6) == "file:/" )
	{
		QFile wmyficext;
		QTextStream outext(&wmyficext);

		wmyficext.setFileName(path_project + "/DVD/GENE/extthum.sh");
		wmyficext.open( QIODevice::WriteOnly );
                outext << "ffmpegthumbnailer -i \"" + frame_mediatheque->wl_pathname.mid(7,frame_mediatheque->wl_pathname.length()-7) + "\" -t 15 -s 400 -q 10 -o \"" + path_project + "/DVD/TEMP/" + QString::number(9999) + ".jpg\"" << endl;
		outext << "rm -f " + path_project + "/DVD/GENE/extthum.sh" << endl;
		outext << "exit" << endl;
		wmyficext.close();
		wg_string_003 = "";
		QString programf = "bash";
		QStringList argumentsf;
		argumentsf << path_project + "/DVD/GENE/extthum.sh";

	      	proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
		proc_ffmpeg.start(programf,argumentsf);

		proc_ffmpeg.waitForFinished(-1);
	}
	else
	{
		QFile wmyficext;
		QTextStream outext(&wmyficext);

		wmyficext.setFileName(path_project + "/DVD/GENE/extthum.sh");
		wmyficext.open( QIODevice::WriteOnly );
                outext << "ffmpegthumbnailer -i \"" + frame_mediatheque->wl_pathname + "\" -t 15 -s 400 -q 10 -o \"" + path_project + "/DVD/TEMP/" + QString::number(9999) + ".jpg\"" << endl;
		outext << "rm -f " + path_project + "/DVD/GENE/extthum.sh" << endl;
		outext << "exit" << endl;
		wmyficext.close();
		wg_string_003 = "";
		QString programf = "bash";
		QStringList argumentsf;
		argumentsf << path_project + "/DVD/GENE/extthum.sh";

	      	proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
		proc_ffmpeg.start(programf,argumentsf);

		proc_ffmpeg.waitForFinished(-1);
	}

	// *** AJOUT DU MEDIA ***
	media *newmedia = new media(frame_mediatheque,frame_mediatheque);
	if ( frame_mediatheque->wl_pathname.mid(0,6) == "file:/" )
	{
		newmedia->miniature.load(path_project + "/DVD/TEMP/9999.jpg");
		newmedia->pathname_media = frame_mediatheque->wl_pathname.mid(7,frame_mediatheque->wl_pathname.length()-7);
	}
	else
	{
		newmedia->miniature.load(path_project + "/DVD/TEMP/9999.jpg");
		newmedia->pathname_media = frame_mediatheque->wl_pathname;
	}

        // *** FABRICATION DE LA MINIATURE ***
        QPixmap wl_pix_001(142,120);
        wl_pix_001.fill(QColor(0,0,0,0));

        QPainter p;
        p.begin(&wl_pix_001);

        p.setPen(Qt::NoPen);
        p.setRenderHint(QPainter::Antialiasing,true);
        p.drawPixmap(3,2,QPixmap(path_project + "/DVD/TEMP/9999.jpg").scaledToHeight(114,Qt::FastTransformation),0,0,117,114);
        p.drawPixmap(0,0,QPixmap(":/Interface/Interface/case.png"),0,0,-1,-1);
        p.end();
        newmedia->image = wl_pix_001;

        // *** AJOUT DU MEDIA ***

        int wl_pos_x=10+(nbre_medias*150);
        int wl_pos_y=40;

        if ( wl_pos_x > this->width() - 150 )
        {
                while ( wl_pos_x > (this->width() - 150) )
                {
                        wl_pos_x = wl_pos_x-(this->width() - 150);
                        wl_pos_y=wl_pos_y+140;
                }
        }

        newmedia->setGeometry((frame_mediatheque->width()-142)/2, (nbre_medias*120)+(10*(nbre_medias+1)), 142, 120);

        newmedia->show();

        if ( ((nbre_medias+1)*120)+(10*(nbre_medias+1))+120 > frame_mediatheque->height() )
        {
            frame_mediatheque->setGeometry(0,frame_mediatheque->geometry().y(),frame_mediatheque->width(),frame_mediatheque->height()+280);

            if ( myeffect_global_sb_medias->opacity() < 1.0 )
            {
                QPropertyAnimation *animation = new QPropertyAnimation(myeffect_global_sb_medias, "opacity");
                animation->setDuration(1000);
                animation->setStartValue(qreal(0.0));
                animation->setEndValue(qreal(1.0));
                animation->start();
            }
            sb_medias->setMaximum(frame_mediatheque->height()-support_frame_mediatheque->height());
        }

	table_hdl_medias[nbre_medias] = newmedia;
	hdl_current_media = newmedia;

	connect(newmedia, SIGNAL(delete_media(media*) ),this, SLOT(f_delete_media(media*)));
	connect(newmedia, SIGNAL(thumbnail_media(media*) ),this, SLOT(f_thumbnail_media(media*)));
	connect(newmedia, SIGNAL(chapitre_media(media*) ),this, SLOT(f_chapitre_media(media*)));
	connect(newmedia, SIGNAL(select_media(media*,int) ),this, SLOT(f_select_media(media*,int)));
	connect(newmedia, SIGNAL(affiche_info(media*) ),this, SLOT(f_affiche_info(media*)));
	connect(newmedia, SIGNAL(cache_info(media*) ),this, SLOT(f_cache_info(media*)));
	connect(newmedia, SIGNAL(encode_media(media*) ),this, SLOT(f_encode_media(media*)));
	connect(newmedia, SIGNAL(soundtrack(media*) ),this, SLOT(f_affiche_language(media*)));
	connect(newmedia, SIGNAL(effets(media*) ),this, SLOT(f_effets_media(media*)));
	connect(newmedia, SIGNAL(introdvd(media*) ),this, SLOT(f_introdvd(media*)));
        connect(newmedia, SIGNAL(sca_media(media*) ),this, SLOT(f_scamedia(media*)));

	// *** CREATION DU MEDIA DANS L'ARBORESCENCE ***
	item_media *newmediaarb = new item_media(frame_syno);

        int wl_calcpos = 2+(150*((nbre_medias + (nbre_menuth+1))-1));
        int wl_multi = 1;
        if ( wl_calcpos > 780 )
        {
                wl_multi = ((float)wl_calcpos/(float)780);
                wl_calcpos = wl_calcpos - (wl_multi*780);
                newmediaarb->setGeometry( 2+wl_calcpos, 150*(wl_multi+1), 142, 120 );
        }
        else
        {
                newmediaarb->setGeometry( wl_calcpos, 150*wl_multi, 142, 120 );
        }

	connect(newmediaarb, SIGNAL(item_move(item_media*) ),this, SLOT(f_itemmedia_move(item_media*)));
	connect(newmediaarb, SIGNAL(sg_ren_media(media*) ),this, SLOT(f_itemmedia_ren(media*)));

	newmediaarb->hdlmedia = newmedia;
	newmediaarb->fond = wl_pix_001;
	newmediaarb->show();
	frame_syno->tab_pnt_media[nbre_medias] = newmediaarb;

	// ****************************************************
	// *** IDENTIFICATION DES CARACTERISTIQUES DU MEDIA ***
	// ****************************************************
	QFile wmyficext2;
	QTextStream outext2(&wmyficext2);

	wmyficext2.setFileName(path_project + "/DVD/GENE/extinf.sh");
	wmyficext2.open( QIODevice::WriteOnly );
        if ( frame_mediatheque->wl_pathname.mid(0,6) == "file:/" )
        {
                outext2 << "mplayer -identify -frames 0 -vo null -ao null \"" + newmedia->pathname_media + "\"" << endl;
                outext2 << "tcprobe -i \"" + newmedia->pathname_media + "\"" << endl;
        }
        else
        {
                outext2 << "mplayer -identify -frames 0 -vo null -ao null \"" + media_media->current_filename + "\"" << endl;
	}
	outext2 << "rm -f " + path_project + "/DVD/GENE/extinf.sh" << endl;
	outext2 << "exit" << endl;
	wmyficext2.close();

	wg_string_001 = "";
	QString program = "bash";
	QStringList arguments;
	arguments <<path_project + "/DVD/GENE/extinf.sh";

	frame_directory->setDisabled(true);

	process_ident_media.setProcessChannelMode ( QProcess::MergedChannels );
	process_ident_media.start( program, arguments );
}

void mainfrm::f_introdvd(media* hdlmedia)
{
	hdl_current_media = hdlmedia;
	wg_int_001=0;
	while ( wg_int_001 < nbre_medias )
	{
		if ( table_hdl_medias[wg_int_001] != hdlmedia )
		{
			table_hdl_medias[wg_int_001]->isdvdintro = 0;
			table_hdl_medias[wg_int_001]->repaint();
		}
		wg_int_001++;
	}
}

void mainfrm::f_scroll_medias(int valscro)
{
        frame_mediatheque->setGeometry(frame_mediatheque->geometry().x(),0-valscro,frame_mediatheque->width(),frame_mediatheque->height());
}

void mainfrm::f_drop_dble()
{
	// ********************************
	// *** CREATION DE LA MINIATURE ***
	// ********************************

	// *** RECHERCHE SI MEDIA DEJA IMPORTE ***

	int wl_int_001 = 0;
	QString wl_str_001;

	wl_str_001 = media_media->current_filename;

	while ( wl_int_001 < nbre_medias )
	{
		if ( table_hdl_medias[wl_int_001]->pathname_media == wl_str_001 )
		{
			QMessageBox::information(this, name_application, tr("Desole mais ce media a deja ete importe."));
			return;
		}
		wl_int_001++;
	}

	if ( nbre_medias > 59 )
	{
		QMessageBox::information(this, name_application, tr("Vous ne pouvez plus ajouter de nouveaux medias. Maximum atteint."));
		return;
	}

	//

	QFile wmyficext;
	QTextStream outext(&wmyficext);

	wmyficext.setFileName(path_project + "/DVD/GENE/extthum.sh");
	wmyficext.open( QIODevice::WriteOnly );
        outext << "ffmpegthumbnailer -i \"" + wl_str_001 + "\" -t 15 -s 400 -q 10 -o \"" + path_project + "/DVD/TEMP/" + QString::number(9999) + ".jpg\"" << endl;
	outext << "rm -f " + path_project + "/DVD/GENE/extthum.sh" << endl;
	outext << "exit" << endl;
	wmyficext.close();
	wg_string_003 = "";
	QString programf = "bash";
	QStringList argumentsf;
	argumentsf << path_project + "/DVD/GENE/extthum.sh";

      	proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
	proc_ffmpeg.start(programf,argumentsf);

	proc_ffmpeg.waitForFinished(-1);

        // *** FABRICATION DE LA MINIATURE ***
        QPixmap wl_pix_001(142,120);
        wl_pix_001.fill(QColor(0,0,0,0));

        QPainter p;
        p.begin(&wl_pix_001);

        p.setPen(Qt::NoPen);
        p.setRenderHint(QPainter::Antialiasing,true);
        p.drawPixmap(3,2,QPixmap(path_project + "/DVD/TEMP/9999.jpg").scaledToHeight(114,Qt::FastTransformation),0,0,117,114);
        p.drawPixmap(0,0,QPixmap(":/Interface/Interface/case.png"),0,0,-1,-1);
        p.end();

        // *** AJOUT DU MEDIA ***
        media *newmedia = new media(frame_mediatheque,frame_mediatheque);
        newmedia->miniature.load(path_project + "/DVD/TEMP/9999.jpg");
        newmedia->pathname_media = media_media->current_filename;
        newmedia->image = wl_pix_001;

	int wl_pos_x=10+(nbre_medias*150);
	int wl_pos_y=40;

	if ( wl_pos_x > this->width() - 150 )
	{
		while ( wl_pos_x > (this->width() - 150) )
		{
			wl_pos_x = wl_pos_x-(this->width() - 150);
			wl_pos_y=wl_pos_y+140;
		}
	}
	
        newmedia->setGeometry((frame_mediatheque->width()-142)/2, (nbre_medias*120)+(10*(nbre_medias+1)), 142, 120);

        if ( (nbre_medias*120)+(10*(nbre_medias+1))+120 > frame_mediatheque->height() )
        {
            frame_mediatheque->setGeometry(0,frame_mediatheque->geometry().y(),frame_mediatheque->width(),frame_mediatheque->height()+280);
            if ( myeffect_global_sb_medias->opacity() < 1.0 )
            {
                QPropertyAnimation *animation = new QPropertyAnimation(myeffect_global_sb_medias, "opacity");
                animation->setDuration(1000);
                animation->setStartValue(qreal(0.0));
                animation->setEndValue(qreal(1.0));
                animation->start();
            }
            sb_medias->setMaximum(frame_mediatheque->height()-support_frame_mediatheque->height());
        }

	newmedia->show();

	table_hdl_medias[nbre_medias] = newmedia;
	hdl_current_media = newmedia;

	connect(newmedia, SIGNAL(delete_media(media*) ),this, SLOT(f_delete_media(media*)));
	connect(newmedia, SIGNAL(thumbnail_media(media*) ),this, SLOT(f_thumbnail_media(media*)));
	connect(newmedia, SIGNAL(chapitre_media(media*) ),this, SLOT(f_chapitre_media(media*)));
	connect(newmedia, SIGNAL(select_media(media*,int) ),this, SLOT(f_select_media(media*,int)));
	connect(newmedia, SIGNAL(affiche_info(media*) ),this, SLOT(f_affiche_info(media*)));
	connect(newmedia, SIGNAL(cache_info(media*) ),this, SLOT(f_cache_info(media*)));
	connect(newmedia, SIGNAL(encode_media(media*) ),this, SLOT(f_encode_media(media*)));
	connect(newmedia, SIGNAL(soundtrack(media*) ),this, SLOT(f_affiche_language(media*)));
	connect(newmedia, SIGNAL(effets(media*) ),this, SLOT(f_effets_media(media*)));
	connect(newmedia, SIGNAL(introdvd(media*) ),this, SLOT(f_introdvd(media*)));
        connect(newmedia, SIGNAL(sca_media(media*) ),this, SLOT(f_scamedia(media*)));

	// *** CREATION DU MEDIA DANS L'ARBORESCENCE ***
	item_media *newmediaarb = new item_media(frame_syno);

        int wl_calcpos = 2+(150*((nbre_medias + (nbre_menuth+1))-1));
        int wl_multi = 1;
        if ( wl_calcpos > 780 )
        {
                wl_multi = ((float)wl_calcpos/(float)780);
                wl_calcpos = wl_calcpos - (wl_multi*780);
                newmediaarb->setGeometry( 2+wl_calcpos, 150*(wl_multi+1), 142, 120 );
        }
        else
        {
                newmediaarb->setGeometry( wl_calcpos, 150*wl_multi, 142, 120 );
        }

	connect(newmediaarb, SIGNAL(item_move(item_media*) ),this, SLOT(f_itemmedia_move(item_media*)));
	connect(newmediaarb, SIGNAL(sg_ren_media(media*) ),this, SLOT(f_itemmedia_ren(media*)));
	newmediaarb->hdlmedia = newmedia;
	newmediaarb->fond = wl_pix_001;
	newmediaarb->show();
	frame_syno->tab_pnt_media[nbre_medias] = newmediaarb;

	// ****************************************************
	// *** IDENTIFICATION DES CARACTERISTIQUES DU MEDIA ***
	// ****************************************************
	QFile wmyficext2;
	QTextStream outext2(&wmyficext2);

	wmyficext2.setFileName(path_project + "/DVD/GENE/extinf.sh");
	wmyficext2.open( QIODevice::WriteOnly );
        outext2 << "mplayer -identify -frames 0 -vo null -ao null \"" + media_media->current_filename + "\"" << endl;
	outext2 << "tcprobe -i \"" + media_media->current_filename + "\"" << endl;
	outext2 << "rm -f " + path_project + "/DVD/GENE/extinf.sh" << endl;
	outext2 << "exit" << endl;
	wmyficext2.close();

	wg_string_001 = "";
	QString program = "bash";
	QStringList arguments;
	arguments <<path_project + "/DVD/GENE/extinf.sh";

	frame_directory->setDisabled(true);

	process_ident_media.setProcessChannelMode ( QProcess::MergedChannels );
	process_ident_media.start( program, arguments );
}

void mainfrm::f_affiche_info(media* hdlmedia)
{
    //frame_tooltip_media->raise();
    //frame_tooltip_media->show();

	wg_int_001 = hdlmedia->pathname_media.lastIndexOf( '/' );
    	frame_tooltip_media->wl_pathname_media = hdlmedia->pathname_media.mid(wg_int_001 + 1, hdlmedia->pathname_media.length() - (wg_int_001 + 1));

	frame_tooltip_media->wl_duree = hdlmedia->wl_duree;
	frame_tooltip_media->wl_width = hdlmedia->wl_width;
	frame_tooltip_media->wl_height = hdlmedia->wl_height;
	frame_tooltip_media->wl_fps = hdlmedia->wl_fps;
	frame_tooltip_media->wl_isdvd = hdlmedia->isdvd;

        /*if ( ((float)hdlmedia->wl_vbitrate_encode.toInt()/(float)1024) > wl_vmax )
	{
		frame_tooltip_media->wl_isdvd = 0;
        }*/

	if ( hdlmedia->wl_format == "1.3333" )
	{
		frame_tooltip_media->wl_format = "4/3";
	}
	else
	{
		frame_tooltip_media->wl_format = "16/9";
	}
	frame_tooltip_media->wl_audio_channel = hdlmedia->wl_audio_channel;
	frame_tooltip_media->wl_chapitres = QString::number(hdlmedia->nbre_chapitres);
        frame_tooltip_media->setGeometry((frame_pro->geometry().x()+hdlmedia->geometry().x())-310,(hdlmedia->geometry().y()+18)+frame_mediatheque->geometry().y(),300,100);

        frame_tooltip_media->raise();
        frame_tooltip_media->f_show();

        /*PropertyAnimation *animation = new QPropertyAnimation(myeffect, "opacity");
        connect(animation,SIGNAL(finished()),this,SLOT(f_leave()));
        animation->setDuration(500);
        animation->setStartValue(myeffect->opacity());
        animation->setEndValue(0.0);
        //animation->setEasingCurve(QEasingCurve::InOutCubic);
        animation->start();*/
}

void mainfrm::f_wheel_scroll()
{
        frame_tooltip_media->f_hide();
        sb_medias->setValue(frame_mediatheque->geometry().y()*-1);
}

void mainfrm::f_cache_info(media*)
{
        /*QPropertyAnimation *animation = new QPropertyAnimation(frame_tooltip_media, "windowOpacity");
        animation->setDuration(250);
        animation->setStartValue(1.0);
        animation->setEndValue(0.0);*/
        //animation->setEasingCurve(QEasingCurve::InOutCubic);
        //animation->start();
        //frame_tooltip_media->hide();

        frame_tooltip_media->f_hide();
}

void mainfrm::f_menu_navi_on(menu* hdlmn)
{
	if ( frame_editor->isEnabled() == true )
	{
		int wl_nbre_lignes = 0;
		int wl_int_001 = 0;
		QFontMetrics fm(frame_info_navi->myfont);
		if ( hdlmn->quoilire == "" )
		{
			frame_info_navi->wl_action = "";
			frame_info_navi->wl_playlist = "";
                        frame_info_navi->setGeometry(hdlmn->geometry().x()+(hdlmn->width()/2),hdlmn->geometry().y()+hdlmn->height(),280,56);
                        //frame_info_navi->repaint();
		}
		else
		{
			int wl_larg_txt;

			if ( hdlmn->quoilire.mid(0,3) == "!M!" )
			{
				frame_info_navi->wl_action = tr("Saut au menu : ") + hdlmn->quoilire.mid(3,hdlmn->quoilire.length()-3);
				frame_info_navi->wl_playlist = "";
				wl_larg_txt = fm.width(frame_info_navi->wl_action);
			}
			else
			{
				wl_int_001 = hdlmn->quoilire.lastIndexOf( '/' );
				frame_info_navi->wl_action = tr("Media : ") + hdlmn->quoilire.mid(wl_int_001+1,hdlmn->quoilire.length()-(wl_int_001+1)) + "\n" + tr("Chapitre : ") + hdlmn->quoilirechapitre;
				if ( hdlmn->quoi_faire == "" )
				{
					frame_info_navi->wl_playlist = "";
				}
				else
				{
					frame_info_navi->wl_row_playlist = 2;
					frame_info_navi->wl_playlist = "Playlist : " + QString::number(hdlmn->quoi_faire.count(QString("$*$"),Qt::CaseSensitive)+1) + " " + tr("elements");
					wl_nbre_lignes++;
				}
				wl_nbre_lignes++;
				wl_larg_txt = fm.width(tr("Media : ") + hdlmn->quoilire.mid(wl_int_001+1,hdlmn->quoilire.length()-(wl_int_001+1)))+50;
				if ( fm.width(tr("Chapitre : ") + hdlmn->quoilirechapitre) > wl_larg_txt )
				{
					wl_larg_txt = fm.width(tr("Chapitre : ") + hdlmn->quoilirechapitre)+50;
				}
			}

                        frame_info_navi->setGeometry(hdlmn->geometry().x()+(hdlmn->width()/2),hdlmn->geometry().y()+hdlmn->height(),wl_larg_txt+42,56+(15*wl_nbre_lignes));
                        //frame_info_navi->repaint();
		}
                frame_info_navi->f_show();
                //frame_info_navi->raise();
	}
}

void mainfrm::f_menu_navi_off(menu*)
{
        //frame_info_navi->hide();
        frame_info_navi->f_hide();
}

void mainfrm::displayRegle( bool state )
{
    if( state )
    {
            h_regle->show();
            h_regle->raise();
            v_regle->show();
            v_regle->raise();
            //frame_lst_menus->raise();
            frame_top_tool->raise();
    }
    else
    {
            h_regle->hide();
            v_regle->hide();
    }
}


void mainfrm::f_showhide_regle()
{
    bool newState = actionAfficher_cacher_les_r_gles->isChecked(); // ! h_regle->isVisible();
    userSettings::setDisplayOption( userSettings::DISPLAY_RULE, newState );
    displayRegle( newState );
}

void mainfrm::f_scroll_timeline(int value)
{
	frame_support_menuthumb->setGeometry(0-value,0,frame_support_menuthumb->width(),frame_support_menuthumb->height());
}

void mainfrm::f_import_mask()
{
	// *** CHOIX DU MASK A IMPORTER ***
	wg_string_001 = QFileDialog::getOpenFileName(
        	this,
        	tr("Importer un mask dans la bibliotheque"),
        	path_img_menu,
        	"(*.PNG *.png)");
	if ( wg_string_001.isNull() )
	{
	}
	else
	{
   		wg_int_001 = wg_string_001.lastIndexOf( '/' );
    		if ( wg_int_001 != -1 )
    		{
        		path_img_menu = wg_string_001.mid(0,wg_int_001);
    		}

		if ( QFile::copy ( wg_string_001, QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Masks/" + wg_string_001.mid(wg_int_001,wg_string_001.length()-wg_int_001) ) )
		{
			QString wl_str_001 = wg_string_001.mid(0,wg_int_001) + "/2t_" + wg_string_001.mid(wg_int_001+1,wg_string_001.length()-(wg_int_001+1));
			QFile::copy ( wl_str_001, QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Masks/2t_" + wg_string_001.mid(wg_int_001+1,wg_string_001.length()-(wg_int_001+1)));
			QDir tmpdir;
			tmpdir.setPath(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Masks/");
			QStringList filters;
			filters << "*.png" << "*.PNG";
			tmpdir.setNameFilters(filters);
			frame_th_msk_idea->clear();

			QListWidgetItem *item = new QListWidgetItem(frame_th_msk_idea);
			item->setIcon(QIcon(":/Interface/Interface/error.png"));
			item->setText(wg_str_int_004);

			QPixmap wl_pix_001;
			QPixmap wl_pix_002;
			QPainter p;

			foreach (wg_string_001, tmpdir.entryList(QDir::Files))
			{
				if ( wg_string_001.mid(0,3) != "2t_" )
				{
					wl_pix_001.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Masks/" + wg_string_001);
					if ( wl_pix_002.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Masks/2t_" + wg_string_001) == true )
					{
						p.begin(&wl_pix_001);
						p.drawPixmap(0,0,wl_pix_002);
						p.end();
					}
					QListWidgetItem *item = new QListWidgetItem(frame_th_msk_idea);
					item->setIcon(wl_pix_001);
					item->setText(wg_string_001.mid(0,wg_string_001.length()-4));
				}
			}

			frame_th_msk_idea->sortItems( Qt::AscendingOrder );
		}
		else
		{
			qDebug() << "ERROR COPYING MASK FILE";
			QMessageBox::information(this, name_application, tr("Erreur pendant la copie du fichier mask. Un autre fichier avec le meme nom existe déja ou vous n'avez pas les droits de copie dans la bibliotheque"));
		}
	}
}

// ********************************
// *** CHOIX MINIATURE DU MEDIA ***
// ********************************

void mainfrm::f_thumbnail_media(media *hdlmed)
{
      	QFile wmyfic(path_project + "/DVD/TEMP/extraimg.sh");

	if ( !wmyfic.open( QIODevice::WriteOnly ))
	{
		qDebug() << "ERROR CREATING EXTRACT SCRIPT IN : " + path_project + "/DVD/TEMP/";
		return;
	}
	else
	{
                smenuBar->setDisabled(true);
		QTextStream out(&wmyfic);
		out << "#!/bin/bash" << endl;
		out << "cd " + path_project + "/DVD/TEMP/" << endl;
                out << "ffmpegthumbnailer -i \"" + hdlmed->pathname_media + "\" -s 400 -q 10 -t 10 -o T1.jpg" << endl;
                out << "ffmpegthumbnailer -i \"" + hdlmed->pathname_media + "\" -s 400 -q 10 -t 20 -o T2.jpg" << endl;
                out << "ffmpegthumbnailer -i \"" + hdlmed->pathname_media + "\" -s 400 -q 10 -t 30 -o T3.jpg" << endl;
                out << "ffmpegthumbnailer -i \"" + hdlmed->pathname_media + "\" -s 400 -q 10 -t 40 -o T4.jpg" << endl;
                out << "ffmpegthumbnailer -i \"" + hdlmed->pathname_media + "\" -s 400 -q 10 -t 50 -o T5.jpg" << endl;
                out << "ffmpegthumbnailer -i \"" + hdlmed->pathname_media + "\" -s 400 -q 10 -t 60 -o T6.jpg" << endl;
                out << "ffmpegthumbnailer -i \"" + hdlmed->pathname_media + "\" -s 400 -q 10 -t 70 -o T7.jpg" << endl;
                out << "ffmpegthumbnailer -i \"" + hdlmed->pathname_media + "\" -s 400 -q 10 -t 80 -o T8.jpg" << endl;
                out << "ffmpegthumbnailer -i \"" + hdlmed->pathname_media + "\" -s 400 -q 10 -t 90 -o T9.jpg" << endl;
		out << "exit" << endl;
		wmyfic.close();

		support_frame_mediatheque->hide();
		jauge_dvd->hide();

		hdl_current_media = hdlmed;

		QString program = "bash";
       		QStringList arguments;
       		arguments << path_project + "/DVD/TEMP/extraimg.sh";
		process_extract_thu.setProcessChannelMode ( QProcess::MergedChannels );
		process_extract_thu.start( program, arguments );
	}
}

void mainfrm::f_generation_thu(int, QProcess::ExitStatus)
{
	hdlpf->addSlide(QImage(path_project + "/DVD/TEMP/T1.jpg"));
	hdlpf->addSlide(QImage(path_project + "/DVD/TEMP/T2.jpg"));
	hdlpf->addSlide(QImage(path_project + "/DVD/TEMP/T3.jpg"));
	hdlpf->addSlide(QImage(path_project + "/DVD/TEMP/T4.jpg"));
	hdlpf->addSlide(QImage(path_project + "/DVD/TEMP/T5.jpg"));
	hdlpf->addSlide(QImage(path_project + "/DVD/TEMP/T6.jpg"));
	hdlpf->addSlide(QImage(path_project + "/DVD/TEMP/T7.jpg"));
	hdlpf->addSlide(QImage(path_project + "/DVD/TEMP/T8.jpg"));
	hdlpf->addSlide(QImage(path_project + "/DVD/TEMP/T9.jpg"));
        hdlpf->setCenterIndex(4);
	hdlpf->showSlide(0);

        slnbimg->setDisabled(true);
        slnbimg->setValue(8);
        slnbimg->setEnabled(true);

	wg_int_001 = 0;
	frame_choose_thumb->show();
	frame_choose_thumb->raise();

	// *** AFFICHAGE POSITION ***
	QTime wl_time(0,0,0);
	wl_time = wl_time.addSecs((wg_int_001+1) * (hdl_current_media->wl_duree.toInt()/10));

        label_pos_med_thumb->setText(tr("Position dans le media : ") + wl_time.toString("hh:mm:ss"));
}

void mainfrm::f_reload_thumb(int nbex)
{
    if ( slnbimg->isEnabled() == false )
    {
        return;
    }

    QFile wmyfic(path_project + "/DVD/TEMP/extraimg.sh");

    if ( !wmyfic.open( QIODevice::WriteOnly ))
    {
            qDebug() << "ERROR CREATING EXTRACT SCRIPT IN : " + path_project + "/DVD/TEMP/";
            return;
    }
    else
    {
            QTextStream out(&wmyfic);
            out << "#!/bin/bash" << endl;
            out << "cd " + path_project + "/DVD/TEMP/" << endl;

            int i = 0;

            while ( i < nbex )
            {
                out << "ffmpegthumbnailer -i \"" + hdl_current_media->pathname_media + "\" -s 400 -q 10 -t " + QString::number(((100/nbex)*i)) + " -o T" + QString::number(i+1) + ".jpg" << endl;
                i++;
            }
            out << "exit" << endl;
            wmyfic.close();

            QString program = "bash";
            QStringList arguments;
            arguments << path_project + "/DVD/TEMP/extraimg.sh";
            proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
            proc_ffmpeg.start(program,arguments);

            proc_ffmpeg.waitForFinished(-1);

            i = 0;

            hdlpf->clear();

            while ( i < nbex )
            {
                hdlpf->addSlide(QImage(path_project + "/DVD/TEMP/T" + QString::number(i+1) + ".jpg"));
                i++;
            }

            hdlpf->setCenterIndex(4);
            hdlpf->showSlide(0);
    }
}

void mainfrm::f_next_thumb()
{
	wg_int_001++;
        if ( wg_int_001 > slnbimg->value() )
	{
		wg_int_001 = 0;
	}
	// *** AFFICHAGE POSITION ***
	QTime wl_time(0,0,0);
	wl_time = wl_time.addSecs((wg_int_001+1) * (hdl_current_media->wl_duree.toInt()/10));

        hdlpf->showSlide(wg_int_001);
        label_pos_med_thumb->setText(tr("Position dans le media : ") + wl_time.toString("hh:mm:ss"));
}

void mainfrm::f_prev_thumb()
{
	wg_int_001--;
	if ( wg_int_001 < 0 )
	{
                wg_int_001 = slnbimg->value();
	}
	// *** AFFICHAGE POSITION ***
	QTime wl_time(0,0,0);
	wl_time = wl_time.addSecs((wg_int_001+1) * (hdl_current_media->wl_duree.toInt()/10));

	hdlpf->showSlide(wg_int_001);
        label_pos_med_thumb->setText(tr("Position dans le media : ") + wl_time.toString("hh:mm:ss"));
    }

void mainfrm::f_valid_thumb()
{
	/*QPixmap wl_pix_001(102,130);
	QPixmap wl_pix_002 = QPixmap(path_project + "/DVD/TEMP/T" + QString::number(wg_int_001+1) + ".jpg").scaledToHeight( 130, Qt::FastTransformation );

	wl_pix_001.fill(QColor(0,0,0,0));

	QPainter p;
	p.begin(&wl_pix_001);

	p.setPen(Qt::NoPen);
	p.setRenderHint(QPainter::Antialiasing,true);
	p.setBrush(QColor(0,0,0));
	p.drawRect(12,3,85,120);

	wl_pix_002 = wl_pix_002.scaledToHeight(120, Qt::FastTransformation );

	p.drawPixmap(12,3,wl_pix_002,0,0,85,120);
	p.drawPixmap(0,0,102,130,QPixmap(":/Interface/Interface/case.png"));
	p.end();*/

	QPixmap wl_pix_001(142,120);
	wl_pix_001.fill(QColor(0,0,0,0));

	QPainter p;
	p.begin(&wl_pix_001);

	p.setPen(Qt::NoPen);
	p.setRenderHint(QPainter::Antialiasing,true);
	p.drawPixmap(3,2,QPixmap(path_project + "/DVD/TEMP/T" + QString::number(wg_int_001+1) + ".jpg").scaledToHeight(114,Qt::FastTransformation),0,0,117,114);
	p.drawPixmap(0,0,QPixmap(":/Interface/Interface/case.png"),0,0,-1,-1);
	p.end();	

	hdl_current_media->image = wl_pix_001;
	if ( hdl_current_media->miniature.load(path_project + "/DVD/TEMP/T" + QString::number(wg_int_001+1) + ".jpg") == false )
	{
		qDebug() << "ERROR LOADING THUMBNAIL TO MEDIA";
	}
	frame_choose_thumb->hide();
	stamp_position_extract->hide();
	support_frame_mediatheque->show();
	jauge_dvd->show();
	hdlpf->clear();

        if ( frame_directory->isVisible() == false )
        {
            smenuBar->setEnabled(true);
        }
}

// **************************
// *** GESTION DES OBJETS ***
// **************************

void mainfrm::f_import_obj()
{
    QString wmypro = QFileDialog::getOpenFileName(
            this,
            tr("Ajouter un objet"),
            path_save,
            "(*.gif *.GIF");
    if ( wmypro.isNull() )
    {
            return;
    }
    else
    {
        int wl_int_001 = wmypro.lastIndexOf( '/' );
        if ( QFile::copy ( wmypro, QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Animations/" + wmypro.mid(wl_int_001+1,wmypro.length()-(1+wl_int_001)) ) )
        {
            QPixmap wl_pix_001(wmypro);
            QListWidgetItem *item = new QListWidgetItem(frame_th_obj_idea);
            item->setIcon(wl_pix_001);
            item->setText(wmypro.mid(wl_int_001+1,wmypro.length()-(5+wl_int_001))); //wg_string_001.mid(0,wg_string_001.length()-4));
        }
    }
}

void mainfrm::f_select_object()
{
	QList<QListWidgetItem *> selectthe = frame_th_obj_idea->selectedItems();
	QListWidgetItem *thetxt = new QListWidgetItem;
	thetxt = selectthe.at(0);

	// *** NOUVEAU LABEL ***
	QImage wl_testimg(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Animations/" + thetxt->text() + ".gif");
        if ( (int)(wl_testimg.width()/wl_testimg.height()) > 0 )
        {
                f_ajoute_menu_new(100,100,128,128/(int)(wl_testimg.width()/wl_testimg.height()));
        }
        else
        {
                f_ajoute_menu_new(100,100,128,128);
        }

	hdl_current_menu->islabel = 1;
	hdl_current_menu->charge_image(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Animations/" + thetxt->text() + ".gif");
	hdl_current_menu->back_image=QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Animations/" + thetxt->text() + ".gif";
	hdl_current_menu->repaint();
	f_update_thumb_menu();
}

void mainfrm::f_select_object_from_drop()
{
        QList<QListWidgetItem *> selectthe = frame_th_obj_idea->selectedItems();
        QListWidgetItem *thetxt = new QListWidgetItem;
        thetxt = selectthe.at(0);

        // *** NOUVEAU LABEL ***
        QImage wl_testimg(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Animations/" + thetxt->text() + ".gif");
        f_ajoute_menu_new(screen_designer->drop_x,screen_designer->drop_y,wl_testimg.width(),wl_testimg.height());

        hdl_current_menu->islabel = 1;
        hdl_current_menu->pos_thumb = "NA";
        hdl_current_menu->charge_image(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Animations/" + thetxt->text() + ".gif");
        hdl_current_menu->back_image=QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Animations/" + thetxt->text() + ".gif";
        hdl_current_menu->repaint();
        f_update_thumb_menu();

        frame_th_obj_idea->clearSelection();
        frame_th_obj_idea->clearFocus();
}

// **************************
// *** GESTION DES THEMES ***
// **************************

void mainfrm::f_add_theme()
{
	if ( frame_add_theme->isVisible() == true )
	{
		// *** AJOUTER LE MENU COURANT COMME THEME ***

		if ( combo_theme_categorie->currentText() != "" && txt_new_categorie->text() != "" )
		{
                    /*this->setEnabled(true);
                    screen_designer->setEnabled(true);
                    background_menu->setEnabled(true);*/
                    f_add_theme_2();
		}
	}
	else
	{
		// *** CHARGEMENT DE LA COMBO DES RUBRIQUES ***
		QDir tmpdir;
		tmpdir.setPath(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Themes/");
		tmpdir.setSorting(QDir::DirsFirst | QDir::Name);

		QStringList filters;
		filters << "*";
		tmpdir.setNameFilters(filters);

		int wl_int_001 = 0;
		combo_theme_categorie->clear();
		foreach (wg_string_001, tmpdir.entryList(QDir::Dirs))
		{
			if ( wg_string_001.mid(0,1) != "." )
			{
				combo_theme_categorie->insertItem(wl_int_001,wg_string_001.mid(5,wg_string_001.length()-5));
				wl_int_001++;
			}
		}

		frame_pro->setDisabled(true);
		smenuBar->setDisabled(true);
		frame_editor->setDisabled(true);
		frame_lst_menus->setDisabled(true);
		frame_add_theme->show();
		frame_add_theme->raise();

                txt_new_categorie->setFocus();
	}
}

void mainfrm::f_add_theme_2()
{
    QDir QDpath_project(QDir::currentPath());
    if ( QDpath_project.mkpath ( QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Themes/FOLD_" + combo_theme_categorie->currentText() + "/" + txt_new_categorie->text() ) == true )
    {
            //background_menu->pixmap()->save(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Themes/FOLD_" + combo_theme_categorie->currentText() + "/" + txt_new_categorie->text() + "/fd.jpg");

            QFile wmyfic(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Themes/FOLD_" + combo_theme_categorie->currentText() + "/" + txt_new_categorie->text() + "/theme.txt");

            if ( !wmyfic.open( QIODevice::WriteOnly ))
            {
                    qDebug() << "ERROR CREATING THEME IN : Bibliotheque/Themes/FOLD_" + combo_theme_categorie->currentText() + "/" + txt_new_categorie->text() + "/theme.txt";
                    return;
            }
            else
            {
                    f_save_widgetonmenu();

                    // *** SAUVEGARDE SNAPSHOT DU MENU ***

                    QTextStream out(&wmyfic);

                    // *** GENERATION DU MAIN MENU ***
                    if ( current_menu_background.right(5) == ".MPEG" || current_menu_background.right(5) == ".mpeg" || current_menu_background.right(4) == ".MPG" || current_menu_background.right(4) == ".mpg" || current_menu_background.right(4) == ".AVI" || current_menu_background.right(4) == ".avi" )
                    {
                            out << "ANIMATED" << endl;
                            wg_int_002 = current_menu_background.lastIndexOf( '/' );
                            if ( wg_int_002 != -1 )
                            {
                                    if ( QFile::copy ( current_menu_background, QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Themes/FOLD_" + combo_theme_categorie->currentText() + "/" + txt_new_categorie->text() + "/" + current_menu_background.mid(wg_int_002+1,current_menu_background.length()-(wg_int_002+1)) ) )
                                    {
                                    }
                                    else
                                    {
                                            qDebug() << "ERROR COPYING VIDEO TO THEME";
                                    }
                            }
                            out << current_menu_background.mid(wg_int_002+1,current_menu_background.length()-(wg_int_002+1)) << endl;
                    }
                    else
                    {
                        if ( QFile::copy ( current_menu_background, QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Themes/FOLD_" + combo_theme_categorie->currentText() + "/" + txt_new_categorie->text() + "/fd.jpg" ) )
                        {
                        }
                        else
                        {
                                qDebug() << "ERROR COPYING VIDEO TO THEME";
                        }
                    }

                    out << dvdxsize << endl;
                    out << dvdysize << endl;
                    out << scale_current_menu_background << endl;

                    if ( current_pencil_draw != "" )
                    {
                            if ( QFile::copy ( path_project + "/DVD/SVP/" + current_pencil_draw, QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Themes/FOLD_" + combo_theme_categorie->currentText() + "/" + txt_new_categorie->text() + "/" + current_pencil_draw ) )
                            {
                                out << current_pencil_draw << endl;
                            }
                            else
                            {
                                qDebug() << "ERROR COPYING VIDEO TO THEME";
                                out << "" << endl;
                            }
                    }
                    else
                    {
                        out << "" << endl;
                    }

                    while ( table_hdl_menuth[wg_int_001] != hdl_current_menuth && wg_int_001 < nbre_menuth )
                    {
                            wg_int_001++;
                    }

                    if ( table_hdl_menuth[wg_int_001] == hdl_current_menuth )
                    {
                            QString wl_str_001;
                            wg_int_002 = 0;
                            while ( wg_int_002 < nbre_menus )
                            {
                                    out << table_menus[wg_int_001][wg_int_002][0] << endl;
                                    out << table_menus[wg_int_001][wg_int_002][1] << endl;
                                    out << table_menus[wg_int_001][wg_int_002][2] << endl;
                                    out << table_menus[wg_int_001][wg_int_002][3] << endl;

                                    if ( table_menus[wg_int_001][wg_int_002][6] != "" )
                                    {
                                            if ( QFile::copy ( table_menus[wg_int_001][wg_int_002][6], QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Themes/FOLD_" + combo_theme_categorie->currentText() + "/" + txt_new_categorie->text() + "/" + QString::number(wg_int_002) + ".png" ) )
                                            {
                                                    wg_int_003 = table_menus[wg_int_001][wg_int_002][6].lastIndexOf( '/' );
                                                    if ( wg_int_003 != -1 )
                                                    {
                                                            wl_str_001 = table_menus[wg_int_001][wg_int_002][6].mid(0,wg_int_003) + "/2t_" + table_menus[wg_int_001][wg_int_002][6].mid(wg_int_003+1,table_menus[wg_int_001][wg_int_002][6].length()-(wg_int_003+1));

                                                            QFile::copy ( wl_str_001, QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Themes/FOLD_" + combo_theme_categorie->currentText() + "/" + txt_new_categorie->text() + "/2t_" + QString::number(wg_int_002) + ".png");
                                                    }
                                                    out << QString::number(wg_int_002) + ".png" << endl;
                                            }
                                            else
                                            {
                                                    out << "" << endl;
                                                    qDebug() << "ERROR COPYING MASK TO THEME";
                                            }
                                    }
                                    else
                                    {
                                            out << table_menus[wg_int_001][wg_int_002][6] << endl;
                                    }

                                    out << table_menus[wg_int_001][wg_int_002][7] << endl;
                                    out << table_menus[wg_int_001][wg_int_002][8] << endl;
                                    out << table_menus[wg_int_001][wg_int_002][10] << endl;
                                    out << table_menus[wg_int_001][wg_int_002][11] << endl;

                                    if ( table_menus[wg_int_001][wg_int_002][4].mid(0,5) == "$TXT$" || table_menus[wg_int_001][wg_int_002][11] == "1" )
                                    {

                                            if ( table_menus[wg_int_001][wg_int_002][4].mid(0,5) == "$TXT$" )
                                            {
                                                    wg_string_001 = table_menus[wg_int_001][wg_int_002][4];
                                                    wg_string_001 = wg_string_001.replace(QString("\n"),QString("$-E#"));
                                                    out << wg_string_001 << endl;
                                            }
                                            else
                                            {
                                                    wg_int_003 = table_menus[wg_int_001][wg_int_002][4].lastIndexOf( '/' );
                                                    if ( wg_int_003 != -1 )
                                                    {
                                                            if ( QFile::copy ( table_menus[wg_int_001][wg_int_002][4], QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Themes/FOLD_" + combo_theme_categorie->currentText() + "/" + txt_new_categorie->text() + "/" + table_menus[wg_int_001][wg_int_002][4].mid(wg_int_003+1,table_menus[wg_int_001][wg_int_002][4].length()-(wg_int_003+1)) ) )
                                                            {
                                                                    out << table_menus[wg_int_001][wg_int_002][4].mid(wg_int_003+1,table_menus[wg_int_001][wg_int_002][4].length()-(wg_int_003+1)) << endl;
                                                            }
                                                            else
                                                            {
                                                                    out << table_menus[wg_int_001][wg_int_002][4].mid(wg_int_003+1,table_menus[wg_int_001][wg_int_002][4].length()-(wg_int_003+1)) << endl;
                                                            }
                                                    }
                                                    else
                                                    {
                                                            out << "" << endl;
                                                            qDebug() << "ERROR EXTRACTING NAME OF IMAGE WHEN CREATE THEME";
                                                    }
                                            }
                                    }
                                    else
                                    {
                                            out << "" << endl;
                                    }
                                    out << table_menus[wg_int_001][wg_int_002][13] << endl;
                                    out << table_menus[wg_int_001][wg_int_002][12] << endl;
                                    out << table_menus[wg_int_001][wg_int_002][18] << endl;
                                    out << table_menus[wg_int_001][wg_int_002][20] << endl;
                                    out << table_menus[wg_int_001][wg_int_002][21] << endl;
                                    out << table_menus[wg_int_001][wg_int_002][24] << endl;
                                    out << table_menus[wg_int_001][wg_int_002][26] << endl;
                                    wg_int_002++;
                            }
                    }
                    else
                    {
                            qDebug() << "ERROR FINDING BOUTON ON MENU WHEN SAVING THEME";
                    }

                    wmyfic.close();
            }
            frame_pro->setEnabled(true);
            smenuBar->setEnabled(true);
            frame_editor->setEnabled(true);
            frame_lst_menus->setEnabled(true);
            frame_add_theme->hide();
            QPixmap::grabWidget(screen_designer).save(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Themes/FOLD_" + combo_theme_categorie->currentText() + "/" + txt_new_categorie->text() + "/theme.jpg");
            frame_th_the_idea->f_load_theme();
    }
    else
    {
            QMessageBox::information(this, name_application, tr("Erreur pendant la creation du dossier du theme. Assurez vous qu'aucun autre thème ne porte le même nom."));
            qDebug() << "CAN'T CREATE THEME FOLDER";
    }
}

void mainfrm::f_add_theme_categorie()
{
	bool ok;
	QString namedir = QInputDialog::getText(this, name_application, tr("Donnez un nom a votre categorie"), QLineEdit::Normal, "", &ok);
	if ( ok && !namedir.isEmpty() )
	{
		QDir credir(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Themes/");
		if ( credir.mkpath( "FOLD_" + namedir) == false )
		{
			qDebug() << "ERROR CREATING THEME FOLDER : " << QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Themes/FOLD_" +  namedir;
			QMessageBox::information(this, name_application, tr("Impossible de créer le dossier du theme"));
		}
		else
		{
			// *** CHARGEMENT DE LA COMBO DES RUBRIQUES ***
			QDir tmpdir;
			tmpdir.setPath(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Themes/");
			tmpdir.setSorting(QDir::DirsFirst | QDir::Name);

			QStringList filters;
			filters << "*";
			tmpdir.setNameFilters(filters);

			int wl_int_001 = 0;
			int wl_int_002 = 0;
			combo_theme_categorie->clear();
			foreach (wg_string_001, tmpdir.entryList(QDir::Dirs))
			{
				if ( wg_string_001.mid(0,1) != "." )
				{
					if ( wg_string_001.mid(5,wg_string_001.length()-5) == namedir )
					{
						wl_int_002 = wl_int_001;
					}
					combo_theme_categorie->insertItem(wl_int_001,wg_string_001.mid(5,wg_string_001.length()-5));
					wl_int_001++;
				}
				combo_theme_categorie->setCurrentIndex(wl_int_002);
			}
		}
	}
}

void mainfrm::f_cancel_add_theme()
{
	frame_pro->setEnabled(true);
	smenuBar->setEnabled(true);
	frame_editor->setEnabled(true);
	frame_lst_menus->setEnabled(true);
	frame_add_theme->hide();
}

void mainfrm::f_select_them()
{
	QList<QListWidgetItem *> selectthe = frame_th_the_idea->selectedItems();
	QListWidgetItem *thetxt = new QListWidgetItem;
	thetxt = selectthe.at(0);

	if ( thetxt->statusTip() == "THEME" )
	{
		// *** AFFECTATION DU THEME AU MENU EN COURS ***

		wg_int_001=0;
		while ( table_hdl_menuth[wg_int_001] != hdl_current_menuth && wg_int_001 < nbre_menuth )
		{
			wg_int_001++;
		}

		if ( table_hdl_menuth[wg_int_001] == hdl_current_menuth )
		{
			QString wl_str_005;

			// *** RELEVER L'ENSEMBLE DES CONTROLES ***
			h_regle->raise();
			v_regle->raise();
			frame_lst_menus->raise();

			f_delete_widgetonmenu();

	   		wg_int_002 = thetxt->text().lastIndexOf( '\n' );
	    		if ( wg_int_002 != -1 )
	    		{
				wl_str_005 = thetxt->text().mid(0,wg_int_002);
			}
			else
			{
				wl_str_005 = thetxt->text();
			}

			wg_int_002 = 0;

			QFile wmyfic(frame_th_the_idea->pathname + wl_str_005 + "/theme.txt");

			int wl_int_001;
			int wl_int_002;
			int wl_int_003;
			int wl_int_004;
			int wl_int_005;
			int wl_int_006;
			int wl_int_007;
			int wl_int_008;
			int wl_int_009;
			int wl_int_010;
                        int wl_int_011;
                        int wl_int_012;
                        int wl_int_013;
                        int wl_int_014;

			int wl_isanimated;

			QString wl_str_001;
			QString wl_str_002;
			QString wl_str_003;
			QString wl_str_004;
			QString wl_str_006;
                        QString wl_str_007;
                        QString wl_str_008;
                        QString wl_str_009;

			if ( !wmyfic.open( QIODevice::ReadOnly ))
			{
				qDebug() << "ERROR OPENING THEME IN : " + frame_th_the_idea->pathname + wl_str_005 + "/theme.txt";
				return;
			}
			else
			{
				QByteArray newData;

				current_menu_background = frame_th_the_idea->pathname + wl_str_005 + "/fd.jpg";

				newData = wmyfic.readLine(0);
				wg_string_001 = QString::fromLocal8Bit(newData);
				wg_string_001 = wg_string_001.simplified();
				wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
				if ( wg_string_001.left(8) == "ANIMATED" )
				{
					newData = wmyfic.readLine(0);
					wg_string_001 = QString::fromLocal8Bit(newData);
					wg_string_001 = wg_string_001.simplified();
					wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
					current_menu_background = frame_th_the_idea->pathname + wl_str_005 + "/" + wg_string_001;
					//
                                        /*if ( QFile::copy ( frame_th_the_idea->pathname + wl_str_005 + "/fd.jpg", path_project+"/DVD/TEMP/"+ wg_string_001 + ".jpg") == false )
					{
						qDebug() << "ERROR RECOVERING VIDEO THEME BACKGROUND " + frame_th_the_idea->pathname + wl_str_005 + "/fd.jpg To : " + path_project+"/DVD/TEMP/"+ wg_string_001 + ".jpg";
                                        }*/

                                        QFile wmyficb(path_project + "/ident.sh");

                                        if ( !wmyficb.open( QIODevice::WriteOnly ))
                                        {
                                                qDebug() << "ERROR CREATING BASH EXTRACT LENGTH THEME IN : " + path_project;
                                                return;
                                        }
                                        else
                                        {
                                                QTextStream out2(&wmyficb);
                                                out2 << "mplayer -identify -frames 0 " + current_menu_background << endl;
                                                out2 << "rm -f " + path_project + "/ident.sh" << endl;
                                                out2 << "exit" << endl;
                                                wmyficb.close();

                                                QString programf = "bash";
                                                QStringList argumentsf;
                                                argumentsf << path_project + "/ident.sh";

                                                wg_string_003 = "";

                                                proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
                                                proc_ffmpeg.start(programf,argumentsf);

                                                proc_ffmpeg.waitForFinished(-1);

                                                // *** DUREE DU MEDIA ***
                                                QString media_length = "";
                                                int i = wg_string_003.indexOf("ID_LENGTH=", 0);
                                                if ( i != -1 )
                                                {
                                                        int j = i + 10;
                                                        while ( wg_string_003.mid(j,1) != " " && wg_string_003.mid(j,1) != "." )
                                                        {
                                                                media_length = media_length + wg_string_003.mid(j,1);
                                                                j++;
                                                        }
                                                }
                                                if ( media_length.toInt() > 0 )
                                                {
                                                    loop_length = media_length.toInt();
                                                }
                                        }

					wl_str_002 = wg_string_001;
					//
					wl_isanimated = 1;
					newData = wmyfic.readLine(0);
				}
				else
				{
					wl_isanimated = 0;
				}

				wg_string_001 = QString::fromLocal8Bit(newData);
				wg_string_001 = wg_string_001.simplified();
				wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
				wl_int_008 = wg_string_001.toInt(); // dvdxsize;

				newData = wmyfic.readLine(0); 
				wg_string_001 = QString::fromLocal8Bit(newData);
				wg_string_001 = wg_string_001.simplified();
				wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
				wl_int_009 = wg_string_001.toInt(); // dvdysize

                                newData = wmyfic.readLine(0);
                                wg_string_001 = QString::fromLocal8Bit(newData);
                                wg_string_001 = wg_string_001.simplified();
                                wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
                                wl_int_011 = wg_string_001.toInt(); // scale_current_menu_background

                                newData = wmyfic.readLine(0);
                                wg_string_001 = QString::fromLocal8Bit(newData);
                                wg_string_001 = wg_string_001.simplified();
                                wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
                                wl_str_009 = wg_string_001; // pencil draw
                                current_pencil_draw = wl_str_009;

                                if ( wl_str_009 == "" )
                                {
                                        QPixmap wl_pix_001(dvdxsize,dvdysize);
                                        wl_pix_001.fill(QColor(0,0,0,0));
                                        frame_pencil_draw->setPixmap(wl_pix_001);
                                        frame_support_drawing_menu->draw_user = wl_pix_001.toImage();
                                }
                                else
                                {
                                    if ( QFile::copy ( frame_th_the_idea->pathname + wl_str_005 + "/" + wl_str_009, path_project+"/DVD/SVP/"+ wl_str_009) == false )
                                    {
                                            qDebug() << "ERROR RECOVERING PENCIL SELECT THEME BACKGROUND " + frame_th_the_idea->pathname + wl_str_005 + "/" + wl_str_009;
                                            QPixmap wl_pix_001(dvdxsize,dvdysize);
                                            wl_pix_001.fill(QColor(0,0,0,0));
                                            frame_pencil_draw->setPixmap(wl_pix_001);
                                            frame_support_drawing_menu->draw_user = wl_pix_001.toImage();
                                    }
                                    else
                                    {
                                        QPixmap wl_pix_001(path_project + "/DVD/SVP/" + current_pencil_draw);
                                        frame_pencil_draw->setPixmap(wl_pix_001);
                                        if ( wl_pix_001.width() != dvdxsize || wl_pix_001.height() != dvdysize )
                                        {
                                            frame_support_drawing_menu->draw_user = wl_pix_001.toImage().scaled(dvdxsize,dvdysize);
                                        }
                                        else
                                        {
                                            frame_support_drawing_menu->draw_user = wl_pix_001.toImage();
                                        }
                                    }
                                }

				if ( wl_isanimated == 0 )
				{
					if ( wl_int_008 == dvdxsize && wl_int_009 == dvdysize )
					{
                                                scale_current_menu_background = wl_int_011;
                                                f_generation_scale();
                                                //background_menu->setPixmap(QPixmap(current_menu_background));
					}
					else
					{
                                                scale_current_menu_background = wl_int_011;
						f_generation_scale();
					}
				}
				else
				{

                                            QFile wmyficext;
                                            QTextStream outext(&wmyficext);

                                            wmyficext.setFileName(path_project + "/DVD/GENE/extthum.sh");
                                            wmyficext.open( QIODevice::WriteOnly );
                                            outext << "rm -f " + path_project + "/DVD/TEMP/"+ wl_str_002 + ".jpg" << endl;

                                            outext << "ffmpegthumbnailer -i \"" + frame_th_the_idea->pathname + wl_str_005 + "/" + wl_str_002 + "\" -s " + QString::number(dvdxsize) + " -t 15 -q 10 -o \"" + path_project + "/DVD/TEMP/"+ wl_str_002 + ".jpg\"" << endl;

                                            outext << "rm -f " + path_project + "/DVD/GENE/extthum.sh" << endl;
                                            outext << "exit" << endl;
                                            wmyficext.close();

                                            wg_string_003 = "";
                                            QString programf = "bash";
                                            QStringList argumentsf;
                                            argumentsf << path_project + "/DVD/GENE/extthum.sh";

                                            proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
                                            proc_ffmpeg.start(programf,argumentsf);

                                            proc_ffmpeg.waitForFinished(-1);
                                            scale_current_menu_background = wl_int_011;

                                            QPixmap wl_pix_001(dvdxsize,dvdysize);
                                            wl_pix_001.fill(QColor(0,0,0));

                                            QPixmap wl_pix_002(path_project + "/DVD/TEMP/" + wl_str_002 + ".jpg");

                                            QPixmap wl_pix_003 = wl_pix_002.scaledToWidth(dvdxsize, Qt::FastTransformation);

                                            QPainter p;
                                            p.begin(&wl_pix_001);
                                            p.drawPixmap((wl_pix_001.width() - wl_pix_003.width()) / 2, (wl_pix_001.height() - wl_pix_003.height()) / 2, wl_pix_003 );
                                            p.end();

                                            wl_pix_001.save(path_project + "/DVD/TEMP/" + wl_str_002 + ".jpg");

                                            background_menu->setPixmap(wl_pix_001);
				}

				newData = wmyfic.readLine(0);

				int tabbtorder = 1;

				while ( wmyfic.atEnd() == false )
				{
					wg_string_001 = QString::fromLocal8Bit(newData);
					wg_string_001 = wg_string_001.simplified();
					wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
					wl_int_001 = wg_string_001.toInt(); // *** BTX ***
					newData = wmyfic.readLine(0); 

					wg_string_001 = QString::fromLocal8Bit(newData);
					wg_string_001 = wg_string_001.simplified();
					wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
					wl_int_002 = wg_string_001.toInt(); // *** BTY ***
					newData = wmyfic.readLine(0);

					wg_string_001 = QString::fromLocal8Bit(newData);
					wg_string_001 = wg_string_001.simplified();
					wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
					wl_int_003 = wg_string_001.toInt(); // *** WIDTH ***
					newData = wmyfic.readLine(0);

					wg_string_001 = QString::fromLocal8Bit(newData);
					wg_string_001 = wg_string_001.simplified();
					wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
					wl_int_004 = wg_string_001.toInt(); // *** HEIGHT ***
					newData = wmyfic.readLine(0);

					wg_string_001 = QString::fromLocal8Bit(newData);
					wg_string_001 = wg_string_001.simplified();
					wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
					if ( wg_string_001 != "" )
					{
						wl_str_001 = frame_th_the_idea->pathname + wl_str_005 + "/" + wg_string_001; // *** PATHMASK ***
					}
					else
					{
						wl_str_001 = "";
					}
					newData = wmyfic.readLine(0);

					wg_string_001 = QString::fromLocal8Bit(newData);
					wg_string_001 = wg_string_001.simplified();
					wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
					wl_int_005 = wg_string_001.toInt(); // *** ROTATION ***
					newData = wmyfic.readLine(0);

					wg_string_001 = QString::fromLocal8Bit(newData);
					wg_string_001 = wg_string_001.simplified();
					wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
					wl_int_006 = wg_string_001.toInt(); // *** IMGXSIZE ***
					newData = wmyfic.readLine(0);

					wg_string_001 = QString::fromLocal8Bit(newData);
					wg_string_001 = wg_string_001.simplified();
					wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
					wl_int_007 = wg_string_001.toInt(); // *** IMGYSIZE ***

					newData = wmyfic.readLine(0);
					wg_string_001 = QString::fromLocal8Bit(newData);
					wg_string_001 = wg_string_001.simplified();
					wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
					wl_int_010 = wg_string_001.toInt(); // *** ISLABEL ***

					newData = wmyfic.readLine(0);
					wg_string_001 = QString::fromLocal8Bit(newData);
					wg_string_001 = wg_string_001.simplified();
					wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
					wl_str_003 = wg_string_001; // *** BACKIMAGE ***

					if ( wl_int_008 != dvdxsize || wl_int_009 != dvdysize )
					{
						wl_int_001 = (int)(wl_int_001 * dvdxsize)/(float)wl_int_008;
                                                wl_int_003 = (int)(wl_int_003 * dvdxsize)/(float)wl_int_008;
						//wl_int_006 = (int)(wl_int_006 * dvdxsize)/(float)wl_int_008;
						//wl_int_001 = (int)(wl_int_001 / (float)((float)wl_int_008/(float)dvdxsize));
						//wl_int_003 = (int)(wl_int_003 / (float)((float)wl_int_008/(float)dvdxsize));
                                                wl_int_006 = (int)(wl_int_006 * dvdxsize)/(float)wl_int_008;
	
						wl_int_002 = (int)(wl_int_002 * dvdysize)/(float)wl_int_009;
                                                wl_int_004 = (int)(wl_int_004 * dvdysize)/(float)wl_int_009;
						//wl_int_007 = (int)(wl_int_007 * dvdysize)/(float)wl_int_009;
						//wl_int_002 = (int)(wl_int_002 / (float)((float)wl_int_009/(float)dvdysize));
						//wl_int_004 = (int)(wl_int_004 / (float)((float)wl_int_009/(float)dvdysize));
                                                wl_int_007 = (int)(wl_int_007 * dvdysize)/(float)wl_int_009;
					}

					if ( wl_str_003.mid(0,5) != "$TXT$" && wl_str_003 != "" )
					{
						wl_str_003 = frame_th_the_idea->pathname + wl_str_005 + "/" + wl_str_003;
						//if ( QFile::exists(path_project+"/DVD/TEMP/" +wl_str_003) == true )
						//{
						//	QFile::remove(path_project+"/DVD/TEMP/" +wl_str_003);
						//}

						//if ( QFile::copy ( QDir::currentPath() + "/Bibliotheque/Themes/" + wl_str_005 + "/" + wl_str_003, path_project+"/DVD/TEMP/" +wl_str_003 ) )
						//{
						//	wl_str_003 = path_project+"/DVD/TEMP/" +wl_str_003;
						//}
						//else
						//{
						//	wl_str_003 = "";
						//	qDebug() << "ERROR COPYING IMAGE";
						//}
					}

					newData = wmyfic.readLine(0);
					wg_string_001 = QString::fromLocal8Bit(newData);
					wg_string_001 = wg_string_001.simplified();
					wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
					wl_str_004 = wg_string_001; // *** MASK COLOR ***

					newData = wmyfic.readLine(0);
					wg_string_001 = QString::fromLocal8Bit(newData);
					wg_string_001 = wg_string_001.simplified();
					wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
					wl_str_006 = wg_string_001; // *** SHADOW ***

                                        newData = wmyfic.readLine(0);
                                        wg_string_001 = QString::fromLocal8Bit(newData);
                                        wg_string_001 = wg_string_001.simplified();
                                        wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
                                        wl_str_007 = wg_string_001; // *** DETAIL TEXT ***

                                        newData = wmyfic.readLine(0);
                                        wg_string_001 = QString::fromLocal8Bit(newData);
                                        wg_string_001 = wg_string_001.simplified();
                                        wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
                                        wl_int_012 = wg_string_001.toInt(); // *** SHEARX ***

                                        newData = wmyfic.readLine(0);
                                        wg_string_001 = QString::fromLocal8Bit(newData);
                                        wg_string_001 = wg_string_001.simplified();
                                        wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
                                        wl_int_013 = wg_string_001.toInt(); // *** SHEARY ***

                                        newData = wmyfic.readLine(0);
                                        wg_string_001 = QString::fromLocal8Bit(newData);
                                        wg_string_001 = wg_string_001.simplified();
                                        wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
                                        wl_str_008 = wg_string_001; // *** FONT STYLE ***

                                        newData = wmyfic.readLine(0);
                                        wg_string_001 = QString::fromLocal8Bit(newData);
                                        wg_string_001 = wg_string_001.simplified();
                                        wg_string_001 = wg_string_001.mid(0, newData.count() - 1);
                                        wl_int_014 = wg_string_001.toInt(); // *** FONT SIZE ***

					table_menus[wg_int_001][wg_int_002][0] = QString::number(wl_int_001);
					table_menus[wg_int_001][wg_int_002][1] = QString::number(wl_int_002);
					table_menus[wg_int_001][wg_int_002][2] = QString::number(wl_int_003);
					table_menus[wg_int_001][wg_int_002][3] = QString::number(wl_int_004);
					table_menus[wg_int_001][wg_int_002][6] = wl_str_001;
					table_menus[wg_int_001][wg_int_002][7] = QString::number(wl_int_005);
					table_menus[wg_int_001][wg_int_002][8] = QString::number(wl_int_006);
					table_menus[wg_int_001][wg_int_002][10] = QString::number(wl_int_007);
					table_menus[wg_int_001][wg_int_002][11] = QString::number(wl_int_010);

                                        wl_str_003 = wl_str_003.replace(QString("$-E#"),QString("\n"));

					table_menus[wg_int_001][wg_int_002][4] = wl_str_003;
					table_menus[wg_int_001][wg_int_002][12] = wl_str_006;
					table_menus[wg_int_001][wg_int_002][13] = wl_str_004;
					table_menus[wg_int_001][wg_int_002][14] = "0";
					table_menus[wg_int_001][wg_int_002][15] = QString::number(wg_int_002);
					table_menus[wg_int_001][wg_int_002][16] = QString::number(tabbtorder);
					table_menus[wg_int_001][wg_int_002][17] = QString::number(255);
                                        table_menus[wg_int_001][wg_int_002][18] = wl_str_007;
                                        table_menus[wg_int_001][wg_int_002][19] = "";
                                        table_menus[wg_int_001][wg_int_002][20] = QString::number(wl_int_012);
                                        table_menus[wg_int_001][wg_int_002][21] = QString::number(wl_int_013);
                                        table_menus[wg_int_001][wg_int_002][22] = "";
                                        table_menus[wg_int_001][wg_int_002][23] = "";
                                        table_menus[wg_int_001][wg_int_002][24] = wl_str_008;
                                        table_menus[wg_int_001][wg_int_002][25] = "NA";

                                        if (wl_int_008 != dvdxsize || wl_int_009 != dvdysize)
                                        {
                                                wl_int_014 = (int)(wl_int_014 * dvdysize)/(float)wl_int_009;
                                        }

                                        table_menus[wg_int_001][wg_int_002][26] = QString::number(wl_int_014);

					if ( wl_int_010 == 0 )
					{
						tabbtorder++;
					}
					f_create_menu_movie();

					wg_int_002++;

					newData = wmyfic.readLine(0);
				}
				table_menus[wg_int_001][wg_int_002][0] = "$$$";
				wmyfic.close();
			}

			frame_th_the_idea->clearSelection();
			hdl_current_menu = 0;
                        f_update_thumb_menu();
		}
		else
		{
			qDebug() << "ERROR FINDING HANDLE OF CURRENT MENU WHEN APPLY A THEME";
		}
	}
	else
	{
		// *** PARCOURS DE L'ARBORESCENCE ***
		if ( thetxt->text() != ".." )
		{
			frame_th_the_idea->pathname = QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Themes/FOLD_" + thetxt->text() + "/";
		}
		else
		{
			frame_th_the_idea->pathname = frame_th_the_idea->top_pathname;
		}
		frame_th_the_idea->f_load_theme(); // *** THEMES ***
	}
}

void mainfrm::f_licence(QString licfile)
{
    thread_ani->hdlmsk = mask_interface;
    thread_ani->sens = 1;
    thread_ani->isrender = 0;

    mask_interface->show();
    mask_interface->raise();
    QTimer::singleShot(5, this, SLOT(f_run_ani()));

    QFile file(licfile);
    if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
        return;

    QByteArray line;
    QString wl_tmp = "";
    while (!file.atEnd())
    {
        line = file.readLine(0);
        wl_tmp = wl_tmp + line;
    }

    txt_licence->setPlainText(wl_tmp);

    frame_licence->show();
    frame_licence->raise();
}

void mainfrm::f_close_licence()
{
    thread_ani->hdlmsk = mask_interface;
    thread_ani->sens = 0;
    thread_ani->isrender = 0;

    mask_interface->show();
    mask_interface->raise();
    QTimer::singleShot(5, this, SLOT(f_run_ani()));

    frame_licence->hide();
    smenuBar->setEnabled(true);
}

void mainfrm::f_pack(QString archpath, QString nameth)
{
    this->setDisabled(true);
    QString wmypro = QFileDialog::getSaveFileName(this, tr("Archiver votre theme"), path_save, tr("Theme (*.thm)"));
    if ( wmypro.isNull() )
    {
            this->setEnabled(true);
            return;
    }
    else
    {
        QFile wmyfic(path_project + "/archi.sh");

        if ( !wmyfic.open( QIODevice::WriteOnly ))
        {
                qDebug() << "ERROR CREATING BASH ARCHIVE THEME IN : " + path_project;
                return;
        }
        else
        {
                QTextStream out(&wmyfic);
                out << "cd " + archpath << endl;
                out << "tar cf " + wmypro + " \"" + nameth + "\"" << endl;
                out << "rm -f " + path_project + "/archi.sh" << endl;
                wmyfic.close();

                QString programf = "bash";
                QStringList argumentsf;
                argumentsf << path_project + "/archi.sh";

                proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
                proc_ffmpeg.start(programf,argumentsf);

                proc_ffmpeg.waitForFinished(-1);

                this->setEnabled(true);
            }
    }
}

// *************************
// *** BANDE SON DU MENU ***
// *************************

void mainfrm::f_select_sound()
{
	wg_string_001 = QFileDialog::getOpenFileName(
        	this,
        	tr("Bande son"),
        	path_img_menu,
        	"(*.MP3 *.mp3 *.wav *.WAV *.ogg *.OGG)");
	if ( wg_string_001.isNull() )
	{
	}
	else
	{
		current_menu_audio = wg_string_001;
		is_is_sound->setToolTip(wg_string_001);
		is_is_sound->is_active = 1;
		screen_designer->has_sound = 1;
		is_is_sound->repaint();
	}
}

void mainfrm::f_cancel_sound()
{
	current_menu_audio = "";
	is_is_sound->setToolTip("");
	is_is_sound->is_active = 0;
	screen_designer->has_sound = 0;
	is_is_sound->repaint();
}

// **********************************
// *** INTRODUCTION VIDEO DU MENU ***
// **********************************

void mainfrm::f_select_intro()
{
	wg_string_001 = QFileDialog::getOpenFileName(
        	this,
        	tr("Video d'introduction"),
        	path_img_menu,
        	"(*.MPG *.mpg *.MPEG *.mpeg *.avi *.AVI)");
	if ( wg_string_001.isNull() )
	{
	}
	else
	{
		current_menu_intro = wg_string_001;
		is_is_intro->setToolTip(wg_string_001);
		is_is_intro->is_active = 1;
		screen_designer->has_intro = 1;
		is_is_intro->repaint();
	}
}

void mainfrm::f_cancel_intro()
{
	current_menu_intro = "";
	is_is_intro->setToolTip("");
	is_is_intro->is_active = 0;
	screen_designer->has_intro = 0;
	is_is_intro->repaint();
}

// *** TRANSITION CALCULEE ***
void mainfrm::f_intro_calc()
{
	f_save_widgetonmenu();

	if ( hdl_current_menuth != table_hdl_menuth[0] )
	{
		wg_int_001=0;
		while ( table_hdl_menuth[wg_int_001] != hdl_current_menuth && wg_int_001 < nbre_menuth )
		{
			wg_int_001++;
		}
		if ( table_hdl_menuth[wg_int_001] == hdl_current_menuth )
		{
                        if ( table_menus_property[wg_int_001][0].right(5) != ".MPEG" && table_menus_property[wg_int_001][0].right(5) != ".MPG" && table_menus_property[wg_int_001][0].right(4) != ".mpeg" && table_menus_property[wg_int_001][0].right(4) != ".mpg" && table_menus_property[wg_int_001][0].right(4) != ".AVI" && table_menus_property[wg_int_001][0].right(4) != ".avi" )
			{
                                thread_trans->srcImage2.load(table_menus_property[wg_int_001][0]);
                                thread_trans->srcImage2 = thread_trans->srcImage2.scaled(label_preview_trans->width(),label_preview_trans->height(), Qt::IgnoreAspectRatio, Qt::FastTransformation);
			}
			else
			{
		   		wg_int_002 = table_menus_property[wg_int_001][0].lastIndexOf( '/' );
		    		if ( wg_int_002 != -1 )
		    		{
                                        thread_trans->srcImage2.load(path_project+"/DVD/TEMP/"+table_menus_property[wg_int_001][0].mid(wg_int_002+1,table_menus_property[wg_int_001][0].length()-(wg_int_002+1))+".jpg");
                                        thread_trans->srcImage2 = thread_trans->srcImage2.scaled(label_preview_trans->width(),label_preview_trans->height(), Qt::IgnoreAspectRatio, Qt::FastTransformation);
				}
			}

                        if ( table_menus_property[wg_int_001-1][0].right(5) != ".MPEG" && table_menus_property[wg_int_001-1][0].right(5) != ".mpeg" && table_menus_property[wg_int_001-1][0].right(4) != ".MPG" && table_menus_property[wg_int_001-1][0].right(4) != ".mpg" && table_menus_property[wg_int_001-1][0].right(4) != ".AVI" && table_menus_property[wg_int_001-1][0].right(4) != ".avi" )
			{
                                thread_trans->srcImage.load(table_menus_property[wg_int_001-1][0]);
                                thread_trans->srcImage = thread_trans->srcImage.scaled(label_preview_trans->width(),label_preview_trans->height(), Qt::IgnoreAspectRatio, Qt::FastTransformation);
			}
			else
			{
		   		wg_int_002 = table_menus_property[wg_int_001-1][0].lastIndexOf( '/' );
		    		if ( wg_int_002 != -1 )
		    		{
                                        thread_trans->srcImage.load(path_project+"/DVD/TEMP/"+table_menus_property[wg_int_001-1][0].mid(wg_int_002+1,table_menus_property[wg_int_001-1][0].length()-(wg_int_002+1))+".jpg");
                                        thread_trans->srcImage = thread_trans->srcImage.scaled(label_preview_trans->width(),label_preview_trans->height(), Qt::IgnoreAspectRatio, Qt::FastTransformation);
				}
			}
		}
		else
		{
			QImage wl_img_001(label_preview_trans->width(),label_preview_trans->height(),QImage::Format_ARGB32_Premultiplied);
			wl_img_001.fill(0);
			thread_trans->srcImage2 = wl_img_001;
		}
	}
	else
	{
		QImage wl_img_001(label_preview_trans->width(),label_preview_trans->height(),QImage::Format_ARGB32_Premultiplied);
		wl_img_001.fill(0);
		QPainter p;
		p.begin(&wl_img_001);
		p.setBrush(QColor(0,0,0));
		p.drawRect(0,0,label_preview_trans->width(),label_preview_trans->height());
		p.end();
		thread_trans->srcImage = wl_img_001;

		wg_int_001=0;
                if ( table_menus_property[wg_int_001][0].right(5) != ".MPEG" && table_menus_property[wg_int_001][0].right(5) != ".mpeg" && table_menus_property[wg_int_001][0].right(4) != ".MPG" && table_menus_property[wg_int_001][0].right(4) != ".mpg" && table_menus_property[wg_int_001][0].right(4) != ".AVI" && table_menus_property[wg_int_001][0].right(4) != ".avi" )
		{
                    if ( table_menus_property[wg_int_001][0] == "" )
                    {
                        thread_trans->srcImage2.load(path_project+"/DVD/TEMP/nofd.png");
                        thread_trans->srcImage2 = thread_trans->srcImage2.scaled(label_preview_trans->width(),label_preview_trans->height(), Qt::IgnoreAspectRatio, Qt::FastTransformation);
                    }
                    else
                    {
			thread_trans->srcImage2.load(table_menus_property[wg_int_001][0]);
			thread_trans->srcImage2 = thread_trans->srcImage2.scaled(label_preview_trans->width(),label_preview_trans->height(), Qt::IgnoreAspectRatio, Qt::FastTransformation);
                    }
		}
		else
		{
	   		wg_int_002 = table_menus_property[wg_int_001][0].lastIndexOf( '/' );
	    		if ( wg_int_002 != -1 )
	    		{
				thread_trans->srcImage2.load(path_project+"/DVD/TEMP/"+table_menus_property[wg_int_001][0].mid(wg_int_002+1,table_menus_property[wg_int_001][0].length()-(wg_int_002+1))+".jpg");
				thread_trans->srcImage2 = thread_trans->srcImage2.scaled(label_preview_trans->width(),label_preview_trans->height(), Qt::IgnoreAspectRatio, Qt::FastTransformation);
			}
		}
	}

	must_update = 0;
	lst_transitions->clearSelection();
	if ( current_menu_intro.left(13) == "Transition : " )
	{
		int i = 0;
		int j = 0;

		j = 13;
		wg_string_001 = "";

		while ( current_menu_intro.mid(j,1) != " " )
		{
			wg_string_001 = wg_string_001 + current_menu_intro.mid(j,1);
			j++;
		}
		wg_string_003 = wg_string_001;

		if ( wg_string_001 != "crossfade" )
		{
			thread_trans->srcImage3.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Luma/" + wg_string_001 + ".png");
			thread_trans->srcImage3 = thread_trans->srcImage3.scaled(label_preview_trans->width(),label_preview_trans->height(), Qt::IgnoreAspectRatio, Qt::FastTransformation);
			thread_trans->type_trans = 0;
			check_invert_trans->setEnabled(true);
		}
		else
		{
			thread_trans->type_trans = 1;
			check_invert_trans->setDisabled(true);
		}

	      	i = current_menu_intro.lastIndexOf(" Duree : ");

		wg_string_002 = "";

		if ( i != -1 )
		{
			j = i + 9;
			while ( current_menu_intro.mid(j,1) != " " )
			{
				wg_string_002 = wg_string_002 + current_menu_intro.mid(j,1);
				j++;
			}
			dial_trans_length->setValue(wg_string_002.toInt());
		}
		else
		{
			dial_trans_length->setValue(4);
		}

	      	i = current_menu_intro.lastIndexOf(" Sens : ");

		if ( i != -1 )
		{
			wg_string_002 = "";
			j = i + 8;
			wg_string_002 = wg_string_002 + current_menu_intro.mid(j,1);
			thread_trans->invert = wg_string_002;

			if ( wg_string_002 == "0" )
			{
				check_invert_trans->setChecked(false);
			}
			else
			{
				check_invert_trans->setChecked(true);
			}
		}
		else
		{
			thread_trans->invert = "0";
			check_invert_trans->setChecked(false);
		}
	}
	else
	{
		thread_trans->srcImage3.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Luma/Brule.png");
		thread_trans->srcImage3 = thread_trans->srcImage3.scaled(label_preview_trans->width(),label_preview_trans->height(), Qt::IgnoreAspectRatio, Qt::FastTransformation);
		wg_string_001 = "Brule";
		wg_string_003 = "Brule";
		thread_trans->invert = "0";
	}

	must_update = 1;

	mysynctime.restart();

	path_zik_intro->setText(current_intro_zik);
        thread_trans->sequence = 0;
	thread_trans->dstImage = thread_trans->dstImage.scaled(label_preview_trans->width(),label_preview_trans->height(), Qt::IgnoreAspectRatio, Qt::FastTransformation);
	thread_trans->start();

        /*thread_ani->hdlmsk = mask_interface;
	thread_ani->progress = 2;
	thread_ani->sens = 1;
        thread_ani->isrender = 0;*/
	wg_int_004 = 1;
        /*mask_interface->show();
        mask_interface->raise();*/
        label_23->setText(tr("Duree (secondes) :") + QString::number(dial_trans_length->value()));
	frame_transitions->show();
	frame_transitions->raise();

        smenuBar->setDisabled(true);
        frame_pro->setDisabled(true);
        bottom_menu->setDisabled(true);
        screen_designer->setDisabled(true);
        frame_top_tool->setDisabled(true);

        //QTimer::singleShot(10, this, SLOT(f_run_ani()));
}

void mainfrm::f_valide_intro_calc()
{
	wg_int_004 = 0;
	thread_trans->terminate();

	current_menu_intro = "Transition : " + wg_string_001 + " Duree : " + QString::number(dial_trans_length->value()) + " Sens : " + thread_trans->invert + " ";
	is_is_intro->setToolTip(current_menu_intro);
	is_is_intro->is_active = 1;
	is_is_intro->repaint();

	current_intro_zik = path_zik_intro->text(); 
	screen_designer->has_intro = 1;

        /*thread_ani->hdlmsk = mask_interface;
	thread_ani->progress = 220;
	thread_ani->sens = 0;
	smenuBar->setEnabled(true);
	frame_transitions->hide();
        QTimer::singleShot(5, this, SLOT(f_run_ani()));*/

        smenuBar->setEnabled(true);
        frame_pro->setEnabled(true);
        bottom_menu->setEnabled(true);
        screen_designer->setEnabled(true);
        frame_top_tool->setEnabled(true);
        frame_transitions->hide();
}

void mainfrm::f_cancel_intro_calc()
{
	wg_int_004 = 0;
	thread_trans->terminate();
        /*thread_ani->hdlmsk = mask_interface;
	thread_ani->progress = 220;
	thread_ani->sens = 0;
	smenuBar->setEnabled(true);
	frame_transitions->hide();
        QTimer::singleShot(5, this, SLOT(f_run_ani()));*/

        smenuBar->setEnabled(true);
        frame_pro->setEnabled(true);
        bottom_menu->setEnabled(true);
        screen_designer->setEnabled(true);
        frame_top_tool->setEnabled(true);
        frame_transitions->hide();
}

void mainfrm::f_update_trans()
{
	label_preview_trans->setPixmap(QPixmap::fromImage(thread_trans->dstImage,Qt::AutoColor));
	int wl_islastframe = 0;
	if ( check_invert_trans->isChecked() == false )
	{
		thread_trans->sequence = thread_trans->sequence + 1;
		if ( thread_trans->sequence > 100 ) 
		{
			thread_trans->sequence = 0;
			wl_islastframe = 1;
		}
	}
	else
	{
		thread_trans->sequence = thread_trans->sequence - 1;
		if ( thread_trans->sequence < 0 ) 
		{
			thread_trans->sequence = 100;
			wl_islastframe = 1;
		}
	}

	if ( check_invert_trans->isChecked() == true )
	{
		thread_trans->invert = "2";
	}
	else
	{
		thread_trans->invert = "0";
	}

	if ( wg_string_003 != wg_string_001 )
	{
		if ( wg_string_001 != "crossfade" )
		{
			thread_trans->srcImage3.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Luma/" + wg_string_001 + ".png");
			thread_trans->srcImage3 = thread_trans->srcImage3.scaled(label_preview_trans->width(),label_preview_trans->height(), Qt::IgnoreAspectRatio, Qt::FastTransformation);
			thread_trans->type_trans = 0;
		}
		else
		{
			thread_trans->type_trans = 1;
		}
		wg_string_003 = wg_string_001;
	}

	//int wl_int = 5*dial_trans_length->value();

	if ( wg_int_004 == 1 )
	{
		while ( thread_trans->isRunning() == true )
		{
		}
                wl_wait = mysynctime.elapsed();
		if ( wl_wait < 10*dial_trans_length->value() )
		{
			wl_wait = (10*dial_trans_length->value())-wl_wait;
		}
		else
		{
			wl_wait = 3;
		}
		mysynctime.restart();
		if ( wl_islastframe == 0 )
		{
			QTimer::singleShot(wl_wait, this, SLOT(f_restart_proc_trans()));
		}
		else
		{
			QTimer::singleShot(500, this, SLOT(f_restart_proc_trans()));
		}
	}
}

void mainfrm::f_restart_proc_trans()
{
	thread_trans->start();
}

void mainfrm::f_change_transition(QListWidgetItem* selitem)
{
	if ( must_update == 1 )
	{
		wg_string_001 = selitem->text();
		if ( wg_string_001 == "crossfade" )
		{
			check_invert_trans->setDisabled(true);
		}
		else
		{
			check_invert_trans->setEnabled(true);
		}
	}
}

void mainfrm::f_dial_trans_length(int vallength)
{
    label_23->setText(tr("Duree (secondes) : ") + QString::number(vallength));
}

void mainfrm::f_find_intro_zik()
{
	QString wl_str_001 = QFileDialog::getOpenFileName(
        	this,
        	tr("Bande son"),
        	path_img_menu,
        	"(*.MP3 *.mp3 *.wav *.WAV *.ogg *.OGG)");
	if ( wl_str_001.isNull() )
	{
		path_zik_intro->setText("");
	}
	else
	{
		path_zik_intro->setText(wl_str_001);
	}
}

// **************************************
// *** ACTION POST LECTURE D'UN MEDIA ***
// **************************************

void mainfrm::f_select_quoifaire_after(menu* hdmenu)
{
	combo_quoifaire_aftermedia->clear();
	hdl_current_menu = hdmenu;

	smenuBar->setDisabled(true);

	// *** AJOUT DES MENUS ***
	int wl_int_001 = 0;
	int wl_int_002 = 0;
	
	while ( wl_int_002 < nbre_medias )
	{
		combo_quoifaire_aftermedia->insertItem(wl_int_001,table_hdl_medias[wl_int_002]->pathname_media);
		combo_quoifaire_aftermedia->setItemIcon(wl_int_001, QIcon(table_hdl_medias[wl_int_002]->image));
		wl_int_001++;
		wl_int_002++;
	}
	
	wl_int_002 = 0;
	combo_quoifaire_aftermedia->insertSeparator(wl_int_001);
	wl_int_001++;

	while ( wl_int_002 <= nbre_menuth )
	{
		if ( wl_int_002 > 0 )
		{
			combo_quoifaire_aftermedia->insertItem(wl_int_001,"> " + tr("Menu") + " " + QString::number(wl_int_002));
			combo_quoifaire_aftermedia->setItemIcon(wl_int_001, QIcon(table_hdl_menuth[wl_int_002]->draw_image));
		}
		else
		{
			combo_quoifaire_aftermedia->insertItem(wl_int_001,"> " + wg_str_int_003);
			combo_quoifaire_aftermedia->setItemIcon(wl_int_001, QIcon(table_hdl_menuth[wl_int_002]->draw_image));
		}
		wl_int_001++;
		wl_int_002++;
	}

	// *** CHARGEMENT DE LA PLAYLIST SI ELLE EXISTE ***
	QString	wl_str_001 = hdl_current_menu->quoi_faire;
	QStringList wl_explode = wl_str_001.split("$*$", QString::SkipEmptyParts);

	wl_int_001=0;
	list_after->clear();
	list_after_2->clear();

	for (int i = 0; i < wl_explode.size(); ++i)
	{
		QListWidgetItem *item = new QListWidgetItem(list_after);
		if ( wl_explode.at(i).toLocal8Bit().mid(0,2) == "> " )
		{
			item->setIcon(QIcon(":/Interface/Interface/goto.png"));
		}
		else
		{
			item->setIcon(QIcon(":/Interface/Interface/media.png"));
		}
		//item->setText(wl_explode.at(i).toLocal8Bit().constData());

   		wl_int_001 = wl_explode.at(i).lastIndexOf( '/' );

		if ( wl_int_001 > -1 )
		{
			item->setText(wl_explode.at(i).mid(wl_int_001+1,wl_explode.at(i).length()-(wl_int_001+1)));
		}
		else
		{
			item->setText(wl_explode.at(i));
		}

		QListWidgetItem *item2 = new QListWidgetItem(list_after_2);
		item2->setText(wl_explode.at(i));

	}
        thread_ani->hdlmsk = mask_interface;
        thread_ani->sens = 1;
        thread_ani->isrender = 0;
        mask_interface->show();
        mask_interface->raise();

        QTimer::singleShot(5, this, SLOT(f_run_ani()));
	frame_quoifaire_after->show();
	frame_quoifaire_after->raise();
}

void mainfrm::f_add_quoifaire_media()
{
	if ( list_after->count() < 15 )
	{
		if ( list_after->count() > 0 )
		{
			list_after->selectAll();
			QList<QListWidgetItem*> lst_pla = list_after->selectedItems();
			if ( lst_pla.at(lst_pla.size()-1)->text().mid(0,2) == "> " )
			{
				list_after->clearSelection();
				QMessageBox::information(this, name_application, tr("Dans une playlist aucune action ne peut suivre un saut vers un menu."));
				return;
			}

			list_after->clearSelection();
		}
		QListWidgetItem *item = new QListWidgetItem(list_after);
		if ( combo_quoifaire_aftermedia->currentText().mid(0,2) == "> " )
		{
			item->setIcon(QIcon(":/Interface/Interface/goto.png"));
		}
		else
		{
			item->setIcon(QIcon(":/Interface/Interface/media.png"));
		}

   		int wl_int_001 = combo_quoifaire_aftermedia->currentText().lastIndexOf( '/' );

		if ( wl_int_001 > -1 )
		{
			item->setText(combo_quoifaire_aftermedia->currentText().mid(wl_int_001+1,combo_quoifaire_aftermedia->currentText().length()-(wl_int_001+1)));
		}
		else
		{
			item->setText(combo_quoifaire_aftermedia->currentText());
		}

		QListWidgetItem *item2 = new QListWidgetItem(list_after_2);
		item2->setText(combo_quoifaire_aftermedia->currentText());
	}
	else
	{
		QMessageBox::information(this, name_application, tr("Une playlist peut compter 15 titres au maximum"));
	}
}

void mainfrm::f_delete_quoifaire_media(int row)
{
	list_after_2->takeItem(row);
}

void mainfrm::f_close_quoifaire_media()
{
	int wl_int_001 = 0;

	// *** SAUVEGARDE DE LA PLAYLIST ***
	if ( list_after->count() > 0 )
	{
		QString wl_str_001 = "";
		list_after_2->selectAll();
		QList<QListWidgetItem*> lst_pla = list_after_2->selectedItems();
		while ( wl_int_001 < lst_pla.size() )
		{
			if ( lst_pla.at(wl_int_001)->text() != "" )
			{
				wl_str_001 = wl_str_001 + lst_pla.at(wl_int_001)->text() + "$*$";
			}
			wl_int_001++;
		}
		hdl_current_menu->quoi_faire = wl_str_001.mid(0,wl_str_001.length()-3);
	}
	else
	{
		hdl_current_menu->quoi_faire = "";
	}
        thread_ani->hdlmsk = mask_interface;
        thread_ani->sens = 0;
        thread_ani->isrender = 0;
        mask_interface->show();
        mask_interface->raise();

        QTimer::singleShot(5, this, SLOT(f_run_ani()));
	smenuBar->setEnabled(true);
	frame_quoifaire_after->hide();
}

// **********************************************
// *** FENETRE DE SELECTION DE LA ZONE DU DVD ***
// **********************************************

void mainfrm::f_view_zone()
{
	smenuBar->setDisabled(true);
        thread_ani->hdlmsk = mask_interface;
        thread_ani->sens = 1;
        thread_ani->isrender = 0;
        mask_interface->show();
        mask_interface->raise();

        QTimer::singleShot(5, this, SLOT(f_run_ani()));

	switch(dvdzone)
	{
	case 0:
		bt_zone_0->setChecked(true);
		break;
	case 1:
		bt_zone_1->setChecked(true);
		break;
	case 2:
		bt_zone_2->setChecked(true);
		break;
	case 3:
		bt_zone_3->setChecked(true);
		break;
	case 4:
		bt_zone_4->setChecked(true);
		break;
	case 5:
		bt_zone_5->setChecked(true);
		break;
	case 6:
		bt_zone_6->setChecked(true);
		break;
	}

	frame_mapzone->show();
	frame_mapzone->raise();
}

void mainfrm::f_aff_zone_0()
{
	dvdzone = 0;
}

void mainfrm::f_aff_zone_1()
{
	dvdzone = 1;
}

void mainfrm::f_aff_zone_2()
{
	dvdzone = 2;
}

void mainfrm::f_aff_zone_3()
{
	dvdzone = 3;
}

void mainfrm::f_aff_zone_4()
{
	dvdzone = 4;
}

void mainfrm::f_aff_zone_5()
{
	dvdzone = 5;
}

void mainfrm::f_aff_zone_6()
{
	dvdzone = 6;
}

void mainfrm::f_valide_zone()
{
	smenuBar->setEnabled(true);
        thread_ani->hdlmsk = mask_interface;
        thread_ani->sens = 0;
        thread_ani->isrender = 0;

        QTimer::singleShot(5, this, SLOT(f_run_ani()));
	frame_mapzone->hide();
}

// ******************************************
// *** GESTION DE L'ORDRE DES TABULATIONS ***
// ******************************************

void mainfrm::f_view_tabulation()
{
	if ( frame_organize->isVisible() == false )
	{
		f_save_widgetonmenu();
		//
		frame_pro->setDisabled(true);

		menuProjet->setDisabled(true);
		menuAffichage->setDisabled(true);
		menuG_n_ration->setDisabled(true);
		menuEdition->setDisabled(true);
                menuInsertion->setDisabled(true);
		actionMenu_pr_c_dent->setDisabled(true);
		actionMenu_suivant->setDisabled(true);
		actionCouleurs_des_overlays->setDisabled(true);
		actionParam_tres_avanc_s->setDisabled(true);
		menuA_propos->setDisabled(true);
                actionDessiner_sur_le_menu->setDisabled(true);

		frame_lst_menus->hide();

		// *** CREATION DES DRAPEAUX ***
		int wl_int_001 = 0;
		int wl_maximum = 0;

		while ( wl_int_001 < nbre_menus )
		{
			if ( table_hdl_menus[wl_int_001]->islabel == 0 )
			{
				wl_maximum++;
			}
			wl_int_001++;
		}

		wl_int_001 = 0;

		while ( wl_int_001 < nbre_menus )
		{
			if ( table_hdl_menus[wl_int_001]->islabel == 0 )
			{
				flag *newflag = new flag(frame_organize);
				//connect(newflag, SIGNAL(change_pos() ),this, SLOT(f_change_order_tab()));
				table_hdl_flags[wl_int_001] = newflag;
				newflag->maximum = wl_maximum;
				if ( table_hdl_menus[wl_int_001]->taborder > 0 )
				{
					newflag->position = table_hdl_menus[wl_int_001]->taborder;
				}
				else
				{
					newflag->position = 0;
				}
				newflag->hdlmenu = table_hdl_menus[wl_int_001];
				newflag->setGeometry(table_hdl_menus[wl_int_001]->menu_x,table_hdl_menus[wl_int_001]->menu_y,QPixmap(":/Interface/Interface/sticker_2.png").width(),QPixmap(":/Interface/Interface/sticker_2.png").height());
			}
			else
			{
				table_hdl_flags[wl_int_001] = 0;
			}
			wl_int_001++;
		}

                frame_pro->setDisabled(true);
                bottom_menu->setDisabled(true);

		frame_organize->setGeometry(screen_designer->geometry().x(),screen_designer->geometry().y(),dvdxsize,dvdysize);
		frame_editor->raise();
		frame_organize->show();
		frame_organize->raise();
		label_mouse->show();
		label_mouse->raise();
	}
	else
	{
		// *** RECHERCHE DES DOUBLONS ***
		int wl_int_001 = 0;
		int wl_int_002;
		int wl_error = 0;

		while ( wl_int_001 < nbre_menus )
		{
			wl_int_002 = 0;
			while ( wl_int_002 < nbre_menus )
			{
				if ( wl_int_002 != wl_int_001 )
				{
					if ( table_hdl_flags[wl_int_001] != 0 && table_hdl_flags[wl_int_002] != 0 )
					{
						if ( table_hdl_flags[wl_int_001]->position == table_hdl_flags[wl_int_002]->position )
						{
							wl_error++;
						}
					}
				}
				wl_int_002++;
			}			
			wl_int_001++;
		}
		//
		if ( wl_error == 0 )
		{
			wl_int_001 = 0;

			while ( wl_int_001 < nbre_menus )
			{
				if ( table_hdl_flags[wl_int_001] != 0 )
				{
					table_hdl_flags[wl_int_001]->hdlmenu->taborder = table_hdl_flags[wl_int_001]->position;
				}
				wl_int_001++;
			}

			wl_int_001 = 0;

			while ( wl_int_001 < nbre_menus )
			{
				if ( table_hdl_flags[wl_int_001] != 0 )
				{
					table_hdl_flags[wl_int_001]->close();
				}
				wl_int_001++;
			}

			frame_pro->setEnabled(true);

			menuProjet->setEnabled(true);
			menuAffichage->setEnabled(true);
			menuG_n_ration->setEnabled(true);
			actionMenu_pr_c_dent->setEnabled(true);
			menuEdition->setEnabled(true);
			actionMenu_suivant->setEnabled(true);
                        menuInsertion->setEnabled(true);
			actionCouleurs_des_overlays->setEnabled(true);
			actionParam_tres_avanc_s->setEnabled(true);
			menuA_propos->setEnabled(true);
                        actionDessiner_sur_le_menu->setEnabled(true);

			frame_editor->lower();

			frame_lst_menus->show();
			frame_organize->hide();
			label_mouse->hide();

                        frame_pro->setEnabled(true);
                        bottom_menu->setEnabled(true);
		}
		else
		{
			QMessageBox::information(this, name_application, tr("Plusieurs menus portent le meme ordre de tabulation.\nCorrigez avant de pouvoir valider."));
		}
	}
}

/*void mainfrm::f_change_order_tab()
{
}*/

// ******************************
// *** OUVERTURE DES FICHIERS ***
// ******************************

void mainfrm::f_open_ipreview(QString pathimg)
{
	if ( pathimg.right(4) == ".jpg" || pathimg.right(5) == ".jpeg" || pathimg.right(4) == ".JPG" || pathimg.right(5) == ".JPEG" || pathimg.right(4) == ".png" || pathimg.right(4) == ".PNG" || pathimg.right(4) == ".gif" || pathimg.right(4) == ".GIF" )
	{
		QPixmap wl_pix_001(pathimg);
		QPixmap wl_pix_002(label_preview_image->width(),label_preview_image->height());
		wl_pix_002.fill(QColor(0,0,0,0));
		wl_pix_001 = wl_pix_001.scaledToHeight( label_preview_image->height()-40, Qt::FastTransformation );

		QImage wl_pix_003 = wl_pix_001.copy(0,wl_pix_001.height()-40,wl_pix_001.width(),40).toImage();
		wl_pix_003 = wl_pix_003.mirrored(false,true);
		wl_pix_003 = wl_pix_003.convertToFormat ( QImage::Format_ARGB32_Premultiplied, Qt::AutoColor );

		QPainter p;

		QPainter::CompositionMode mode = (QPainter::CompositionMode)6;

		p.begin(&wl_pix_003);
		p.setCompositionMode ( mode );
		QLinearGradient Gradient(0.0, 0.0,0.0,wl_pix_003.height());
		Gradient.setColorAt(0.0, QColor(0,0,0,60));
		Gradient.setColorAt(0.3, QColor(0,0,0,60));
		Gradient.setColorAt(0.8, QColor(0,0,0,0));
		p.setBrush(Gradient);
		p.drawRect(0, 0, wl_pix_003.width(), wl_pix_003.height());
		p.end();

		p.begin(&wl_pix_002);
		p.drawPixmap(QRect((wl_pix_002.width()-wl_pix_001.width())/2,0,-1,-1),wl_pix_001);
		p.drawImage(QRect((wl_pix_002.width()-wl_pix_001.width())/2,wl_pix_001.height(),-1,-1),wl_pix_003);
		p.end();

		label_preview_image->setPixmap(wl_pix_002);
		label_preview_image->raise();

		frame_preview_image->show();
		frame_preview_image->raise();
	}
	else
	{
                if ( pathimg.right(5) == ".mpeg" || pathimg.right(5) == ".MPEG" || pathimg.right(4) == ".avi" || pathimg.right(4) == ".AVI" || pathimg.right(4) == ".mpg" || pathimg.right(5) == ".mpeg" || pathimg.right(4) == ".MPG" || pathimg.right(5) == ".MPEG" || pathimg.right(4) == ".MP4" || pathimg.right(4) == ".mp4" )
		{
			QFile wmyficext;
			QTextStream outext(&wmyficext);

			wmyficext.setFileName(path_project + "/.imgvid.sh");
			wmyficext.open( QIODevice::WriteOnly );
			outext << "rm -f " + path_project + "/.1.jpg" << endl;
                        outext << "ffmpegthumbnailer -i \"" + pathimg + "\" -s " + QString::number(label_preview_image->width()) + " -t 15 -q 10 -o \"" + path_project + "/.1.jpg\"" << endl;
			outext << "rm -f " + path_project + "/.imgvid.sh" << endl;
			outext << "exit" << endl;
			wmyficext.close();
			QString programf = "bash";
			QStringList argumentsf;
			argumentsf << path_project + "/.imgvid.sh";

		      	proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
			proc_ffmpeg.start(programf,argumentsf);

			proc_ffmpeg.waitForFinished(-1);

			QPixmap wl_pix_001;
			if ( wl_pix_001.load(path_project + "/.1.jpg") == false )
			{
				wl_pix_001.load(":/Interface/Interface/fond_media.png");
			}

			QPixmap wl_pix_002(label_preview_image->width(),label_preview_image->height());
			wl_pix_002.fill(QColor(0,0,0,0));
			wl_pix_001 = wl_pix_001.scaledToHeight( label_preview_image->height()-40, Qt::FastTransformation );

			QImage wl_pix_003 = wl_pix_001.copy(0,wl_pix_001.height()-40,wl_pix_001.width(),40).toImage();
			wl_pix_003 = wl_pix_003.mirrored(false,true);
			wl_pix_003 = wl_pix_003.convertToFormat ( QImage::Format_ARGB32_Premultiplied, Qt::AutoColor );

			QPainter p;

			QPainter::CompositionMode mode = (QPainter::CompositionMode)6;

			p.begin(&wl_pix_003);
			p.setCompositionMode ( mode );
			QLinearGradient Gradient(0.0, 0.0,0.0,wl_pix_003.height());
			Gradient.setColorAt(0.0, QColor(0,0,0,60));
			Gradient.setColorAt(0.3, QColor(0,0,0,60));
			Gradient.setColorAt(0.8, QColor(0,0,0,0));
			p.setBrush(Gradient);
			p.drawRect(0, 0, wl_pix_003.width(), wl_pix_003.height());
			p.end();

			p.begin(&wl_pix_002);
			p.drawPixmap(QRect((wl_pix_002.width()-wl_pix_001.width())/2,0,-1,-1),wl_pix_001);
			p.drawImage(QRect((wl_pix_002.width()-wl_pix_001.width())/2,wl_pix_001.height(),-1,-1),wl_pix_003);
			p.end();

			label_preview_image->setPixmap(wl_pix_002);
			label_preview_image->raise();

			frame_preview_image->show();
			frame_preview_image->raise();
		}
		else
		{
			frame_preview_image->hide();
		}
	}
}

void mainfrm::f_close_ipreview( const QStringList myfile )
{
	frame_pro->setEnabled(true);

	menuProjet->setEnabled(true);
	menuAffichage->setEnabled(true);
	menuMenu->setEnabled(true);
	menuG_n_ration->setEnabled(true);
	menuEdition->setEnabled(true);
	actionMenu_pr_c_dent->setEnabled(true);
	actionMenu_suivant->setEnabled(true);
	actionCouleurs_des_overlays->setEnabled(true);
	actionParam_tres_avanc_s->setEnabled(true);
	menuA_propos->setEnabled(true);
	frame_editor->setEnabled(true);

	frame_lst_menus->show();
	frame_preview_image->hide();

	if ( pntfiled->source == 0 )
	{
		wg_string_001 = myfile.at(0);

		if ( wg_string_001.isNull() )
		{
		}
		else
		{
	   		wg_int_001 = wg_string_001.lastIndexOf( '/' );
	    		if ( wg_int_001 != -1 )
	    		{
				path_background = wg_string_001.mid(0,wg_int_001);
	    		}

                if ( wg_string_001.right(5) != ".MPEG" && wg_string_001.right(5) != ".mpeg" && wg_string_001.right(4) != ".MPG" && wg_string_001.right(4) != ".mpg" && wg_string_001.right(4) != ".AVI" && wg_string_001.right(4) != ".avi" && wg_string_001.right(4) != ".MP4" && wg_string_001.right(4) != ".mp4" )
                {
                        QImage wl_img_001(wg_string_001);

                        if ( (float)((float)wl_img_001.width()/(float)wl_img_001.height()) == (float)dvdxsize/(float)dvdysize )
                        {

                            f_update_thumb_menu();
                        }
                        else
                        {
                            // *** GENERATION DES FORMATS DE SCALE ***
                            QImage wl_img_002;
                            QPixmap wl_pix_001(dvdxsize,dvdysize);
                            wl_pix_001.fill(QColor(0,0,0));
                            if ( wl_img_001.width() > wl_img_001.height() )
                            {
                                wl_img_002 = wl_img_001.scaledToWidth ( dvdxsize, Qt::FastTransformation );
                            }
                            else
                            {
                                wl_img_002 = wl_img_001.scaledToHeight ( dvdysize, Qt::FastTransformation );
                            }

                            // *** SOLUTION 1 ***

                            QPainter p;
                            p.begin(&wl_pix_001);
                            p.drawImage((wl_pix_001.width() - wl_img_002.width()) / 2, (wl_pix_001.height() - wl_img_002.height()) / 2, wl_img_002, 0, 0, -1, -1 );
                            p.end();

                            wg_pix_001 = wl_pix_001;

                            solution_scale_1->pixbu = wl_pix_001.scaledToWidth(300, Qt::FastTransformation);
                            p.begin(&solution_scale_1->pixbu);
                            p.setPen(QColor(255,255,255,200));
                            p.setBrush(QColor(0,0,0,0));
                            p.drawRect(0,0, solution_scale_1->pixbu.width()-1, solution_scale_1->pixbu.height()-1);
                            p.end();

                            wl_pix_001 = solution_scale_1->pixbu;

                            p.begin(&wl_pix_001);
                            p.setPen(Qt::NoPen);
                            p.setBrush(QColor(0,0,0,80));
                            p.drawRect(1,1, solution_scale_1->pixbu.width()-2, solution_scale_1->pixbu.height()-2);
                            p.end();
                            solution_scale_1->pixbt = wl_pix_001;


                            // *** SOLUTION 2 ***

                            wl_pix_001 = wl_pix_001.scaled(dvdxsize,dvdysize,Qt::IgnoreAspectRatio);
                            wl_pix_001.fill(QColor(0,0,0));
                            if ( wl_img_001.width() > wl_img_001.height() )
                            {
                                wl_img_002 = wl_img_001.scaledToHeight ( dvdysize, Qt::FastTransformation );
                            }
                            else
                            {
                                wl_img_002 = wl_img_001.scaledToWidth ( dvdxsize, Qt::FastTransformation );
                            }

                            p.begin(&wl_pix_001);
                            p.drawImage((wl_pix_001.width() - wl_img_002.width()) / 2, (wl_pix_001.height() - wl_img_002.height()) / 2, wl_img_002, 0, 0, -1, -1 );
                            p.end();

                            wg_pix_002 = wl_pix_001;

                            solution_scale_2->pixbu = wl_pix_001.scaledToWidth(300, Qt::FastTransformation);

                            p.begin(&solution_scale_2->pixbu);
                            p.setPen(Qt::SolidLine);
                            p.setPen(QColor(255,255,255,200));
                            p.setBrush(QColor(0,0,0,0));
                            p.drawRect(0,0, solution_scale_2->pixbu.width()-1,solution_scale_2->pixbu.height()-1);
                            p.end();

                            wl_pix_001 = solution_scale_2->pixbu;

                            p.begin(&wl_pix_001);
                            p.setPen(Qt::NoPen);
                            p.setBrush(QColor(0,0,0,80));
                            p.drawRect(1,1, solution_scale_2->pixbu.width()-2, solution_scale_2->pixbu.height()-2);
                            p.end();
                            solution_scale_2->pixbt = wl_pix_001;

                            // *** AFFICHAGE DU CHOIX ***

                            thread_ani->hdlmsk = mask_interface;
                            thread_ani->sens = 1;
                            thread_ani->isrender = 0;
                            mask_interface->show();
                            mask_interface->raise();
                            frame_scale_background->show();
                            frame_scale_background->raise();
                            QTimer::singleShot(5, this, SLOT(f_run_ani()));
                        }
			}
			else
			{
			     	QFile wmyfic(path_project + "/DVD/GENE/extvid.sh");
	
				if ( !wmyfic.open( QIODevice::WriteOnly ))
				{
					qDebug() << "ERROR CREATING FILE FOR EXTRACTING VIDEO : " + path_project + "/DVD/GENE/";
					return;
				}
				else
				{
			   		wg_int_001 = wg_string_001.lastIndexOf( '/' );
			    		if ( wg_int_001 != -1 )
			    		{
						wg_string_004 = wg_string_001.mid(wg_int_001+1,wg_string_001.length()-(wg_int_001+1));

						QTextStream out(&wmyfic);

						current_menu_background = wg_string_001;
						scale_current_menu_background = 0;

						out << "cd " + path_project + "/DVD/TEMP/" << endl;
                                                out << "ffmpegthumbnailer -i \"" + wg_string_001 + "\" -s " + QString::number(dvdxsize) + " -t 15 -q 10 -o \"" + wg_string_004 + ".jpg\"" << endl;
						out << "exit" << endl;
						wmyfic.close();
						QString program = "bash";
						QStringList arguments;
	       					arguments << path_project + "/DVD/GENE/extvid.sh";
					      	thviProcess.setProcessChannelMode(QProcess::MergedChannels);
					      	thviProcess.start(program,arguments);

                                                //

                                                QFile wmyficb(path_project + "/ident.sh");

                                                if ( !wmyficb.open( QIODevice::WriteOnly ))
                                                {
                                                        qDebug() << "ERROR CREATING BASH EXTRACT LENGTH THEME IN : " + path_project;
                                                        return;
                                                }
                                                else
                                                {
                                                        QTextStream out2(&wmyficb);
                                                        out2 << "mplayer -identify -frames 0 " + current_menu_background << endl;
                                                        out2 << "rm -f " + path_project + "/ident.sh" << endl;
                                                        out2 << "exit" << endl;
                                                        wmyficb.close();

                                                        QString programf = "bash";
                                                        QStringList argumentsf;
                                                        argumentsf << path_project + "/ident.sh";

                                                        wg_string_003 = "";

                                                        proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
                                                        proc_ffmpeg.start(programf,argumentsf);

                                                        proc_ffmpeg.waitForFinished(-1);

                                                        // *** DUREE DU MEDIA ***
                                                        QString media_length = "";
                                                        int i = wg_string_003.indexOf("ID_LENGTH=", 0);
                                                        if ( i != -1 )
                                                        {
                                                                int j = i + 10;
                                                                while ( wg_string_003.mid(j,1) != " " && wg_string_003.mid(j,1) != "." )
                                                                {
                                                                        media_length = media_length + wg_string_003.mid(j,1);
                                                                        j++;
                                                                }
                                                        }

                                                        if ( loop_length != media_length.toInt() && media_length.toInt() > 0 )
                                                        {
                                                            QMessageBox msgBox;
                                                            msgBox.setText("2ManDVD");
                                                            msgBox.setInformativeText(tr("La durée de la vidéo sélectionnée ne correspond pas à la durée définie de la boucle du menu. Voulez vous ajuster la durée de boucle du menu à celle de la vidéo importée ?"));
                                                            msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
                                                            msgBox.setDefaultButton(QMessageBox::Yes);
                                                            int ret = msgBox.exec();

                                                            switch (ret) {
                                                                    case QMessageBox::Yes:
                                                                    loop_length = media_length.toInt();
                                                                    break;
                                                                    case QMessageBox::No:
                                                                    break;
                                                            }
                                                        }
                                                }
			    		}			
				}
			}
		}
	}
	else
	{ // *** VIDEO IMAGE DU BOUTON ***
		wg_string_001 = myfile.at(0);
		if ( wg_string_001.isNull() )
		{
		}
		else
		{
	   		wg_int_001 = wg_string_001.lastIndexOf( '/' );
	    		if ( wg_int_001 != -1 )
	    		{
				path_img_menu = wg_string_001.mid(0,wg_int_001);
	    		}

                        //QPixmap wl_pix_001(wg_string_001);
                        hdl_current_menu->charge_image(wg_string_001);
                        /*hdl_current_menu->img_x_size = wl_pix_001.width();
                        hdl_current_menu->img_y_size = wl_pix_001.height();*/
                        hdl_current_menu->back_image=wg_string_001;

                        //if ( wg_string_001.right(5) != ".MPEG" && wg_string_001.right(5) != ".mpeg" &&  wg_string_001.right(4) != ".MPG" && wg_string_001.right(4) != ".mpg" && wg_string_001.right(4) != ".AVI" && wg_string_001.right(4) != ".avi" && wg_string_001.right(4) != ".MP4" && wg_string_001.right(4) != ".mp4" )
                        //{
                            //float wl_ratio = (float)wl_pix_001.width()/(float)wl_pix_001.height();
                            hdl_current_menu->setGeometry(hdl_current_menu->geometry().x(),hdl_current_menu->geometry().y(),hdl_current_menu->width(),hdl_current_menu->height());
                            //hdl_current_menu->repaint();

                            //hdl_current_menu->img_x_size = hdl_current_menu->width();
                            //hdl_current_menu->img_y_size = hdl_current_menu->height();
                        //}

			if ( hdl_current_menu->path_mask != "" )
			{
				hdl_current_menu->charge_mask(hdl_current_menu->path_mask);
			}

                        must_update = 0;
			bttxt->setPlainText("");
			hdl_current_menu->anim_thumb = 0;
			check_anim->setChecked(false);
			must_update = 1;
		}
	}
}

void mainfrm::f_cancel_ipreview()
{
	frame_pro->setEnabled(true);

	menuProjet->setEnabled(true);
	menuAffichage->setEnabled(true);
	menuMenu->setEnabled(true);
	menuG_n_ration->setEnabled(true);
	menuEdition->setEnabled(true);
	actionMenu_pr_c_dent->setEnabled(true);
	actionMenu_suivant->setEnabled(true);
	actionCouleurs_des_overlays->setEnabled(true);
	actionParam_tres_avanc_s->setEnabled(true);
	menuA_propos->setEnabled(true);
	frame_editor->setEnabled(true);

	frame_lst_menus->show();
	frame_preview_image->hide();
}

// ****************************************************************
// *** GENERATION DES THUMBNAILS MEDIA POUR SCALE SUR RENDERING ***
// ****************************************************************

void mainfrm::f_scamedia(media* hdlmed)
{
    QFile wmyfic(path_project + "/DVD/TEMP/extraimg.sh");

    if ( !wmyfic.open( QIODevice::WriteOnly ))
    {
            qDebug() << "ERROR CREATING EXTRACT SCRIPT IN : " + path_project + "/DVD/TEMP/";
            return;
    }
    else
    {
            smenuBar->setDisabled(true);
            QTextStream out(&wmyfic);
            out << "#!/bin/bash" << endl;
            out << "cd " + path_project + "/DVD/TEMP/" << endl;
            out << "ffmpegthumbnailer -i \"" + hdlmed->pathname_media + "\" -s 400 -t 65 -q 10 -o M1.jpg" << endl;
            out << "exit" << endl;
            wmyfic.close();

            hdl_current_media = hdlmed;

            QString program = "bash";
            QStringList arguments;
            arguments << path_project + "/DVD/TEMP/extraimg.sh";
            proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
            proc_ffmpeg.start(program,arguments);

            proc_ffmpeg.waitForFinished(-1);

            QPixmap wl_pix1(path_project + "/DVD/TEMP/M1.jpg");

            QPixmap wl_pix2(400,320);
            wl_pix2.fill(QColor(0,0,0));
            QPixmap wl_pix3(400,320);
            wl_pix3.fill(QColor(0,0,0));
            QPixmap wl_pix4(400,320);
            wl_pix4.fill(QColor(0,0,0));
            QPixmap wl_pix5(400,320);

            QPainter p;
            p.begin(&wl_pix2);

            if ( wl_pix1.width() > wl_pix1.height() )
            {
                p.drawPixmap(0,(320-wl_pix1.height())/2,400,-1,wl_pix1);
            }
            else
            {
                p.drawPixmap((400-wl_pix1.width())/2,0,-1,320,wl_pix1);
            }
            p.setPen(QColor(255,255,255));
            p.drawRect(0,0,399,319);
            p.end();

            p.begin(&wl_pix3);

            if ( wl_pix1.width() > wl_pix1.height() )
            {
                wl_pix4 = wl_pix1.scaledToHeight(320,Qt::FastTransformation);
                p.drawPixmap((400-wl_pix4.width())/2,0,-1,320,wl_pix4);
            }
            else
            {
                wl_pix4 = wl_pix1.scaledToWidth(320,Qt::FastTransformation);
                p.drawPixmap(0,(320-wl_pix4.height())/2,400,-1,wl_pix4);
            }
            p.setPen(QColor(255,255,255));
            p.drawRect(0,0,399,319);
            p.end();

            solution_scale_3->pixbu = wl_pix2;

            p.begin(&wl_pix5);

            p.setPen(QColor(0,0,0,180));
            p.setBrush(QColor(0,0,0,180));
            p.drawPixmap(0,0,-1,-1,wl_pix2);

            //if ( hdlmed->issca != 1 )
            //{
                p.drawRect(1,1,397,317);
            //}

            p.end();

            solution_scale_3->pixbt = wl_pix5;

            solution_scale_4->pixbu = wl_pix3;

            p.begin(&wl_pix5);

            p.setPen(QColor(0,0,0,180));
            p.setBrush(QColor(0,0,0,180));
            p.drawPixmap(0,0,-1,-1,wl_pix3);

            //if ( hdlmed->issca != 2 )
            //{
                p.drawRect(1,1,397,317);
            //}

            p.end();

            solution_scale_4->pixbt = wl_pix5;

            // *** AFFICHAGE DU CHOIX ***
            thread_ani->hdlmsk = mask_interface;
            thread_ani->sens = 1;
            thread_ani->isrender = 0;
            mask_interface->show();
            mask_interface->raise();
            frame_scale_media->show();
            frame_scale_media->raise();
            QTimer::singleShot(5, this, SLOT(f_run_ani()));

    }
}

void mainfrm::f_scamedia_1()
{
    if ( hdl_current_media->issca != 1 )
    {
        hdl_current_media->issca = 1;
        hdl_current_media->isdvd = 0;
        hdl_current_media->already_encode = 0;
    }
    thread_ani->hdlmsk = mask_interface;
    thread_ani->sens = 0;
    thread_ani->isrender = 0;
    frame_scale_media->hide();
    QTimer::singleShot(5, this, SLOT(f_run_ani()));
    smenuBar->setEnabled(true);
}

void mainfrm::f_scamedia_2()
{
    if ( hdl_current_media->issca != 2 )
    {
        hdl_current_media->issca = 2;
        hdl_current_media->isdvd = 0;
        hdl_current_media->already_encode = 0;
    }
    thread_ani->hdlmsk = mask_interface;
    thread_ani->sens = 0;
    thread_ani->isrender = 0;
    frame_scale_media->hide();
    QTimer::singleShot(5, this, SLOT(f_run_ani()));
    smenuBar->setEnabled(true);
}

// *******************************
// *** GESTION DES PREFERENCES ***
// *******************************

void mainfrm::f_open_preferences()
{
	smenuBar->setDisabled(true);
        /*frame_pro->setDisabled(true);
	frame_editor->setDisabled(true);
        frame_lst_menus->hide();*/
	//
        thread_ani->hdlmsk = mask_interface;
        thread_ani->sens = 1;
        thread_ani->isrender = 0;
        mask_interface->show();
        mask_interface->raise();
        QTimer::singleShot(5, this, SLOT(f_run_ani()));
        //
        if ( frame_smile->isVisible() == true )
        {
            cb_aa->setEnabled(true);
            cb_dr->setEnabled(true);
        }
        else
        {
            cb_aa->setDisabled(true);
            cb_dr->setDisabled(true);
        }

	frame_preferences->show();
	frame_preferences->raise();
}

void mainfrm::f_close_preferences()
{
        QDir currentDir = QDir::homePath();
        QFile configfile( currentDir.path() + "/.2mandvd.cnf" );
        if (configfile.open(QIODevice::WriteOnly))
        {
                QTextStream out(&configfile);
                out << line_path_projet->text() << endl;
		if ( checkBox_save_encode->isChecked() == true )
		{
                        out << "1" << endl;
		}
		else
		{
                        out << "0" << endl;
		}
		if ( combo_format_vmax->currentIndex() == 0 )
		{
			out << "2600" << endl;
			wl_vmax = 2600;
		}
		else
		{
			if ( combo_format_vmax->currentIndex() == 1 )
			{
				out << "5000" << endl;
				wl_vmax = 5000;
			}
			else
			{
				out << "9800" << endl;
				wl_vmax = 9800;
                        }
		}
                out << combo_format_audio->currentIndex() << endl;
                out << QString::number(spin_thread->value()) << endl;
                out << QString::number(combo_player->currentIndex()) << endl;
                out << cb_aa->isChecked() << endl;
                out << cb_dr->isChecked() << endl;
                out << QString::number(combo_vmemory->currentIndex()) << endl;
                configfile.close();
        }
	//
        if ( frame_smile->isVisible() == true )
        {
            QMessageBox::information(this, name_application, tr("Vous devez redemarrer l'application pour que les changements prennent effet"));
            frame_preferences->hide();
            mask_interface->hide();
            smenuBar->setEnabled(true);
        }
        else
        {
                smenuBar->setEnabled(true);
                frame_pro->setEnabled(true);
                frame_editor->setEnabled(true);
                frame_lst_menus->show();
                frame_lst_menus->raise();
                //
                frame_preferences->hide();
                thread_ani->hdlmsk = mask_interface;
                thread_ani->sens = 0;
                thread_ani->isrender = 0;
                mask_interface->show();
                mask_interface->raise();
                QTimer::singleShot(5, this, SLOT(f_run_ani()));
        }
}

//
void mainfrm::displayContours( bool state )
{
    int wl_int_001 = 0;
    while ( wl_int_001 < nbre_menus )
    {
            table_hdl_menus[wl_int_001]->iscontours = state;
            table_hdl_menus[wl_int_001]->repaint();
            wl_int_001++;
    }
}

void mainfrm::f_view_contours()
{
    bool newState = actionAfficher_cacher_les_contours->isChecked(); // ! draw_contours;
    userSettings::setDisplayOption( userSettings::DISPLAY_SHAPE, newState );
    displayContours( newState );
    draw_contours = newState;

}

// *********************************************
// *** COPIER / COLLER COULEURS DES PALETTES ***
// *********************************************

void mainfrm::f_triangle_copier(ColorPickerWidget* hdl)
{
    wheel_red = hdl->red;
    wheel_green = hdl->green;
    wheel_blue = hdl->blue;
}

void mainfrm::f_triangle_coller(ColorPickerWidget* hdl)
{
    hdl->setColor(wheel_red,wheel_green,wheel_blue);
}

// *********************************
// *** PREVIEW DES OBJETS ANIMES ***
// *********************************

void mainfrm::f_affhide_anim()
{
    if ( frame_support_preview_anim->isVisible() == true )
    {
        frame_support_preview_anim->hide();
        hdlmov->stop();
    }
    /*else
    {
        QPixmap wl_pix_001(100,100);
        wl_pix_001.fill(QColor(0,0,0,0));
        frame_preview_anim->setPixmap(wl_pix_001);
        frame_support_preview_anim->setGeometry(frame_pro->geometry().x()-150,10,150,150);
        frame_preview_anim->show();
        frame_preview_anim->raise();
    }*/
}

void mainfrm::f_select_item_object(QListWidgetItem *)
{
    if ( frame_smile->isVisible() == true )
    {
        QList<QListWidgetItem *> selectthe = frame_th_ani_smile->selectedItems();
        QListWidgetItem *thetxt = new QListWidgetItem;
        thetxt = selectthe.at(0);
        QPixmap wl_pix_001(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Animations/" + thetxt->text() + ".gif");
        frame_support_preview_anim->setGeometry(frame_toolslide->geometry().x()-(wl_pix_001.width()+60),10,wl_pix_001.width()+20,wl_pix_001.height()+30+label_prev->height());
        label_prev->setGeometry(0,frame_support_preview_anim->height()-10-label_prev->height(),frame_support_preview_anim->width(),label_prev->height());
        frame_preview_anim->setGeometry(10,10,wl_pix_001.width(),wl_pix_001.height());

        QMovie *movie = new QMovie(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Animations/" + thetxt->text() + ".gif");

        frame_preview_anim->setMovie(movie);
        hdlmov = movie;
        movie->start();
        frame_support_preview_anim->show();
        frame_support_preview_anim->raise();
    }
    else
    {
        QList<QListWidgetItem *> selectthe = frame_th_obj_idea->selectedItems();
        QListWidgetItem *thetxt = new QListWidgetItem;
        thetxt = selectthe.at(0);
        QPixmap wl_pix_001(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Animations/" + thetxt->text() + ".gif");
        frame_support_preview_anim->setGeometry(frame_pro->geometry().x()-(wl_pix_001.width()+60),10,wl_pix_001.width()+20,wl_pix_001.height()+30+label_prev->height());
        label_prev->setGeometry(0,frame_support_preview_anim->height()-10-label_prev->height(),frame_support_preview_anim->width(),label_prev->height());
        frame_preview_anim->setGeometry(10,10,wl_pix_001.width(),wl_pix_001.height());

        QMovie *movie = new QMovie(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Animations/" + thetxt->text() + ".gif");

        frame_preview_anim->setMovie(movie);
        hdlmov = movie;
        movie->start();
        frame_support_preview_anim->show();
        frame_support_preview_anim->raise();
    }
}

// ***************************
// *** PEINDRE SUR LE MENU ***
// ***************************

void mainfrm::f_menu_pencil()
{
    f_save_widgetonmenu();
    int wl_int_001=0;
    while ( table_hdl_menuth[wl_int_001] != hdl_current_menuth && wl_int_001 < nbre_menuth )
    {
            wl_int_001++;
    }

    if ( table_hdl_menuth[wl_int_001] == hdl_current_menuth )
    {
        frame_support_drawing_menu->fond_draw = QPixmap::grabWidget(background_menu).toImage();
        background_menu->hide();

        QPixmap wl_pix_001(dvdxsize,dvdysize);
        wl_pix_001.fill(QColor(0,0,0,0));

        QPainter p;
        p.begin(&wl_pix_001);

        int wl_int_002 = 0;
        int sx = 0 ,sy = 0;
        int menu_width = 0 ,menu_height = 0;
        double PI = M_PI;
        double angleradian;

        while ( table_menus[wl_int_001][wl_int_002][0] != "$$$" )
        {
            // *** CALCUL TAILLE AVANT TRANSFORMATIONS ***
            sx = table_hdl_menus[wl_int_002]->shear_value_x;
            sy = table_hdl_menus[wl_int_002]->shear_value_y;

            if ( table_hdl_menus[wl_int_002]->shear_value_x < 0 )
            {
                    sx = table_hdl_menus[wl_int_002]->shear_value_x * -1;
            }

            if ( table_hdl_menus[wl_int_002]->shear_value_y < 0 )
            {
                    sy = table_hdl_menus[wl_int_002]->shear_value_y * -1;
            }

            angleradian = (PI*table_hdl_menus[wl_int_002]->rotation)/180;

            /*if ( table_hdl_menus[wl_int_002]->rotation <= 90 )
            {
                    menu_width = (table_hdl_menus[wl_int_002]->img_x_size * cos(angleradian))+(table_hdl_menus[wl_int_002]->img_y_size * sin(angleradian));
                    menu_height = (table_hdl_menus[wl_int_002]->img_x_size * sin(angleradian))+(table_hdl_menus[wl_int_002]->img_y_size * cos(angleradian));
            }
            else
            {
                    float mcos = cos(angleradian);
                    float msin = sin(angleradian);

                    if ( mcos < 0 )
                    {
                            mcos=mcos*-1;
                    }
                    if ( msin < 0 )
                    {
                            msin=msin*-1;
                    }
                    menu_width = (table_hdl_menus[wl_int_002]->img_x_size * mcos)+(table_hdl_menus[wl_int_002]->img_y_size * msin);
                    menu_height = (table_hdl_menus[wl_int_002]->img_x_size * msin)+(table_hdl_menus[wl_int_002]->img_y_size * mcos);
            }*/
            //p.drawRect(table_hdl_menus[wl_int_002]->geometry().x(),table_hdl_menus[wl_int_002]->geometry().y(),table_hdl_menus[wl_int_002]->width(),table_hdl_menus[wl_int_002]->height());



            if ( table_hdl_menus[wl_int_002]->rotation < 90)
            {
                    menu_width = ((table_hdl_menus[wl_int_002]->img_x_size+sy) * cos(angleradian))+((table_hdl_menus[wl_int_002]->img_y_size+sx) * sin(angleradian));
                    menu_height = ((table_hdl_menus[wl_int_002]->img_y_size+sx) * cos(angleradian))+((table_hdl_menus[wl_int_002]->img_x_size+sy) * sin(angleradian));
            }
            else
            {
                    float mcos = cos(angleradian);
                    float msin = sin(angleradian);

                    if ( mcos < 0 )
                    {
                            mcos=mcos*-1;
                    }
                    if ( msin < 0 )
                    {
                            msin=msin*-1;
                    }
                    menu_width = ((table_hdl_menus[wl_int_002]->img_x_size+sy) * mcos)+((table_hdl_menus[wl_int_002]->img_y_size+sx) * msin);
                    menu_height = ((table_hdl_menus[wl_int_002]->img_x_size+sy) * msin)+((table_hdl_menus[wl_int_002]->img_y_size+sx) * mcos);
            }

            /*menu_x = this->geometry().x()+((this->width()-menu_width)/2);
            menu_y = this->geometry().y()+((this->height()-menu_height)/2);

            this->setGeometry(menu_x,menu_y,menu_width,menu_height);*/

            p.translate(table_hdl_menus[wl_int_002]->geometry().x()+(menu_width/2),table_hdl_menus[wl_int_002]->geometry().y()+(menu_height/2));
            p.rotate(table_hdl_menus[wl_int_002]->rotation);
            p.shear(qreal(table_hdl_menus[wl_int_002]->shear_value_y)/100,qreal(table_hdl_menus[wl_int_002]->shear_value_x)/100);
            p.translate(-(table_hdl_menus[wl_int_002]->geometry().x()+(menu_width/2)),-(table_hdl_menus[wl_int_002]->geometry().y()+(menu_height)/2));
            p.drawPixmap(table_hdl_menus[wl_int_002]->geometry().x()+((table_hdl_menus[wl_int_002]->width()-table_hdl_menus[wl_int_002]->img_x_size)/2),table_hdl_menus[wl_int_002]->geometry().y()+((table_hdl_menus[wl_int_002]->height()-table_hdl_menus[wl_int_002]->img_y_size)/2),table_hdl_menus[wl_int_002]->img_x_size,table_hdl_menus[wl_int_002]->img_y_size,table_hdl_menus[wl_int_002]->draw_image);

            p.resetTransform();

            wl_int_002++;
        }

        p.end();
        frame_support_drawing_menu->bt_draw = wl_pix_001.toImage();

        background_menu->show();

        if ( frame_support_drawing_menu->draw_user.width() < 1 )
        {
            frame_support_drawing_menu->draw_user.load(":/Interface/Interface/reload.png");
            frame_support_drawing_menu->draw_user = frame_support_drawing_menu->draw_user.scaled(frame_support_drawing_menu->fond_draw.width(),frame_support_drawing_menu->fond_draw.height());
            frame_support_drawing_menu->draw_user.fill(0);
        }
        else
        {
            frame_support_drawing_menu->draw_user = frame_support_drawing_menu->draw_user.scaled(frame_support_drawing_menu->fond_draw.width(),frame_support_drawing_menu->fond_draw.height());
        }
        smenuBar->setDisabled(true);
        frame_drawing_menu->show();
        frame_drawing_menu->raise();
    }
    else
    {
        qDebug() << "ERROR FINDING MENU TO LAUNCH PENCIL EDITOR";
    }
}

void mainfrm::f_close_pencil_menu()
{
    QDateTime wl_tnow = QDateTime::currentDateTime();

    int wl_int_001=0;
    while ( table_hdl_menuth[wl_int_001] != hdl_current_menuth && wl_int_001 < nbre_menuth )
    {
            wl_int_001++;
    }

    if ( table_hdl_menuth[wl_int_001] == hdl_current_menuth )
    {
        if ( current_pencil_draw == "" )
        {
            frame_support_drawing_menu->draw_user.save(path_project + "/DVD/SVP/" + wl_tnow.toString("ddMMyyhhmmss") + ".png","PNG");
            current_pencil_draw = wl_tnow.toString("ddMMyyhhmmss") + ".png";
        }
        else
        {
            frame_support_drawing_menu->draw_user.save(path_project + "/DVD/SVP/" + current_pencil_draw,"PNG");
        }
        frame_pencil_draw->setPixmap(path_project + "/DVD/SVP/" + current_pencil_draw);
        f_update_thumb_menu();
    }
    else
    {
        qDebug() << "ERROR SEARCHING MENU FOR SAVING PENCIL DRAW";
    }
    smenuBar->setEnabled(true);
    frame_drawing_menu->hide();
}

void mainfrm::f_cancel_pencil_menu()
{
    if ( current_pencil_draw != "" )
    {
        QPixmap wl_pix_001(path_project + "/DVD/SVP/" + current_pencil_draw);
        frame_pencil_draw->setPixmap(wl_pix_001);
        frame_support_drawing_menu->draw_user = wl_pix_001.toImage();
    }

    smenuBar->setEnabled(true);
    frame_drawing_menu->hide();
}

void mainfrm::f_tool_pencil_1()
{
    frame_support_drawing_menu->tool = 0;
}

void mainfrm::f_tool_pencil_2()
{
    frame_support_drawing_menu->tool = 1;
}

void mainfrm::f_tool_pencil_3()
{
    frame_support_drawing_menu->tool = 2;
}

void mainfrm::f_tool_pencil_4()
{
    frame_support_drawing_menu->tool = 3;
}

void mainfrm::f_tool_pencil_5()
{
    frame_support_drawing_menu->tool = 4;
}

void mainfrm::f_tool_pencil_6()
{
    frame_support_drawing_menu->draw_user.fill(0);
    frame_support_drawing_menu->repaint();
}

void mainfrm::f_tool_pencil_7()
{
    QString wl_path = QFileDialog::getOpenFileName(
            this,
            tr("Image"),
            "",
            "(*.png *.PNG *.jpg *.JPG *.jpeg *.JPEG)");
    if ( wl_path.isNull() )
    {
            tool_pencil_7->setChecked(false);
            tool_pencil_1->setChecked(true);
            frame_support_drawing_menu->tool = 0;
    }
    else
    {
        frame_support_drawing_menu->pixy = QPixmap(wl_path);
        frame_support_drawing_menu->tool = 5;
    }
}

void mainfrm::f_pencil_brush_width(int val)
{
    frame_support_drawing_menu->brush_width = val;
}

void mainfrm::f_valide_color_pencil()
{
    frame_support_drawing_menu->pencil_color.setRgb(pntwheel6->red,pntwheel6->green,pntwheel6->blue);
    frame_support_drawing_menu->pencil_color.setAlpha(frame_support_drawing_menu->opacity);
}

void mainfrm::f_pencil_brush_opacity(int val)
{
    frame_support_drawing_menu->opacity = val;
    frame_support_drawing_menu->pencil_color.setRgb(pntwheel6->red,pntwheel6->green,pntwheel6->blue);
    frame_support_drawing_menu->pencil_color.setAlpha(frame_support_drawing_menu->opacity);
}

void mainfrm::f_valide_color_pencil_2()
{
    frame_support_drawing_menu->pencil_color_2.setRgb(pntwheel7->red,pntwheel7->green,pntwheel7->blue);
    frame_support_drawing_menu->pencil_color_2.setAlpha(frame_support_drawing_menu->opacity_2);
}

void mainfrm::f_pencil_brush_opacity_2(int val)
{
    frame_support_drawing_menu->opacity_2 = val;
    frame_support_drawing_menu->pencil_color_2.setRgb(pntwheel7->red,pntwheel7->green,pntwheel7->blue);
    frame_support_drawing_menu->pencil_color_2.setAlpha(frame_support_drawing_menu->opacity_2);
}

void mainfrm::f_pencil_check_bt(int)
{
    if ( pencil_check_bt->isChecked() == true )
    {
        frame_support_drawing_menu->is_bt = 1;
    }
    else
    {
        frame_support_drawing_menu->is_bt = 0;
    }
    frame_support_drawing_menu->repaint();
}

void mainfrm::f_pencil_check_bt_2(int)
{
    if ( pencil_check_bt_2->isChecked() == true )
    {
        frame_support_drawing_menu->is_round = 1;
    }
    else
    {
        frame_support_drawing_menu->is_round = 0;
    }
}
