/* ============================================================
 * File  : menu.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "menu.h"

menu::menu ( QWidget * parent )
    : QLabel(parent)
{
	this->setAttribute(Qt::WA_DeleteOnClose);
        this->setAttribute(Qt::WA_TranslucentBackground, true);

        //this->setMouseTracking(true);
	this->setScaledContents(false);
        //this->setAcceptDrops(true);
	//
	alpha_menu = 255;
	menu_x = 100;
	menu_y = 100;
	menu_width = 128;
	menu_height = 128;
	img_x_size = 128;
	img_y_size = 128;
	rotation = 0;
        rotation2 = 0;
	shear_value_x = 0;
	shear_value_y = 0;
	shadow = 2;
	shadow_angle = 0;
	shadow_opacity = 255;
	shadow_color = "0^0^0^";
        font_size = 12;
	shift_press = 0;
	tool = 2;
	is_select = 0;
	isovermask = 0;
	back_image = "";
	path_mask = "";
	quoi_faire = "";
        wg_str_001 = "";
	PI = M_PI;
	pos_cx = 0;
	pos_cy = 0;
	radius0 = 0;
	radius1 = 0;
	teta0 = 0.0;
	teta1 = 0.0;
	isgrab = 0;
	zindex = 9999;
	anim_thumb = 0;
	color_mask_over = "";
	audio_track = "";
	quoi_overlay = "";
	pos_thumb = "NA";
        is_magnetic = 0;

	isbold=false;
	isitalic=false;
	isunderline=false;
	isalign=1;

	//
	action_supprimer = new QAction(tr("Supprimer le bouton"), this);
	action_supprimer->setIcon ( QIcon(":/Interface/Interface/trash.png") );
	action_customize = new QAction(tr("Customiser le masque"), this);
	action_customize->setIcon ( QIcon(":/Interface/Interface/customize.png") );
	action_charger_image = new QAction(tr("Charger une image"), this);
	action_charger_image->setIcon ( QIcon(":/Interface/Interface/finder.png") );
	action_charger_image_video = new QAction(tr("Image de la video associee"), this);
	action_charger_image_video->setIcon ( QIcon(":/Interface/Interface/media.png") );
	action_envoi_premier = new QAction(tr("Envoyer au premier plan"), this);
	action_envoi_premier->setIcon ( QIcon(":/Interface/Interface/front.png") );
	action_envoi_dernier = new QAction(tr("Envoyer a l'arriere plan"), this);
	action_envoi_dernier->setIcon ( QIcon(":/Interface/Interface/back.png") );
	action_copy = new QAction(tr("Copier le bouton"), this);
	action_copy->setIcon ( QIcon(":/Interface/Interface/copy.png") );
	action_goto = new QAction(tr("Se rendre au menu"), this);
	action_goto->setIcon ( QIcon(":/Interface/Interface/goto.png") );

	action_tobt = new QAction(tr("Transformer en boutton"), this);
	action_tobt->setIcon ( QIcon(":/Interface/Interface/default_bt.png") );

	action_halign = new QAction(tr("Aligner sur la regle horizontale"), this);
	action_halign->setIcon ( QIcon(":/Interface/Interface/hruler.png") );
	action_valign = new QAction(tr("Aligner sur la regle verticale"), this);
	action_valign->setIcon ( QIcon(":/Interface/Interface/vruler.png") );
	action_talign = new QAction(tr("Aligner horizontal et vertical"), this);
	action_talign->setIcon ( QIcon(":/Interface/Interface/equerre.png") );

	action_quoifaire = new QAction(tr("Action apres lecture"), this);
	action_quoifaire->setIcon ( QIcon(":/Interface/Interface/quoifaire.png") );

	action_editoverlay = new QAction(tr("Editer les overlays"), this);
	action_editoverlay->setIcon ( QIcon(":/Interface/Interface/pencil.png") );

	action_adjust = new QAction(tr("Ajuster la boucle video"), this);
        action_adjust->setIcon ( QIcon(":/Interface/Interface/media3.png") );

	connect(action_supprimer, SIGNAL(triggered()), this, SLOT(supprimer()));
	connect(action_customize, SIGNAL(triggered()), this, SLOT(customize()));
	connect(action_charger_image, SIGNAL(triggered()), this, SLOT(charge_image_call()));
	connect(action_charger_image_video, SIGNAL(triggered()), this, SLOT(charge_image_video_call()));
	connect(action_envoi_premier, SIGNAL(triggered()), this, SLOT(f_front()));
	connect(action_envoi_dernier, SIGNAL(triggered()), this, SLOT(f_back()));
	connect(action_copy, SIGNAL(triggered()), this, SLOT(f_copy()));
	connect(action_goto, SIGNAL(triggered()), this, SLOT(f_goto()));

	connect(action_halign, SIGNAL(triggered()), this, SLOT(f_halign()));
	connect(action_valign, SIGNAL(triggered()), this, SLOT(f_valign()));
	connect(action_talign, SIGNAL(triggered()), this, SLOT(f_talign()));

	connect(action_quoifaire, SIGNAL(triggered()), this, SLOT(f_quoifaire()));
	connect(action_editoverlay, SIGNAL(triggered()), this, SLOT(f_editoverlay()));
	connect(action_tobt, SIGNAL(triggered()), this, SLOT(f_tobt()));

	connect(action_adjust, SIGNAL(triggered()), this, SLOT(f_adjust()));

        myeffect = new QGraphicsOpacityEffect();
        myeffect->setOpacity(0.0);
        this->setAttribute(Qt::WA_TranslucentBackground, true);
        this->setGraphicsEffect(myeffect);
}

void menu::f_static_show()
{
    QPropertyAnimation *animation = new QPropertyAnimation(myeffect, "opacity");
    animation->setDuration(300);
    animation->setStartValue(0.0);
    animation->setEndValue(1.0);
    //animation->setEasingCurve(QEasingCurve::InOutCubic);
    animation->start();
}

void menu::f_adjust()
{
	emit adjust(this);
}

void menu::f_tobt()
{
	emit tobt(this);
}

void menu::f_editoverlay()
{
	emit editoverlay(this);
}

void menu::f_quoifaire()
{
	emit quoifaire(this);
}

void menu::f_halign()
{
	emit halign(this);
}

void menu::f_valign()
{
	emit valign(this);
}

void menu::f_talign()
{
	emit talign(this);
}

void menu::f_goto()
{
	emit goto_menu(this);
}

void menu::f_copy()
{
	emit copy_menu(this);
}

void menu::f_front()
{
	emit go_front(this);
}

void menu::f_back()
{
	emit go_lower(this);
}

void menu::charge_image_call()
{
	emit call_charge_image();
}

void menu::charge_image_video_call()
{
	emit call_charge_image_video();
}

void menu::set_opacity(int value)
{
        alpha_menu = value;
        QImage wl_image;

        if ( back_image.mid(0,5) == "$TXT$" )
        {
            wl_image = original.toImage();
        }
        else
        {
            wl_image = original.toImage().scaled(img_x_size,img_y_size,Qt::IgnoreAspectRatio,Qt::FastTransformation);
        }

        wl_image = wl_image.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor );
	QColor trtcolor;
	QRgb srcPixel;
	int x;
	int y;
	for (y = 0; y < wl_image.height(); y++)
	{
		for (x = 0; x < wl_image.width(); x++)
		{
			srcPixel = wl_image.pixel(x, y);
			trtcolor = srcPixel;
			if ( qAlpha(srcPixel) > 0 )
			{
				if ( (value*qAlpha(srcPixel))/255 >=0 && (value*qAlpha(srcPixel))/255 < 256 )
				{
					trtcolor.setAlpha((value*qAlpha(srcPixel))/255);
					//trtcolor.setAlpha(value);
				}
				else
				{
					if ( (value*qAlpha(srcPixel))/255 < 0 )
					{
						trtcolor.setAlpha(0);
					}
					else
					{
						trtcolor.setAlpha(255);
					}
				}
				wl_image.setPixel(x, y, trtcolor.rgba());
			}
		}
	}
        draw_image = QPixmap::fromImage( wl_image );
}

void menu::charge_image(QString pathname)
{
    if (pathname != "EXT_VIDEO_EXT")
    {
            if ( pathname != "" )
            {
                    if ( pathname.right(5) != ".MPEG" && pathname.right(5) != ".mpeg" && pathname.right(4) != ".MPG" && pathname.right(4) != ".mpg" && pathname.right(4) != ".AVI" && pathname.right(4) != ".avi" )
                    {
                            draw_image.load(pathname);
                            if ( draw_image.width() <= 500 )
                            {
                                    original = draw_image;
                            }
                            else
                            {
                                    if ( draw_image.width() > draw_image.height() )
                                    {
                                            original = draw_image.scaledToWidth(500, Qt::FastTransformation);
                                    }
                                    else
                                    {
                                            original = draw_image.scaledToHeight(400, Qt::FastTransformation);
                                    }
                            }
                            if ( img_x_size < img_y_size )
                            {
                                draw_image = draw_image.scaledToWidth(img_x_size, Qt::FastTransformation);
                                img_y_size = draw_image.height();
                            }
                            else
                            {
                                draw_image = draw_image.scaledToHeight(img_y_size, Qt::FastTransformation);
                                img_x_size = draw_image.width();
                            }
                            if ( pos_thumb == "NA" )
                            {
                                anim_thumb = 0;
                            }
                            else
                            {
                                anim_thumb = 1;
                            }
                    }
                    else
                    {
                            QFile wmyficext;
                            QTextStream outext(&wmyficext);
                            QDir currentDir = QDir::homePath();

                            wmyficext.setFileName( currentDir.path() + "/.extthum.sh");
                            wmyficext.open( QIODevice::WriteOnly );
                            outext << "cd " + currentDir.path() << endl;
                            outext << "ffmpegthumbnailer -i \"" + pathname + "\" -t 15 -s 400 -q 10 -o \".tmp2m.jpg\"" << endl;
                            outext << "rm -f .extthum.sh" << endl;
                            outext << "exit" << endl;
                            wmyficext.close();

                            QString programf = "bash";
                            QStringList argumentsf;
                            argumentsf << currentDir.path() + "/.extthum.sh";

                            proc_ffmpeg_m.setProcessChannelMode(QProcess::MergedChannels);
                            proc_ffmpeg_m.start(programf,argumentsf);

                            proc_ffmpeg_m.waitForFinished(-1);

                            draw_image.load(currentDir.path() + "/.tmp2m.jpg");
                            if ( draw_image.width() <= 500 )
                            {
                                    original = draw_image;
                            }
                            else
                            {
                                    if ( draw_image.width() > draw_image.height() )
                                    {
                                            original = draw_image.scaledToWidth(500, Qt::FastTransformation);
                                    }
                                    else
                                    {
                                            original = draw_image.scaledToHeight(400, Qt::FastTransformation);
                                    }
                            }
                            if ( img_x_size < img_y_size )
                            {
                                draw_image = draw_image.scaledToWidth(img_x_size, Qt::FastTransformation);
                                img_y_size = draw_image.height();
                            }
                            else
                            {
                                draw_image = draw_image.scaledToHeight(img_y_size, Qt::FastTransformation);
                                img_x_size = draw_image.width();
                            }

                            draw_image = draw_image.scaled(img_x_size, img_y_size, Qt::IgnoreAspectRatio,Qt::FastTransformation);
                            anim_thumb = 1;
                    }
            }
            else
            {
                    draw_image.load(":/Interface/Interface/default_bt.png");
                    original = draw_image;
                    img_x_size = draw_image.width();
                    img_y_size = draw_image.height();
                    draw_image = draw_image.scaled(img_x_size, img_y_size, Qt::IgnoreAspectRatio,Qt::FastTransformation);
            }
    }

    int sx = shear_value_x;
    int sy = shear_value_y;

    if ( shear_value_x < 0 )
    {
            sx = shear_value_x * -1;
    }

    if ( shear_value_y < 0 )
    {
            sy = shear_value_y * -1;
    }

    angleradian = (PI*rotation)/180;

    if ( rotation <= 90)
    {
            menu_width = ((img_x_size+sy) * cos(angleradian))+((img_y_size+sx) * sin(angleradian));
            menu_height = ((img_y_size+sx) * cos(angleradian))+((img_x_size+sy) * sin(angleradian));
    }
    else
    {
            float mcos = cos(angleradian);
            float msin = sin(angleradian);

            if ( mcos < 0 )
            {
                    mcos=mcos*-1;
            }
            if ( msin < 0 )
            {
                    msin=msin*-1;
            }
            menu_width = ((img_x_size+sy) * mcos)+((img_y_size+sx) * msin);
            menu_height = ((img_x_size+sy) * msin)+((img_y_size+sx) * mcos);
    }
    if ( alpha_menu < 255 )
    {
            set_opacity(alpha_menu);
    }
    this->setGeometry(menu_x,menu_y,menu_width,menu_height);
}

void menu::reload_charge_image(QString pathname)
{
	if (pathname != "EXT_VIDEO_EXT")
	{
		if ( pathname != "" )
		{
                        if ( pathname.right(5) != ".MPEG" && pathname.right(5) != ".mpeg" && pathname.right(4) != ".MPG" && pathname.right(4) != ".mpg" && pathname.right(4) != ".AVI" && pathname.right(4) != ".avi" )
			{
				draw_image.load(pathname);
				if ( draw_image.width() <= 500 )
				{
					original = draw_image;
				}
				else
				{
					if ( draw_image.width() > draw_image.height() )
					{
						original = draw_image.scaledToWidth(500, Qt::FastTransformation);
					}
					else
					{
						original = draw_image.scaledToHeight(400, Qt::FastTransformation);
					}
				}
                                if ( img_x_size < img_y_size )
                                {
                                    draw_image = draw_image.scaledToWidth(img_x_size, Qt::FastTransformation);
                                    img_y_size = draw_image.height();
                                }
                                else
                                {
                                    draw_image = draw_image.scaledToHeight(img_y_size, Qt::FastTransformation);
                                    img_x_size = draw_image.width();
                                }
                                if ( pos_thumb == "NA" )
                                {
                                    anim_thumb = 0;
                                }
                                else
                                {
                                    anim_thumb = 1;
                                }
			}
			else
			{
				QFile wmyficext;
				QTextStream outext(&wmyficext);
			        QDir currentDir = QDir::homePath();

				wmyficext.setFileName( currentDir.path() + "/.extthum.sh");
				wmyficext.open( QIODevice::WriteOnly );
				outext << "cd " + currentDir.path() << endl;
                                outext << "ffmpegthumbnailer -i \"" + pathname + "\" -t 15 -s 400 -q 10 -o \".tmp2m.jpg\"" << endl;
				outext << "rm -f .extthum.sh" << endl;
				outext << "exit" << endl;
				wmyficext.close();

				QString programf = "bash";
				QStringList argumentsf;
				argumentsf << currentDir.path() + "/.extthum.sh";

			      	proc_ffmpeg_m.setProcessChannelMode(QProcess::MergedChannels);
				proc_ffmpeg_m.start(programf,argumentsf);

				proc_ffmpeg_m.waitForFinished(-1);

				draw_image.load(currentDir.path() + "/.tmp2m.jpg");
				if ( draw_image.width() <= 500 )
				{
					original = draw_image;
				}
				else
				{
					if ( draw_image.width() > draw_image.height() )
					{
						original = draw_image.scaledToWidth(500, Qt::FastTransformation);
					}
					else
					{
						original = draw_image.scaledToHeight(400, Qt::FastTransformation);
					}
				}
                                if ( img_x_size < img_y_size )
                                {
                                    draw_image = draw_image.scaledToWidth(img_x_size, Qt::FastTransformation);
                                    img_y_size = draw_image.height();
                                }
                                else
                                {
                                    draw_image = draw_image.scaledToHeight(img_y_size, Qt::FastTransformation);
                                    img_x_size = draw_image.width();
                                }

				draw_image = draw_image.scaled(img_x_size, img_y_size, Qt::IgnoreAspectRatio,Qt::FastTransformation);
				anim_thumb = 1;
			}
		}
		else
		{
			draw_image.load(":/Interface/Interface/default_bt.png");
			original = draw_image;
                        img_x_size = draw_image.width();
                        img_y_size = draw_image.height();
			draw_image = draw_image.scaled(img_x_size, img_y_size, Qt::IgnoreAspectRatio,Qt::FastTransformation);
		}
	}

	int sx = shear_value_x;
	int sy = shear_value_y;

	if ( shear_value_x < 0 )
	{
		sx = shear_value_x * -1;
	}

	if ( shear_value_y < 0 )
	{
		sy = shear_value_y * -1;
	}

        angleradian = (PI*rotation)/180;

	if ( rotation <= 90)
	{              
                menu_width = ((img_x_size+sy) * cos(angleradian))+((img_y_size+sx) * sin(angleradian));
                menu_height = ((img_y_size+sx) * cos(angleradian))+((img_x_size+sy) * sin(angleradian));
	}
	else
	{ 
		float mcos = cos(angleradian);
		float msin = sin(angleradian);

		if ( mcos < 0 )
		{
			mcos=mcos*-1;
		}
		if ( msin < 0 )
		{
			msin=msin*-1;
		}
                menu_width = ((img_x_size+sy) * mcos)+((img_y_size+sx) * msin);
                menu_height = ((img_x_size+sy) * msin)+((img_y_size+sx) * mcos);
	}

	//menu_x = this->geometry().x();
	//menu_y = this->geometry().y();

	//menu_width = menu_width+(sx*3);
	//menu_height = menu_height+(sy*3);
        /*if ( menu_width >= menu_height )
	{
		menu_width = menu_width+((float)sx*((float)1.2*((float)menu_width/(float)menu_height)));
		menu_height = menu_height+((float)sy*((float)1.2*((float)menu_width/(float)menu_height)));
	}
	else
	{
		menu_width = menu_width+((float)sx*((float)1.2*((float)menu_height/(float)menu_width)));
		menu_height = menu_height+((float)sy*((float)1.2*((float)menu_height/(float)menu_width)));
        }*/

	if ( alpha_menu < 255 )
	{
		set_opacity(alpha_menu);
	}
        //this->setGeometry(menu_x,menu_y,menu_width,menu_height);
}

void menu::charge_mask(QString pathname)
{
        mask.fill(QColor(0,0,0,0));
        if ( mask.load(pathname) == true )
	{
                draw_image = original.scaled( draw_image.width(), draw_image.height(), Qt::IgnoreAspectRatio, Qt::FastTransformation );
                //set_opacity(alpha_menu);
		QPixmap wl_pix_001(720,(float)720/(float)((float)draw_image.width() / (float)draw_image.height()));

		QPixmap wl_pix_002;

		if ( mask.width() > mask.height() )
		{
			wl_pix_002 = mask.scaledToWidth( 720, Qt::FastTransformation );
			if ( wl_pix_002.height() > wl_pix_001.height() )
			{
				wl_pix_002 = wl_pix_002.scaledToHeight( wl_pix_001.height(), Qt::FastTransformation );
			}
		}
		else
		{
			wl_pix_002 = mask.scaledToHeight( wl_pix_001.height(), Qt::FastTransformation );
			if ( wl_pix_002.width() > wl_pix_001.width() )
			{
				wl_pix_002 = wl_pix_002.scaledToWidth( wl_pix_001.width(), Qt::FastTransformation );
			}
		}

		wl_pix_001.fill(QColor(0,0,0,0));

		QPainter p;
		p.begin(&wl_pix_001);
		p.drawPixmap ( QRect((wl_pix_001.width()-wl_pix_002.width())/2,(wl_pix_001.height()-wl_pix_002.height())/2,-1,-1),wl_pix_002 );
		p.end();

		original_mask = wl_pix_001;

		wl_pix_001 = wl_pix_001.scaled( draw_image.width(), draw_image.height(), Qt::IgnoreAspectRatio, Qt::FastTransformation );

                if ( alpha_menu < 255 )
		{
			set_opacity(alpha_menu);
                }

		isovermask = 0;
	      	int i = pathname.lastIndexOf("/");
		if ( i != -1 )
		{
			QString wl_str_001 = pathname.mid(0,i) + "/2t_" + pathname.mid(i+1,pathname.length()-(i+1));

			if ( over_mask.load(wl_str_001) == true )
			{
                                QImage wl_image = draw_image.toImage();
                                wl_image = wl_image.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor );

                                QImage wl_image_2 = wl_pix_001.toImage();
                                wl_image_2 = wl_image_2.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied

                                QPainter g;

                                QPainter::CompositionMode mode = (QPainter::CompositionMode)6;

                                g.begin(&wl_image);
                                g.setCompositionMode ( mode );
                                g.drawImage(QRect(0,0,-1,-1),wl_image_2);
                                g.end();

                                wl_pix_002 = over_mask.scaled( wl_pix_002.width(), wl_pix_002.height(), Qt::IgnoreAspectRatio );

                                QPixmap wl_pix_003(720,(float)720/(float)((float)draw_image.width() / (float)draw_image.height()));

                                wl_pix_003.fill(QColor(0,0,0,0));

                                p.begin(&wl_pix_003);
                                p.drawPixmap ( QRect((wl_pix_003.width()-wl_pix_002.width())/2,(wl_pix_003.height()-wl_pix_002.height())/2,-1,-1),wl_pix_002 );
                                p.end();

                                // *** MUTATION DES COULEURS OVER MASK ***

                                if ( color_mask_over != "" )
                                {
                                        QImage wlimg = wl_pix_003.toImage();
                                        QStringList wl_explode = color_mask_over.split("$",QString::KeepEmptyParts);
                                        int lumi = 0;
                                        int rouge = wl_explode.at(0).toInt();
                                        int vert = wl_explode.at(1).toInt();
                                        int bleu = wl_explode.at(2).toInt();
                                        int valueadd_R = 0;
                                        int valueadd_V = 0;
                                        int valueadd_B = 0;
                                        int opacity = wl_explode.at(3).toInt();
                                        QRgb srcPixel;
                                        QColor trtcolor;
                                        //
                                        for (int y = 0; y < wlimg.height(); y++)
                                        {
                                                for (int x = 0; x < wlimg.width(); x++)
                                                {
                                                        srcPixel = wlimg.pixel(x, y);
                                                        trtcolor = srcPixel;
                                                        //
                                                        if (qAlpha(srcPixel) > 1 )
                                                        {
                                                                //
                                                                valueadd_R = lumi + rouge; //+ ac_r;
                                                                valueadd_V = lumi + vert; //+ ac_v;
                                                                valueadd_B = lumi + bleu; // + ac_b;
                                                                //

                                                                if ( valueadd_R > 0 )
                                                                {
                                                                        if ( trtcolor.red() < 255 - valueadd_R)
                                                                        {
                                                                                trtcolor.setRed(trtcolor.red() + valueadd_R);
                                                                        }
                                                                        else
                                                                        {
                                                                                trtcolor.setRed(255);
                                                                        }
                                                                }
                                                                else
                                                                {
                                                                        if ( trtcolor.red() > (valueadd_R*-1))
                                                                        {
                                                                                trtcolor.setRed(trtcolor.red() + valueadd_R);
                                                                        }
                                                                        else
                                                                        {
                                                                                trtcolor.setRed(0);
                                                                        }
                                                                }

                                                                if ( valueadd_V > 0 )
                                                                {
                                                                        if ( trtcolor.green() < 255 - valueadd_V)
                                                                        {
                                                                                trtcolor.setGreen(trtcolor.green() + valueadd_V);
                                                                        }
                                                                        else
                                                                        {
                                                                                trtcolor.setGreen(255);
                                                                        }
                                                                }
                                                                else
                                                                {
                                                                        if ( trtcolor.green() > (valueadd_V*-1))
                                                                        {
                                                                                trtcolor.setGreen(trtcolor.green() + valueadd_V);
                                                                        }
                                                                        else
                                                                        {
                                                                                trtcolor.setGreen(0);
                                                                        }
                                                                }

                                                                if ( valueadd_B > 0 )
                                                                {
                                                                        if ( trtcolor.blue() < 255 - valueadd_B)
                                                                        {
                                                                                trtcolor.setBlue(trtcolor.blue() + valueadd_B);
                                                                        }
                                                                        else
                                                                        {
                                                                                trtcolor.setBlue(255);
                                                                        }
                                                                }
                                                                else
                                                                {
                                                                        if ( trtcolor.blue() > (valueadd_B*-1))
                                                                        {
                                                                                trtcolor.setBlue(trtcolor.blue() + valueadd_B);
                                                                        }
                                                                        else
                                                                        {
                                                                                trtcolor.setBlue(0);
                                                                        }
                                                                }
                                                                //
                                                                trtcolor.setAlpha(opacity);
                                                                wlimg.setPixel(x, y, trtcolor.rgba());
                                                        }
                                                }
                                        }
                                        wl_pix_003 = QPixmap::fromImage(wlimg,Qt::AutoColor);
                                }
                                //

                                over_mask = wl_pix_003;
                                wl_pix_003 = wl_pix_003.scaled( draw_image.width(), draw_image.height(), Qt::IgnoreAspectRatio, Qt::FastTransformation );

                                QPainter::CompositionMode mode2 = (QPainter::CompositionMode)0;

                                p.begin(&wl_image);
                                p.setCompositionMode ( mode2 );
                                p.drawPixmap(QRect(0,0,-1,-1),wl_pix_003);
                                p.end();

                                draw_image = QPixmap::fromImage( wl_image, Qt::AutoColor );

                                isovermask = 1;
                                path_over_mask = wl_str_001;
			}
			else
			{
				// *** MASK SPECIAL SANS OVERMASK ***
				QImage wl_image = draw_image.toImage();
				wl_image = wl_image.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor );

				QImage wl_image_2 = wl_pix_001.toImage();
				wl_image_2 = wl_image_2.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied

				QPainter g;

				QPainter::CompositionMode mode = (QPainter::CompositionMode)6;

				g.begin(&wl_image);
				g.setCompositionMode ( mode );
				g.drawImage(QRect(0,0,-1,-1),wl_image_2);
				g.end();
				draw_image = QPixmap::fromImage( wl_image, Qt::AutoColor );
				path_over_mask = "";
				over_mask.fill(QColor(0,0,0,0));
			}
		}
		path_mask = pathname;
		this->repaint();
	}
	else
	{
		qDebug() << "ERROR LOADING MASK : " << pathname;
	}
}

void menu::mouseMoveEvent(QMouseEvent *event)
{
	if (!(event->buttons() & Qt::LeftButton)) return;

	if ( isgrab == 0 )
	{
		isgrab = 1;
		emit cache_navi(this);
	}

	if ( tool == 2 ) // *** MOVE ***
	{
		move(event->globalPos().x() - dragPosition.x(),event->globalPos().y() - dragPosition.y());
		menu_x = event->globalPos().x() - dragPosition.x();
                menu_y = event->globalPos().y() - dragPosition.y();

                if ( is_magnetic == 1 )
                {
                    if (menu_x%10 != 0 || menu_y%10 != 0)
                    {
                        menu_x = menu_x + (10-(menu_x%10));
                        menu_y = menu_y + (10-(menu_y%10));
                        this->setGeometry(menu_x,menu_y,this->width(),this->height());
                    }
                }
	}
	else
	{
		if ( tool == 1 ) // *** ROTATION ***
		{
                        centerpos.setX((event->globalPos().x()-event->pos().x())+(this->width()/2));
                        centerpos.setY((event->globalPos().y()-event->pos().y())+(this->height()/2));

                        pos_cx = centerpos.x();
			pos_cy = centerpos.y();

                        p1 = event->globalPos();
                        radius1 = getDist(p1, centerpos);
			teta1 = getTeta(p1, radius1);

                        rotation=rotation2-((teta1-teta0)*180/PI);
			if ( rotation < 0 )
			{
				rotation = 360 + rotation;
			}

			angleradian = (PI*rotation)/180;

			int sx = shear_value_x;
			int sy = shear_value_y;

			if ( shear_value_x < 0 )
			{
				sx = shear_value_x * -1;
			}

			if ( shear_value_y < 0 )
			{
				sy = shear_value_y * -1;
			}

                        if ( rotation < 90)
                        {
                                menu_width = ((img_x_size+sy) * cos(angleradian))+((img_y_size+sx) * sin(angleradian));
                                menu_height = ((img_y_size+sx) * cos(angleradian))+((img_x_size+sy) * sin(angleradian));
                        }
			else
			{ 
				float mcos = cos(angleradian);
				float msin = sin(angleradian);

				if ( mcos < 0 )
				{
					mcos=mcos*-1;
				}
				if ( msin < 0 )
				{
					msin=msin*-1;
				}
                                menu_width = ((img_x_size+sy) * mcos)+((img_y_size+sx) * msin);
                                menu_height = ((img_x_size+sy) * msin)+((img_y_size+sx) * mcos);
                        }

                        menu_x = this->geometry().x()+((this->width()-menu_width)/2);
                        menu_y = this->geometry().y()+((this->height()-menu_height)/2);

                        this->setGeometry(menu_x,menu_y,menu_width,menu_height);
		}
		else
		{  
			if ( tool == 0 ) // *** SCALE ***
			{
                                if ( back_image.left(5) == "$TXT$" )
                                {
                                    if ( event->globalPos().y() - oldpos.y() < 0 )
                                    {
                                        emit rsc_txt(1);
                                    }
                                    else
                                    {
                                        emit rsc_txt(2);
                                    }
                                    oldpos.setX(event->globalPos().x());
                                    oldpos.setY(event->globalPos().y());

                                    emit change_position(this);
                                    return;
                                }

				if ( shift_press == 1 || back_image.left(5) == "$TXT$" )
				{
					// *** RESCALE PROPORTIONNEL ***
					if ( event->globalPos().y() - oldpos.y() < 0 )
					{
						if ( img_x_size < 1500 && img_y_size < 500 )
						{
							img_x_size=img_x_size+4;
							img_y_size=img_y_size+4;
						}
					}
					else
					{
						if ( img_x_size > 60 && img_y_size > 60 )
						{
							img_x_size=img_x_size-4;
							img_y_size=img_y_size-4;
						}
					}

					draw_image = original.scaled(img_x_size,img_y_size,Qt::IgnoreAspectRatio,Qt::FastTransformation);

					if ( alpha_menu < 255 )
					{
						set_opacity(alpha_menu);
					}

					angleradian = (PI*rotation)/180;

                                        int sx = shear_value_x;
                                        int sy = shear_value_y;

                                        if ( shear_value_x < 0 )
                                        {
                                                sx = shear_value_x * -1;
                                        }

                                        if ( shear_value_y < 0 )
                                        {
                                                sy = shear_value_y * -1;
                                        }

                                        if ( rotation < 90)
                                        {
                                                menu_width = ((img_x_size+sy) * cos(angleradian))+((img_y_size+sx) * sin(angleradian));
                                                menu_height = ((img_y_size+sx) * cos(angleradian))+((img_x_size+sy) * sin(angleradian));
                                        }
                                        else
                                        {
                                                float mcos = cos(angleradian);
                                                float msin = sin(angleradian);

                                                if ( mcos < 0 )
                                                {
                                                        mcos=mcos*-1;
                                                }
                                                if ( msin < 0 )
                                                {
                                                        msin=msin*-1;
                                                }
                                                menu_width = ((img_x_size+sy) * mcos)+((img_y_size+sx) * msin);
                                                menu_height = ((img_x_size+sy) * msin)+((img_y_size+sx) * mcos);
                                        }

                                        menu_x = this->geometry().x()+((this->width()-menu_width)/2);
                                        menu_y = this->geometry().y()+((this->height()-menu_height)/2);

                                        this->setGeometry(menu_x,menu_y,menu_width,menu_height);

					if ( path_mask != "" )
					{
						if ( isovermask == 1 )
						{
                                                        mask = original_mask.scaled( draw_image.width(), draw_image.height(), Qt::IgnoreAspectRatio, Qt::FastTransformation );
                                                        draw_image.setMask(mask.mask());

                                                        QImage wl_image = draw_image.toImage();
                                                        wl_image = wl_image.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor );

                                                         QPainter::CompositionMode mode2 = (QPainter::CompositionMode)0;

                                                        QPainter p;

                                                        p.begin(&wl_image);
                                                        p.setCompositionMode ( mode2 );
                                                        p.drawPixmap(QRect(0,0,-1,-1),over_mask.scaled( draw_image.width(), draw_image.height(), Qt::IgnoreAspectRatio, Qt::FastTransformation ));
                                                        p.end();

                                                        draw_image = QPixmap::fromImage( wl_image, Qt::AutoColor );
                                                }
                                                else
						{
							// *** MASK SPECIAL SANS OVERMASK ***
							QImage wl_image = draw_image.toImage();
							wl_image = wl_image.convertToFormat ( QImage::Format_ARGB32_Premultiplied, Qt::AutoColor );

							mask = original_mask.scaled( draw_image.width(), draw_image.height(), Qt::IgnoreAspectRatio, Qt::FastTransformation );
							QImage wl_image_2 = mask.toImage();
							wl_image_2 = wl_image_2.convertToFormat ( QImage::Format_ARGB32_Premultiplied, Qt::AutoColor );

							QPainter g;

							QPainter::CompositionMode mode = (QPainter::CompositionMode)6;

							g.begin(&wl_image);
							g.setCompositionMode ( mode );
							g.drawImage(QRect(0,0,-1,-1),wl_image_2);
							g.end();
							draw_image = QPixmap::fromImage( wl_image, Qt::AutoColor );
						}
					}
				}
				else
				{
					// *** RESCALE NON PROPORTIONNEL ***
					if ( event->globalPos().x() - oldpos.x() > 0 )
					{
						img_x_size = img_x_size + 4;
					}
					else
					{
						if ( event->globalPos().x() - oldpos.x() < 0 )
						{
							img_x_size = img_x_size - 4;
						}
					}
					if ( event->globalPos().y() - oldpos.y() > 0 )
					{
						img_y_size = img_y_size + 4;
					}
					else
					{
						if ( event->globalPos().y() - oldpos.y() < 0 )
						{
							img_y_size = img_y_size - 4;
						}
					}

					if ( img_y_size > 500 )
					{
						img_y_size = 500;
					}

					if ( img_y_size < 60 )
					{
						img_y_size = 60;
					}

					if ( img_x_size > 1500 )
					{
						img_x_size = 1500;
					}

					if ( img_x_size < 60 )
					{
						img_x_size = 60;
					}

					draw_image = original.scaled(img_x_size,img_y_size,Qt::IgnoreAspectRatio,Qt::FastTransformation);

					if ( alpha_menu < 255 )
					{
						set_opacity(alpha_menu);
					}

                                        angleradian = (PI*rotation)/180;

                                        int sx = shear_value_x;
                                        int sy = shear_value_y;

                                        if ( shear_value_x < 0 )
                                        {
                                                sx = shear_value_x * -1;
                                        }

                                        if ( shear_value_y < 0 )
                                        {
                                                sy = shear_value_y * -1;
                                        }

                                        if ( rotation < 90)
                                        {
                                                menu_width = ((img_x_size+sy) * cos(angleradian))+((img_y_size+sx) * sin(angleradian));
                                                menu_height = ((img_y_size+sx) * cos(angleradian))+((img_x_size+sy) * sin(angleradian));
                                        }
                                        else
                                        {
                                                float mcos = cos(angleradian);
                                                float msin = sin(angleradian);

                                                if ( mcos < 0 )
                                                {
                                                        mcos=mcos*-1;
                                                }
                                                if ( msin < 0 )
                                                {
                                                        msin=msin*-1;
                                                }
                                                menu_width = ((img_x_size+sy) * mcos)+((img_y_size+sx) * msin);
                                                menu_height = ((img_x_size+sy) * msin)+((img_y_size+sx) * mcos);
                                        }

                                        menu_x = this->geometry().x()+((this->width()-menu_width)/2);
                                        menu_y = this->geometry().y()+((this->height()-menu_height)/2);

                                        this->setGeometry(menu_x,menu_y,menu_width,menu_height);

					if ( path_mask != "" )
					{
						if ( isovermask == 1 )
						{
                                                        mask = original_mask.scaled( draw_image.width(), draw_image.height(), Qt::IgnoreAspectRatio, Qt::FastTransformation );
                                                        draw_image.setMask(mask.mask());

                                                        QImage wl_image = draw_image.toImage();
                                                        wl_image = wl_image.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor );

                                                        QPainter::CompositionMode mode2 = (QPainter::CompositionMode)0;

                                                        QPainter p;

                                                        p.begin(&wl_image);
                                                        p.setCompositionMode ( mode2 );
                                                        p.drawPixmap(QRect(0,0,-1,-1),over_mask.scaled( draw_image.width(), draw_image.height(), Qt::IgnoreAspectRatio, Qt::FastTransformation ));
                                                        p.end();

                                                        draw_image = QPixmap::fromImage( wl_image, Qt::AutoColor );
						}
						else
						{
							// *** MASK SPECIAL SANS OVERMASK ***
							QImage wl_image = draw_image.toImage();
							wl_image = wl_image.convertToFormat ( QImage::Format_ARGB32_Premultiplied, Qt::AutoColor );

							mask = original_mask.scaled( draw_image.width(), draw_image.height(), Qt::IgnoreAspectRatio, Qt::FastTransformation );
							QImage wl_image_2 = mask.toImage();
							wl_image_2 = wl_image_2.convertToFormat ( QImage::Format_ARGB32_Premultiplied, Qt::AutoColor );

							QPainter g;

							QPainter::CompositionMode mode = (QPainter::CompositionMode)6;

							g.begin(&wl_image);
							g.setCompositionMode ( mode );
							g.drawImage(QRect(0,0,-1,-1),wl_image_2);
							g.end();
							draw_image = QPixmap::fromImage( wl_image, Qt::AutoColor );
						}
					}
				}
			}
			else
			{
				// *** SHEAR ***
				if ( shift_press == 1 )
				{
					if ( event->globalPos().x() - oldpos.x() < 0 )
					{
						if ( shear_value_y < 100 )
						{
							shear_value_y++;
						}
					}
					else
					{
						if ( event->globalPos().x() - oldpos.x() > 0 )
						{
							if ( shear_value_y > -100 )
							{
								shear_value_y--;
							}
						}
					}
				}
				else
				{
					if ( event->globalPos().y() - oldpos.y() < 0 )
					{
						if ( shear_value_x < 100 )
						{
							shear_value_x++;
						}
					}
					else
					{
						if ( event->globalPos().y() - oldpos.y() > 0 )
						{
							if ( shear_value_x > -100 )
							{
								shear_value_x--;
							}
						}
					}
				}

                                angleradian = (PI*rotation)/180;

                                int sx = shear_value_x;
                                int sy = shear_value_y;

                                if ( shear_value_x < 0 )
                                {
                                        sx = shear_value_x * -1;
                                }

                                if ( shear_value_y < 0 )
                                {
                                        sy = shear_value_y * -1;
                                }

                                if ( rotation < 90)
                                {
                                        menu_width = ((img_x_size+sy) * cos(angleradian))+((img_y_size+sx) * sin(angleradian));
                                        menu_height = ((img_y_size+sx) * cos(angleradian))+((img_x_size+sy) * sin(angleradian));
                                }
                                else
                                {
                                        float mcos = cos(angleradian);
                                        float msin = sin(angleradian);

                                        if ( mcos < 0 )
                                        {
                                                mcos=mcos*-1;
                                        }
                                        if ( msin < 0 )
                                        {
                                                msin=msin*-1;
                                        }
                                        menu_width = ((img_x_size+sy) * mcos)+((img_y_size+sx) * msin);
                                        menu_height = ((img_x_size+sy) * msin)+((img_y_size+sx) * mcos);
                                }

                                menu_x = this->geometry().x()+((this->width()-menu_width)/2);
                                menu_y = this->geometry().y()+((this->height()-menu_height)/2);

                                this->setGeometry(menu_x,menu_y,menu_width,menu_height);

			}
		}
	}

	oldpos.setX(event->globalPos().x());
	oldpos.setY(event->globalPos().y());

	emit change_position(this);
}

void menu::mousePressEvent ( QMouseEvent * event ) 
{
	dragPosition = event->globalPos() - frameGeometry().topLeft();
        centerpos.setX((event->globalPos().x()-event->pos().x())+(this->width()/2));
        centerpos.setY((event->globalPos().y()-event->pos().y())+(this->height()/2));

	pos_cx = centerpos.x();
	pos_cy = centerpos.y();

	rotation2 = rotation;

	p0 = event->globalPos();
	radius0 = getDist(p0, centerpos);
	teta0 = getTeta(p0, radius0);

	oldpos.setX(event->x());
	oldpos.setY(event->y());
	emit select_menu(this);
}

void menu::change_cursor()
{
        if ( tool == 0 )
        {
                QCursor mycursor ( QPixmap(":/Interface/Interface/zoom.png"), -1, -1 );
                this->setCursor(mycursor);
        }
        else
        {
                if ( tool == 1 )
                {
                        QCursor mycursor ( QPixmap(":/Interface/Interface/rotate.png"), -1, -1 );
                        this->setCursor(mycursor);
                }
                else
                {
                        if ( tool == 2 )
                        {
                                QCursor mycursor ( QPixmap(":/Interface/Interface/grab.png"), -1, -1 );
                                this->setCursor(mycursor);
                        }
                        else
                        {
                                QCursor mycursor ( QPixmap(":/Interface/Interface/shear.png"), -1, -1 );
                                this->setCursor(mycursor);
                        }
                }
        }
}

void menu::enterEvent ( QEvent * ) 
{
	if ( is_select == 1 )
	{
		if ( tool == 0 )
		{ 
			QCursor mycursor ( QPixmap(":/Interface/Interface/zoom.png"), -1, -1 );
			this->setCursor(mycursor);
		}
		else
		{
			if ( tool == 1 )
			{ 
				QCursor mycursor ( QPixmap(":/Interface/Interface/rotate.png"), -1, -1 );
				this->setCursor(mycursor);
			}
			else
			{
				if ( tool == 2 )
				{ 
					QCursor mycursor ( QPixmap(":/Interface/Interface/grab.png"), -1, -1 );
					this->setCursor(mycursor);
				}
				else
				{
					QCursor mycursor ( QPixmap(":/Interface/Interface/shear.png"), -1, -1 );
					this->setCursor(mycursor);
				}
			}
		}
	}
	else
	{
		this->unsetCursor();
	}

	if ( isgrab == 0 && islabel == 0 )
	{
		emit affiche_navi(this);
	}
}

void menu::leaveEvent ( QEvent * ) 
{
	emit cache_navi(this);
}

void menu::mouseReleaseEvent ( QMouseEvent * ) 
{
	isgrab = 0;
	emit release_menu(this);
	if ( islabel == 0 )
	{
		emit affiche_navi(this);
	}
        /*if ( back_image.left(5) == "$TXT$" )
	{
		emit has_scale(this);
        }*/
}

void menu::wheelEvent( QWheelEvent *event )
{
    if ( isgrab == 0 )
    {
            isgrab = 1;
            emit cache_navi(this);
    }

    if ( back_image.left(5) == "$TXT$" )
    {
        if ( event->delta() > 0 )
        {
            emit rsc_txt(1);
        }
        else
        {
            emit rsc_txt(2);
        }
        oldpos.setX(event->globalPos().x());
        oldpos.setY(event->globalPos().y());

        emit change_position(this);
        return;
    }
    int sx = shear_value_x;
    int sy = shear_value_y;

    if ( shear_value_x < 0 )
    {
            sx = shear_value_x * -1;
    }

    if ( shear_value_y < 0 )
    {
            sy = shear_value_y * -1;
    }

            // *** RESCALE PROPORTIONNEL ***
            if ( event->delta() > 0 )
            {
                    if ( img_x_size < 1500 && img_y_size < 500 )
                    {
                            img_x_size=img_x_size+4;
                            img_y_size=img_y_size+4;
                    }
            }
            else
            {
                    if ( img_x_size > 60 && img_y_size > 60 )
                    {
                            img_x_size=img_x_size-4;
                            img_y_size=img_y_size-4;
                    }
            }

            draw_image = original.scaled(img_x_size,img_y_size,Qt::IgnoreAspectRatio,Qt::FastTransformation);

            if ( alpha_menu < 255 )
            {
                    set_opacity(alpha_menu);
            }

            angleradian = (PI*rotation)/180;

            if ( rotation < 90)
            {
                    menu_width = ((img_x_size+sy) * cos(angleradian))+((img_y_size+sx) * sin(angleradian));
                    menu_height = ((img_y_size+sx) * cos(angleradian))+((img_x_size+sy) * sin(angleradian));
            }
            else
            {
                    float mcos = cos(angleradian);
                    float msin = sin(angleradian);

                    if ( mcos < 0 )
                    {
                            mcos=mcos*-1;
                    }
                    if ( msin < 0 )
                    {
                            msin=msin*-1;
                    }
                    menu_width = ((img_x_size+sy) * mcos)+((img_y_size+sx) * msin);
                    menu_height = ((img_x_size+sy) * msin)+((img_y_size+sx) * mcos);
            }

            menu_x = this->geometry().x()+((this->width()-menu_width)/2);
            menu_y = this->geometry().y()+((this->height()-menu_height)/2);

            this->setGeometry(menu_x,menu_y,menu_width,menu_height);

            if ( path_mask != "" )
            {
                    if ( isovermask == 1 )
                    {
                            mask = original_mask.scaled( draw_image.width(), draw_image.height(), Qt::IgnoreAspectRatio, Qt::FastTransformation );
                            draw_image.setMask(mask.mask());

                            QImage wl_image = draw_image.toImage();
                            wl_image = wl_image.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor );

                            QPainter::CompositionMode mode2 = (QPainter::CompositionMode)0;

                            QPainter p;

                            p.begin(&wl_image);
                            p.setCompositionMode ( mode2 );
                            p.drawPixmap(QRect(0,0,-1,-1),over_mask.scaled( draw_image.width(), draw_image.height(), Qt::IgnoreAspectRatio, Qt::FastTransformation ));
                            p.end();

                            draw_image = QPixmap::fromImage( wl_image, Qt::AutoColor );
                    }
                    else
                    {
                            // *** MASK SPECIAL SANS OVERMASK ***
                            QImage wl_image = draw_image.toImage();
                            wl_image = wl_image.convertToFormat ( QImage::Format_ARGB32_Premultiplied, Qt::AutoColor );

                            mask = original_mask.scaled( draw_image.width(), draw_image.height(), Qt::IgnoreAspectRatio, Qt::FastTransformation );
                            QImage wl_image_2 = mask.toImage();
                            wl_image_2 = wl_image_2.convertToFormat ( QImage::Format_ARGB32_Premultiplied, Qt::AutoColor );

                            QPainter g;

                            QPainter::CompositionMode mode = (QPainter::CompositionMode)6;

                            g.begin(&wl_image);
                            g.setCompositionMode ( mode );
                            g.drawImage(QRect(0,0,-1,-1),wl_image_2);
                            g.end();
                            draw_image = QPixmap::fromImage( wl_image, Qt::AutoColor );
                    }
            }
}

void menu::contextMenuEvent(QContextMenuEvent *event)
{
	if ( isovermask == 1 )
	{
		action_customize->setEnabled(true);
	}
	else
	{
		action_customize->setDisabled(true);
	}

	if ( quoilire.mid(0,3) != "!M!" && quoilire != "" )
	{
		action_charger_image_video->setEnabled(true);
		action_goto->setDisabled(true);
		action_quoifaire->setEnabled(true);
	}
	else
	{
		action_charger_image_video->setDisabled(true);
		
		if ( quoilire.mid(0,3) == "!M!" )
		{
			action_goto->setEnabled(true);
			action_quoifaire->setDisabled(true);
		}
		else
		{
			action_goto->setDisabled(true);
			action_quoifaire->setDisabled(true);
		}
	}

	if ( anim_thumb == 1 )
	{
		action_adjust->setEnabled(true);
	}
	else
	{
		action_adjust->setDisabled(true);
	}

	if ( islabel == 0 )
	{
		action_editoverlay->setEnabled(true);
		action_tobt->setDisabled(true);
	}
	else
	{
		action_editoverlay->setDisabled(true);
		action_tobt->setEnabled(true);
	}

	QMenu menu(this);
	menu.addAction(action_customize);
	menu.addSeparator();
	menu.addAction(action_charger_image);
	menu.addAction(action_charger_image_video);
	menu.addAction(action_adjust);
	menu.addAction(action_supprimer);
	menu.addSeparator();
	menu.addAction(action_tobt);
	menu.addSeparator();
	menu.addAction(action_envoi_premier);
	menu.addAction(action_envoi_dernier);
	menu.addSeparator();
	QMenu *menualign = menu.addMenu(QIcon(":/Interface/Interface/vruler.png"),tr("Alignement"));
	menualign->addAction(action_halign);
	menualign->addAction(action_valign);
	menualign->addSeparator();
	menualign->addAction(action_talign);

	if ( is_ruler == 0 )
	{
		menualign->setDisabled(true);
	}
	else
	{
		menualign->setEnabled(true);
	}

	menu.addSeparator();
	menu.addAction(action_copy);
	menu.addSeparator();
	menu.addAction(action_goto);
	menu.addSeparator();
	menu.addAction(action_quoifaire);
	menu.addAction(action_editoverlay);
	menu.exec(event->globalPos());
}

void menu::supprimer()
{
	emit delete_menu(this);
	this->close(); 
}

void menu::customize()
{
	emit customize_menu(this);
}

// ******************************************************
// *** CALCULS TRIGO POUR ROTATION ET TRANSFORMATIONS ***
// ******************************************************

float menu::getTeta(QPoint p, int radius) 
{
        if (p.x() > pos_cx && p.y() < pos_cy)
	{
                tetatemp = (float)acos(((float)p.x() - (float)pos_cx) / (float)radius);
	} 
        else
        {
                if (p.x() <= pos_cx && p.y() <= pos_cy)
                {
                        tetatemp = (float)((float)PI + (float)(asin(((float)p.y() - (float)pos_cy) / (float)radius)));
                }
                else
                {
                        if (p.x() < pos_cx && p.y() > pos_cy )
                        {
                                tetatemp = (float)((float)PI + (float)(acos(((float)-p.x() + (float)pos_cx) / (float)radius)));
                        }
                        else
                        {
                                tetatemp = (float)((float)(asin(((float)pos_cy - (float)p.y()) / (float)radius))+2.0*PI);
                        }
                }
        }

        return tetatemp;
}

float menu::getDist(QPoint p3, QPoint p2)
{
	double px = p3.x() - p2.x();
	double py = p3.y() - p2.y();
        return sqrt(px * px + py * py);
}

// ***************************************
// *** DEFINIR LE MEDIA POUR LE BOUTON ***
// ***************************************
void menu::dragEnterEvent(QDragEnterEvent *event)
{
    QList<QUrl> myurl = event->mimeData()->urls();
    wg_str_001 = myurl[0].toString(QUrl::None);
    if ( wg_str_001.mid(0,4) == "$ANI" )
    {
        //this->setCursor(Qt::ForbiddenCursor);
        return;
    }
    event->acceptProposedAction();
}

void menu::dropEvent(QDropEvent *event)
{
        QList<QUrl> myurl = event->mimeData()->urls();
        wg_str_001 = myurl[0].toString(QUrl::None);

        emit drop_to_a_menu(this);
}

// *******************************
// *** DESSIN DU MENU (BOUTON) ***
// *******************************

void menu::paintEvent(QPaintEvent *)
{
        QPainter p;
        p.begin(this);
        //p.setRenderHint(QPainter::Antialiasing,true);

        //QPainter p(this);
        //On positionne le centre de l'image (dans ce cas, on choisi le centre du widget)
        p.translate(this->width()/2,this->height()/2);
        //On applique la rotation
        p.rotate(rotation);
        p.shear(qreal(shear_value_y)/100,qreal(shear_value_x)/100);
        //Translation de l'image pour faire correspondre le centre
        //(puisque le painter prend en coordonnées le coin supérieur gauche de l'image)
        p.translate(-draw_image.width()/2,-draw_image.height()/2);
        //On dessine l'image
        //(en 0,0, puisque les translations ont placé le repère de coordonnées au bon endroit)
        p.drawPixmap(0,0,draw_image);

        if ( is_select == 1 )
	{
		p.resetMatrix();
		QPen pen;
		pen.setStyle(Qt::DotLine);
		pen.setCapStyle(Qt::RoundCap);
		pen.setJoinStyle(Qt::RoundJoin);
		p.setPen(pen);
		p.drawRect(0,0,this->width()-1,this->height()-1);
                p.drawPixmap(0,0,QPixmap(":/Interface/Interface/select4.png"));
	}
	else
	{
		if ( iscontours == 1 )
		{
			p.resetMatrix();
			p.setPen(QColor(0,0,0,200));
			p.drawRect(0,0,this->width()-1,this->height()-1);
			QPen pen;
			pen.setStyle(Qt::DotLine);
			pen.setCapStyle(Qt::RoundCap);
			pen.setJoinStyle(Qt::RoundJoin);
			pen.setColor(QColor(255,0,0));
			p.setPen(pen);
			p.drawRect(0,0,this->width()-1,this->height()-1);
		}
	}
	p.end();
}

