/* ============================================================
 * File  : preview_effect.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "preview_effect.h"

preview_effect::preview_effect ( QWidget * parent )
    : QLabel(parent)
{
    this->setAttribute(Qt::WA_DeleteOnClose);
    this->setMouseTracking(true);
    is_active = 0;
    x = 0;
}

void preview_effect::mouseMoveEvent ( QMouseEvent * event )
{
    x = event->x();
    this->repaint();
}

void preview_effect::enterEvent ( QEvent * )
{
    is_active = 1;
    this->repaint();
}

void preview_effect::leaveEvent ( QEvent * )
{
    is_active = 0;
    this->repaint();
}

// ********************************
// *** DESSIN DU FOND DU WIDGET ***
// ********************************

void preview_effect::paintEvent(QPaintEvent *)
{
    QPainter p;
    p.begin(this);
    p.drawPixmap(0,0,-1,-1,wl_pix_mod);

    if ( x > 0 && x < this->width() && is_active == 1 && as_effect == 1 )
    {
        p.drawPixmap(0,0,wl_pix_ori,0,0,x,-1);
        QPen mypen;
        mypen.setWidth(2);
        mypen.setColor(QColor(255,255,255));
        mypen.setStyle(Qt::DashLine);
        p.setPen(mypen);
        p.drawLine(x,0,x,this->height());

        mypen.setStyle(Qt::NoPen);
        p.setPen(mypen);

        p.setBrush(QColor(0,0,0,150));
        p.setPen(QColor(255,255,255));

        p.drawRect(x-80,15,70,20);
        p.drawRect(x+10,15,70,20);
        p.drawText(x-80,15,70,20,Qt::AlignCenter,tr("Original"));
        p.drawText(x+10,15,70,20,Qt::AlignCenter,tr("Modifiée"));
    }

    p.end();
}

